---
title: Version 22.12 (LTS)
---

# Version 22.12 (LTS)

.. toc::

## Introduction

This is the final release of the version 22 [release cycle](../../organization/policies.md#release-schedule). As such it is a **long-term support** release, and will be supported as stated in the [policies](../../org/policies.md#long-term-support-v-interim-releases).

## What to know

More details in the [Changelog](https://sanic.readthedocs.io/en/stable/sanic/changelog.html). Notable new or breaking features, and what to upgrade...

### 🚨 *BREAKING CHANGE* - Sanic Inspector is now an HTTP server

Sanic v22.9 introduced the [Inspector](./v22.9.md#inspector) to allow live inspection of a running Sanic instance. This feature relied upon opening a TCP socket and communicating over a custom protocol. That basic TCP protocol has been dropped in favor of running a full HTTP service in its place. [Learn more about the Inspector](../deployment/inspector.md).

The current release introduces a new HTTP server and a refreshed CLI experience. This enables several new features highlighted here. Perhaps the most significant change, however, is to move all of the Inspector's commands to a subparser on the CLI instance.

```
$ sanic inspect --help                             

  ▄███ █████ ██      ▄█▄      ██       █   █   ▄██████████
 ██                 █   █     █ ██     █   █  ██
  ▀███████ ███▄    ▀     █    █   ██   ▄   █  ██
              ██  █████████   █     ██ █   █  ▄▄
 ████ ████████▀  █         █  █       ██   █   ▀██ ███████

Optional
========
  General:
    -h, --help                      show this help message and exit
    --host HOST, -H HOST            Inspector host address [default 127.0.0.1]
    --port PORT, -p PORT            Inspector port [default 6457]
    --secure, -s                    Whether to access the Inspector via TLS encryption
    --api-key API_KEY, -k API_KEY   Inspector authentication key
    --raw                           Whether to output the raw response information

  Subcommands:
    Run one or none of the below subcommands. Using inspect without a subcommand will fetch general information about the state of the application instance.
    
    Or, you can optionally follow inspect with a subcommand. If you have created a custom Inspector instance, then you can run custom commands. See https://sanic.dev/en/guide/deployment/inspector.html for more details.

    {reload,shutdown,scale,<custom>}
        reload                      Trigger a reload of the server workers
        shutdown                    Shutdown the application and all processes
        scale                       Scale the number of workers
        <custom>                    Run a custom command
```

#### CLI remote access now available

The `host` and `port` of the Inspector are now explicitly exposed on the CLI as shown above. Previously in v22.9, they were inferred by reference to the application instance. Because of this change, it will be more possible to expose the Inspector on live production instances and access from a remote installation of the CLI. 

For example, you can check your running production deployment from your local development machine.

```
$ sanic inspect --host=1.2.3.4
```


.. warning:: 

    For **production** instances, make sure you are _using TLS and authentication_ described below.

#### TLS encryption now available

You can secure your remote Inspector access by providing a TLS certificate to encrypt the web traffic.

```python
app.config.INSPECTOR_TLS_CERT = "/path/to/cert.pem"
app.config.INSPECTOR_TLS_KEY = "/path/to/key.pem"
```

To access an encrypted installation via the CLI, use the `--secure` flag.

```
$ sanic inspect --secure
```

#### Authentication now available

To control access to the remote Inspector, you can protect the endpoints using an API key.

```python
app.config.INSPECTOR_API_KEY = "Super-Secret-200"
```

To access a protected installation via the CLI, use the `--api-key` flag.

```
$ sanic inspect --api-key=Super-Secret-200
```

This is equivalent to the header: `Authorization: Bearer <KEY>`.

```
$ curl http://localhost:6457  -H "Authorization: Bearer Super-Secret-200"
```

### Scale number of running server workers

The Inspector is now capable of scaling the number of worker processes. For example, to scale to 3 replicas, use the following command:

```
$ sanic inspect scale 3
```

### Extend Inspector with custom commands

The Inspector is now fully extendable to allow for adding custom commands to the CLI. For more information see [Custom Commands](../deployment/inspector.md#custom-commands).

```
$ sanic inspect foo --bar
```

### Early worker exit on failure

The process manager shipped with v22.9 had a very short startup timeout. This was to protect against deadlock. This was increased to 30s, and a new mechanism has been added to fail early if there is a crash in a worker process on startup.

### Introduce `JSONResponse` with convenience methods to update a JSON response body

The `sanic.response.json` convenience method now returns a new subclass of `HTTPResponse` appropriately named: `JSONResponse`. This new type has some convenient methods for handling changes to a response body after its creation.

```python
resp = json({"foo": "bar"})
resp.update({"another": "value"})
```

See [Returning JSON Data](../basics/response.md#returning-json-data) for more information.

### Updates to downstream requirements: `uvloop` and `websockets`

Minimum `uvloop` was set to `0.15.0`. Changes were added to make Sanic compliant with `websockets` version `11.0`.

### Force exit on 2nd `ctrl+c`

On supporting operating systems, the existing behavior is for Sanic server to try to perform a graceful shutdown when hitting `ctrl+c`. This new release will perform an immediate shutdown on subsequent `ctrl+c` after the initial shutdown has begun.

### Deprecations and Removals

1. *DEPRECATED* - The `--inspect*` commands introduced in v22.9 have been replaced with a new subcommand parser available as `inspect`. The flag versions will continue to operate until v23.3. You are encouraged to use the replacements. While this short deprecation period is a deviation from the standard two-cycles, we hope this change will be minimally disruptive.
    ```
    OLD   sanic ... --inspect
    NEW   sanic ... inspect
    
    OLD   sanic ... --inspect-raw
    NEW   sanic ... inspect --raw
    
    OLD   sanic ... --inspect-reload
    NEW   sanic ... inspect reload
    
    OLD   sanic ... --inspect-shutdown
    NEW   sanic ... inspect shutdown
    ```

## News

The Sanic Community Organization will be headed by a new Steering Council for 2023. There are two returning and two new members. 

[@ahopkins](https://github.com/ahopkins)  *returning* \
[@prryplatypus](https://github.com/prryplatypus)  *returning* \
[@sjsadowski](https://github.com/sjsadowski)  *NEW* \
[@Tronic](https://github.com/Tronic)  *NEW*

The 2023 release managers are [@ahopkins](https://github.com/ahopkins) and [@sjsadowski](https://github.com/sjsadowski).

If you are interested in getting more involved with Sanic, contact us on the [Discord server](https://discord.gg/FARQzAEMAA).

## Thank you

Thank you to everyone that participated in this release: :clap:

[@aaugustin](https://github.com/aaugustin)
[@ahopkins](https://github.com/ahopkins)
[@ChihweiLHBird](https://github.com/ChihweiLHBird)
[@kijk2869](https://github.com/kijk2869)
[@LiraNuna](https://github.com/LiraNuna)
[@prryplatypus](https://github.com/prryplatypus)
[@sjsadowski](https://github.com/sjsadowski)
[@todddialpad](https://github.com/todddialpad)
[@Tronic](https://github.com/Tronic)

---

If you enjoy the project, please consider contributing. Of course we love code contributions, but we also love contributions in any form. Consider writing some documentation, showing off use cases, joining conversations and making your voice known, and if you are able: [financial contributions](https://opencollective.com/sanic-org/).
