---
title: Version 22.6
---

# Version 22.6

.. toc::

## Introduction

This is the second release of the version 22 [release cycle](../../organization/policies.md#release-schedule). Version 22 will be "finalized" in the December long-term support version release. 

## What to know

More details in the [Changelog](https://sanic.readthedocs.io/en/stable/sanic/changelog.html). Notable new or breaking features, and what to upgrade...

### Automatic TLS setup in `DEBUG` mode

The Sanic server can automatically setup a TLS certificate using either [mkcert](https://github.com/FiloSottile/mkcert) or [trustme](https://github.com/python-trio/trustme). This certificate will enable `https://localhost` (or another local address) for local development environments. You must install either `mkcert` or `trustme` on your own for this to work.

.. column::

    ```
    $ sanic path.to.server:app --auto-tls --debug
    ```

.. column::

    ```python
    app.run(debug=True, auto_tls=True)
    ```

This feature is not available when running in `ASGI` mode, or in `PRODUCTION` mode. When running Sanic in production, you should be using a real TLS certificate either purchased through a legitimate vendor, or using [Let's Encrypt](https://letsencrypt.org/).

### HTTP/3 Server 🚀

In June 2022, the IETF finalized and published [RFC 9114](https://www.rfc-editor.org/rfc/rfc9114.html), the specification for HTTP/3. In short, HTTP/3 is a **very** different protocol than HTTP/1.1 and HTTP/2 because it implements HTTP over UDP instead of TCP. The new HTTP protocol promises faster webpage load times and solving some of the problems of the older standards. You are encouraged to [read more about](https://http3-explained.haxx.se/) this new web technology. You likely will need to install a [capable client](https://curl.se/docs/http3.html) as traditional tooling will not work.

Sanic server offers HTTP/3 support using [aioquic](https://github.com/aiortc/aioquic). This **must** be installed:

```
pip install sanic aioquic
```

```
pip install sanic[http3]
```

To start HTTP/3, you must explicitly request it when running your application.

.. column::

    ```
    $ sanic path.to.server:app --http=3
    ```

    ```
    $ sanic path.to.server:app -3
    ```

.. column::

    ```python
    app.run(version=3)
    ```

To run both an HTTP/3 and HTTP/1.1 server simultaneously, you can use [application multi-serve](./v22.3.html#application-multi-serve) introduced in v22.3.


.. column::

    ```
    $ sanic path.to.server:app --http=3 --http=1
    ```

    ```
    $ sanic path.to.server:app -3 -1
    ```

.. column::

    ```python
    app.prepre(version=3)
    app.prepre(version=1)
    Sanic.serve()
    ```

Because HTTP/3 requires TLS, you cannot start a HTTP/3 server without a TLS certificate. You should [set it up yourself](../../guide/how-to/tls.md) or use `mkcert` if in `DEBUG` mode. Currently, automatic TLS setup for HTTP/3 is not compatible with `trustme`.

**👶 This feature is being released as an *EARLY RELEASE FEATURE*.** It is **not** yet fully compliant with the HTTP/3 specification, lacking some features like [websockets](https://websockets.spec.whatwg.org/), [webtransport](https://w3c.github.io/webtransport/), and [push responses](https://http3-explained.haxx.se/en/h3/h3-push). Instead the intent of this release is to bring the existing HTTP request/response cycle towards feature parity with HTTP/3. Over the next several releases, more HTTP/3 features will be added and the API for it finalized.

### Consistent exception naming

Some of the Sanic exceptions have been renamed to be more compliant with standard HTTP response names.

- `InvalidUsage` >> `BadRequest`
- `MethodNotSupported` >> `MethodNotAllowed`
- `ContentRangeError` >> `RangeNotSatisfiable`

All old names have been aliased and will remain backwards compatible.

### Current request getter

Similar to the API to access an application (`Sanic.get_app()`), there is a new method for retrieving the current request when outside of a request handler.

```python
from sanic import Request

Request.get_current()
```

### Improved API support for setting cache control headers

The `file` response helper has some added parameters to make it easier to handle setting of the [Cache-Control](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) header.

```python
file(
    ...,
    last_modified=...,
    max_age=...,
    no_store=...,
)
```

### Custom `loads` function

Just like Sanic supports globally setting a custom `dumps`, you can now set a global custom `loads`.

```python
from orjson import loads

app = Sanic("Test", loads=loads)
```

### Deprecations and Removals

1. *REMOVED* - Applications may no longer opt-out of the application registry
1. *REMOVED* - Custom exception handlers will no longer run after some part of an exception has been sent
1. *REMOVED* - Fallback error formats cannot be set on the `ErrorHandler` and must **only** be set in the `Config`
1. *REMOVED* - Setting a custom `LOGO` for startup is no longer allowed
1. *REMOVED* - The old `stream` response convenience method has been removed
1. *REMOVED* - `AsyncServer.init` is removed and no longer an alias of `AsyncServer.app.state.is_started`


## Thank you

Thank you to everyone that participated in this release: :clap:

[@ahopkins](https://github.com/ahopkins)
[@amitay87](https://github.com/amitay87 )
[@ashleysommer](https://github.com/ashleysommer)
[@azimovMichael](https://github.com/azimovMichael)
[@ChihweiLHBird](https://github.com/ChihweiLHBird)
[@kijk2869](https://github.com/kijk2869)
[@prryplatypus](https://github.com/prryplatypus)
[@SaidBySolo](https://github.com/SaidBySolo)
[@sjsadowski](https://github.com/sjsadowski)
[@timmo001](https://github.com/timmo001)
[@zozzz](https://github.com/zozzz)

---

If you enjoy the project, please consider contributing. Of course we love code contributions, but we also love contributions in any form. Consider writing some documentation, showing off use cases, joining conversations and making your voice known, and if you are able: [financial contributions](https://opencollective.com/sanic-org/).
