---
title: Version 24.12
---

# Version 24.12

.. toc::


## Introduction

This is the first release of the version 24 [release cycle](../../organization/policies.md#release-schedule).  The release cadence for v24 may be slightly altered from years past. Make sure to stay up to date in the Discord server for latest updates. If you run into any issues, please raise a concern on [GitHub](https://github.com/sanic-org/sanic/issues/new/choose).

## What to know

More details in the [Changelog](../changelog.html). Notable new or breaking features, and what to upgrade:

### 👶 _BETA_ Custom CLI commands

The `sanic` CLI utility now allows for custom commands to be invoked. Commands can be added using the decorator syntax below.

```python
@app.command
async def foo(one, two: str, three: str = "..."):
    logger.info(f"FOO {one=} {two=} {three=}")


@app.command
def bar():
    logger.info("BAR")


@app.command(name="qqq")
async def baz():
    logger.info("BAZ")
```

These are invoked using the `exec` command as follows.

```sh
sanic server:app exec <command> [--arg=value]
```

Any arguments in the function's signature will be added as arguments. For example:

```sh
sanic server:app exec command --one=1 --two=2 --three=3
```

.. warning::

    This is in **BETA** and the functionality is subject to change in upcoming versions.

### Add Python 3.13 support

We have added Python 3.13 to the supported versions.

### Remove Python 3.8 support

Python 3.8 reached end-of-life. Sanic is now dropping support for Python 3.8, and requires Python 3.9 or newer.

### Old response cookie accessors removed

Prior to v23, cookies on `Response` objects were set and accessed as dictionary objects. That was deprecated in v23.3 when the new [convenience methods](../2023/v23.3.html#more-convenient-methods-for-setting-and-deleting-cookies) were added. The old patterns have been removed.

## Thank you

Thank you to everyone that participated in this release: :clap:

[@ahopkins](https://github.com/ahopkins)
[@C5H12O5](https://github.com/C5H12O5)
[@ChihweiLHBird](https://github.com/ChihweiLHBird)
[@HyperKiko](https://github.com/HyperKiko)
[@imnotjames](https://github.com/imnotjames)
[@pygeek](https://github.com/pygeek)

---

If you enjoy the project, please consider contributing. Of course we love code contributions, but we also love contributions in any form. Consider writing some documentation, showing off use cases, joining conversations and making your voice known, and if you are able: [financial contributions](https://opencollective.com/sanic-org/).
