---
title: Version 24.6
---

# Version 24.6

.. toc::


## Introduction

This is the first release of the version 24 [release cycle](../../organization/policies.md#release-schedule).  The release cadence for v24 may be slightly altered from years past. Make sure to stay up to date in the Discord server for latest updates. If you run into any issues, please raise a concern on [GitHub](https://github.com/sanic-org/sanic/issues/new/choose).

## What to know

More details in the [Changelog](../changelog.html). Notable new or breaking features, and what to upgrade:

### Logging improvements

The default logging patterns have been cleaned up to make them much more developer-friendly when viewing from a terminal session. This includes the use of color and less verbose formatting.

Sanic will select between two slight variations depending upon whether your server is in DEBUG mode. You can always opt to remove colors by using:

```python
app.config.NO_COLOR = True
```

The color will automatically be stripped out from logs not in TTY terminal.

Sanic will switch between the DEBUG and PROD formatters automatically using `sanic.logging.formatter.AutoFormatter` and `sanic.logging.formatter.AutoAccessFormatter`. Of course, you can force one version or the other using the appropriately named formatters

#### In DEBUG mode

```python
sanic.logging.formatter.DebugFormatter
sanic.logging.formatter.DebugAccessFormatter
```

![](/assets/images/logging-dev.png)

#### In PROD mode


```python
sanic.logging.formatter.ProdFormatter
sanic.logging.formatter.ProdAccessFormatter
```

![](/assets/images/logging-prod.png)

#### Legacy

If you prefer the old-style of logging, these have been preserved for you as logging formatters: `sanic.logging.formatter.LegacyFormatter` and `sanic.logging.formatter.LegacyAccessFormatter`.

One way to implement these formatters:

```python
from sanic.log import LOGGING_CONFIG_DEFAULTS

LOGGING_CONFIG_DEFAULTS["formatters"] = {
    "generic": {
        "class": "sanic.logging.formatter.LegacyFormatter"
    },
    "access": {
        "class": "sanic.logging.formatter.LegacyAccessFormatter"
    },
}
```

#### New JSON formatter

There also is a new JSON log formatter that will output the logs in JSON format for integration with other third part logging platforms.


```python
from sanic.log import LOGGING_CONFIG_DEFAULTS

LOGGING_CONFIG_DEFAULTS["formatters"] = {
    "generic": {
        "class": "sanic.logging.formatter.JSONFormatter"
    },
    "access": {
        "class": "sanic.logging.formatter.JSONAccessFormatter"
    },
}
```

### Using Paths in unix sockets

When creating a unix socket for your server, you can now perform that by passing a `pathlib.Path` object instead of just a string-based path

### Custom route names

You can override the `generate_name` method on either a custom `Sanic` or a `Blueprint`. This will allow you to modify the route names at will.

```python
from sanic import Sanic, text,

class Custom(Sanic):
    def generate_name(self, *objects):
        existing = self._generate_name(*objects)
        return existing.upper()
        
app = Sanic("Foo")

@app.get("/")
async def handler(request):
    return text(request.name)  # FOO.HANDLER

    
return app
```

### 🚨 BREAKING CHANGES

1. `Request.cookies.getlist` always returns a `list`. This means when no cookie of `key` exists, it will be an empty `list` instead of `None`. Use `Request.cookies.getlist("something", None)` to retain existing behavior.


## Thank you

Thank you to everyone that participated in this release: :clap:

[@ahopkins](https://github.com/ahopkins)
[@ashleysommer](https://github.com/ashleysommer)
[@ChihweiLHBird](https://github.com/ChihweiLHBird)
[@DeJayDev](https://github.com/DeJayDev)
[@ekzhang](https://github.com/ekzhang)
[@Huy-Ngo](https://github.com/Huy-Ngo)
[@iAndriy](https://github.com/iAndriy)
[@jakkaz](https://github.com/jakkaz)
[@Nano112](https://github.com/Nano112)
[@prryplatypus](https://github.com/prryplatypus)
[@razodactyl](https://github.com/razodactyl)
[@Tronic](https://github.com/Tronic)
[@wieczorek1990](https://github.com/wieczorek1990)

---

If you enjoy the project, please consider contributing. Of course we love code contributions, but we also love contributions in any form. Consider writing some documentation, showing off use cases, joining conversations and making your voice known, and if you are able: [financial contributions](https://opencollective.com/sanic-org/).
