---
title: Version 25.3
---

# Version 25.3

.. toc::


## Introduction

This is the first release of the version 25 [release cycle](../../organization/policies.md#release-schedule).  The release cadence for v24 may be slightly altered from years past. Make sure to stay up to date in the Discord server for latest updates. If you run into any issues, please raise a concern on [GitHub](https://github.com/sanic-org/sanic/issues/new/choose).

## What to know

More details in the [Changelog](../changelog.html). Notable new or breaking features, and what to upgrade:

### REPL Context

In [v23.12](../2023/v23.12.md#-embetaem-welcome-to-the-sanic-interactive-console) we introduced the [Development REPL](/en/guide/running/development.html#development-repl). The goal was to allow you to enter into an enhanced Python REPL from inside your running Sanic application. One of its features is several built-ins to allow you to easily interact with your app and with Sanic.

You now can add your own custom objects to the REPL

```python
import os

def foo():
    """This docstring will show in the REPL"""
    
app.repl_ctx.foo = foo
app.repl_ctx.os = os
```

There is also a lower-level API that you can use if (for example) you want to control the help test displayed in the REPL for your objects:

```python
app.repl_ctx.add(foo)
app.repl_ctx.add(os, desc="Standard os module.")
```


## Thank you

Thank you to everyone that participated in this release: :clap:

[@ahopkins](https://github.com/ahopkins)
[@erhuabushuo](https://github.com/erhuabushuo)
[@eric-spitler](https://github.com/eric-spitler)
[@goodki-d](https://github.com/goodki-d)
[@SaidBySolo](https://github.com/SaidBySolo)


---

If you enjoy the project, please consider contributing. Of course we love code contributions, but we also love contributions in any form. Consider writing some documentation, showing off use cases, joining conversations and making your voice known, and if you are able: [financial contributions](https://opencollective.com/sanic-org/).
