testdata = {
    "py": [
        {
            "test_name": "simple_a",
            "directory": "simple_a",
            "expected_edges": [["simple_a::func_a", "simple_a::func_b"]],
            "expected_nodes": ["simple_a::func_a", "simple_a::func_b"]
        },
        {
            "test_name": "simple_b",
            "directory": "simple_b",
            "expected_edges": [
                ["simple_b::c.d", "simple_b::a"],
                ["simple_b::a", "simple_b::b"],
                ["simple_b::(global)", "simple_b::c.d"],
                ["simple_b::b", "simple_b::a"]],
            "expected_nodes": ["simple_b::c.d", "simple_b::a", "simple_b::b",
                               "simple_b::(global)"]
        },
        {
            "test_name": "simple_b --exclude-functions",
            "comment": "We don't have a function c so nothing should happen",
            "directory": "simple_b",
            "kwargs": {"exclude_functions": ["c"]},
            "expected_edges": [
                ["simple_b::c.d", "simple_b::a"],
                ["simple_b::a", "simple_b::b"],
                ["simple_b::(global)", "simple_b::c.d"],
                ["simple_b::b", "simple_b::a"]
            ],
            "expected_nodes": ["simple_b::c.d", "simple_b::a", "simple_b::b",
                               "simple_b::(global)"]
        },
        {
            "test_name": "simple_b --exclude-functions2",
            "comment": "Exclude all edges with function a",
            "directory": "simple_b",
            "kwargs": {"exclude_functions": ["a"]},
            "expected_edges": [
                ["simple_b::(global)", "simple_b::c.d"]
            ],
            "expected_nodes": ["simple_b::c.d", "simple_b::(global)"]
        },
        {
            "test_name": "simple_b --exclude-functions2 no_trimming",
            "comment": "Exclude all edges with function a. No trimming keeps nodes except a",
            "directory": "simple_b",
            "kwargs": {"exclude_functions": ["a"], "no_trimming": True},
            "expected_edges": [
                ["simple_b::(global)", "simple_b::c.d"]
            ],
            "expected_nodes": ["simple_b::c.d", "simple_b::b", "simple_b::(global)"]
        },
        {
            "test_name": "simple_b --exclude-functions2",
            "comment": "Exclude all edges with function d (d is in a class)",
            "directory": "simple_b",
            "kwargs": {"exclude_functions": ["d"]},
            "expected_edges": [
                ["simple_b::a", "simple_b::b"],
                ["simple_b::b", "simple_b::a"]
            ],
            "expected_nodes": ["simple_b::a", "simple_b::b"]
        },
        {
            "test_name": "simple_b --exclude-namespaces",
            "comment": "Exclude the file itself",
            "directory": "simple_b",
            "kwargs": {"exclude_namespaces": ["simple_b"]},
            "expected_edges": [],
            "expected_nodes": []
        },
        {
            "test_name": "simple_b --exclude-namespaces 2",
            "comment": "Exclude a class in the file",
            "directory": "simple_b",
            "kwargs": {"exclude_namespaces": ["c"]},
            "expected_edges": [
                ["simple_b::a", "simple_b::b"],
                ["simple_b::b", "simple_b::a"]
            ],
            "expected_nodes": ["simple_b::a", "simple_b::b"]
        },

        {
            "test_name": "simple_b --include-only-functions",
            "comment": "Include one a and b",
            "directory": "simple_b",
            "kwargs": {"include_only_functions": ["a", "b"]},
            "expected_edges": [
                ["simple_b::a", "simple_b::b"],
                ["simple_b::b", "simple_b::a"]
            ],
            "expected_nodes": ["simple_b::a", "simple_b::b"]
        },
        {
            "test_name": "pytz --include-only-functions",
            "comment": "Include only two functions",
            "directory": "pytz",
            "kwargs": {"include_only_functions": ["_fill", "open_resource"]},
            "expected_edges": [
                ["__init__::_CountryTimezoneDict._fill", "__init__::open_resource"],
                ["__init__::_CountryNameDict._fill", "__init__::open_resource"]
            ],
            "expected_nodes": ["__init__::_CountryTimezoneDict._fill", "__init__::_CountryNameDict._fill", "__init__::open_resource"]
        },

        {
            "test_name": "--include-only-namespaces=reference",
            "directory": "pytz",
            "kwargs":{"include_only_namespaces": ["reference"]},
            "expected_edges": [["reference::USTimeZone.utcoffset",
                                "reference::USTimeZone.dst"],
                               ["reference::LocalTimezone.utcoffset",
                                "reference::LocalTimezone._isdst"],
                               ["reference::(global)", "reference::USTimeZone.__init__"],
                               ["reference::USTimeZone.tzname",
                                "reference::USTimeZone.dst"],
                               ["reference::LocalTimezone.dst",
                                "reference::LocalTimezone._isdst"],
                               ["reference::LocalTimezone.tzname",
                                "reference::LocalTimezone._isdst"],
                               ["reference::USTimeZone.dst",
                                "reference::first_sunday_on_or_after"]],
            "expected_nodes": ["reference::USTimeZone.utcoffset",
                               "reference::LocalTimezone.dst",
                               "reference::LocalTimezone.tzname",
                               "reference::USTimeZone.__init__",
                               "reference::USTimeZone.tzname",
                               "reference::USTimeZone.dst",
                               "reference::(global)",
                               "reference::LocalTimezone._isdst",
                               "reference::LocalTimezone.utcoffset",
                               "reference::first_sunday_on_or_after"]
        },


        {
            "test_name": "--include-only-namespaces=USTimeZone",
            "directory": "pytz",
            "kwargs":{"include_only_namespaces": ["USTimeZone"]},
            "expected_edges": [["reference::USTimeZone.utcoffset",
                                "reference::USTimeZone.dst"],
                               ["reference::USTimeZone.tzname",
                                "reference::USTimeZone.dst"]],
            "expected_nodes": ["reference::USTimeZone.dst",
                               "reference::USTimeZone.utcoffset",
                               "reference::USTimeZone.tzname"]
        },
        {
            "test_name": "include_exclude_namespaces",
            "comment": "Complex including/excluding namespaces",
            "directory": "pytz",
            "kwargs": {"include_only_namespaces": ["tzfile","tzinfo"],
                       "exclude_namespaces": ["DstTzInfo"]},
            "expected_edges": [["tzinfo::(global)", "tzinfo::memorized_timedelta"],
                               ["tzfile::build_tzinfo", "tzfile::_std_string"],
                               ["tzfile::(global)", "tzfile::build_tzinfo"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_ttinfo"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_timedelta"],
                               ["tzfile::(global)", "tzfile::_byte_string"],
                               ["tzinfo::unpickler", "tzinfo::memorized_timedelta"],
                               ["tzfile::build_tzinfo", "tzfile::_byte_string"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_datetime"],
                               ["tzinfo::memorized_ttinfo",
                                "tzinfo::memorized_timedelta"]],
            "expected_nodes": ["tzinfo::unpickler",
                               "tzfile::build_tzinfo",
                               "tzinfo::(global)",
                               "tzfile::_std_string",
                               "tzinfo::memorized_timedelta",
                               "tzfile::(global)",
                               "tzinfo::memorized_datetime",
                               "tzfile::_byte_string",
                               "tzinfo::memorized_ttinfo"]
        },
        {
            "test_name": "include_exclude_namespaces_exclude_functions",
            "comment": "Very complex including/excluding namespaces and excluding functions",
            "directory": "pytz",
            "kwargs": {"include_only_namespaces": ["tzfile","tzinfo"],
                       "exclude_namespaces": ["DstTzInfo"],
                       "exclude_functions": ["(global)"]},
            "expected_edges": [["tzfile::build_tzinfo", "tzinfo::memorized_ttinfo"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_timedelta"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_datetime"],
                               ["tzinfo::memorized_ttinfo", "tzinfo::memorized_timedelta"],
                               ["tzfile::build_tzinfo", "tzfile::_std_string"],
                               ["tzfile::build_tzinfo", "tzfile::_byte_string"],
                               ["tzinfo::unpickler", "tzinfo::memorized_timedelta"]],
            "expected_nodes": ["tzinfo::unpickler",
                               "tzinfo::memorized_datetime",
                               "tzinfo::memorized_ttinfo",
                               "tzfile::build_tzinfo",
                               "tzfile::_std_string",
                               "tzinfo::memorized_timedelta",
                               "tzfile::_byte_string"]
        },
        {
            "test_name": "simple_b --exclude-namespaces not found",
            "comment": "Exclude something not there",
            "directory": "simple_b",
            "kwargs": {"exclude_namespaces": ["notreal"]},
            "expected_edges": [
                ["simple_b::c.d", "simple_b::a"],
                ["simple_b::a", "simple_b::b"],
                ["simple_b::(global)", "simple_b::c.d"],
                ["simple_b::b", "simple_b::a"]
            ],
            "expected_nodes": ["simple_b::c.d", "simple_b::a", "simple_b::b",
                               "simple_b::(global)"]
        },
        {
            "test_name": "two_file_simple",
            "directory": "two_file_simple",
            "expected_edges": [["file_a::(global)", "file_a::a"],
                               ["file_a::a", "file_b::b"]],
            "expected_nodes": ["file_a::(global)", "file_a::a", "file_b::b"]
        },
        {
            "test_name": "two_file_simple --exclude_functions",
            "comment": "Function a is in both files so should be removed from both",
            "directory": "two_file_simple",
            "kwargs": {"exclude_functions": ["a"]},
            "expected_edges": [],
            "expected_nodes": []
        },
        {
            "test_name": "two_file_simple --exclude_functions no-trim",
            "comment": "Function a is in both files but don't trim so leave file_b nodes",
            "directory": "two_file_simple",
            "kwargs": {"exclude_functions": ["a"], "no_trimming": True},
            "expected_edges": [],
            "expected_nodes": ["file_a::(global)", "file_b::(global)", "file_b::b", "file_b::c"]
        },
        {
            "test_name": "two_file_simple --exclude_namespaces no-trim",
            "comment": "Trim one file and leave the other intact",
            "directory": "two_file_simple",
            "kwargs": {"exclude_namespaces": ["file_a"], "no_trimming": True},
            "expected_edges": [],
            "expected_nodes": ["file_b::(global)", "file_b::b", "file_b::c"]
        },
        {
            "test_name": "async_basic",
            "directory": "async_basic",
            "kwargs": {},
            "expected_edges": [["async_basic::main", "async_basic::A.__init__"],
                               ["async_basic::(global)", "async_basic::main"],
                               ["async_basic::main", "async_basic::A.test"]],
            "expected_nodes": ["async_basic::(global)",
                               "async_basic::A.__init__",
                               "async_basic::A.test",
                               "async_basic::main"]
        },
        {
            "test_name": "exclude_modules",
            "comment": "Correct name resolution when third-party modules are involved",
            "directory": "exclude_modules",
            "kwargs": {},
            "expected_edges": [["exclude_modules::(global)", "exclude_modules::alpha"],
                               ["exclude_modules::alpha", "exclude_modules::beta"],
                               ["exclude_modules::beta", "exclude_modules::search"]],
            "expected_nodes": ["exclude_modules::(global)", "exclude_modules::alpha",
                               "exclude_modules::beta", "exclude_modules::search"]
        },
        {
            "test_name": "exclude_modules_two_files",
            "comment": "Correct name resolution when third-party modules are involved with two files",
            "directory": "exclude_modules_two_files",
            "expected_edges": [["exclude_modules_a::b", "exclude_modules_b::match"],
                               ["exclude_modules_a::(global)", "exclude_modules_a::b"],
                               ["exclude_modules_a::(global)", "exclude_modules_a::a"]],
            "expected_nodes": ["exclude_modules_a::a",
                               "exclude_modules_a::b",
                               "exclude_modules_b::match",
                               "exclude_modules_a::(global)"]
        },
        {
            "test_name": "resolve_correct_class",
            "comment": "Correct name resolution with multiple classes",
            "directory": "resolve_correct_class",
            "kwargs": {},
            "expected_edges": [["rcc::Alpha.func_1", "rcc::Alpha.func_1"],
                               ["rcc::Alpha.func_1", "rcc::func_1"],
                               ["rcc::Alpha.func_1", "rcc::Beta.func_2"],
                               ["rcc::Beta.func_1", "rcc::Alpha.func_2"],
                               ],
            "expected_nodes": ["rcc::Alpha.func_1", "rcc::Alpha.func_2",
                               "rcc::func_1", "rcc::Beta.func_2",
                               "rcc::Beta.func_1"]
        },
        {
            "test_name": "ambibuous resolution",
            "comment": "If we can't resolve, do not inlude node.",
            "directory": "ambiguous_resolution",
            "expected_edges": [["ambiguous_resolution::(global)",
                                "ambiguous_resolution::main"],
                               ["ambiguous_resolution::main",
                                "ambiguous_resolution::Cadabra.cadabra_it"],
                               ["ambiguous_resolution::Cadabra.cadabra_it",
                                "ambiguous_resolution::Abra.abra_it"]],
            "expected_nodes": ["ambiguous_resolution::(global)",
                               "ambiguous_resolution::main",
                               "ambiguous_resolution::Cadabra.cadabra_it",
                               "ambiguous_resolution::Abra.abra_it"]
        },
        {
            "test_name": "weird_imports",
            "directory": "weird_imports",
            "expected_edges": [["weird_imports::(global)", "weird_imports::main"]],
            "expected_nodes": ["weird_imports::main", "weird_imports::(global)"]
        },
        {
            "test_name": "nested classes",
            "directory": "nested_class",
            "expected_edges": [["nested_class::(global)",
                                "nested_class::Outer.outer_func"],
                               ["nested_class::(global)", "nested_class::Outer.__init__"]],
            "expected_nodes": ["nested_class::Outer.outer_func",
                               "nested_class::Outer.__init__",
                               "nested_class::(global)"]
        },
        {
            "test_name": "init",
            "comment": "working with constructors",
            "directory": "init",
            "expected_edges": [["init::Abra.__init__", "init::Abra.cadabra"],
                               ["init::(global)", "the_import::imported_func"],
                               ["init::(global)", "init::b"],
                               ["init::b", "init::Abra.__init__"],
                               ["init::(global)", "the_import::HiddenClass.__init__"],
                               ["init::(global)", "the_import::ProvincialClass.__init__"]],
            "expected_nodes": ["init::(global)",
                               "the_import::ProvincialClass.__init__",
                               "init::Abra.__init__",
                               "init::Abra.cadabra",
                               "the_import::HiddenClass.__init__",
                               "the_import::imported_func",
                               "init::b"]
        },
        {
            "test_name": "weird_calls",
            "directory": "weird_calls",
            "comment": "Subscript calls",
            "expected_edges": [["weird_calls::func_c", "weird_calls::print_it"],
                               ["weird_calls::func_b", "weird_calls::print_it"],
                               ["weird_calls::(global)", "weird_calls::func_b"],
                               ["weird_calls::func_a", "weird_calls::print_it"],
                               ["weird_calls::(global)", "weird_calls::factory"]],
            "expected_nodes": ["weird_calls::func_b",
                               "weird_calls::print_it",
                               "weird_calls::(global)",
                               "weird_calls::func_c",
                               "weird_calls::func_a",
                               "weird_calls::factory"]
        },
        {
            "test_name": "chained",
            "directory": "chained",
            "expected_edges": [["chained::(global)", "chained::Chain.sub"],
                               ["chained::(global)", "chained::Chain.__init__"],
                               ["chained::(global)", "chained::Chain.add"],
                               ["chained::(global)", "chained::Chain.mul"]],
            "expected_nodes": ["chained::Chain.__init__",
                               "chained::(global)",
                               "chained::Chain.sub",
                               "chained::Chain.add",
                               "chained::Chain.mul"]
        },
        {
            "test_name": "inherits",
            "directory": "inherits",
            "expected_edges": [["inherits::(global)", "inherits::ScaleDemo.__init__"],
                               ["inherits::ScaleDemoLimited.__init__",
                                "inherits_import::MajorScales.majorNum"],
                               ["inherits::ScaleDemo.__init__",
                                "inherits_import::MajorScales.majorNum"],
                               ["inherits::(global)", "inherits::majorNum"],
                               ["inherits::ScaleDemo.__init__",
                                "inherits_import::PentatonicScales.pentaNum"]],
            "expected_nodes": ["inherits_import::MajorScales.majorNum",
                               "inherits::(global)",
                               "inherits::ScaleDemoLimited.__init__",
                               "inherits_import::PentatonicScales.pentaNum",
                               "inherits::majorNum",
                               "inherits::ScaleDemo.__init__"]
        },
        {
            "test_name": "import_paths",
            "directory": "import_paths",
            "comment": "relative and absolute imports",
            "expected_edges": [["import_paths::main", "abra::abra2"],
                               ["import_paths::main", "cadabra::cadabra2"],
                               ["import_paths::main2", "abra::abra2"],
                               ["import_paths::main", "import_paths::main2"],
                               ["import_paths::(global)", "import_paths::main"]],
            "expected_nodes": ["abra::abra2",
                               "import_paths::main2",
                               "import_paths::main",
                               "cadabra::cadabra2",
                               "import_paths::(global)"]
        },
        {
            "test_name": "nested_calls",
            "directory": "nested_calls",
            "comment": "Something like func(a)(b)",
            "expected_edges": [["nested_calls::(global)", "nested_calls::trace"]],
            "expected_nodes": ["nested_calls::trace", "nested_calls::(global)"]
        },
        {
            "test_name": "pytz",
            "directory": "pytz",
            "kwargs": {"exclude_namespaces": ["test_tzinfo"]},
            "expected_edges": [["tzinfo::(global)", "tzinfo::memorized_timedelta"],
                               ["tzfile::(global)", "tzfile::_byte_string"],
                               ["__init__::timezone", "tzfile::build_tzinfo"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_datetime"],
                               ["__init__::timezone",
                                "__init__::_case_insensitive_zone_lookup"],
                               ["tzinfo::DstTzInfo.utcoffset",
                                "tzinfo::DstTzInfo.localize"],
                               ["tzinfo::memorized_ttinfo", "tzinfo::memorized_timedelta"],
                               ["reference::USTimeZone.tzname",
                                "reference::USTimeZone.dst"],
                               ["tzfile::build_tzinfo", "tzfile::_std_string"],
                               ["__init__::_CountryTimezoneDict._fill",
                                "__init__::open_resource"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_timedelta"],
                               ["tzinfo::DstTzInfo.dst", "tzinfo::DstTzInfo.localize"],
                               ["reference::LocalTimezone.tzname",
                                "reference::LocalTimezone._isdst"],
                               ["reference::LocalTimezone.utcoffset",
                                "reference::LocalTimezone._isdst"],
                               ["__init__::(global)", "__init__::_test"],
                               ["tzinfo::DstTzInfo.__reduce__", "tzinfo::_to_seconds"],
                               ["__init__::_p", "tzinfo::unpickler"],
                               ["reference::USTimeZone.utcoffset",
                                "reference::USTimeZone.dst"],
                               ["__init__::_CountryNameDict._fill",
                                "__init__::open_resource"],
                               ["reference::(global)", "reference::USTimeZone.__init__"],
                               ["__init__::timezone", "__init__::open_resource"],
                               ["__init__::timezone", "__init__::_unmunge_zone"],
                               ["__init__::timezone", "__init__::ascii"],
                               ["__init__::UTC.fromutc", "__init__::UTC.localize"],
                               ["lazy::LazyList.__new__", "lazy::LazyList.__new__"],
                               ["lazy::LazySet.__new__", "lazy::LazySet.__new__"],
                               ["tzinfo::DstTzInfo.tzname", "tzinfo::DstTzInfo.localize"],
                               ["tzfile::(global)", "tzfile::build_tzinfo"],
                               ["tzinfo::DstTzInfo.localize",
                                "tzinfo::DstTzInfo.localize"],
                               ["reference::USTimeZone.dst",
                                "reference::first_sunday_on_or_after"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_ttinfo"],
                               ["tzinfo::unpickler", "tzinfo::memorized_timedelta"],
                               ["tzinfo::DstTzInfo.normalize",
                                "tzinfo::DstTzInfo.fromutc"],
                               ["lazy::LazyDict.keys", "lazy::LazyDict.keys"],
                               ["__init__::resource_exists", "__init__::open_resource"],
                               ["tzfile::build_tzinfo", "tzfile::_byte_string"],
                               ["__init__::FixedOffset",
                                "__init__::_FixedOffset.__init__"],
                               ["reference::LocalTimezone.dst",
                                "reference::LocalTimezone._isdst"]],
            "expected_nodes": ["reference::USTimeZone.__init__",
                               "tzinfo::_to_seconds",
                               "__init__::_p",
                               "lazy::LazyDict.keys",
                               "tzinfo::memorized_ttinfo",
                               "lazy::LazySet.__new__",
                               "__init__::_CountryTimezoneDict._fill",
                               "__init__::FixedOffset",
                               "tzinfo::DstTzInfo.tzname",
                               "tzfile::build_tzinfo",
                               "lazy::LazyList.__new__",
                               "reference::first_sunday_on_or_after",
                               "tzinfo::DstTzInfo.__reduce__",
                               "tzfile::(global)",
                               "reference::LocalTimezone.dst",
                               "reference::USTimeZone.dst",
                               "__init__::timezone",
                               "reference::USTimeZone.tzname",
                               "tzinfo::DstTzInfo.dst",
                               "reference::USTimeZone.utcoffset",
                               "reference::LocalTimezone._isdst",
                               "tzfile::_std_string",
                               "__init__::open_resource",
                               "tzinfo::DstTzInfo.localize",
                               "__init__::_case_insensitive_zone_lookup",
                               "__init__::UTC.localize",
                               "reference::LocalTimezone.tzname",
                               "tzinfo::DstTzInfo.normalize",
                               "tzfile::_byte_string",
                               "__init__::UTC.fromutc",
                               "tzinfo::DstTzInfo.fromutc",
                               "__init__::_unmunge_zone",
                               "__init__::ascii",
                               "__init__::_FixedOffset.__init__",
                               "tzinfo::memorized_datetime",
                               "tzinfo::memorized_timedelta",
                               "__init__::_test",
                               "reference::(global)",
                               "tzinfo::DstTzInfo.utcoffset",
                               "reference::LocalTimezone.utcoffset",
                               "__init__::_CountryNameDict._fill",
                               "__init__::(global)",
                               "__init__::resource_exists",
                               "tzinfo::(global)",
                               "tzinfo::unpickler"]
        },
        {
            "test_name": "pytz_basic_upstream_downstream",
            "directory": "pytz",
            "kwargs": {"target_function": "build_tzinfo",
                       "upstream_depth": "1",
                       "downstream_depth": "1"},
            "expected_edges": [["__init__::timezone", "tzfile::build_tzinfo"],
                               ["tzfile::(global)", "tzfile::build_tzinfo"],
                               ["tzinfo::memorized_ttinfo", "tzinfo::memorized_timedelta"],
                               ["tzfile::build_tzinfo", "tzfile::_std_string"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_timedelta"],
                               ["tzfile::build_tzinfo", "tzfile::_byte_string"],
                               ["tzfile::(global)", "tzfile::_byte_string"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_ttinfo"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_datetime"]],
            "expected_nodes": ["__init__::timezone",
                               "tzfile::(global)",
                               "tzfile::_std_string",
                               "tzinfo::memorized_ttinfo",
                               "tzfile::_byte_string",
                               "tzinfo::memorized_datetime",
                               "tzfile::build_tzinfo",
                               "tzinfo::memorized_timedelta"]
        },
        {
            "test_name": "pytz_no_upstream_file_handle",
            "directory": "pytz",
            "kwargs": {"target_function": "tzfile::(global)",
                        "downstream_depth": "2"},
            "expected_edges": [["tzfile::(global)", "tzfile::build_tzinfo"],
                               ["tzfile::(global)", "tzfile::_byte_string"],
                               ["tzinfo::memorized_ttinfo", "tzinfo::memorized_timedelta"],
                               ["tzfile::build_tzinfo", "tzfile::_std_string"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_timedelta"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_ttinfo"],
                               ["tzfile::build_tzinfo", "tzinfo::memorized_datetime"],
                               ["tzfile::build_tzinfo", "tzfile::_byte_string"]],
            "expected_nodes": ["tzinfo::memorized_datetime",
                               "tzfile::_byte_string",
                               "tzinfo::memorized_ttinfo",
                               "tzfile::_std_string",
                               "tzfile::build_tzinfo",
                               "tzfile::(global)",
                               "tzinfo::memorized_timedelta"]
        },
    ],
    "js": [
        {
            "test_name": "simple_a_js",
            "directory": "simple_a_js",
            "expected_edges": [["simple_a::func_a", "simple_a::func_b"]],
            "expected_nodes": ["simple_a::func_a", "simple_a::func_b"]
        },
        {
            "test_name": "simple_b_js",
            "directory": "simple_b_js",
            "expected_edges": [
                ["simple_b::C.d", "simple_b::a"],
                ["simple_b::a", "simple_b::b"],
                ["simple_b::(global)", "simple_b::C.d"],
                ["simple_b::b", "simple_b::a"]],
            "expected_nodes": ["simple_b::C.d", "simple_b::a", "simple_b::b",
                               "simple_b::(global)"]
        },
        {
            "test_name": "two_file_simple",
            "directory": "two_file_simple",
            "expected_edges": [["file_a::(global)", "file_a::a"],
                               ["file_a::a", "file_b::b"]],
            "expected_nodes": ["file_a::(global)", "file_a::a", "file_b::b"]
        },
        {
            "test_name": "two_file_simple exclude entire file",
            "directory": "two_file_simple",
            "kwargs": {"exclude_namespaces": ["file_b", "file_c"]},
            "expected_edges": [["file_a::(global)", "file_a::a"]],
            "expected_nodes": ["file_a::(global)", "file_a::a"]
        },

        {
            "test_name": "exclude modules",
            "directory": "exclude_modules",
            "expected_edges": [["exclude_modules::(global)", "exclude_modules::alpha"],
                               ["exclude_modules::alpha", "exclude_modules::alpha"],
                               ["exclude_modules::alpha", "exclude_modules::beta"],
                               ["exclude_modules::beta", "exclude_modules::readFileSync"]],
            "expected_nodes": ["exclude_modules::alpha",
                               "exclude_modules::beta",
                               "exclude_modules::(global)",
                               "exclude_modules::readFileSync"]
        },
        {
            "test_name": "exclude modules exclude_functions no_trimming",
            "comment": "makes sense to test in js as well. Include a function that's not there for more coverage",
            "directory": "exclude_modules",
            "kwargs": {"exclude_functions": ["beta", "gamma"], "no_trimming": True},
            "expected_edges": [["exclude_modules::(global)", "exclude_modules::alpha"],
                               ["exclude_modules::alpha", "exclude_modules::alpha"]],
            "expected_nodes": ["exclude_modules::alpha",
                               "exclude_modules::(global)",
                               "exclude_modules::readFileSync"],
        },
        {
            "test_name": "exclude modules es6",
            "directory": "exclude_modules_es6",
            "kwargs": {'source_type': 'module'},
            "expected_edges": [["exclude_modules_es6::(global)", "exclude_modules_es6::alpha"],
                               ["exclude_modules_es6::alpha", "exclude_modules_es6::alpha"],
                               ["exclude_modules_es6::alpha", "exclude_modules_es6::beta"],
                               ["exclude_modules_es6::beta", "exclude_modules_es6::readFileSync"]],
            "expected_nodes": ["exclude_modules_es6::alpha",
                               "exclude_modules_es6::beta",
                               "exclude_modules_es6::(global)",
                               "exclude_modules_es6::readFileSync"]
        },
        {
            "test_name": "ambiguous_names",
            "directory": "ambiguous_names",
            "expected_edges": [["ambiguous_names::Cadabra.cadabra_it",
                                "ambiguous_names::Abra.abra_it"],
                               ["ambiguous_names::main",
                                "ambiguous_names::Cadabra.cadabra_it"],
                               ["ambiguous_names::(global)",
                                "ambiguous_names::main"],
                               ["ambiguous_names::Abra.(constructor)",
                                "ambiguous_names::Abra.abra_it"]],
            "expected_nodes": ["ambiguous_names::Cadabra.cadabra_it",
                               "ambiguous_names::main",
                               "ambiguous_names::(global)",
                               "ambiguous_names::Abra.abra_it",
                               "ambiguous_names::Abra.(constructor)"]
        },
        {
            "test_name": "ambiguous_names",
            "directory": "ambiguous_names",
            "kwargs": {"no_trimming": True},
            "expected_edges": [["ambiguous_names::Cadabra.cadabra_it",
                                "ambiguous_names::Abra.abra_it"],
                               ["ambiguous_names::main",
                                "ambiguous_names::Cadabra.cadabra_it"],
                               ["ambiguous_names::(global)",
                                "ambiguous_names::main"],
                               ["ambiguous_names::Abra.(constructor)",
                                "ambiguous_names::Abra.abra_it"]],
            "expected_nodes": ["ambiguous_names::Cadabra.cadabra_it",
                               "ambiguous_names::main",
                               "ambiguous_names::(global)",
                               "ambiguous_names::Abra.abra_it",
                               "ambiguous_names::Abra.(constructor)",
                               "ambiguous_names::Abra.magic",
                               "ambiguous_names::Cadabra.magic",
                               ]
        },
        {
            "test_name": "ambiguous_names exclude_namespaces",
            "directory": "ambiguous_names",
            "comment": "Also tests an important thing. .magic is in two classes in the first test. This eliminates a class and magic is resolved.",
            "kwargs": {"exclude_namespaces": ['Abra']},
            "expected_edges": [["ambiguous_names::main",
                                "ambiguous_names::Cadabra.cadabra_it"],
                               ["ambiguous_names::(global)",
                                "ambiguous_names::main"],
                               ["ambiguous_names::main",
                                "ambiguous_names::Cadabra.magic"]],
            "expected_nodes": ["ambiguous_names::Cadabra.cadabra_it",
                               "ambiguous_names::Cadabra.magic",
                               "ambiguous_names::main",
                               "ambiguous_names::(global)"]
        },
        {
            "test_name": "weird_assignments",
            "directory": "weird_assignments",
            "expected_edges": [["weird_assignments::(global)",
                                "weird_assignments::get_ab"]],
            "expected_nodes": ["weird_assignments::(global)", "weird_assignments::get_ab"]
        },
        {
            "test_name": "complex_ownership",
            "directory": "complex_ownership",
            "expected_edges": [["complex_ownership::(global)",
                                "complex_ownership::DEF.toABC"],
                               ["complex_ownership::DEF.toABC",
                                "complex_ownership::ABC.(constructor)"],
                               ["complex_ownership::(global)",
                                "complex_ownership::ABC.apply"],
                               ["complex_ownership::GHI.doit2",
                                "complex_ownership::ABC.apply"],
                               ["complex_ownership::(global)",
                                "complex_ownership::GHI.doit2"],
                               ["complex_ownership::(global)",
                                "complex_ownership::ABC.doit"],
                               ["complex_ownership::(global)",
                                "complex_ownership::GHI.doit3"]],
            "expected_nodes": ["complex_ownership::(global)",
                               "complex_ownership::ABC.apply",
                               "complex_ownership::ABC.doit",
                               "complex_ownership::ABC.(constructor)",
                               "complex_ownership::DEF.toABC",
                               "complex_ownership::GHI.doit2",
                               "complex_ownership::GHI.doit3"]
        },
        {
            "test_name": "two_file_imports",
            "directory": "two_file_imports",
            "expected_edges": [["importer::outer", "imported::myClass.(constructor)"],
                               ["importer::outer", "imported::inner"],
                               ["importer::(global)", "importer::outer"],
                               ["imported::myClass.(constructor)",
                                "imported::myClass.doit"],
                               ["imported::myClass.doit", "imported::myClass.doit2"]],
            "expected_nodes": ["imported::myClass.doit2",
                               "imported::myClass.(constructor)",
                               "imported::myClass.doit",
                               "imported::inner",
                               "importer::(global)",
                               "importer::outer"]
        },
        {
            "test_name": "globals",
            "comment": "ensure that nested functions behave correctly",
            "directory": "globals",
            "expected_edges": [["globals::a", "globals::b"],
                               ["globals::a", "globals::c"],
                               ["globals::c", "globals::d"]],
            "expected_nodes": ["globals::d", "globals::a", "globals::c", "globals::b"]
        },
        {
            "test_name": "scope confusion",
            "comment": "Be sure that 'this' is used correctly",
            "directory": "scoping",
            "expected_edges": [["scoping::(global)", "scoping::MyClass.a"],
                               ["scoping::MyClass.a", "scoping::MyClass.scope_confusion"],
                               ["scoping::(global)", "scoping::MyClass.b"],
                               ["scoping::MyClass.b", "scoping::scope_confusion"]],
            "expected_nodes": ["scoping::MyClass.scope_confusion",
                               "scoping::MyClass.b",
                               "scoping::scope_confusion",
                               "scoping::MyClass.a",
                               "scoping::(global)"]
        },
        {
            "test_name": "chained",
            "directory": "chained",
            "expected_edges": [["chained::(global)", "chained::Chain.(constructor)"],
                               ["chained::(global)", "chained::Chain.mul"],
                               ["chained::(global)", "chained::Chain.add"],
                               ["chained::(global)", "chained::Chain.sub"]],
            "expected_nodes": ["chained::Chain.sub",
                               "chained::(global)",
                               "chained::Chain.(constructor)",
                               "chained::Chain.add",
                               "chained::Chain.mul"]
        },
        {
            "test_name": "inheritance",
            "directory": "inheritance",
            "expected_edges": [["inheritance::(global)",
                                "inheritance::ScaleDemo.(constructor)"],
                               ["inheritance::(global)", "inheritance::pentaNum"],
                               ["inheritance::ScaleDemo.(constructor)",
                                "inheritance::MajorScales.majorNum"]],
            "expected_nodes": ["inheritance::MajorScales.majorNum",
                               "inheritance::ScaleDemo.(constructor)",
                               "inheritance::pentaNum",
                               "inheritance::(global)"]
        },
        {
            "test_name": "inheritance_attr",
            "directory": "inheritance_attr",
            "comment": "This is rare but it happened while testing chart.js. Extends was done on an attr.",
            "expected_edges": [["inheritance_attr::(global)",
                                "inheritance_attr::ClsB.meow"]],
            "expected_nodes": ["inheritance_attr::(global)",
                               "inheritance_attr::ClsB.meow"]
        },
        {
            "test_name": "bad_parse",
            "directory": "bad_parse",
            "comments": "One file is bad. Test bad parse line",
            "kwargs": {"skip_parse_errors": True},
            "expected_edges": [["file_a_good::(global)", "file_a_good::a"]],
            "expected_nodes": ["file_a_good::(global)", "file_a_good::a"]
        },
        {
            "test_name": "class_in_function",
            "directory": "class_in_function",
            "comments": "when a function defines a class within it",
            "expected_edges": [["class_in_function::(global)",
                                "class_in_function::rectangleClassFactory"]],
            "expected_nodes": ["class_in_function::rectangleClassFactory",
                               "class_in_function::(global)"]
        },
        {
            "test_name": "ternary_new",
            "directory": "ternary_new",
            "comments": "Ignore the name. This is for complex multi-layered object instantiation.",
            "expected_edges": [["ternary_new::Cadabra.init", "ternary_new::Cadabra.init"],
                               ["ternary_new::Abra.init", "ternary_new::Abra.init"],
                               ["ternary_new::(global)", "ternary_new::ClassMap.fact"]],
            "expected_nodes": ["ternary_new::Cadabra.init",
                               "ternary_new::ClassMap.fact",
                               "ternary_new::(global)",
                               "ternary_new::Abra.init"]
        },
        {
            "test_name": "moment.js",
            "directory": "moment",
            "expected_edges": [["moment::getWeeksInWeekYear", "moment::weeksInYear"],
                               ["moment::configFromRFC2822", "moment::preprocessRFC2822"],
                               ["moment::isNumberOrStringArray", "moment::isString"],
                               ["moment::prepareConfig", "moment::isDate"],
                               ["moment::handleStrictParse$1", "moment::createUTC"],
                               ["moment::addSubtract", "moment::setMonth"],
                               ["moment::makeGetSet", "moment::set$1"],
                               ["moment::dayOfYearFromWeeks", "moment::firstWeekOffset"],
                               ["moment::createDuration", "moment::Duration"],
                               ["moment::prepareConfig", "moment::Moment"],
                               ["moment::isNumberOrStringArray", "moment::isNumber"],
                               ["moment::configFromInput", "moment::configFromString"],
                               ["moment::createAdder", "moment::addSubtract"],
                               ["moment::pastFuture", "moment::isFunction"],
                               ["moment::configFromArray", "moment::daysInYear"],
                               ["moment::isSame", "moment::normalizeUnits"],
                               ["moment::getParsingFlags", "moment::defaultParsingFlags"],
                               ["moment::makeFormatFunction",
                                "moment::removeFormattingTokens"],
                               ["moment::relativeTime$1", "moment::createDuration"],
                               ["moment::defineLocale", "moment::deprecateSimple"],
                               ["moment::localeMonthsParse", "moment::createUTC"],
                               ["moment::getPrioritizedUnits", "moment::hasOwnProp"],
                               ["moment::(global)", "moment::setHookCallback"],
                               ["moment::deprecate", "moment::hasOwnProp"],
                               ["moment::listWeekdaysImpl", "moment::isNumber"],
                               ["moment::parseMs", "moment::toInt"],
                               ["moment::createLocalOrUTC", "moment::isArray"],
                               ["moment::relativeTime", "moment::isFunction"],
                               ["moment::(global)", "moment::toInt"],
                               ["moment::weekdaysShortRegex", "moment::hasOwnProp"],
                               ["moment::isSame", "moment::isMoment"],
                               ["moment::formatMoment", "moment::expandFormat"],
                               ["moment::getSetWeekYearHelper", "moment::weekOfYear"],
                               ["moment::max", "moment::pickBy"],
                               ["moment::createDuration", "moment::momentsDifference"],
                               ["moment::startOf", "moment::normalizeUnits"],
                               ["moment::prepareConfig", "moment::isArray"],
                               ["moment::bubble", "moment::monthsToDays"],
                               ["moment::configFromInput", "moment::configFromObject"],
                               ["moment::createLocal", "moment::createLocalOrUTC"],
                               ["moment::defineLocale", "moment::mergeConfigs"],
                               ["moment::addSubtract$1", "moment::createDuration"],
                               ["moment::configFromStringAndArray", "moment::extend"],
                               ["moment::parsingFlags", "moment::extend"],
                               ["moment::as", "moment::daysToMonths"],
                               ["moment::normalizeObjectUnits", "moment::normalizeUnits"],
                               ["moment::weekdaysMinRegex", "moment::hasOwnProp"],
                               ["moment::mergeConfigs", "moment::isObject"],
                               ["moment::localeEras", "moment::getLocale"],
                               ["moment::checkOverflow", "moment::getParsingFlags"],
                               ["moment::configFromStringAndFormat",
                                "moment::getParseRegexForToken"],
                               ["moment::listMonthsShort", "moment::listMonthsImpl"],
                               ["moment::extractFromRFC2822Strings",
                                "moment::untruncateYear"],
                               ["moment::(global)", "moment::addWeekParseToken"],
                               ["moment::getSetWeekYearHelper", "moment::weeksInYear"],
                               ["moment::configFromObject", "moment::configFromArray"],
                               ["moment::isBetween", "moment::createLocal"],
                               ["moment::addTimeToArrayFromToken", "moment::hasOwnProp"],
                               ["moment::configFromStringAndArray", "moment::copyConfig"],
                               ["moment::valueOf$1", "moment::toInt"],
                               ["moment::to", "moment::createLocal"],
                               ["moment::getSetMonth", "moment::setMonth"],
                               ["moment::getSetGlobalLocale", "moment::getLocale"],
                               ["moment::(global)", "moment::offset"],
                               ["moment::copyConfig", "moment::getParsingFlags"],
                               ["moment::offset", "moment::zeroFill"],
                               ["moment::isCalendarSpec", "moment::isObject"],
                               ["moment::isSame", "moment::createLocal"],
                               ["moment::addSubtract", "moment::set$1"],
                               ["moment::listWeekdaysImpl", "moment::getLocale"],
                               ["moment::isDaylightSavingTimeShifted",
                                "moment::prepareConfig"],
                               ["moment::diff", "moment::absFloor"],
                               ["moment::(global)", "moment::zeroFill"],
                               ["moment::createDuration", "moment::toInt"],
                               ["moment::setOffsetToLocal", "moment::getDateOffset"],
                               ["moment::subtract$1", "moment::addSubtract$1"],
                               ["moment::toISOString", "moment::isFunction"],
                               ["moment::normalizeObjectUnits", "moment::hasOwnProp"],
                               ["moment::mergeConfigs", "moment::extend"],
                               ["moment::prepareConfig",
                                "moment::configFromStringAndArray"],
                               ["moment::locale", "moment::getLocale"],
                               ["moment::listMonthsImpl", "moment::get$1"],
                               ["moment::updateLocale", "moment::loadLocale"],
                               ["moment::configFromObject", "moment::map"],
                               ["moment::meridiem", "moment::addFormatToken"],
                               ["moment::calendar$1", "moment::createLocal"],
                               ["moment::configFromArray", "moment::defaults"],
                               ["moment::toISOString$1", "moment::sign"],
                               ["moment::configFromStringAndFormat",
                                "moment::getParsingFlags"],
                               ["moment::configFromRFC2822", "moment::getParsingFlags"],
                               ["moment::getIsLeapYear", "moment::isLeapYear"],
                               ["moment::isMomentInputObject", "moment::hasOwnProp"],
                               ["moment::stringSet", "moment::normalizeObjectUnits"],
                               ["moment::cloneWithOffset", "moment::createLocal"],
                               ["moment::isValid$2", "moment::isValid"],
                               ["moment::(global)", "moment::hasOwnProp"],
                               ["moment::(global)", "moment::makeGetSet"],
                               ["moment::configFromInput", "moment::configFromArray"],
                               ["moment::configFromRFC2822",
                                "moment::extractFromRFC2822Strings"],
                               ["moment::(global)", "moment::getSetGlobalLocale"],
                               ["moment::getSetISOWeek", "moment::weekOfYear"],
                               ["moment::isNumberOrStringArray", "moment::isArray"],
                               ["moment::monthsShortRegex", "moment::hasOwnProp"],
                               ["moment::set", "moment::hasOwnProp"],
                               ["moment::from", "moment::createLocal"],
                               ["moment::deprecate", "moment::warn"],
                               ["moment::configFromArray", "moment::currentDateArray"],
                               ["moment::addSubtract", "moment::absRound"],
                               ["moment::configFromInput", "moment::isNumber"],
                               ["moment::(global)", "moment::getParsingFlags"],
                               ["moment::defineLocale", "moment::loadLocale"],
                               ["moment::getSetOffset", "moment::getDateOffset"],
                               ["moment::Duration", "moment::normalizeObjectUnits"],
                               ["moment::createInvalid", "moment::extend"],
                               ["moment::getSetISODayOfWeek", "moment::parseIsoWeekday"],
                               ["moment::configFromStringAndArray",
                                "moment::getParsingFlags"],
                               ["moment::parsingFlags", "moment::getParsingFlags"],
                               ["moment::endOf", "moment::normalizeUnits"],
                               ["moment::erasNameRegex", "moment::hasOwnProp"],
                               ["moment::diff", "moment::monthDiff"],
                               ["moment::getSetOffset", "moment::offsetFromString"],
                               ["moment::dayOfYearFromWeekInfo", "moment::createLocal"],
                               ["moment::calendar", "moment::isFunction"],
                               ["moment::configFromRFC2822", "moment::checkWeekday"],
                               ["moment::getSetOffset", "moment::createDuration"],
                               ["moment::configFromString", "moment::configFromISO"],
                               ["moment::getWeeksInYear", "moment::weeksInYear"],
                               ["moment::set", "moment::isFunction"],
                               ["moment::(global)", "moment::createInvalid"],
                               ["moment::daysInMonth", "moment::isLeapYear"],
                               ["moment::stringSet", "moment::isFunction"],
                               ["moment::getISOWeeksInYear", "moment::weeksInYear"],
                               ["moment::dayOfYearFromWeekInfo",
                                "moment::dayOfYearFromWeeks"],
                               ["moment::isAfter", "moment::normalizeUnits"],
                               ["moment::calendar$1", "moment::isMomentInput"],
                               ["moment::getLocale", "moment::chooseLocale"],
                               ["moment::toNow", "moment::createLocal"],
                               ["moment::prepareConfig", "moment::createInvalid"],
                               ["moment::weekdaysRegex", "moment::hasOwnProp"],
                               ["moment::loadLocale", "moment::getSetGlobalLocale"],
                               ["moment::pickBy", "moment::createLocal"],
                               ["moment::fromNow", "moment::createLocal"],
                               ["moment::setWeekAll", "moment::dayOfYearFromWeeks"],
                               ["moment::configFromStringAndFormat",
                                "moment::addTimeToArrayFromToken"],
                               ["moment::isAfter", "moment::isMoment"],
                               ["moment::formatMoment", "moment::makeFormatFunction"],
                               ["moment::createAdder", "moment::deprecateSimple"],
                               ["moment::updateLocale", "moment::mergeConfigs"],
                               ["moment::stringSet", "moment::getPrioritizedUnits"],
                               ["moment::localeWeek", "moment::weekOfYear"],
                               ["moment::as", "moment::monthsToDays"],
                               ["moment::setMonth", "moment::isNumber"],
                               ["moment::isMomentInput", "moment::isMomentInputObject"],
                               ["moment::chooseLocale", "moment::commonPrefix"],
                               ["moment::monthsRegex", "moment::hasOwnProp"],
                               ["moment::computeWeekdaysParse", "moment::createUTC"],
                               ["moment::configFromInput", "moment::isDate"],
                               ["moment::prepareConfig", "moment::configFromInput"],
                               ["moment::localeMonthsShort", "moment::isArray"],
                               ["moment::get$1", "moment::getLocale"],
                               ["moment::as", "moment::normalizeUnits"],
                               ["moment::isMomentInputObject", "moment::isObjectEmpty"],
                               ["moment::to", "moment::createDuration"],
                               ["moment::configFromInput", "moment::isUndefined"],
                               ["moment::dayOfYearFromWeeks", "moment::daysInYear"],
                               ["moment::listMonthsImpl", "moment::isNumber"],
                               ["moment::getLocale", "moment::loadLocale"],
                               ["moment::configFromStringAndFormat",
                                "moment::configFromRFC2822"],
                               ["moment::isMomentInput", "moment::isMoment"],
                               ["moment::isDaylightSavingTimeShifted",
                                "moment::createLocal"],
                               ["moment::erasAbbrRegex", "moment::hasOwnProp"],
                               ["moment::computeMonthsParse", "moment::createUTC"],
                               ["moment::stringGet", "moment::isFunction"],
                               ["moment::isObjectEmpty", "moment::hasOwnProp"],
                               ["moment::listMonths", "moment::listMonthsImpl"],
                               ["moment::compareArrays", "moment::toInt"],
                               ["moment::createUnix", "moment::createLocal"],
                               ["moment::addFormatToken", "moment::zeroFill"],
                               ["moment::isAfter", "moment::createLocal"],
                               ["moment::createInvalid$1", "moment::createDuration"],
                               ["moment::createAdder", "moment::createDuration"],
                               ["moment::isDaylightSavingTimeShifted",
                                "moment::isUndefined"],
                               ["moment::configFromRFC2822", "moment::calculateOffset"],
                               ["moment::pickBy", "moment::isArray"],
                               ["moment::localeWeekdaysMin", "moment::shiftWeekdays"],
                               ["moment::configFromInput", "moment::isObject"],
                               ["moment::getLocale", "moment::isArray"],
                               ["moment::createDuration", "moment::absRound"],
                               ["moment::configFromInput", "moment::isArray"],
                               ["moment::deprecateSimple", "moment::warn"],
                               ["moment::extend", "moment::hasOwnProp"],
                               ["moment::(global)", "moment::addParseToken"],
                               ["moment::(global)", "moment::makeAs"],
                               ["moment::from", "moment::createDuration"],
                               ["moment::addParseToken", "moment::isNumber"],
                               ["moment::chooseLocale", "moment::normalizeLocale"],
                               ["moment::Moment", "moment::copyConfig"],
                               ["moment::localeMonths", "moment::isArray"],
                               ["moment::clone$1", "moment::createDuration"],
                               ["moment::getSetGlobalLocale", "moment::isUndefined"],
                               ["moment::stringSet", "moment::normalizeUnits"],
                               ["moment::isBefore", "moment::isMoment"],
                               ["moment::makeFormatFunction", "moment::isFunction"],
                               ["moment::defineLocale", "moment::getSetGlobalLocale"],
                               ["moment::min", "moment::pickBy"],
                               ["moment::createUTC", "moment::createLocalOrUTC"],
                               ["moment::add$1", "moment::addSubtract$1"],
                               ["moment::get$1", "moment::createUTC"],
                               ["moment::weeksInYear", "moment::daysInYear"],
                               ["moment::configFromObject",
                                "moment::normalizeObjectUnits"],
                               ["moment::dayOfYearFromWeekInfo", "moment::weekOfYear"],
                               ["moment::prepareConfig", "moment::isMoment"],
                               ["moment::offsetFromString", "moment::toInt"],
                               ["moment::calendar$1", "moment::isFunction"],
                               ["moment::(global)", "moment::createAdder"],
                               ["moment::getParseRegexForToken", "moment::hasOwnProp"],
                               ["moment::cloneWithOffset", "moment::isDate"],
                               ["moment::configFromArray", "moment::getParsingFlags"],
                               ["moment::localeWeekdays", "moment::isArray"],
                               ["moment::dayOfYearFromWeekInfo", "moment::defaults"],
                               ["moment::configFromStringAndArray",
                                "moment::configFromStringAndFormat"],
                               ["moment::getEraYear", "moment::hooks"],
                               ["moment::setOffsetToParsedOffset",
                                "moment::offsetFromString"],
                               ["moment::bubble", "moment::absFloor"],
                               ["moment::createInvalid", "moment::createUTC"],
                               ["moment::addSubtract", "moment::get"],
                               ["moment::weekOfYear", "moment::weeksInYear"],
                               ["moment::prepareConfig",
                                "moment::configFromStringAndFormat"],
                               ["moment::(global)", "moment::addWeekYearFormatToken"],
                               ["moment::setMonth", "moment::toInt"],
                               ["moment::configFromInput", "moment::map"],
                               ["moment::offset", "moment::addFormatToken"],
                               ["moment::(global)", "moment::deprecate"],
                               ["moment::listWeekdays", "moment::listWeekdaysImpl"],
                               ["moment::endOf", "moment::mod$1"],
                               ["moment::isValid", "moment::getParsingFlags"],
                               ["moment::isMomentInput", "moment::isNumberOrStringArray"],
                               ["moment::defineLocale", "moment::Locale"],
                               ["moment::localeWeekdays", "moment::shiftWeekdays"],
                               ["moment::calendar$1", "moment::isCalendarSpec"],
                               ["moment::pastFuture", "moment::format"],
                               ["moment::configFromStringAndArray", "moment::isValid"],
                               ["moment::isDaylightSavingTimeShifted",
                                "moment::copyConfig"],
                               ["moment::mergeConfigs", "moment::hasOwnProp"],
                               ["moment::setMonth", "moment::daysInMonth"],
                               ["moment::stringGet", "moment::normalizeUnits"],
                               ["moment::humanize", "moment::relativeTime$1"],
                               ["moment::toISOString", "moment::formatMoment"],
                               ["moment::createFromConfig", "moment::prepareConfig"],
                               ["moment::listWeekdaysMin", "moment::listWeekdaysImpl"],
                               ["moment::addWeekYearFormatToken",
                                "moment::addFormatToken"],
                               ["moment::prepareConfig", "moment::isValid"],
                               ["moment::handleStrictParse", "moment::createUTC"],
                               ["moment::createDuration", "moment::hasOwnProp"],
                               ["moment::isCalendarSpec", "moment::hasOwnProp"],
                               ["moment::erasNarrowRegex", "moment::hasOwnProp"],
                               ["moment::localeEras", "moment::hooks"],
                               ["moment::weekOfYear", "moment::firstWeekOffset"],
                               ["moment::Duration", "moment::getLocale"],
                               ["moment::isMomentInput", "moment::isString"],
                               ["moment::getSetGlobalLocale", "moment::defineLocale"],
                               ["moment::createDuration", "moment::parseIso"],
                               ["moment::configFromStringAndFormat",
                                "moment::meridiemFixWrap"],
                               ["moment::diff", "moment::normalizeUnits"],
                               ["moment::configFromStringAndFormat",
                                "moment::checkOverflow"],
                               ["moment::daysInMonth", "moment::mod"],
                               ["moment::createFromConfig", "moment::checkOverflow"],
                               ["moment::get$2", "moment::normalizeUnits"],
                               ["moment::(global)", "moment::addRegexToken"],
                               ["moment::isMomentInputObject", "moment::isObject"],
                               ["moment::isBetween", "moment::isMoment"],
                               ["moment::createDuration", "moment::createLocal"],
                               ["moment::(global)", "moment::addUnitAlias"],
                               ["moment::createLocalOrUTC", "moment::isObjectEmpty"],
                               ["moment::isMomentInput", "moment::isNumber"],
                               ["moment::addParseToken", "moment::toInt"],
                               ["moment::startOf", "moment::mod$1"],
                               ["moment::makeGetSet", "moment::get"],
                               ["moment::createLocalOrUTC", "moment::isObject"],
                               ["moment::to", "moment::isMoment"],
                               ["moment::checkWeekday", "moment::getParsingFlags"],
                               ["moment::defineLocale", "moment::defineLocale"],
                               ["moment::localeErasConvertYear", "moment::hooks"],
                               ["moment::getSetMonth", "moment::get"],
                               ["moment::createInvalid", "moment::getParsingFlags"],
                               ["moment::momentsDifference", "moment::cloneWithOffset"],
                               ["moment::configFromISO",
                                "moment::configFromStringAndFormat"],
                               ["moment::configFromStringAndFormat",
                                "moment::configFromArray"],
                               ["moment::updateLocale", "moment::getSetGlobalLocale"],
                               ["moment::unescapeFormat", "moment::regexEscape"],
                               ["moment::configFromISO", "moment::getParsingFlags"],
                               ["moment::configFromStringAndFormat",
                                "moment::configFromISO"],
                               ["moment::getDaysInMonth", "moment::daysInMonth"],
                               ["moment::daysInYear", "moment::isLeapYear"],
                               ["moment::diff", "moment::cloneWithOffset"],
                               ["moment::configFromArray",
                                "moment::dayOfYearFromWeekInfo"],
                               ["moment::prepareConfig", "moment::checkOverflow"],
                               ["moment::addRegexToken", "moment::isFunction"],
                               ["moment::isBefore", "moment::normalizeUnits"],
                               ["moment::bubble", "moment::absCeil"],
                               ["moment::isDurationValid", "moment::toInt"],
                               ["moment::computeWeekdaysParse", "moment::regexEscape"],
                               ["moment::momentsDifference",
                                "moment::positiveMomentsDifference"],
                               ["moment::cloneWithOffset", "moment::isMoment"],
                               ["moment::getParseRegexForToken", "moment::unescapeFormat"],
                               ["moment::configFromArray", "moment::createUTCDate"],
                               ["moment::toISOString$1", "moment::absFloor"],
                               ["moment::isDaylightSavingTimeShifted",
                                "moment::compareArrays"],
                               ["moment::monthDiff", "moment::monthDiff"],
                               ["moment::from", "moment::isMoment"],
                               ["moment::isCalendarSpec", "moment::isObjectEmpty"],
                               ["moment::bubble", "moment::daysToMonths"],
                               ["moment::chooseLocale", "moment::loadLocale"],
                               ["moment::weeksInYear", "moment::firstWeekOffset"],
                               ["moment::listWeekdaysImpl", "moment::get$1"],
                               ["moment::calendar$1", "moment::cloneWithOffset"],
                               ["moment::isMomentInput", "moment::isDate"],
                               ["moment::(global)", "moment::offsetFromString"],
                               ["moment::addWeekParseToken", "moment::addParseToken"],
                               ["moment::getISOWeeksInISOWeekYear", "moment::weeksInYear"],
                               ["moment::invalidAt", "moment::getParsingFlags"],
                               ["moment::computeMonthsParse", "moment::regexEscape"],
                               ["moment::localeWeekdaysShort", "moment::shiftWeekdays"],
                               ["moment::getSetOffset", "moment::addSubtract"],
                               ["moment::firstWeekOffset", "moment::createUTCDate"],
                               ["moment::weeks", "moment::absFloor"],
                               ["moment::updateLocale", "moment::Locale"],
                               ["moment::copyConfig", "moment::isUndefined"],
                               ["moment::createDuration", "moment::isDuration"],
                               ["moment::hasAlignedHourOffset", "moment::createLocal"],
                               ["moment::clone", "moment::Moment"],
                               ["moment::set$1", "moment::toInt"],
                               ["moment::getSetDayOfWeek", "moment::parseWeekday"],
                               ["moment::setWeekAll", "moment::createUTCDate"],
                               ["moment::(global)", "moment::meridiem"],
                               ["moment::isDaylightSavingTimeShifted",
                                "moment::createUTC"],
                               ["moment::set$1", "moment::isLeapYear"],
                               ["moment::configFromStringAndFormat",
                                "moment::expandFormat"],
                               ["moment::set$1", "moment::daysInMonth"],
                               ["moment::format", "moment::formatMoment"],
                               ["moment::localeWeekdaysParse", "moment::createUTC"],
                               ["moment::deprecate", "moment::extend"],
                               ["moment::computeErasParse", "moment::regexEscape"],
                               ["moment::(global)", "moment::makeGetter"],
                               ["moment::isBefore", "moment::createLocal"],
                               ["moment::configFromString", "moment::configFromRFC2822"],
                               ["moment::dayOfYearFromWeekInfo",
                                "moment::getParsingFlags"],
                               ["moment::dayOfYearFromWeekInfo", "moment::weeksInYear"],
                               ["moment::(global)", "moment::addFormatToken"],
                               ["moment::createDuration", "moment::isNumber"],
                               ["moment::createLocalOrUTC", "moment::createFromConfig"],
                               ["moment::(global)", "moment::addUnitPriority"],
                               ["moment::createFromConfig", "moment::Moment"],
                               ["moment::checkOverflow", "moment::daysInMonth"],
                               ["moment::listWeekdaysShort", "moment::listWeekdaysImpl"],
                               ["moment::Duration", "moment::isDurationValid"],
                               ["moment::toInt", "moment::absFloor"],
                               ["moment::isDurationValid", "moment::hasOwnProp"],
                               ["moment::prepareConfig", "moment::getLocale"]],
            "expected_nodes": ["moment::weeksInYear",
                               "moment::toISOString$1",
                               "moment::createFromConfig",
                               "moment::mod$1",
                               "moment::checkOverflow",
                               "moment::configFromISO",
                               "moment::getSetISODayOfWeek",
                               "moment::regexEscape",
                               "moment::isCalendarSpec",
                               "moment::from",
                               "moment::setOffsetToLocal",
                               "moment::setHookCallback",
                               "moment::deprecateSimple",
                               "moment::checkWeekday",
                               "moment::Locale",
                               "moment::daysToMonths",
                               "moment::getIsLeapYear",
                               "moment::isFunction",
                               "moment::defineLocale",
                               "moment::loadLocale",
                               "moment::configFromObject",
                               "moment::listWeekdaysShort",
                               "moment::addFormatToken",
                               "moment::getEraYear",
                               "moment::startOf",
                               "moment::makeGetSet",
                               "moment::fromNow",
                               "moment::currentDateArray",
                               "moment::makeAs",
                               "moment::stringGet",
                               "moment::createAdder",
                               "moment::copyConfig",
                               "moment::hasAlignedHourOffset",
                               "moment::getSetDayOfWeek",
                               "moment::isValid",
                               "moment::isMomentInputObject",
                               "moment::localeWeek",
                               "moment::getWeeksInYear",
                               "moment::getDaysInMonth",
                               "moment::sign",
                               "moment::dayOfYearFromWeeks",
                               "moment::addSubtract$1",
                               "moment::getLocale",
                               "moment::setMonth",
                               "moment::addTimeToArrayFromToken",
                               "moment::getWeeksInWeekYear",
                               "moment::configFromStringAndFormat",
                               "moment::meridiem",
                               "moment::handleStrictParse$1",
                               "moment::set",
                               "moment::parseIso",
                               "moment::chooseLocale",
                               "moment::daysInYear",
                               "moment::localeErasConvertYear",
                               "moment::createInvalid",
                               "moment::isBefore",
                               "moment::erasNameRegex",
                               "moment::handleStrictParse",
                               "moment::subtract$1",
                               "moment::defaultParsingFlags",
                               "moment::meridiemFixWrap",
                               "moment::parseMs",
                               "moment::isNumber",
                               "moment::createInvalid$1",
                               "moment::createUnix",
                               "moment::isSame",
                               "moment::relativeTime$1",
                               "moment::addUnitAlias",
                               "moment::createDuration",
                               "moment::expandFormat",
                               "moment::deprecate",
                               "moment::to",
                               "moment::offset",
                               "moment::getParsingFlags",
                               "moment::absRound",
                               "moment::firstWeekOffset",
                               "moment::monthsToDays",
                               "moment::isAfter",
                               "moment::localeMonths",
                               "moment::toInt",
                               "moment::normalizeLocale",
                               "moment::isUndefined",
                               "moment::weeks",
                               "moment::createLocal",
                               "moment::addRegexToken",
                               "moment::add$1",
                               "moment::makeGetter",
                               "moment::createUTCDate",
                               "moment::computeWeekdaysParse",
                               "moment::configFromStringAndArray",
                               "moment::absCeil",
                               "moment::normalizeUnits",
                               "moment::max",
                               "moment::pickBy",
                               "moment::endOf",
                               "moment::configFromRFC2822",
                               "moment::isDaylightSavingTimeShifted",
                               "moment::bubble",
                               "moment::createUTC",
                               "moment::getPrioritizedUnits",
                               "moment::isObjectEmpty",
                               "moment::isObject",
                               "moment::zeroFill",
                               "moment::addParseToken",
                               "moment::calendar",
                               "moment::momentsDifference",
                               "moment::unescapeFormat",
                               "moment::monthsRegex",
                               "moment::compareArrays",
                               "moment::setOffsetToParsedOffset",
                               "moment::prepareConfig",
                               "moment::toISOString",
                               "moment::isValid$2",
                               "moment::weekOfYear",
                               "moment::format",
                               "moment::localeWeekdays",
                               "moment::getISOWeeksInISOWeekYear",
                               "moment::isMoment",
                               "moment::hooks",
                               "moment::shiftWeekdays",
                               "moment::(global)",
                               "moment::preprocessRFC2822",
                               "moment::clone$1",
                               "moment::isNumberOrStringArray",
                               "moment::warn",
                               "moment::weekdaysRegex",
                               "moment::formatMoment",
                               "moment::getSetISOWeek",
                               "moment::weekdaysMinRegex",
                               "moment::listMonths",
                               "moment::isDuration",
                               "moment::extractFromRFC2822Strings",
                               "moment::weekdaysShortRegex",
                               "moment::configFromArray",
                               "moment::untruncateYear",
                               "moment::min",
                               "moment::Duration",
                               "moment::getParseRegexForToken",
                               "moment::erasNarrowRegex",
                               "moment::removeFormattingTokens",
                               "moment::updateLocale",
                               "moment::listWeekdays",
                               "moment::mergeConfigs",
                               "moment::isString",
                               "moment::getSetOffset",
                               "moment::hasOwnProp",
                               "moment::configFromString",
                               "moment::isDate",
                               "moment::parsingFlags",
                               "moment::calculateOffset",
                               "moment::stringSet",
                               "moment::listMonthsImpl",
                               "moment::dayOfYearFromWeekInfo",
                               "moment::isDurationValid",
                               "moment::positiveMomentsDifference",
                               "moment::clone",
                               "moment::map",
                               "moment::get$1",
                               "moment::makeFormatFunction",
                               "moment::erasAbbrRegex",
                               "moment::computeMonthsParse",
                               "moment::daysInMonth",
                               "moment::listWeekdaysImpl",
                               "moment::computeErasParse",
                               "moment::getSetWeekYearHelper",
                               "moment::pastFuture",
                               "moment::isBetween",
                               "moment::listWeekdaysMin",
                               "moment::normalizeObjectUnits",
                               "moment::isMomentInput",
                               "moment::getSetMonth",
                               "moment::parseWeekday",
                               "moment::offsetFromString",
                               "moment::addWeekParseToken",
                               "moment::set$1",
                               "moment::localeMonthsShort",
                               "moment::addUnitPriority",
                               "moment::localeWeekdaysMin",
                               "moment::createLocalOrUTC",
                               "moment::commonPrefix",
                               "moment::getSetGlobalLocale",
                               "moment::valueOf$1",
                               "moment::localeMonthsParse",
                               "moment::addWeekYearFormatToken",
                               "moment::as",
                               "moment::mod",
                               "moment::get",
                               "moment::configFromInput",
                               "moment::humanize",
                               "moment::addSubtract",
                               "moment::listMonthsShort",
                               "moment::absFloor",
                               "moment::relativeTime",
                               "moment::monthDiff",
                               "moment::getISOWeeksInYear",
                               "moment::isArray",
                               "moment::setWeekAll",
                               "moment::monthsShortRegex",
                               "moment::Moment",
                               "moment::extend",
                               "moment::locale",
                               "moment::cloneWithOffset",
                               "moment::localeWeekdaysParse",
                               "moment::toNow",
                               "moment::localeEras",
                               "moment::localeWeekdaysShort",
                               "moment::get$2",
                               "moment::parseIsoWeekday",
                               "moment::diff",
                               "moment::getDateOffset",
                               "moment::calendar$1",
                               "moment::invalidAt",
                               "moment::defaults",
                               "moment::isLeapYear"]
        },
        {
            "test_name": "moment_depth_1",
            "directory": "moment",
            "kwargs": {"target_function": "createDuration",
                       "upstream_depth": "1",
                       "downstream_depth": "1"},
            "expected_edges": [["moment::clone$1", "moment::createDuration"],
                               ["moment::createInvalid$1", "moment::createDuration"],
                               ["moment::createDuration", "moment::isDuration"],
                               ["moment::relativeTime$1", "moment::createDuration"],
                               ["moment::createDuration", "moment::Duration"],
                               ["moment::createDuration", "moment::isNumber"],
                               ["moment::createDuration", "moment::absRound"],
                               ["moment::createAdder", "moment::createDuration"],
                               ["moment::createDuration", "moment::hasOwnProp"],
                               ["moment::addSubtract$1", "moment::createDuration"],
                               ["moment::createDuration", "moment::parseIso"],
                               ["moment::from", "moment::createLocal"],
                               ["moment::to", "moment::createLocal"],
                               ["moment::createDuration", "moment::momentsDifference"],
                               ["moment::to", "moment::createDuration"],
                               ["moment::from", "moment::createDuration"],
                               ["moment::getSetOffset", "moment::createDuration"],
                               ["moment::createDuration", "moment::toInt"],
                               ["moment::createDuration", "moment::createLocal"]],
            "expected_nodes": ["moment::toInt",
                               "moment::Duration",
                               "moment::createAdder",
                               "moment::createDuration",
                               "moment::absRound",
                               "moment::from",
                               "moment::addSubtract$1",
                               "moment::isDuration",
                               "moment::isNumber",
                               "moment::hasOwnProp",
                               "moment::createLocal",
                               "moment::parseIso",
                               "moment::getSetOffset",
                               "moment::relativeTime$1",
                               "moment::createInvalid$1",
                               "moment::clone$1",
                               "moment::to",
                               "moment::momentsDifference"]
        },
        {
            "test_name": "moment_only_down",
            "directory": "moment",
            "kwargs": {"target_function": "createDuration", "downstream_depth": "1"},
            "expected_edges": [["moment::createDuration", "moment::hasOwnProp"],
                               ["moment::createDuration", "moment::isDuration"],
                               ["moment::createDuration", "moment::momentsDifference"],
                               ["moment::createDuration", "moment::absRound"],
                               ["moment::createDuration", "moment::isNumber"],
                               ["moment::createDuration", "moment::parseIso"],
                               ["moment::createDuration", "moment::toInt"],
                               ["moment::createDuration", "moment::Duration"],
                               ["moment::createDuration", "moment::createLocal"]],
            "expected_nodes": ["moment::parseIso",
                               "moment::createDuration",
                               "moment::isNumber",
                               "moment::hasOwnProp",
                               "moment::toInt",
                               "moment::isDuration",
                               "moment::createLocal",
                               "moment::momentsDifference",
                               "moment::absRound",
                               "moment::Duration"]
        },
        {
            "test_name": "moment_only_up",
            "directory": "moment",
            "kwargs": {"target_function": "createDuration", "upstream_depth": "1"},
            "expected_edges": [["moment::createInvalid$1", "moment::createDuration"],
                               ["moment::to", "moment::createDuration"],
                               ["moment::from", "moment::createDuration"],
                               ["moment::createAdder", "moment::createDuration"],
                               ["moment::getSetOffset", "moment::createDuration"],
                               ["moment::clone$1", "moment::createDuration"],
                               ["moment::addSubtract$1", "moment::createDuration"],
                               ["moment::relativeTime$1", "moment::createDuration"]],
            "expected_nodes": ["moment::relativeTime$1",
                               "moment::createDuration",
                               "moment::createInvalid$1",
                               "moment::to",
                               "moment::createAdder",
                               "moment::from",
                               "moment::getSetOffset",
                               "moment::clone$1",
                               "moment::addSubtract$1"]
        },
        {
            "test_name": "moment_double_depth",
            "directory": "moment",
            "kwargs": {"target_function": "createDuration",
                       "upstream_depth": "2",
                       "downstream_depth": "2"},
            "expected_edges": [["moment::(global)", "moment::toInt"],
                               ["moment::isDurationValid", "moment::hasOwnProp"],
                               ["moment::to", "moment::createLocal"],
                               ["moment::cloneWithOffset", "moment::createLocal"],
                               ["moment::createDuration", "moment::absRound"],
                               ["moment::createLocal", "moment::createLocalOrUTC"],
                               ["moment::isDurationValid", "moment::toInt"],
                               ["moment::clone$1", "moment::createDuration"],
                               ["moment::momentsDifference", "moment::cloneWithOffset"],
                               ["moment::subtract$1", "moment::addSubtract$1"],
                               ["moment::momentsDifference",
                                "moment::positiveMomentsDifference"],
                               ["moment::normalizeObjectUnits", "moment::hasOwnProp"],
                               ["moment::createDuration", "moment::createLocal"],
                               ["moment::from", "moment::createDuration"],
                               ["moment::add$1", "moment::addSubtract$1"],
                               ["moment::Duration", "moment::isDurationValid"],
                               ["moment::relativeTime$1", "moment::createDuration"],
                               ["moment::createDuration", "moment::Duration"],
                               ["moment::getSetOffset", "moment::createDuration"],
                               ["moment::humanize", "moment::relativeTime$1"],
                               ["moment::Duration", "moment::getLocale"],
                               ["moment::addSubtract$1", "moment::createDuration"],
                               ["moment::to", "moment::createDuration"],
                               ["moment::Duration", "moment::normalizeObjectUnits"],
                               ["moment::toInt", "moment::absFloor"],
                               ["moment::createDuration", "moment::hasOwnProp"],
                               ["moment::from", "moment::createLocal"],
                               ["moment::createAdder", "moment::createDuration"],
                               ["moment::(global)", "moment::hasOwnProp"],
                               ["moment::createDuration", "moment::isDuration"],
                               ["moment::(global)", "moment::createAdder"],
                               ["moment::createDuration", "moment::momentsDifference"],
                               ["moment::createDuration", "moment::toInt"],
                               ["moment::createDuration", "moment::isNumber"],
                               ["moment::createDuration", "moment::parseIso"],
                               ["moment::createInvalid$1", "moment::createDuration"]],
            "expected_nodes": ["moment::normalizeObjectUnits",
                               "moment::cloneWithOffset",
                               "moment::createInvalid$1",
                               "moment::to",
                               "moment::isDuration",
                               "moment::hasOwnProp",
                               "moment::isNumber",
                               "moment::momentsDifference",
                               "moment::createLocalOrUTC",
                               "moment::(global)",
                               "moment::absFloor",
                               "moment::relativeTime$1",
                               "moment::Duration",
                               "moment::from",
                               "moment::absRound",
                               "moment::addSubtract$1",
                               "moment::getSetOffset",
                               "moment::isDurationValid",
                               "moment::positiveMomentsDifference",
                               "moment::createDuration",
                               "moment::getLocale",
                               "moment::parseIso",
                               "moment::add$1",
                               "moment::createAdder",
                               "moment::clone$1",
                               "moment::createLocal",
                               "moment::toInt",
                               "moment::subtract$1",
                               "moment::humanize"]
        }
    ],
    'mjs': [
        {
            "test_name": "two_file_imports_es6",
            "directory": "two_file_imports_es6",
            "comment": "mjs files should be detected and this separately tests es6 imports",
            "kwargs": {'source_type': 'module'},
            "expected_edges": [["imported_es6::myClass.(constructor)",
                                "imported_es6::myClass.doit"],
                               ["importer_es6::outer", "imported_es6::inner"],
                               ["imported_es6::myClass.doit",
                                "imported_es6::myClass.doit2"],
                               ["importer_es6::outer",
                                "imported_es6::myClass.(constructor)"],
                               ["importer_es6::(global)", "importer_es6::outer"]],
            "expected_nodes": ["imported_es6::myClass.doit",
                               "imported_es6::inner",
                               "imported_es6::myClass.doit2",
                               "imported_es6::myClass.(constructor)",
                               "importer_es6::(global)",
                               "importer_es6::outer"]
        },
    ],
    'rb': [
        {
            "test_name": "simple_a",
            "directory": "simple_a",
            "expected_edges": [["simple_a::func_a", "simple_a::func_b"],
                               ["simple_a::(global)", "simple_a::func_a"]],
            "expected_nodes": ["simple_a::(global)",
                               "simple_a::func_a",
                               "simple_a::func_b"]
        },
        {
            "test_name": "simple_b",
            "directory": "simple_b",
            "expected_edges": [["simple_b::b", "simple_b::a"],
                               ["simple_b::a", "simple_b::b"],
                               ["simple_b::Cls.d", "simple_b::a"],
                               ["simple_b::(global)", "simple_b::Cls.initialize"],
                               ["simple_b::(global)", "simple_b::Cls.d"]],
            "expected_nodes": ["simple_b::(global)",
                               "simple_b::a",
                               "simple_b::b",
                               "simple_b::Cls.d",
                               "simple_b::Cls.initialize"]
        },
        {
            "test_name": "two_file_simple",
            "directory": "two_file_simple",
            "expected_edges": [["file_a::(global)", "file_a::abra"],
                               ["file_a::abra", "file_b::babra"]],
            "expected_nodes": ["file_a::(global)", "file_a::abra", "file_b::babra"]
        },
        {
            "test_name": "resolve_correct_class",
            "directory": "resolve_correct_class",
            "expected_edges": [["rcc::Beta.func_1", "rcc::Alpha.func_2"],
                               ["rcc::Alpha.func_1", "rcc::Beta.func_2"],
                               ["rcc::Alpha.func_1", "rcc::Alpha.func_1"]],
            "expected_nodes": ["rcc::Beta.func_1",
                               "rcc::Alpha.func_1",
                               "rcc::Alpha.func_2",
                               "rcc::Beta.func_2"]
        },
        {
            "test_name": "ambiguous_resolution",
            "directory": "ambiguous_resolution",
            "expected_edges": [["ambiguous_resolution::Cadabra.cadabra_it",
                                "ambiguous_resolution::Abra.abra_it"],
                               ["ambiguous_resolution::(global)",
                                "ambiguous_resolution::main"],
                               ["ambiguous_resolution::main",
                                "ambiguous_resolution::Cadabra.cadabra_it"]],
            "expected_nodes": ["ambiguous_resolution::Abra.abra_it",
                               "ambiguous_resolution::main",
                               "ambiguous_resolution::(global)",
                               "ambiguous_resolution::Cadabra.cadabra_it"]

        },
        {
            "test_name": "instance_methods",
            "directory": "instance_methods",
            "expected_edges": [["instance_methods::Abra.nested2",
                                "instance_methods::Abra.main"],
                               ["instance_methods::(global)",
                                "instance_methods::Abra.nested2"],
                               ["instance_methods::Abra.nested",
                                "instance_methods::Abra.main"],
                               ["instance_methods::(global)",
                                "instance_methods::Abra.nested"],
                               ["instance_methods::(global)",
                                "instance_methods::Abra.main2"],
                               ["instance_methods::Abra.main",
                                "instance_methods::Abra.nested"],
                               ["instance_methods::(global)",
                                "instance_methods::Abra.main"]],
            "expected_nodes": ["instance_methods::Abra.nested2",
                               "instance_methods::Abra.main2",
                               "instance_methods::Abra.nested",
                               "instance_methods::Abra.main",
                               "instance_methods::(global)"]

        },
        {
            "test_name": "chains",
            "directory": "chains",
            "expected_edges": [["chains::a", "chains::b"],
                               ["chains::(global)", "chains::c"],
                               ["chains::b", "chains::a"],
                               ["chains::c", "chains::Cls.initialize"],
                               ["chains::c", "chains::Cls.b"],
                               ["chains::(global)", "chains::b"],
                               ["chains::(global)", "chains::a"],
                               ["chains::c", "chains::Cls.a"]],
            "expected_nodes": ["chains::a",
                               "chains::Cls.initialize",
                               "chains::Cls.a",
                               "chains::c",
                               "chains::(global)",
                               "chains::Cls.b",
                               "chains::b"]

        },
        {
            "test_name": "modules",
            "directory": "modules",
            "expected_edges": [["modules::(global)", "modules::ScaleDemo.initialize"],
                               ["modules::(global)", "modules::majorNum"],
                               ["modules::ScaleDemoLimited.initialize",
                                "modules::MajorScales.majorNum"],
                               ["modules::ScaleDemo.initialize",
                                "modules::MajorScales.majorNum"],
                               ["modules::ScaleDemo.initialize",
                                "modules::PentatonicScales.pentaNum"]],
            "expected_nodes": ["modules::PentatonicScales.pentaNum",
                               "modules::ScaleDemo.initialize",
                               "modules::(global)",
                               "modules::MajorScales.majorNum",
                               "modules::ScaleDemoLimited.initialize",
                               "modules::majorNum"]
        },
        {
            "test_name": "doublecolon",
            "directory": "doublecolon",
            "expected_edges": [["doublecolon::Class1.func_a",
                                "doublecolon::Class2.func_b"],
                               ["doublecolon::Class1.func_b",
                                "doublecolon::Class1.func_a"],
                               ["doublecolon::Class2.func_b",
                                "doublecolon::Class2.func_a"],
                               ["doublecolon::Class2.func_a",
                                "doublecolon::Class1.func_b"],
                               ["doublecolon::(global)", "doublecolon::Class2.func_b"]],
            "expected_nodes": ["doublecolon::Class2.func_a",
                               "doublecolon::(global)",
                               "doublecolon::Class1.func_b",
                               "doublecolon::Class1.func_a",
                               "doublecolon::Class2.func_b"]
        },
        {
            "test_name": "weird_chains",
            "directory": "weird_chains",
            "expected_edges": [["weird_chains::(global)", "weird_chains::DivByTwo.result"],
                               ["weird_chains::(global)", "weird_chains::DivByTwo.-"],
                               ["weird_chains::(global)",
                                "weird_chains::DivByTwo.initialize"],
                               ["weird_chains::(global)", "weird_chains::DivByTwo.*"],
                               ["weird_chains::(global)", "weird_chains::DivByTwo.+"]],
            "expected_nodes": ["weird_chains::DivByTwo.+",
                               "weird_chains::DivByTwo.*",
                               "weird_chains::DivByTwo.-",
                               "weird_chains::DivByTwo.result",
                               "weird_chains::DivByTwo.initialize",
                               "weird_chains::(global)"]
        },
        {
            "test_name": "onelinefile",
            "directory": "onelinefile",
            "comment": "Including this because the ruby ast treats single line stuff different from multiline. Also there is a lambda",
            "expected_edges": [],
            "expected_nodes": []
        },
        {
            "test_name": "nested",
            "directory": "nested",
            "expected_edges": [["nested::Nested.initialize", "nested::Nested.func_1"],
                               ["nested::(global)", "nested::Nested.func_2"],
                               ["nested::(global)", "nested::Mod.func_1"],
                               ["nested::Nested.func_2", "nested::Mod.func_2"],
                               ["nested::func_1", "nested::func_2"],
                               ["nested::(global)", "nested::Nested.initialize"],
                               ["nested::Nested.func_2", "nested::Nested.func_1"],
                               ["nested::func_2", "nested::func_1"],
                               ["nested::Nested.func_1", "nested::Mod.func_1"]],
            "expected_nodes": ["nested::Mod.func_1",
                               "nested::func_2",
                               "nested::Nested.func_1",
                               "nested::func_1",
                               "nested::Nested.initialize",
                               "nested::(global)",
                               "nested::Mod.func_2",
                               "nested::Nested.func_2"]
        },
        {
            "test_name": "nested_classes",
            "directory": "nested_classes",
            "comment": "like the last nested test but with classes instead of modules",
            "expected_edges": [["nested_classes::(global)", "nested_classes::Mod.func_1"],
                               ["nested_classes::Nested.func_1",
                                "nested_classes::Mod.func_1"],
                               ["nested_classes::Nested.func_2",
                                "nested_classes::Mod.func_2"],
                               ["nested_classes::(global)",
                                "nested_classes::Nested.initialize"],
                               ["nested_classes::func_1", "nested_classes::func_2"],
                               ["nested_classes::Nested.func_2",
                                "nested_classes::Nested.func_1"],
                               ["nested_classes::func_2", "nested_classes::func_1"],
                               ["nested_classes::Nested.initialize",
                                "nested_classes::Nested.func_1"],
                               ["nested_classes::(global)",
                                "nested_classes::Nested.func_2"]],
            "expected_nodes": ["nested_classes::Mod.func_1",
                               "nested_classes::func_1",
                               "nested_classes::func_2",
                               "nested_classes::Nested.func_2",
                               "nested_classes::Nested.initialize",
                               "nested_classes::Mod.func_2",
                               "nested_classes::(global)",
                               "nested_classes::Nested.func_1"]
        },
        {
            "test_name": "inheritance_2",
            "directory": "inheritance_2",
            "comment": "The '<' style of inheritance",
            "expected_edges": [["inheritance_2::Cat.meow", "inheritance_2::Animal.speak"],
                               ["inheritance_2::(global)", "inheritance_2::Animal.speak"],
                               ["inheritance_2::(global)", "inheritance_2::Cat.meow"]],
            "expected_nodes": ["inheritance_2::Cat.meow",
                               "inheritance_2::Animal.speak",
                               "inheritance_2::(global)"]
        },
        {
            "test_name": "split_modules",
            "directory": "split_modules",
            "expected_edges": [["split_modules_a::(global)",
                                "split_modules_b::MyClass.doit"],
                               ["split_modules_b::MyClass.doit",
                                "split_modules_a::Split.say_hi"],
                               ["split_modules_a::(global)",
                                "split_modules_b::MyClass.initialize"],
                               ["split_modules_a::Split.say_hi",
                                "split_modules_b::Split.say_bye"]],
            "expected_nodes": ["split_modules_b::MyClass.doit",
                               "split_modules_b::Split.say_bye",
                               "split_modules_b::MyClass.initialize",
                               "split_modules_a::(global)",
                               "split_modules_a::Split.say_hi"]
        },
        {
            "test_name": "public_suffix",
            "directory": "public_suffix",
            "expected_edges": [["domain::Domain.to_s", "domain::Domain.name"],
                               ["list::List.select", "list::List.size"],
                               ["public_suffix::PublicSuffix.normalize",
                                "list::List.empty?"],
                               ["domain::Domain.subdomain", "domain::Domain.subdomain?"],
                               ["rule::Exception.decompose", "rule::Exception.parts"],
                               ["domain::Domain.name_to_labels", "domain::Domain.to_s"],
                               ["list::List.select", "domain::Domain.to_s"],
                               ["public_suffix::PublicSuffix.decompose",
                                "domain::Domain.initialize"],
                               ["rule::Normal.decompose", "domain::Domain.to_s"],
                               ["list::List.clear", "list::List.clear"],
                               ["list::List.empty?", "list::List.empty?"],
                               ["list::List.select", "list::List.entry_to_rule"],
                               ["rule::Base.initialize", "domain::Domain.to_s"],
                               ["list::List.each", "list::List.entry_to_rule"],
                               ["domain::Domain.domain", "domain::Domain.domain?"],
                               ["list::List.find", "list::List.select"],
                               ["public_suffix::PublicSuffix.parse",
                                "public_suffix::PublicSuffix.decompose"],
                               ["public_suffix::PublicSuffix.normalize",
                                "domain::Domain.to_s"],
                               ["public_suffix::PublicSuffix.valid?",
                                "public_suffix::PublicSuffix.normalize"],
                               ["rule::Wildcard.decompose", "domain::Domain.to_s"],
                               ["rule::Rule.default", "rule::Rule.factory"],
                               ["list::List.size", "list::List.size"],
                               ["rule::Wildcard.decompose", "rule::Wildcard.parts"],
                               ["rule::Base.match?", "list::List.empty?"],
                               ["list::List.parse", "list::List.add"],
                               ["public_suffix::PublicSuffix.decompose",
                                "list::List.empty?"],
                               ["public_suffix::PublicSuffix.valid?", "list::List.find"],
                               ["public_suffix::PublicSuffix.domain",
                                "public_suffix::PublicSuffix.parse"],
                               ["rule::Exception.build", "domain::Domain.to_s"],
                               ["list::List.each", "list::List.each"],
                               ["public_suffix::PublicSuffix.parse",
                                "public_suffix::PublicSuffix.normalize"],
                               ["rule::Normal.decompose", "rule::Normal.parts"],
                               ["rule::Exception.decompose", "domain::Domain.to_s"],
                               ["rule::Wildcard.build", "domain::Domain.to_s"],
                               ["list::List.parse", "list::List.empty?"],
                               ["list::List.parse", "rule::Rule.factory"],
                               ["public_suffix::PublicSuffix.parse", "list::List.find"],
                               ["list::List.default", "list::List.parse"],
                               ["rule::Rule.factory", "domain::Domain.to_s"],
                               ["list::List.add", "list::List.rule_to_entry"]],
            "expected_nodes": ["rule::Base.initialize",
                               "list::List.empty?",
                               "domain::Domain.initialize",
                               "domain::Domain.name",
                               "rule::Normal.parts",
                               "list::List.clear",
                               "list::List.select",
                               "list::List.default",
                               "rule::Wildcard.decompose",
                               "list::List.rule_to_entry",
                               "rule::Normal.decompose",
                               "public_suffix::PublicSuffix.domain",
                               "list::List.parse",
                               "list::List.add",
                               "domain::Domain.name_to_labels",
                               "list::List.entry_to_rule",
                               "list::List.each",
                               "rule::Wildcard.parts",
                               "public_suffix::PublicSuffix.valid?",
                               "rule::Base.match?",
                               "rule::Exception.decompose",
                               "rule::Rule.default",
                               "domain::Domain.domain",
                               "rule::Exception.build",
                               "domain::Domain.subdomain",
                               "public_suffix::PublicSuffix.parse",
                               "list::List.find",
                               "list::List.size",
                               "domain::Domain.to_s",
                               "domain::Domain.subdomain?",
                               "domain::Domain.domain?",
                               "rule::Rule.factory",
                               "public_suffix::PublicSuffix.decompose",
                               "rule::Exception.parts",
                               "rule::Wildcard.build",
                               "public_suffix::PublicSuffix.normalize"]
        }
    ],
    'php': [
        {
            "test_name": "simple_a",
            "directory": "simple_a",
            "expected_edges": [["simple_a::func_a", "simple_a::func_b"],
                               ["simple_a::(global)", "simple_a::func_a"]],
            "expected_nodes": ["simple_a::func_a",
                               "simple_a::func_b",
                               "simple_a::(global)"]
        },
        {
            "test_name": "simple_b",
            "directory": "simple_b",
            "expected_edges": [["simple_b::(global)", "simple_b::C.d"],
                               ["simple_b::a", "simple_b::b"],
                               ["simple_b::C.d", "simple_b::a"],
                               ["simple_b::b", "simple_b::a"]],
            "expected_nodes": ["simple_b::b",
                               "simple_b::(global)",
                               "simple_b::a",
                               "simple_b::C.d"]
        },
        {
            "test_name": "two_file_simple",
            "directory": "two_file_simple",
            "expected_edges": [["file_a::(global)", "file_a::a"],
                               ["file_a::a", "file_b::b"]],
            "expected_nodes": ["file_a::a", "file_b::b", "file_a::(global)"]
        },
        {
            "test_name": "resolve_correct_class",
            "directory": "resolve_correct_class",
            "expected_edges": [["rcc::Alpha.func_1", "rcc::Alpha.func_1"],
                               ["rcc::Alpha.func_1", "rcc::Beta.func_2"],
                               ["rcc::Beta.func_1", "rcc::Alpha.func_2"]],
            "expected_nodes": ["rcc::Beta.func_1",
                               "rcc::Beta.func_2",
                               "rcc::Alpha.func_2",
                               "rcc::Alpha.func_1"]
        },
        {
            "test_name": "ambiguous_resolution",
            "directory": "ambiguous_resolution",
            "expected_edges": [["ambiguous_resolution::main",
                                "ambiguous_resolution::Cadabra.cadabra_it"],
                               ["ambiguous_resolution::Cadabra.cadabra_it",
                                "ambiguous_resolution::Abra.abra_it"],
                               ["ambiguous_resolution::(global)",
                                "ambiguous_resolution::main"]],
            "expected_nodes": ["ambiguous_resolution::main",
                               "ambiguous_resolution::(global)",
                               "ambiguous_resolution::Abra.abra_it",
                               "ambiguous_resolution::Cadabra.cadabra_it"]
        },
        {
            "test_name": "chains",
            "directory": "chains",
            "expected_edges": [["chains::c", "chains::Cls.__construct"],
                               ["chains::a", "chains::b"],
                               ["chains::b", "chains::a"],
                               ["chains::c", "chains::Cls.a"],
                               ["chains::c", "chains::Cls.b"],
                               ["chains::(global)", "chains::c"],
                               ["chains::(global)", "chains::b"],
                               ["chains::(global)", "chains::a"]],
            "expected_nodes": ["chains::c",
                               "chains::Cls.b",
                               "chains::(global)",
                               "chains::a",
                               "chains::Cls.__construct",
                               "chains::b",
                               "chains::Cls.a"]
        },
        {
            "test_name": "publicprivateprotected",
            "directory": "publicprivateprotected",
            "comment": "Just ensuring that access modifiers don't confuse code2flow",
            "expected_edges": [["publicprivateprotected::set_color_weight",
                                "publicprivateprotected::Fruit.set_weight"],
                               ["publicprivateprotected::(global)",
                                "publicprivateprotected::set_color_weight"],
                               ["publicprivateprotected::(global)",
                                "publicprivateprotected::Fruit.set_name"],
                               ["publicprivateprotected::set_color_weight",
                                "publicprivateprotected::Fruit.set_color"]],
            "expected_nodes": ["publicprivateprotected::Fruit.set_color",
                               "publicprivateprotected::set_color_weight",
                               "publicprivateprotected::Fruit.set_weight",
                               "publicprivateprotected::Fruit.set_name",
                               "publicprivateprotected::(global)"]
        },
        {
            "test_name": "inheritance",
            "directory": "inheritance",
            "expected_edges": [["inheritance::Strawberry.message",
                                "inheritance::Fruit.getColor"],
                               ["inheritance::(global)",
                                "inheritance::Strawberry.message"],
                               ["inheritance::(global)", "inheritance::Fruit.intro"]],
            "expected_nodes": ["inheritance::Fruit.intro",
                               "inheritance::(global)",
                               "inheritance::Fruit.getColor",
                               "inheritance::Strawberry.message"]
        },
        {
            "test_name": "inheritance2",
            "directory": "inheritance2",
            "expected_edges": [["inheritance2::(global)", "inheritance2::Audi.intro"],
                               ["inheritance2::(global)", "inheritance2::Volvo.intro"],
                               ["inheritance2::(global)", "inheritance2::Audi.makeSound"],
                               ["inheritance2::(global)", "inheritance2::Citroen.intro"]],
            "expected_nodes": ["inheritance2::Audi.makeSound",
                               "inheritance2::Citroen.intro",
                               "inheritance2::Audi.intro",
                               "inheritance2::Volvo.intro",
                               "inheritance2::(global)"]
        },
        {
            "test_name": "traits",
            "directory": "traits",
            "expected_edges": [["traits::welcome2", "traits::message1.msg1"],
                               ["traits::welcome1", "traits::Welcome.__construct"],
                               ["traits::welcome2", "traits::message2.msg2"],
                               ["traits::welcome1", "traits::message1.msg1"]],
            "expected_nodes": ["traits::message1.msg1",
                               "traits::Welcome.__construct",
                               "traits::message2.msg2",
                               "traits::welcome2",
                               "traits::welcome1"]
        },
        {
            "test_name": "static",
            "directory": "static",
            "expected_edges": [["static::(global)", "static::Greeting.__construct"],
                               ["static::(global)", "static::Greeting.welcome"],
                               ["static::Greeting.__construct",
                                "static::Greeting.say_name"],
                               ["static::Greeting.__construct",
                                "static::Greeting.welcome"]],
            "expected_nodes": ["static::Greeting.__construct",
                               "static::(global)",
                               "static::Greeting.welcome",
                               "static::Greeting.say_name"]
        },
        {
            "test_name": "anon",
            "directory": "anon",
            "comment": "skip closure methods",
            "expected_edges": [["anonymous_function::(global)", "anonymous_function::a"]],
            "expected_nodes": ["anonymous_function::(global)", "anonymous_function::a"]
        },
        {
            "test_name": "anon2",
            "directory": "anon2",
            "expected_edges": [["anonymous_function2::(Closure)",
                                "anonymous_function2::func_a"]],
            "expected_nodes": ["anonymous_function2::(Closure)",
                               "anonymous_function2::func_a"]
        },
        {
            "test_name": "branch",
            "directory": "branch",
            "comment": "just a simple sub-block",
            "expected_edges": [["branch::(global)", "branch::a"]],
            "expected_nodes": ["branch::a", "branch::(global)"]
        },
        {
            "test_name": "factory",
            "directory": "factory",
            "expected_edges": [["factory::(Closure)", "currency::Currency.__construct"],
                               ["factory::(Closure)", "currency::Currency.getCode"],
                               ["factory::(Closure)", "currency::Money.contains"]],
            "expected_nodes": ["currency::Currency.getCode",
                               "currency::Money.contains",
                               "factory::(Closure)",
                               "currency::Currency.__construct"]
        },
        {
            "test_name": "nested",
            "directory": "nested",
            "expected_edges": [["nested::(global)", "nested::outer"],
                               ["nested::(global)", "nested::inner"]],
            "expected_nodes": ["nested::outer", "nested::inner", "nested::(global)"]
        },
        {
            "test_name": "namespace_a",
            "directory": "namespace_a",
            "expected_edges": [["namespace_a::NS.(global)",
                                "namespace_a::Namespaced_cls.__construct"],
                               ["namespace_a::NS.(global)",
                                "namespace_a::NS.namespaced_func"],
                               ["namespace_a::NS.(global)",
                                "namespace_a::Namespaced_cls.instance_method"]],
            "expected_nodes": ["namespace_a::NS.namespaced_func",
                               "namespace_a::Namespaced_cls.__construct",
                               "namespace_a::Namespaced_cls.instance_method",
                               "namespace_a::NS.(global)"]
        },
        {
            "test_name": "namespace_b",
            "directory": "namespace_b",
            "expected_edges": [["namespace_b1::(global)", "namespace_b2::Cat.says"],
                               ["namespace_b1::(global)", "namespace_b2::Animal.meows"],
                               ["namespace_b1::(global)", "namespace_b2::Cat.meows"]],
            "expected_nodes": ["namespace_b2::Cat.says",
                               "namespace_b1::(global)",
                               "namespace_b2::Animal.meows",
                               "namespace_b2::Cat.meows"]
        },
        {
            "test_name": "namespace_c",
            "directory": "namespace_c",
            "expected_edges": [["namespace_c1::(global)",
                                "namespace_c2::Outer.Inner.speak"],
                               ["namespace_c1::(global)", "namespace_c2::Cat.meow"]],
            "expected_nodes": ["namespace_c2::Outer.Inner.speak",
                               "namespace_c2::Cat.meow",
                               "namespace_c1::(global)"]
        },
        {
            "test_name": "nested_calls",
            "directory": "nested_calls",
            "test_name": "nested_calls",
            "directory": "nested_calls",
            "expected_edges": [["nested_calls::(global)", "nested_calls::Cls.func"],
                               ["nested_calls::x_", "nested_calls::Cls.func2"],
                               ["nested_calls::Cls.func", "nested_calls::Cls.a"],
                               ["nested_calls::Cls.func2", "nested_calls::z_"],
                               ["nested_calls::Cls.func2", "nested_calls::y_"],
                               ["nested_calls::Cls.func2", "nested_calls::x_"],
                               ["nested_calls::Cls.func", "nested_calls::Cls.c"],
                               ["nested_calls::Cls.func", "nested_calls::Cls.b"],
                               ["nested_calls::(global)", "nested_calls::func2"]],
            "expected_nodes": ["nested_calls::z_",
                               "nested_calls::Cls.a",
                               "nested_calls::x_",
                               "nested_calls::Cls.c",
                               "nested_calls::Cls.func2",
                               "nested_calls::func2",
                               "nested_calls::Cls.b",
                               "nested_calls::(global)",
                               "nested_calls::Cls.func",
                               "nested_calls::y_"]
        },
        {

            "test_name": "weird_assign",
            "directory": "weird_assign",
            "comment": "Not a complicated test but an unusual usecase",
            "expected_edges": [["weird_assign::c", "weird_assign::b"],
                               ["weird_assign::c", "weird_assign::a"]],
            "expected_nodes": ["weird_assign::c", "weird_assign::a", "weird_assign::b"]
        },
        {
            "test_name": "money",
            "directory": "money",
            "expected_edges": [["GmpCalculator::GmpCalculator.round",
                                "Number::Number.isCurrentEven"],
                               ["BcMathCalculator::BcMathCalculator.round",
                                "Number::Number.isHalf"],
                               ["Money::Money.greaterThan", "Money::Money.compare"],
                               ["IntlLocalizedDecimalFormatter::IntlLocalizedDecimalFormatter.format",
                                "Money::Money.getAmount"],
                               ["Number::Number.fromNumber", "Number::Number.__construct"],
                               ["IntlLocalizedDecimalParser::IntlLocalizedDecimalParser.parse",
                                "Money::Money.__construct"],
                               ["GmpCalculator::GmpCalculator.divide",
                                "InvalidArgumentException::InvalidArgumentException.divisionByZero"],
                               ["GmpCalculator::GmpCalculator.round",
                                "Number::Number.isInteger"],
                               ["CurrencyPair::CurrencyPair.createFromIso",
                                "Currency::Currency.__construct"],
                               ["BitcoinMoneyFormatter::BitcoinMoneyFormatter.format",
                                "Number::Number.roundMoneyValue"],
                               ["GmpCalculator::GmpCalculator.divide",
                                "Number::Number.getFractionalPart"],
                               ["IndirectExchange::IndirectExchange.getConversions",
                                "UnresolvableCurrencyPairException::UnresolvableCurrencyPairException.createFromCurrencies"],
                               ["GmpCalculator::GmpCalculator.round",
                                "Number::Number.fromString"],
                               ["BitcoinMoneyFormatter::BitcoinMoneyFormatter.format",
                                "Money::Money.getCurrency"],
                               ["DecimalMoneyParser::DecimalMoneyParser.parse",
                                "Money::Money.__construct"],
                               ["BcMathCalculator::BcMathCalculator.round",
                                "Number::Number.getIntegerRoundingMultiplier"],
                               ["GmpCalculator::GmpCalculator.compare",
                                "Number::Number.fromString"],
                               ["ReversedCurrenciesExchange::ReversedCurrenciesExchange.quote",
                                "CurrencyPair::CurrencyPair.getConversionRatio"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "Money::Money.getCurrency"],
                               ["BitcoinMoneyFormatter::BitcoinMoneyFormatter.format",
                                "Currency::Currency.getCode"],
                               ["FixedExchange::FixedExchange.quote",
                                "UnresolvableCurrencyPairException::UnresolvableCurrencyPairException.createFromCurrencies"],
                               ["Money::Money.allocate", "Money::Money.__construct"],
                               ["IntlMoneyParser::IntlMoneyParser.parse",
                                "Number::Number.roundMoneyValue"],
                               ["CurrencyList::CurrencyList.contains",
                                "Currency::Currency.getCode"],
                               ["Money::Money.min", "Money::Money.lessThan"],
                               ["Number::Number.fromNumber", "Number::Number.fromString"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "Currency::Currency.getCode"],
                               ["Money::Money.absolute", "Money::Money.__construct"],
                               ["GmpCalculator::GmpCalculator.share",
                                "GmpCalculator::GmpCalculator.multiply"],
                               ["ISOCurrencies::ISOCurrencies.subunitFor",
                                "ISOCurrencies::ISOCurrencies.contains"],
                               ["GmpCalculator::GmpCalculator.divide",
                                "Number::Number.isDecimal"],
                               ["SwapExchange::SwapExchange.quote",
                                "CurrencyPair::CurrencyPair.__construct"],
                               ["GmpCalculator::GmpCalculator.roundDigit",
                                "Number::Number.getIntegerPart"],
                               ["IntlMoneyFormatter::IntlMoneyFormatter.format",
                                "Money::Money.getCurrency"],
                               ["ISOCurrencies::ISOCurrencies.subunitFor",
                                "Currency::Currency.getCode"],
                               ["GmpCalculator::GmpCalculator.floor",
                                "Number::Number.getIntegerPart"],
                               ["BcMathCalculator::BcMathCalculator.floor",
                                "Number::Number.isInteger"],
                               ["IntlLocalizedDecimalParser::IntlLocalizedDecimalParser.parse",
                                "Number::Number.roundMoneyValue"],
                               ["Money::Money.divide", "Money::Money.__construct"],
                               ["Money::Money.max", "Money::Money.greaterThan"],
                               ["GmpCalculator::GmpCalculator.share",
                                "GmpCalculator::GmpCalculator.floor"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "CurrencyPair::CurrencyPair.getCounterCurrency"],
                               ["BitcoinMoneyParser::BitcoinMoneyParser.parse",
                                "Currency::Currency.__construct"],
                               ["BitcoinMoneyFormatter::BitcoinMoneyFormatter.format",
                                "Money::Money.getAmount"],
                               ["BcMathCalculator::BcMathCalculator.floor",
                                "Number::Number.fromString"],
                               ["DecimalMoneyParser::DecimalMoneyParser.parse",
                                "Number::Number.roundMoneyValue"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "Number::Number.fromString"],
                               ["Comparator::Comparator.__construct",
                                "IntlMoneyFormatter::IntlMoneyFormatter.__construct"],
                               ["Number::Number.base10", "Number::Number.__construct"],
                               ["GmpCalculator::GmpCalculator.round",
                                "Number::Number.getIntegerPart"],
                               ["BitcoinCurrencies::BitcoinCurrencies.contains",
                                "Currency::Currency.getCode"],
                               ["GmpCalculator::GmpCalculator.roundDigit",
                                "Number::Number.getIntegerRoundingMultiplier"],
                               ["GmpCalculator::GmpCalculator.compare",
                                "Number::Number.getIntegerPart"],
                               ["DecimalMoneyFormatter::DecimalMoneyFormatter.format",
                                "Money::Money.getCurrency"],
                               ["ISOCurrencies::ISOCurrencies.subunitFor",
                                "ISOCurrencies::ISOCurrencies.getCurrencies"],
                               ["GmpCalculator::GmpCalculator.roundDigit",
                                "Number::Number.isCloserToNext"],
                               ["GmpCalculator::GmpCalculator.compare",
                                "Number::Number.isDecimal"],
                               ["ISOCurrencies::ISOCurrencies.(Closure)",
                                "Currency::Currency.__construct"],
                               ["GmpCalculator::GmpCalculator.round",
                                "Number::Number.isHalf"],
                               ["ISOCurrencies::ISOCurrencies.contains",
                                "Currency::Currency.getCode"],
                               ["ReversedCurrenciesExchange::ReversedCurrenciesExchange.quote",
                                "Money::Money.getCalculator"],
                               ["GmpCalculator::GmpCalculator.ceil",
                                "Number::Number.isInteger"],
                               ["Number::Number.fromFloat", "Number::Number.fromString"],
                               ["Money::Money.roundToUnit", "Money::Money.__construct"],
                               ["Money::Money.negative", "Money::Money.__construct"],
                               ["GmpCalculator::GmpCalculator.round",
                                "GmpCalculator::GmpCalculator.roundDigit"],
                               ["UnresolvableCurrencyPairException::UnresolvableCurrencyPairException.createFromCurrencies",
                                "Currency::Currency.getCode"],
                               ["Money::Money.multiply", "Money::Money.__construct"],
                               ["FixedExchange::FixedExchange.quote",
                                "CurrencyPair::CurrencyPair.__construct"],
                               ["Converter::Converter.convert",
                                "Money::Money.getCurrency"],
                               ["GmpCalculator::GmpCalculator.roundDigit",
                                "GmpCalculator::GmpCalculator.add"],
                               ["IndirectExchange::IndirectExchange.getConversions",
                                "Currency::Currency.getCode"],
                               ["GmpCalculator::GmpCalculator.ceil",
                                "Number::Number.fromString"],
                               ["Money::Money.lessThan", "Money::Money.compare"],
                               ["GmpCalculator::GmpCalculator.floor",
                                "GmpCalculator::GmpCalculator.add"],
                               ["Money::Money.allocateTo", "Money::Money.allocate"],
                               ["CurrencyList::CurrencyList.(Closure)",
                                "Currency::Currency.__construct"],
                               ["Converter::Converter.convertAndReturnWithCurrencyPair",
                                "Money::Money.getCurrency"],
                               ["GmpCalculator::GmpCalculator.round",
                                "Number::Number.getIntegerRoundingMultiplier"],
                               ["BcMathCalculator::BcMathCalculator.roundDigit",
                                "Number::Number.getIntegerRoundingMultiplier"],
                               ["CurrencyList::CurrencyList.subunitFor",
                                "Currency::Currency.getCode"],
                               ["BcMathCalculator::BcMathCalculator.round",
                                "Number::Number.isInteger"],
                               ["ISOCurrencies::ISOCurrencies.numericCodeFor",
                                "ISOCurrencies::ISOCurrencies.contains"],
                               ["Number::Number.__construct",
                                "Number::Number.parseIntegerPart"],
                               ["ISOCurrencies::ISOCurrencies.numericCodeFor",
                                "Currency::Currency.getCode"],
                               ["BcMathCalculator::BcMathCalculator.roundDigit",
                                "Number::Number.isCloserToNext"],
                               ["BcMathCalculator::BcMathCalculator.share",
                                "BcMathCalculator::BcMathCalculator.floor"],
                               ["GmpCalculator::GmpCalculator.multiply",
                                "Number::Number.fromString"],
                               ["FixedExchange::FixedExchange.quote",
                                "Currency::Currency.getCode"],
                               ["GmpCalculator::GmpCalculator.share",
                                "GmpCalculator::GmpCalculator.divide"],
                               ["BcMathCalculator::BcMathCalculator.mod",
                                "InvalidArgumentException::InvalidArgumentException.moduloByZero"],
                               ["Money::Money.subtract", "Money::Money.__construct"],
                               ["IntlMoneyFormatter::IntlMoneyFormatter.format",
                                "Currency::Currency.getCode"],
                               ["Converter::Converter.convertAndReturnWithCurrencyPair",
                                "Converter::Converter.convertAgainstCurrencyPair"],
                               ["GmpCalculator::GmpCalculator.compare",
                                "Number::Number.getFractionalPart"],
                               ["IntlMoneyParser::IntlMoneyParser.parse",
                                "Currency::Currency.__construct"],
                               ["ISOCurrencies::ISOCurrencies.contains",
                                "ISOCurrencies::ISOCurrencies.getCurrencies"],
                               ["IndirectExchange::IndirectExchange.quote",
                                "IndirectExchange::IndirectExchange.getConversions"],
                               ["GmpCalculator::GmpCalculator.divide",
                                "GmpCalculator::GmpCalculator.compare"],
                               ["ISOCurrencies::ISOCurrencies.getIterator",
                                "ISOCurrencies::ISOCurrencies.getCurrencies"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "Money::Money.getAmount"],
                               ["GmpCalculator::GmpCalculator.round",
                                "GmpCalculator::GmpCalculator.add"],
                               ["GmpCalculator::GmpCalculator.mod",
                                "GmpCalculator::GmpCalculator.compare"],
                               ["Money::Money.equals", "Money::Money.compare"],
                               ["GmpCalculator::GmpCalculator.divide",
                                "Number::Number.__construct"],
                               ["IndirectExchange::IndirectExchange.(Closure)",
                                "CurrencyPair::CurrencyPair.getConversionRatio"],
                               ["Money::Money.__construct", "Number::Number.isInteger"],
                               ["IntlMoneyFormatter::IntlMoneyFormatter.format",
                                "Money::Money.getAmount"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "CurrencyPair::CurrencyPair.getConversionRatio"],
                               ["ISOCurrencies::ISOCurrencies.numericCodeFor",
                                "ISOCurrencies::ISOCurrencies.getCurrencies"],
                               ["CurrencyList::CurrencyList.subunitFor",
                                "CurrencyList::CurrencyList.contains"],
                               ["ExchangerExchange::ExchangerExchange.quote",
                                "UnresolvableCurrencyPairException::UnresolvableCurrencyPairException.createFromCurrencies"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "Number::Number.base10"],
                               ["IntlLocalizedDecimalFormatter::IntlLocalizedDecimalFormatter.format",
                                "Money::Money.getCurrency"],
                               ["Money::Money.__construct", "Number::Number.fromString"],
                               ["Number::Number.__construct",
                                "Number::Number.parseFractionalPart"],
                               ["GmpCalculator::GmpCalculator.ceil",
                                "Number::Number.getIntegerPart"],
                               ["Money::Money.add", "Money::Money.__construct"],
                               ["GmpCalculator::GmpCalculator.mod",
                                "GmpCalculator::GmpCalculator.absolute"],
                               ["BcMathCalculator::BcMathCalculator.round",
                                "Number::Number.isCurrentEven"],
                               ["GmpCalculator::GmpCalculator.multiply",
                                "Number::Number.getIntegerPart"],
                               ["IndirectExchange::IndirectExchange.getConversions",
                                "IndirectExchangeQueuedItem::IndirectExchangeQueuedItem.__construct"],
                               ["GmpCalculator::GmpCalculator.mod",
                                "InvalidArgumentException::InvalidArgumentException.moduloByZero"],
                               ["GmpCalculator::GmpCalculator.divide",
                                "Number::Number.fromString"],
                               ["GmpCalculator::GmpCalculator.multiply",
                                "Number::Number.isDecimal"],
                               ["MoneyFactory::MoneyFactory.__callStatic",
                                "Currency::Currency.__construct"],
                               ["BitcoinMoneyParser::BitcoinMoneyParser.parse",
                                "Money::Money.__construct"],
                               ["GmpCalculator::GmpCalculator.mod",
                                "Number::Number.fromString"],
                               ["Money::Money.divide", "Money::Money.round"],
                               ["BcMathCalculator::BcMathCalculator.divide",
                                "InvalidArgumentException::InvalidArgumentException.divisionByZero"],
                               ["DecimalMoneyFormatter::DecimalMoneyFormatter.format",
                                "Money::Money.getAmount"],
                               ["BitcoinCurrencies::BitcoinCurrencies.subunitFor",
                                "Currency::Currency.getCode"],
                               ["Number::Number.fromString", "Number::Number.__construct"],
                               ["BcMathCalculator::BcMathCalculator.ceil",
                                "Number::Number.isInteger"],
                               ["Converter::Converter.convert",
                                "Converter::Converter.convertAgainstCurrencyPair"],
                               ["IndirectExchange::IndirectExchange.getConversions",
                                "IndirectExchange::IndirectExchange.reconstructConversionChain"],
                               ["Comparator::Comparator.__construct",
                                "AggregateCurrencies::AggregateCurrencies.__construct"],
                               ["BcMathCalculator::BcMathCalculator.round",
                                "Number::Number.fromString"],
                               ["BcMathCalculator::BcMathCalculator.round",
                                "BcMathCalculator::BcMathCalculator.roundDigit"],
                               ["BcMathCalculator::BcMathCalculator.ceil",
                                "Number::Number.fromString"],
                               ["IndirectExchange::IndirectExchange.reconstructConversionChain",
                                "Currency::Currency.getCode"],
                               ["Money::Money.lessThanOrEqual", "Money::Money.compare"],
                               ["IndirectExchange::IndirectExchange.quote",
                                "CurrencyPair::CurrencyPair.__construct"],
                               ["IndirectExchange::IndirectExchange.(Closure)",
                                "Money::Money.getCalculator"],
                               ["Money::Money.greaterThanOrEqual", "Money::Money.compare"],
                               ["Money::Money.__construct",
                                "Number::Number.getIntegerPart"],
                               ["GmpCalculator::GmpCalculator.multiply",
                                "Number::Number.getFractionalPart"],
                               ["AggregateMoneyFormatter::AggregateMoneyFormatter.format",
                                "Money::Money.getCurrency"],
                               ["GmpCalculator::GmpCalculator.ceil",
                                "GmpCalculator::GmpCalculator.add"],
                               ["ExchangerExchange::ExchangerExchange.quote",
                                "CurrencyPair::CurrencyPair.__construct"],
                               ["ReversedCurrenciesExchange::ReversedCurrenciesExchange.quote",
                                "CurrencyPair::CurrencyPair.__construct"],
                               ["AggregateMoneyFormatter::AggregateMoneyFormatter.format",
                                "Currency::Currency.getCode"],
                               ["GmpCalculator::GmpCalculator.divide",
                                "Number::Number.getIntegerPart"],
                               ["MoneyFactory::MoneyFactory.__callStatic",
                                "Money::Money.__construct"],
                               ["Money::Money.multiply", "Money::Money.round"],
                               ["SwapExchange::SwapExchange.quote",
                                "UnresolvableCurrencyPairException::UnresolvableCurrencyPairException.createFromCurrencies"],
                               ["Money::Money.mod", "Money::Money.__construct"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "Money::Money.__construct"],
                               ["GmpCalculator::GmpCalculator.floor",
                                "Number::Number.isInteger"],
                               ["ExchangerExchange::ExchangerExchange.quote",
                                "Currency::Currency.getCode"],
                               ["BitcoinCurrencies::BitcoinCurrencies.getIterator",
                                "Currency::Currency.__construct"],
                               ["Converter::Converter.convertAgainstCurrencyPair",
                                "CurrencyPair::CurrencyPair.getBaseCurrency"],
                               ["CurrencyPair::CurrencyPair.createFromIso",
                                "CurrencyPair::CurrencyPair.__construct"],
                               ["ISOCurrencies::ISOCurrencies.getCurrencies",
                                "ISOCurrencies::ISOCurrencies.loadCurrencies"],
                               ["Money::Money.ratioOf", "Money::Money.isZero"],
                               ["IntlMoneyParser::IntlMoneyParser.parse",
                                "Money::Money.__construct"],
                               ["GmpCalculator::GmpCalculator.floor",
                                "Number::Number.fromString"]],
            "expected_nodes": ["GmpCalculator::GmpCalculator.add",
                               "FixedExchange::FixedExchange.quote",
                               "Number::Number.roundMoneyValue",
                               "CurrencyPair::CurrencyPair.getBaseCurrency",
                               "ISOCurrencies::ISOCurrencies.loadCurrencies",
                               "Number::Number.isCloserToNext",
                               "GmpCalculator::GmpCalculator.roundDigit",
                               "Money::Money.greaterThan",
                               "Money::Money.subtract",
                               "Money::Money.lessThanOrEqual",
                               "CurrencyList::CurrencyList.subunitFor",
                               "BcMathCalculator::BcMathCalculator.ceil",
                               "Money::Money.equals",
                               "Number::Number.isHalf",
                               "Comparator::Comparator.__construct",
                               "IndirectExchange::IndirectExchange.reconstructConversionChain",
                               "Number::Number.__construct",
                               "GmpCalculator::GmpCalculator.share",
                               "Number::Number.getIntegerRoundingMultiplier",
                               "Number::Number.isDecimal",
                               "InvalidArgumentException::InvalidArgumentException.moduloByZero",
                               "Money::Money.mod",
                               "Converter::Converter.convertAgainstCurrencyPair",
                               "BitcoinCurrencies::BitcoinCurrencies.getIterator",
                               "GmpCalculator::GmpCalculator.compare",
                               "IntlLocalizedDecimalParser::IntlLocalizedDecimalParser.parse",
                               "Money::Money.multiply",
                               "Money::Money.divide",
                               "Money::Money.isZero",
                               "Number::Number.fromNumber",
                               "BcMathCalculator::BcMathCalculator.roundDigit",
                               "IntlMoneyFormatter::IntlMoneyFormatter.format",
                               "BcMathCalculator::BcMathCalculator.mod",
                               "ISOCurrencies::ISOCurrencies.(Closure)",
                               "BitcoinCurrencies::BitcoinCurrencies.contains",
                               "Money::Money.getCurrency",
                               "IndirectExchange::IndirectExchange.(Closure)",
                               "Money::Money.__construct",
                               "Number::Number.fromFloat",
                               "Money::Money.allocate",
                               "BitcoinMoneyFormatter::BitcoinMoneyFormatter.format",
                               "Money::Money.lessThan",
                               "ISOCurrencies::ISOCurrencies.contains",
                               "Money::Money.add",
                               "ReversedCurrenciesExchange::ReversedCurrenciesExchange.quote",
                               "Number::Number.parseFractionalPart",
                               "Currency::Currency.__construct",
                               "ISOCurrencies::ISOCurrencies.subunitFor",
                               "Money::Money.ratioOf",
                               "Number::Number.isInteger",
                               "SwapExchange::SwapExchange.quote",
                               "BitcoinMoneyParser::BitcoinMoneyParser.parse",
                               "IndirectExchange::IndirectExchange.quote",
                               "Number::Number.base10",
                               "CurrencyPair::CurrencyPair.createFromIso",
                               "Number::Number.isCurrentEven",
                               "DecimalMoneyParser::DecimalMoneyParser.parse",
                               "GmpCalculator::GmpCalculator.divide",
                               "ISOCurrencies::ISOCurrencies.numericCodeFor",
                               "AggregateCurrencies::AggregateCurrencies.__construct",
                               "GmpCalculator::GmpCalculator.floor",
                               "Money::Money.negative",
                               "Number::Number.getFractionalPart",
                               "Money::Money.roundToUnit",
                               "CurrencyList::CurrencyList.(Closure)",
                               "ISOCurrencies::ISOCurrencies.getIterator",
                               "IndirectExchange::IndirectExchange.getConversions",
                               "InvalidArgumentException::InvalidArgumentException.divisionByZero",
                               "Money::Money.compare",
                               "CurrencyPair::CurrencyPair.__construct",
                               "AggregateMoneyFormatter::AggregateMoneyFormatter.format",
                               "DecimalMoneyFormatter::DecimalMoneyFormatter.format",
                               "BcMathCalculator::BcMathCalculator.floor",
                               "Money::Money.getCalculator",
                               "BcMathCalculator::BcMathCalculator.divide",
                               "IndirectExchangeQueuedItem::IndirectExchangeQueuedItem.__construct",
                               "MoneyFactory::MoneyFactory.__callStatic",
                               "Money::Money.greaterThanOrEqual",
                               "Money::Money.min",
                               "Converter::Converter.convert",
                               "ISOCurrencies::ISOCurrencies.getCurrencies",
                               "GmpCalculator::GmpCalculator.absolute",
                               "Money::Money.absolute",
                               "IntlMoneyParser::IntlMoneyParser.parse",
                               "Number::Number.fromString",
                               "Money::Money.max",
                               "GmpCalculator::GmpCalculator.mod",
                               "UnresolvableCurrencyPairException::UnresolvableCurrencyPairException.createFromCurrencies",
                               "CurrencyPair::CurrencyPair.getConversionRatio",
                               "Money::Money.getAmount",
                               "IntlMoneyFormatter::IntlMoneyFormatter.__construct",
                               "GmpCalculator::GmpCalculator.ceil",
                               "ExchangerExchange::ExchangerExchange.quote",
                               "Money::Money.round",
                               "GmpCalculator::GmpCalculator.multiply",
                               "GmpCalculator::GmpCalculator.round",
                               "BcMathCalculator::BcMathCalculator.share",
                               "IntlLocalizedDecimalFormatter::IntlLocalizedDecimalFormatter.format",
                               "Converter::Converter.convertAndReturnWithCurrencyPair",
                               "BcMathCalculator::BcMathCalculator.round",
                               "CurrencyList::CurrencyList.contains",
                               "Number::Number.parseIntegerPart",
                               "Currency::Currency.getCode",
                               "CurrencyPair::CurrencyPair.getCounterCurrency",
                               "Money::Money.allocateTo",
                               "BitcoinCurrencies::BitcoinCurrencies.subunitFor",
                               "Number::Number.getIntegerPart"]
        }
    ]
}
