# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project you agree to abide by its terms.

If you are new to open source, I've written a [guide for how to contribute](https://css-tricks.com/how-to-contribute-to-an-open-source-project/).

> The pull request should have a useful title. Pull requests with `Update readme.md` as title will be closed. Please carefully read everything in `Adding to this list`.

## Table of Contents

- [Adding to this list](#adding-to-this-list)
- [Updating your Pull Request](#updating-your-pull-request)

## Adding to this list

Please ensure your pull request adheres to the following guidelines:

- Please submit your contribution at the end of the list of the relevant category. If you don't find a section that it belongs in, please make one.
- Please don't use a long description. The description should not wrap to 3 lines, ideally it should fit on one.
- Search previous suggestions before making a new one, as yours may be a duplicate. 
- Please don't use bold or italics unless it's somehow appropriate to the link.
- Make sure the list is useful before submitting. That implies it has enough content and every item has a good succinct description.
- Make an individual pull request for each suggestion.
- Use [Title Casing](https://titlecaseconverter.com/).
- Use the following format: `[List Name](link)`
- New categories or improvements to the existing categorization are welcome.
- Please check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- The pull request and commit should have a useful title.
- The body of your commit message should contain a link to the repository.

Thank you for your suggestions!

## Updating your Pull Request

Sometimes, we will ask you to edit your Pull Request before it is included. This is normally due to spelling errors or because your PR didn't match the awesome-actions list guidelines.

[Here](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) is a write up on how to change a Pull Request, and the different ways you can do that.
