# Table of Contents

* [Welcome to Amica!](welcome.md)

## 🌸 Overview

* [How Amica Works](./overview/how-amica-works.md)
* [Core Features](./overview/core-features.md)
* [Amica Life](./overview/amica-life.md)
* [Emotion System](./overview/emotion-system.md)
* [Other Features](./overview/other-features.md)
* [Use Cases](./overview/use-cases.md)
* [Amica vs Other Tools](./overview/amica-vs-other-tools.md)

## 🌳 Getting Started

* [Quickstart Guide](./getting-started/quickstart.md)
* [Installing Amica](./getting-started/installation.md)
* [Next Steps](./getting-started/next-steps.md)

## 🗣️ Connecting LLMs (Your Core AI Chatbot Model)

* [Using LM Studio](./guides/using-lm-studio.md)
* [Using LLaMA.cpp](./guides/using-llamacpp.md)
* [Using Ollama](./guides/using-ollama.md)
* [Using KoboldCpp](./guides/using-koboldcpp.md)
* [Using OpenAI](./guides/using-openai.md)
* [Using Oobabooga](./guides/using-oobabooga.md)
* [Using OpenRouter](./guides/using-openrouter.md)

## 🔊 Connecting Speech Options (TTS)

* [Using SpeechT5](./guides/using-speecht5.md)
* [Using ElevenLabs](./guides/using-elevenlabs.md)
* [Using Coqui Local](./guides/using-coqui.md)
* [Using Piper ](./guides/using-piper.md)
* [Using Alltalk TTS](./guides/using-alltalk.md)
* [Using Kokoro TTS](./guides/using-kokoro.md)
* [Using RVC](./guides/using-rvc.md)


## 👂 Connecting Microphone Options (STT)

* [Using whisper.cpp](./guides/using-whispercpp.md)

## 👁️ Connecting Multi-Modal Modules

* [Using LLaVA](./guides/using-llava.md)

## 🔧 Other Guides

* [Using Window.ai](./guides/using-windowai.md)
* [Using Moshi (Voice to Voice)](./guides/using-moshi.md)

## 🧩 Plugin System 

* [Plugins Intro](./plugin-system/plugin-intro.md)
* [Getting Real World News on Amica](./plugin-system/news-example.md)

## 🔌 API System

* [External API for Agents](./api/api-reference.md)


## 🌻 Tutorials

* [Creating new Avatars](./tutorials/creating-new-avatars.md)
* [Using Custom Assets](./tutorials/using-custom-assets.md)

## 🌺 Contributing to Amica

* [Setting up your developer environment](./contributing/setup-dev-env.md)
* [Contributing to the Docs](./contributing/contributing-to-the-docs.md)
* [Developing Amica](./contributing/developing-amica.md)
* [Adding Translations](./contributing/adding-translations.md)
