<div align="center">
  <a href="https://vshymanskyy.github.io/StandWithUkraine">
    <img src="https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/banner2-direct.svg" alt="Stand With Ukraine" />
  </a>
  
  <img src="./icons/icon.png">
  <h1>Awesome macOS Open Source Applications</h1>
  <p>A curated list of open source applications for macOS</p>
  <p>
    <a href="https://github.com/sindresorhus/awesome"><img alt="Awesome" src="https://awesome.re/badge.svg" /></a>
    <a href="https://gitter.im/open-source-mac-os-apps/Lobby"><img alt="Join the chat at gitter" src="https://badges.gitter.im/Join%20Chat.svg" /></a>
    <a href="https://t.me/opensourcemacosapps"><img alt="Telegram Channel" src="https://img.shields.io/badge/Telegram-Channel-blue.svg" /></a>
  </p>
  <p>
    <img src="https://img.shields.io/badge/Total%20Apps-617-blue" alt="Total Apps"/>
    <img src="https://img.shields.io/badge/Categories-49-green" alt="Categories"/>
    <img src="https://img.shields.io/badge/Last%20Updated-December%207,%202025-orange" alt="Last Updated"/>
  </p>
</div>

<p align="center">
  <a href="#audio">Audio</a> •
  <a href="#backup">Backup</a> •
  <a href="#browser">Browser</a> •
  <a href="#chat">Chat</a> •
  <a href="#cryptocurrency">Crypto</a> •
  <a href="#database">Database</a> •
  <a href="#development">Dev</a> •
  <a href="#editors">Editors</a> •
  <a href="#graphics">Graphics</a> •
  <a href="#productivity">Productivity</a> •
  <a href="#utilities">Utilities</a>
</p>

List of awesome open source applications for macOS. This list contains a lot of native, and cross-platform apps. The main goal of this repository is to find free open source apps and start contributing. Feel free to [contribute](CONTRIBUTING.md) to the list, any suggestions are welcome!

To receive all new or popular applications you can join our [telegram channel](https://t.me/opensourcemacosapps).

## Support

Hey friend! Help me out for a couple of :beers:!  <span class="badge-patreon"><a href="https://www.patreon.com/serhiilondar" title="Donate to this project using Patreon"><img src="https://img.shields.io/badge/patreon-donate-yellow.svg" alt="Patreon donate button" /></a></span>

## 📊 Statistics

| Metric | Count |
|--------|-------|
| 📱 Total Applications | 617 |
| 📂 Categories | 49 |
| 🔝 Top Languages | Swift: 271 • Objective-C: 134 • Javascript: 108 • C++: 54 • C: 34 |

## Languages

You can see in which language an app is written. Currently there are following languages:

| Language | Icon |
|----------|------|
| C | <img src='./icons/c-16.png' alt='C' height='16'/> |
| C++ | <img src='./icons/cpp-16.png' alt='C++' height='16'/> |
| C# | <img src='./icons/csharp-16.png' alt='C#' height='16'/> |
| Clojure | <img src='./icons/clojure-16.png' alt='Clojure' height='16'/> |
| CoffeeScript | <img src='./icons/coffeescript-16.png' alt='CoffeeScript' height='16'/> |
| CSS | <img src='./icons/css-16.png' alt='CSS' height='16'/> |
| Elm | <img src='./icons/elm-16.png' alt='Elm' height='16'/> |
| Go | <img src='./icons/golang-16.png' alt='Go' height='16'/> |
| Haskell | <img src='./icons/haskell-16.png' alt='Haskell' height='16'/> |
| Java | <img src='./icons/java-16.png' alt='Java' height='16'/> |
| JavaScript | <img src='./icons/javascript-16.png' alt='JavaScript' height='16'/> |
| Lua | <img src='./icons/Lua-16.png' alt='Lua' height='16'/> |
| Objective-C | <img src='./icons/objective-c-16.png' alt='Objective-C' height='16'/> |
| Python | <img src='./icons/python-16.png' alt='Python' height='16'/> |
| Ruby | <img src='./icons/ruby-16.png' alt='Ruby' height='16'/> |
| Rust | <img src='./icons/rust-16.png' alt='Rust' height='16'/> |
| Shell | <img src='./icons/shell-16.png' alt='Shell' height='16'/> |
| Swift | <img src='./icons/swift-16.png' alt='Swift' height='16'/> |
| TypeScript | <img src='./icons/typescript-16.png' alt='TypeScript' height='16'/> |


## Contents
- [Audio](#audio)
- [Backup](#backup)
- [Browser](#browser)
- [Chat](#chat)
- [Cryptocurrency](#cryptocurrency)
- [Database](#database)
- [Development](#development)
- [Git](#git)
- [iOS / macOS](#ios--macos)
- [JSON Parsing](#json-parsing)
- [Web development](#web-development)
- [Other development](#other-development)
- [Downloader](#downloader)
- [Editors](#editors)
- [CSV](#csv)
- [JSON](#json)
- [Markdown](#markdown)
- [TeX](#tex)
- [Text](#text)
- [Extensions](#extensions)
- [Finder](#finder)
- [Games](#games)
- [Graphics](#graphics)
- [IDE](#ide)
- [Images](#images)
- [Keyboard](#keyboard)
- [Mail](#mail)
- [Menubar](#menubar)
- [Music](#music)
- [News](#news)
- [Notes](#notes)
- [Other](#other)
- [Podcast](#podcast)
- [Productivity](#productivity)
- [Screensaver](#screensaver)
- [Security](#security)
- [Sharing Files](#sharing-files)
- [Social Networking](#social-networking)
- [Streaming](#streaming)
- [System](#system)
- [Terminal](#terminal)
- [Touch Bar](#touch-bar)
- [Utilities](#utilities)
- [VPN & Proxy](#vpn--proxy)
- [Video](#video)
- [Wallpaper](#wallpaper)
- [Window Management](#window-management)

## Applications

<a id="audio"></a>
### 🎵 Audio (36)
- [[Un]MuteMic](https://github.com/CocoaHeadsBrasil/MuteUnmuteMic) - macOS app to mute & unmute the input volume of your microphone. Perfect for podcasters.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/CocoaHeadsBrasil/MuteUnmuteMic/releases/latest'><img src='https://img.shields.io/github/v/release/CocoaHeadsBrasil/MuteUnmuteMic?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/CocoaHeadsBrasil/MuteUnmuteMic'><img src='https://img.shields.io/github/stars/CocoaHeadsBrasil/MuteUnmuteMic?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/CocoaHeadsBrasil/MuteUnmuteMic' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/235208/10419593/143171fc-704a-11e5-8270-374ca898685b.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Audacity](https://github.com/audacity/audacity) - Free, open source, cross-platform audio software

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/audacity/audacity/releases/latest'><img src='https://img.shields.io/github/v/release/audacity/audacity?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/audacity/audacity'><img src='https://img.shields.io/github/stars/audacity/audacity?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/audacity/audacity' alt='License'/>

  **Website:** [https://www.audacityteam.org/](https://www.audacityteam.org/)

  **Screenshots:**

  <img src='https://www.audacityteam.org/wp-content/uploads/2017/12/Audacity-220-Mac-normal.png' width='400' loading='lazy'/>

  </p>
  </details>

- [AUHost](https://github.com/vgorloff/AUHost) - Application which hosts AudioUnits v3 using AVFoundation API. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/vgorloff/AUHost/releases/latest'><img src='https://img.shields.io/github/v/release/vgorloff/AUHost?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vgorloff/AUHost'><img src='https://img.shields.io/github/stars/vgorloff/AUHost?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vgorloff/AUHost' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/vgorloff/AUHost/master/Media/Screenshot-MainWindow.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Aural Player](https://github.com/kartik-venugopal/aural-player) - Aural Player is a audio player application for the macOS platform. Inspired by the classic Winamp player for Windows, it is designed to be to-the-point and easy to use. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/kartik-venugopal/aural-player/releases/latest'><img src='https://img.shields.io/github/v/release/kartik-venugopal/aural-player?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kartik-venugopal/aural-player'><img src='https://img.shields.io/github/stars/kartik-venugopal/aural-player?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kartik-venugopal/aural-player' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/maculateConception/aural-player/master/Documentation/Demos/mainDemo.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/maculateConception/aural-player/master/Documentation/Demos/playerView.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/maculateConception/aural-player/master/Documentation/Demos/ABLoop.gif' width='400' loading='lazy'/>

  *(5 more screenshots available in the repository)*

  </p>
  </details>

- [AutoMute](https://github.com/yonilevy/automute) - Automatically mute the sound when headphones disconnect / Mac awake from sleep.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/yonilevy/automute/releases/latest'><img src='https://img.shields.io/github/v/release/yonilevy/automute?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/yonilevy/automute'><img src='https://img.shields.io/github/stars/yonilevy/automute?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/yonilevy/automute' alt='License'/>

  **Website:** [https://yoni.ninja/automute/](https://yoni.ninja/automute/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/31284/49688097-ac653900-fb15-11e8-9c48-3db96df5dcbf.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/31284/49688098-ae2efc80-fb15-11e8-8034-14c67fb69d90.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Background Music](https://github.com/kyleneideck/BackgroundMusic) - Background Music, a macOS audio utility: automatically pause your music, set individual apps' volumes and record system audio. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/kyleneideck/BackgroundMusic/releases/latest'><img src='https://img.shields.io/github/v/release/kyleneideck/BackgroundMusic?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kyleneideck/BackgroundMusic'><img src='https://img.shields.io/github/stars/kyleneideck/BackgroundMusic?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kyleneideck/BackgroundMusic' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/kyleneideck/BackgroundMusic/master/Images/README/Screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [BlackHole](https://github.com/ExistentialAudio/BlackHole) - BlackHole is a modern macOS virtual audio driver that allows applications to pass audio to other applications with zero additional latency.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/ExistentialAudio/BlackHole/releases/latest'><img src='https://img.shields.io/github/v/release/ExistentialAudio/BlackHole?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ExistentialAudio/BlackHole'><img src='https://img.shields.io/github/stars/ExistentialAudio/BlackHole?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ExistentialAudio/BlackHole' alt='License'/>

  </p>
  </details>

- [CAM](https://github.com/hanayik/CAM) - macOS camera recording using ffmpeg 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/hanayik/CAM/releases/latest'><img src='https://img.shields.io/github/v/release/hanayik/CAM?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hanayik/CAM'><img src='https://img.shields.io/github/stars/hanayik/CAM?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hanayik/CAM' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/hanayik/CAM/master/gh-screenshots/1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/hanayik/CAM/master/gh-screenshots/2.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/hanayik/CAM/master/gh-screenshots/3.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Clementine](https://github.com/clementine-player/Clementine) - Clementine is a modern music player and library organizer for Windows, Linux and macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/clementine-player/Clementine/releases/latest'><img src='https://img.shields.io/github/v/release/clementine-player/Clementine?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/clementine-player/Clementine'><img src='https://img.shields.io/github/stars/clementine-player/Clementine?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/clementine-player/Clementine' alt='License'/>

  **Website:** [https://www.clementine-player.org/](https://www.clementine-player.org/)

  **Screenshots:**

  <img src='https://clementine-player.github.io/pages/images/screenshots/clementine-1.2-1.png' width='400' loading='lazy'/>

  <img src='https://clementine-player.github.io/pages/images/screenshots/clementine-1.2-2.png' width='400' loading='lazy'/>

  <img src='https://clementine-player.github.io/pages/images/screenshots/clementine-1.2-3.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Cog](https://bitbucket.org/losnoco/cog/src) - Cog is an open source audio player for macOS. The basic layout is a single-paned playlist interface with two retractable drawers, one for navigating the user's music folders and another for viewing audio file properties, like bitrate.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Website:** [https://cogx.org/](https://cogx.org/)

  </p>
  </details>

- [eqMac2](https://github.com/bitgapp/eqMac) - System-Wide Equalizer for the Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/bitgapp/eqMac/releases/latest'><img src='https://img.shields.io/github/v/release/bitgapp/eqMac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bitgapp/eqMac'><img src='https://img.shields.io/github/stars/bitgapp/eqMac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bitgapp/eqMac' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/8472525/29003031-13d1cd60-7aa7-11e7-9868-6afc36a34b52.jpg' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/8472525/33244041-488cf4b4-d2e8-11e7-986c-49826dd853e1.png' width='400' loading='lazy'/>

  </p>
  </details>

- [fre:ac](https://github.com/enzo1982/freac) - The fre:ac audio converter project. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/enzo1982/freac/releases/latest'><img src='https://img.shields.io/github/v/release/enzo1982/freac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/enzo1982/freac'><img src='https://img.shields.io/github/stars/enzo1982/freac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/enzo1982/freac' alt='License'/>

  **Screenshots:**

  <img src='https://freac.org/images/freac-ubuntu.png' width='400' loading='lazy'/>

  </p>
  </details>

- [iTunes-Volume-Control](https://github.com/alberti42/iTunes-Volume-Control) - This app allows you to control the iTunes volume using volume up and volume down hotkeys. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/alberti42/iTunes-Volume-Control/releases/latest'><img src='https://img.shields.io/github/v/release/alberti42/iTunes-Volume-Control?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alberti42/iTunes-Volume-Control'><img src='https://img.shields.io/github/stars/alberti42/iTunes-Volume-Control?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alberti42/iTunes-Volume-Control' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/0e72c553e7a1078295948921350e923e03f9a8f4/68747470733a2f2f7261772e6769746875622e636f6d2f616c626572746934322f6954756e65732d566f6c756d652d436f6e74726f6c2f6d61737465722f6954756e6573253230566f6c756d65253230436f6e74726f6c2f496d616765732f73637265656e73686f742e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [jmc](https://github.com/jcm93/jmc) - jmc is new macOS media organizer. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/jcm93/jmc/releases/latest'><img src='https://img.shields.io/github/v/release/jcm93/jmc?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jcm93/jmc'><img src='https://img.shields.io/github/stars/jcm93/jmc?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jcm93/jmc' alt='License'/>

  **Screenshots:**

  <img src='https://puu.sh/xoZYo/bd6d6deeb0.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/SJ5RgM5.png' width='400' loading='lazy'/>

  <img src='https://puu.sh/xoZHp/31dddfc751.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Karaoke Forever](https://github.com/bhj/KaraokeEternal) - Host awesome karaoke parties where everyone can queue songs from their phone's browser. Plays MP3+G and MP4 with WebGL visualizations.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/bhj/KaraokeEternal/releases/latest'><img src='https://img.shields.io/github/v/release/bhj/KaraokeEternal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bhj/KaraokeEternal'><img src='https://img.shields.io/github/stars/bhj/KaraokeEternal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bhj/KaraokeEternal' alt='License'/>

  **Website:** [https://www.karaoke-eternal.com/](https://www.karaoke-eternal.com/)

  **Screenshots:**

  <img src='https://github.com/bhj/KaraokeEternal/blob/master/docs/assets/images/README.jpg?raw=true' width='400' loading='lazy'/>

  </p>
  </details>

- [LocalRadio](https://github.com/dsward2/LocalRadio) - LocalRadio is software for listening to "Software-Defined Radio" on your Mac and mobile devices. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/dsward2/LocalRadio/releases/latest'><img src='https://img.shields.io/github/v/release/dsward2/LocalRadio?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dsward2/LocalRadio'><img src='https://img.shields.io/github/stars/dsward2/LocalRadio?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dsward2/LocalRadio' alt='License'/>

  **Screenshots:**

  <img src='https://cdn.jsdelivr.net/gh/dsward2/LocalRadio@d3eb87c/Documents/LocalRadio-animation.svg' width='400' loading='lazy'/>

  </p>
  </details>

- [LosslessCut](https://github.com/mifi/lossless-cut) - The swiss army knife of lossless video/audio editing without re-encoding.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/mifi/lossless-cut/releases/latest'><img src='https://img.shields.io/github/v/release/mifi/lossless-cut?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mifi/lossless-cut'><img src='https://img.shields.io/github/stars/mifi/lossless-cut?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mifi/lossless-cut' alt='License'/>

  **Website:** [https://mifi.no/losslesscut/](https://mifi.no/losslesscut/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mifi/lossless-cut/master/main_screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Lyricism](https://github.com/lyc2345/Lyricism) - macOS app to show you lyric what currently iTunes or Spotify is playing. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/lyc2345/Lyricism/releases/latest'><img src='https://img.shields.io/github/v/release/lyc2345/Lyricism?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lyc2345/Lyricism'><img src='https://img.shields.io/github/stars/lyc2345/Lyricism?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lyc2345/Lyricism' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/lyc2345/Lyricism/master/screenshot/Screen%20Shot%202016-09-20%20at%209.23.34%20AM.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/lyc2345/Lyricism/master/screenshot/Screen%20Shot%202016-07-21%20at%204.34.33%20PM.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/lyc2345/Lyricism/master/screenshot/Screen%20Shot%202016-09-20%20at%209.22.59%20AM.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [LyricsX](https://github.com/ddddxxx/LyricsX) - Lyrics for iTunes, Spotify and Vox. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ddddxxx/LyricsX/releases/latest'><img src='https://img.shields.io/github/v/release/ddddxxx/LyricsX?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ddddxxx/LyricsX'><img src='https://img.shields.io/github/stars/ddddxxx/LyricsX?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ddddxxx/LyricsX' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ddddxxx/LyricsX/master/docs/img/desktop_lyrics.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/ddddxxx/LyricsX/master/docs/img/preview_3.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/ddddxxx/LyricsX/master/docs/img/preview_2.jpg' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [MonitorControl](https://github.com/MonitorControl/MonitorControl) - Control your external monitor brightness, contrast or volume directly from a menulet or with keyboard native keys.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/MonitorControl/MonitorControl/releases/latest'><img src='https://img.shields.io/github/v/release/MonitorControl/MonitorControl?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/MonitorControl/MonitorControl'><img src='https://img.shields.io/github/stars/MonitorControl/MonitorControl?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/MonitorControl/MonitorControl' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/MonitorControl/MonitorControl/tree/master/.github' width='400' loading='lazy'/>

  </p>
  </details>

- [Mous Player](https://github.com/bsdelf/mous) - Simple yet powerful audio player for BSD/Linux/macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/bsdelf/mous/releases/latest'><img src='https://img.shields.io/github/v/release/bsdelf/mous?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bsdelf/mous'><img src='https://img.shields.io/github/stars/bsdelf/mous?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bsdelf/mous' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/bsdelf/mous/master/screenshot/qt-conv.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/bsdelf/mous/master/screenshot/qt5-macos.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/bsdelf/mous/master/screenshot/qt.png' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [MPV](https://github.com/mpv-player/mpv) - Lightweight, highly configurable media player.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/mpv-player/mpv/releases/latest'><img src='https://img.shields.io/github/v/release/mpv-player/mpv?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mpv-player/mpv'><img src='https://img.shields.io/github/stars/mpv-player/mpv?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mpv-player/mpv' alt='License'/>

  **Website:** [https://mpv.io](https://mpv.io)

  **Screenshots:**

  <img src='https://mpv.io/images/mpv-screenshot-34cd36ae.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [NoiseBuddy](https://github.com/insidegui/NoiseBuddy) - Control the listening mode on your AirPods Pro in the Touch Bar or Menu Bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/NoiseBuddy/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/NoiseBuddy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/NoiseBuddy'><img src='https://img.shields.io/github/stars/insidegui/NoiseBuddy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/NoiseBuddy' alt='License'/>

  </p>
  </details>

- [PlayStatus](https://github.com/nbolar/PlayStatus) - PlayStatus is a macOS app that allows the control of Spotify and iTunes music playback from the menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/nbolar/PlayStatus/releases/latest'><img src='https://img.shields.io/github/v/release/nbolar/PlayStatus?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nbolar/PlayStatus'><img src='https://img.shields.io/github/stars/nbolar/PlayStatus?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nbolar/PlayStatus' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/45484873/60389024-ece0d000-9ac2-11e9-8dbc-2376e905887f.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Plug](https://github.com/wulkano/Plug) - Discover and listen to music from Hype Machine.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/wulkano/Plug/releases/latest'><img src='https://img.shields.io/github/v/release/wulkano/Plug?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wulkano/Plug'><img src='https://img.shields.io/github/stars/wulkano/Plug?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wulkano/Plug' alt='License'/>

  **Website:** [https://www.plugformac.com/](https://www.plugformac.com/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wulkano/Plug/1ae6383ad9ad7026ce6fad4f1ea7ce3356c1f722/Media/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Scope](https://github.com/billthefarmer/audiotools/tree/master/Scope/swift) - Audio Oscilloscope

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/billthefarmer/audiotools/releases/latest'><img src='https://img.shields.io/github/v/release/billthefarmer/audiotools?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/billthefarmer/audiotools/tree/master/Scope/swift'><img src='https://img.shields.io/github/stars/billthefarmer/audiotools?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/billthefarmer/audiotools' alt='License'/>

  **Website:** [https://billthefarmer.github.io/audiotools/](https://billthefarmer.github.io/audiotools/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/billthefarmer/billthefarmer.github.io/master/images/audiotools/Scope-swift.png' width='400' loading='lazy'/>

  </p>
  </details>

- [shairport-sync](https://github.com/mikebrady/shairport-sync) - macOS/Linux/FreeBSD/OpenBSD Airplay audio receiver.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/mikebrady/shairport-sync/releases/latest'><img src='https://img.shields.io/github/v/release/mikebrady/shairport-sync?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mikebrady/shairport-sync'><img src='https://img.shields.io/github/stars/mikebrady/shairport-sync?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mikebrady/shairport-sync' alt='License'/>

  </p>
  </details>

- [ShazamScrobbler](https://github.com/ShazamScrobbler/shazamscrobbler-macos) - Scrobble vinyl, radios, movies to Last.fm. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/ShazamScrobbler/shazamscrobbler-macos/releases/latest'><img src='https://img.shields.io/github/v/release/ShazamScrobbler/shazamscrobbler-macos?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ShazamScrobbler/shazamscrobbler-macos'><img src='https://img.shields.io/github/stars/ShazamScrobbler/shazamscrobbler-macos?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ShazamScrobbler/shazamscrobbler-macos' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/1932338/10404677/7d1ffe58-6ed4-11e5-99d0-c29480a0bfda.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Sonora](https://github.com/sonoramac/Sonora) - Minimal, beautifully designed music player for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/sonoramac/Sonora/releases/latest'><img src='https://img.shields.io/github/v/release/sonoramac/Sonora?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sonoramac/Sonora'><img src='https://img.shields.io/github/stars/sonoramac/Sonora?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sonoramac/Sonora' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/sonoramac/Sonora/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Spotify4BigSur](https://github.com/fabiusBile/Spotify4BigSur) - Spotify widget for Notification Center.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/fabiusBile/Spotify4BigSur/releases/latest'><img src='https://img.shields.io/github/v/release/fabiusBile/Spotify4BigSur?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/fabiusBile/Spotify4BigSur'><img src='https://img.shields.io/github/stars/fabiusBile/Spotify4BigSur?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/fabiusBile/Spotify4BigSur' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/fabiusBile/Spotify4BigSur/blob/master/medium_light.png?raw=true' width='400' loading='lazy'/>

  </p>
  </details>

- [SpotMenu](https://github.com/kmikiy/SpotMenu) - Spotify and iTunes in your menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/kmikiy/SpotMenu/releases/latest'><img src='https://img.shields.io/github/v/release/kmikiy/SpotMenu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kmikiy/SpotMenu'><img src='https://img.shields.io/github/stars/kmikiy/SpotMenu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kmikiy/SpotMenu' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/kmikiy/SpotMenu/master/Demo/demo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [SpotSpot](https://github.com/will-stone/SpotSpot) - Spotify mini-player for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/will-stone/SpotSpot/releases/latest'><img src='https://img.shields.io/github/v/release/will-stone/SpotSpot?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/will-stone/SpotSpot'><img src='https://img.shields.io/github/stars/will-stone/SpotSpot?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/will-stone/SpotSpot' alt='License'/>

  </p>
  </details>

- [Suohai](https://github.com/Sunnyyoung/Suohai) - Audio input/output source lock for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Sunnyyoung/Suohai/releases/latest'><img src='https://img.shields.io/github/v/release/Sunnyyoung/Suohai?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Sunnyyoung/Suohai'><img src='https://img.shields.io/github/stars/Sunnyyoung/Suohai?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Sunnyyoung/Suohai' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Sunnyyoung/Suohai/master/Screenshot/0x01.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Tickeys](https://github.com/yingDev/Tickeys) - Instant audio feedback for typing. macOS version. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/yingDev/Tickeys/releases/latest'><img src='https://img.shields.io/github/v/release/yingDev/Tickeys?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/yingDev/Tickeys'><img src='https://img.shields.io/github/stars/yingDev/Tickeys?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/yingDev/Tickeys' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/yingDev/Tickeys/master/.readme_images/1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/yingDev/Tickeys/master/.readme_images/video_thumb.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/yingDev/Tickeys/master/.readme_images/2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Tuner](https://github.com/billthefarmer/ctuner) - Musical Instrument Tuner

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/billthefarmer/ctuner/releases/latest'><img src='https://img.shields.io/github/v/release/billthefarmer/ctuner?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/billthefarmer/ctuner'><img src='https://img.shields.io/github/stars/billthefarmer/ctuner?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/billthefarmer/ctuner' alt='License'/>

  **Website:** [https://billthefarmer.github.io/ctuner/ ](https://billthefarmer.github.io/ctuner/ )

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/billthefarmer/billthefarmer.github.io/master/images/ctuner/Tuner-swift.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/billthefarmer/billthefarmer.github.io/master/images/ctuner/Tuner-preferences.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/billthefarmer/billthefarmer.github.io/master/images/ctuner/Note-filter.png' width='400' loading='lazy'/>

  </p>
  </details>

- [waveSDR](https://github.com/getoffmyhack/waveSDR) - macOS native desktop Software Defined Radio application using the RTL-SDR USB device. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/getoffmyhack/waveSDR/releases/latest'><img src='https://img.shields.io/github/v/release/getoffmyhack/waveSDR?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/getoffmyhack/waveSDR'><img src='https://img.shields.io/github/stars/getoffmyhack/waveSDR?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/getoffmyhack/waveSDR' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/getoffmyhack/waveSDR/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="backup"></a>
### 💾 Backup (5)
- [BorgBase/Vorta](https://github.com/borgbase) - Simple and Secure Offsite Backups

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Website:** [https://www.borgbase.com/](https://www.borgbase.com/)

  </p>
  </details>

- [Mackup](https://github.com/lra/mackup) - Keep your application settings in sync (macOS/Linux). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/lra/mackup/releases/latest'><img src='https://img.shields.io/github/v/release/lra/mackup?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lra/mackup'><img src='https://img.shields.io/github/stars/lra/mackup?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lra/mackup' alt='License'/>

  </p>
  </details>

- [shallow-backup](https://github.com/alichtman/shallow-backup) - Easily create lightweight documentation of installed applications, dotfiles, and more. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/alichtman/shallow-backup/releases/latest'><img src='https://img.shields.io/github/v/release/alichtman/shallow-backup?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alichtman/shallow-backup'><img src='https://img.shields.io/github/stars/alichtman/shallow-backup?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alichtman/shallow-backup' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/alichtman/shallow-backup/blob/main/img/shallow-backup-demo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Syncalicious](https://github.com/zenangst/Syncalicious) - Keeping multiple macOS preferences in sync can be painful, but it shouldn't be.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/zenangst/Syncalicious/releases/latest'><img src='https://img.shields.io/github/v/release/zenangst/Syncalicious?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/zenangst/Syncalicious'><img src='https://img.shields.io/github/stars/zenangst/Syncalicious?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/zenangst/Syncalicious' alt='License'/>

  </p>
  </details>

- [UrBackup](https://github.com/uroni/urbackup_backend) - UrBackup is Client/Server network backup for Windows, macOS and Linux.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/uroni/urbackup_backend/releases/latest'><img src='https://img.shields.io/github/v/release/uroni/urbackup_backend?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/uroni/urbackup_backend'><img src='https://img.shields.io/github/stars/uroni/urbackup_backend?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/uroni/urbackup_backend' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="browser"></a>
### 🌐 Browser (13)
- [Beaker Browser](https://github.com/beakerbrowser/beaker) - Beaker is an experimental peer-to-peer Web browser.  

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/beakerbrowser/beaker/releases/latest'><img src='https://img.shields.io/github/v/release/beakerbrowser/beaker?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/beakerbrowser/beaker'><img src='https://img.shields.io/github/stars/beakerbrowser/beaker?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/beakerbrowser/beaker' alt='License'/>

  **Screenshots:**

  <img src='http://nerdist.com/wp-content/uploads/2016/05/the-mad-king-game-of-thrones.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/beakerbrowser/beaker/master/build/icons/256x256.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Brave Browser](https://github.com/brave/brave-browser) - Brave browser for Desktop and Laptop computers running Windows, macOS, and Linux. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/brave/brave-browser/releases/latest'><img src='https://img.shields.io/github/v/release/brave/brave-browser?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/brave/brave-browser'><img src='https://img.shields.io/github/stars/brave/brave-browser?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/brave/brave-browser' alt='License'/>

  </p>
  </details>

- [browserosaurus](https://github.com/will-stone/browserosaurus) - macOS tool that prompts you to choose a browser when opening a link. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/will-stone/browserosaurus/releases/latest'><img src='https://img.shields.io/github/v/release/will-stone/browserosaurus?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/will-stone/browserosaurus'><img src='https://img.shields.io/github/stars/will-stone/browserosaurus?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/will-stone/browserosaurus' alt='License'/>

  </p>
  </details>

- [Chromium](https://chromium.googlesource.com/chromium/src/) - Chromium is an open-source browser project that aims to build a safer, faster, and more stable way for all users to experience the web.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Website:** [https://www.chromium.org/](https://www.chromium.org/)

  </p>
  </details>

- [Finicky](https://github.com/johnste/finicky) - Always opens the right browser. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/johnste/finicky/releases/latest'><img src='https://img.shields.io/github/v/release/johnste/finicky?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/johnste/finicky'><img src='https://img.shields.io/github/stars/johnste/finicky?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/johnste/finicky' alt='License'/>

  </p>
  </details>

- [Firefox](https://hg.mozilla.org/mozilla-central/) - Fast, privacy aware browser from a non-profit. Runs on Windows, macOS and Linux. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Website:** [https://www.mozilla.org/en-US/firefox/browsers/](https://www.mozilla.org/en-US/firefox/browsers/)

  </p>
  </details>

- [Helium](https://github.com/JadenGeller/Helium) - Floating browser window for macOS.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/JadenGeller/Helium/releases/latest'><img src='https://img.shields.io/github/v/release/JadenGeller/Helium?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/JadenGeller/Helium'><img src='https://img.shields.io/github/stars/JadenGeller/Helium?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/JadenGeller/Helium' alt='License'/>

  </p>
  </details>

- [Min Browser](https://github.com/minbrowser/min) - A fast and efficient minimal web browser.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/minbrowser/min/releases/latest'><img src='https://img.shields.io/github/v/release/minbrowser/min?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/minbrowser/min'><img src='https://img.shields.io/github/stars/minbrowser/min?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/minbrowser/min' alt='License'/>

  **Website:** [https://minbrowser.org](https://minbrowser.org)

  </p>
  </details>

- [otter-browser](https://github.com/OtterBrowser/otter-browser) - Otter Browser aims to recreate the best aspects of the classic Opera (12.x) UI using Qt5.  

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/OtterBrowser/otter-browser/releases/latest'><img src='https://img.shields.io/github/v/release/OtterBrowser/otter-browser?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/OtterBrowser/otter-browser'><img src='https://img.shields.io/github/stars/OtterBrowser/otter-browser?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/OtterBrowser/otter-browser' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/050724a64db6ea50c8dd28144b26942b76883752/68747470733a2f2f6f747465722d62726f777365722e6f72672f73637265656e73686f74732f312e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [Pennywise](https://github.com/kamranahmedse/pennywise) - Pennywise opens any website or media in a small floating window that remains on top of all other applications. It's a great alternative to Helium.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/kamranahmedse/pennywise/releases/latest'><img src='https://img.shields.io/github/v/release/kamranahmedse/pennywise?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kamranahmedse/pennywise'><img src='https://img.shields.io/github/stars/kamranahmedse/pennywise?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kamranahmedse/pennywise' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/275d176aeaab2b9cf09701a091c8fb7ecfe6256a/68747470733a2f2f692e696d6775722e636f6d2f753766415439392e706e67' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/71ba8a4a28624f1f102272685f72a80fe70a2c03/68747470733a2f2f692e696d6775722e636f6d2f43654c596f75782e706e673f31' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/601c0dc538bad004c231201e8fe86e16ed3729d0/68747470733a2f2f692e696d6775722e636f6d2f4262715a6d634b2e706e67' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Plash](https://github.com/sindresorhus/Plash) - Make any website your desktop wallpaper.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sindresorhus/Plash/releases/latest'><img src='https://img.shields.io/github/v/release/sindresorhus/Plash?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sindresorhus/Plash'><img src='https://img.shields.io/github/stars/sindresorhus/Plash?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sindresorhus/Plash' alt='License'/>

  **Website:** [https://sindresorhus.com/plash](https://sindresorhus.com/plash)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/170270/74323375-0287d900-4db8-11ea-8b26-5566565fa8a1.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Privacy Redirect for Safari](https://github.com/smmr-software/privacy-redirect-safari) - Redirect Twitter, YouTube, Reddit, Google Maps, Google Search, and Google Translate to privacy friendly alternatives.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/smmr-software/privacy-redirect-safari/releases/latest'><img src='https://img.shields.io/github/v/release/smmr-software/privacy-redirect-safari?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/smmr-software/privacy-redirect-safari'><img src='https://img.shields.io/github/stars/smmr-software/privacy-redirect-safari?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/smmr-software/privacy-redirect-safari' alt='License'/>

  </p>
  </details>

- [seb-mac](https://github.com/SafeExamBrowser/seb-mac) - Safe Exam Browser for macOS and iOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/SafeExamBrowser/seb-mac/releases/latest'><img src='https://img.shields.io/github/v/release/SafeExamBrowser/seb-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/SafeExamBrowser/seb-mac'><img src='https://img.shields.io/github/stars/SafeExamBrowser/seb-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/SafeExamBrowser/seb-mac' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="chat"></a>
### 💬 Chat (19)
- [Adium](https://github.com/adium/adium) - Instant messaging application that can connect to XMPP (Jabber), IRC and more.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/adium/adium/releases/latest'><img src='https://img.shields.io/github/v/release/adium/adium?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/adium/adium'><img src='https://img.shields.io/github/stars/adium/adium?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/adium/adium' alt='License'/>

  **Website:** [https://adium.im/](https://adium.im/)

  **Screenshots:**

  <img src='https://adiumx.com/blog/uploads/2009/03/twitter-full.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Beagle IM](https://github.com/tigase/beagle-im) - Powerful XMPP client with support for file transfer, VoIP and end-to-end encryption.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/tigase/beagle-im/releases/latest'><img src='https://img.shields.io/github/v/release/tigase/beagle-im?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/tigase/beagle-im'><img src='https://img.shields.io/github/stars/tigase/beagle-im?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/tigase/beagle-im' alt='License'/>

  **Website:** [https://beagle.im/](https://beagle.im/)

  **Screenshots:**

  <img src='https://beagle.im/img/services/darkOrLight.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ChitChat](https://github.com/stonesam92/ChitChat) - Native Mac app wrapper for WhatsApp Web. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/stonesam92/ChitChat/releases/latest'><img src='https://img.shields.io/github/v/release/stonesam92/ChitChat?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/stonesam92/ChitChat'><img src='https://img.shields.io/github/stars/stonesam92/ChitChat?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/stonesam92/ChitChat' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/riXrTvx.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Electronic WeChat](https://github.com/geeeeeeeeek/electronic-wechat) - Better WeChat on macOS and Linux. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/geeeeeeeeek/electronic-wechat/releases/latest'><img src='https://img.shields.io/github/v/release/geeeeeeeeek/electronic-wechat?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/geeeeeeeeek/electronic-wechat'><img src='https://img.shields.io/github/stars/geeeeeeeeek/electronic-wechat?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/geeeeeeeeek/electronic-wechat' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/7262715/14876747/ff691ade-0d49-11e6-8435-cb1fac91b3c2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Element](https://github.com/vector-im/element-web) - Element is a collaboration app (currently Electron) for the [Matrix](https://matrix.org/) protocol.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/vector-im/element-web/releases/latest'><img src='https://img.shields.io/github/v/release/vector-im/element-web?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vector-im/element-web'><img src='https://img.shields.io/github/stars/vector-im/element-web?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vector-im/element-web' alt='License'/>

  </p>
  </details>

- [Franz](https://github.com/meetfranz/franz) - Franz is messaging application for services like WhatsApp, Slack, Messenger and many more. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/meetfranz/franz/releases/latest'><img src='https://img.shields.io/github/v/release/meetfranz/franz?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/meetfranz/franz'><img src='https://img.shields.io/github/stars/meetfranz/franz?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/meetfranz/franz' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/meetfranz/franz/master/build-helpers/images/icon.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Google Allo for Desktop](https://github.com/kelyvin/Google-Allo-For-Desktop) - Native macOS & Windows desktop app for Google Allo. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/kelyvin/Google-Allo-For-Desktop/releases/latest'><img src='https://img.shields.io/github/v/release/kelyvin/Google-Allo-For-Desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kelyvin/Google-Allo-For-Desktop'><img src='https://img.shields.io/github/stars/kelyvin/Google-Allo-For-Desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kelyvin/Google-Allo-For-Desktop' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/5g1VU3S.png' width='400' loading='lazy'/>

  </p>
  </details>

- [GroupMe](https://github.com/dcrousso/GroupMe) - Unofficial GroupMe App.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/dcrousso/GroupMe/releases/latest'><img src='https://img.shields.io/github/v/release/dcrousso/GroupMe?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dcrousso/GroupMe'><img src='https://img.shields.io/github/stars/dcrousso/GroupMe?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dcrousso/GroupMe' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/dcrousso/GroupMe/master/media/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MessagesHistoryBrowser](https://github.com/glaurent/MessagesHistoryBrowser) - macOS application to comfortably browse and search through your Messages.app history. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/glaurent/MessagesHistoryBrowser/releases/latest'><img src='https://img.shields.io/github/v/release/glaurent/MessagesHistoryBrowser?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/glaurent/MessagesHistoryBrowser'><img src='https://img.shields.io/github/stars/glaurent/MessagesHistoryBrowser?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/glaurent/MessagesHistoryBrowser' alt='License'/>

  </p>
  </details>

- [RocketChat](https://github.com/RocketChat/Rocket.Chat.Electron) - Free open source chat system for teams. An alternative to Slack that can also be self hosted.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/RocketChat/Rocket.Chat.Electron/releases/latest'><img src='https://img.shields.io/github/v/release/RocketChat/Rocket.Chat.Electron?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/RocketChat/Rocket.Chat.Electron'><img src='https://img.shields.io/github/stars/RocketChat/Rocket.Chat.Electron?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/RocketChat/Rocket.Chat.Electron' alt='License'/>

  **Website:** [https://www.rocket.chat/](https://www.rocket.chat/)

  </p>
  </details>

- [Seaglass](https://github.com/neilalexander/seaglass) - A truly native [Matrix](https://matrix.org/blog/home/) client for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/neilalexander/seaglass/releases/latest'><img src='https://img.shields.io/github/v/release/neilalexander/seaglass?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/neilalexander/seaglass'><img src='https://img.shields.io/github/stars/neilalexander/seaglass?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/neilalexander/seaglass' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/neilalexander/seaglass/master/image.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Signal Desktop](https://github.com/signalapp/Signal-Desktop) - Electron app that links with your Signal Android or Signal iOS app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/signalapp/Signal-Desktop/releases/latest'><img src='https://img.shields.io/github/v/release/signalapp/Signal-Desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/signalapp/Signal-Desktop'><img src='https://img.shields.io/github/stars/signalapp/Signal-Desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/signalapp/Signal-Desktop' alt='License'/>

  </p>
  </details>

- [Telegram](https://github.com/overtake/TelegramSwift) - Source code of Telegram for macOS on Swift. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/overtake/TelegramSwift/releases/latest'><img src='https://img.shields.io/github/v/release/overtake/TelegramSwift?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/overtake/TelegramSwift'><img src='https://img.shields.io/github/stars/overtake/TelegramSwift?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/overtake/TelegramSwift' alt='License'/>

  </p>
  </details>

- [Telegram Desktop](https://github.com/telegramdesktop/tdesktop) - Telegram Desktop messaging app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/telegramdesktop/tdesktop/releases/latest'><img src='https://img.shields.io/github/v/release/telegramdesktop/tdesktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/telegramdesktop/tdesktop'><img src='https://img.shields.io/github/stars/telegramdesktop/tdesktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/telegramdesktop/tdesktop' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/telegramdesktop/tdesktop/dev/docs/assets/preview.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Textual](https://github.com/Codeux-Software/Textual) - Textual is an IRC client for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Codeux-Software/Textual/releases/latest'><img src='https://img.shields.io/github/v/release/Codeux-Software/Textual?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Codeux-Software/Textual'><img src='https://img.shields.io/github/stars/Codeux-Software/Textual?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Codeux-Software/Textual' alt='License'/>

  **Screenshots:**

  <img src='https://www.codeux.com/textual/private/images/v600media/YosemiteDarkFullscreen.png' width='400' loading='lazy'/>

  <img src='https://www.codeux.com/textual/private/images/v600media/YosemiteDarkThumbnail.png' width='400' loading='lazy'/>

  <img src='https://www.codeux.com/textual/private/images/v600media/YosemiteLightFullscreen.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Thunderbird](https://hg.mozilla.org/mozilla-central) - Backed by Mozilla, Thunderbird is an extensible email, newsfeed, chat, and calendaring client.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Website:** [https://www.thunderbird.net/en-US/](https://www.thunderbird.net/en-US/)

  **Screenshots:**

  <img src='https://www.thunderbird.net/media/img/l10n/en-US/thunderbird/landing/screenshot-mac.png' width='400' loading='lazy'/>

  <img src='https://www.thunderbird.net/media/img/l10n/en-US/thunderbird/calendar/screenshot-mac.png' width='400' loading='lazy'/>

  <img src='https://www.thunderbird.net/media/img/thunderbird/features/addon-manager.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Torchat-Mac](https://github.com/javerous/TorChat-Mac) - TorChat for Mac is a macOS native and unofficial port of torchat. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/javerous/TorChat-Mac/releases/latest'><img src='https://img.shields.io/github/v/release/javerous/TorChat-Mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/javerous/TorChat-Mac'><img src='https://img.shields.io/github/stars/javerous/TorChat-Mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/javerous/TorChat-Mac' alt='License'/>

  </p>
  </details>

- [WhatsAppBar](https://github.com/aldychris/WhatsAppBar) - Send WhatsApp message from menu bar. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/aldychris/WhatsAppBar/releases/latest'><img src='https://img.shields.io/github/v/release/aldychris/WhatsAppBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/aldychris/WhatsAppBar'><img src='https://img.shields.io/github/stars/aldychris/WhatsAppBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/aldychris/WhatsAppBar' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/aldychris/WhatsAppBar/master/Resource/AppScreenshoot.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/aldychris/WhatsAppBar/master/Resource/WaPref.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/aldychris/WhatsAppBar/master/Resource/WhatsAppBarGif.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Wire Desktop](https://github.com/wireapp/wire-desktop) - Standalone Electron app for the chatapp Wire. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/wireapp/wire-desktop/releases/latest'><img src='https://img.shields.io/github/v/release/wireapp/wire-desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wireapp/wire-desktop'><img src='https://img.shields.io/github/stars/wireapp/wire-desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wireapp/wire-desktop' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="cryptocurrency"></a>
### 💰 Cryptocurrency (5)
- [Balance Open](https://github.com/balance-io/balance-open) - App for all the world’s currencies. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/balance-io/balance-open/releases/latest'><img src='https://img.shields.io/github/v/release/balance-io/balance-open?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/balance-io/balance-open'><img src='https://img.shields.io/github/stars/balance-io/balance-open?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/balance-io/balance-open' alt='License'/>

  **Screenshots:**

  <img src='https://d3vv6lp55qjaqc.cloudfront.net/items/2840292G3j1g102Q3s21/balance-open.png' width='400' loading='lazy'/>

  </p>
  </details>

- [CoinBar](https://github.com/adamwaite/CoinBar) - macOS menu bar application for tracking crypto coin prices. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/adamwaite/CoinBar/releases/latest'><img src='https://img.shields.io/github/v/release/adamwaite/CoinBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/adamwaite/CoinBar'><img src='https://img.shields.io/github/stars/adamwaite/CoinBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/adamwaite/CoinBar' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/adamwaite/CoinBar/master/resources/04.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/adamwaite/CoinBar/master/resources/01.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/adamwaite/CoinBar/master/resources/02.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Copay](https://github.com/bitpay/copay) - A secure bitcoin wallet platform for both desktop and mobile devices. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/bitpay/copay/releases/latest'><img src='https://img.shields.io/github/v/release/bitpay/copay?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bitpay/copay'><img src='https://img.shields.io/github/stars/bitpay/copay?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bitpay/copay' alt='License'/>

  </p>
  </details>

- [Crypto Bar](https://github.com/geraldoramos/crypto-bar) - macOS menu bar application built with Electron. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/geraldoramos/crypto-bar/releases/latest'><img src='https://img.shields.io/github/v/release/geraldoramos/crypto-bar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/geraldoramos/crypto-bar'><img src='https://img.shields.io/github/stars/geraldoramos/crypto-bar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/geraldoramos/crypto-bar' alt='License'/>

  </p>
  </details>

- [Float coin](https://github.com/kaunteya/FloatCoin) - Native menu bar app with floating window and support for many Exchanges. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/kaunteya/FloatCoin/releases/latest'><img src='https://img.shields.io/github/v/release/kaunteya/FloatCoin?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kaunteya/FloatCoin'><img src='https://img.shields.io/github/stars/kaunteya/FloatCoin?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kaunteya/FloatCoin' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/kaunteya/FloatCoin/master/Images/Banner.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="database"></a>
### 🗄️ Database (18)
- [Bdash](https://github.com/bdash-app/bdash) - Simple SQL Client for lightweight data analysis.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/bdash-app/bdash/releases/latest'><img src='https://img.shields.io/github/v/release/bdash-app/bdash?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bdash-app/bdash'><img src='https://img.shields.io/github/stars/bdash-app/bdash?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bdash-app/bdash' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/bdash-app/bdash/1.2.2/assets/capture1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/bdash-app/bdash/1.2.2/assets/capture2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Beekeeper Studio](https://github.com/beekeeper-studio/beekeeper-studio) - SQL editor and manager with support for SQLite, MySQL, MariaDB, Postgres, CockroachDB, SQL Server, and Amazon Redshift.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/beekeeper-studio/beekeeper-studio/releases/latest'><img src='https://img.shields.io/github/v/release/beekeeper-studio/beekeeper-studio?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/beekeeper-studio/beekeeper-studio'><img src='https://img.shields.io/github/stars/beekeeper-studio/beekeeper-studio?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/beekeeper-studio/beekeeper-studio' alt='License'/>

  **Website:** [https://www.beekeeperstudio.io](https://www.beekeeperstudio.io)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/beekeeper-studio/beekeeper-studio/master/apps/studio/screenshots/beekeeper-studio-demo.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/beekeeper-studio/beekeeper-studio/master/apps/studio/screenshots/main.png' width='400' loading='lazy'/>

  </p>
  </details>

- [DB Browser for SQLite](https://github.com/sqlitebrowser/sqlitebrowser) - SQLite database management GUI. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/sqlitebrowser/sqlitebrowser/releases/latest'><img src='https://img.shields.io/github/v/release/sqlitebrowser/sqlitebrowser?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sqlitebrowser/sqlitebrowser'><img src='https://img.shields.io/github/stars/sqlitebrowser/sqlitebrowser?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sqlitebrowser/sqlitebrowser' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/sqlitebrowser/sqlitebrowser/master/images/sqlitebrowser.png' width='400' loading='lazy'/>

  </p>
  </details>

- [DBeaver](https://github.com/dbeaver/dbeaver) - Universal database tool and SQL client. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/java-16.png' alt='Java icon' title='Java' height='16'/> 

  **Links:** <a href='https://github.com/dbeaver/dbeaver/releases/latest'><img src='https://img.shields.io/github/v/release/dbeaver/dbeaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dbeaver/dbeaver'><img src='https://img.shields.io/github/stars/dbeaver/dbeaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dbeaver/dbeaver' alt='License'/>

  **Screenshots:**

  <img src='https://dbeaver.io/product/dbeaver-ss-classic.png' width='400' loading='lazy'/>

  <img src='https://dbeaver.io/product/dbeaver-ss-mock.png' width='400' loading='lazy'/>

  <img src='https://dbeaver.io/product/dbeaver-ss-erd.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [DbGate](https://github.com/dbgate/dbgate) - Database manager for MySQL, PostgreSQL, SQL Server, MongoDB, SQLite and others. Runs under Windows, Linux, Mac or as web application.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/dbgate/dbgate/releases/latest'><img src='https://img.shields.io/github/v/release/dbgate/dbgate?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dbgate/dbgate'><img src='https://img.shields.io/github/stars/dbgate/dbgate?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dbgate/dbgate' alt='License'/>

  **Website:** [https://dbgate.org](https://dbgate.org)

  **Screenshots:**

  <img src='https://dbgate.org/assets/screenshots/datagrid.png' width='400' loading='lazy'/>

  <img src='https://dbgate.org/assets/screenshots/query.png' width='400' loading='lazy'/>

  <img src='https://dbgate.org/assets/screenshots/diagram.png' width='400' loading='lazy'/>

  *(6 more screenshots available in the repository)*

  </p>
  </details>

- [Medis](https://github.com/luin/medis) - 💻 Medis is a beautiful, easy-to-use Mac database management application for Redis.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/luin/medis/releases/latest'><img src='https://img.shields.io/github/v/release/luin/medis?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/luin/medis'><img src='https://img.shields.io/github/stars/luin/medis?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/luin/medis' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/94bf1d9f514351e5064e6bf9245fc3a48e2a5a8c/687474703a2f2f6765746d656469732e636f6d2f73637265656e2e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [mongoDB.app](https://github.com/gcollazo/mongodbapp) - The easiest way to get started with mongoDB on the Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/gcollazo/mongodbapp/releases/latest'><img src='https://img.shields.io/github/v/release/gcollazo/mongodbapp?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gcollazo/mongodbapp'><img src='https://img.shields.io/github/stars/gcollazo/mongodbapp?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gcollazo/mongodbapp' alt='License'/>

  **Screenshots:**

  <img src='https://gcollazo.github.io/mongodbapp/assets/img/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MongoHub](https://github.com/jeromelebel/MongoHub-Mac) - Add another lightweight Mac Native MongoDB client.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/jeromelebel/MongoHub-Mac/releases/latest'><img src='https://img.shields.io/github/v/release/jeromelebel/MongoHub-Mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jeromelebel/MongoHub-Mac'><img src='https://img.shields.io/github/stars/jeromelebel/MongoHub-Mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jeromelebel/MongoHub-Mac' alt='License'/>

  </p>
  </details>

- [Postbird](https://github.com/Paxa/postbird) - PostgreSQL GUI client for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/Paxa/postbird/releases/latest'><img src='https://img.shields.io/github/v/release/Paxa/postbird?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Paxa/postbird'><img src='https://img.shields.io/github/stars/Paxa/postbird?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Paxa/postbird' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/26019/41055418-dcc55700-69f3-11e8-8d3e-572cf5febedc.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/26019/41055416-dc5a5464-69f3-11e8-87b8-994e763da816.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/26019/41055417-dc8eb56a-69f3-11e8-8145-6f0d5eb147a6.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Postgres.app](https://github.com/PostgresApp/PostgresApp) - The easiest way to get started with PostgreSQL on the Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/PostgresApp/PostgresApp/releases/latest'><img src='https://img.shields.io/github/v/release/PostgresApp/PostgresApp?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/PostgresApp/PostgresApp'><img src='https://img.shields.io/github/stars/PostgresApp/PostgresApp?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/PostgresApp/PostgresApp' alt='License'/>

  </p>
  </details>

- [Redis Desktop Manager](https://github.com/uglide/RedisDesktopManager) - Cross-platform open source database management tool for Redis ®

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/uglide/RedisDesktopManager/releases/latest'><img src='https://img.shields.io/github/v/release/uglide/RedisDesktopManager?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/uglide/RedisDesktopManager'><img src='https://img.shields.io/github/stars/uglide/RedisDesktopManager?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/uglide/RedisDesktopManager' alt='License'/>

  **Screenshots:**

  <img src='https://rdm.dev/static/img/features/all.png?v=20202' width='400' loading='lazy'/>

  </p>
  </details>

- [redis-pro](https://github.com/cmushroom/redis-pro) - Redis management with SwiftUI.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/cmushroom/redis-pro/releases/latest'><img src='https://img.shields.io/github/v/release/cmushroom/redis-pro?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/cmushroom/redis-pro'><img src='https://img.shields.io/github/stars/cmushroom/redis-pro?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/cmushroom/redis-pro' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/2920167/125376778-4f614c00-e3be-11eb-8c11-7195e4cdb665.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Redis.app](https://github.com/jpadilla/redisapp) - The easiest way to get started with Redis on the Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/jpadilla/redisapp/releases/latest'><img src='https://img.shields.io/github/v/release/jpadilla/redisapp?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jpadilla/redisapp'><img src='https://img.shields.io/github/stars/jpadilla/redisapp?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jpadilla/redisapp' alt='License'/>

  **Screenshots:**

  <img src='https://jpadilla.github.io/redisapp/assets/img/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [reventlou](https://github.com/b3z/reventlou) - Personal database as an information management system.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/b3z/reventlou/releases/latest'><img src='https://img.shields.io/github/v/release/b3z/reventlou?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/b3z/reventlou'><img src='https://img.shields.io/github/stars/b3z/reventlou?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/b3z/reventlou' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/b3z/reventlou/blob/master/assets/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Robo 3T](https://github.com/Studio3T/robomongo) - Robo 3T (formerly Robomongo) is the free lightweight GUI for MongoDB enthusiasts. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/Studio3T/robomongo/releases/latest'><img src='https://img.shields.io/github/v/release/Studio3T/robomongo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Studio3T/robomongo'><img src='https://img.shields.io/github/stars/Studio3T/robomongo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Studio3T/robomongo' alt='License'/>

  **Screenshots:**

  <img src='https://robomongo.org/static/screens-transparent-6e2a44fd.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Sequel Ace](https://github.com/Sequel-Ace/Sequel-Ace) - Sequel Ace is a fast, easy-to-use Mac database management application for working with MySQL & MariaDB databases.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Sequel-Ace/Sequel-Ace/releases/latest'><img src='https://img.shields.io/github/v/release/Sequel-Ace/Sequel-Ace?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Sequel-Ace/Sequel-Ace'><img src='https://img.shields.io/github/stars/Sequel-Ace/Sequel-Ace?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Sequel-Ace/Sequel-Ace' alt='License'/>

  **Website:** [https://sequel-ace.com/](https://sequel-ace.com/)

  </p>
  </details>

- [Sequel Pro](https://github.com/sequelpro/sequelpro) - MySQL/MariaDB database management for macOS.  

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/sequelpro/sequelpro/releases/latest'><img src='https://img.shields.io/github/v/release/sequelpro/sequelpro?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sequelpro/sequelpro'><img src='https://img.shields.io/github/stars/sequelpro/sequelpro?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sequelpro/sequelpro' alt='License'/>

  **Screenshots:**

  <img src='https://sequelpro.com/images/logo.png' width='400' loading='lazy'/>

  <img src='https://sequelpro.com/images/browse.png' width='400' loading='lazy'/>

  </p>
  </details>

- [sqlectron](https://github.com/sqlectron/sqlectron-gui) - A simple and lightweight SQL client desktop/terminal with cross database and platform support.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/sqlectron/sqlectron-gui/releases/latest'><img src='https://img.shields.io/github/v/release/sqlectron/sqlectron-gui?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sqlectron/sqlectron-gui'><img src='https://img.shields.io/github/stars/sqlectron/sqlectron-gui?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sqlectron/sqlectron-gui' alt='License'/>

  **Website:** [https://sqlectron.github.io/](https://sqlectron.github.io/)

  **Screenshots:**

  <img src='https://sqlectron.github.io/demos/sqlectron-demo-gui-v1.31.0.gif' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="development"></a>
### 👨‍💻 Development (9)
- [Apache Netbeans](https://github.com/apache/netbeans) - Apache NetBeans is an IDE, Tooling Platform and Application Framework suitable for development in Java, JavaScript, PHP, HTML5, CSS, and more.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/java-16.png' alt='Java icon' title='Java' height='16'/> 

  **Links:** <a href='https://github.com/apache/netbeans/releases/latest'><img src='https://img.shields.io/github/v/release/apache/netbeans?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/apache/netbeans'><img src='https://img.shields.io/github/stars/apache/netbeans?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/apache/netbeans' alt='License'/>

  **Website:** [https://netbeans.apache.org/](https://netbeans.apache.org/)

  **Screenshots:**

  <img src='https://www.dropbox.com/s/r9ewe87xer4nypj/netbeans_dark.png?dl=0' width='400' loading='lazy'/>

  <img src='https://www.dropbox.com/s/qs2gh43lrsbdkid/netbeans_light.png?dl=0' width='400' loading='lazy'/>

  </p>
  </details>

- [Brackets](https://github.com/brackets-cont/brackets) - Modern open-source code editor for HTML, CSS and JavaScript that's built in HTML, CSS and JavaScript.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/brackets-cont/brackets/releases/latest'><img src='https://img.shields.io/github/v/release/brackets-cont/brackets?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/brackets-cont/brackets'><img src='https://img.shields.io/github/stars/brackets-cont/brackets?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/brackets-cont/brackets' alt='License'/>

  **Website:** [https://brackets.io/](https://brackets.io/)

  **Screenshots:**

  <img src='https://brackets.io/img/hero.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ColorSet](https://github.com/DigiDNA/ColorSet) - ColorSet is a macOS utility and framework allowing developers to manage custom interface colors with ease.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/csharp-16.png' alt='C# icon' title='C#' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/DigiDNA/ColorSet/releases/latest'><img src='https://img.shields.io/github/v/release/DigiDNA/ColorSet?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/DigiDNA/ColorSet'><img src='https://img.shields.io/github/stars/DigiDNA/ColorSet?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/DigiDNA/ColorSet' alt='License'/>

  **Website:** [https://imazing.com/colorset](https://imazing.com/colorset)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/DigiDNA/ColorSet/master/Assets/ColorSet.png' width='400' loading='lazy'/>

  </p>
  </details>

- [GitAhead](https://github.com/gitahead/gitahead/) - A graphical Git client designed to help you understand and manage your source code history.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/gitahead/gitahead/releases/latest'><img src='https://img.shields.io/github/v/release/gitahead/gitahead?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gitahead/gitahead/'><img src='https://img.shields.io/github/stars/gitahead/gitahead?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gitahead/gitahead' alt='License'/>

  **Website:** [https://gitahead.github.io/gitahead.com/](https://gitahead.github.io/gitahead.com/)

  </p>
  </details>

- [KiCad](https://gitlab.com/kicad/code/kicad) - A software suite for electronic design automation.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Website:** [https://www.kicad.org/](https://www.kicad.org/)

  </p>
  </details>

- [Layout Designer for UICollectionView](https://github.com/amirdew/CollectionViewPagingLayout) - A simple but powerful tool that helps you make complex layouts for UICollectionView.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12'><img src='./icons/app_store-16.png' alt='App Store' title='Download on the Mac App Store' height='16'/> App Store</a> &nbsp; <a href='https://github.com/amirdew/CollectionViewPagingLayout/releases/latest'><img src='https://img.shields.io/github/v/release/amirdew/CollectionViewPagingLayout?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/amirdew/CollectionViewPagingLayout'><img src='https://img.shields.io/github/stars/amirdew/CollectionViewPagingLayout?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/amirdew/CollectionViewPagingLayout' alt='License'/>

  **Website:** [https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12](https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12)

  **Screenshots:**

  <img src='https://amir.app/git/layout_designer_preview.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Pasteboard Viewer](https://github.com/sindresorhus/Pasteboard-Viewer) - Inspect the system pasteboards.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sindresorhus/Pasteboard-Viewer/releases/latest'><img src='https://img.shields.io/github/v/release/sindresorhus/Pasteboard-Viewer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sindresorhus/Pasteboard-Viewer'><img src='https://img.shields.io/github/stars/sindresorhus/Pasteboard-Viewer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sindresorhus/Pasteboard-Viewer' alt='License'/>

  **Website:** [https://sindresorhus.com/pasteboard-viewer](https://sindresorhus.com/pasteboard-viewer)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/sindresorhus/Pasteboard-Viewer/3ab9545e24050a0ca60ab102e9c303345af8da10/Stuff/screenshot1.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Stringz](https://github.com/mohakapt/Stringz) - A lightweight and powerful editor for localizing iOS, macOS, tvOS, and watchOS applications.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mohakapt/Stringz/releases/latest'><img src='https://img.shields.io/github/v/release/mohakapt/Stringz?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mohakapt/Stringz'><img src='https://img.shields.io/github/stars/mohakapt/Stringz?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mohakapt/Stringz' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mohakapt/Stringz/main/Resources/hero_dark.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/mohakapt/Stringz/main/Resources/hero_light.png' width='400' loading='lazy'/>

  </p>
  </details>

- [utmapp](https://github.com/utmapp/) - Virtualization for other operating systems.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Website:** [https://mac.getutm.app/](https://mac.getutm.app/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/utmapp/UTM/main/screenmac.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="git"></a>
#### 📦 Git (20)
- [Cashew](https://github.com/dhennessy/OpenCashew) - Cashew macOS Github Issue Tracker.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/dhennessy/OpenCashew/releases/latest'><img src='https://img.shields.io/github/v/release/dhennessy/OpenCashew?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dhennessy/OpenCashew'><img src='https://img.shields.io/github/stars/dhennessy/OpenCashew?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dhennessy/OpenCashew' alt='License'/>

  </p>
  </details>

- [Git Interactive Rebase Tool](https://github.com/MitMaro/git-interactive-rebase-tool) - Full feature terminal based sequence editor for interactive rebase.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/MitMaro/git-interactive-rebase-tool/releases/latest'><img src='https://img.shields.io/github/v/release/MitMaro/git-interactive-rebase-tool?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/MitMaro/git-interactive-rebase-tool'><img src='https://img.shields.io/github/stars/MitMaro/git-interactive-rebase-tool?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/MitMaro/git-interactive-rebase-tool' alt='License'/>

  **Website:** [https://gitrebasetool.mitmaro.ca/](https://gitrebasetool.mitmaro.ca/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/MitMaro/git-interactive-rebase-tool/master/docs/assets/images/girt-demo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [GitAhead](https://github.com/gitahead/gitahead/) - A graphical Git client designed to help you understand and manage your source code history.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/gitahead/gitahead/releases/latest'><img src='https://img.shields.io/github/v/release/gitahead/gitahead?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gitahead/gitahead/'><img src='https://img.shields.io/github/stars/gitahead/gitahead?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gitahead/gitahead' alt='License'/>

  **Website:** [https://gitahead.github.io/gitahead.com/](https://gitahead.github.io/gitahead.com/)

  </p>
  </details>

- [GitBlamePR](https://github.com/maoyama/GitBlamePR) - Mac app that shows pull request last modified each line of a file

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/maoyama/GitBlamePR/releases/latest'><img src='https://img.shields.io/github/v/release/maoyama/GitBlamePR?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/maoyama/GitBlamePR'><img src='https://img.shields.io/github/stars/maoyama/GitBlamePR?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/maoyama/GitBlamePR' alt='License'/>

  </p>
  </details>

- [Gitee](https://github.com/Nightonke/Gitee) - Gitee, macOS status bar application for Github.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Nightonke/Gitee/releases/latest'><img src='https://img.shields.io/github/v/release/Nightonke/Gitee?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Nightonke/Gitee'><img src='https://img.shields.io/github/stars/Nightonke/Gitee?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Nightonke/Gitee' alt='License'/>

  **Screenshots:**

  <img src='https://img.shields.io/github/v/release/nightonke/gitee.svg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/Nightonke/Gitee/master/Pictures/notification_1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/Nightonke/Gitee/master/Pictures/tab_pie_1.png' width='400' loading='lazy'/>

  *(11 more screenshots available in the repository)*

  </p>
  </details>

- [Github contributions](https://github.com/remirobert/Github-contributions) - GitHub contributions app, for iOS, WatchOS, and macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/remirobert/Github-contributions/releases/latest'><img src='https://img.shields.io/github/v/release/remirobert/Github-contributions?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/remirobert/Github-contributions'><img src='https://img.shields.io/github/stars/remirobert/Github-contributions?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/remirobert/Github-contributions' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/3276768/19214602/f39af4c0-8d87-11e6-8b3d-3d9c7b94d57c.png' width='400' loading='lazy'/>

  </p>
  </details>

- [GitHub Desktop](https://github.com/desktop/desktop) - Simple collaboration from your desktop. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/desktop/desktop/releases/latest'><img src='https://img.shields.io/github/v/release/desktop/desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/desktop/desktop'><img src='https://img.shields.io/github/stars/desktop/desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/desktop/desktop' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/359239/26094502/a1f56d02-3a5d-11e7-8799-23c7ba5e5106.png' width='400' loading='lazy'/>

  </p>
  </details>

- [GithubListener](https://github.com/ad/GithubListener) - Simple app that will notify about new commits to watched repositories. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ad/GithubListener/releases/latest'><img src='https://img.shields.io/github/v/release/ad/GithubListener?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ad/GithubListener'><img src='https://img.shields.io/github/stars/ad/GithubListener?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ad/GithubListener' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ad/GithubListener/master/notifyexample.png' width='400' loading='lazy'/>

  </p>
  </details>

- [GithubNotify](https://github.com/erik/github-notify) - Simple macOS app to alert you when you have unread GitHub notifications. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/erik/github-notify/releases/latest'><img src='https://img.shields.io/github/v/release/erik/github-notify?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/erik/github-notify'><img src='https://img.shields.io/github/stars/erik/github-notify?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/erik/github-notify' alt='License'/>

  </p>
  </details>

- [Gitify](https://github.com/manosim/gitify) - Your GitHub notifications on your menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/manosim/gitify/releases/latest'><img src='https://img.shields.io/github/v/release/manosim/gitify?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/manosim/gitify'><img src='https://img.shields.io/github/stars/manosim/gitify?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/manosim/gitify' alt='License'/>

  **Website:** [https://www.gitify.io/](https://www.gitify.io/)

  **Screenshots:**

  <img src='https://github.com/manosim/gitify/blob/main/assets/images/press.png' width='400' loading='lazy'/>

  </p>
  </details>

- [GitSync](https://github.com/eonist/GitSync) - Minimalistic Git client for Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/eonist/GitSync/releases/latest'><img src='https://img.shields.io/github/v/release/eonist/GitSync?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/eonist/GitSync'><img src='https://img.shields.io/github/stars/eonist/GitSync?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/eonist/GitSync' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/stylekit/img/master/Element210-01.png' width='400' loading='lazy'/>

  </p>
  </details>

- [GitUp](https://github.com/git-up/GitUp) - The Git interface you've been missing all your life has finally arrived. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/git-up/GitUp/releases/latest'><img src='https://img.shields.io/github/v/release/git-up/GitUp?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/git-up/GitUp'><img src='https://img.shields.io/github/stars/git-up/GitUp?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/git-up/GitUp' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/t6iC9TC.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/ZfxM7su.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/29hxDcJ.png' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [GitX](https://github.com/gitx/gitx) - Graphical client for the git version control system. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/gitx/gitx/releases/latest'><img src='https://img.shields.io/github/v/release/gitx/gitx?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gitx/gitx'><img src='https://img.shields.io/github/stars/gitx/gitx?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gitx/gitx' alt='License'/>

  </p>
  </details>

- [GPM](https://github.com/mtgto/GPM) - macOS application for easily operating GitHub Projects. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mtgto/GPM/releases/latest'><img src='https://img.shields.io/github/v/release/mtgto/GPM?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mtgto/GPM'><img src='https://img.shields.io/github/stars/mtgto/GPM?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mtgto/GPM' alt='License'/>

  </p>
  </details>

- [osagitfilter](https://github.com/doekman/osagitfilter) - Filter to put OSA languages (AppleScript, JavaScript) into git, as if they where plain text-files.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/shell-16.png' alt='Shell icon' title='Shell' height='16'/> <code>applescript</code> 

  **Links:** <a href='https://github.com/doekman/osagitfilter/releases/latest'><img src='https://img.shields.io/github/v/release/doekman/osagitfilter?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/doekman/osagitfilter'><img src='https://img.shields.io/github/stars/doekman/osagitfilter?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/doekman/osagitfilter' alt='License'/>

  </p>
  </details>

- [Streaker](https://github.com/jamieweavis/streaker) - GitHub contribution streak tracking menubar app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/jamieweavis/streaker/releases/latest'><img src='https://img.shields.io/github/v/release/jamieweavis/streaker?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jamieweavis/streaker'><img src='https://img.shields.io/github/stars/jamieweavis/streaker?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jamieweavis/streaker' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/jamieweavis/streaker/main/.github/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [TeamStatus-for-GitHub](https://github.com/marcinreliga/TeamStatus-for-GitHub) - macOS status bar application for tracking code review process within the team. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/marcinreliga/TeamStatus-for-GitHub/releases/latest'><img src='https://img.shields.io/github/v/release/marcinreliga/TeamStatus-for-GitHub?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/marcinreliga/TeamStatus-for-GitHub'><img src='https://img.shields.io/github/stars/marcinreliga/TeamStatus-for-GitHub?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/marcinreliga/TeamStatus-for-GitHub' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/marcinreliga/TeamStatus-for-GitHub/master/doc/preview.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Tempo](https://github.com/maoyama/Tempo) - Replace the Git CLI with a clear UI and AI assist.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/maoyama/Tempo/releases/latest'><img src='https://img.shields.io/github/v/release/maoyama/Tempo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/maoyama/Tempo'><img src='https://img.shields.io/github/stars/maoyama/Tempo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/maoyama/Tempo' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/maoyama/Tempo/refs/heads/main/Screenshots/Screenshot.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/maoyama/Tempo/refs/heads/main/Screenshots/Screenshot2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Trailer](https://github.com/ptsochantaris/trailer) - Managing Pull Requests and Issues For GitHub & GitHub Enterprise. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ptsochantaris/trailer/releases/latest'><img src='https://img.shields.io/github/v/release/ptsochantaris/trailer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ptsochantaris/trailer'><img src='https://img.shields.io/github/stars/ptsochantaris/trailer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ptsochantaris/trailer' alt='License'/>

  **Screenshots:**

  <img src='http://ptsochantaris.github.io/trailer/images/ipadscreenshot-820-1.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Xit](https://github.com/Uncommon/Xit) - Xit is a graphical tool for working with git repositories. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Uncommon/Xit/releases/latest'><img src='https://img.shields.io/github/v/release/Uncommon/Xit?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Uncommon/Xit'><img src='https://img.shields.io/github/stars/Uncommon/Xit?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Uncommon/Xit' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Uncommon/Xit/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="json-parsing"></a>
#### 🔄 JSON Parsing (4)
- [j2s](https://github.com/zadr/j2s) - macOS app to convert JSON objects into Swift structs (currently targets Swift 4 and Codable). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/zadr/j2s/releases/latest'><img src='https://img.shields.io/github/v/release/zadr/j2s?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/zadr/j2s'><img src='https://img.shields.io/github/stars/zadr/j2s?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/zadr/j2s' alt='License'/>

  </p>
  </details>

- [JSON Mapper](https://github.com/AppCraft-LLC/json-mapper) - Simple macOS app to generate Swift Object Mapper classes from JSON. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AppCraft-LLC/json-mapper/releases/latest'><img src='https://img.shields.io/github/v/release/AppCraft-LLC/json-mapper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AppCraft-LLC/json-mapper'><img src='https://img.shields.io/github/stars/AppCraft-LLC/json-mapper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AppCraft-LLC/json-mapper' alt='License'/>

  </p>
  </details>

- [JSON to Model class](https://github.com/chanonly123/Json-Model-Generator) - Template based highly customizable macOS app to generate classes from JSON string, supports many languages. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/chanonly123/Json-Model-Generator/releases/latest'><img src='https://img.shields.io/github/v/release/chanonly123/Json-Model-Generator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/chanonly123/Json-Model-Generator'><img src='https://img.shields.io/github/stars/chanonly123/Json-Model-Generator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/chanonly123/Json-Model-Generator' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/chanonly123/Json-Model-Generator/master/demo1.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [JSONExport](https://github.com/Ahmed-Ali/JSONExport) - Desktop application for macOS which enables you to export JSON objects as model classes with their associated constructors, utility methods, setters and getters in your favorite language. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Ahmed-Ali/JSONExport/releases/latest'><img src='https://img.shields.io/github/v/release/Ahmed-Ali/JSONExport?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Ahmed-Ali/JSONExport'><img src='https://img.shields.io/github/stars/Ahmed-Ali/JSONExport?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Ahmed-Ali/JSONExport' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/5157350/5228493/72693010-7713-11e4-9e42-625a8590424a.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="other-development"></a>
#### 🔧 Other Development (5)
- [Boop](https://github.com/IvanMathy/Boop) - A scriptable scratchpad for developers.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/IvanMathy/Boop/releases/latest'><img src='https://img.shields.io/github/v/release/IvanMathy/Boop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/IvanMathy/Boop'><img src='https://img.shields.io/github/stars/IvanMathy/Boop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/IvanMathy/Boop' alt='License'/>

  **Website:** [https://boop.okat.best](https://boop.okat.best)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/IvanMathy/Boop/main/Boop/Documentation/Images/UI.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ChefInspector](https://github.com/Yasumoto/ChefInspector) - Node and Attribute viewer for Chef 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Yasumoto/ChefInspector/releases/latest'><img src='https://img.shields.io/github/v/release/Yasumoto/ChefInspector?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Yasumoto/ChefInspector'><img src='https://img.shields.io/github/stars/Yasumoto/ChefInspector?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Yasumoto/ChefInspector' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Yasumoto/ChefInspector/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [macho-browser](https://github.com/dcsch/macho-browser) - Browser for macOS Mach-O binaries.  

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/dcsch/macho-browser/releases/latest'><img src='https://img.shields.io/github/v/release/dcsch/macho-browser?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dcsch/macho-browser'><img src='https://img.shields.io/github/stars/dcsch/macho-browser?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dcsch/macho-browser' alt='License'/>

  </p>
  </details>

- [MQTTX](https://github.com/emqx/MQTTX) - An elegant Cross-platform MQTT 5.0 desktop client.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/emqx/MQTTX/releases/latest'><img src='https://img.shields.io/github/v/release/emqx/MQTTX?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/emqx/MQTTX'><img src='https://img.shields.io/github/stars/emqx/MQTTX?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/emqx/MQTTX' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/emqx/MQTTX/master/assets/mqttx-gif.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/emqx/MQTTX/master/assets/mqttx-preview.png' width='400' loading='lazy'/>

  </p>
  </details>

- [vegvisir](https://github.com/ant4g0nist/vegvisir) - Browser based GUI for **LLDB** Debugger. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/ant4g0nist/vegvisir/releases/latest'><img src='https://img.shields.io/github/v/release/ant4g0nist/vegvisir?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ant4g0nist/vegvisir'><img src='https://img.shields.io/github/stars/ant4g0nist/vegvisir?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ant4g0nist/vegvisir' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ant4g0nist/vegvisir/master/Screenshots/funcs.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/ant4g0nist/vegvisir/master/Screenshots/sections.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/ant4g0nist/vegvisir/master/Screenshots/blank.png' width='400' loading='lazy'/>

  *(5 more screenshots available in the repository)*

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="web-development"></a>
#### 🌍 Web Development (15)
- [aws-s3-uploader](https://github.com/RafalWilinski/s3-uploader) - Simple macOS app for uploading files to Amazon Web Services. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/RafalWilinski/s3-uploader/releases/latest'><img src='https://img.shields.io/github/v/release/RafalWilinski/s3-uploader?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/RafalWilinski/s3-uploader'><img src='https://img.shields.io/github/stars/RafalWilinski/s3-uploader?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/RafalWilinski/s3-uploader' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/RafalWilinski/s3-uploader/master/upload_anim.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Corectl App for macOS](https://github.com/TheNewNormal/corectl.app) - Corectl App is a macOS Status bar App which works like a wrapper around the corectl command line tool corectld to control the server runtime process. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/TheNewNormal/corectl.app/releases/latest'><img src='https://img.shields.io/github/v/release/TheNewNormal/corectl.app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/TheNewNormal/corectl.app'><img src='https://img.shields.io/github/stars/TheNewNormal/corectl.app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/TheNewNormal/corectl.app' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/TheNewNormal/corectl.app/master/corectl_app.png' width='400' loading='lazy'/>

  </p>
  </details>

- [CoreOS VM](https://github.com/TheNewNormal/coreos-osx) - CoreOS VM is macOS status bar app which allows in an easy way to control CoreOS VM on your Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/TheNewNormal/coreos-osx/releases/latest'><img src='https://img.shields.io/github/v/release/TheNewNormal/coreos-osx?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/TheNewNormal/coreos-osx'><img src='https://img.shields.io/github/stars/TheNewNormal/coreos-osx?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/TheNewNormal/coreos-osx' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/TheNewNormal/coreos-osx/master/coreos-osx.png' width='400' loading='lazy'/>

  </p>
  </details>

- [HTTP Toolkit](https://github.com/httptoolkit/httptoolkit-desktop) - HTTP Toolkit is a cross-platform tool to intercept, debug & mock HTTP. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/httptoolkit/httptoolkit-desktop/releases/latest'><img src='https://img.shields.io/github/v/release/httptoolkit/httptoolkit-desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/httptoolkit/httptoolkit-desktop'><img src='https://img.shields.io/github/stars/httptoolkit/httptoolkit-desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/httptoolkit/httptoolkit-desktop' alt='License'/>

  **Website:** [https://httptoolkit.com/](https://httptoolkit.com/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/httptoolkit/httptoolkit.tech/master/src/images/inspect-screenshot.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/httptoolkit/httptoolkit.tech/master/src/images/intercept-screenshot.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/httptoolkit/httptoolkit.tech/master/src/images/edit-screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Insomnia](https://github.com/Kong/insomnia) - Insomnia is a cross-platform REST client, built on top of Electron. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/Kong/insomnia/releases/latest'><img src='https://img.shields.io/github/v/release/Kong/insomnia?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Kong/insomnia'><img src='https://img.shields.io/github/stars/Kong/insomnia?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Kong/insomnia' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/getinsomnia/insomnia/master/screenshots/main.png' width='400' loading='lazy'/>

  </p>
  </details>

- [iTunesConnect](https://github.com/trulyronak/itunesconnect) - macOS app to let you access iTunesConnect. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/trulyronak/itunesconnect/releases/latest'><img src='https://img.shields.io/github/v/release/trulyronak/itunesconnect?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/trulyronak/itunesconnect'><img src='https://img.shields.io/github/stars/trulyronak/itunesconnect?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/trulyronak/itunesconnect' alt='License'/>

  </p>
  </details>

- [KubeMonitor](https://github.com/Daniel-Sanche/KubeMonitor) - KubeMonitor is a macOS app that displays information about your active Kubernetes cluster in your menu bar. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Daniel-Sanche/KubeMonitor/releases/latest'><img src='https://img.shields.io/github/v/release/Daniel-Sanche/KubeMonitor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Daniel-Sanche/KubeMonitor'><img src='https://img.shields.io/github/stars/Daniel-Sanche/KubeMonitor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Daniel-Sanche/KubeMonitor' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/DanSanche/KubeMonitor/master/Screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [KubeSwitch](https://github.com/nsriram/KubeSwitch) - KubeSwitch lists the available kubernetes cluster contexts on the mac, in Mac's Menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/nsriram/KubeSwitch/releases/latest'><img src='https://img.shields.io/github/v/release/nsriram/KubeSwitch?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nsriram/KubeSwitch'><img src='https://img.shields.io/github/stars/nsriram/KubeSwitch?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nsriram/KubeSwitch' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/nsriram/KubeSwitch/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Lantern](https://github.com/RoyalIcing/Lantern) - Dedicated Mac app for website auditing and crawling. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/RoyalIcing/Lantern/releases/latest'><img src='https://img.shields.io/github/v/release/RoyalIcing/Lantern?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/RoyalIcing/Lantern'><img src='https://img.shields.io/github/stars/RoyalIcing/Lantern?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/RoyalIcing/Lantern' alt='License'/>

  </p>
  </details>

- [LocalSites](https://github.com/plan44/localSites) - Simple Menu Bar (Status Bar) App for macOS listing local Bonjour websites (as Safari 11 no longer has Bonjour Bookmarks). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/plan44/localSites/releases/latest'><img src='https://img.shields.io/github/v/release/plan44/localSites?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/plan44/localSites'><img src='https://img.shields.io/github/stars/plan44/localSites?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/plan44/localSites' alt='License'/>

  </p>
  </details>

- [ndm](https://github.com/720kb/ndm) - Npm desktop GUI. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/720kb/ndm/releases/latest'><img src='https://img.shields.io/github/v/release/720kb/ndm?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/720kb/ndm'><img src='https://img.shields.io/github/stars/720kb/ndm?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/720kb/ndm' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/6KL3pt7.png' width='400' loading='lazy'/>

  </p>
  </details>

- [nodeScratchpad](https://github.com/vsaravind007/nodeScratchpad) - Evaluate Nodejs/JS code snippets from Menubar. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/vsaravind007/nodeScratchpad/releases/latest'><img src='https://img.shields.io/github/v/release/vsaravind007/nodeScratchpad?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vsaravind007/nodeScratchpad'><img src='https://img.shields.io/github/stars/vsaravind007/nodeScratchpad?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vsaravind007/nodeScratchpad' alt='License'/>

  </p>
  </details>

- [Requestly](https://github.com/requestly/requestly) - A lightweight open-source API Development, Testing & Mocking platform

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/requestly/requestly/releases/latest'><img src='https://img.shields.io/github/v/release/requestly/requestly?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/requestly/requestly'><img src='https://img.shields.io/github/stars/requestly/requestly?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/requestly/requestly' alt='License'/>

  **Website:** [https://requestly.com](https://requestly.com)

  **Screenshots:**

  <img src='https://github.com/user-attachments/assets/a962b213-8744-4ffc-bd04-fcf891f48914' width='400' loading='lazy'/>

  <img src='https://github.com/user-attachments/assets/7bc00c7e-c280-40eb-9a2a-c070ecdea662' width='400' loading='lazy'/>

  </p>
  </details>

- [SimpleLocalize CLI](https://github.com/simplelocalize/simplelocalize-cli) - Open source tool for managing i18n keys in software projects.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/simplelocalize/simplelocalize-cli/releases/latest'><img src='https://img.shields.io/github/v/release/simplelocalize/simplelocalize-cli?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/simplelocalize/simplelocalize-cli'><img src='https://img.shields.io/github/stars/simplelocalize/simplelocalize-cli?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/simplelocalize/simplelocalize-cli' alt='License'/>

  **Website:** [https://simplelocalize.io](https://simplelocalize.io)

  </p>
  </details>

- [stts](https://github.com/inket/stts) - macOS app for monitoring the status of cloud services. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/inket/stts/releases/latest'><img src='https://img.shields.io/github/v/release/inket/stts?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/inket/stts'><img src='https://img.shields.io/github/stars/inket/stts?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/inket/stts' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/OAK3hR0.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="ios--macos"></a>
#### 📱 iOS / macOS (41)
- [AppBox](https://github.com/getappbox/AppBox-iOSAppsWirelessInstallation) - Tool for iOS developers to build and deploy Development, Ad-Hoc and In-house (Enterprise) applications directly to the devices from your Dropbox account. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/getappbox/AppBox-iOSAppsWirelessInstallation/releases/latest'><img src='https://img.shields.io/github/v/release/getappbox/AppBox-iOSAppsWirelessInstallation?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/getappbox/AppBox-iOSAppsWirelessInstallation'><img src='https://img.shields.io/github/stars/getappbox/AppBox-iOSAppsWirelessInstallation?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/getappbox/AppBox-iOSAppsWirelessInstallation' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/getappbox/Home/master/Images/UploadIPA-Dark.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/getappbox/Home/master/Images/Dashboard-Dark.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/getappbox/Home/master/Images/AppURL.png' width='400' loading='lazy'/>

  </p>
  </details>

- [AppIcons](https://github.com/kuyawa/AppIcons) - Tool for generating icons in all sizes as required by macOS and iOS apps. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/kuyawa/AppIcons/releases/latest'><img src='https://img.shields.io/github/v/release/kuyawa/AppIcons?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kuyawa/AppIcons'><img src='https://img.shields.io/github/stars/kuyawa/AppIcons?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kuyawa/AppIcons' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/kuyawa/Gallery/master/AppIcons/appicons.png' width='400' loading='lazy'/>

  </p>
  </details>

- [AppleTrace](https://github.com/everettjf/AppleTrace) - Trace tool for iOS/macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/everettjf/AppleTrace/releases/latest'><img src='https://img.shields.io/github/v/release/everettjf/AppleTrace?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/everettjf/AppleTrace'><img src='https://img.shields.io/github/stars/everettjf/AppleTrace?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/everettjf/AppleTrace' alt='License'/>

  </p>
  </details>

- [AppStoreReviewTimes](https://github.com/arbel03/AppStoreReviewTimes) - Gives you indication about the average iOS / macOS app stores review times. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/arbel03/AppStoreReviewTimes/releases/latest'><img src='https://img.shields.io/github/v/release/arbel03/AppStoreReviewTimes?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/arbel03/AppStoreReviewTimes'><img src='https://img.shields.io/github/stars/arbel03/AppStoreReviewTimes?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/arbel03/AppStoreReviewTimes' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/Y0jr8lF.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/rwBYris.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Asset Catalog Tinkerer](https://github.com/insidegui/AssetCatalogTinkerer) - App that lets you open .car files and browse/extract their images.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/AssetCatalogTinkerer/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/AssetCatalogTinkerer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/AssetCatalogTinkerer'><img src='https://img.shields.io/github/stars/insidegui/AssetCatalogTinkerer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/AssetCatalogTinkerer' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/insidegui/AssetCatalogTinkerer/master/screenshot.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/insidegui/AssetCatalogTinkerer/master/screenshot_themestore.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/insidegui/AssetCatalogTinkerer/master/quicklook_thumb.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Assets](https://github.com/e7711bbear/Assets) - Assets is a macOS app that manages assets for your development projects (Xcode, web, etc). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/e7711bbear/Assets/releases/latest'><img src='https://img.shields.io/github/v/release/e7711bbear/Assets?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/e7711bbear/Assets'><img src='https://img.shields.io/github/stars/e7711bbear/Assets?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/e7711bbear/Assets' alt='License'/>

  </p>
  </details>

- [Attabench](https://github.com/attaswift/Attabench) - Attabench is a microbenchmarking app for macOS, designed to measure and visualize the performance of Swift code. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/attaswift/Attabench/releases/latest'><img src='https://img.shields.io/github/v/release/attaswift/Attabench?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/attaswift/Attabench'><img src='https://img.shields.io/github/stars/attaswift/Attabench?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/attaswift/Attabench' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/attaswift/Attabench/master/Images/Attabench-screenshot.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/attaswift/Attabench/master/Images/Header.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/attaswift/Attabench/master/Images/SampleBenchmark.png' width='400' loading='lazy'/>

  </p>
  </details>

- [AVXCAssets Generator](https://github.com/angelvasa/AVXCAssets-Generator) - Takes path for your assets images and creates appiconset and imageset for you in just one click. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/angelvasa/AVXCAssets-Generator/releases/latest'><img src='https://img.shields.io/github/v/release/angelvasa/AVXCAssets-Generator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/angelvasa/AVXCAssets-Generator'><img src='https://img.shields.io/github/stars/angelvasa/AVXCAssets-Generator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/angelvasa/AVXCAssets-Generator' alt='License'/>

  </p>
  </details>

- [Board For GitHub](https://github.com/JustinFincher/BoardForGitHub) - Small application to monitor your GitHub project web page in a native macOS app :octocat:! 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/JustinFincher/BoardForGitHub/releases/latest'><img src='https://img.shields.io/github/v/release/JustinFincher/BoardForGitHub?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/JustinFincher/BoardForGitHub'><img src='https://img.shields.io/github/stars/JustinFincher/BoardForGitHub?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/JustinFincher/BoardForGitHub' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/JustinFincher/BoardForGitHub/master/DemoImgs/1.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/JustinFincher/BoardForGitHub/master/DemoImgs/2.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/JustinFincher/BoardForGitHub/master/DemoImgs/Banner.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Brisk](https://github.com/br1sk/brisk) - macOS app for submitting radars. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/br1sk/brisk/releases/latest'><img src='https://img.shields.io/github/v/release/br1sk/brisk?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/br1sk/brisk'><img src='https://img.shields.io/github/stars/br1sk/brisk?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/br1sk/brisk' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/br1sk/brisk/master/.github/AppIcon.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/br1sk/brisk/master/.github/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [calabash-launcher](https://github.com/xing/calabash-launcher) - iOS Calabash Launcher is a macOS app that helps you run and manage Calabash tests on your Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/xing/calabash-launcher/releases/latest'><img src='https://img.shields.io/github/v/release/xing/calabash-launcher?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/xing/calabash-launcher'><img src='https://img.shields.io/github/stars/xing/calabash-launcher?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/xing/calabash-launcher' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/18147900/32694248-d8c2d7c8-c73b-11e7-8803-81590d61fbf9.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/18147900/32609402-e9b05aa2-c55f-11e7-99d6-c2c1b5b8195d.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/18147900/34467506-8ca05b50-eef4-11e7-9ca0-1373ba7ddd19.png' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [Cleaner for Xcode](https://github.com/waylybaye/XcodeCleaner) - Cleaner for Xcode.app built with react-native-macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/waylybaye/XcodeCleaner/releases/latest'><img src='https://img.shields.io/github/v/release/waylybaye/XcodeCleaner?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/waylybaye/XcodeCleaner'><img src='https://img.shields.io/github/stars/waylybaye/XcodeCleaner?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/waylybaye/XcodeCleaner' alt='License'/>

  </p>
  </details>

- [CocoaRestClient](https://github.com/mmattozzi/cocoa-rest-client) - Native Apple macOS app for testing HTTP/REST endpoints. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/mmattozzi/cocoa-rest-client/releases/latest'><img src='https://img.shields.io/github/v/release/mmattozzi/cocoa-rest-client?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mmattozzi/cocoa-rest-client'><img src='https://img.shields.io/github/stars/mmattozzi/cocoa-rest-client?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mmattozzi/cocoa-rest-client' alt='License'/>

  **Screenshots:**

  <img src='https://mmattozzi.github.io/cocoa-rest-client/screenshots/screenshot-1.png' width='400' loading='lazy'/>

  <img src='https://mmattozzi.github.io/cocoa-rest-client/screenshots/screenshot-2.png' width='400' loading='lazy'/>

  <img src='https://mmattozzi.github.io/cocoa-rest-client/screenshots/screenshot-4.png' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [Corona Tracker](https://github.com/MhdHejazi/CoronaTracker) - Coronavirus tracker app for iOS & macOS with maps & charts.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/MhdHejazi/CoronaTracker/releases/latest'><img src='https://img.shields.io/github/v/release/MhdHejazi/CoronaTracker?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/MhdHejazi/CoronaTracker'><img src='https://img.shields.io/github/stars/MhdHejazi/CoronaTracker?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/MhdHejazi/CoronaTracker' alt='License'/>

  **Website:** [https://coronatracker.samabox.com/](https://coronatracker.samabox.com/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/121827/77247007-03751b80-6c3e-11ea-91fc-b3d535fda6a2.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/121827/77246699-e25efb80-6c3a-11ea-8a49-30bd87ff33c0.png' width='400' loading='lazy'/>

  </p>
  </details>

- [FilterShop](https://github.com/KrisYu/FilterShop) - macOS App to explore CoreImage Filters. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/KrisYu/FilterShop/releases/latest'><img src='https://img.shields.io/github/v/release/KrisYu/FilterShop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/KrisYu/FilterShop'><img src='https://img.shields.io/github/stars/KrisYu/FilterShop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/KrisYu/FilterShop' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/KrisYu/FilterShop/master/showcase.png' width='400' loading='lazy'/>

  </p>
  </details>

- [IconGenerator](https://github.com/onmyway133/IconGenerator) - macOS app to generate app icons. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/onmyway133/IconGenerator/releases/latest'><img src='https://img.shields.io/github/v/release/onmyway133/IconGenerator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/onmyway133/IconGenerator'><img src='https://img.shields.io/github/stars/onmyway133/IconGenerator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/onmyway133/IconGenerator' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/onmyway133/IconGenerator/master/Screenshots/gif.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/onmyway133/IconGenerator/master/Screenshots/banner.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Iconizer](https://github.com/raphaelhanneken/iconizer) - Create Xcode image catalogs (xcassets) on the fly. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/raphaelhanneken/iconizer/releases/latest'><img src='https://img.shields.io/github/v/release/raphaelhanneken/iconizer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/raphaelhanneken/iconizer'><img src='https://img.shields.io/github/stars/raphaelhanneken/iconizer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/raphaelhanneken/iconizer' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/raphaelhanneken/iconizer/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Iconology](https://github.com/liamrosenfeld/Iconology) - Edit icons and then export to Xcode, icns, ico, favicon, macOS iconset, or a custom collection. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://apps.apple.com/us/app/iconology/id1463452867'><img src='./icons/app_store-16.png' alt='App Store' title='Download on the Mac App Store' height='16'/> App Store</a> &nbsp; <a href='https://github.com/liamrosenfeld/Iconology/releases/latest'><img src='https://img.shields.io/github/v/release/liamrosenfeld/Iconology?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/liamrosenfeld/Iconology'><img src='https://img.shields.io/github/stars/liamrosenfeld/Iconology?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/liamrosenfeld/Iconology' alt='License'/>

  **Website:** [https://apps.apple.com/us/app/iconology/id1463452867](https://apps.apple.com/us/app/iconology/id1463452867)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/liamrosenfeld/Iconology/main/Iconology/Assets.xcassets/Logo.imageset/logo-long-black.svg' width='400' loading='lazy'/>

  </p>
  </details>

- [Icons.app](https://github.com/SAP/macos-icon-generator) - App for macOS which is designed to generate consistent sized icons of an existing application in various states, jiggling (shaking) etc. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/SAP/macos-icon-generator/releases/latest'><img src='https://img.shields.io/github/v/release/SAP/macos-icon-generator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/SAP/macos-icon-generator'><img src='https://img.shields.io/github/stars/SAP/macos-icon-generator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/SAP/macos-icon-generator' alt='License'/>

  </p>
  </details>

- [InjectionIII](https://github.com/johnno1962/InjectionIII) - overdue Swift rewrite of Injection.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/johnno1962/InjectionIII/releases/latest'><img src='https://img.shields.io/github/v/release/johnno1962/InjectionIII?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/johnno1962/InjectionIII'><img src='https://img.shields.io/github/stars/johnno1962/InjectionIII?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/johnno1962/InjectionIII' alt='License'/>

  </p>
  </details>

- [iOS Images Extractor](https://github.com/devcxm/iOS-Images-Extractor) - iOS Images Extractor is a Mac app to normalize, decode, and extract images from iOS apps. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/devcxm/iOS-Images-Extractor/releases/latest'><img src='https://img.shields.io/github/v/release/devcxm/iOS-Images-Extractor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/devcxm/iOS-Images-Extractor'><img src='https://img.shields.io/github/stars/devcxm/iOS-Images-Extractor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/devcxm/iOS-Images-Extractor' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/devcxm/iOS-Images-Extractor/master/iOSImagesExtractor/iOSImagesExtractor/Images.xcassets/AppIcon.appiconset/AppIcon-256.png' width='400' loading='lazy'/>

  <img src='https://cloud.githubusercontent.com/assets/8568955/7927878/874f0594-0918-11e5-9fe3-452372f5affd.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [iSimulator](https://github.com/wigl/iSimulator) - iSimulator is a GUI utility to control the Simulator and manage the app installed on the simulator. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/wigl/iSimulator/releases/latest'><img src='https://img.shields.io/github/v/release/wigl/iSimulator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wigl/iSimulator'><img src='https://img.shields.io/github/stars/wigl/iSimulator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wigl/iSimulator' alt='License'/>

  </p>
  </details>

- [Knuff](https://github.com/KnuffApp/Knuff) - The debug application for Apple Push Notification Service (APNs). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/KnuffApp/Knuff/releases/latest'><img src='https://img.shields.io/github/v/release/KnuffApp/Knuff?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/KnuffApp/Knuff'><img src='https://img.shields.io/github/stars/KnuffApp/Knuff?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/KnuffApp/Knuff' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/499192/12481271/36b610e0-c048-11e5-9be6-ee9e996036a2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [LayerX](https://github.com/yuhua-chen/LayerX) - Intuitive app to display transparent images on screen. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/yuhua-chen/LayerX/releases/latest'><img src='https://img.shields.io/github/v/release/yuhua-chen/LayerX?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/yuhua-chen/LayerX'><img src='https://img.shields.io/github/stars/yuhua-chen/LayerX?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/yuhua-chen/LayerX' alt='License'/>

  **Screenshots:**

  <img src='http://img.youtube.com/vi/35KixjZBDjY/0.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Localizable.strings](https://github.com/cristibaluta/Localizable.strings) - Mac app to localize your iOS and macOS projects. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/cristibaluta/Localizable.strings/releases/latest'><img src='https://img.shields.io/github/v/release/cristibaluta/Localizable.strings?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/cristibaluta/Localizable.strings'><img src='https://img.shields.io/github/stars/cristibaluta/Localizable.strings?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/cristibaluta/Localizable.strings' alt='License'/>

  </p>
  </details>

- [Localization Editor](https://github.com/igorkulman/iOSLocalizationEditor) - Simple macOS editor app to help you manage iOS app localizations by allowing you to edit all the translations side by side. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/igorkulman/iOSLocalizationEditor/releases/latest'><img src='https://img.shields.io/github/v/release/igorkulman/iOSLocalizationEditor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/igorkulman/iOSLocalizationEditor'><img src='https://img.shields.io/github/stars/igorkulman/iOSLocalizationEditor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/igorkulman/iOSLocalizationEditor' alt='License'/>

  </p>
  </details>

- [Localizations](https://github.com/e7711bbear/Localizations) - Localizations is an macOS app that manages your Xcode project localization files (.strings). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/e7711bbear/Localizations/releases/latest'><img src='https://img.shields.io/github/v/release/e7711bbear/Localizations?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/e7711bbear/Localizations'><img src='https://img.shields.io/github/stars/e7711bbear/Localizations?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/e7711bbear/Localizations' alt='License'/>

  </p>
  </details>

- [Menubar Colors](https://github.com/nvzqz/Menubar-Colors) - macOS app for convenient access to the system color panel. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/nvzqz/Menubar-Colors/releases/latest'><img src='https://img.shields.io/github/v/release/nvzqz/Menubar-Colors?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nvzqz/Menubar-Colors'><img src='https://img.shields.io/github/stars/nvzqz/Menubar-Colors?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nvzqz/Menubar-Colors' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/nvzqz/Menubar-Colors/master/Example.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Notarize](https://github.com/macmade/Notarize) - Notarization status monitoring tool for macOS, supporting multiple developer accounts

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/macmade/Notarize/releases/latest'><img src='https://img.shields.io/github/v/release/macmade/Notarize?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/macmade/Notarize'><img src='https://img.shields.io/github/stars/macmade/Notarize?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/macmade/Notarize' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/macmade/Notarize/master/Assets/MainWindow.png' width='400' loading='lazy'/>

  </p>
  </details>

- [PodsUpdater](https://github.com/kizitonwose/PodsUpdater) - macOS app which helps you manage dependency releases in your Podfile. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/kizitonwose/PodsUpdater/releases/latest'><img src='https://img.shields.io/github/v/release/kizitonwose/PodsUpdater?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kizitonwose/PodsUpdater'><img src='https://img.shields.io/github/stars/kizitonwose/PodsUpdater?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kizitonwose/PodsUpdater' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/kizitonwose/PodsUpdater/master/Assets/screenshot_2.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/kizitonwose/PodsUpdater/master/Assets/screenshot_1.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ProfilesManager](https://github.com/shaojiankui/ProfilesManager) - Apple iOS/macOS Provisioning Profiles management,.provisionprofile, .mobileprovision files manager tool for mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/shaojiankui/ProfilesManager/releases/latest'><img src='https://img.shields.io/github/v/release/shaojiankui/ProfilesManager?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/shaojiankui/ProfilesManager'><img src='https://img.shields.io/github/stars/shaojiankui/ProfilesManager?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/shaojiankui/ProfilesManager' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/shaojiankui/ProfilesManager/master/demo.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [PushNotifications](https://github.com/onmyway133/PushNotifications) - macOS app to test push notifications on iOS and Android. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/onmyway133/PushNotifications/releases/latest'><img src='https://img.shields.io/github/v/release/onmyway133/PushNotifications?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/onmyway133/PushNotifications'><img src='https://img.shields.io/github/stars/onmyway133/PushNotifications?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/onmyway133/PushNotifications' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/onmyway133/PushNotifications/master/Screenshots/TeamId.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/onmyway133/PushNotifications/master/Screenshots/iOSToken.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/onmyway133/PushNotifications/master/Screenshots/Android.png' width='400' loading='lazy'/>

  *(6 more screenshots available in the repository)*

  </p>
  </details>

- [ResignTool](https://github.com/InjoyDeng/ResignTool) - This is an app for macOS that can (re)sign apps and bundle them into ipa files that are ready to be installed on an iOS device. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/InjoyDeng/ResignTool/releases/latest'><img src='https://img.shields.io/github/v/release/InjoyDeng/ResignTool?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/InjoyDeng/ResignTool'><img src='https://img.shields.io/github/stars/InjoyDeng/ResignTool?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/InjoyDeng/ResignTool' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/H8kRoPf.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Resizr](https://github.com/onurgenes/Resizr) - MacOS application for creating AppIcon for iOS and Android apps.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/onurgenes/Resizr/releases/latest'><img src='https://img.shields.io/github/v/release/onurgenes/Resizr?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/onurgenes/Resizr'><img src='https://img.shields.io/github/stars/onurgenes/Resizr?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/onurgenes/Resizr' alt='License'/>

  </p>
  </details>

- [SmartPush](https://github.com/shaojiankui/SmartPush) - iOS Push Notification Debug App. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/shaojiankui/SmartPush/releases/latest'><img src='https://img.shields.io/github/v/release/shaojiankui/SmartPush?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/shaojiankui/SmartPush'><img src='https://img.shields.io/github/stars/shaojiankui/SmartPush?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/shaojiankui/SmartPush' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/shaojiankui/SmartPush/master/demo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Stringz](https://github.com/mohakapt/Stringz) - A lightweight and powerful editor for localizing iOS, macOS, tvOS, and watchOS applications.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mohakapt/Stringz/releases/latest'><img src='https://img.shields.io/github/v/release/mohakapt/Stringz?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mohakapt/Stringz'><img src='https://img.shields.io/github/stars/mohakapt/Stringz?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mohakapt/Stringz' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mohakapt/Stringz/main/Resources/hero_dark.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/mohakapt/Stringz/main/Resources/hero_light.png' width='400' loading='lazy'/>

  </p>
  </details>

- [TransporterPad](https://github.com/iseebi/TransporterPad) - iOS/Android app deployment tool for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/iseebi/TransporterPad/releases/latest'><img src='https://img.shields.io/github/v/release/iseebi/TransporterPad?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/iseebi/TransporterPad'><img src='https://img.shields.io/github/stars/iseebi/TransporterPad?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/iseebi/TransporterPad' alt='License'/>

  </p>
  </details>

- [WWDC](https://github.com/insidegui/WWDC) - Unofficial WWDC app for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/WWDC/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/WWDC?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/WWDC'><img src='https://img.shields.io/github/stars/insidegui/WWDC?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/WWDC' alt='License'/>

  </p>
  </details>

- [WWDC.srt](https://github.com/ssamadgh/WWDCsrt) - Powerful app for downloading subtitle for each WWDC session video since 2013 in (srt) format. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ssamadgh/WWDCsrt/releases/latest'><img src='https://img.shields.io/github/v/release/ssamadgh/WWDCsrt?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ssamadgh/WWDCsrt'><img src='https://img.shields.io/github/stars/ssamadgh/WWDCsrt?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ssamadgh/WWDCsrt' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ssamadgh/WWDCsrt/master/WWDCSubGetter/Assets.xcassets/AppIcon.appiconset/Icon_256x256.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/ssamadgh/WWDCsrt/master/ScreenShots/Session02.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/ssamadgh/WWDCsrt/master/ScreenShots/VideoLink.png' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [Xcodes.app](https://github.com/RobotsAndPencils/XcodesApp) - The easiest way to install and switch between multiple versions of Xcode.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/RobotsAndPencils/XcodesApp/releases/latest'><img src='https://img.shields.io/github/v/release/RobotsAndPencils/XcodesApp?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/RobotsAndPencils/XcodesApp'><img src='https://img.shields.io/github/stars/RobotsAndPencils/XcodesApp?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/RobotsAndPencils/XcodesApp' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/RobotsAndPencils/XcodesApp/main/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [xib2Storyboard](https://github.com/novemberfiveco/xib2Storyboard) - Tool to convert Xcode .xib to .storyboard files. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/novemberfiveco/xib2Storyboard/releases/latest'><img src='https://img.shields.io/github/v/release/novemberfiveco/xib2Storyboard?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/novemberfiveco/xib2Storyboard'><img src='https://img.shields.io/github/stars/novemberfiveco/xib2Storyboard?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/novemberfiveco/xib2Storyboard' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="downloader"></a>
### ⬇️ Downloader (7)
- [App Downloader](https://github.com/yep/app-downloader) - Easily search and download macOS apps from the huge `homebrew cask` app catalog. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/yep/app-downloader/releases/latest'><img src='https://img.shields.io/github/v/release/yep/app-downloader?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/yep/app-downloader'><img src='https://img.shields.io/github/stars/yep/app-downloader?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/yep/app-downloader' alt='License'/>

  </p>
  </details>

- [Extream Download Manager](https://github.com/subhra74/xdm) - a powerful tool to increase download speeds up to 500%

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/java-16.png' alt='Java icon' title='Java' height='16'/> 

  **Links:** <a href='https://github.com/subhra74/xdm/releases/latest'><img src='https://img.shields.io/github/v/release/subhra74/xdm?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/subhra74/xdm'><img src='https://img.shields.io/github/stars/subhra74/xdm?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/subhra74/xdm' alt='License'/>

  **Website:** [https://subhra74.github.io/xdm/](https://subhra74.github.io/xdm/)

  </p>
  </details>

- [Get It](https://github.com/Kevin-De-Koninck/Get-It) - Native macOS video/audio downloader. Think of it as a youtube downloader that works on many sites. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Kevin-De-Koninck/Get-It/releases/latest'><img src='https://img.shields.io/github/v/release/Kevin-De-Koninck/Get-It?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Kevin-De-Koninck/Get-It'><img src='https://img.shields.io/github/stars/Kevin-De-Koninck/Get-It?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Kevin-De-Koninck/Get-It' alt='License'/>

  </p>
  </details>

- [Motrix](https://github.com/agalwood/Motrix) - A full-featured download manager. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/agalwood/Motrix/releases/latest'><img src='https://img.shields.io/github/v/release/agalwood/Motrix?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/agalwood/Motrix'><img src='https://img.shields.io/github/stars/agalwood/Motrix?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/agalwood/Motrix' alt='License'/>

  **Website:** [https://motrix.app/](https://motrix.app/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/agalwood/Motrix/master/screenshots/motrix-task-list-empty-light%402x.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/agalwood/Motrix/master/screenshots/motrix-task-list-downloading-light%402x.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/agalwood/Motrix/master/screenshots/motrix-task-list-empty-dark%402x.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Pillager](https://github.com/Pjirlip/Pillager) - macOS Video Downloader written in Swift and Objective-C.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Pjirlip/Pillager/releases/latest'><img src='https://img.shields.io/github/v/release/Pjirlip/Pillager?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Pjirlip/Pillager'><img src='https://img.shields.io/github/stars/Pjirlip/Pillager?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Pjirlip/Pillager' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Pjirlip/Pillager/master/docu/pillagerpreview.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/Pjirlip/Pillager/master/docu/useffmpeg.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [udemy-downloader-gui](https://github.com/FaisalUmair/udemy-downloader-gui) - desktop application for downloading Udemy Courses. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/FaisalUmair/udemy-downloader-gui/releases/latest'><img src='https://img.shields.io/github/v/release/FaisalUmair/udemy-downloader-gui?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/FaisalUmair/udemy-downloader-gui'><img src='https://img.shields.io/github/stars/FaisalUmair/udemy-downloader-gui?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/FaisalUmair/udemy-downloader-gui' alt='License'/>

  </p>
  </details>

- [YouTube Downloader for macOS](https://github.com/DenBeke/YouTube-Downloader-for-macOS) - Simple menu bar app to download YouTube movies on your Mac. I wrote this as a test project to learn more about app development on macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/DenBeke/YouTube-Downloader-for-macOS/releases/latest'><img src='https://img.shields.io/github/v/release/DenBeke/YouTube-Downloader-for-macOS?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/DenBeke/YouTube-Downloader-for-macOS'><img src='https://img.shields.io/github/stars/DenBeke/YouTube-Downloader-for-macOS?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/DenBeke/YouTube-Downloader-for-macOS' alt='License'/>

  **Screenshots:**

  <img src='https://denbeke.be/blog/wp-content/uploads/2017/11/Youtube-downloader-macOS-Swift.gif' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="editors"></a>
### 📝 Editors (4)
- [AuroraEditor](https://github.com/AuroraEditor/AuroraEditor) - Lightweight Code Editor (IDE) for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AuroraEditor/AuroraEditor/releases/latest'><img src='https://img.shields.io/github/v/release/AuroraEditor/AuroraEditor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AuroraEditor/AuroraEditor'><img src='https://img.shields.io/github/stars/AuroraEditor/AuroraEditor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AuroraEditor/AuroraEditor' alt='License'/>

  **Website:** [https://auroraeditor.com](https://auroraeditor.com)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/63672227/187914690-2277654c-6cab-4738-b151-1c85947bea8b.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Chime](https://github.com/ChimeHQ/Chime) - An editor for macOS

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ChimeHQ/Chime/releases/latest'><img src='https://img.shields.io/github/v/release/ChimeHQ/Chime?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ChimeHQ/Chime'><img src='https://img.shields.io/github/stars/ChimeHQ/Chime?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ChimeHQ/Chime' alt='License'/>

  **Website:** [https://www.chimehq.com/](https://www.chimehq.com/)

  **Screenshots:**

  <img src='https://www.chimehq.com/assets/images/laptop-frame-large.png' width='400' loading='lazy'/>

  </p>
  </details>

- [CodeEdit](https://github.com/CodeEditApp/CodeEdit) - CodeEdit App for macOS – Elevate your code editing experience. Open source, free forever.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/CodeEditApp/CodeEdit/releases/latest'><img src='https://img.shields.io/github/v/release/CodeEditApp/CodeEdit?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/CodeEditApp/CodeEdit'><img src='https://img.shields.io/github/stars/CodeEditApp/CodeEdit?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/CodeEditApp/CodeEdit' alt='License'/>

  **Website:** [https://www.codeedit.app/](https://www.codeedit.app/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/806104/194004176-3143d19f-1ad9-449c-bd41-8c4f9998f44b.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Geany](https://github.com/geany/geany) - Geany is a powerful, stable and lightweight programmer's text editor that provides tons of useful features without bogging down your workflow.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <code>c++</code> 

  **Links:** <a href='https://github.com/geany/geany/releases/latest'><img src='https://img.shields.io/github/v/release/geany/geany?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/geany/geany'><img src='https://img.shields.io/github/stars/geany/geany?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/geany/geany' alt='License'/>

  **Website:** [https://www.geany.org/](https://www.geany.org/)

  **Screenshots:**

  <img src='https://www.geany.org/media/uploads/screenshots/geany_dark_2019-05-20.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="csv"></a>
#### 📊 CSV (1)
- [TableTool](https://github.com/jakob/TableTool) - simple CSV editor for the macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/jakob/TableTool/releases/latest'><img src='https://img.shields.io/github/v/release/jakob/TableTool?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jakob/TableTool'><img src='https://img.shields.io/github/stars/jakob/TableTool?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jakob/TableTool' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="json"></a>
#### 📋 JSON (2)
- [JSON Editor](https://github.com/fand/json-editor-app) - Dead simple JSON editor using josdejong/jsoneditor

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/fand/json-editor-app/releases/latest'><img src='https://img.shields.io/github/v/release/fand/json-editor-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/fand/json-editor-app'><img src='https://img.shields.io/github/stars/fand/json-editor-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/fand/json-editor-app' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/1403842/73547401-2ecf5b80-4482-11ea-8b03-753c1621c116.png' width='400' loading='lazy'/>

  </p>
  </details>

- [JSON-Splora](https://github.com/wellsjo/JSON-Splora) - GUI for editing, visualizing, and manipulating JSON data. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/wellsjo/JSON-Splora/releases/latest'><img src='https://img.shields.io/github/v/release/wellsjo/JSON-Splora?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wellsjo/JSON-Splora'><img src='https://img.shields.io/github/stars/wellsjo/JSON-Splora?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wellsjo/JSON-Splora' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/CiXIrrg.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/wellsjo/JSON-Splora/master/app/assets/logos/logo.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="markdown"></a>
#### 📝 Markdown (10)
- [Gingko](https://github.com/gingko/client) - Tree-structured markdown editor for macOS, Windows, and Linux. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/elm-16.png' alt='Elm icon' title='Elm' height='16'/> 

  **Links:** <a href='https://github.com/gingko/client/releases/latest'><img src='https://img.shields.io/github/v/release/gingko/client?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gingko/client'><img src='https://img.shields.io/github/stars/gingko/client?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gingko/client' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/gingko/client/master/docs/images/screenshot-alien-screenplay.png' width='400' loading='lazy'/>

  </p>
  </details>

- [linked](https://github.com/lostdesign/linked) - 🧾 Your daily journal app, diary or anything else to unclutter your mind. Let linked help you get focused by writing down what is in your mind on a daily basis. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <code>vue</code> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/lostdesign/linked/releases/latest'><img src='https://img.shields.io/github/v/release/lostdesign/linked?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lostdesign/linked'><img src='https://img.shields.io/github/stars/lostdesign/linked?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lostdesign/linked' alt='License'/>

  **Website:** [https://uselinked.com](https://uselinked.com)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/5164617/112966541-9f3b4080-914a-11eb-9dff-00ea2a121b93.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/5164617/112368648-97f3dd00-8cdb-11eb-8865-0203264d420b.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MacDown](https://github.com/MacDownApp/macdown) - Markdown editor for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/MacDownApp/macdown/releases/latest'><img src='https://img.shields.io/github/v/release/MacDownApp/macdown?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/MacDownApp/macdown'><img src='https://img.shields.io/github/stars/MacDownApp/macdown?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/MacDownApp/macdown' alt='License'/>

  </p>
  </details>

- [Mark Text](https://github.com/marktext/marktext/) - Realtime preview markdown editor for macOS Windows and Linux. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/marktext/marktext/releases/latest'><img src='https://img.shields.io/github/v/release/marktext/marktext?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/marktext/marktext/'><img src='https://img.shields.io/github/stars/marktext/marktext?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/marktext/marktext' alt='License'/>

  </p>
  </details>

- [MarkEdit](https://github.com/MarkEdit-app/MarkEdit) - MarkEdit is a free and open-source Markdown editor, for macOS. It's just like TextEdit on Mac but dedicated to Markdown.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/MarkEdit-app/MarkEdit/releases/latest'><img src='https://img.shields.io/github/v/release/MarkEdit-app/MarkEdit?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/MarkEdit-app/MarkEdit'><img src='https://img.shields.io/github/stars/MarkEdit-app/MarkEdit?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/MarkEdit-app/MarkEdit' alt='License'/>

  **Website:** [https://markedit.app/](https://markedit.app/)

  **Screenshots:**

  <img src='https://github.com/MarkEdit-app/MarkEdit/blob/main/Screenshots/01.png' width='400' loading='lazy'/>

  <img src='https://github.com/MarkEdit-app/MarkEdit/raw/main/Screenshots/02.png' width='400' loading='lazy'/>

  <img src='https://github.com/MarkEdit-app/MarkEdit/blob/main/Screenshots/03.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Notenik](https://github.com/hbowie/notenik-swift) - Note-taking app with many organizational options.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/hbowie/notenik-swift/releases/latest'><img src='https://img.shields.io/github/v/release/hbowie/notenik-swift?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hbowie/notenik-swift'><img src='https://img.shields.io/github/stars/hbowie/notenik-swift?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hbowie/notenik-swift' alt='License'/>

  **Website:** [https://notenik.app](https://notenik.app)

  **Screenshots:**

  <img src='https://notenik.app/images/notenik-list-and-display.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Obsidian plugins & themes](https://github.com/obsidianmd/obsidian-releases) - Community plugins list, theme list, and releases of Obsidian. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/obsidianmd/obsidian-releases/releases/latest'><img src='https://img.shields.io/github/v/release/obsidianmd/obsidian-releases?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/obsidianmd/obsidian-releases'><img src='https://img.shields.io/github/stars/obsidianmd/obsidian-releases?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/obsidianmd/obsidian-releases' alt='License'/>

  **Website:** [https://obsidian.md/](https://obsidian.md/)

  **Screenshots:**

  <img src='' width='400' loading='lazy'/>

  </p>
  </details>

- [Pine](https://github.com/lukakerr/Pine) - A modern MacOS markdown editor. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/lukakerr/Pine/releases/latest'><img src='https://img.shields.io/github/v/release/lukakerr/Pine?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lukakerr/Pine'><img src='https://img.shields.io/github/stars/lukakerr/Pine?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lukakerr/Pine' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/ptzSBmo.jpg' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/14fd8828c4ab0e59f62cd7457fff295fe8113f26/68747470733a2f2f692e696d6775722e636f6d2f767841614e65582e706e67' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/77b139742c8d23e154de89331b5fcfd3672878bf/68747470733a2f2f692e696d6775722e636f6d2f354c51314c6c342e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [QOwnNotes](https://github.com/pbek/QOwnNotes) - Plain-text file notepad and todo-list manager with markdown support and ownCloud / Nextcloud integration.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/pbek/QOwnNotes/releases/latest'><img src='https://img.shields.io/github/v/release/pbek/QOwnNotes?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pbek/QOwnNotes'><img src='https://img.shields.io/github/stars/pbek/QOwnNotes?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pbek/QOwnNotes' alt='License'/>

  **Website:** [https://www.qownnotes.org/](https://www.qownnotes.org/)

  **Screenshots:**

  <img src='https://www.qownnotes.org/screenshots/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Zettlr](https://github.com/Zettlr/Zettlr) - A Markdown Editor for the 21st century.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/Zettlr/Zettlr/releases/latest'><img src='https://img.shields.io/github/v/release/Zettlr/Zettlr?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Zettlr/Zettlr'><img src='https://img.shields.io/github/stars/Zettlr/Zettlr?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Zettlr/Zettlr' alt='License'/>

  **Website:** [https://www.zettlr.com/](https://www.zettlr.com/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Zettlr/Zettlr/develop/resources/screenshots/zettlr_view.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="tex"></a>
#### 📐 TeX (1)
- [Qilin Editor](https://github.com/qilin-editor/qilin-app) - Text editor for exact sciences with built-in KaTeX/AsciiMath support. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/qilin-editor/qilin-app/releases/latest'><img src='https://img.shields.io/github/v/release/qilin-editor/qilin-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/qilin-editor/qilin-app'><img src='https://img.shields.io/github/stars/qilin-editor/qilin-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/qilin-editor/qilin-app' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/VOGLGv5.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/LYzVw99.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/utXxWLf.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="text"></a>
#### ✏️ Text (11)
- [AuroraEditor](https://github.com/AuroraEditor/AuroraEditor) - Lightweight Code Editor (IDE) for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AuroraEditor/AuroraEditor/releases/latest'><img src='https://img.shields.io/github/v/release/AuroraEditor/AuroraEditor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AuroraEditor/AuroraEditor'><img src='https://img.shields.io/github/stars/AuroraEditor/AuroraEditor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AuroraEditor/AuroraEditor' alt='License'/>

  **Website:** [https://auroraeditor.com](https://auroraeditor.com)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/63672227/187914690-2277654c-6cab-4738-b151-1c85947bea8b.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [CotEditor](https://github.com/coteditor/CotEditor) - Lightweight Plain-Text Editor for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/coteditor/CotEditor/releases/latest'><img src='https://img.shields.io/github/v/release/coteditor/CotEditor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/coteditor/CotEditor'><img src='https://img.shields.io/github/stars/coteditor/CotEditor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/coteditor/CotEditor' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/coteditor/CotEditor/master/screenshot@2x.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Geany](https://github.com/geany/geany) - Geany is a powerful, stable and lightweight programmer's text editor that provides tons of useful features without bogging down your workflow.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <code>c++</code> 

  **Links:** <a href='https://github.com/geany/geany/releases/latest'><img src='https://img.shields.io/github/v/release/geany/geany?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/geany/geany'><img src='https://img.shields.io/github/stars/geany/geany?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/geany/geany' alt='License'/>

  **Website:** [https://www.geany.org/](https://www.geany.org/)

  **Screenshots:**

  <img src='https://www.geany.org/media/uploads/screenshots/geany_dark_2019-05-20.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MacVim](https://github.com/macvim-dev/macvim) - Text editor for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/macvim-dev/macvim/releases/latest'><img src='https://img.shields.io/github/v/release/macvim-dev/macvim?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/macvim-dev/macvim'><img src='https://img.shields.io/github/stars/macvim-dev/macvim?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/macvim-dev/macvim' alt='License'/>

  </p>
  </details>

- [micro](https://github.com/zyedidia/micro) - A terminal-based text editor that aims to be easy to use and intuitive, while also taking advantage of the capabilities of modern terminals.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/golang-16.png' alt='Go icon' title='Go' height='16'/> 

  **Links:** <a href='https://github.com/zyedidia/micro/releases/latest'><img src='https://img.shields.io/github/v/release/zyedidia/micro?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/zyedidia/micro'><img src='https://img.shields.io/github/stars/zyedidia/micro?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/zyedidia/micro' alt='License'/>

  **Website:** [https://micro-editor.github.io](https://micro-editor.github.io)

  **Screenshots:**

  <img src='https://micro-editor.github.io/screenshots/micro-monokai.png' width='400' loading='lazy'/>

  <img src='https://micro-editor.github.io/screenshots/micro-one-dark.png' width='400' loading='lazy'/>

  <img src='https://micro-editor.github.io/screenshots/micro-darcula.png' width='400' loading='lazy'/>

  *(8 more screenshots available in the repository)*

  </p>
  </details>

- [Noto](https://github.com/brunophilipe/noto) - Plain text editor for macOS with customizable themes. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/brunophilipe/noto/releases/latest'><img src='https://img.shields.io/github/v/release/brunophilipe/noto?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/brunophilipe/noto'><img src='https://img.shields.io/github/stars/brunophilipe/noto?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/brunophilipe/noto' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/BlqwbV7.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/SXh8o7n.png' width='400' loading='lazy'/>

  </p>
  </details>

- [reventlou](https://github.com/b3z/reventlou) - Personal database as an information management system.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/b3z/reventlou/releases/latest'><img src='https://img.shields.io/github/v/release/b3z/reventlou?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/b3z/reventlou'><img src='https://img.shields.io/github/stars/b3z/reventlou?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/b3z/reventlou' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/b3z/reventlou/blob/master/assets/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [SubEthaEdit](https://github.com/subethaedit/SubEthaEdit) - General purpose plain text editor for macOS. Widely known for its live collaboration feature.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/subethaedit/SubEthaEdit/releases/latest'><img src='https://img.shields.io/github/v/release/subethaedit/SubEthaEdit?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/subethaedit/SubEthaEdit'><img src='https://img.shields.io/github/stars/subethaedit/SubEthaEdit?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/subethaedit/SubEthaEdit' alt='License'/>

  **Screenshots:**

  <img src='https://subethaedit.net/images/screenshots/en-contribute-bright-thumb.png' width='400' loading='lazy'/>

  <img src='https://subethaedit.net/images/screenshots/en-find-bright-thumb.png' width='400' loading='lazy'/>

  </p>
  </details>

- [TextMate](https://github.com/textmate/textmate) - TextMate is a graphical text editor for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/textmate/textmate/releases/latest'><img src='https://img.shields.io/github/v/release/textmate/textmate?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/textmate/textmate'><img src='https://img.shields.io/github/stars/textmate/textmate?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/textmate/textmate' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/textmate/textmate/gh-pages/images/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Tincta](https://github.com/CodingFriends/Tincta) - One-window text editor with syntax highlighting.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/CodingFriends/Tincta/releases/latest'><img src='https://img.shields.io/github/v/release/CodingFriends/Tincta?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/CodingFriends/Tincta'><img src='https://img.shields.io/github/stars/CodingFriends/Tincta?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/CodingFriends/Tincta' alt='License'/>

  **Website:** [https://codingfriends.github.io/Tincta/](https://codingfriends.github.io/Tincta/)

  </p>
  </details>

- [VimR](https://github.com/qvacua/vimr) - Refined Neovim experience for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/qvacua/vimr/releases/latest'><img src='https://img.shields.io/github/v/release/qvacua/vimr?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/qvacua/vimr'><img src='https://img.shields.io/github/stars/qvacua/vimr?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/qvacua/vimr' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="extensions"></a>
### 🧩 Extensions (13)
- [AdGuard for Safari](https://github.com/adguardteam/adguardforsafari) - The most advanced ad blocking extension for Safari

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/adguardteam/adguardforsafari/releases/latest'><img src='https://img.shields.io/github/v/release/adguardteam/adguardforsafari?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/adguardteam/adguardforsafari'><img src='https://img.shields.io/github/stars/adguardteam/adguardforsafari?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/adguardteam/adguardforsafari' alt='License'/>

  **Website:** [https://adguard.com/en/welcome.html](https://adguard.com/en/welcome.html)

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/30d586bf934b280622aeac16949d86bb67184250b2b7902b9ea7fcf53e35ca39/68747470733a2f2f63646e2e616467756172642e636f6d2f7075626c69632f416467756172642f436f6d6d6f6e2f7361666172695f66696c746572732e706e673f' width='400' loading='lazy'/>

  </p>
  </details>

- [BetterPiP](https://github.com/Capevace/BetterPiP) - Use native picture-in-picture with browsers such as Google Chrome for HTML5 videos. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Capevace/BetterPiP/releases/latest'><img src='https://img.shields.io/github/v/release/Capevace/BetterPiP?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Capevace/BetterPiP'><img src='https://img.shields.io/github/stars/Capevace/BetterPiP?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Capevace/BetterPiP' alt='License'/>

  **Screenshots:**

  <img src='https://media.giphy.com/media/3b7gn1cvDnjDk9Kngv/giphy-downsized-large.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Is It Private?](https://github.com/ffittschen/IsItPrivate) - A Safari Extension providing a toolbar icon that changes its visual appearance if Private Browsing is enabled.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ffittschen/IsItPrivate/releases/latest'><img src='https://img.shields.io/github/v/release/ffittschen/IsItPrivate?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ffittschen/IsItPrivate'><img src='https://img.shields.io/github/stars/ffittschen/IsItPrivate?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ffittschen/IsItPrivate' alt='License'/>

  **Website:** [https://florian.codes/projects/is-it-private/](https://florian.codes/projects/is-it-private/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ffittschen/IsItPrivate/master/Assets/Screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Middleclick](https://github.com/artginzburg/MiddleClick-Ventura) - Emulate a scroll wheel click with three finger Click or Tap on MacBook trackpad and Magic Mouse

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/artginzburg/MiddleClick-Ventura/releases/latest'><img src='https://img.shields.io/github/v/release/artginzburg/MiddleClick-Ventura?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/artginzburg/MiddleClick-Ventura'><img src='https://img.shields.io/github/stars/artginzburg/MiddleClick-Ventura?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/artginzburg/MiddleClick-Ventura' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/artginzburg/MiddleClick-Ventura/blob/master/demo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [nef](https://github.com/bow-swift/nef-plugin) - This Xcode extension enables you to make a code selection and export it to a snippets. Available on Mac AppStore.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/bow-swift/nef-plugin/releases/latest'><img src='https://img.shields.io/github/v/release/bow-swift/nef-plugin?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bow-swift/nef-plugin'><img src='https://img.shields.io/github/stars/bow-swift/nef-plugin?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bow-swift/nef-plugin' alt='License'/>

  **Website:** [https://nef.bow-swift.io/](https://nef.bow-swift.io/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/bow-swift/nef-plugin/master/assets/nef-plugin-action-export.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/bow-swift/nef-plugin/master/assets/nef-xcode-preferences.png' width='400' loading='lazy'/>

  </p>
  </details>

- [PageExtender](https://github.com/fphilipe/PageExtender.app) - Extend pages with your own CSS and JS files.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/fphilipe/PageExtender.app/releases/latest'><img src='https://img.shields.io/github/v/release/fphilipe/PageExtender.app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/fphilipe/PageExtender.app'><img src='https://img.shields.io/github/stars/fphilipe/PageExtender.app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/fphilipe/PageExtender.app' alt='License'/>

  **Screenshots:**

  <img src='https://phili.pe/posts/introducing-page-extender-for-safari/app.png' width='400' loading='lazy'/>

  </p>
  </details>

- [PiPifier](https://github.com/arnoappenzeller/PiPifier) - PiPifier is a native macOS 10.12 Safari extension that lets you use every HTML5 video in Picture in Picture mode. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/arnoappenzeller/PiPifier/releases/latest'><img src='https://img.shields.io/github/v/release/arnoappenzeller/PiPifier?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/arnoappenzeller/PiPifier'><img src='https://img.shields.io/github/stars/arnoappenzeller/PiPifier?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/arnoappenzeller/PiPifier' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/arnoappenzeller/PiPifier/master/macOS/Images/demo.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/arnoappenzeller/PiPifier/master/macOS/Images/Banner.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/arnoappenzeller/PiPifier/master/macOS/Images/pipifier_ios_usage.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [PiPTool](https://github.com/bfmatei/PiPTool) - Add the Picture-in-Picture Functionality to YouTube, Netflix, Plex and other video broadcasting services in macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/bfmatei/PiPTool/releases/latest'><img src='https://img.shields.io/github/v/release/bfmatei/PiPTool?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bfmatei/PiPTool'><img src='https://img.shields.io/github/stars/bfmatei/PiPTool?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bfmatei/PiPTool' alt='License'/>

  </p>
  </details>

- [Privacy Redirect for Safari](https://github.com/smmr-software/privacy-redirect-safari) - Redirect Twitter, YouTube, Reddit, Google Maps, Google Search, and Google Translate to privacy friendly alternatives.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/smmr-software/privacy-redirect-safari/releases/latest'><img src='https://img.shields.io/github/v/release/smmr-software/privacy-redirect-safari?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/smmr-software/privacy-redirect-safari'><img src='https://img.shields.io/github/stars/smmr-software/privacy-redirect-safari?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/smmr-software/privacy-redirect-safari' alt='License'/>

  </p>
  </details>

- [Sessions](https://github.com/AlexPerathoner/Sessions) - Safari extension to save your working sessions

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AlexPerathoner/Sessions/releases/latest'><img src='https://img.shields.io/github/v/release/AlexPerathoner/Sessions?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AlexPerathoner/Sessions'><img src='https://img.shields.io/github/stars/AlexPerathoner/Sessions?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AlexPerathoner/Sessions' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/AlexPerathoner/Sessions/master/Screens/Registrazione%20schermo%202019-11-26%20alle%2001.14.21.mov' width='400' loading='lazy'/>

  </p>
  </details>

- [Swimat](https://github.com/Jintin/Swimat) - Swimat is an Xcode plug-in to format your Swift code.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Jintin/Swimat/releases/latest'><img src='https://img.shields.io/github/v/release/Jintin/Swimat?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Jintin/Swimat'><img src='https://img.shields.io/github/stars/Jintin/Swimat?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Jintin/Swimat' alt='License'/>

  **Website:** [https://jintin.github.io/Swimat/](https://jintin.github.io/Swimat/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Jintin/Swimat/master/README/preview.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [ThenGenerator](https://github.com/87kangsw/ThenGenerator) - Xcode Source Editor Extension for 'Then'

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/87kangsw/ThenGenerator/releases/latest'><img src='https://img.shields.io/github/v/release/87kangsw/ThenGenerator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/87kangsw/ThenGenerator'><img src='https://img.shields.io/github/stars/87kangsw/ThenGenerator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/87kangsw/ThenGenerator' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/87kangsw/ThenGenerator/main/.github/images/property.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Ultra TabSaver](https://github.com/Swift-open-source/UltraTabSaver) - Ultra TabSaver is an open-source Tab Manager for Safari

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Swift-open-source/UltraTabSaver/releases/latest'><img src='https://img.shields.io/github/v/release/Swift-open-source/UltraTabSaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Swift-open-source/UltraTabSaver'><img src='https://img.shields.io/github/stars/Swift-open-source/UltraTabSaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Swift-open-source/UltraTabSaver' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Swift-open-source/UltraTabSaver/main/Ultra-TabSaver.gif' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="finder"></a>
### 🔍 Finder (11)
- [cd to... ](https://github.com/jbtule/cdto) - Finder Toolbar app to open the current directory in the Terminal

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/jbtule/cdto/releases/latest'><img src='https://img.shields.io/github/v/release/jbtule/cdto?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jbtule/cdto'><img src='https://img.shields.io/github/stars/jbtule/cdto?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jbtule/cdto' alt='License'/>

  </p>
  </details>

- [Clipy](https://github.com/Clipy/Clipy) - Clipy is a Clipboard extension app for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Clipy/Clipy/releases/latest'><img src='https://img.shields.io/github/v/release/Clipy/Clipy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Clipy/Clipy'><img src='https://img.shields.io/github/stars/Clipy/Clipy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Clipy/Clipy' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Clipy/Clipy/master/Resources/clipy_logo.png' width='400' loading='lazy'/>

  <img src='https://clipy-app.com/img/screenshot1.png' width='400' loading='lazy'/>

  </p>
  </details>

- [CopyQ](https://github.com/hluk/CopyQ) - Clipboard manager with advanced features

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/hluk/CopyQ/releases/latest'><img src='https://img.shields.io/github/v/release/hluk/CopyQ?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hluk/CopyQ'><img src='https://img.shields.io/github/stars/hluk/CopyQ?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hluk/CopyQ' alt='License'/>

  </p>
  </details>

- [dupeGuru](https://github.com/arsenetar/dupeguru/) - dupeGuru is a tool to find duplicate files on your computer. It can scan using file names and file contents.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/arsenetar/dupeguru/releases/latest'><img src='https://img.shields.io/github/v/release/arsenetar/dupeguru?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/arsenetar/dupeguru/'><img src='https://img.shields.io/github/stars/arsenetar/dupeguru?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/arsenetar/dupeguru' alt='License'/>

  **Website:** [https://dupeguru.voltaicideas.net/](https://dupeguru.voltaicideas.net/)

  </p>
  </details>

- [Duplicate Finder](https://github.com/powerwolf543/DuplicateFinder) - It's a useful tool that would help you to find all duplicate files which have the same names in the specific folder.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/powerwolf543/DuplicateFinder/releases/latest'><img src='https://img.shields.io/github/v/release/powerwolf543/DuplicateFinder?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/powerwolf543/DuplicateFinder'><img src='https://img.shields.io/github/stars/powerwolf543/DuplicateFinder?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/powerwolf543/DuplicateFinder' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/16394562/94992308-bc3bf000-05bb-11eb-95a9-907ec334c660.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Finder Go](https://github.com/onmyway133/FinderGo) - macOS app and Finder Sync Extension to open Terminal, iTerm, Hyper from Finder. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/onmyway133/FinderGo/releases/latest'><img src='https://img.shields.io/github/v/release/onmyway133/FinderGo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/onmyway133/FinderGo'><img src='https://img.shields.io/github/stars/onmyway133/FinderGo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/onmyway133/FinderGo' alt='License'/>

  </p>
  </details>

- [FiScript](https://github.com/Mortennn/FiScript) - Execute custom scripts from the MacOS context menu (CTRL+click) in Finder. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Mortennn/FiScript/releases/latest'><img src='https://img.shields.io/github/v/release/Mortennn/FiScript?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Mortennn/FiScript'><img src='https://img.shields.io/github/stars/Mortennn/FiScript?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Mortennn/FiScript' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Mortennn/FiScript/master/Images/landingNoText.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/Mortennn/FiScript/master/Images/logo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [OpenInCode](https://github.com/sozercan/OpenInCode) - Finder toolbar app to open current folder in Visual Studio Code. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/sozercan/OpenInCode/releases/latest'><img src='https://img.shields.io/github/v/release/sozercan/OpenInCode?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sozercan/OpenInCode'><img src='https://img.shields.io/github/stars/sozercan/OpenInCode?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sozercan/OpenInCode' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/F5ZrCmS.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [OpenInTerminal](https://github.com/Ji4n1ng/OpenInTerminal) - Finder Toolbar app for macOS to open the current directory in Terminal, iTerm, Hyper or Alacritty.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Ji4n1ng/OpenInTerminal/releases/latest'><img src='https://img.shields.io/github/v/release/Ji4n1ng/OpenInTerminal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Ji4n1ng/OpenInTerminal'><img src='https://img.shields.io/github/stars/Ji4n1ng/OpenInTerminal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Ji4n1ng/OpenInTerminal' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/11001224/78589385-b797b880-7872-11ea-9062-c11a49461598.gif' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/11001224/78589369-b36b9b00-7872-11ea-8a9e-e3f23e7ce80e.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Quick Look plugins](https://github.com/sindresorhus/quick-look-plugins) - List of useful Quick Look plugins for developers.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/sindresorhus/quick-look-plugins/releases/latest'><img src='https://img.shields.io/github/v/release/sindresorhus/quick-look-plugins?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sindresorhus/quick-look-plugins'><img src='https://img.shields.io/github/stars/sindresorhus/quick-look-plugins?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sindresorhus/quick-look-plugins' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/sindresorhus/quick-look-plugins/master/screenshots/QLColorCode.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sindresorhus/quick-look-plugins/master/screenshots/QLStephen.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sindresorhus/quick-look-plugins/master/screenshots/QLMarkdown.png' width='400' loading='lazy'/>

  *(5 more screenshots available in the repository)*

  </p>
  </details>

- [zoxide](https://github.com/ajeetdsouza/zoxide) - zoxide is a smarter cd command for your terminal.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/ajeetdsouza/zoxide/releases/latest'><img src='https://img.shields.io/github/v/release/ajeetdsouza/zoxide?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ajeetdsouza/zoxide'><img src='https://img.shields.io/github/stars/ajeetdsouza/zoxide?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ajeetdsouza/zoxide' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ajeetdsouza/zoxide/c392a8bb75af098b3906ed66595e79f05af92d1a/contrib/tutorial.webp' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="games"></a>
### 🎮 Games (11)
- [0 A.D.](https://svn.wildfiregames.com/public/ps/trunk/) - Real-time strategy game of ancient warfare

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Website:** [https://play0ad.com](https://play0ad.com)

  **Screenshots:**

  <img src='https://play0ad.com/wp-content/gallery/screenshots/EgyptianPyramids.jpg' width='400' loading='lazy'/>

  <img src='https://play0ad.com/wp-content/gallery/screenshots/screenshot0088.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Battle for Wesnoth](https://github.com/wesnoth/wesnoth) - Turn-based tactical strategy game, featuring both single-player and online multiplayer combat. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/wesnoth/wesnoth/releases/latest'><img src='https://img.shields.io/github/v/release/wesnoth/wesnoth?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wesnoth/wesnoth'><img src='https://img.shields.io/github/stars/wesnoth/wesnoth?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wesnoth/wesnoth' alt='License'/>

  </p>
  </details>

- [Boxer](https://github.com/alunbestor/Boxer) - The DOS game emulator that’s fit for your Mac.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/alunbestor/Boxer/releases/latest'><img src='https://img.shields.io/github/v/release/alunbestor/Boxer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alunbestor/Boxer'><img src='https://img.shields.io/github/stars/alunbestor/Boxer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alunbestor/Boxer' alt='License'/>

  </p>
  </details>

- [Chess](https://opensource.apple.com/source/Chess/Chess-410.4.1/) - The chess app that comes with macOS.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <code>objective-c</code> 

  **Website:** [https://www.apple.com/](https://www.apple.com/)

  **Screenshots:**

  <img src='https://upload.wikimedia.org/wikipedia/commons/8/83/Chess_screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Dolphin](https://github.com/dolphin-emu/dolphin) - Powerful emulator for Nintendo GameCube and Wii games. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/dolphin-emu/dolphin/releases/latest'><img src='https://img.shields.io/github/v/release/dolphin-emu/dolphin?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dolphin-emu/dolphin'><img src='https://img.shields.io/github/stars/dolphin-emu/dolphin?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dolphin-emu/dolphin' alt='License'/>

  </p>
  </details>

- [Dynamic Dark Mode](https://github.com/ApolloZhu/Dynamic-Dark-Mode) - Dynamic Dark Mode is the app you are looking for to power up Dark Mode on macOS Mojave and beyond.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ApolloZhu/Dynamic-Dark-Mode/releases/latest'><img src='https://img.shields.io/github/v/release/ApolloZhu/Dynamic-Dark-Mode?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ApolloZhu/Dynamic-Dark-Mode'><img src='https://img.shields.io/github/stars/ApolloZhu/Dynamic-Dark-Mode?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ApolloZhu/Dynamic-Dark-Mode' alt='License'/>

  **Website:** [https://apollozhu.github.io/Dynamic-Dark-Mode/](https://apollozhu.github.io/Dynamic-Dark-Mode/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/10842684/54065701-b240e800-41f2-11e9-8f7a-5d502ab27c4e.png' width='400' loading='lazy'/>

  </p>
  </details>

- [OpenEmu](https://github.com/OpenEmu/OpenEmu) - Retro video game emulation for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/OpenEmu/OpenEmu/releases/latest'><img src='https://img.shields.io/github/v/release/OpenEmu/OpenEmu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/OpenEmu/OpenEmu'><img src='https://img.shields.io/github/stars/OpenEmu/OpenEmu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/OpenEmu/OpenEmu' alt='License'/>

  **Screenshots:**

  <img src='http://openemu.org/img/intro-md.png' width='400' loading='lazy'/>

  </p>
  </details>

- [OpenRCT2](https://github.com/OpenRCT2/OpenRCT2) - Re-implementation of RollerCoaster Tycoon 2. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/OpenRCT2/OpenRCT2/releases/latest'><img src='https://img.shields.io/github/v/release/OpenRCT2/OpenRCT2?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/OpenRCT2/OpenRCT2'><img src='https://img.shields.io/github/stars/OpenRCT2/OpenRCT2?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/OpenRCT2/OpenRCT2' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/888d993a9716208446bd0d5a762977d6b7993058/68747470733a2f2f692e696d6775722e636f6d2f6537434b3553632e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [Screentendo](https://github.com/AaronRandall/Screentendo) - Turn your screen into a playable level of Mario. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/AaronRandall/Screentendo/releases/latest'><img src='https://img.shields.io/github/v/release/AaronRandall/Screentendo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AaronRandall/Screentendo'><img src='https://img.shields.io/github/stars/AaronRandall/Screentendo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AaronRandall/Screentendo' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/AaronRandall/Screentendo/master/Screentendo/Screentendo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Stockfish](https://github.com/daylen/stockfish-mac) - Beautiful, powerful chess application.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/daylen/stockfish-mac/releases/latest'><img src='https://img.shields.io/github/v/release/daylen/stockfish-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/daylen/stockfish-mac'><img src='https://img.shields.io/github/stars/daylen/stockfish-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/daylen/stockfish-mac' alt='License'/>

  </p>
  </details>

- [Widelands](https://github.com/widelands/widelands) - Widelands is a free, open source real-time strategy game with singleplayer campaigns and a multiplayer mode. The game was inspired by Settlers II™ (© Bluebyte) but has significantly more variety and depth to it.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <code>c++</code> <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> <img src='./icons/Lua-16.png' alt='Lua icon' title='Lua' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/widelands/widelands/releases/latest'><img src='https://img.shields.io/github/v/release/widelands/widelands?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/widelands/widelands'><img src='https://img.shields.io/github/stars/widelands/widelands?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/widelands/widelands' alt='License'/>

  **Website:** [https://www.widelands.org](https://www.widelands.org)

  **Screenshots:**

  <img src='https://www.widelands.org/static/img/welcome.jpg' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="graphics"></a>
### 🎨 Graphics (15)
- [Aseprite](https://github.com/aseprite/aseprite) - Animated sprite editor & pixel art tool (Windows, macOS, Linux).

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/aseprite/aseprite/releases/latest'><img src='https://img.shields.io/github/v/release/aseprite/aseprite?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/aseprite/aseprite'><img src='https://img.shields.io/github/stars/aseprite/aseprite?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/aseprite/aseprite' alt='License'/>

  </p>
  </details>

- [Blender](https://projects.blender.org/) - Blender is the free and open source 3D creation suite. It supports the entirety of the 3D pipeline: modeling, rigging, animation, simulation, rendering, compositing, motion tracking, and video editing.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Website:** [https://www.blender.org](https://www.blender.org)

  **Screenshots:**

  <img src='https://www.blender.org/wp-content/uploads/2019/07/blender_render-1280x720.jpg?x94097' width='400' loading='lazy'/>

  <img src='https://www.blender.org/wp-content/uploads/2019/07/blender_vfx-1280x720.jpg?x94097' width='400' loading='lazy'/>

  <img src='https://www.blender.org/wp-content/uploads/2019/07/modeling02-1280x720.jpg?x94097' width='400' loading='lazy'/>

  *(3 more screenshots available in the repository)*

  </p>
  </details>

- [CaptuocrToy](https://github.com/sfragrance/CaptuocrToy) - Tool to capture screenshot and recognize text by online ocr apis. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sfragrance/CaptuocrToy/releases/latest'><img src='https://img.shields.io/github/v/release/sfragrance/CaptuocrToy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sfragrance/CaptuocrToy'><img src='https://img.shields.io/github/stars/sfragrance/CaptuocrToy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sfragrance/CaptuocrToy' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/gragrance/CaptuocrToy/master/screenshot.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [ColorSet](https://github.com/DigiDNA/ColorSet) - ColorSet is a macOS utility and framework allowing developers to manage custom interface colors with ease.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/csharp-16.png' alt='C# icon' title='C#' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/DigiDNA/ColorSet/releases/latest'><img src='https://img.shields.io/github/v/release/DigiDNA/ColorSet?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/DigiDNA/ColorSet'><img src='https://img.shields.io/github/stars/DigiDNA/ColorSet?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/DigiDNA/ColorSet' alt='License'/>

  **Website:** [https://imazing.com/colorset](https://imazing.com/colorset)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/DigiDNA/ColorSet/master/Assets/ColorSet.png' width='400' loading='lazy'/>

  </p>
  </details>

- [FreeCAD](https://github.com/FreeCAD/FreeCAD) - FreeCAD is an open-source 3D parametric modeler

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <code>c++</code> <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/FreeCAD/FreeCAD/releases/latest'><img src='https://img.shields.io/github/v/release/FreeCAD/FreeCAD?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/FreeCAD/FreeCAD'><img src='https://img.shields.io/github/stars/FreeCAD/FreeCAD?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/FreeCAD/FreeCAD' alt='License'/>

  **Website:** [https://www.freecad.org/](https://www.freecad.org/)

  **Screenshots:**

  <img src='https://www.freecad.org/images/feature-03.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Gaphor](https://github.com/gaphor/gaphor) - Gaphor is the simple modeling tool for UML and SysML.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/gaphor/gaphor/releases/latest'><img src='https://img.shields.io/github/v/release/gaphor/gaphor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gaphor/gaphor'><img src='https://img.shields.io/github/stars/gaphor/gaphor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gaphor/gaphor' alt='License'/>

  **Website:** [https://gaphor.org](https://gaphor.org)

  </p>
  </details>

- [GifCapture](https://github.com/onmyway133/GifCapture) - Gif capture app for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/onmyway133/GifCapture/releases/latest'><img src='https://img.shields.io/github/v/release/onmyway133/GifCapture?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/onmyway133/GifCapture'><img src='https://img.shields.io/github/stars/onmyway133/GifCapture?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/onmyway133/GifCapture' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/onmyway133/GifCapture/master/Images/gifcapture.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/onmyway133/GifCapture/master/Images/Icon.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/onmyway133/GifCapture/master/Images/g2.gif' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Gifcurry](https://github.com/lettier/gifcurry) - Video to GIF maker with a graphical interface capable of cropping, adding text, seeking, and trimming. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/haskell-16.png' alt='Haskell icon' title='Haskell' height='16'/> 

  **Links:** <a href='https://github.com/lettier/gifcurry/releases/latest'><img src='https://img.shields.io/github/v/release/lettier/gifcurry?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lettier/gifcurry'><img src='https://img.shields.io/github/stars/lettier/gifcurry?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lettier/gifcurry' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/KFZyEqq.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/ByyCNuk.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Gifski](https://github.com/sindresorhus/Gifski) - Convert videos to high-quality GIFs. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sindresorhus/Gifski/releases/latest'><img src='https://img.shields.io/github/v/release/sindresorhus/Gifski?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sindresorhus/Gifski'><img src='https://img.shields.io/github/stars/sindresorhus/Gifski?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sindresorhus/Gifski' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/sindresorhus/Gifski/master/Stuff/screenshot2.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sindresorhus/Gifski/master/Stuff/screenshot1.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sindresorhus/Gifski/master/Stuff/screenshot3.jpg' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [InfiniteCanvas](https://github.com/CleanCocoa/InfiniteCanvas) - Proof of concept Mac drawing application. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/CleanCocoa/InfiniteCanvas/releases/latest'><img src='https://img.shields.io/github/v/release/CleanCocoa/InfiniteCanvas?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/CleanCocoa/InfiniteCanvas'><img src='https://img.shields.io/github/stars/CleanCocoa/InfiniteCanvas?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/CleanCocoa/InfiniteCanvas' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/CleanCocoa/InfiniteCanvas/master/assets/title-sketch.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Krita](https://invent.kde.org/graphics/krita) - Krita is a cross-platform application for creating digital art files from scratch like illustrations, concept art, matte painting, textures, comics and animations.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Website:** [https://krita.org/en/](https://krita.org/en/)

  **Screenshots:**

  <img src='https://krita.org/wp-content/uploads/2019/08/krita-ui-40.png' width='400' loading='lazy'/>

  </p>
  </details>

- [macSVG](https://github.com/dsward2/macSVG) - macOS application for designing HTML5 SVG (Scalable Vector Graphics) art and animation with a WebKit web view. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/dsward2/macSVG/releases/latest'><img src='https://img.shields.io/github/v/release/dsward2/macSVG?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dsward2/macSVG'><img src='https://img.shields.io/github/stars/dsward2/macSVG?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dsward2/macSVG' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/dsward2/macSVG/master/README_images/macsvg-screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Material Colors Native](https://github.com/BafS/Material-Colors-native) - Choose your Material colours and copy the hex code. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/BafS/Material-Colors-native/releases/latest'><img src='https://img.shields.io/github/v/release/BafS/Material-Colors-native?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/BafS/Material-Colors-native'><img src='https://img.shields.io/github/stars/BafS/Material-Colors-native?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/BafS/Material-Colors-native' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/jIJ4Gcf.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Pencil2D Animation](https://github.com/pencil2d/pencil) - Pencil2D is an animation/drawing software for macOS, Windows, and Linux. It lets you create traditional hand-drawn animation (cartoon) using both bitmap and vector graphics. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/pencil2d/pencil/releases/latest'><img src='https://img.shields.io/github/v/release/pencil2d/pencil?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pencil2d/pencil'><img src='https://img.shields.io/github/stars/pencil2d/pencil?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pencil2d/pencil' alt='License'/>

  </p>
  </details>

- [ScreenToLayers for macOS](https://github.com/duyquoc/ScreenToLayers) - ScreenToLayers is a macOS application to easily capture your screen as a layered PSD file.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/duyquoc/ScreenToLayers/releases/latest'><img src='https://img.shields.io/github/v/release/duyquoc/ScreenToLayers?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/duyquoc/ScreenToLayers'><img src='https://img.shields.io/github/stars/duyquoc/ScreenToLayers?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/duyquoc/ScreenToLayers' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/duyquoc/ScreenToLayers/master/Others/presentation.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="ide"></a>
### 💻 IDE (12)
- [Apache Netbeans](https://github.com/apache/netbeans) - Apache NetBeans is an IDE, Tooling Platform and Application Framework suitable for development in Java, JavaScript, PHP, HTML5, CSS, and more.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/java-16.png' alt='Java icon' title='Java' height='16'/> 

  **Links:** <a href='https://github.com/apache/netbeans/releases/latest'><img src='https://img.shields.io/github/v/release/apache/netbeans?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/apache/netbeans'><img src='https://img.shields.io/github/stars/apache/netbeans?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/apache/netbeans' alt='License'/>

  **Website:** [https://netbeans.apache.org/](https://netbeans.apache.org/)

  **Screenshots:**

  <img src='https://www.dropbox.com/s/r9ewe87xer4nypj/netbeans_dark.png?dl=0' width='400' loading='lazy'/>

  <img src='https://www.dropbox.com/s/qs2gh43lrsbdkid/netbeans_light.png?dl=0' width='400' loading='lazy'/>

  </p>
  </details>

- [Atom](https://github.com/atom/atom) - The hackable text editor. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/atom/atom/releases/latest'><img src='https://img.shields.io/github/v/release/atom/atom?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/atom/atom'><img src='https://img.shields.io/github/stars/atom/atom?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/atom/atom' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/378023/49132477-f4b77680-f31f-11e8-8357-ac6491761c6c.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/378023/49132478-f4b77680-f31f-11e8-9e10-e8454d8d9b7e.png' width='400' loading='lazy'/>

  </p>
  </details>

- [AuroraEditor](https://github.com/AuroraEditor/AuroraEditor) - Lightweight Code Editor (IDE) for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AuroraEditor/AuroraEditor/releases/latest'><img src='https://img.shields.io/github/v/release/AuroraEditor/AuroraEditor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AuroraEditor/AuroraEditor'><img src='https://img.shields.io/github/stars/AuroraEditor/AuroraEditor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AuroraEditor/AuroraEditor' alt='License'/>

  **Website:** [https://auroraeditor.com](https://auroraeditor.com)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/63672227/187914690-2277654c-6cab-4738-b151-1c85947bea8b.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Brackets](https://github.com/brackets-cont/brackets) - Modern open-source code editor for HTML, CSS and JavaScript that's built in HTML, CSS and JavaScript.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/brackets-cont/brackets/releases/latest'><img src='https://img.shields.io/github/v/release/brackets-cont/brackets?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/brackets-cont/brackets'><img src='https://img.shields.io/github/stars/brackets-cont/brackets?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/brackets-cont/brackets' alt='License'/>

  **Website:** [https://brackets.io/](https://brackets.io/)

  **Screenshots:**

  <img src='https://brackets.io/img/hero.png' width='400' loading='lazy'/>

  </p>
  </details>

- [CodeEdit](https://github.com/CodeEditApp/CodeEdit) - CodeEdit App for macOS – Elevate your code editing experience. Open source, free forever.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/CodeEditApp/CodeEdit/releases/latest'><img src='https://img.shields.io/github/v/release/CodeEditApp/CodeEdit?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/CodeEditApp/CodeEdit'><img src='https://img.shields.io/github/stars/CodeEditApp/CodeEdit?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/CodeEditApp/CodeEdit' alt='License'/>

  **Website:** [https://www.codeedit.app/](https://www.codeedit.app/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/806104/194004176-3143d19f-1ad9-449c-bd41-8c4f9998f44b.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Geany](https://github.com/geany/geany) - Geany is a powerful, stable and lightweight programmer's text editor that provides tons of useful features without bogging down your workflow.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <code>c++</code> 

  **Links:** <a href='https://github.com/geany/geany/releases/latest'><img src='https://img.shields.io/github/v/release/geany/geany?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/geany/geany'><img src='https://img.shields.io/github/stars/geany/geany?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/geany/geany' alt='License'/>

  **Website:** [https://www.geany.org/](https://www.geany.org/)

  **Screenshots:**

  <img src='https://www.geany.org/media/uploads/screenshots/geany_dark_2019-05-20.png' width='400' loading='lazy'/>

  </p>
  </details>

- [IntelliJ IDEA Community Edition](https://github.com/JetBrains/intellij-community) - IntelliJ IDEA is an integrated development environment written in Java for developing computer software

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/java-16.png' alt='Java icon' title='Java' height='16'/> 

  **Links:** <a href='https://github.com/JetBrains/intellij-community/releases/latest'><img src='https://img.shields.io/github/v/release/JetBrains/intellij-community?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/JetBrains/intellij-community'><img src='https://img.shields.io/github/stars/JetBrains/intellij-community?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/JetBrains/intellij-community' alt='License'/>

  **Website:** [https://www.jetbrains.com/idea/](https://www.jetbrains.com/idea/)

  **Screenshots:**

  <img src='https://www.jetbrains.com/idea/img/screenshots/idea_overview_5_1@2x.png' width='400' loading='lazy'/>

  </p>
  </details>

- [LiveCode](https://github.com/livecode/livecode) - Cross-platform development IDE.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/livecode/livecode/releases/latest'><img src='https://img.shields.io/github/v/release/livecode/livecode?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/livecode/livecode'><img src='https://img.shields.io/github/stars/livecode/livecode?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/livecode/livecode' alt='License'/>

  **Website:** [https://livecode.org/](https://livecode.org/)

  </p>
  </details>

- [Oni](https://github.com/onivim/oni) - Oni is a modern take on modal editing code editor focused on developer productivity. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/onivim/oni/releases/latest'><img src='https://img.shields.io/github/v/release/onivim/oni?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/onivim/oni'><img src='https://img.shields.io/github/stars/onivim/oni?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/onivim/oni' alt='License'/>

  </p>
  </details>

- [Vim](https://github.com/vim/vim) - ubiquitous text editor

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <code>Vim script</code> 

  **Links:** <a href='https://github.com/vim/vim/releases/latest'><img src='https://img.shields.io/github/v/release/vim/vim?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vim/vim'><img src='https://img.shields.io/github/stars/vim/vim?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vim/vim' alt='License'/>

  **Website:** [https://www.vim.org/](https://www.vim.org/)

  **Screenshots:**

  <img src='https://upload.wikimedia.org/wikipedia/commons/thumb/d/d5/Vim-search-copen-quickfix.png/640px-Vim-search-copen-quickfix.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Visual Studio Code](https://github.com/Microsoft/vscode) - Code editor developed by Microsoft. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/Microsoft/vscode/releases/latest'><img src='https://img.shields.io/github/v/release/Microsoft/vscode?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Microsoft/vscode'><img src='https://img.shields.io/github/stars/Microsoft/vscode?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Microsoft/vscode' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/11839736/16642200/6624dde0-43bd-11e6-8595-c81885ba0dc2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ZeroBraneStudio](https://github.com/pkulchenko/ZeroBraneStudio) - ZeroBrane Studio is a lightweight cross-platform Lua IDE with code completion, syntax highlighting, remote debugger, code analyzer, live coding, and debugging support for various Lua engines. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/Lua-16.png' alt='Lua icon' title='Lua' height='16'/> 

  **Links:** <a href='https://github.com/pkulchenko/ZeroBraneStudio/releases/latest'><img src='https://img.shields.io/github/v/release/pkulchenko/ZeroBraneStudio?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pkulchenko/ZeroBraneStudio'><img src='https://img.shields.io/github/stars/pkulchenko/ZeroBraneStudio?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pkulchenko/ZeroBraneStudio' alt='License'/>

  **Screenshots:**

  <img src='https://studio.zerobrane.com/images/debugging.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="images"></a>
### 🖼️ Images (17)
- [APNGb](https://github.com/shgodoroja/APNGb) - macOS app which assembles and disassembles animated png files. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/shgodoroja/APNGb/releases/latest'><img src='https://img.shields.io/github/v/release/shgodoroja/APNGb?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/shgodoroja/APNGb'><img src='https://img.shields.io/github/stars/shgodoroja/APNGb?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/shgodoroja/APNGb' alt='License'/>

  </p>
  </details>

- [Crunch](https://github.com/chrissimpkins/Crunch) - Insane(ly slow but wicked good) PNG image optimization. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/chrissimpkins/Crunch/releases/latest'><img src='https://img.shields.io/github/v/release/chrissimpkins/Crunch?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/chrissimpkins/Crunch'><img src='https://img.shields.io/github/stars/chrissimpkins/Crunch?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/chrissimpkins/Crunch' alt='License'/>

  </p>
  </details>

- [ExifCleaner](https://github.com/szTheory/exifcleaner) - Remove image metadata with drag and drop, multi-core batch processing, and dark mode.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/szTheory/exifcleaner/releases/latest'><img src='https://img.shields.io/github/v/release/szTheory/exifcleaner?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/szTheory/exifcleaner'><img src='https://img.shields.io/github/stars/szTheory/exifcleaner?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/szTheory/exifcleaner' alt='License'/>

  **Website:** [https://exifcleaner.com](https://exifcleaner.com)

  **Screenshots:**

  <img src='https://exifcleaner.com/images/screenshot.png' width='400' loading='lazy'/>

  <img src='https://exifcleaner.com/images/batchprocessing.png' width='400' loading='lazy'/>

  <img src='https://exifcleaner.com/images/darkmode.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Flameshot](https://github.com/flameshot-org/flameshot) - Powerful yet simple to use screenshot software.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/flameshot-org/flameshot/releases/latest'><img src='https://img.shields.io/github/v/release/flameshot-org/flameshot?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/flameshot-org/flameshot'><img src='https://img.shields.io/github/stars/flameshot-org/flameshot?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/flameshot-org/flameshot' alt='License'/>

  **Website:** [https://flameshot.org](https://flameshot.org)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/flameshot-org/flameshot/master/data/img/preview/animatedUsage.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Freehand](https://github.com/wddwycc/Freehand) - macOS Status Bar App for quick sketch. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/wddwycc/Freehand/releases/latest'><img src='https://img.shields.io/github/v/release/wddwycc/Freehand?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wddwycc/Freehand'><img src='https://img.shields.io/github/stars/wddwycc/Freehand?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wddwycc/Freehand' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wddwycc/Freehand/master/_images/demo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Gimp](https://github.com/GNOME/gimp) - Gimp is GNU Image Manipulation Program. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/GNOME/gimp/releases/latest'><img src='https://img.shields.io/github/v/release/GNOME/gimp?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/GNOME/gimp'><img src='https://img.shields.io/github/stars/GNOME/gimp?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/GNOME/gimp' alt='License'/>

  </p>
  </details>

- [Iconology](https://github.com/liamrosenfeld/Iconology) - Edit icons and then export to Xcode, icns, ico, favicon, macOS iconset, or a custom collection. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://apps.apple.com/us/app/iconology/id1463452867'><img src='./icons/app_store-16.png' alt='App Store' title='Download on the Mac App Store' height='16'/> App Store</a> &nbsp; <a href='https://github.com/liamrosenfeld/Iconology/releases/latest'><img src='https://img.shields.io/github/v/release/liamrosenfeld/Iconology?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/liamrosenfeld/Iconology'><img src='https://img.shields.io/github/stars/liamrosenfeld/Iconology?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/liamrosenfeld/Iconology' alt='License'/>

  **Website:** [https://apps.apple.com/us/app/iconology/id1463452867](https://apps.apple.com/us/app/iconology/id1463452867)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/liamrosenfeld/Iconology/main/Iconology/Assets.xcassets/Logo.imageset/logo-long-black.svg' width='400' loading='lazy'/>

  </p>
  </details>

- [ImageAlpha](https://github.com/kornelski/ImageAlpha) - Mac GUI for pngquant, pngnq and posterizer.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/kornelski/ImageAlpha/releases/latest'><img src='https://img.shields.io/github/v/release/kornelski/ImageAlpha?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kornelski/ImageAlpha'><img src='https://img.shields.io/github/stars/kornelski/ImageAlpha?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kornelski/ImageAlpha' alt='License'/>

  **Screenshots:**

  <img src='https://pngmini.com/screenshot-1.3.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Imagine](https://github.com/meowtec/Imagine) - Imagine is a desktop app for compression of PNG and JPEG, with a modern and friendly UI. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/meowtec/Imagine/releases/latest'><img src='https://img.shields.io/github/v/release/meowtec/Imagine?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/meowtec/Imagine'><img src='https://img.shields.io/github/stars/meowtec/Imagine?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/meowtec/Imagine' alt='License'/>

  </p>
  </details>

- [Inkscape](https://gitlab.com/inkscape/inkscape) - Inkscape is a Free and open source vector graphics editor.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <code>c++</code> 

  **Website:** [https://inkscape.org/](https://inkscape.org/)

  **Screenshots:**

  <img src='https://media.inkscape.org/media/resources/file/inkscape-0.48-moonlight-views.png' width='400' loading='lazy'/>

  </p>
  </details>

- [InVesalius](https://github.com/invesalius/invesalius3/) - 3D medical imaging reconstruction software

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/invesalius/invesalius3/releases/latest'><img src='https://img.shields.io/github/v/release/invesalius/invesalius3?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/invesalius/invesalius3/'><img src='https://img.shields.io/github/stars/invesalius/invesalius3?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/invesalius/invesalius3' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wiki/invesalius/invesalius3/figures/screen_1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/wiki/invesalius/invesalius3/figures/screen_2.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/wiki/invesalius/invesalius3/figures/screen_3.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Katana](https://github.com/bluegill/katana) - Katana is a simple screenshot utility for macOS that lives in your menubar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/bluegill/katana/releases/latest'><img src='https://img.shields.io/github/v/release/bluegill/katana?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bluegill/katana'><img src='https://img.shields.io/github/stars/bluegill/katana?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bluegill/katana' alt='License'/>

  </p>
  </details>

- [Krita](https://invent.kde.org/graphics/krita) - Krita is a cross-platform application for creating digital art files from scratch like illustrations, concept art, matte painting, textures, comics and animations.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Website:** [https://krita.org/en/](https://krita.org/en/)

  **Screenshots:**

  <img src='https://krita.org/wp-content/uploads/2019/08/krita-ui-40.png' width='400' loading='lazy'/>

  </p>
  </details>

- [PhotoMiner](https://github.com/gergelysanta/photominer) - macOS app for finding and lost forgotten photos on your disks. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/gergelysanta/photominer/releases/latest'><img src='https://img.shields.io/github/v/release/gergelysanta/photominer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gergelysanta/photominer'><img src='https://img.shields.io/github/stars/gergelysanta/photominer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gergelysanta/photominer' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/gergelysanta/photominer/master/AppStore/Screenshots/06.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/gergelysanta/photominer/master/AppStore/Screenshots/02.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/gergelysanta/photominer/master/AppStore/Screenshots/04.png' width='400' loading='lazy'/>

  *(3 more screenshots available in the repository)*

  </p>
  </details>

- [Screenbar](https://github.com/crilleengvall/Screenbar) - macOS menubar app for automating screenshots. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/crilleengvall/Screenbar/releases/latest'><img src='https://img.shields.io/github/v/release/crilleengvall/Screenbar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/crilleengvall/Screenbar'><img src='https://img.shields.io/github/stars/crilleengvall/Screenbar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/crilleengvall/Screenbar' alt='License'/>

  **Screenshots:**

  <img src='https://www.screenbar.net/assets/images/screenbar-window.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Seashore](https://github.com/robaho/seashore) - Easy to use macOS image editing application for the rest of us.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/robaho/seashore/releases/latest'><img src='https://img.shields.io/github/v/release/robaho/seashore?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/robaho/seashore'><img src='https://img.shields.io/github/stars/robaho/seashore?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/robaho/seashore' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/robaho/seashore/master/doc/ss1.png' width='400' loading='lazy'/>

  </p>
  </details>

- [WebPonize](https://github.com/1000ch/WebPonize) - WebPonize is a macOS App for converting PNG, JPEG, animated (or not) GIF images into WebP.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/1000ch/WebPonize/releases/latest'><img src='https://img.shields.io/github/v/release/1000ch/WebPonize?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/1000ch/WebPonize'><img src='https://img.shields.io/github/stars/1000ch/WebPonize?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/1000ch/WebPonize' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="keyboard"></a>
### ⌨️ Keyboard (9)
- [AnnePro-mac](https://github.com/msvisser/AnnePro-mac) - macOS application for controlling AnnePro keyboard over bluetooth. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/msvisser/AnnePro-mac/releases/latest'><img src='https://img.shields.io/github/v/release/msvisser/AnnePro-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/msvisser/AnnePro-mac'><img src='https://img.shields.io/github/stars/msvisser/AnnePro-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/msvisser/AnnePro-mac' alt='License'/>

  </p>
  </details>

- [Fluor](https://github.com/Pyroh/Fluor) - Handy tool for macOS allowing you to switch Fn keys' mode based on active application. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Pyroh/Fluor/releases/latest'><img src='https://img.shields.io/github/v/release/Pyroh/Fluor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Pyroh/Fluor'><img src='https://img.shields.io/github/stars/Pyroh/Fluor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Pyroh/Fluor' alt='License'/>

  </p>
  </details>

- [GokuRakuJoudo](https://github.com/yqrashawn/GokuRakuJoudo) - Karabiner-Elements configuration manager, rescue to bloated karabiner.json 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/clojure-16.png' alt='Clojure icon' title='Clojure' height='16'/> 

  **Links:** <a href='https://github.com/yqrashawn/GokuRakuJoudo/releases/latest'><img src='https://img.shields.io/github/v/release/yqrashawn/GokuRakuJoudo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/yqrashawn/GokuRakuJoudo'><img src='https://img.shields.io/github/stars/yqrashawn/GokuRakuJoudo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/yqrashawn/GokuRakuJoudo' alt='License'/>

  </p>
  </details>

- [Karabiner](https://github.com/tekezo/Karabiner) - Karabiner (KeyRemap4MacBook) is a powerful utility for keyboard customization.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/tekezo/Karabiner/releases/latest'><img src='https://img.shields.io/github/v/release/tekezo/Karabiner?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/tekezo/Karabiner'><img src='https://img.shields.io/github/stars/tekezo/Karabiner?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/tekezo/Karabiner' alt='License'/>

  </p>
  </details>

- [Karabiner-Elements](https://github.com/pqrs-org/Karabiner-Elements) - Karabiner-Elements is a powerful utility for keyboard customization on macOS Sierra (10.12) or later.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/pqrs-org/Karabiner-Elements/releases/latest'><img src='https://img.shields.io/github/v/release/pqrs-org/Karabiner-Elements?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pqrs-org/Karabiner-Elements'><img src='https://img.shields.io/github/stars/pqrs-org/Karabiner-Elements?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pqrs-org/Karabiner-Elements' alt='License'/>

  </p>
  </details>

- [Kawa](https://github.com/hatashiro/kawa) - Better input source switcher for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/hatashiro/kawa/releases/latest'><img src='https://img.shields.io/github/v/release/hatashiro/kawa?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hatashiro/kawa'><img src='https://img.shields.io/github/stars/hatashiro/kawa?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hatashiro/kawa' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/1013641/9109734/d73505e4-3c72-11e5-9c71-49cdf4a484da.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/hatashiro/kawa/master/resource/png/logo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Keycastr](https://github.com/keycastr/keycastr) - Keystroke visualizer.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <code>Objective-C</code> 

  **Links:** <a href='https://github.com/keycastr/keycastr/releases/latest'><img src='https://img.shields.io/github/v/release/keycastr/keycastr?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/keycastr/keycastr'><img src='https://img.shields.io/github/stars/keycastr/keycastr?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/keycastr/keycastr' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/keycastr/keycastr/blob/5a9a9e5b498aad7f3bc26e3c2c95862359dbf3e4/assets/preview.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Thor](https://github.com/gbammc/Thor) - Switch the right application ASAP. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/gbammc/Thor/releases/latest'><img src='https://img.shields.io/github/v/release/gbammc/Thor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gbammc/Thor'><img src='https://img.shields.io/github/stars/gbammc/Thor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gbammc/Thor' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/gbammc/Thor/master/screenshot_settings.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/gbammc/Thor/master/screenshot_list.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Unshaky](https://github.com/aahung/Unshaky) - A software attempt to address the "double key press" issue on Apple's butterfly keyboard 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/aahung/Unshaky/releases/latest'><img src='https://img.shields.io/github/v/release/aahung/Unshaky?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/aahung/Unshaky'><img src='https://img.shields.io/github/stars/aahung/Unshaky?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/aahung/Unshaky' alt='License'/>

  **Website:** [https://unshaky.nestederror.com/](https://unshaky.nestederror.com/)

  **Screenshots:**

  <img src='https://github.com/aahung/Unshaky/blob/master/README/menubar.png' width='400' loading='lazy'/>

  <img src='https://github.com/aahung/Unshaky/blob/master/README/how-unshaky-works.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="mail"></a>
### 📧 Mail (7)
- [Correo](https://github.com/amitmerchant1990/correo) - Menubar/taskbar Gmail App for Windows and macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/amitmerchant1990/correo/releases/latest'><img src='https://img.shields.io/github/v/release/amitmerchant1990/correo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/amitmerchant1990/correo'><img src='https://img.shields.io/github/stars/amitmerchant1990/correo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/amitmerchant1990/correo' alt='License'/>

  </p>
  </details>

- [dejalu](https://github.com/dinhvh/dejalu) - Fast and Simple Email Client.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/dinhvh/dejalu/releases/latest'><img src='https://img.shields.io/github/v/release/dinhvh/dejalu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dinhvh/dejalu'><img src='https://img.shields.io/github/stars/dinhvh/dejalu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dinhvh/dejalu' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/dinhviethoa/dejalu/master/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [ElectronMail](https://github.com/vladimiry/ElectronMail) - Unofficial desktop app for ProtonMail and Tutanota end-to-end encrypted email providers.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/vladimiry/ElectronMail/releases/latest'><img src='https://img.shields.io/github/v/release/vladimiry/ElectronMail?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vladimiry/ElectronMail'><img src='https://img.shields.io/github/stars/vladimiry/ElectronMail?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vladimiry/ElectronMail' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/vladimiry/ElectronMail/master/images/search.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/vladimiry/ElectronMail/master/images/export.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Mailspring](https://github.com/Foundry376/Mailspring) - 💌 A beautiful, fast and maintained fork of @nylas Mail by one of the original authors

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/Foundry376/Mailspring/releases/latest'><img src='https://img.shields.io/github/v/release/Foundry376/Mailspring?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Foundry376/Mailspring'><img src='https://img.shields.io/github/stars/Foundry376/Mailspring?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Foundry376/Mailspring' alt='License'/>

  **Website:** [https://getmailspring.com/](https://getmailspring.com/)

  </p>
  </details>

- [Rambox](https://github.com/ramboxapp/community-edition) - Cross Platform messaging and emailing app that combines common web applications into one.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/ramboxapp/community-edition/releases/latest'><img src='https://img.shields.io/github/v/release/ramboxapp/community-edition?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ramboxapp/community-edition'><img src='https://img.shields.io/github/stars/ramboxapp/community-edition?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ramboxapp/community-edition' alt='License'/>

  </p>
  </details>

- [SimpleLogin](https://github.com/simple-login/mac-app) - Email Alias solution: protect your real email address.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/simple-login/mac-app/releases/latest'><img src='https://img.shields.io/github/v/release/simple-login/mac-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/simple-login/mac-app'><img src='https://img.shields.io/github/stars/simple-login/mac-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/simple-login/mac-app' alt='License'/>

  </p>
  </details>

- [Thunderbird](https://hg.mozilla.org/mozilla-central) - Backed by Mozilla, Thunderbird is an extensible email, newsfeed, chat, and calendaring client.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Website:** [https://www.thunderbird.net/en-US/](https://www.thunderbird.net/en-US/)

  **Screenshots:**

  <img src='https://www.thunderbird.net/media/img/l10n/en-US/thunderbird/landing/screenshot-mac.png' width='400' loading='lazy'/>

  <img src='https://www.thunderbird.net/media/img/l10n/en-US/thunderbird/calendar/screenshot-mac.png' width='400' loading='lazy'/>

  <img src='https://www.thunderbird.net/media/img/thunderbird/features/addon-manager.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="medical"></a>
### 🏥 Medical (1)
- [InVesalius](https://github.com/invesalius/invesalius3/) - 3D medical imaging reconstruction software

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/invesalius/invesalius3/releases/latest'><img src='https://img.shields.io/github/v/release/invesalius/invesalius3?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/invesalius/invesalius3/'><img src='https://img.shields.io/github/stars/invesalius/invesalius3?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/invesalius/invesalius3' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wiki/invesalius/invesalius3/figures/screen_1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/wiki/invesalius/invesalius3/figures/screen_2.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/wiki/invesalius/invesalius3/figures/screen_3.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="menubar"></a>
### 📊 Menubar (40)
- [Airpass](https://github.com/alvesjtiago/airpass) - Status bar Mac application to overcome time constrained WiFi networks. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/alvesjtiago/airpass/releases/latest'><img src='https://img.shields.io/github/v/release/alvesjtiago/airpass?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alvesjtiago/airpass'><img src='https://img.shields.io/github/stars/alvesjtiago/airpass?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alvesjtiago/airpass' alt='License'/>

  </p>
  </details>

- [Akku](https://github.com/jariz/Akku) - The missing macOS bluetooth headset battery indicator app.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> <img src='./icons/ruby-16.png' alt='Ruby icon' title='Ruby' height='16'/> 

  **Links:** <a href='https://github.com/jariz/Akku/releases/latest'><img src='https://img.shields.io/github/v/release/jariz/Akku?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jariz/Akku'><img src='https://img.shields.io/github/stars/jariz/Akku?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jariz/Akku' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/0f9f9231ff083edead13ad239d7a73566e7b1933c3f176e11ce04e7e624bb24a/68747470733a2f2f6a6172692e6c6f6c2f384f516d4c6e794b72752e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [AnyBar](https://github.com/tonsky/AnyBar) - macOS menubar status indicator. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/tonsky/AnyBar/releases/latest'><img src='https://img.shields.io/github/v/release/tonsky/AnyBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/tonsky/AnyBar'><img src='https://img.shields.io/github/stars/tonsky/AnyBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/tonsky/AnyBar' alt='License'/>

  </p>
  </details>

- [baRSS – Menu Bar RSS Reader](https://github.com/relikd/barss) - RSS & Atom feed reader that lives in the system status bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/relikd/barss/releases/latest'><img src='https://img.shields.io/github/v/release/relikd/barss?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/relikd/barss'><img src='https://img.shields.io/github/stars/relikd/barss?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/relikd/barss' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/relikd/baRSS/main/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [BarTranslate](https://github.com/ThijmenDam/BarTranslate) - A handy menu bar translator app that supports DeepL and Google Translate.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/ThijmenDam/BarTranslate/releases/latest'><img src='https://img.shields.io/github/v/release/ThijmenDam/BarTranslate?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ThijmenDam/BarTranslate'><img src='https://img.shields.io/github/stars/ThijmenDam/BarTranslate?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ThijmenDam/BarTranslate' alt='License'/>

  **Website:** [https://thijmendam.github.io/BarTranslate/](https://thijmendam.github.io/BarTranslate/)

  **Screenshots:**

  <img src='https://thijmendam.github.io/BarTranslate/assets/images/interface-snapshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Bye-AppQuit](https://github.com/designsbymuzeer/Bye-Mac-App) - A minimal native macOS app to quickly view and Bulk kill running processes.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/designsbymuzeer/Bye-Mac-App/releases/latest'><img src='https://img.shields.io/github/v/release/designsbymuzeer/Bye-Mac-App?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/designsbymuzeer/Bye-Mac-App'><img src='https://img.shields.io/github/stars/designsbymuzeer/Bye-Mac-App?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/designsbymuzeer/Bye-Mac-App' alt='License'/>

  **Website:** [https://github.com/designsbymuzeer/Bye-Mac-App](https://github.com/designsbymuzeer/Bye-Mac-App)

  **Screenshots:**

  <img src='https://github.com/user-attachments/assets/63dade24-d967-4946-89e5-f8ae44097b31' width='400' loading='lazy'/>

  </p>
  </details>

- [CloudyTabs](https://github.com/josh-/CloudyTabs) - Simple menu bar macOS application for displaying lists of your iCloud Tabs and Reading List. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/josh-/CloudyTabs/releases/latest'><img src='https://img.shields.io/github/v/release/josh-/CloudyTabs?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/josh-/CloudyTabs'><img src='https://img.shields.io/github/stars/josh-/CloudyTabs?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/josh-/CloudyTabs' alt='License'/>

  **Screenshots:**

  <img src='https://joshparnham.com/projects/cloudytabs/CloudyTabs.png' width='400' loading='lazy'/>

  </p>
  </details>

- [DatWeatherDoe](https://github.com/inderdhir/DatWeatherDoe) - Simple menu bar weather app for macOS written in Swift. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/inderdhir/DatWeatherDoe/releases/latest'><img src='https://img.shields.io/github/v/release/inderdhir/DatWeatherDoe?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/inderdhir/DatWeatherDoe'><img src='https://img.shields.io/github/stars/inderdhir/DatWeatherDoe?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/inderdhir/DatWeatherDoe' alt='License'/>

  </p>
  </details>

- [DisplayMenu](https://github.com/Kwpolska/DisplayMenu) - Simple (bare-bones) macOS menubar extra to apply display presets. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Kwpolska/DisplayMenu/releases/latest'><img src='https://img.shields.io/github/v/release/Kwpolska/DisplayMenu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Kwpolska/DisplayMenu'><img src='https://img.shields.io/github/stars/Kwpolska/DisplayMenu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Kwpolska/DisplayMenu' alt='License'/>

  </p>
  </details>

- [Dozer](https://github.com/Mortennn/Dozer) - Hide MacOS menubar items.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Mortennn/Dozer/releases/latest'><img src='https://img.shields.io/github/v/release/Mortennn/Dozer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Mortennn/Dozer'><img src='https://img.shields.io/github/stars/Mortennn/Dozer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Mortennn/Dozer' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Mortennn/Dozer/master/Stuff/demo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [eul](https://github.com/gao-sun/eul) - macOS status monitoring app written in SwiftUI.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/gao-sun/eul/releases/latest'><img src='https://img.shields.io/github/v/release/gao-sun/eul?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gao-sun/eul'><img src='https://img.shields.io/github/stars/gao-sun/eul?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gao-sun/eul' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/14722250/105626766-f718ab00-5e6c-11eb-9761-661ff85c8faf.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Grayscale Mode](https://github.com/rkbhochalya/grayscale-mode) - Manage grayscale mode from menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/rkbhochalya/grayscale-mode/releases/latest'><img src='https://img.shields.io/github/v/release/rkbhochalya/grayscale-mode?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/rkbhochalya/grayscale-mode'><img src='https://img.shields.io/github/stars/rkbhochalya/grayscale-mode?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/rkbhochalya/grayscale-mode' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/12229032/78544215-6b6b5a80-7817-11ea-8b80-12bbbfc16053.jpg' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/12229032/78544289-84740b80-7817-11ea-9092-e76fcb027702.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [gSwitch](https://github.com/CodySchrank/gSwitch) - macOS status bar app that allows control over the gpu on dual gpu macbooks. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/CodySchrank/gSwitch/releases/latest'><img src='https://img.shields.io/github/v/release/CodySchrank/gSwitch?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/CodySchrank/gSwitch'><img src='https://img.shields.io/github/stars/CodySchrank/gSwitch?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/CodySchrank/gSwitch' alt='License'/>

  </p>
  </details>

- [Hidden Bar](https://github.com/dwarvesf/hidden) - An ultra-light MacOS utility that helps hide menu bar icons

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/dwarvesf/hidden/releases/latest'><img src='https://img.shields.io/github/v/release/dwarvesf/hidden?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dwarvesf/hidden'><img src='https://img.shields.io/github/stars/dwarvesf/hidden?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dwarvesf/hidden' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/dwarvesf/hidden/blob/develop/img/tutorial.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [iGlance](https://github.com/iglance/iGlance) - macOS System Monitor (cpu, memory, network, fan and battery) for the Status Bar. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/iglance/iGlance/releases/latest'><img src='https://img.shields.io/github/v/release/iglance/iGlance?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/iglance/iGlance'><img src='https://img.shields.io/github/stars/iglance/iGlance?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/iglance/iGlance' alt='License'/>

  </p>
  </details>

- [Itsycal](https://github.com/sfsam/Itsycal) - A tiny calendar for that lives in the Mac menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/sfsam/Itsycal/releases/latest'><img src='https://img.shields.io/github/v/release/sfsam/Itsycal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sfsam/Itsycal'><img src='https://img.shields.io/github/stars/sfsam/Itsycal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sfsam/Itsycal' alt='License'/>

  **Website:** [https://www.mowglii.com/itsycal/](https://www.mowglii.com/itsycal/)

  **Screenshots:**

  <img src='https://www.mowglii.com/itsycal/itsycalbanner2@2x.png' width='400' loading='lazy'/>

  </p>
  </details>

- [KubeContext](https://github.com/turkenh/KubeContext) - import, manage and switch between your Kubernetes contexts on Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/turkenh/KubeContext/releases/latest'><img src='https://img.shields.io/github/v/release/turkenh/KubeContext?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/turkenh/KubeContext'><img src='https://img.shields.io/github/stars/turkenh/KubeContext?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/turkenh/KubeContext' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/turkenh/KubeContext/master/Image/SS3.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/turkenh/KubeContext/master/Image/SS4.png' width='400' loading='lazy'/>

  </p>
  </details>

- [LinkLiar](https://github.com/halo/LinkLiar) - Keep your MAC address random for privacy (intuitive GUI for ifconfig)

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/halo/LinkLiar/releases/latest'><img src='https://img.shields.io/github/v/release/halo/LinkLiar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/halo/LinkLiar'><img src='https://img.shields.io/github/stars/halo/LinkLiar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/halo/LinkLiar' alt='License'/>

  **Website:** [https://halo.github.io/LinkLiar/](https://halo.github.io/LinkLiar/)

  **Screenshots:**

  <img src='https://cdn.jsdelivr.net/gh/halo/LinkLiar@master/docs/screenshot_3.0.1b.svg' width='400' loading='lazy'/>

  </p>
  </details>

- [Market Bar](https://github.com/mnndnl/market-bar ) - Tiny stocks watcher for the menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mnndnl/market-bar /releases/latest'><img src='https://img.shields.io/github/v/release/mnndnl/market-bar ?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mnndnl/market-bar '><img src='https://img.shields.io/github/stars/mnndnl/market-bar ?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mnndnl/market-bar ' alt='License'/>

  </p>
  </details>

- [MeetingBar](https://github.com/leits/MeetingBar) - Menu bar app for your calendar meetings

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/leits/MeetingBar/releases/latest'><img src='https://img.shields.io/github/v/release/leits/MeetingBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/leits/MeetingBar'><img src='https://img.shields.io/github/stars/leits/MeetingBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/leits/MeetingBar' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/leits/MeetingBar/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Menubar Brightness](https://github.com/lucasbento/menubar-brightness) - macOS app to change the screen brightness on the menubar. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/lucasbento/menubar-brightness/releases/latest'><img src='https://img.shields.io/github/v/release/lucasbento/menubar-brightness?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lucasbento/menubar-brightness'><img src='https://img.shields.io/github/stars/lucasbento/menubar-brightness?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lucasbento/menubar-brightness' alt='License'/>

  </p>
  </details>

- [MenuMeters](https://github.com/yujitach/MenuMeters) - CPU, memory, disk, and network monitoring tools for macOS.  

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/yujitach/MenuMeters/releases/latest'><img src='https://img.shields.io/github/v/release/yujitach/MenuMeters?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/yujitach/MenuMeters'><img src='https://img.shields.io/github/stars/yujitach/MenuMeters?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/yujitach/MenuMeters' alt='License'/>

  </p>
  </details>

- [MiniSim](https://github.com/okwasniewski/MiniSim) - MacOS menu bar app for launching iOS  and Android 🤖 emulators.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/okwasniewski/MiniSim/releases/latest'><img src='https://img.shields.io/github/v/release/okwasniewski/MiniSim?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/okwasniewski/MiniSim'><img src='https://img.shields.io/github/stars/okwasniewski/MiniSim?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/okwasniewski/MiniSim' alt='License'/>

  **Website:** [https://www.minisim.app/](https://www.minisim.app/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/52801365/223483262-aa3bad72-2948-4893-87a0-578e5d3d8e89.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Monitor Bar](https://github.com/tidiemme/monitorbar) - Monitor Bar app supports three modes, compact, normal, extra. It monitors battery, Disk, Memory, CPU, Network bandwidth, Wi-Fi.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/tidiemme/monitorbar/releases/latest'><img src='https://img.shields.io/github/v/release/tidiemme/monitorbar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/tidiemme/monitorbar'><img src='https://img.shields.io/github/stars/tidiemme/monitorbar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/tidiemme/monitorbar' alt='License'/>

  </p>
  </details>

- [Night Shift Control](https://github.com/isaiasmatewos/night-shift-control) - Night Shift Control is a simple macOS menubar app for controlling Night Shift. It's aim is to bring features from f.lux which are missing from Night Shift such as disabling Night Shift for certain apps. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/isaiasmatewos/night-shift-control/releases/latest'><img src='https://img.shields.io/github/v/release/isaiasmatewos/night-shift-control?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/isaiasmatewos/night-shift-control'><img src='https://img.shields.io/github/stars/isaiasmatewos/night-shift-control?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/isaiasmatewos/night-shift-control' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/isaiasmatewos/night-shift-control/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Nocturnal](https://github.com/joshjon/nocturnal) - Menu bar app featuring darker than dark dimming, Night Shift fine tuning, and the ability to turn off TouchBar on MacBook Pro. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/joshjon/nocturnal/releases/latest'><img src='https://img.shields.io/github/v/release/joshjon/nocturnal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/joshjon/nocturnal'><img src='https://img.shields.io/github/stars/joshjon/nocturnal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/joshjon/nocturnal' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/joshjon/nocturnal/master/Docs/Images/Nocturnal-Screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [NoiseBuddy](https://github.com/insidegui/NoiseBuddy) - Control the listening mode on your AirPods Pro in the Touch Bar or Menu Bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/NoiseBuddy/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/NoiseBuddy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/NoiseBuddy'><img src='https://img.shields.io/github/stars/insidegui/NoiseBuddy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/NoiseBuddy' alt='License'/>

  </p>
  </details>

- [Pareto Security](https://github.com/paretoSecurity/pareto-mac/) - A MenuBar app to automatically audit your Mac for basic security hygiene.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/paretoSecurity/pareto-mac/releases/latest'><img src='https://img.shields.io/github/v/release/paretoSecurity/pareto-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/paretoSecurity/pareto-mac/'><img src='https://img.shields.io/github/stars/paretoSecurity/pareto-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/paretoSecurity/pareto-mac' alt='License'/>

  **Website:** [https://paretosecurity.com/](https://paretosecurity.com/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/239513/126497099-1b89a8ef-68f2-4aae-9f05-f124748685d2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Pi Stats](https://github.com/Bunn/PiStats) - macOS app to visualize Pi-hole information.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Bunn/PiStats/releases/latest'><img src='https://img.shields.io/github/v/release/Bunn/PiStats?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Bunn/PiStats'><img src='https://img.shields.io/github/stars/Bunn/PiStats?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Bunn/PiStats' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Bunn/PiStats/master/images/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Pika](https://github.com/superhighfives/pika) - Is an easy to use, open-source, native colour picker for macOS.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <code>metal</code> 

  **Links:** <a href='https://github.com/superhighfives/pika/releases/latest'><img src='https://img.shields.io/github/v/release/superhighfives/pika?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/superhighfives/pika'><img src='https://img.shields.io/github/stars/superhighfives/pika?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/superhighfives/pika' alt='License'/>

  **Website:** [https://superhighfives.com/pika](https://superhighfives.com/pika)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/449385/103492507-4e55cd80-4e23-11eb-9366-d31c2bb74030.png' width='400' loading='lazy'/>

  </p>
  </details>

- [PlayStatus](https://github.com/nbolar/PlayStatus) - PlayStatus is a macOS app that allows the control of Spotify and iTunes music playback from the menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/nbolar/PlayStatus/releases/latest'><img src='https://img.shields.io/github/v/release/nbolar/PlayStatus?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nbolar/PlayStatus'><img src='https://img.shields.io/github/stars/nbolar/PlayStatus?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nbolar/PlayStatus' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/45484873/60389024-ece0d000-9ac2-11e9-8dbc-2376e905887f.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [PSIBar](https://github.com/nikhilsh/PSIBar) - Quickly hacked up PSI macOS status bar app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/nikhilsh/PSIBar/releases/latest'><img src='https://img.shields.io/github/v/release/nikhilsh/PSIBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nikhilsh/PSIBar'><img src='https://img.shields.io/github/stars/nikhilsh/PSIBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nikhilsh/PSIBar' alt='License'/>

  </p>
  </details>

- [Quickeys](https://github.com/alexrosenfeld10/Quickeys) - A mac menu bar app that provides note taking functionality though a quick dropdown menu. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/alexrosenfeld10/Quickeys/releases/latest'><img src='https://img.shields.io/github/v/release/alexrosenfeld10/Quickeys?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alexrosenfeld10/Quickeys'><img src='https://img.shields.io/github/stars/alexrosenfeld10/Quickeys?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alexrosenfeld10/Quickeys' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/alexrosenfeld10/Quickeys/master/Images/Quickeys.png' width='400' loading='lazy'/>

  </p>
  </details>

- [SensibleSideButtons](https://github.com/archagon/sensible-side-buttons) - Small menu bar utility that lets you use your third-party mouse's side buttons for navigation across a variety of apps.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/archagon/sensible-side-buttons/releases/latest'><img src='https://img.shields.io/github/v/release/archagon/sensible-side-buttons?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/archagon/sensible-side-buttons'><img src='https://img.shields.io/github/stars/archagon/sensible-side-buttons?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/archagon/sensible-side-buttons' alt='License'/>

  </p>
  </details>

- [Shifty](https://github.com/thompsonate/Shifty) - macOS menu bar app that gives you more control over Night Shift. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/thompsonate/Shifty/releases/latest'><img src='https://img.shields.io/github/v/release/thompsonate/Shifty?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/thompsonate/Shifty'><img src='https://img.shields.io/github/stars/thompsonate/Shifty?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/thompsonate/Shifty' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/thompsonate/Shifty/master/docs/en/images/prefs-general-screenshot-shadow.png' width='400' loading='lazy'/>

  </p>
  </details>

- [SlimHUD - Cyanocitta](https://github.com/AlexPerathoner/SlimHUD) - Replacement for MacOS' volume, brightness and keyboard backlight HUDs.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AlexPerathoner/SlimHUD/releases/latest'><img src='https://img.shields.io/github/v/release/AlexPerathoner/SlimHUD?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AlexPerathoner/SlimHUD'><img src='https://img.shields.io/github/stars/AlexPerathoner/SlimHUD?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AlexPerathoner/SlimHUD' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/AlexPerathoner/SlimHUD/master/Screens/Animations/animations.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/AlexPerathoner/SlimHUD/master/Screens/settingsWindow.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Stats](https://github.com/exelban/stats) - macOS system monitor in your menu bar

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/exelban/stats/releases/latest'><img src='https://img.shields.io/github/v/release/exelban/stats?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/exelban/stats'><img src='https://img.shields.io/github/stars/exelban/stats?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/exelban/stats' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/0e25eeb8b466356b0bcd847d064da3084baa5aed9bf53fab3bad2f0f0fbd1ee9/68747470733a2f2f7365726869792e73332e65752d63656e7472616c2d312e616d617a6f6e6177732e636f6d2f4769746875625f7265706f2f73746174732f706f7075707325334676322e332e322e706e673f7633' width='400' loading='lazy'/>

  </p>
  </details>

- [SwiftBar](https://github.com/swiftbar/SwiftBar) - Powerful macOS menu bar customization tool.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/swiftbar/SwiftBar/releases/latest'><img src='https://img.shields.io/github/v/release/swiftbar/SwiftBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/swiftbar/SwiftBar'><img src='https://img.shields.io/github/stars/swiftbar/SwiftBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/swiftbar/SwiftBar' alt='License'/>

  **Website:** [https://swiftbar.app](https://swiftbar.app)

  </p>
  </details>

- [TimeScribe](https://github.com/WINBIGFOX/timescribe) - Simple and free working time recording.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/WINBIGFOX/timescribe/releases/latest'><img src='https://img.shields.io/github/v/release/WINBIGFOX/timescribe?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/WINBIGFOX/timescribe'><img src='https://img.shields.io/github/stars/WINBIGFOX/timescribe?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/WINBIGFOX/timescribe' alt='License'/>

  **Website:** [https://timescribe.app](https://timescribe.app)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/WINBIGFOX/timescribe/refs/heads/main/.github/images/menubar_light.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/WINBIGFOX/timescribe/refs/heads/main/.github/images/dayview_en_light.webp' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/WINBIGFOX/timescribe/refs/heads/main/.github/images/app_activity_en_light.webp' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [xbar](https://github.com/matryer/xbar) - Put the output from any script or program into your macOS Menu Bar. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/matryer/xbar/releases/latest'><img src='https://img.shields.io/github/v/release/matryer/xbar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/matryer/xbar'><img src='https://img.shields.io/github/stars/matryer/xbar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/matryer/xbar' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="music"></a>
### 🎧 Music (15)
- [Carol](https://github.com/AnaghSharma/Carol) - A minimal and beautiful lyrics app that stays in the menu bar of macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/csharp-16.png' alt='C# icon' title='C#' height='16'/> 

  **Links:** <a href='https://github.com/AnaghSharma/Carol/releases/latest'><img src='https://img.shields.io/github/v/release/AnaghSharma/Carol?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AnaghSharma/Carol'><img src='https://img.shields.io/github/stars/AnaghSharma/Carol?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AnaghSharma/Carol' alt='License'/>

  </p>
  </details>

- [ChordDetector](https://github.com/cemolcay/ChordDetector) - Tiny menu bar app that listens iTunes and Spotify to detect chords of songs! 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/cemolcay/ChordDetector/releases/latest'><img src='https://img.shields.io/github/v/release/cemolcay/ChordDetector?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/cemolcay/ChordDetector'><img src='https://img.shields.io/github/stars/cemolcay/ChordDetector?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/cemolcay/ChordDetector' alt='License'/>

  </p>
  </details>

- [DeezPlayer](https://github.com/imanel/deezplayer) - Deezer Desktop app for Windows, Linux and macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/coffeescript-16.png' alt='CoffeeScript icon' title='CoffeeScript' height='16'/> 

  **Links:** <a href='https://github.com/imanel/deezplayer/releases/latest'><img src='https://img.shields.io/github/v/release/imanel/deezplayer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/imanel/deezplayer'><img src='https://img.shields.io/github/stars/imanel/deezplayer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/imanel/deezplayer' alt='License'/>

  </p>
  </details>

- [iTunes Graphs](https://github.com/Zac-Garby/iTunes-Graphs) - macOS app to visualise your iTunes library as graphs. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Zac-Garby/iTunes-Graphs/releases/latest'><img src='https://img.shields.io/github/v/release/Zac-Garby/iTunes-Graphs?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Zac-Garby/iTunes-Graphs'><img src='https://img.shields.io/github/stars/Zac-Garby/iTunes-Graphs?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Zac-Garby/iTunes-Graphs' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Zac-Garby/iTunes-Graphs/master/screenshot2.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/Zac-Garby/iTunes-Graphs/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Karaoke Forever](https://github.com/bhj/KaraokeEternal) - Host awesome karaoke parties where everyone can queue songs from their phone's browser. Plays MP3+G and MP4 with WebGL visualizations.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/bhj/KaraokeEternal/releases/latest'><img src='https://img.shields.io/github/v/release/bhj/KaraokeEternal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bhj/KaraokeEternal'><img src='https://img.shields.io/github/stars/bhj/KaraokeEternal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bhj/KaraokeEternal' alt='License'/>

  **Website:** [https://www.karaoke-eternal.com/](https://www.karaoke-eternal.com/)

  **Screenshots:**

  <img src='https://github.com/bhj/KaraokeEternal/blob/master/docs/assets/images/README.jpg?raw=true' width='400' loading='lazy'/>

  </p>
  </details>

- [Lilypond UI](https://github.com/doches/lilypond-ui) - Create beautiful musical scores with LilyPond.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/doches/lilypond-ui/releases/latest'><img src='https://img.shields.io/github/v/release/doches/lilypond-ui?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/doches/lilypond-ui'><img src='https://img.shields.io/github/stars/doches/lilypond-ui?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/doches/lilypond-ui' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/doches/lilypond-ui/develop/docs/lilypond-ide.png' width='400' loading='lazy'/>

  </p>
  </details>

- [lyricsify](https://github.com/mamal72/lyricsify-mac) - Simple Spotify lyrics viewer menu bar app for macOS in Swift. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mamal72/lyricsify-mac/releases/latest'><img src='https://img.shields.io/github/v/release/mamal72/lyricsify-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mamal72/lyricsify-mac'><img src='https://img.shields.io/github/stars/mamal72/lyricsify-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mamal72/lyricsify-mac' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mamal72/lyricsify-mac/master/screenshots/en.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/mamal72/lyricsify-mac/master/screenshots/fa.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MPV](https://github.com/mpv-player/mpv) - Lightweight, highly configurable media player.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/mpv-player/mpv/releases/latest'><img src='https://img.shields.io/github/v/release/mpv-player/mpv?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mpv-player/mpv'><img src='https://img.shields.io/github/stars/mpv-player/mpv?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mpv-player/mpv' alt='License'/>

  **Website:** [https://mpv.io](https://mpv.io)

  **Screenshots:**

  <img src='https://mpv.io/images/mpv-screenshot-34cd36ae.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [NoiseBuddy](https://github.com/insidegui/NoiseBuddy) - Control the listening mode on your AirPods Pro in the Touch Bar or Menu Bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/NoiseBuddy/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/NoiseBuddy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/NoiseBuddy'><img src='https://img.shields.io/github/stars/insidegui/NoiseBuddy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/NoiseBuddy' alt='License'/>

  </p>
  </details>

- [PlayStatus](https://github.com/nbolar/PlayStatus) - PlayStatus is a macOS app that allows the control of Spotify and iTunes music playback from the menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/nbolar/PlayStatus/releases/latest'><img src='https://img.shields.io/github/v/release/nbolar/PlayStatus?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nbolar/PlayStatus'><img src='https://img.shields.io/github/stars/nbolar/PlayStatus?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nbolar/PlayStatus' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/45484873/60389024-ece0d000-9ac2-11e9-8dbc-2376e905887f.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Plug](https://github.com/wulkano/Plug) - Discover and listen to music from Hype Machine.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/wulkano/Plug/releases/latest'><img src='https://img.shields.io/github/v/release/wulkano/Plug?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wulkano/Plug'><img src='https://img.shields.io/github/stars/wulkano/Plug?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wulkano/Plug' alt='License'/>

  **Website:** [https://www.plugformac.com/](https://www.plugformac.com/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wulkano/Plug/1ae6383ad9ad7026ce6fad4f1ea7ce3356c1f722/Media/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [SoundCleod](https://github.com/salomvary/soundcleod) - SoundCloud for macOS and Windows. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/salomvary/soundcleod/releases/latest'><img src='https://img.shields.io/github/v/release/salomvary/soundcleod?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/salomvary/soundcleod'><img src='https://img.shields.io/github/stars/salomvary/soundcleod?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/salomvary/soundcleod' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/a29d773a5a06dcca271d137ab82b46b8609bade4/68747470733a2f2f7261772e6769746875622e636f6d2f73616c6f6d766172792f736f756e64636c656f642f6d61737465722f73637265656e73686f742e6a7067s' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/8c4c858d36597bca72f9eea033f42f6882efc048/68747470733a2f2f7261772e6769746875622e636f6d2f73616c6f6d766172792f736f756e64636c656f642f6d61737465722f73637265656e73686f742d6461726b2e6a7067' width='400' loading='lazy'/>

  </p>
  </details>

- [spicetify-cli](https://github.com/spicetify/spicetify-cli) - Command-line tool to customize the official Spotify client. Supports Windows, MacOS and Linux.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/spicetify/spicetify-cli/releases/latest'><img src='https://img.shields.io/github/v/release/spicetify/spicetify-cli?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/spicetify/spicetify-cli'><img src='https://img.shields.io/github/stars/spicetify/spicetify-cli?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/spicetify/spicetify-cli' alt='License'/>

  **Website:** [https://spicetify.app/](https://spicetify.app/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/spicetify/spicetify-cli/master/.github/assets/logo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Spotify-Cli-Mac](https://github.com/ersel/spotify-cli-mac) - Control Spotify without leaving your terminal. :notes: 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/ersel/spotify-cli-mac/releases/latest'><img src='https://img.shields.io/github/v/release/ersel/spotify-cli-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ersel/spotify-cli-mac'><img src='https://img.shields.io/github/stars/ersel/spotify-cli-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ersel/spotify-cli-mac' alt='License'/>

  **Screenshots:**

  <img src='https://asciinema.org/a/ejbbvaa8833wq4xn4d2xuc9jx.png' width='400' loading='lazy'/>

  </p>
  </details>

- [YouTube-Music](https://github.com/steve228uk/YouTube-Music) - macOS wrapper for music.youtube.com. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/steve228uk/YouTube-Music/releases/latest'><img src='https://img.shields.io/github/v/release/steve228uk/YouTube-Music?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/steve228uk/YouTube-Music'><img src='https://img.shields.io/github/stars/steve228uk/YouTube-Music?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/steve228uk/YouTube-Music' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/steve228uk/YouTube-Music/master/screenshots/screenshot-1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/steve228uk/YouTube-Music/master/screenshots/screenshot-2.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/steve228uk/YouTube-Music/master/screenshots/screenshot-3.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="news"></a>
### 📰 News (6)
- [baRSS – Menu Bar RSS Reader](https://github.com/relikd/barss) - RSS & Atom feed reader that lives in the system status bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/relikd/barss/releases/latest'><img src='https://img.shields.io/github/v/release/relikd/barss?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/relikd/barss'><img src='https://img.shields.io/github/stars/relikd/barss?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/relikd/barss' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/relikd/baRSS/main/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Diurna](https://github.com/ngquerol/Diurna) - Basic/Classic Hacker News app, used as a Cocoa & Swift learning platform. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ngquerol/Diurna/releases/latest'><img src='https://img.shields.io/github/v/release/ngquerol/Diurna?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ngquerol/Diurna'><img src='https://img.shields.io/github/stars/ngquerol/Diurna?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ngquerol/Diurna' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ngquerol/Diurna/master/diurna.png' width='400' loading='lazy'/>

  </p>
  </details>

- [hacker-menu](https://github.com/owenthereal/hacker-menu) - Hacker News Delivered to Desktop. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/owenthereal/hacker-menu/releases/latest'><img src='https://img.shields.io/github/v/release/owenthereal/hacker-menu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/owenthereal/hacker-menu'><img src='https://img.shields.io/github/stars/owenthereal/hacker-menu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/owenthereal/hacker-menu' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/jingweno/hacker-menu/master/images/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [NetNewsWire](https://github.com/Ranchero-Software/NetNewsWire) - Feed reader for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Ranchero-Software/NetNewsWire/releases/latest'><img src='https://img.shields.io/github/v/release/Ranchero-Software/NetNewsWire?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Ranchero-Software/NetNewsWire'><img src='https://img.shields.io/github/stars/Ranchero-Software/NetNewsWire?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Ranchero-Software/NetNewsWire' alt='License'/>

  </p>
  </details>

- [Vienna](https://github.com/ViennaRSS/vienna-rss) - Vienna is a RSS/Atom newsreader for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/ViennaRSS/vienna-rss/releases/latest'><img src='https://img.shields.io/github/v/release/ViennaRSS/vienna-rss?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ViennaRSS/vienna-rss'><img src='https://img.shields.io/github/stars/ViennaRSS/vienna-rss?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ViennaRSS/vienna-rss' alt='License'/>

  </p>
  </details>

- [Winds](https://github.com/GetStream/Winds) - A Beautiful Open Source RSS & Podcast App Powered by Getstream.io

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/GetStream/Winds/releases/latest'><img src='https://img.shields.io/github/v/release/GetStream/Winds?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/GetStream/Winds'><img src='https://img.shields.io/github/stars/GetStream/Winds?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/GetStream/Winds' alt='License'/>

  **Website:** [https://getstream.io/winds/](https://getstream.io/winds/)

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/a632526f284f114b74e16c393ce5ccac4ddefa48e168d7f81f5b3fa0be6abe5e/68747470733a2f2f692e696d6775722e636f6d2f573166706f77562e706e67' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/6041b4f4b94786f08926fb72b1a99c4f72031d104c3100bf1a360ff9dc90276d/68747470733a2f2f692e696d6775722e636f6d2f416c56674454672e706e67' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/2c483da82086b0b3b34ca830bef20c369bc2dad69cf821160139c6bc16cf62fb/68747470733a2f2f692e696d6775722e636f6d2f7a6157744e66562e706e67' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="notes"></a>
### 📔 Notes (16)
- [Boostnote](https://github.com/BoostIO/BoostNote-Legacy) - Note-taking application made for programmers just like you. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/BoostIO/BoostNote-Legacy/releases/latest'><img src='https://img.shields.io/github/v/release/BoostIO/BoostNote-Legacy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/BoostIO/BoostNote-Legacy'><img src='https://img.shields.io/github/stars/BoostIO/BoostNote-Legacy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/BoostIO/BoostNote-Legacy' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/BoostIO/Boostnote/master/resources/repository/top.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Dnote](https://github.com/dnote/dnote) - A simple command line notebook with multi-device sync and web interface.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/golang-16.png' alt='Go icon' title='Go' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/dnote/dnote/releases/latest'><img src='https://img.shields.io/github/v/release/dnote/dnote?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dnote/dnote'><img src='https://img.shields.io/github/stars/dnote/dnote?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dnote/dnote' alt='License'/>

  **Website:** [https://www.getdnote.com/](https://www.getdnote.com/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/dnote/dnote/master/assets/cli.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [FromScratch](https://github.com/Kilian/fromscratch) - Little app that you can use as a quick note taking or todo app.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/Kilian/fromscratch/releases/latest'><img src='https://img.shields.io/github/v/release/Kilian/fromscratch?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Kilian/fromscratch'><img src='https://img.shields.io/github/stars/Kilian/fromscratch?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Kilian/fromscratch' alt='License'/>

  </p>
  </details>

- [FSNotes](https://github.com/glushchenko/fsnotes) - Notes manager for macOS/iOS: modern notational velocity (nvALT) on steroids. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/glushchenko/fsnotes/releases/latest'><img src='https://img.shields.io/github/v/release/glushchenko/fsnotes?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/glushchenko/fsnotes'><img src='https://img.shields.io/github/stars/glushchenko/fsnotes?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/glushchenko/fsnotes' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/glushchenko/fsnotes/master/code.png' width='400' loading='lazy'/>

  <img src='https://f001.backblazeb2.com/file/og-files/ios.png' width='400' loading='lazy'/>

  </p>
  </details>

- [joplin](https://github.com/laurent22/joplin) - Note taking and to-do application with synchronization capabilities for Windows, macOS, Linux, Android and iOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/laurent22/joplin/releases/latest'><img src='https://img.shields.io/github/v/release/laurent22/joplin?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/laurent22/joplin'><img src='https://img.shields.io/github/stars/laurent22/joplin?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/laurent22/joplin' alt='License'/>

  </p>
  </details>

- [Jupyter Notebook Viewer](https://github.com/tuxu/nbviewer-app) - Notebook viewer for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/tuxu/nbviewer-app/releases/latest'><img src='https://img.shields.io/github/v/release/tuxu/nbviewer-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/tuxu/nbviewer-app'><img src='https://img.shields.io/github/stars/tuxu/nbviewer-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/tuxu/nbviewer-app' alt='License'/>

  </p>
  </details>

- [linked](https://github.com/lostdesign/linked) - 🧾 Your daily journal app, diary or anything else to unclutter your mind. Let linked help you get focused by writing down what is in your mind on a daily basis. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <code>vue</code> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/lostdesign/linked/releases/latest'><img src='https://img.shields.io/github/v/release/lostdesign/linked?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lostdesign/linked'><img src='https://img.shields.io/github/stars/lostdesign/linked?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lostdesign/linked' alt='License'/>

  **Website:** [https://uselinked.com](https://uselinked.com)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/5164617/112966541-9f3b4080-914a-11eb-9dff-00ea2a121b93.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/5164617/112368648-97f3dd00-8cdb-11eb-8865-0203264d420b.png' width='400' loading='lazy'/>

  </p>
  </details>

- [notable](https://github.com/jmcfarlane/notable) - Simple note taking application. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/jmcfarlane/notable/releases/latest'><img src='https://img.shields.io/github/v/release/jmcfarlane/notable?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jmcfarlane/notable'><img src='https://img.shields.io/github/stars/jmcfarlane/notable?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jmcfarlane/notable' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/jmcfarlane/notable/master/docs/images/notable.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/jmcfarlane/notable/master/docs/images/unsaved-changes.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/jmcfarlane/notable/master/docs/images/help.png' width='400' loading='lazy'/>

  *(4 more screenshots available in the repository)*

  </p>
  </details>

- [Notenik](https://github.com/hbowie/notenik-swift) - Note-taking app with many organizational options.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/hbowie/notenik-swift/releases/latest'><img src='https://img.shields.io/github/v/release/hbowie/notenik-swift?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hbowie/notenik-swift'><img src='https://img.shields.io/github/stars/hbowie/notenik-swift?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hbowie/notenik-swift' alt='License'/>

  **Website:** [https://notenik.app](https://notenik.app)

  **Screenshots:**

  <img src='https://notenik.app/images/notenik-list-and-display.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Notes](https://github.com/SauvageP/Notes) - Notes is a macOS application built to create notes, using text amongst other formats: images, videos, contacts, and etc. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/SauvageP/Notes/releases/latest'><img src='https://img.shields.io/github/v/release/SauvageP/Notes?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/SauvageP/Notes'><img src='https://img.shields.io/github/stars/SauvageP/Notes?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/SauvageP/Notes' alt='License'/>

  </p>
  </details>

- [NoteTaker](https://github.com/insidegui/NoteTaker) - Simple note taking app for macOS and iOS which uses Realm and CloudKit for syncing. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/NoteTaker/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/NoteTaker?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/NoteTaker'><img src='https://img.shields.io/github/stars/insidegui/NoteTaker?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/NoteTaker' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/insidegui/NoteTaker/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [QOwnNotes](https://github.com/pbek/QOwnNotes) - Plain-text file notepad and todo-list manager with markdown support and ownCloud / Nextcloud integration.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/pbek/QOwnNotes/releases/latest'><img src='https://img.shields.io/github/v/release/pbek/QOwnNotes?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pbek/QOwnNotes'><img src='https://img.shields.io/github/stars/pbek/QOwnNotes?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pbek/QOwnNotes' alt='License'/>

  **Website:** [https://www.qownnotes.org/](https://www.qownnotes.org/)

  **Screenshots:**

  <img src='https://www.qownnotes.org/screenshots/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Simplenote](https://github.com/Automattic/simplenote-macos) - Simplest way to keep notes. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Automattic/simplenote-macos/releases/latest'><img src='https://img.shields.io/github/v/release/Automattic/simplenote-macos?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Automattic/simplenote-macos'><img src='https://img.shields.io/github/stars/Automattic/simplenote-macos?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Automattic/simplenote-macos' alt='License'/>

  **Screenshots:**

  <img src='https://simplenoteblog.files.wordpress.com/2017/12/screen-shot-2017-12-22-at-9-05-33-am.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Standard Notes](https://github.com/standardnotes/app) - Safe place for your notes, thoughts, and life's work.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/standardnotes/app/releases/latest'><img src='https://img.shields.io/github/v/release/standardnotes/app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/standardnotes/app'><img src='https://img.shields.io/github/stars/standardnotes/app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/standardnotes/app' alt='License'/>

  </p>
  </details>

- [tmpNote](https://github.com/buddax2/tmpNote) - Very simple macOS app to make temporary notes. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/buddax2/tmpNote/releases/latest'><img src='https://img.shields.io/github/v/release/buddax2/tmpNote?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/buddax2/tmpNote'><img src='https://img.shields.io/github/stars/buddax2/tmpNote?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/buddax2/tmpNote' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/buddax2/tmpNote/master/Resources/screenshot_new.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Tusk](https://github.com/klaudiosinani/tusk) - Unofficial, third-party, community driven Evernote app with a handful of useful features.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/klaudiosinani/tusk/releases/latest'><img src='https://img.shields.io/github/v/release/klaudiosinani/tusk?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/klaudiosinani/tusk'><img src='https://img.shields.io/github/stars/klaudiosinani/tusk?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/klaudiosinani/tusk' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="other"></a>
### 📦 Other (22)
- [Betaflight Configurator](https://github.com/betaflight/betaflight-configurator) - Cross platform configuration tool for the Betaflight firmware.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/betaflight/betaflight-configurator/releases/latest'><img src='https://img.shields.io/github/v/release/betaflight/betaflight-configurator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/betaflight/betaflight-configurator'><img src='https://img.shields.io/github/stars/betaflight/betaflight-configurator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/betaflight/betaflight-configurator' alt='License'/>

  **Website:** [https://betaflight.com/](https://betaflight.com/)

  **Screenshots:**

  <img src='https://lh3.googleusercontent.com/di77U8MJEDNqdZ3UQugKJy6TEDtHsPegDH8fOaCM0m8E7zImA6bW1epvftG5LdpUsxE-eAkJtKAfDqIvOf-RXr8VUhg=w640-h400-e365-rj-sc0x00ffffff' width='400' loading='lazy'/>

  </p>
  </details>

- [Cakebrew](https://github.com/brunophilipe/Cakebrew) - Manage your Homebrew formulas with style using Cakebrew. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/brunophilipe/Cakebrew/releases/latest'><img src='https://img.shields.io/github/v/release/brunophilipe/Cakebrew?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/brunophilipe/Cakebrew'><img src='https://img.shields.io/github/stars/brunophilipe/Cakebrew?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/brunophilipe/Cakebrew' alt='License'/>

  **Screenshots:**

  <img src='https://www.cakebrew.com/assets/img/app-bg.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ChipMunk](https://github.com/esrlabs/chipmunk) - Log analysis tool. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/esrlabs/chipmunk/releases/latest'><img src='https://img.shields.io/github/v/release/esrlabs/chipmunk?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/esrlabs/chipmunk'><img src='https://img.shields.io/github/stars/esrlabs/chipmunk?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/esrlabs/chipmunk' alt='License'/>

  **Screenshots:**

  <img src='' width='400' loading='lazy'/>

  </p>
  </details>

- [DevDocs for macOS](https://github.com/dteoh/devdocs-macos) - An unofficial DevDocs API documentation viewer.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/dteoh/devdocs-macos/releases/latest'><img src='https://img.shields.io/github/v/release/dteoh/devdocs-macos?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dteoh/devdocs-macos'><img src='https://img.shields.io/github/stars/dteoh/devdocs-macos?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dteoh/devdocs-macos' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/dteoh/devdocs-macos/master/img/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Gas Mask](https://github.com/2ndalpha/gasmask) - Hosts file manager for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/2ndalpha/gasmask/releases/latest'><img src='https://img.shields.io/github/v/release/2ndalpha/gasmask?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/2ndalpha/gasmask'><img src='https://img.shields.io/github/stars/2ndalpha/gasmask?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/2ndalpha/gasmask' alt='License'/>

  </p>
  </details>

- [Hosts](https://github.com/specialunderwear/Hosts.prefpane) - Cocoa GUI for /etc/hosts. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/specialunderwear/Hosts.prefpane/releases/latest'><img src='https://img.shields.io/github/v/release/specialunderwear/Hosts.prefpane?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/specialunderwear/Hosts.prefpane'><img src='https://img.shields.io/github/stars/specialunderwear/Hosts.prefpane?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/specialunderwear/Hosts.prefpane' alt='License'/>

  </p>
  </details>

- [ImageOptim](https://github.com/ImageOptim/ImageOptim) - GUI image optimizer for Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/ImageOptim/ImageOptim/releases/latest'><img src='https://img.shields.io/github/v/release/ImageOptim/ImageOptim?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ImageOptim/ImageOptim'><img src='https://img.shields.io/github/stars/ImageOptim/ImageOptim?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ImageOptim/ImageOptim' alt='License'/>

  </p>
  </details>

- [Keyframes Player](https://github.com/insidegui/KeyframesPlayer) - Simple macOS app to preview animations created with Facebook's keyframes framework. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/KeyframesPlayer/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/KeyframesPlayer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/KeyframesPlayer'><img src='https://img.shields.io/github/stars/insidegui/KeyframesPlayer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/KeyframesPlayer' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/insidegui/KeyframesPlayer/master/screenshot.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Lepton](https://github.com/hackjutsu/Lepton) - Democratizing Code Snippets Management (macOS/Win/Linux). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/hackjutsu/Lepton/releases/latest'><img src='https://img.shields.io/github/v/release/hackjutsu/Lepton?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hackjutsu/Lepton'><img src='https://img.shields.io/github/stars/hackjutsu/Lepton?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hackjutsu/Lepton' alt='License'/>

  </p>
  </details>

- [Letters](https://github.com/klaaspieter/letters) - Teach your kids the alphabet and how to type.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/klaaspieter/letters/releases/latest'><img src='https://img.shields.io/github/v/release/klaaspieter/letters?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/klaaspieter/letters'><img src='https://img.shields.io/github/stars/klaaspieter/letters?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/klaaspieter/letters' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/9a6e15d41e4976c204add53b0ee9ac95e97ad86f/687474703a2f2f692e67697068792e636f6d2f336f365a73536b78743056326e37396b546d2e676966' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/98880/35166585-a81ed35e-fd52-11e7-87e1-9e82a03cc36d.jpg' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/98880/35166588-a90e5c12-fd52-11e7-8fcc-45679328392c.jpg' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [macGist](https://github.com/Bunn/macGist) - Simple app to send pasteboard items to GitHub's Gist. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Bunn/macGist/releases/latest'><img src='https://img.shields.io/github/v/release/Bunn/macGist?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Bunn/macGist'><img src='https://img.shields.io/github/stars/Bunn/macGist?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Bunn/macGist' alt='License'/>

  </p>
  </details>

- [Platypus](https://github.com/sveinbjornt/Platypus) - Mac developer tool that creates application bundles from command line scripts. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/sveinbjornt/Platypus/releases/latest'><img src='https://img.shields.io/github/v/release/sveinbjornt/Platypus?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sveinbjornt/Platypus'><img src='https://img.shields.io/github/stars/sveinbjornt/Platypus?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sveinbjornt/Platypus' alt='License'/>

  </p>
  </details>

- [QorumLogs](https://github.com/Esqarrouth/QorumLogs) - Swift Logging Utility for Xcode & Google Docs. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Esqarrouth/QorumLogs/releases/latest'><img src='https://img.shields.io/github/v/release/Esqarrouth/QorumLogs?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Esqarrouth/QorumLogs'><img src='https://img.shields.io/github/stars/Esqarrouth/QorumLogs?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Esqarrouth/QorumLogs' alt='License'/>

  </p>
  </details>

- [React Native Debugger](https://github.com/jhen0409/react-native-debugger) - Desktop app for inspecting your React Native projects. macOS, Linux, and Windows. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/jhen0409/react-native-debugger/releases/latest'><img src='https://img.shields.io/github/v/release/jhen0409/react-native-debugger?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jhen0409/react-native-debugger'><img src='https://img.shields.io/github/stars/jhen0409/react-native-debugger?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jhen0409/react-native-debugger' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/3001525/29451479-6621bf1a-83c8-11e7-8ebb-b4e98b1af91c.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Reactotron](https://github.com/infinitered/reactotron) - Desktop app for inspecting your React JS and React Native projects. macOS, Linux, and Windows. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/infinitered/reactotron/releases/latest'><img src='https://img.shields.io/github/v/release/infinitered/reactotron?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/infinitered/reactotron'><img src='https://img.shields.io/github/stars/infinitered/reactotron?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/infinitered/reactotron' alt='License'/>

  </p>
  </details>

- [RktMachine](https://github.com/woofwoofinc/rktmachine) - Menu bar macOS app for running rkt in a macOS hypervisor CoreOS VM. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/woofwoofinc/rktmachine/releases/latest'><img src='https://img.shields.io/github/v/release/woofwoofinc/rktmachine?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/woofwoofinc/rktmachine'><img src='https://img.shields.io/github/stars/woofwoofinc/rktmachine?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/woofwoofinc/rktmachine' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/woofwoofinc/rktmachine/master/docs/assets/title.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/woofwoofinc/rktmachine/master/docs/assets/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Ruby.app](https://github.com/gosu/ruby-app) - macOS app that contains a full Ruby installation (for use with Ruby/Gosu). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/ruby-16.png' alt='Ruby icon' title='Ruby' height='16'/> 

  **Links:** <a href='https://github.com/gosu/ruby-app/releases/latest'><img src='https://img.shields.io/github/v/release/gosu/ruby-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gosu/ruby-app'><img src='https://img.shields.io/github/stars/gosu/ruby-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gosu/ruby-app' alt='License'/>

  </p>
  </details>

- [Shuttle](https://github.com/fitztrev/shuttle) - Simple SSH shortcut menu for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/fitztrev/shuttle/releases/latest'><img src='https://img.shields.io/github/v/release/fitztrev/shuttle?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/fitztrev/shuttle'><img src='https://img.shields.io/github/stars/fitztrev/shuttle?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/fitztrev/shuttle' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/fitztrev/shuttle/gh-pages/images/how-shuttle-works.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [SwiftyBeaver](https://github.com/SwiftyBeaver/SwiftyBeaver) - Convenient logging during development & release in Swift. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/SwiftyBeaver/SwiftyBeaver/releases/latest'><img src='https://img.shields.io/github/v/release/SwiftyBeaver/SwiftyBeaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/SwiftyBeaver/SwiftyBeaver'><img src='https://img.shields.io/github/stars/SwiftyBeaver/SwiftyBeaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/SwiftyBeaver/SwiftyBeaver' alt='License'/>

  </p>
  </details>

- [syncthing-macosx](https://github.com/syncthing/syncthing-macos) - Frugal nativemacOS macOS Syncthing application bundle. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/syncthing/syncthing-macos/releases/latest'><img src='https://img.shields.io/github/v/release/syncthing/syncthing-macos?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/syncthing/syncthing-macos'><img src='https://img.shields.io/github/stars/syncthing/syncthing-macos?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/syncthing/syncthing-macos' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/1050166/48157165-35970f00-e2cf-11e8-8009-10bfbf7fbce2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Unused](https://github.com/jeffhodnett/Unused) - Mac app for checking Xcode projects for unused resources.  

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/jeffhodnett/Unused/releases/latest'><img src='https://img.shields.io/github/v/release/jeffhodnett/Unused?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jeffhodnett/Unused'><img src='https://img.shields.io/github/stars/jeffhodnett/Unused?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jeffhodnett/Unused' alt='License'/>

  </p>
  </details>

- [Vagrant Manager](https://github.com/lanayotech/vagrant-manager) - Manage your vagrant machines in one place with Vagrant Manager for macOS.  

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/lanayotech/vagrant-manager/releases/latest'><img src='https://img.shields.io/github/v/release/lanayotech/vagrant-manager?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lanayotech/vagrant-manager'><img src='https://img.shields.io/github/stars/lanayotech/vagrant-manager?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lanayotech/vagrant-manager' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/1NTsz6S.gif' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="player"></a>
### ▶️ Player (6)
- [IINA](https://github.com/iina/iina) - The modern video player for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/iina/iina/releases/latest'><img src='https://img.shields.io/github/v/release/iina/iina?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/iina/iina'><img src='https://img.shields.io/github/stars/iina/iina?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/iina/iina' alt='License'/>

  **Website:** [https://iina.io](https://iina.io)

  </p>
  </details>

- [MacMorpheus](https://github.com/emoRaivis/MacMorpheus) - 3D 180/360 video player for macOS for PSVR with head tracking. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/emoRaivis/MacMorpheus/releases/latest'><img src='https://img.shields.io/github/v/release/emoRaivis/MacMorpheus?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/emoRaivis/MacMorpheus'><img src='https://img.shields.io/github/stars/emoRaivis/MacMorpheus?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/emoRaivis/MacMorpheus' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/emoRaivis/MacMorpheus/master/wiring_diagram.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Movie Monad](https://github.com/lettier/movie-monad) - Desktop video player built with Haskell that uses GStreamer and GTK+. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/haskell-16.png' alt='Haskell icon' title='Haskell' height='16'/> 

  **Links:** <a href='https://github.com/lettier/movie-monad/releases/latest'><img src='https://img.shields.io/github/v/release/lettier/movie-monad?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lettier/movie-monad'><img src='https://img.shields.io/github/stars/lettier/movie-monad?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lettier/movie-monad' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/r1btBMF.gif' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/gdsyIMv.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MPlayerX](https://github.com/niltsh/MPlayerX) - Media player on macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/niltsh/MPlayerX/releases/latest'><img src='https://img.shields.io/github/v/release/niltsh/MPlayerX?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/niltsh/MPlayerX'><img src='https://img.shields.io/github/stars/niltsh/MPlayerX?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/niltsh/MPlayerX' alt='License'/>

  </p>
  </details>

- [MPV](https://github.com/mpv-player/mpv) - Lightweight, highly configurable media player.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/mpv-player/mpv/releases/latest'><img src='https://img.shields.io/github/v/release/mpv-player/mpv?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mpv-player/mpv'><img src='https://img.shields.io/github/stars/mpv-player/mpv?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mpv-player/mpv' alt='License'/>

  **Website:** [https://mpv.io](https://mpv.io)

  **Screenshots:**

  <img src='https://mpv.io/images/mpv-screenshot-34cd36ae.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Plug](https://github.com/wulkano/Plug) - Discover and listen to music from Hype Machine.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/wulkano/Plug/releases/latest'><img src='https://img.shields.io/github/v/release/wulkano/Plug?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wulkano/Plug'><img src='https://img.shields.io/github/stars/wulkano/Plug?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wulkano/Plug' alt='License'/>

  **Website:** [https://www.plugformac.com/](https://www.plugformac.com/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wulkano/Plug/1ae6383ad9ad7026ce6fad4f1ea7ce3356c1f722/Media/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="podcast"></a>
### 🎙️ Podcast (7)
- [Cumulonimbus](https://github.com/z-------------/CPod) - Simple, beautiful podcast app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/z-------------/CPod/releases/latest'><img src='https://img.shields.io/github/v/release/z-------------/CPod?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/z-------------/CPod'><img src='https://img.shields.io/github/stars/z-------------/CPod?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/z-------------/CPod' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/S7K9wrr.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Doughnut](https://github.com/dyerc/Doughnut) - Podcast player and library for mac

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/dyerc/Doughnut/releases/latest'><img src='https://img.shields.io/github/v/release/dyerc/Doughnut?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dyerc/Doughnut'><img src='https://img.shields.io/github/stars/dyerc/Doughnut?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dyerc/Doughnut' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/CD1212/Doughnut/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [gPodder](https://github.com/gpodder/gpodder) - gPodder is a simple, open source podcast client.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/gpodder/gpodder/releases/latest'><img src='https://img.shields.io/github/v/release/gpodder/gpodder?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gpodder/gpodder'><img src='https://img.shields.io/github/stars/gpodder/gpodder?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gpodder/gpodder' alt='License'/>

  **Website:** [https://gpodder.github.io/](https://gpodder.github.io/)

  **Screenshots:**

  <img src='https://gpodder.github.io/assets/screenshot-2022-03-24-crop.png' width='400' loading='lazy'/>

  </p>
  </details>

- [mkchromecast](https://github.com/muammar/mkchromecast) - Cast macOS and Linux Audio/Video to your Google Cast and Sonos Devices. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/muammar/mkchromecast/releases/latest'><img src='https://img.shields.io/github/v/release/muammar/mkchromecast?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/muammar/mkchromecast'><img src='https://img.shields.io/github/stars/muammar/mkchromecast?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/muammar/mkchromecast' alt='License'/>

  </p>
  </details>

- [PodcastMenu](https://github.com/insidegui/PodcastMenu) - PodcastMenu is a simple app which puts [Overcast](https://overcast.fm/) on your Mac's menu bar so you can listen to your favorite podcasts while you work. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/PodcastMenu/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/PodcastMenu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/PodcastMenu'><img src='https://img.shields.io/github/stars/insidegui/PodcastMenu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/PodcastMenu' alt='License'/>

  </p>
  </details>

- [Podlive for macOS](https://github.com/Podlive/podlive-macos) - macOS client to listen to live streaming podcasts (only). It currently supports all livestreams broadcasting via Ultraschall with [Studio Link On Air](https://studio-link.de). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Podlive/podlive-macos/releases/latest'><img src='https://img.shields.io/github/v/release/Podlive/podlive-macos?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Podlive/podlive-macos'><img src='https://img.shields.io/github/stars/Podlive/podlive-macos?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Podlive/podlive-macos' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/phranck/podlive-macos/master/screenshot1.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Winds](https://github.com/GetStream/Winds) - A Beautiful Open Source RSS & Podcast App Powered by Getstream.io

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/GetStream/Winds/releases/latest'><img src='https://img.shields.io/github/v/release/GetStream/Winds?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/GetStream/Winds'><img src='https://img.shields.io/github/stars/GetStream/Winds?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/GetStream/Winds' alt='License'/>

  **Website:** [https://getstream.io/winds/](https://getstream.io/winds/)

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/a632526f284f114b74e16c393ce5ccac4ddefa48e168d7f81f5b3fa0be6abe5e/68747470733a2f2f692e696d6775722e636f6d2f573166706f77562e706e67' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/6041b4f4b94786f08926fb72b1a99c4f72031d104c3100bf1a360ff9dc90276d/68747470733a2f2f692e696d6775722e636f6d2f416c56674454672e706e67' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/2c483da82086b0b3b34ca830bef20c369bc2dad69cf821160139c6bc16cf62fb/68747470733a2f2f692e696d6775722e636f6d2f7a6157744e66562e706e67' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="productivity"></a>
### ⏱️ Productivity (57)
- [Ao](https://github.com/klaudiosinani/ao) - Elegant Microsoft To-Do desktop app.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/klaudiosinani/ao/releases/latest'><img src='https://img.shields.io/github/v/release/klaudiosinani/ao?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/klaudiosinani/ao'><img src='https://img.shields.io/github/stars/klaudiosinani/ao?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/klaudiosinani/ao' alt='License'/>

  </p>
  </details>

- [Bye-AppQuit](https://github.com/designsbymuzeer/Bye-Mac-App) - A minimal native macOS app to quickly view and Bulk kill running processes.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/designsbymuzeer/Bye-Mac-App/releases/latest'><img src='https://img.shields.io/github/v/release/designsbymuzeer/Bye-Mac-App?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/designsbymuzeer/Bye-Mac-App'><img src='https://img.shields.io/github/stars/designsbymuzeer/Bye-Mac-App?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/designsbymuzeer/Bye-Mac-App' alt='License'/>

  **Website:** [https://github.com/designsbymuzeer/Bye-Mac-App](https://github.com/designsbymuzeer/Bye-Mac-App)

  **Screenshots:**

  <img src='https://github.com/user-attachments/assets/63dade24-d967-4946-89e5-f8ae44097b31' width='400' loading='lazy'/>

  </p>
  </details>

- [Calculeta](https://github.com/varol/Calculeta) - Calculator for macOS which working on statusbar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/varol/Calculeta/releases/latest'><img src='https://img.shields.io/github/v/release/varol/Calculeta?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/varol/Calculeta'><img src='https://img.shields.io/github/stars/varol/Calculeta?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/varol/Calculeta' alt='License'/>

  </p>
  </details>

- [Cerebro](https://github.com/cerebroapp/cerebro) - Cross-platform launcher app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/cerebroapp/cerebro/releases/latest'><img src='https://img.shields.io/github/v/release/cerebroapp/cerebro?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/cerebroapp/cerebro'><img src='https://img.shields.io/github/stars/cerebroapp/cerebro?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/cerebroapp/cerebro' alt='License'/>

  </p>
  </details>

- [ClipMenu](https://github.com/naotaka/ClipMenu) - Clipboard manager for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/naotaka/ClipMenu/releases/latest'><img src='https://img.shields.io/github/v/release/naotaka/ClipMenu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/naotaka/ClipMenu'><img src='https://img.shields.io/github/stars/naotaka/ClipMenu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/naotaka/ClipMenu' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/naotaka/ClipMenu/master/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Clocker](https://github.com/n0shake/Clocker) - macOS app to plan and organize through timezones. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/n0shake/Clocker/releases/latest'><img src='https://img.shields.io/github/v/release/n0shake/Clocker?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/n0shake/Clocker'><img src='https://img.shields.io/github/stars/n0shake/Clocker?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/n0shake/Clocker' alt='License'/>

  </p>
  </details>

- [Condution](https://github.com/Shabang-Systems/Condution) - Create tasks, manage due dates, and filter with powerful perspectives.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/Shabang-Systems/Condution/releases/latest'><img src='https://img.shields.io/github/v/release/Shabang-Systems/Condution?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Shabang-Systems/Condution'><img src='https://img.shields.io/github/stars/Shabang-Systems/Condution?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Shabang-Systems/Condution' alt='License'/>

  **Website:** [https://www.condution.com](https://www.condution.com)

  **Screenshots:**

  <img src='https://www.condution.com/static/media/demo.528a92c2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ControlPlane](https://github.com/dustinrue/ControlPlane) - Automate running tasks based on where you are or what you do. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/dustinrue/ControlPlane/releases/latest'><img src='https://img.shields.io/github/v/release/dustinrue/ControlPlane?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dustinrue/ControlPlane'><img src='https://img.shields.io/github/stars/dustinrue/ControlPlane?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dustinrue/ControlPlane' alt='License'/>

  </p>
  </details>

- [DevUtils.app](https://github.com/DevUtilsApp/DevUtils-app) - Developer Utilities for macOS, helps you with your tiny daily tasks with just a single click! i.e., JSON Formatter, UUID Generator...

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/DevUtilsApp/DevUtils-app/releases/latest'><img src='https://img.shields.io/github/v/release/DevUtilsApp/DevUtils-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/DevUtilsApp/DevUtils-app'><img src='https://img.shields.io/github/stars/DevUtilsApp/DevUtils-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/DevUtilsApp/DevUtils-app' alt='License'/>

  **Website:** [https://devutils.com](https://devutils.com)

  **Screenshots:**

  <img src='https://devutils.com/screenshot-dark.png' width='400' loading='lazy'/>

  </p>
  </details>

- [DropPoint](https://github.com/GameGodS3/DropPoint) - Make drag-and-drop easier using DropPoint. Helps to drag content without having to open side-by-side windows.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/GameGodS3/DropPoint/releases/latest'><img src='https://img.shields.io/github/v/release/GameGodS3/DropPoint?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/GameGodS3/DropPoint'><img src='https://img.shields.io/github/stars/GameGodS3/DropPoint?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/GameGodS3/DropPoint' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/QkUPoOb.gif' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/WElktc0.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [espanso](https://github.com/espanso/espanso) - Cross-platform Text Expander, a powerful replacement for Alfred Snippets

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/espanso/espanso/releases/latest'><img src='https://img.shields.io/github/v/release/espanso/espanso?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/espanso/espanso'><img src='https://img.shields.io/github/stars/espanso/espanso?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/espanso/espanso' alt='License'/>

  **Website:** [https://espanso.org](https://espanso.org)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/federico-terzi/espanso/master/images/example.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [far2l](https://github.com/elfmz/far2l) - Linux/Mac fork of FAR Manager v2

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/elfmz/far2l/releases/latest'><img src='https://img.shields.io/github/v/release/elfmz/far2l?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/elfmz/far2l'><img src='https://img.shields.io/github/stars/elfmz/far2l?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/elfmz/far2l' alt='License'/>

  </p>
  </details>

- [Flycut](https://github.com/TermiT/flycut) - Clean and simple clipboard manager for developers. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/TermiT/flycut/releases/latest'><img src='https://img.shields.io/github/v/release/TermiT/flycut?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/TermiT/flycut'><img src='https://img.shields.io/github/stars/TermiT/flycut?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/TermiT/flycut' alt='License'/>

  </p>
  </details>

- [Ice](https://github.com/jordanbaird/Ice) - Ice is a versatile menu bar manager that goes beyond hiding and showing items to offer a rich set of productivity features.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/jordanbaird/Ice/releases/latest'><img src='https://img.shields.io/github/v/release/jordanbaird/Ice?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jordanbaird/Ice'><img src='https://img.shields.io/github/stars/jordanbaird/Ice?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jordanbaird/Ice' alt='License'/>

  **Website:** [https://icemenubar.app/](https://icemenubar.app/)

  **Screenshots:**

  <img src='https://icemenubar.app/gallery/ice-bar.png' width='400' loading='lazy'/>

  <img src='https://icemenubar.app/gallery/menu-bar-item-search.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Itsycal](https://github.com/sfsam/Itsycal) - A tiny calendar for that lives in the Mac menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/sfsam/Itsycal/releases/latest'><img src='https://img.shields.io/github/v/release/sfsam/Itsycal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sfsam/Itsycal'><img src='https://img.shields.io/github/stars/sfsam/Itsycal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sfsam/Itsycal' alt='License'/>

  **Website:** [https://www.mowglii.com/itsycal/](https://www.mowglii.com/itsycal/)

  **Screenshots:**

  <img src='https://www.mowglii.com/itsycal/itsycalbanner2@2x.png' width='400' loading='lazy'/>

  </p>
  </details>

- [KeyHolder](https://github.com/Clipy/KeyHolder) - Record shortcuts in macOS, like Alfred.app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Clipy/KeyHolder/releases/latest'><img src='https://img.shields.io/github/v/release/Clipy/KeyHolder?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Clipy/KeyHolder'><img src='https://img.shields.io/github/stars/Clipy/KeyHolder?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Clipy/KeyHolder' alt='License'/>

  </p>
  </details>

- [Kiwix](https://github.com/kiwix/apple) - Kiwix for iOS and macOS, build on Swift. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/kiwix/apple/releases/latest'><img src='https://img.shields.io/github/v/release/kiwix/apple?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kiwix/apple'><img src='https://img.shields.io/github/stars/kiwix/apple?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kiwix/apple' alt='License'/>

  </p>
  </details>

- [Layout Designer for UICollectionView](https://github.com/amirdew/CollectionViewPagingLayout) - A simple but powerful tool that helps you make complex layouts for UICollectionView.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12'><img src='./icons/app_store-16.png' alt='App Store' title='Download on the Mac App Store' height='16'/> App Store</a> &nbsp; <a href='https://github.com/amirdew/CollectionViewPagingLayout/releases/latest'><img src='https://img.shields.io/github/v/release/amirdew/CollectionViewPagingLayout?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/amirdew/CollectionViewPagingLayout'><img src='https://img.shields.io/github/stars/amirdew/CollectionViewPagingLayout?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/amirdew/CollectionViewPagingLayout' alt='License'/>

  **Website:** [https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12](https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12)

  **Screenshots:**

  <img src='https://amir.app/git/layout_designer_preview.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [linked](https://github.com/lostdesign/linked) - 🧾 Your daily journal app, diary or anything else to unclutter your mind. Let linked help you get focused by writing down what is in your mind on a daily basis. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <code>vue</code> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/lostdesign/linked/releases/latest'><img src='https://img.shields.io/github/v/release/lostdesign/linked?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lostdesign/linked'><img src='https://img.shields.io/github/stars/lostdesign/linked?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lostdesign/linked' alt='License'/>

  **Website:** [https://uselinked.com](https://uselinked.com)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/5164617/112966541-9f3b4080-914a-11eb-9dff-00ea2a121b93.png' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/5164617/112368648-97f3dd00-8cdb-11eb-8865-0203264d420b.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Linked Ideas](https://github.com/fespinoza/LinkedIdeas) - macOS application to write down and connect ideas. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/fespinoza/LinkedIdeas/releases/latest'><img src='https://img.shields.io/github/v/release/fespinoza/LinkedIdeas?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/fespinoza/LinkedIdeas'><img src='https://img.shields.io/github/stars/fespinoza/LinkedIdeas?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/fespinoza/LinkedIdeas' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/uqb1x43.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Mac Screenshot Tracker](https://github.com/instance01/mac-screenshot-tracker) - An open source, free and hackable screenshot tracker. Re-watch what you've been working on!

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/instance01/mac-screenshot-tracker/releases/latest'><img src='https://img.shields.io/github/v/release/instance01/mac-screenshot-tracker?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/instance01/mac-screenshot-tracker'><img src='https://img.shields.io/github/stars/instance01/mac-screenshot-tracker?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/instance01/mac-screenshot-tracker' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/instance01/mac-screenshot-tracker/master/.github/screen1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/instance01/mac-screenshot-tracker/master/.github/screen2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Maccy](https://github.com/p0deje/Maccy) - Lightweight search-as-you-type clipboard manager. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/p0deje/Maccy/releases/latest'><img src='https://img.shields.io/github/v/release/p0deje/Maccy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/p0deje/Maccy'><img src='https://img.shields.io/github/stars/p0deje/Maccy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/p0deje/Maccy' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/665846/36135303-8c4f80ae-10b4-11e8-9940-978e228cb6bd.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [macOrganizer](https://github.com/shubhambatra3019/macOrganizer) - macOS app for organizing files or removing unnecessary files. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/shubhambatra3019/macOrganizer/releases/latest'><img src='https://img.shields.io/github/v/release/shubhambatra3019/macOrganizer?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/shubhambatra3019/macOrganizer'><img src='https://img.shields.io/github/stars/shubhambatra3019/macOrganizer?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/shubhambatra3019/macOrganizer' alt='License'/>

  </p>
  </details>

- [Manta](https://github.com/hql287/Manta) - Flexible invoicing desktop app with beautiful & customizable templates. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/hql287/Manta/releases/latest'><img src='https://img.shields.io/github/v/release/hql287/Manta?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hql287/Manta'><img src='https://img.shields.io/github/stars/hql287/Manta?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hql287/Manta' alt='License'/>

  </p>
  </details>

- [MeetingBar](https://github.com/leits/MeetingBar) - Menu bar app for your calendar meetings

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/leits/MeetingBar/releases/latest'><img src='https://img.shields.io/github/v/release/leits/MeetingBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/leits/MeetingBar'><img src='https://img.shields.io/github/stars/leits/MeetingBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/leits/MeetingBar' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/leits/MeetingBar/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Middleclick](https://github.com/artginzburg/MiddleClick-Ventura) - Emulate a scroll wheel click with three finger Click or Tap on MacBook trackpad and Magic Mouse

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/artginzburg/MiddleClick-Ventura/releases/latest'><img src='https://img.shields.io/github/v/release/artginzburg/MiddleClick-Ventura?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/artginzburg/MiddleClick-Ventura'><img src='https://img.shields.io/github/stars/artginzburg/MiddleClick-Ventura?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/artginzburg/MiddleClick-Ventura' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/artginzburg/MiddleClick-Ventura/blob/master/demo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Paperless Desktop](https://github.com/thomasbrueggemann/paperless-desktop) - Desktop app that uses the paperless API to manage your document scans. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/thomasbrueggemann/paperless-desktop/releases/latest'><img src='https://img.shields.io/github/v/release/thomasbrueggemann/paperless-desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/thomasbrueggemann/paperless-desktop'><img src='https://img.shields.io/github/stars/thomasbrueggemann/paperless-desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/thomasbrueggemann/paperless-desktop' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/F5GNK4X.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/FrgAptE.png' width='400' loading='lazy'/>

  </p>
  </details>

- [PDF Archiver](https://github.com/PDF-Archiver/PDF-Archiver) - Nice tool for tagging and archiving tasks. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/PDF-Archiver/PDF-Archiver/releases/latest'><img src='https://img.shields.io/github/v/release/PDF-Archiver/PDF-Archiver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/PDF-Archiver/PDF-Archiver'><img src='https://img.shields.io/github/stars/PDF-Archiver/PDF-Archiver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/PDF-Archiver/PDF-Archiver' alt='License'/>

  </p>
  </details>

- [Pennywise](https://github.com/kamranahmedse/pennywise) - Pennywise opens any website or media in a small floating window that remains on top of all other applications. It's a great alternative to Helium.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/kamranahmedse/pennywise/releases/latest'><img src='https://img.shields.io/github/v/release/kamranahmedse/pennywise?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kamranahmedse/pennywise'><img src='https://img.shields.io/github/stars/kamranahmedse/pennywise?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kamranahmedse/pennywise' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/275d176aeaab2b9cf09701a091c8fb7ecfe6256a/68747470733a2f2f692e696d6775722e636f6d2f753766415439392e706e67' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/71ba8a4a28624f1f102272685f72a80fe70a2c03/68747470733a2f2f692e696d6775722e636f6d2f43654c596f75782e706e673f31' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/601c0dc538bad004c231201e8fe86e16ed3729d0/68747470733a2f2f692e696d6775722e636f6d2f4262715a6d634b2e706e67' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [Pomodoro Cycle](https://github.com/ziulev/pomodoro-cycle-app) - Pomodoro Cycle for macOS

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/ziulev/pomodoro-cycle-app/releases/latest'><img src='https://img.shields.io/github/v/release/ziulev/pomodoro-cycle-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ziulev/pomodoro-cycle-app'><img src='https://img.shields.io/github/stars/ziulev/pomodoro-cycle-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ziulev/pomodoro-cycle-app' alt='License'/>

  **Website:** [https://github.com/ziulev/pomodoro-cycle-app/releases](https://github.com/ziulev/pomodoro-cycle-app/releases)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/jet8a/pomodoro-cycle-app/master/screenshots/preview.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [QOwnNotes](https://github.com/pbek/QOwnNotes) - Plain-text file notepad and todo-list manager with markdown support and ownCloud / Nextcloud integration.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/pbek/QOwnNotes/releases/latest'><img src='https://img.shields.io/github/v/release/pbek/QOwnNotes?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pbek/QOwnNotes'><img src='https://img.shields.io/github/stars/pbek/QOwnNotes?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pbek/QOwnNotes' alt='License'/>

  **Website:** [https://www.qownnotes.org/](https://www.qownnotes.org/)

  **Screenshots:**

  <img src='https://www.qownnotes.org/screenshots/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Quicksilver](https://github.com/quicksilver/Quicksilver) - Quicksilver is a fast macOS productivity application that gives you the power to control your Mac quickly and elegantly. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/quicksilver/Quicksilver/releases/latest'><img src='https://img.shields.io/github/v/release/quicksilver/Quicksilver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/quicksilver/Quicksilver'><img src='https://img.shields.io/github/stars/quicksilver/Quicksilver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/quicksilver/Quicksilver' alt='License'/>

  </p>
  </details>

- [Quickwords](https://github.com/quickwords/quickwords) - Write anything in a matter of seconds. Create snippets that can substitute text, execute tedious tasks and more. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/quickwords/quickwords/releases/latest'><img src='https://img.shields.io/github/v/release/quickwords/quickwords?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/quickwords/quickwords'><img src='https://img.shields.io/github/stars/quickwords/quickwords?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/quickwords/quickwords' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/asCk1Ds.png' width='400' loading='lazy'/>

  </p>
  </details>

- [reventlou](https://github.com/b3z/reventlou) - Personal database as an information management system.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/b3z/reventlou/releases/latest'><img src='https://img.shields.io/github/v/release/b3z/reventlou?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/b3z/reventlou'><img src='https://img.shields.io/github/stars/b3z/reventlou?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/b3z/reventlou' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/b3z/reventlou/blob/master/assets/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [SelfControl](https://github.com/SelfControlApp/selfcontrol) - macOS app to block your own access to distracting websites etc for a predetermined period of time. It can not be undone by the app or by a restart – you must wait for the timer to run out. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/SelfControlApp/selfcontrol/releases/latest'><img src='https://img.shields.io/github/v/release/SelfControlApp/selfcontrol?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/SelfControlApp/selfcontrol'><img src='https://img.shields.io/github/stars/SelfControlApp/selfcontrol?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/SelfControlApp/selfcontrol' alt='License'/>

  </p>
  </details>

- [Sessions](https://github.com/AlexPerathoner/Sessions) - Safari extension to save your working sessions

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AlexPerathoner/Sessions/releases/latest'><img src='https://img.shields.io/github/v/release/AlexPerathoner/Sessions?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AlexPerathoner/Sessions'><img src='https://img.shields.io/github/stars/AlexPerathoner/Sessions?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AlexPerathoner/Sessions' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/AlexPerathoner/Sessions/master/Screens/Registrazione%20schermo%202019-11-26%20alle%2001.14.21.mov' width='400' loading='lazy'/>

  </p>
  </details>

- [Speed Reader](https://github.com/LumingYin/SpeedReader) - Read faster with the power of silencing vocalization with SpeedReader.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://apps.apple.com/app/speed-reader/id1258448209'><img src='./icons/app_store-16.png' alt='App Store' title='Download on the Mac App Store' height='16'/> App Store</a> &nbsp; <a href='https://github.com/LumingYin/SpeedReader/releases/latest'><img src='https://img.shields.io/github/v/release/LumingYin/SpeedReader?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/LumingYin/SpeedReader'><img src='https://img.shields.io/github/stars/LumingYin/SpeedReader?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/LumingYin/SpeedReader' alt='License'/>

  **Website:** [https://apps.apple.com/app/speed-reader/id1258448209](https://apps.apple.com/app/speed-reader/id1258448209)

  **Screenshots:**

  <img src='https://github.com/LumingYin/SpeedReader/blob/master/speedreader_dark.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Spotter](https://github.com/spotter-application/spotter) - Productivity tool, the main function is to search and launch external application actions and applications themselves, so you can stay focused on your current task. Kind of spotlight or alfred alternative.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/spotter-application/spotter/releases/latest'><img src='https://img.shields.io/github/v/release/spotter-application/spotter?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/spotter-application/spotter'><img src='https://img.shields.io/github/stars/spotter-application/spotter?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/spotter-application/spotter' alt='License'/>

  </p>
  </details>

- [sqlectron](https://github.com/sqlectron/sqlectron-gui) - A simple and lightweight SQL client desktop/terminal with cross database and platform support.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/sqlectron/sqlectron-gui/releases/latest'><img src='https://img.shields.io/github/v/release/sqlectron/sqlectron-gui?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sqlectron/sqlectron-gui'><img src='https://img.shields.io/github/stars/sqlectron/sqlectron-gui?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sqlectron/sqlectron-gui' alt='License'/>

  **Website:** [https://sqlectron.github.io/](https://sqlectron.github.io/)

  **Screenshots:**

  <img src='https://sqlectron.github.io/demos/sqlectron-demo-gui-v1.31.0.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [status-bar-todo](https://github.com/Onix-Systems/osx-status-bar-todo) - Simple macOS app to keep TODO-list in status bar. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Onix-Systems/osx-status-bar-todo/releases/latest'><img src='https://img.shields.io/github/v/release/Onix-Systems/osx-status-bar-todo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Onix-Systems/osx-status-bar-todo'><img src='https://img.shields.io/github/stars/Onix-Systems/osx-status-bar-todo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Onix-Systems/osx-status-bar-todo' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/1434418/21689532/52b0c1ba-d379-11e6-882a-b16d4f8fce00.png' width='400' loading='lazy'/>

  </p>
  </details>

- [StickyNotes](https://github.com/LumingYin/StickyNotes) - A Windows 10-esque Sticky Notes app implemented in AppKit.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/LumingYin/StickyNotes/releases/latest'><img src='https://img.shields.io/github/v/release/LumingYin/StickyNotes?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/LumingYin/StickyNotes'><img src='https://img.shields.io/github/stars/LumingYin/StickyNotes?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/LumingYin/StickyNotes' alt='License'/>

  **Website:** [https://github.com/LumingYin/StickyNotes/releases](https://github.com/LumingYin/StickyNotes/releases)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/LumingYin/StickyNotes/master/images/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Strategr](https://github.com/khrykin/StrategrDesktop) - No-fuss time management.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/khrykin/StrategrDesktop/releases/latest'><img src='https://img.shields.io/github/v/release/khrykin/StrategrDesktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/khrykin/StrategrDesktop'><img src='https://img.shields.io/github/stars/khrykin/StrategrDesktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/khrykin/StrategrDesktop' alt='License'/>

  **Website:** [https://khrykin.github.io/StrategrDesktop/](https://khrykin.github.io/StrategrDesktop/)

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/0aab0a8a9be68c3f98628a5c7dc2a09da176ea7a/68747470733a2f2f6b6872796b696e2e6769746875622e696f2f73747261746567722f7265736f75726365732f6d61635f6d61696e5f6f726967696e616c2e706e67' width='400' loading='lazy'/>

  <img src='https://camo.githubusercontent.com/1e9cc6df1bafd86c7f619cca3d4b3c30f9917398/68747470733a2f2f6b6872796b696e2e6769746875622e696f2f73747261746567722f7265736f75726365732f6d61635f626c61636b5f6d61696e2e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [stretchly](https://github.com/hovancik/stretchly) - Cross-platform electron app that reminds you to take breaks when working with computer. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/hovancik/stretchly/releases/latest'><img src='https://img.shields.io/github/v/release/hovancik/stretchly?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hovancik/stretchly'><img src='https://img.shields.io/github/stars/hovancik/stretchly?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hovancik/stretchly' alt='License'/>

  </p>
  </details>

- [Super Productivity](https://github.com/johannesjo/super-productivity) - Free to do list & time tracker for programmers & designers with Jira integration.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/johannesjo/super-productivity/releases/latest'><img src='https://img.shields.io/github/v/release/johannesjo/super-productivity?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/johannesjo/super-productivity'><img src='https://img.shields.io/github/stars/johannesjo/super-productivity?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/johannesjo/super-productivity' alt='License'/>

  **Website:** [https://super-productivity.com](https://super-productivity.com)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/johannesjo/super-productivity/master/screens/screen_standard.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ThenGenerator](https://github.com/87kangsw/ThenGenerator) - Xcode Source Editor Extension for 'Then'

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/87kangsw/ThenGenerator/releases/latest'><img src='https://img.shields.io/github/v/release/87kangsw/ThenGenerator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/87kangsw/ThenGenerator'><img src='https://img.shields.io/github/stars/87kangsw/ThenGenerator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/87kangsw/ThenGenerator' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/87kangsw/ThenGenerator/main/.github/images/property.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Thyme](https://github.com/joaomoreno/thyme) - The task timer for OS X. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/joaomoreno/thyme/releases/latest'><img src='https://img.shields.io/github/v/release/joaomoreno/thyme?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/joaomoreno/thyme'><img src='https://img.shields.io/github/stars/joaomoreno/thyme?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/joaomoreno/thyme' alt='License'/>

  </p>
  </details>

- [Time to Leave](https://github.com/thamara/time-to-leave) - Log work hours and get notified when it's time to leave the office and start to live.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> <code>html</code> 

  **Links:** <a href='https://github.com/thamara/time-to-leave/releases/latest'><img src='https://img.shields.io/github/v/release/thamara/time-to-leave?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/thamara/time-to-leave'><img src='https://img.shields.io/github/stars/thamara/time-to-leave?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/thamara/time-to-leave' alt='License'/>

  **Website:** [https://timetoleave.app/](https://timetoleave.app/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/3754225/94519528-4e549900-0248-11eb-8872-b6fb2d47f43c.jpg' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/3754225/94762058-4e79a380-03c4-11eb-8f28-1c480dbf8b5c.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Timer](https://github.com/michaelvillar/timer-app) - Simple Timer app for Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/michaelvillar/timer-app/releases/latest'><img src='https://img.shields.io/github/v/release/michaelvillar/timer-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/michaelvillar/timer-app'><img src='https://img.shields.io/github/stars/michaelvillar/timer-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/michaelvillar/timer-app' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/michaelvillar/timer-app/master/screenshots/light-mode.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/michaelvillar/timer-app/master/screenshots/dark-mode.png' width='400' loading='lazy'/>

  </p>
  </details>

- [TimeScribe](https://github.com/WINBIGFOX/timescribe) - Simple and free working time recording.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/WINBIGFOX/timescribe/releases/latest'><img src='https://img.shields.io/github/v/release/WINBIGFOX/timescribe?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/WINBIGFOX/timescribe'><img src='https://img.shields.io/github/stars/WINBIGFOX/timescribe?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/WINBIGFOX/timescribe' alt='License'/>

  **Website:** [https://timescribe.app](https://timescribe.app)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/WINBIGFOX/timescribe/refs/heads/main/.github/images/menubar_light.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/WINBIGFOX/timescribe/refs/heads/main/.github/images/dayview_en_light.webp' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/WINBIGFOX/timescribe/refs/heads/main/.github/images/app_activity_en_light.webp' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [Toggl Desktop](https://github.com/toggl-open-source/toggldesktop) - Toggl Desktop app for Windows, Mac and Linux. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/toggl-open-source/toggldesktop/releases/latest'><img src='https://img.shields.io/github/v/release/toggl-open-source/toggldesktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/toggl-open-source/toggldesktop'><img src='https://img.shields.io/github/stars/toggl-open-source/toggldesktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/toggl-open-source/toggldesktop' alt='License'/>

  </p>
  </details>

- [TomatoBar](https://github.com/ivoronin/TomatoBar) - Pomodoro Technique Timer for macOS with Touch Bar support.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ivoronin/TomatoBar/releases/latest'><img src='https://img.shields.io/github/v/release/ivoronin/TomatoBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ivoronin/TomatoBar'><img src='https://img.shields.io/github/stars/ivoronin/TomatoBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ivoronin/TomatoBar' alt='License'/>

  </p>
  </details>

- [TrelloApp](https://github.com/jlong/TrelloApp) - Unofficial wrapper application for Trello.com written in Swift. This is almost a "Hello World" for a site specific browser. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/jlong/TrelloApp/releases/latest'><img src='https://img.shields.io/github/v/release/jlong/TrelloApp?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jlong/TrelloApp'><img src='https://img.shields.io/github/stars/jlong/TrelloApp?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jlong/TrelloApp' alt='License'/>

  </p>
  </details>

- [Ueli](https://github.com/oliverschwendener/ueli) - A keystroke launcher for macOS (and Windows) like Spotlight or Alfred.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/oliverschwendener/ueli/releases/latest'><img src='https://img.shields.io/github/v/release/oliverschwendener/ueli?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/oliverschwendener/ueli'><img src='https://img.shields.io/github/stars/oliverschwendener/ueli?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/oliverschwendener/ueli' alt='License'/>

  **Website:** [https://ueli.app/](https://ueli.app/)

  **Screenshots:**

  <img src='https://github.com/oliverschwendener/ueli/blob/dev/assets/feature-simple-folder-search.png?raw=true' width='400' loading='lazy'/>

  </p>
  </details>

- [Ultra TabSaver](https://github.com/Swift-open-source/UltraTabSaver) - Ultra TabSaver is an open-source Tab Manager for Safari

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Swift-open-source/UltraTabSaver/releases/latest'><img src='https://img.shields.io/github/v/release/Swift-open-source/UltraTabSaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Swift-open-source/UltraTabSaver'><img src='https://img.shields.io/github/stars/Swift-open-source/UltraTabSaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Swift-open-source/UltraTabSaver' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Swift-open-source/UltraTabSaver/main/Ultra-TabSaver.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Watson](https://github.com/TailorDev/Watson) - A CLI application for time tracking. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/TailorDev/Watson/releases/latest'><img src='https://img.shields.io/github/v/release/TailorDev/Watson?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/TailorDev/Watson'><img src='https://img.shields.io/github/stars/TailorDev/Watson?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/TailorDev/Watson' alt='License'/>

  **Screenshots:**

  <img src='https://tailordev.github.io/Watson/img/logo-watson-600px.png' width='400' loading='lazy'/>

  <img src='https://tailordev.github.io/Watson/img/watson-demo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Whale](https://github.com/1000ch/whale) - Unofficial Trello app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/1000ch/whale/releases/latest'><img src='https://img.shields.io/github/v/release/1000ch/whale?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/1000ch/whale'><img src='https://img.shields.io/github/stars/1000ch/whale?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/1000ch/whale' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/1000ch/whale/master/demo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Yomu](https://github.com/sendyhalim/Yomu) - Manga reader app for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sendyhalim/Yomu/releases/latest'><img src='https://img.shields.io/github/v/release/sendyhalim/Yomu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sendyhalim/Yomu'><img src='https://img.shields.io/github/stars/sendyhalim/Yomu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sendyhalim/Yomu' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="screensaver"></a>
### 🌙 Screensaver (10)
- [Aerial](https://github.com/JohnCoates/Aerial) - Apple TV Aerial Screensaver for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/JohnCoates/Aerial/releases/latest'><img src='https://img.shields.io/github/v/release/JohnCoates/Aerial?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/JohnCoates/Aerial'><img src='https://img.shields.io/github/stars/JohnCoates/Aerial?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/JohnCoates/Aerial' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/37544189/47649972-1f76a980-db7f-11e8-910b-1d5d50931ae2.png' width='400' loading='lazy'/>

  <img src='https://cloud.githubusercontent.com/assets/499192/10754100/c0e1cc4c-7c95-11e5-9d3b-842d3acc2fd5.gif' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/37544189/47649971-1f76a980-db7f-11e8-97be-d1f90b943c9d.png' width='400' loading='lazy'/>

  *(3 more screenshots available in the repository)*

  </p>
  </details>

- [Brooklyn](https://github.com/pedrommcarrasco/Brooklyn) - Screensaver inspired by Apple's Event on October 30, 2018. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/pedrommcarrasco/Brooklyn/releases/latest'><img src='https://img.shields.io/github/v/release/pedrommcarrasco/Brooklyn?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pedrommcarrasco/Brooklyn'><img src='https://img.shields.io/github/stars/pedrommcarrasco/Brooklyn?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pedrommcarrasco/Brooklyn' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/pedrommcarrasco/Brooklyn/master/Design/showcase.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/pedrommcarrasco/Brooklyn/master/Design/preferenceMenu.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Epoch Flip Clock Screensaver](https://github.com/chrstphrknwtn/epoch-flip-clock-screensaver) - Unix epoch timestamp flip clock screensaver.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/chrstphrknwtn/epoch-flip-clock-screensaver/releases/latest'><img src='https://img.shields.io/github/v/release/chrstphrknwtn/epoch-flip-clock-screensaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/chrstphrknwtn/epoch-flip-clock-screensaver'><img src='https://img.shields.io/github/stars/chrstphrknwtn/epoch-flip-clock-screensaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/chrstphrknwtn/epoch-flip-clock-screensaver' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/chrstphrknwtn/epoch-flip-clock/master/epochFlipClock.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Image-As-Wallpaper](https://github.com/ved62/Image-As-Wallpaper) - Utility application helps with selection of images for using as desktop wallpaper or in screensaver on Mac computers. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ved62/Image-As-Wallpaper/releases/latest'><img src='https://img.shields.io/github/v/release/ved62/Image-As-Wallpaper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ved62/Image-As-Wallpaper'><img src='https://img.shields.io/github/stars/ved62/Image-As-Wallpaper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ved62/Image-As-Wallpaper' alt='License'/>

  </p>
  </details>

- [Irvue](https://github.com/leonspok/Irvue-Screensaver) - Screensaver for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/leonspok/Irvue-Screensaver/releases/latest'><img src='https://img.shields.io/github/v/release/leonspok/Irvue-Screensaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/leonspok/Irvue-Screensaver'><img src='https://img.shields.io/github/stars/leonspok/Irvue-Screensaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/leonspok/Irvue-Screensaver' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/leonspok/Irvue-Screensaver/master/README_resources/2.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/leonspok/Irvue-Screensaver/master/README_resources/1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/leonspok/Irvue-Screensaver/master/README_resources/3.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Life Saver](https://github.com/amiantos/lifesaver) - An abstract screensaver based on Conway's Game of Life implemented with SpriteKit

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/amiantos/lifesaver/releases/latest'><img src='https://img.shields.io/github/v/release/amiantos/lifesaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/amiantos/lifesaver'><img src='https://img.shields.io/github/stars/amiantos/lifesaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/amiantos/lifesaver' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/amiantos/lifesaver/master/Design/screensaver/lifesaver-screenshots-1.1.png' width='400' loading='lazy'/>

  <img src='https://github.com/amiantos/lifesaver/blob/master/Design/tvos/tvos-ss-1.png' width='400' loading='lazy'/>

  <img src='https://github.com/amiantos/lifesaver/blob/master/Design/tvos/tvos-ss-2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MinimalClock](https://github.com/mattiarossini/MinimalClock) - Simple and elegant screensaver that displays the time.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mattiarossini/MinimalClock/releases/latest'><img src='https://img.shields.io/github/v/release/mattiarossini/MinimalClock?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mattiarossini/MinimalClock'><img src='https://img.shields.io/github/stars/mattiarossini/MinimalClock?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mattiarossini/MinimalClock' alt='License'/>

  **Website:** [https://mattiarossini.github.io/MinimalClock/](https://mattiarossini.github.io/MinimalClock/)

  **Screenshots:**

  <img src='https://github.com/mattiarossini/MinimalClock/blob/master/Screenshot.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [MusaicFM](https://github.com/obrhoff/MusaicFM) - iTunes Screensaver Clone for Spotify and Last.fm 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/obrhoff/MusaicFM/releases/latest'><img src='https://img.shields.io/github/v/release/obrhoff/MusaicFM?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/obrhoff/MusaicFM'><img src='https://img.shields.io/github/stars/obrhoff/MusaicFM?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/obrhoff/MusaicFM' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/OuF5nOe.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Predator](https://github.com/vpeschenkov/Predator) - A predator-inspired clock screensaver for macOS

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/vpeschenkov/Predator/releases/latest'><img src='https://img.shields.io/github/v/release/vpeschenkov/Predator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vpeschenkov/Predator'><img src='https://img.shields.io/github/stars/vpeschenkov/Predator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vpeschenkov/Predator' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/vpeschenkov/Predator/master/assets/preview.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/vpeschenkov/Predator/master/assets/settings.png' width='400' loading='lazy'/>

  </p>
  </details>

- [The GitHub Matrix Screensaver](https://github.com/winterbe/github-matrix-screensaver) - The GitHub Matrix Screensaver for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/winterbe/github-matrix-screensaver/releases/latest'><img src='https://img.shields.io/github/v/release/winterbe/github-matrix-screensaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/winterbe/github-matrix-screensaver'><img src='https://img.shields.io/github/stars/winterbe/github-matrix-screensaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/winterbe/github-matrix-screensaver' alt='License'/>

  **Screenshots:**

  <img src='https://winterbe.com/image/matrix-has-you.gif' width='400' loading='lazy'/>

  <img src='https://winterbe.com/image/matrix.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="security"></a>
### 🔒 Security (9)
- [Cloaker](https://github.com/spieglt/cloaker) - simple drag-and-drop, password-based file encryption.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/spieglt/cloaker/releases/latest'><img src='https://img.shields.io/github/v/release/spieglt/cloaker?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/spieglt/cloaker'><img src='https://img.shields.io/github/stars/spieglt/cloaker?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/spieglt/cloaker' alt='License'/>

  **Website:** [https://adequate.systems/](https://adequate.systems/)

  **Screenshots:**

  <img src='https://github.com/spieglt/Cloaker/blob/master/demo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Cryptomator](https://github.com/cryptomator/cryptomator) - Multi-platform transparent client-side encryption of your files in the cloud.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/java-16.png' alt='Java icon' title='Java' height='16'/> 

  **Links:** <a href='https://github.com/cryptomator/cryptomator/releases/latest'><img src='https://img.shields.io/github/v/release/cryptomator/cryptomator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/cryptomator/cryptomator'><img src='https://img.shields.io/github/stars/cryptomator/cryptomator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/cryptomator/cryptomator' alt='License'/>

  **Website:** [https://cryptomator.org/](https://cryptomator.org/)

  </p>
  </details>

- [LuLu](https://github.com/objective-see/LuLu) - LuLu is macOS firewall application that aims to block unauthorized (outgoing) network traffic. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/objective-see/LuLu/releases/latest'><img src='https://img.shields.io/github/v/release/objective-see/LuLu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/objective-see/LuLu'><img src='https://img.shields.io/github/stars/objective-see/LuLu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/objective-see/LuLu' alt='License'/>

  </p>
  </details>

- [macOS GateKeeper Helper](https://github.com/wynioux/macOS-GateKeeper-Helper) - Simple macOS GateKeeper script. It helps you to control your GateKeeper.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/shell-16.png' alt='Shell icon' title='Shell' height='16'/> 

  **Links:** <a href='https://github.com/wynioux/macOS-GateKeeper-Helper/releases/latest'><img src='https://img.shields.io/github/v/release/wynioux/macOS-GateKeeper-Helper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wynioux/macOS-GateKeeper-Helper'><img src='https://img.shields.io/github/stars/wynioux/macOS-GateKeeper-Helper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wynioux/macOS-GateKeeper-Helper' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wynioux/macOS-GateKeeper-Helper/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Pareto Security](https://github.com/paretoSecurity/pareto-mac/) - A MenuBar app to automatically audit your Mac for basic security hygiene.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/paretoSecurity/pareto-mac/releases/latest'><img src='https://img.shields.io/github/v/release/paretoSecurity/pareto-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/paretoSecurity/pareto-mac/'><img src='https://img.shields.io/github/stars/paretoSecurity/pareto-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/paretoSecurity/pareto-mac' alt='License'/>

  **Website:** [https://paretosecurity.com/](https://paretosecurity.com/)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/239513/126497099-1b89a8ef-68f2-4aae-9f05-f124748685d2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Privacy Redirect for Safari](https://github.com/smmr-software/privacy-redirect-safari) - Redirect Twitter, YouTube, Reddit, Google Maps, Google Search, and Google Translate to privacy friendly alternatives.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/smmr-software/privacy-redirect-safari/releases/latest'><img src='https://img.shields.io/github/v/release/smmr-software/privacy-redirect-safari?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/smmr-software/privacy-redirect-safari'><img src='https://img.shields.io/github/stars/smmr-software/privacy-redirect-safari?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/smmr-software/privacy-redirect-safari' alt='License'/>

  </p>
  </details>

- [stronghold](https://github.com/alichtman/stronghold) - Easily configure macOS security settings from the terminal. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/alichtman/stronghold/releases/latest'><img src='https://img.shields.io/github/v/release/alichtman/stronghold?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alichtman/stronghold'><img src='https://img.shields.io/github/stars/alichtman/stronghold?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alichtman/stronghold' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/alichtman/stronghold/master/img/stronghold-logo-left.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/alichtman/stronghold/master/img/demo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Swifty](https://github.com/swiftyapp/swifty) - Free and offline password manager. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/swiftyapp/swifty/releases/latest'><img src='https://img.shields.io/github/v/release/swiftyapp/swifty?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/swiftyapp/swifty'><img src='https://img.shields.io/github/stars/swiftyapp/swifty?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/swiftyapp/swifty' alt='License'/>

  **Website:** [https://getswifty.pro](https://getswifty.pro)

  **Screenshots:**

  <img src='https://alchaplinsky.com/images/misc/swifty_screen_01.png' width='400' loading='lazy'/>

  <img src='https://alchaplinsky.com/images/misc/swifty_screen_02.png' width='400' loading='lazy'/>

  </p>
  </details>

- [VeraCrypt](https://github.com/veracrypt/VeraCrypt) - Disk encryption with strong security based on TrueCrypt. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/veracrypt/VeraCrypt/releases/latest'><img src='https://img.shields.io/github/v/release/veracrypt/VeraCrypt?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/veracrypt/VeraCrypt'><img src='https://img.shields.io/github/stars/veracrypt/VeraCrypt?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/veracrypt/VeraCrypt' alt='License'/>

  **Website:** [https://www.veracrypt.fr](https://www.veracrypt.fr)

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="sharing-files"></a>
### 📤 Sharing Files (9)
- [Cyberduck](https://github.com/iterate-ch/cyberduck) - Cyberduck is a libre server and cloud storage browser for Mac and Windows with support for FTP, SFTP, WebDAV, Amazon S3, OpenStack Swift, Backblaze B2, Microsoft Azure & OneDrive, Google Drive and Dropbox.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/java-16.png' alt='Java icon' title='Java' height='16'/> 

  **Links:** <a href='https://github.com/iterate-ch/cyberduck/releases/latest'><img src='https://img.shields.io/github/v/release/iterate-ch/cyberduck?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/iterate-ch/cyberduck'><img src='https://img.shields.io/github/stars/iterate-ch/cyberduck?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/iterate-ch/cyberduck' alt='License'/>

  **Website:** [https://cyberduck.io](https://cyberduck.io)

  **Screenshots:**

  <img src='https://cdn.cyberduck.io/img/mac/browser-bookmarks.png' width='400' loading='lazy'/>

  <img src='https://cdn.cyberduck.io/img/mac/browser.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Deluge](https://github.com/deluge-torrent/deluge) - Lightweight cross-platform BitTorrent client. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/deluge-torrent/deluge/releases/latest'><img src='https://img.shields.io/github/v/release/deluge-torrent/deluge?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/deluge-torrent/deluge'><img src='https://img.shields.io/github/stars/deluge-torrent/deluge?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/deluge-torrent/deluge' alt='License'/>

  </p>
  </details>

- [mac2imgur](https://github.com/mileswd/mac2imgur) - Simple Mac app designed to make uploading images and screenshots to Imgur quick and effortless. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mileswd/mac2imgur/releases/latest'><img src='https://img.shields.io/github/v/release/mileswd/mac2imgur?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mileswd/mac2imgur'><img src='https://img.shields.io/github/stars/mileswd/mac2imgur?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mileswd/mac2imgur' alt='License'/>

  </p>
  </details>

- [NitroShare](https://github.com/nitroshare/nitroshare-desktop) - Transferring files from one device to another

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/nitroshare/nitroshare-desktop/releases/latest'><img src='https://img.shields.io/github/v/release/nitroshare/nitroshare-desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nitroshare/nitroshare-desktop'><img src='https://img.shields.io/github/stars/nitroshare/nitroshare-desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nitroshare/nitroshare-desktop' alt='License'/>

  **Website:** [https://nitroshare.net](https://nitroshare.net)

  </p>
  </details>

- [qBittorrent](https://github.com/qbittorrent/qBittorrent) - BitTorrent client in Qt. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/qbittorrent/qBittorrent/releases/latest'><img src='https://img.shields.io/github/v/release/qbittorrent/qBittorrent?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/qbittorrent/qBittorrent'><img src='https://img.shields.io/github/stars/qbittorrent/qBittorrent?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/qbittorrent/qBittorrent' alt='License'/>

  </p>
  </details>

- [Rhea](https://github.com/timonus/Rhea) - macOS status bar app for quickly sharing files and URLs. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/timonus/Rhea/releases/latest'><img src='https://img.shields.io/github/v/release/timonus/Rhea?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/timonus/Rhea'><img src='https://img.shields.io/github/stars/timonus/Rhea?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/timonus/Rhea' alt='License'/>

  </p>
  </details>

- [Soduto](https://github.com/soduto/Soduto) - Soduto is a KDEConnect compatible application for macOS. It gives AirDrop like integration and allows file and clipboard sharing between your phones, desktops and tablets.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/soduto/Soduto/releases/latest'><img src='https://img.shields.io/github/v/release/soduto/Soduto?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/soduto/Soduto'><img src='https://img.shields.io/github/stars/soduto/Soduto?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/soduto/Soduto' alt='License'/>

  **Website:** [https://soduto.com/](https://soduto.com/)

  </p>
  </details>

- [Transmission](https://github.com/transmission/transmission) - Official Transmission BitTorrent client repository.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/transmission/transmission/releases/latest'><img src='https://img.shields.io/github/v/release/transmission/transmission?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/transmission/transmission'><img src='https://img.shields.io/github/stars/transmission/transmission?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/transmission/transmission' alt='License'/>

  </p>
  </details>

- [Tribler](https://github.com/Tribler/tribler) - Privacy enhanced BitTorrent client with P2P content discovery. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/Tribler/tribler/releases/latest'><img src='https://img.shields.io/github/v/release/Tribler/tribler?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Tribler/tribler'><img src='https://img.shields.io/github/stars/Tribler/tribler?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Tribler/tribler' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="social-networking"></a>
### 👥 Social Networking (9)
- [Caprine](https://github.com/sindresorhus/caprine#features) - Elegant Facebook Messenger desktop app.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/sindresorhus/caprine#features/releases/latest'><img src='https://img.shields.io/github/v/release/sindresorhus/caprine#features?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sindresorhus/caprine#features'><img src='https://img.shields.io/github/stars/sindresorhus/caprine#features?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sindresorhus/caprine#features' alt='License'/>

  </p>
  </details>

- [Goofy](https://github.com/danielbuechele/goofy) - Unofficial Facebook Messenger client. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/danielbuechele/goofy/releases/latest'><img src='https://img.shields.io/github/v/release/danielbuechele/goofy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/danielbuechele/goofy'><img src='https://img.shields.io/github/stars/danielbuechele/goofy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/danielbuechele/goofy' alt='License'/>

  </p>
  </details>

- [Leviathan](https://github.com/Swiftodon/Leviathan) - Leviathan is a iOS and macOS client application for the Mastodon social network. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Swiftodon/Leviathan/releases/latest'><img src='https://img.shields.io/github/v/release/Swiftodon/Leviathan?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Swiftodon/Leviathan'><img src='https://img.shields.io/github/stars/Swiftodon/Leviathan?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Swiftodon/Leviathan' alt='License'/>

  </p>
  </details>

- [Messenger](https://github.com/rsms/fb-mac-messenger) - macOS app wrapping Facebook's Messenger for desktop. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/rsms/fb-mac-messenger/releases/latest'><img src='https://img.shields.io/github/v/release/rsms/fb-mac-messenger?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/rsms/fb-mac-messenger'><img src='https://img.shields.io/github/stars/rsms/fb-mac-messenger?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/rsms/fb-mac-messenger' alt='License'/>

  **Screenshots:**

  <img src='https://fbmacmessenger.rsms.me/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Product Hunt](https://github.com/producthunt/producthunt-osx) - share and discover your favorite new products and applications. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/producthunt/producthunt-osx/releases/latest'><img src='https://img.shields.io/github/v/release/producthunt/producthunt-osx?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/producthunt/producthunt-osx'><img src='https://img.shields.io/github/stars/producthunt/producthunt-osx?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/producthunt/producthunt-osx' alt='License'/>

  </p>
  </details>

- [Quail](https://github.com/1000ch/quail) - Unofficial [esa](https://esa.io) app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/1000ch/quail/releases/latest'><img src='https://img.shields.io/github/v/release/1000ch/quail?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/1000ch/quail'><img src='https://img.shields.io/github/stars/1000ch/quail?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/1000ch/quail' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/1000ch/quail/master/demo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Ramme](https://github.com/terkelg/ramme) - Unofficial Instagram Desktop App.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/terkelg/ramme/releases/latest'><img src='https://img.shields.io/github/v/release/terkelg/ramme?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/terkelg/ramme'><img src='https://img.shields.io/github/stars/terkelg/ramme?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/terkelg/ramme' alt='License'/>

  </p>
  </details>

- [RedditOS](https://github.com/Dimillian/RedditOS) - A SwiftUI Reddit client for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Dimillian/RedditOS/releases/latest'><img src='https://img.shields.io/github/v/release/Dimillian/RedditOS?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Dimillian/RedditOS'><img src='https://img.shields.io/github/stars/Dimillian/RedditOS?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Dimillian/RedditOS' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Dimillian/RedditOS/master/Images/image1.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Simpo](https://github.com/KeliCheng/Simpo) - macOS menubar app to post status quickly. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/KeliCheng/Simpo/releases/latest'><img src='https://img.shields.io/github/v/release/KeliCheng/Simpo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/KeliCheng/Simpo'><img src='https://img.shields.io/github/stars/KeliCheng/Simpo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/KeliCheng/Simpo' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/KeliCheng/Simpo/master/preview.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/KeliCheng/Simpo/master/donate.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="streaming"></a>
### 📡 Streaming (3)
- [Galeri](https://github.com/michealparks/galeri) - Perpetual artwork streaming app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/michealparks/galeri/releases/latest'><img src='https://img.shields.io/github/v/release/michealparks/galeri?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/michealparks/galeri'><img src='https://img.shields.io/github/stars/michealparks/galeri?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/michealparks/galeri' alt='License'/>

  </p>
  </details>

- [OBS Studio](https://github.com/obsproject/obs-studio) - Free and open source software for live streaming and screen recording. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/obsproject/obs-studio/releases/latest'><img src='https://img.shields.io/github/v/release/obsproject/obs-studio?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/obsproject/obs-studio'><img src='https://img.shields.io/github/stars/obsproject/obs-studio?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/obsproject/obs-studio' alt='License'/>

  **Website:** [https://obsproject.com/](https://obsproject.com/)

  </p>
  </details>

- [Plug](https://github.com/wulkano/Plug) - Discover and listen to music from Hype Machine.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/wulkano/Plug/releases/latest'><img src='https://img.shields.io/github/v/release/wulkano/Plug?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wulkano/Plug'><img src='https://img.shields.io/github/stars/wulkano/Plug?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wulkano/Plug' alt='License'/>

  **Website:** [https://www.plugformac.com/](https://www.plugformac.com/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wulkano/Plug/1ae6383ad9ad7026ce6fad4f1ea7ce3356c1f722/Media/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="system"></a>
### ⚙️ System (23)
- [Apple Juice](https://github.com/raphaelhanneken/apple-juice) - Advanced battery gauge for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/raphaelhanneken/apple-juice/releases/latest'><img src='https://img.shields.io/github/v/release/raphaelhanneken/apple-juice?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/raphaelhanneken/apple-juice'><img src='https://img.shields.io/github/stars/raphaelhanneken/apple-juice?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/raphaelhanneken/apple-juice' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/raphaelhanneken/apple-juice/master/screenshot_today.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/raphaelhanneken/apple-juice/master/screenshot_appmenu.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/raphaelhanneken/apple-juice/master/screenshot_notifications.png' width='400' loading='lazy'/>

  </p>
  </details>

- [AppPolice](https://github.com/AppPolice/AppPolice) - App for macOS with a minimalistic UI which lets you quickly throttle down the CPU usage of any running process. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/AppPolice/AppPolice/releases/latest'><img src='https://img.shields.io/github/v/release/AppPolice/AppPolice?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AppPolice/AppPolice'><img src='https://img.shields.io/github/stars/AppPolice/AppPolice?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AppPolice/AppPolice' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/1557716/12860558/11908a78-cc66-11e5-9998-b4bec11dbfeb.png' width='400' loading='lazy'/>

  <img src='https://cloud.githubusercontent.com/assets/1557716/12860551/ffff72d8-cc65-11e5-9304-4f1341657b5a.png' width='400' loading='lazy'/>

  <img src='https://cloud.githubusercontent.com/assets/1557716/12860559/1193fe42-cc66-11e5-9d4f-8b8af842ea72.png' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [Clean-Me](https://github.com/Kevin-De-Koninck/Clean-Me) - Small macOS app that acts as a system cleaner (logs, cache, ...). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Kevin-De-Koninck/Clean-Me/releases/latest'><img src='https://img.shields.io/github/v/release/Kevin-De-Koninck/Clean-Me?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Kevin-De-Koninck/Clean-Me'><img src='https://img.shields.io/github/stars/Kevin-De-Koninck/Clean-Me?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Kevin-De-Koninck/Clean-Me' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Kevin-De-Koninck/Clean-Me/master/resources/Cleam-Me-image1.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/Kevin-De-Koninck/Clean-Me/master/resources/Cleam-Me-image2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Diagnostics](https://github.com/macmade/Diagnostics) - Diagnostics is an application displaying the diagnostic reports from applications on macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/macmade/Diagnostics/releases/latest'><img src='https://img.shields.io/github/v/release/macmade/Diagnostics?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/macmade/Diagnostics'><img src='https://img.shields.io/github/stars/macmade/Diagnostics?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/macmade/Diagnostics' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/macmade/Diagnostics/master/Resources/Screen.png' width='400' loading='lazy'/>

  </p>
  </details>

- [DisableMonitor](https://github.com/Eun/DisableMonitor) - Easily disable or enable a monitor on your Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Eun/DisableMonitor/releases/latest'><img src='https://img.shields.io/github/v/release/Eun/DisableMonitor?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Eun/DisableMonitor'><img src='https://img.shields.io/github/stars/Eun/DisableMonitor?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Eun/DisableMonitor' alt='License'/>

  </p>
  </details>

- [eul](https://github.com/gao-sun/eul) - macOS status monitoring app written in SwiftUI.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/gao-sun/eul/releases/latest'><img src='https://img.shields.io/github/v/release/gao-sun/eul?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gao-sun/eul'><img src='https://img.shields.io/github/stars/gao-sun/eul?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gao-sun/eul' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/14722250/105626766-f718ab00-5e6c-11eb-9761-661ff85c8faf.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Fanny](https://github.com/DanielStormApps/Fanny) - Monitor your Mac's fan speed and CPU temperature from your Notification Center. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/DanielStormApps/Fanny/releases/latest'><img src='https://img.shields.io/github/v/release/DanielStormApps/Fanny?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/DanielStormApps/Fanny'><img src='https://img.shields.io/github/stars/DanielStormApps/Fanny?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/DanielStormApps/Fanny' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/10573489/26471886/ac78360e-4171-11e7-8b89-1e27fe6a582e.png' width='400' loading='lazy'/>

  </p>
  </details>

- [HoRNDIS](https://github.com/jwise/HoRNDIS) - Android USB tethering driver for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/jwise/HoRNDIS/releases/latest'><img src='https://img.shields.io/github/v/release/jwise/HoRNDIS?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jwise/HoRNDIS'><img src='https://img.shields.io/github/stars/jwise/HoRNDIS?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jwise/HoRNDIS' alt='License'/>

  </p>
  </details>

- [Juice](https://github.com/brianmichel/Juice) - Make your battery information a bit more interesting. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/brianmichel/Juice/releases/latest'><img src='https://img.shields.io/github/v/release/brianmichel/Juice?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/brianmichel/Juice'><img src='https://img.shields.io/github/stars/brianmichel/Juice?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/brianmichel/Juice' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/brianmichel/Juice/master/images/cyle-post.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/brianmichel/Juice/master/images/icon-readme.png' width='400' loading='lazy'/>

  </p>
  </details>

- [KeepingYouAwake](https://github.com/newmarcel/KeepingYouAwake) - Prevents your Mac from going to sleep. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/newmarcel/KeepingYouAwake/releases/latest'><img src='https://img.shields.io/github/v/release/newmarcel/KeepingYouAwake?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/newmarcel/KeepingYouAwake'><img src='https://img.shields.io/github/stars/newmarcel/KeepingYouAwake?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/newmarcel/KeepingYouAwake' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/newmarcel/KeepingYouAwake/master/Extras/Screenshot@2x.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Latest](https://github.com/mangerlahn/Latest) - Small utility app for macOS that makes sure you know about all the latest updates to the apps you use. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mangerlahn/Latest/releases/latest'><img src='https://img.shields.io/github/v/release/mangerlahn/Latest?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mangerlahn/Latest'><img src='https://img.shields.io/github/stars/mangerlahn/Latest?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mangerlahn/Latest' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mangerlahn/Latest/master/latest.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Loading](https://github.com/BonzaiThePenguin/Loading) - Simple network activity monitor for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/BonzaiThePenguin/Loading/releases/latest'><img src='https://img.shields.io/github/v/release/BonzaiThePenguin/Loading?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/BonzaiThePenguin/Loading'><img src='https://img.shields.io/github/stars/BonzaiThePenguin/Loading?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/BonzaiThePenguin/Loading' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/BonzaiThePenguin/Loading/master/README/en.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [macOS GateKeeper Helper](https://github.com/wynioux/macOS-GateKeeper-Helper) - Simple macOS GateKeeper script. It helps you to control your GateKeeper.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/shell-16.png' alt='Shell icon' title='Shell' height='16'/> 

  **Links:** <a href='https://github.com/wynioux/macOS-GateKeeper-Helper/releases/latest'><img src='https://img.shields.io/github/v/release/wynioux/macOS-GateKeeper-Helper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wynioux/macOS-GateKeeper-Helper'><img src='https://img.shields.io/github/stars/wynioux/macOS-GateKeeper-Helper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wynioux/macOS-GateKeeper-Helper' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wynioux/macOS-GateKeeper-Helper/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [macOSLucidaGrande](https://github.com/LumingYin/macOSLucidaGrande) - A small utility to set Lucida Grande as your Mac's system UI font.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/LumingYin/macOSLucidaGrande/releases/latest'><img src='https://img.shields.io/github/v/release/LumingYin/macOSLucidaGrande?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/LumingYin/macOSLucidaGrande'><img src='https://img.shields.io/github/stars/LumingYin/macOSLucidaGrande?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/LumingYin/macOSLucidaGrande' alt='License'/>

  **Website:** [https://github.com/LumingYin/macOSLucidaGrande/releases](https://github.com/LumingYin/macOSLucidaGrande/releases)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/LumingYin/macOSLucidaGrande/master/Screenshot/Screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Overkill](https://github.com/KrauseFx/overkill-for-mac) - Stop iTunes from opening when you connect your iPhone. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/KrauseFx/overkill-for-mac/releases/latest'><img src='https://img.shields.io/github/v/release/KrauseFx/overkill-for-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/KrauseFx/overkill-for-mac'><img src='https://img.shields.io/github/stars/KrauseFx/overkill-for-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/KrauseFx/overkill-for-mac' alt='License'/>

  </p>
  </details>

- [ProfileCreator](https://github.com/ProfileCreator/ProfileCreator) - macOS Application to create standard or customized configuration profiles. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/ProfileCreator/ProfileCreator/releases/latest'><img src='https://img.shields.io/github/v/release/ProfileCreator/ProfileCreator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ProfileCreator/ProfileCreator'><img src='https://img.shields.io/github/stars/ProfileCreator/ProfileCreator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ProfileCreator/ProfileCreator' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/erikberglund/ProfileCreator/master/resources/screenshots/ProfileCreator.png' width='400' loading='lazy'/>

  </p>
  </details>

- [SlimHUD - Cyanocitta](https://github.com/AlexPerathoner/SlimHUD) - Replacement for MacOS' volume, brightness and keyboard backlight HUDs.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AlexPerathoner/SlimHUD/releases/latest'><img src='https://img.shields.io/github/v/release/AlexPerathoner/SlimHUD?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AlexPerathoner/SlimHUD'><img src='https://img.shields.io/github/stars/AlexPerathoner/SlimHUD?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AlexPerathoner/SlimHUD' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/AlexPerathoner/SlimHUD/master/Screens/Animations/animations.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/AlexPerathoner/SlimHUD/master/Screens/settingsWindow.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Sloth](https://github.com/sveinbjornt/Sloth) - Sloth is an macOS application that displays a list of all open files and sockets in use by all running applications on your system. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/sveinbjornt/Sloth/releases/latest'><img src='https://img.shields.io/github/v/release/sveinbjornt/Sloth?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sveinbjornt/Sloth'><img src='https://img.shields.io/github/stars/sveinbjornt/Sloth?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sveinbjornt/Sloth' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/sveinbjornt/Sloth/master/resources/sloth_icon.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sveinbjornt/Sloth/master/resources/sloth_screenshot1.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sveinbjornt/Sloth/master/resources/sloth_screenshot2.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Spotter](https://github.com/spotter-application/spotter) - Productivity tool, the main function is to search and launch external application actions and applications themselves, so you can stay focused on your current task. Kind of spotlight or alfred alternative.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/spotter-application/spotter/releases/latest'><img src='https://img.shields.io/github/v/release/spotter-application/spotter?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/spotter-application/spotter'><img src='https://img.shields.io/github/stars/spotter-application/spotter?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/spotter-application/spotter' alt='License'/>

  </p>
  </details>

- [Stats](https://github.com/exelban/stats) - macOS system monitor in your menu bar

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/exelban/stats/releases/latest'><img src='https://img.shields.io/github/v/release/exelban/stats?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/exelban/stats'><img src='https://img.shields.io/github/stars/exelban/stats?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/exelban/stats' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/0e25eeb8b466356b0bcd847d064da3084baa5aed9bf53fab3bad2f0f0fbd1ee9/68747470733a2f2f7365726869792e73332e65752d63656e7472616c2d312e616d617a6f6e6177732e636f6d2f4769746875625f7265706f2f73746174732f706f7075707325334676322e332e322e706e673f7633' width='400' loading='lazy'/>

  </p>
  </details>

- [Turbo Boost Switcher](https://github.com/rugarciap/Turbo-Boost-Switcher) - Turbo Boost Switcher is a little application for Mac computers that allows to enable and/or disable the Turbo Boost feature. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/rugarciap/Turbo-Boost-Switcher/releases/latest'><img src='https://img.shields.io/github/v/release/rugarciap/Turbo-Boost-Switcher?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/rugarciap/Turbo-Boost-Switcher'><img src='https://img.shields.io/github/stars/rugarciap/Turbo-Boost-Switcher?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/rugarciap/Turbo-Boost-Switcher' alt='License'/>

  </p>
  </details>

- [VerticalBar](https://github.com/DeromirNeves/DockSeparator) - macOS application to add a vertical bar to Dock. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/DeromirNeves/DockSeparator/releases/latest'><img src='https://img.shields.io/github/v/release/DeromirNeves/DockSeparator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/DeromirNeves/DockSeparator'><img src='https://img.shields.io/github/stars/DeromirNeves/DockSeparator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/DeromirNeves/DockSeparator' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/DeromirNeves/VerticalBar/master/img/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Wireshark](https://gitlab.com/wireshark/wireshark/-/tree/master) - Wireshark is the world’s foremost and widely-used network protocol analyzer. It lets you see what’s happening on your network at a microscopic level and is the de facto (and often de jure) standard across many commercial and non-profit enterprises, government agencies, and educational institutions.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <code>c++</code> 

  **Website:** [https://www.wireshark.org/](https://www.wireshark.org/)

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="terminal"></a>
### 📺 Terminal (13)
- [Alacritty](https://github.com/alacritty/alacritty) - Cross-platform, GPU-accelerated terminal emulator. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/alacritty/alacritty/releases/latest'><img src='https://img.shields.io/github/v/release/alacritty/alacritty?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alacritty/alacritty'><img src='https://img.shields.io/github/stars/alacritty/alacritty?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alacritty/alacritty' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/4285147/21585004/2ebd0288-d06c-11e6-95d3-4a2889dbbd6f.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Bifrost](https://github.com/ishuah/bifrost) - A tiny terminal emulator for serial port communication (macOS/Linux). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/golang-16.png' alt='Go icon' title='Go' height='16'/> 

  **Links:** <a href='https://github.com/ishuah/bifrost/releases/latest'><img src='https://img.shields.io/github/v/release/ishuah/bifrost?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ishuah/bifrost'><img src='https://img.shields.io/github/stars/ishuah/bifrost?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ishuah/bifrost' alt='License'/>

  </p>
  </details>

- [cd to... ](https://github.com/jbtule/cdto) - Finder Toolbar app to open the current directory in the Terminal

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/jbtule/cdto/releases/latest'><img src='https://img.shields.io/github/v/release/jbtule/cdto?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jbtule/cdto'><img src='https://img.shields.io/github/stars/jbtule/cdto?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jbtule/cdto' alt='License'/>

  </p>
  </details>

- [Console](https://github.com/macmade/Console) - macOS console application. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/macmade/Console/releases/latest'><img src='https://img.shields.io/github/v/release/macmade/Console?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/macmade/Console'><img src='https://img.shields.io/github/stars/macmade/Console?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/macmade/Console' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/macmade/Console/master/Assets/MainWindow.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Finder Go](https://github.com/onmyway133/FinderGo) - macOS app and Finder Sync Extension to open Terminal, iTerm, Hyper from Finder. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/onmyway133/FinderGo/releases/latest'><img src='https://img.shields.io/github/v/release/onmyway133/FinderGo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/onmyway133/FinderGo'><img src='https://img.shields.io/github/stars/onmyway133/FinderGo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/onmyway133/FinderGo' alt='License'/>

  </p>
  </details>

- [Hyper](https://github.com/vercel/hyper) - Terminal built on web technologies.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/vercel/hyper/releases/latest'><img src='https://img.shields.io/github/v/release/vercel/hyper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vercel/hyper'><img src='https://img.shields.io/github/stars/vercel/hyper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vercel/hyper' alt='License'/>

  **Screenshots:**

  <img src='https://assets.zeit.co/image/upload/v1537650716/repositories/hyper/hyper-repo-banner.png' width='400' loading='lazy'/>

  </p>
  </details>

- [iTerm 2](https://github.com/gnachman/iTerm2) - Terminal emulator for macOS that does amazing things. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/gnachman/iTerm2/releases/latest'><img src='https://img.shields.io/github/v/release/gnachman/iTerm2?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gnachman/iTerm2'><img src='https://img.shields.io/github/stars/gnachman/iTerm2?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gnachman/iTerm2' alt='License'/>

  </p>
  </details>

- [Kitty](https://github.com/kovidgoyal/kitty) - Cross-platform, fast, feature full, GPU based terminal emulator.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/kovidgoyal/kitty/releases/latest'><img src='https://img.shields.io/github/v/release/kovidgoyal/kitty?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kovidgoyal/kitty'><img src='https://img.shields.io/github/stars/kovidgoyal/kitty?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kovidgoyal/kitty' alt='License'/>

  </p>
  </details>

- [macOS GateKeeper Helper](https://github.com/wynioux/macOS-GateKeeper-Helper) - Simple macOS GateKeeper script. It helps you to control your GateKeeper.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/shell-16.png' alt='Shell icon' title='Shell' height='16'/> 

  **Links:** <a href='https://github.com/wynioux/macOS-GateKeeper-Helper/releases/latest'><img src='https://img.shields.io/github/v/release/wynioux/macOS-GateKeeper-Helper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wynioux/macOS-GateKeeper-Helper'><img src='https://img.shields.io/github/stars/wynioux/macOS-GateKeeper-Helper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wynioux/macOS-GateKeeper-Helper' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wynioux/macOS-GateKeeper-Helper/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [OpenInTerminal](https://github.com/Ji4n1ng/OpenInTerminal) - Finder Toolbar app for macOS to open the current directory in Terminal, iTerm, Hyper or Alacritty.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Ji4n1ng/OpenInTerminal/releases/latest'><img src='https://img.shields.io/github/v/release/Ji4n1ng/OpenInTerminal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Ji4n1ng/OpenInTerminal'><img src='https://img.shields.io/github/stars/Ji4n1ng/OpenInTerminal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Ji4n1ng/OpenInTerminal' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/11001224/78589385-b797b880-7872-11ea-9062-c11a49461598.gif' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/11001224/78589369-b36b9b00-7872-11ea-8a9e-e3f23e7ce80e.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [OpenTerminal](https://github.com/es-kumagai/OpenTerminal) - App for macOS that opens a new Finder window and changes the current directory to the folder launched by the app. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/es-kumagai/OpenTerminal/releases/latest'><img src='https://img.shields.io/github/v/release/es-kumagai/OpenTerminal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/es-kumagai/OpenTerminal'><img src='https://img.shields.io/github/stars/es-kumagai/OpenTerminal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/es-kumagai/OpenTerminal' alt='License'/>

  </p>
  </details>

- [wallpapper](https://github.com/mczachurski/wallpapper) - wallpapper is a console application for creating dynamic wallpapers for Mojave. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mczachurski/wallpapper/releases/latest'><img src='https://img.shields.io/github/v/release/mczachurski/wallpapper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mczachurski/wallpapper'><img src='https://img.shields.io/github/stars/mczachurski/wallpapper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mczachurski/wallpapper' alt='License'/>

  </p>
  </details>

- [zoxide](https://github.com/ajeetdsouza/zoxide) - zoxide is a smarter cd command for your terminal.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/ajeetdsouza/zoxide/releases/latest'><img src='https://img.shields.io/github/v/release/ajeetdsouza/zoxide?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ajeetdsouza/zoxide'><img src='https://img.shields.io/github/stars/ajeetdsouza/zoxide?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ajeetdsouza/zoxide' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ajeetdsouza/zoxide/c392a8bb75af098b3906ed66595e79f05af92d1a/contrib/tutorial.webp' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="touch-bar"></a>
### 🎚️ Touch Bar (6)
- [Muse](https://github.com/xzzz9097/Muse) - Spotify controller with TouchBar support. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/xzzz9097/Muse/releases/latest'><img src='https://img.shields.io/github/v/release/xzzz9097/Muse?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/xzzz9097/Muse'><img src='https://img.shields.io/github/stars/xzzz9097/Muse?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/xzzz9097/Muse' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/xzzz9097/Muse/master/Screenshots/Window2.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MyTouchbarMyRules](https://github.com/toxblh/MTMR) - App to customize your Touch Bar as you want. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/toxblh/MTMR/releases/latest'><img src='https://img.shields.io/github/v/release/toxblh/MTMR?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/toxblh/MTMR'><img src='https://img.shields.io/github/stars/toxblh/MTMR?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/toxblh/MTMR' alt='License'/>

  </p>
  </details>

- [Pock](https://github.com/pock/pock) - Display macOS Dock in Touch Bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/pock/pock/releases/latest'><img src='https://img.shields.io/github/v/release/pock/pock?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pock/pock'><img src='https://img.shields.io/github/stars/pock/pock?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pock/pock' alt='License'/>

  **Website:** [https://pock.app/](https://pock.app/)

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/51a17fe9599c84dddda6aa5540e8cdbebedfce83/68747470733a2f2f706f636b2e6465762f6173736574732f696d672f707265766965772f706f636b5f776964676574732e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [Touch Bar Preview](https://github.com/touchbar/Touch-Bar-Preview) - Small application to display your designs on the Touch Bar of the new MacBook Pro. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/touchbar/Touch-Bar-Preview/releases/latest'><img src='https://img.shields.io/github/v/release/touchbar/Touch-Bar-Preview?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/touchbar/Touch-Bar-Preview'><img src='https://img.shields.io/github/stars/touchbar/Touch-Bar-Preview?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/touchbar/Touch-Bar-Preview' alt='License'/>

  </p>
  </details>

- [Touch Bar Simulator](https://github.com/sindresorhus/touch-bar-simulator) - Use the Touch Bar on any Mac. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sindresorhus/touch-bar-simulator/releases/latest'><img src='https://img.shields.io/github/v/release/sindresorhus/touch-bar-simulator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sindresorhus/touch-bar-simulator'><img src='https://img.shields.io/github/stars/sindresorhus/touch-bar-simulator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sindresorhus/touch-bar-simulator' alt='License'/>

  </p>
  </details>

- [Touch Emoji](https://github.com/ilyalesik/touch-emoji) - Emoji picker for MacBook Pro Touch Bar. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ilyalesik/touch-emoji/releases/latest'><img src='https://img.shields.io/github/v/release/ilyalesik/touch-emoji?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ilyalesik/touch-emoji'><img src='https://img.shields.io/github/stars/ilyalesik/touch-emoji?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ilyalesik/touch-emoji' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/lm-a/touch-emoji/master/touch-emoji-icon-screenshot.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/lm-a/touch-emoji/master/touch-emoji-recent-screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="utilities"></a>
### 🛠️ Utilities (83)
- [Android tool for Mac](https://github.com/mortenjust/androidtool-mac) - One-click screenshots, video recordings, app installation for iOS and Android 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mortenjust/androidtool-mac/releases/latest'><img src='https://img.shields.io/github/v/release/mortenjust/androidtool-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mortenjust/androidtool-mac'><img src='https://img.shields.io/github/stars/mortenjust/androidtool-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mortenjust/androidtool-mac' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mortenjust/androidtool-mac/master/Demos/plugging%20in.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/mortenjust/androidtool-mac/master/Demos/phonerecording.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/mortenjust/androidtool-mac/master/Demos/installapk.gif' width='400' loading='lazy'/>

  *(2 more screenshots available in the repository)*

  </p>
  </details>

- [ArchiveMounter](https://github.com/ivoronin/ArchiveMounter) - Mounts archives like disk images.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ivoronin/ArchiveMounter/releases/latest'><img src='https://img.shields.io/github/v/release/ivoronin/ArchiveMounter?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ivoronin/ArchiveMounter'><img src='https://img.shields.io/github/stars/ivoronin/ArchiveMounter?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ivoronin/ArchiveMounter' alt='License'/>

  </p>
  </details>

- [Balena Etcher](https://github.com/balena-io/etcher) - Flash OS images to SD cards & USB drives, safely and easily. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/balena-io/etcher/releases/latest'><img src='https://img.shields.io/github/v/release/balena-io/etcher?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/balena-io/etcher'><img src='https://img.shields.io/github/stars/balena-io/etcher?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/balena-io/etcher' alt='License'/>

  **Website:** [https://www.balena.io/etcher](https://www.balena.io/etcher)

  </p>
  </details>

- [baRSS – Menu Bar RSS Reader](https://github.com/relikd/barss) - RSS & Atom feed reader that lives in the system status bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/relikd/barss/releases/latest'><img src='https://img.shields.io/github/v/release/relikd/barss?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/relikd/barss'><img src='https://img.shields.io/github/stars/relikd/barss?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/relikd/barss' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/relikd/baRSS/main/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [BeardedSpice](https://github.com/beardedspice/beardedspice) - Control web based media players with the media keys found on Mac keyboards. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/beardedspice/beardedspice/releases/latest'><img src='https://img.shields.io/github/v/release/beardedspice/beardedspice?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/beardedspice/beardedspice'><img src='https://img.shields.io/github/stars/beardedspice/beardedspice?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/beardedspice/beardedspice' alt='License'/>

  </p>
  </details>

- [Betaflight Configurator](https://github.com/betaflight/betaflight-configurator) - Cross platform configuration tool for the Betaflight firmware.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/betaflight/betaflight-configurator/releases/latest'><img src='https://img.shields.io/github/v/release/betaflight/betaflight-configurator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/betaflight/betaflight-configurator'><img src='https://img.shields.io/github/stars/betaflight/betaflight-configurator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/betaflight/betaflight-configurator' alt='License'/>

  **Website:** [https://betaflight.com/](https://betaflight.com/)

  **Screenshots:**

  <img src='https://lh3.googleusercontent.com/di77U8MJEDNqdZ3UQugKJy6TEDtHsPegDH8fOaCM0m8E7zImA6bW1epvftG5LdpUsxE-eAkJtKAfDqIvOf-RXr8VUhg=w640-h400-e365-rj-sc0x00ffffff' width='400' loading='lazy'/>

  </p>
  </details>

- [Bitwarden](https://github.com/bitwarden/desktop) - Cross-platform password management solutions for individuals, teams, and business organizations. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/bitwarden/desktop/releases/latest'><img src='https://img.shields.io/github/v/release/bitwarden/desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/bitwarden/desktop'><img src='https://img.shields.io/github/stars/bitwarden/desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/bitwarden/desktop' alt='License'/>

  **Website:** [https://bitwarden.com/](https://bitwarden.com/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/bitwarden/brand/master/screenshots/desktop-macos-vault.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/bitwarden/brand/master/screenshots/mobile-ios-myvault.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/bitwarden/brand/master/screenshots/cli-macos.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Bitwarden Menu](https://github.com/jnsdrtlf/bitwarden-menubar) - Bitwarden Password Manager in your menu bar

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/jnsdrtlf/bitwarden-menubar/releases/latest'><img src='https://img.shields.io/github/v/release/jnsdrtlf/bitwarden-menubar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jnsdrtlf/bitwarden-menubar'><img src='https://img.shields.io/github/stars/jnsdrtlf/bitwarden-menubar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jnsdrtlf/bitwarden-menubar' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/jnsdrtlf/bitwarden-menubar/main/artwork/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Boop](https://github.com/IvanMathy/Boop) - A scriptable scratchpad for developers.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/IvanMathy/Boop/releases/latest'><img src='https://img.shields.io/github/v/release/IvanMathy/Boop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/IvanMathy/Boop'><img src='https://img.shields.io/github/stars/IvanMathy/Boop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/IvanMathy/Boop' alt='License'/>

  **Website:** [https://boop.okat.best](https://boop.okat.best)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/IvanMathy/Boop/main/Boop/Documentation/Images/UI.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Buttercup Desktop](https://github.com/buttercup/buttercup-desktop) - Secure password manager for mac and other platforms. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/buttercup/buttercup-desktop/releases/latest'><img src='https://img.shields.io/github/v/release/buttercup/buttercup-desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/buttercup/buttercup-desktop'><img src='https://img.shields.io/github/stars/buttercup/buttercup-desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/buttercup/buttercup-desktop' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/3869469/35880367-6bd58770-0b86-11e8-879f-d1f9136274a9.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Bye-AppQuit](https://github.com/designsbymuzeer/Bye-Mac-App) - A minimal native macOS app to quickly view and Bulk kill running processes.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/designsbymuzeer/Bye-Mac-App/releases/latest'><img src='https://img.shields.io/github/v/release/designsbymuzeer/Bye-Mac-App?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/designsbymuzeer/Bye-Mac-App'><img src='https://img.shields.io/github/stars/designsbymuzeer/Bye-Mac-App?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/designsbymuzeer/Bye-Mac-App' alt='License'/>

  **Website:** [https://github.com/designsbymuzeer/Bye-Mac-App](https://github.com/designsbymuzeer/Bye-Mac-App)

  **Screenshots:**

  <img src='https://github.com/user-attachments/assets/63dade24-d967-4946-89e5-f8ae44097b31' width='400' loading='lazy'/>

  </p>
  </details>

- [Calculeta](https://github.com/varol/Calculeta) - Calculator for macOS which working on statusbar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/varol/Calculeta/releases/latest'><img src='https://img.shields.io/github/v/release/varol/Calculeta?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/varol/Calculeta'><img src='https://img.shields.io/github/stars/varol/Calculeta?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/varol/Calculeta' alt='License'/>

  </p>
  </details>

- [calibre](https://github.com/kovidgoyal/calibre) - cross platform e-book manager.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/kovidgoyal/calibre/releases/latest'><img src='https://img.shields.io/github/v/release/kovidgoyal/calibre?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kovidgoyal/calibre'><img src='https://img.shields.io/github/stars/kovidgoyal/calibre?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kovidgoyal/calibre' alt='License'/>

  **Website:** [https://calibre-ebook.com](https://calibre-ebook.com)

  </p>
  </details>

- [Catch](https://github.com/mipstian/catch/) - Catch: Broadcatching made easy. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mipstian/catch/releases/latest'><img src='https://img.shields.io/github/v/release/mipstian/catch?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mipstian/catch/'><img src='https://img.shields.io/github/stars/mipstian/catch?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mipstian/catch' alt='License'/>

  </p>
  </details>

- [Clear Clipboard Text Format](https://github.com/LumingYin/ClipboardClear) - Easily clear the format of your clipboard text with Clear Clipboard Text Format.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://apps.apple.com/app/clear-clipboard-text-format/id1322855232'><img src='./icons/app_store-16.png' alt='App Store' title='Download on the Mac App Store' height='16'/> App Store</a> &nbsp; <a href='https://github.com/LumingYin/ClipboardClear/releases/latest'><img src='https://img.shields.io/github/v/release/LumingYin/ClipboardClear?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/LumingYin/ClipboardClear'><img src='https://img.shields.io/github/stars/LumingYin/ClipboardClear?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/LumingYin/ClipboardClear' alt='License'/>

  **Website:** [https://apps.apple.com/app/clear-clipboard-text-format/id1322855232](https://apps.apple.com/app/clear-clipboard-text-format/id1322855232)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/LumingYin/ClipboardClear/master/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [CoreLocationCLI](https://github.com/fulldecent/corelocationcli) - Get the physical location of your device and prints it to standard output

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/fulldecent/corelocationcli/releases/latest'><img src='https://img.shields.io/github/v/release/fulldecent/corelocationcli?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/fulldecent/corelocationcli'><img src='https://img.shields.io/github/stars/fulldecent/corelocationcli?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/fulldecent/corelocationcli' alt='License'/>

  **Screenshots:**

  <img src='https://cloud.githubusercontent.com/assets/382183/25063655/52c11234-221d-11e7-81fb-0f8712dac393.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [CornerCal](https://github.com/ekreutz/CornerCal) - Simple, clean calendar and clock app for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ekreutz/CornerCal/releases/latest'><img src='https://img.shields.io/github/v/release/ekreutz/CornerCal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ekreutz/CornerCal'><img src='https://img.shields.io/github/stars/ekreutz/CornerCal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ekreutz/CornerCal' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ekreutz/CornerCal/master/screenshot-01.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Crypter](https://github.com/HR/Crypter) - Crypter is an innovative, convenient and secure cross-platform crypto app that simplifies secure password generation and management by requiring you to only remember one bit, the MasterPass. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/HR/Crypter/releases/latest'><img src='https://img.shields.io/github/v/release/HR/Crypter?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/HR/Crypter'><img src='https://img.shields.io/github/stars/HR/Crypter?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/HR/Crypter' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/HR/Crypter/master/.github/Welcome_screen.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/HR/Crypter/master/.github/Settings_screen.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/HR/Crypter/master/.github/Crypter_main_screen.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [DevUtils.app](https://github.com/DevUtilsApp/DevUtils-app) - Developer Utilities for macOS, helps you with your tiny daily tasks with just a single click! i.e., JSON Formatter, UUID Generator...

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/DevUtilsApp/DevUtils-app/releases/latest'><img src='https://img.shields.io/github/v/release/DevUtilsApp/DevUtils-app?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/DevUtilsApp/DevUtils-app'><img src='https://img.shields.io/github/stars/DevUtilsApp/DevUtils-app?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/DevUtilsApp/DevUtils-app' alt='License'/>

  **Website:** [https://devutils.com](https://devutils.com)

  **Screenshots:**

  <img src='https://devutils.com/screenshot-dark.png' width='400' loading='lazy'/>

  </p>
  </details>

- [dupeGuru](https://github.com/arsenetar/dupeguru/) - dupeGuru is a tool to find duplicate files on your computer. It can scan using file names and file contents.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/arsenetar/dupeguru/releases/latest'><img src='https://img.shields.io/github/v/release/arsenetar/dupeguru?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/arsenetar/dupeguru/'><img src='https://img.shields.io/github/stars/arsenetar/dupeguru?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/arsenetar/dupeguru' alt='License'/>

  **Website:** [https://dupeguru.voltaicideas.net/](https://dupeguru.voltaicideas.net/)

  </p>
  </details>

- [Duplicate Finder](https://github.com/powerwolf543/DuplicateFinder) - It's a useful tool that would help you to find all duplicate files which have the same names in the specific folder.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/powerwolf543/DuplicateFinder/releases/latest'><img src='https://img.shields.io/github/v/release/powerwolf543/DuplicateFinder?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/powerwolf543/DuplicateFinder'><img src='https://img.shields.io/github/stars/powerwolf543/DuplicateFinder?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/powerwolf543/DuplicateFinder' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/16394562/94992308-bc3bf000-05bb-11eb-95a9-907ec334c660.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ECheck](https://github.com/josejuanqm/ECheck) - Small tool to validate epub files for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/josejuanqm/ECheck/releases/latest'><img src='https://img.shields.io/github/v/release/josejuanqm/ECheck?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/josejuanqm/ECheck'><img src='https://img.shields.io/github/stars/josejuanqm/ECheck?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/josejuanqm/ECheck' alt='License'/>

  </p>
  </details>

- [eul](https://github.com/gao-sun/eul) - macOS status monitoring app written in SwiftUI.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/gao-sun/eul/releases/latest'><img src='https://img.shields.io/github/v/release/gao-sun/eul?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/gao-sun/eul'><img src='https://img.shields.io/github/stars/gao-sun/eul?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/gao-sun/eul' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/14722250/105626766-f718ab00-5e6c-11eb-9761-661ff85c8faf.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [far2l](https://github.com/elfmz/far2l) - Linux/Mac fork of FAR Manager v2

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/elfmz/far2l/releases/latest'><img src='https://img.shields.io/github/v/release/elfmz/far2l?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/elfmz/far2l'><img src='https://img.shields.io/github/stars/elfmz/far2l?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/elfmz/far2l' alt='License'/>

  </p>
  </details>

- [Flying Carpet](https://github.com/spieglt/flyingcarpet) - cross-platform file transfer over ad-hoc wifi, like AirDrop but for Mac/Windows/Linux.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/golang-16.png' alt='Go icon' title='Go' height='16'/> 

  **Links:** <a href='https://github.com/spieglt/flyingcarpet/releases/latest'><img src='https://img.shields.io/github/v/release/spieglt/flyingcarpet?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/spieglt/flyingcarpet'><img src='https://img.shields.io/github/stars/spieglt/flyingcarpet?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/spieglt/flyingcarpet' alt='License'/>

  **Website:** [https://adequate.systems/](https://adequate.systems/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/spieglt/FlyingCarpet/master/pictures/macDemo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [fselect](https://github.com/jhspetersson/fselect) - Command-line tool to search files with SQL syntax.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/jhspetersson/fselect/releases/latest'><img src='https://img.shields.io/github/v/release/jhspetersson/fselect?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jhspetersson/fselect'><img src='https://img.shields.io/github/stars/jhspetersson/fselect?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jhspetersson/fselect' alt='License'/>

  </p>
  </details>

- [Funky](https://github.com/thecatalinstan/Funky) - Easily toggle the function key on your Mac on a per app basis.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/thecatalinstan/Funky/releases/latest'><img src='https://img.shields.io/github/v/release/thecatalinstan/Funky?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/thecatalinstan/Funky'><img src='https://img.shields.io/github/stars/thecatalinstan/Funky?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/thecatalinstan/Funky' alt='License'/>

  </p>
  </details>

- [Gray](https://github.com/zenangst/Gray) - Pick between the light appearance and the dark appearance on a per-app basis with the click of a button 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/zenangst/Gray/releases/latest'><img src='https://img.shields.io/github/v/release/zenangst/Gray?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/zenangst/Gray'><img src='https://img.shields.io/github/stars/zenangst/Gray?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/zenangst/Gray' alt='License'/>

  </p>
  </details>

- [Grayscale Mode](https://github.com/rkbhochalya/grayscale-mode) - Manage grayscale mode from menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/rkbhochalya/grayscale-mode/releases/latest'><img src='https://img.shields.io/github/v/release/rkbhochalya/grayscale-mode?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/rkbhochalya/grayscale-mode'><img src='https://img.shields.io/github/stars/rkbhochalya/grayscale-mode?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/rkbhochalya/grayscale-mode' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/12229032/78544215-6b6b5a80-7817-11ea-8b80-12bbbfc16053.jpg' width='400' loading='lazy'/>

  <img src='https://user-images.githubusercontent.com/12229032/78544289-84740b80-7817-11ea-9092-e76fcb027702.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [homebrew-cask](https://github.com/Homebrew/homebrew-cask) - A CLI workflow for the administration of macOS applications distributed as binaries

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/ruby-16.png' alt='Ruby icon' title='Ruby' height='16'/> 

  **Links:** <a href='https://github.com/Homebrew/homebrew-cask/releases/latest'><img src='https://img.shields.io/github/v/release/Homebrew/homebrew-cask?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Homebrew/homebrew-cask'><img src='https://img.shields.io/github/stars/Homebrew/homebrew-cask?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Homebrew/homebrew-cask' alt='License'/>

  **Website:** [https://brew.sh/](https://brew.sh/)

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/e0232f054269f4da8df572c3dea4f08def189df3/68747470733a2f2f692e696d6775722e636f6d2f626a723855785a2e676966' width='400' loading='lazy'/>

  </p>
  </details>

- [Ice](https://github.com/jordanbaird/Ice) - Ice is a versatile menu bar manager that goes beyond hiding and showing items to offer a rich set of productivity features.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/jordanbaird/Ice/releases/latest'><img src='https://img.shields.io/github/v/release/jordanbaird/Ice?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jordanbaird/Ice'><img src='https://img.shields.io/github/stars/jordanbaird/Ice?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jordanbaird/Ice' alt='License'/>

  **Website:** [https://icemenubar.app/](https://icemenubar.app/)

  **Screenshots:**

  <img src='https://icemenubar.app/gallery/ice-bar.png' width='400' loading='lazy'/>

  <img src='https://icemenubar.app/gallery/menu-bar-item-search.png' width='400' loading='lazy'/>

  </p>
  </details>

- [iOScanX](https://github.com/alessiomaffeis/iOScanX) - Cocoa application for semi-automated iOS app analysis and evaluation.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/alessiomaffeis/iOScanX/releases/latest'><img src='https://img.shields.io/github/v/release/alessiomaffeis/iOScanX?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alessiomaffeis/iOScanX'><img src='https://img.shields.io/github/stars/alessiomaffeis/iOScanX?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alessiomaffeis/iOScanX' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/4zx0UvT.png' width='400' loading='lazy'/>

  <img src='https://i.imgur.com/0vEOyar.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Kap](https://github.com/wulkano/kap) - Screen recorder application built with web technology. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/wulkano/kap/releases/latest'><img src='https://img.shields.io/github/v/release/wulkano/kap?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wulkano/kap'><img src='https://img.shields.io/github/stars/wulkano/kap?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wulkano/kap' alt='License'/>

  </p>
  </details>

- [KeePassXC](https://github.com/keepassxreboot/keepassxc) - Cross-platform community-driven port of the Windows application "Keepass Password Safe" 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/keepassxreboot/keepassxc/releases/latest'><img src='https://img.shields.io/github/v/release/keepassxreboot/keepassxc?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/keepassxreboot/keepassxc'><img src='https://img.shields.io/github/stars/keepassxreboot/keepassxc?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/keepassxreboot/keepassxc' alt='License'/>

  </p>
  </details>

- [KeeWeb](https://github.com/keeweb/keeweb) - Cross-platform password manager compatible with KeePass. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/keeweb/keeweb/releases/latest'><img src='https://img.shields.io/github/v/release/keeweb/keeweb?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/keeweb/keeweb'><img src='https://img.shields.io/github/stars/keeweb/keeweb?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/keeweb/keeweb' alt='License'/>

  </p>
  </details>

- [Keka](https://github.com/aonez/Keka) - Keka is a full featured file archiver, as easy as it can be.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/aonez/Keka/releases/latest'><img src='https://img.shields.io/github/v/release/aonez/Keka?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/aonez/Keka'><img src='https://img.shields.io/github/stars/aonez/Keka?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/aonez/Keka' alt='License'/>

  **Website:** [https://www.keka.io/en/](https://www.keka.io/en/)

  **Screenshots:**

  <img src='https://www.keka.io/img/Keka-Square-512x512.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Kyapchar](https://github.com/vishaltelangre/Kyapchar) - Simple screen and microphone audio recorder for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/vishaltelangre/Kyapchar/releases/latest'><img src='https://img.shields.io/github/v/release/vishaltelangre/Kyapchar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vishaltelangre/Kyapchar'><img src='https://img.shields.io/github/stars/vishaltelangre/Kyapchar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vishaltelangre/Kyapchar' alt='License'/>

  </p>
  </details>

- [Layout Designer for UICollectionView](https://github.com/amirdew/CollectionViewPagingLayout) - A simple but powerful tool that helps you make complex layouts for UICollectionView.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12'><img src='./icons/app_store-16.png' alt='App Store' title='Download on the Mac App Store' height='16'/> App Store</a> &nbsp; <a href='https://github.com/amirdew/CollectionViewPagingLayout/releases/latest'><img src='https://img.shields.io/github/v/release/amirdew/CollectionViewPagingLayout?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/amirdew/CollectionViewPagingLayout'><img src='https://img.shields.io/github/stars/amirdew/CollectionViewPagingLayout?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/amirdew/CollectionViewPagingLayout' alt='License'/>

  **Website:** [https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12](https://apps.apple.com/nl/app/layout-designer/id1507238011?l=en&mt=12)

  **Screenshots:**

  <img src='https://amir.app/git/layout_designer_preview.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Lunar](https://github.com/alin23/lunar) - Intelligent adaptive brightness for your external displays. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/alin23/lunar/releases/latest'><img src='https://img.shields.io/github/v/release/alin23/lunar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/alin23/lunar'><img src='https://img.shields.io/github/stars/alin23/lunar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/alin23/lunar' alt='License'/>

  </p>
  </details>

- [mac-sound-fix](https://github.com/dragstor/mac-sound-fix) - Mac Sound Re-Enabler. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/dragstor/mac-sound-fix/releases/latest'><img src='https://img.shields.io/github/v/release/dragstor/mac-sound-fix?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dragstor/mac-sound-fix'><img src='https://img.shields.io/github/stars/dragstor/mac-sound-fix?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dragstor/mac-sound-fix' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/2ec00a08b476bb6b62b64b1813e0b608dd819d6d/68747470733a2f2f692e696d6775722e636f6d2f483338735073662e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [macOS GateKeeper Helper](https://github.com/wynioux/macOS-GateKeeper-Helper) - Simple macOS GateKeeper script. It helps you to control your GateKeeper.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/shell-16.png' alt='Shell icon' title='Shell' height='16'/> 

  **Links:** <a href='https://github.com/wynioux/macOS-GateKeeper-Helper/releases/latest'><img src='https://img.shields.io/github/v/release/wynioux/macOS-GateKeeper-Helper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wynioux/macOS-GateKeeper-Helper'><img src='https://img.shields.io/github/stars/wynioux/macOS-GateKeeper-Helper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wynioux/macOS-GateKeeper-Helper' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/wynioux/macOS-GateKeeper-Helper/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MacPacker](https://github.com/sarensw/MacPacker/) - Archive manager for macOS. Preview (nested) archives without extracting them. Extract single files.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sarensw/MacPacker/releases/latest'><img src='https://img.shields.io/github/v/release/sarensw/MacPacker?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sarensw/MacPacker/'><img src='https://img.shields.io/github/stars/sarensw/MacPacker?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sarensw/MacPacker' alt='License'/>

  **Website:** [https://macpacker.app/](https://macpacker.app/)

  **Screenshots:**

  <img src='https://macpacker.app/main.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MacPass](https://github.com/MacPass/MacPass) - Native macOS KeePass client. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/MacPass/MacPass/releases/latest'><img src='https://img.shields.io/github/v/release/MacPass/MacPass?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/MacPass/MacPass'><img src='https://img.shields.io/github/stars/MacPass/MacPass?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/MacPass/MacPass' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/768f015c1f8777b78ceb2c75bf880133a3668061/68747470733a2f2f7261772e6769746875622e636f6d2f6d737461726b652f4d6163506173732f6d61737465722f4173736574732f53637265656e73686f74732f4d6163506173732e706e67' width='400' loading='lazy'/>

  </p>
  </details>

- [Maria](https://github.com/shincurry/Maria) - macOS native app/widget for aria2 download tool. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/shincurry/Maria/releases/latest'><img src='https://img.shields.io/github/v/release/shincurry/Maria?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/shincurry/Maria'><img src='https://img.shields.io/github/stars/shincurry/Maria?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/shincurry/Maria' alt='License'/>

  </p>
  </details>

- [MeetingBar](https://github.com/leits/MeetingBar) - Menu bar app for your calendar meetings

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/leits/MeetingBar/releases/latest'><img src='https://img.shields.io/github/v/release/leits/MeetingBar?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/leits/MeetingBar'><img src='https://img.shields.io/github/stars/leits/MeetingBar?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/leits/MeetingBar' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/leits/MeetingBar/master/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Meme Maker](https://github.com/MemeMaker/Meme-Maker-Mac) - Meme Maker macOS application for meme creation. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/MemeMaker/Meme-Maker-Mac/releases/latest'><img src='https://img.shields.io/github/v/release/MemeMaker/Meme-Maker-Mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/MemeMaker/Meme-Maker-Mac'><img src='https://img.shields.io/github/stars/MemeMaker/Meme-Maker-Mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/MemeMaker/Meme-Maker-Mac' alt='License'/>

  </p>
  </details>

- [Middleclick](https://github.com/artginzburg/MiddleClick-Ventura) - Emulate a scroll wheel click with three finger Click or Tap on MacBook trackpad and Magic Mouse

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/artginzburg/MiddleClick-Ventura/releases/latest'><img src='https://img.shields.io/github/v/release/artginzburg/MiddleClick-Ventura?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/artginzburg/MiddleClick-Ventura'><img src='https://img.shields.io/github/stars/artginzburg/MiddleClick-Ventura?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/artginzburg/MiddleClick-Ventura' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/artginzburg/MiddleClick-Ventura/blob/master/demo.png' width='400' loading='lazy'/>

  </p>
  </details>

- [MiddleDrag](https://github.com/NullPointerDepressiveDisorder/MiddleDrag) - Three-finger trackpad gestures for middle-click and middle-drag.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/NullPointerDepressiveDisorder/MiddleDrag/releases/latest'><img src='https://img.shields.io/github/v/release/NullPointerDepressiveDisorder/MiddleDrag?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/NullPointerDepressiveDisorder/MiddleDrag'><img src='https://img.shields.io/github/stars/NullPointerDepressiveDisorder/MiddleDrag?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/NullPointerDepressiveDisorder/MiddleDrag' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/NullPointerDepressiveDisorder/MiddleDrag/main/Screenshots/MiddleDrag-Demo.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [MonitorControl](https://github.com/MonitorControl/MonitorControl) - Control your external monitor brightness, contrast or volume directly from a menulet or with keyboard native keys.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/MonitorControl/MonitorControl/releases/latest'><img src='https://img.shields.io/github/v/release/MonitorControl/MonitorControl?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/MonitorControl/MonitorControl'><img src='https://img.shields.io/github/stars/MonitorControl/MonitorControl?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/MonitorControl/MonitorControl' alt='License'/>

  **Screenshots:**

  <img src='https://github.com/MonitorControl/MonitorControl/tree/master/.github' width='400' loading='lazy'/>

  </p>
  </details>

- [Monolingual](https://github.com/IngmarStein/Monolingual) - Remove unnecessary language resources from macOS 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/IngmarStein/Monolingual/releases/latest'><img src='https://img.shields.io/github/v/release/IngmarStein/Monolingual?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/IngmarStein/Monolingual'><img src='https://img.shields.io/github/stars/IngmarStein/Monolingual?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/IngmarStein/Monolingual' alt='License'/>

  **Screenshots:**

  <img src='https://ingmarstein.github.io/Monolingual/images/Monolingual-1.6.7-en.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Mos](https://github.com/Caldis/Mos) - Smooth your mouse's scrolling and reverse the mouse scroll direction 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Caldis/Mos/releases/latest'><img src='https://img.shields.io/github/v/release/Caldis/Mos?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Caldis/Mos'><img src='https://img.shields.io/github/stars/Caldis/Mos?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Caldis/Mos' alt='License'/>

  </p>
  </details>

- [MQTTX](https://github.com/emqx/MQTTX) - An elegant Cross-platform MQTT 5.0 desktop client.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> 

  **Links:** <a href='https://github.com/emqx/MQTTX/releases/latest'><img src='https://img.shields.io/github/v/release/emqx/MQTTX?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/emqx/MQTTX'><img src='https://img.shields.io/github/stars/emqx/MQTTX?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/emqx/MQTTX' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/emqx/MQTTX/master/assets/mqttx-gif.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/emqx/MQTTX/master/assets/mqttx-preview.png' width='400' loading='lazy'/>

  </p>
  </details>

- [nix-package-manager](https://github.com/NixOS/nix) - Nix is a reproducible package manager alternative to Homebrew, with over 80,000 packages.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <code>c++</code> <img src='./icons/shell-16.png' alt='Shell icon' title='Shell' height='16'/> <code>nix</code> 

  **Links:** <a href='https://github.com/NixOS/nix/releases/latest'><img src='https://img.shields.io/github/v/release/NixOS/nix?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/NixOS/nix'><img src='https://img.shields.io/github/stars/NixOS/nix?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/NixOS/nix' alt='License'/>

  **Website:** [https://nixos.org/explore.html](https://nixos.org/explore.html)

  </p>
  </details>

- [Nmap](https://github.com/nmap/nmap) - Nmap - the Network Mapper. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/nmap/nmap/releases/latest'><img src='https://img.shields.io/github/v/release/nmap/nmap?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nmap/nmap'><img src='https://img.shields.io/github/stars/nmap/nmap?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nmap/nmap' alt='License'/>

  **Website:** [https://nmap.org](https://nmap.org)

  </p>
  </details>

- [Nocturnal](https://github.com/joshjon/nocturnal) - Menu bar app featuring darker than dark dimming, Night Shift fine tuning, and the ability to turn off TouchBar on MacBook Pro. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/joshjon/nocturnal/releases/latest'><img src='https://img.shields.io/github/v/release/joshjon/nocturnal?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/joshjon/nocturnal'><img src='https://img.shields.io/github/stars/joshjon/nocturnal?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/joshjon/nocturnal' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/joshjon/nocturnal/master/Docs/Images/Nocturnal-Screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [NoiseBuddy](https://github.com/insidegui/NoiseBuddy) - Control the listening mode on your AirPods Pro in the Touch Bar or Menu Bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/NoiseBuddy/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/NoiseBuddy?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/NoiseBuddy'><img src='https://img.shields.io/github/stars/insidegui/NoiseBuddy?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/NoiseBuddy' alt='License'/>

  </p>
  </details>

- [Noti](https://github.com/jariz/Noti/) - Receive Android notifications on your mac (with PushBullet). 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/jariz/Noti/releases/latest'><img src='https://img.shields.io/github/v/release/jariz/Noti?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jariz/Noti/'><img src='https://img.shields.io/github/stars/jariz/Noti?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jariz/Noti' alt='License'/>

  </p>
  </details>

- [NVM](https://github.com/nvm-sh/nvm) - Node Version Manager. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/shell-16.png' alt='Shell icon' title='Shell' height='16'/> 

  **Links:** <a href='https://github.com/nvm-sh/nvm/releases/latest'><img src='https://img.shields.io/github/v/release/nvm-sh/nvm?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nvm-sh/nvm'><img src='https://img.shields.io/github/stars/nvm-sh/nvm?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nvm-sh/nvm' alt='License'/>

  </p>
  </details>

- [OpenRocket](https://github.com/openrocket/openrocket) - OpenRocket is a cross-platform utility tool to model and simulate model rockets and their flight characteristics.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/java-16.png' alt='Java icon' title='Java' height='16'/> 

  **Links:** <a href='https://github.com/openrocket/openrocket/releases/latest'><img src='https://img.shields.io/github/v/release/openrocket/openrocket?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/openrocket/openrocket'><img src='https://img.shields.io/github/stars/openrocket/openrocket?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/openrocket/openrocket' alt='License'/>

  **Website:** [https://openrocket.info/](https://openrocket.info/)

  </p>
  </details>

- [Padlock](https://github.com/padloc/padloc) - A minimal, open source password manager for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/padloc/padloc/releases/latest'><img src='https://img.shields.io/github/v/release/padloc/padloc?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/padloc/padloc'><img src='https://img.shields.io/github/stars/padloc/padloc?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/padloc/padloc' alt='License'/>

  </p>
  </details>

- [PB for Desktop](https://github.com/sidneys/pb-for-desktop) - Receive native push notifications on macOS, Windows and Linux. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/sidneys/pb-for-desktop/releases/latest'><img src='https://img.shields.io/github/v/release/sidneys/pb-for-desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sidneys/pb-for-desktop'><img src='https://img.shields.io/github/stars/sidneys/pb-for-desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sidneys/pb-for-desktop' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/sidneys/pb-for-desktop/master/resources/screenshots/screenshot-linux.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sidneys/pb-for-desktop/master/resources/graphics/icon.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sidneys/pb-for-desktop/master/resources/screenshots/screenshot-macos.png' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [PercentCalculator](https://github.com/cemolcay/PercentCalculator) - A menu bar application that calculates percents. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/cemolcay/PercentCalculator/releases/latest'><img src='https://img.shields.io/github/v/release/cemolcay/PercentCalculator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/cemolcay/PercentCalculator'><img src='https://img.shields.io/github/stars/cemolcay/PercentCalculator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/cemolcay/PercentCalculator' alt='License'/>

  </p>
  </details>

- [Pika](https://github.com/superhighfives/pika) - Is an easy to use, open-source, native colour picker for macOS.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <code>metal</code> 

  **Links:** <a href='https://github.com/superhighfives/pika/releases/latest'><img src='https://img.shields.io/github/v/release/superhighfives/pika?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/superhighfives/pika'><img src='https://img.shields.io/github/stars/superhighfives/pika?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/superhighfives/pika' alt='License'/>

  **Website:** [https://superhighfives.com/pika](https://superhighfives.com/pika)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/449385/103492507-4e55cd80-4e23-11eb-9366-d31c2bb74030.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Plain Pasta](https://github.com/hisaac/PlainPasta) - Plaintextify your clipboard

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/hisaac/PlainPasta/releases/latest'><img src='https://img.shields.io/github/v/release/hisaac/PlainPasta?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/hisaac/PlainPasta'><img src='https://img.shields.io/github/stars/hisaac/PlainPasta?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/hisaac/PlainPasta' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/hisaac/PlainPasta/main/docs/without-plain-pasta.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/hisaac/PlainPasta/main/docs/with-plain-pasta.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [PlayStatus](https://github.com/nbolar/PlayStatus) - PlayStatus is a macOS app that allows the control of Spotify and iTunes music playback from the menu bar.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/nbolar/PlayStatus/releases/latest'><img src='https://img.shields.io/github/v/release/nbolar/PlayStatus?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/nbolar/PlayStatus'><img src='https://img.shields.io/github/stars/nbolar/PlayStatus?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/nbolar/PlayStatus' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/45484873/60389024-ece0d000-9ac2-11e9-8dbc-2376e905887f.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [PowerShell](https://github.com/powershell/powershell) - PowerShell is a cross-platform automation and configuration tool/framework that works well with your existing tools.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/csharp-16.png' alt='C# icon' title='C#' height='16'/> 

  **Links:** <a href='https://github.com/powershell/powershell/releases/latest'><img src='https://img.shields.io/github/v/release/powershell/powershell?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/powershell/powershell'><img src='https://img.shields.io/github/stars/powershell/powershell?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/powershell/powershell' alt='License'/>

  </p>
  </details>

- [Rugby](https://github.com/swiftyfinch/Rugby) - 🏈 Cache CocoaPods for faster rebuild and indexing Xcode project.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/swiftyfinch/Rugby/releases/latest'><img src='https://img.shields.io/github/v/release/swiftyfinch/Rugby?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/swiftyfinch/Rugby'><img src='https://img.shields.io/github/stars/swiftyfinch/Rugby?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/swiftyfinch/Rugby' alt='License'/>

  **Website:** [https://swiftyfinch.github.io/en/2021-03-09-rugby-story/](https://swiftyfinch.github.io/en/2021-03-09-rugby-story/)

  **Screenshots:**

  <img src='https://github.com/swiftyfinch/Rugby/blob/main/Assets/Preview.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [ScreenCat](https://github.com/maxogden/screencat) - ScreenCat is a screen sharing + remote collaboration application.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> <img src='./icons/css-16.png' alt='CSS icon' title='CSS' height='16'/> 

  **Links:** <a href='https://github.com/maxogden/screencat/releases/latest'><img src='https://img.shields.io/github/v/release/maxogden/screencat?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/maxogden/screencat'><img src='https://img.shields.io/github/stars/maxogden/screencat?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/maxogden/screencat' alt='License'/>

  </p>
  </details>

- [SlimHUD - Cyanocitta](https://github.com/AlexPerathoner/SlimHUD) - Replacement for MacOS' volume, brightness and keyboard backlight HUDs.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/AlexPerathoner/SlimHUD/releases/latest'><img src='https://img.shields.io/github/v/release/AlexPerathoner/SlimHUD?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/AlexPerathoner/SlimHUD'><img src='https://img.shields.io/github/stars/AlexPerathoner/SlimHUD?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/AlexPerathoner/SlimHUD' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/AlexPerathoner/SlimHUD/master/Screens/Animations/animations.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/AlexPerathoner/SlimHUD/master/Screens/settingsWindow.png' width='400' loading='lazy'/>

  </p>
  </details>

- [SlowQuitApps](https://github.com/dteoh/SlowQuitApps) - Add a global delay to Command-Q to stop accidental app quits. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/dteoh/SlowQuitApps/releases/latest'><img src='https://img.shields.io/github/v/release/dteoh/SlowQuitApps?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/dteoh/SlowQuitApps'><img src='https://img.shields.io/github/stars/dteoh/SlowQuitApps?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/dteoh/SlowQuitApps' alt='License'/>

  </p>
  </details>

- [Spotter](https://github.com/spotter-application/spotter) - Productivity tool, the main function is to search and launch external application actions and applications themselves, so you can stay focused on your current task. Kind of spotlight or alfred alternative.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/spotter-application/spotter/releases/latest'><img src='https://img.shields.io/github/v/release/spotter-application/spotter?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/spotter-application/spotter'><img src='https://img.shields.io/github/stars/spotter-application/spotter?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/spotter-application/spotter' alt='License'/>

  </p>
  </details>

- [Stats](https://github.com/exelban/stats) - macOS system monitor in your menu bar

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/exelban/stats/releases/latest'><img src='https://img.shields.io/github/v/release/exelban/stats?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/exelban/stats'><img src='https://img.shields.io/github/stars/exelban/stats?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/exelban/stats' alt='License'/>

  **Screenshots:**

  <img src='https://camo.githubusercontent.com/0e25eeb8b466356b0bcd847d064da3084baa5aed9bf53fab3bad2f0f0fbd1ee9/68747470733a2f2f7365726869792e73332e65752d63656e7472616c2d312e616d617a6f6e6177732e636f6d2f4769746875625f7265706f2f73746174732f706f7075707325334676322e332e322e706e673f7633' width='400' loading='lazy'/>

  </p>
  </details>

- [Stringz](https://github.com/mohakapt/Stringz) - A lightweight and powerful editor for localizing iOS, macOS, tvOS, and watchOS applications.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mohakapt/Stringz/releases/latest'><img src='https://img.shields.io/github/v/release/mohakapt/Stringz?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mohakapt/Stringz'><img src='https://img.shields.io/github/stars/mohakapt/Stringz?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mohakapt/Stringz' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mohakapt/Stringz/main/Resources/hero_dark.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/mohakapt/Stringz/main/Resources/hero_light.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Super Productivity](https://github.com/johannesjo/super-productivity) - Free to do list & time tracker for programmers & designers with Jira integration.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/typescript-16.png' alt='TypeScript icon' title='TypeScript' height='16'/> <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/johannesjo/super-productivity/releases/latest'><img src='https://img.shields.io/github/v/release/johannesjo/super-productivity?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/johannesjo/super-productivity'><img src='https://img.shields.io/github/stars/johannesjo/super-productivity?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/johannesjo/super-productivity' alt='License'/>

  **Website:** [https://super-productivity.com](https://super-productivity.com)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/johannesjo/super-productivity/master/screens/screen_standard.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Telephone](https://github.com/64characters/Telephone) - SIP softphone for macOS.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/64characters/Telephone/releases/latest'><img src='https://img.shields.io/github/v/release/64characters/Telephone?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/64characters/Telephone'><img src='https://img.shields.io/github/stars/64characters/Telephone?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/64characters/Telephone' alt='License'/>

  </p>
  </details>

- [The Blockstack Browser](https://github.com/stacks-network/blockstack-browser) - Blockstack is an internet for decentralized apps where users own their data. The Blockstack Browser allows you to explore the Blockstack internet. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/stacks-network/blockstack-browser/releases/latest'><img src='https://img.shields.io/github/v/release/stacks-network/blockstack-browser?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/stacks-network/blockstack-browser'><img src='https://img.shields.io/github/stars/stacks-network/blockstack-browser?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/stacks-network/blockstack-browser' alt='License'/>

  </p>
  </details>

- [ThenGenerator](https://github.com/87kangsw/ThenGenerator) - Xcode Source Editor Extension for 'Then'

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/87kangsw/ThenGenerator/releases/latest'><img src='https://img.shields.io/github/v/release/87kangsw/ThenGenerator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/87kangsw/ThenGenerator'><img src='https://img.shields.io/github/stars/87kangsw/ThenGenerator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/87kangsw/ThenGenerator' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/87kangsw/ThenGenerator/main/.github/images/property.png' width='400' loading='lazy'/>

  </p>
  </details>

- [ToTheTop](https://github.com/zenangst/ToTheTop) - Small macOS application to help you scroll to the top. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/zenangst/ToTheTop/releases/latest'><img src='https://img.shields.io/github/v/release/zenangst/ToTheTop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/zenangst/ToTheTop'><img src='https://img.shields.io/github/stars/zenangst/ToTheTop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/zenangst/ToTheTop' alt='License'/>

  </p>
  </details>

- [Ultra TabSaver](https://github.com/Swift-open-source/UltraTabSaver) - Ultra TabSaver is an open-source Tab Manager for Safari

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/Swift-open-source/UltraTabSaver/releases/latest'><img src='https://img.shields.io/github/v/release/Swift-open-source/UltraTabSaver?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Swift-open-source/UltraTabSaver'><img src='https://img.shields.io/github/stars/Swift-open-source/UltraTabSaver?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Swift-open-source/UltraTabSaver' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/Swift-open-source/UltraTabSaver/main/Ultra-TabSaver.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [wechsel](https://github.com/friedrichweise/wechsel) - manage bluetooth connections with your keyboard.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/friedrichweise/wechsel/releases/latest'><img src='https://img.shields.io/github/v/release/friedrichweise/wechsel?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/friedrichweise/wechsel'><img src='https://img.shields.io/github/stars/friedrichweise/wechsel?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/friedrichweise/wechsel' alt='License'/>

  **Website:** [https://wechsel.weise.io](https://wechsel.weise.io)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/friedrichweise/wechsel/master/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Wireshark](https://github.com/wireshark/wireshark) - Wireshark is the world’s foremost and widely-used network protocol analyzer. It lets you see what’s happening on your network at a microscopic level and is the de facto (and often de jure) standard across many commercial and non-profit enterprises, government agencies, and educational institutions. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/wireshark/wireshark/releases/latest'><img src='https://img.shields.io/github/v/release/wireshark/wireshark?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/wireshark/wireshark'><img src='https://img.shields.io/github/stars/wireshark/wireshark?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/wireshark/wireshark' alt='License'/>

  **Website:** [https://www.wireshark.org](https://www.wireshark.org)

  </p>
  </details>

- [zoxide](https://github.com/ajeetdsouza/zoxide) - zoxide is a smarter cd command for your terminal.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/rust-16.png' alt='Rust icon' title='Rust' height='16'/> 

  **Links:** <a href='https://github.com/ajeetdsouza/zoxide/releases/latest'><img src='https://img.shields.io/github/v/release/ajeetdsouza/zoxide?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ajeetdsouza/zoxide'><img src='https://img.shields.io/github/stars/ajeetdsouza/zoxide?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ajeetdsouza/zoxide' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/ajeetdsouza/zoxide/c392a8bb75af098b3906ed66595e79f05af92d1a/contrib/tutorial.webp' width='400' loading='lazy'/>

  </p>
  </details>

- [Übersicht](https://github.com/felixhageloh/uebersicht) - Keep an eye on what's happening on your machine and in the world. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/felixhageloh/uebersicht/releases/latest'><img src='https://img.shields.io/github/v/release/felixhageloh/uebersicht?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/felixhageloh/uebersicht'><img src='https://img.shields.io/github/stars/felixhageloh/uebersicht?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/felixhageloh/uebersicht' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="vpn--proxy"></a>
### 🔐 VPN & Proxy (6)
- [clashX](https://github.com/yichengchen/clashX) - A rule based custom proxy with GUI for Mac base on clash. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/yichengchen/clashX/releases/latest'><img src='https://img.shields.io/github/v/release/yichengchen/clashX?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/yichengchen/clashX'><img src='https://img.shields.io/github/stars/yichengchen/clashX?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/yichengchen/clashX' alt='License'/>

  </p>
  </details>

- [rvc-mac](https://github.com/riboseinc/cryptode-mac) - Ribose VPN Client macOS Menu App. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/riboseinc/cryptode-mac/releases/latest'><img src='https://img.shields.io/github/v/release/riboseinc/cryptode-mac?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/riboseinc/cryptode-mac'><img src='https://img.shields.io/github/stars/riboseinc/cryptode-mac?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/riboseinc/cryptode-mac' alt='License'/>

  </p>
  </details>

- [ShadowsocksX-NG](https://github.com/shadowsocks/ShadowsocksX-NG) - Next Generation of ShadowsocksX. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/shadowsocks/ShadowsocksX-NG/releases/latest'><img src='https://img.shields.io/github/v/release/shadowsocks/ShadowsocksX-NG?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/shadowsocks/ShadowsocksX-NG'><img src='https://img.shields.io/github/stars/shadowsocks/ShadowsocksX-NG?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/shadowsocks/ShadowsocksX-NG' alt='License'/>

  </p>
  </details>

- [Specht](https://github.com/zhuhaow/Specht) - Rule-based proxy app built with Network Extension for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/zhuhaow/Specht/releases/latest'><img src='https://img.shields.io/github/v/release/zhuhaow/Specht?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/zhuhaow/Specht'><img src='https://img.shields.io/github/stars/zhuhaow/Specht?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/zhuhaow/Specht' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/zhuhaow/Specht/master/imgs/splash.png' width='400' loading='lazy'/>

  </p>
  </details>

- [SpechtLite](https://github.com/zhuhaow/SpechtLite) - Rule-based proxy app for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/zhuhaow/SpechtLite/releases/latest'><img src='https://img.shields.io/github/v/release/zhuhaow/SpechtLite?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/zhuhaow/SpechtLite'><img src='https://img.shields.io/github/stars/zhuhaow/SpechtLite?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/zhuhaow/SpechtLite' alt='License'/>

  </p>
  </details>

- [Tunnelblick](https://github.com/Tunnelblick/Tunnelblick) - Tunnelblick is a graphic user interface for OpenVPN on macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Tunnelblick/Tunnelblick/releases/latest'><img src='https://img.shields.io/github/v/release/Tunnelblick/Tunnelblick?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Tunnelblick/Tunnelblick'><img src='https://img.shields.io/github/stars/Tunnelblick/Tunnelblick?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Tunnelblick/Tunnelblick' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="video"></a>
### 🎬 Video (19)
- [Acid.Cam.v2.OSX](https://github.com/lostjared/Acid.Cam.v2.OSX) - Acid Cam v2 for macOS distorts video to create art. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/lostjared/Acid.Cam.v2.OSX/releases/latest'><img src='https://img.shields.io/github/v/release/lostjared/Acid.Cam.v2.OSX?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lostjared/Acid.Cam.v2.OSX'><img src='https://img.shields.io/github/stars/lostjared/Acid.Cam.v2.OSX?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lostjared/Acid.Cam.v2.OSX' alt='License'/>

  </p>
  </details>

- [AppleEvents](https://github.com/insidegui/AppleEvents) - Unofficial Apple Events app for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/insidegui/AppleEvents/releases/latest'><img src='https://img.shields.io/github/v/release/insidegui/AppleEvents?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/insidegui/AppleEvents'><img src='https://img.shields.io/github/stars/insidegui/AppleEvents?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/insidegui/AppleEvents' alt='License'/>

  </p>
  </details>

- [Conferences.digital](https://github.com/zagahr/Conferences.digital) - Best way to watch the latest and greatest videos from your favourite developer conferences for free on your Mac.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/zagahr/Conferences.digital/releases/latest'><img src='https://img.shields.io/github/v/release/zagahr/Conferences.digital?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/zagahr/Conferences.digital'><img src='https://img.shields.io/github/stars/zagahr/Conferences.digital?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/zagahr/Conferences.digital' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/zagahr/Conferences.digital/master/.github/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Datamosh](https://github.com/maelswarm/Datamosh) - Datamosh your videos on macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/maelswarm/Datamosh/releases/latest'><img src='https://img.shields.io/github/v/release/maelswarm/Datamosh?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/maelswarm/Datamosh'><img src='https://img.shields.io/github/stars/maelswarm/Datamosh?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/maelswarm/Datamosh' alt='License'/>

  **Screenshots:**

  <img src='https://media.giphy.com/media/13bMkBsTQ7mh32/giphy.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Face Data](https://github.com/xiaohk/FaceData) - macOS application used to auto-annotate landmarks from a video. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/xiaohk/FaceData/releases/latest'><img src='https://img.shields.io/github/v/release/xiaohk/FaceData?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/xiaohk/FaceData'><img src='https://img.shields.io/github/stars/xiaohk/FaceData?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/xiaohk/FaceData' alt='License'/>

  **Screenshots:**

  <img src='https://i.imgur.com/FEVY2Pu.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/xiaohk/FaceData/master/result.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Gifted](https://github.com/vdel26/gifted) - Turn any short video into an animated GIF quickly and easily. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/vdel26/gifted/releases/latest'><img src='https://img.shields.io/github/v/release/vdel26/gifted?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/vdel26/gifted'><img src='https://img.shields.io/github/stars/vdel26/gifted?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/vdel26/gifted' alt='License'/>

  </p>
  </details>

- [GNU Gatekeeper](https://github.com/willamowius/gnugk) - Video conferencing server for H.323 terminals. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/willamowius/gnugk/releases/latest'><img src='https://img.shields.io/github/v/release/willamowius/gnugk?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/willamowius/gnugk'><img src='https://img.shields.io/github/stars/willamowius/gnugk?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/willamowius/gnugk' alt='License'/>

  **Website:** [https://www.gnugk.org](https://www.gnugk.org)

  </p>
  </details>

- [HandBrake](https://github.com/HandBrake/HandBrake) - HandBrake is a video transcoder available for Linux, Mac, and Windows. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/HandBrake/HandBrake/releases/latest'><img src='https://img.shields.io/github/v/release/HandBrake/HandBrake?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/HandBrake/HandBrake'><img src='https://img.shields.io/github/stars/HandBrake/HandBrake?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/HandBrake/HandBrake' alt='License'/>

  </p>
  </details>

- [LosslessCut](https://github.com/mifi/lossless-cut) - The swiss army knife of lossless video/audio editing without re-encoding.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/mifi/lossless-cut/releases/latest'><img src='https://img.shields.io/github/v/release/mifi/lossless-cut?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mifi/lossless-cut'><img src='https://img.shields.io/github/stars/mifi/lossless-cut?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mifi/lossless-cut' alt='License'/>

  **Website:** [https://mifi.no/losslesscut/](https://mifi.no/losslesscut/)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mifi/lossless-cut/master/main_screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [MenuTube](https://github.com/edanchenkov/MenuTube) - Catch YouTube into your macOS menu bar! 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/edanchenkov/MenuTube/releases/latest'><img src='https://img.shields.io/github/v/release/edanchenkov/MenuTube?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/edanchenkov/MenuTube'><img src='https://img.shields.io/github/stars/edanchenkov/MenuTube?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/edanchenkov/MenuTube' alt='License'/>

  </p>
  </details>

- [MPV](https://github.com/mpv-player/mpv) - Lightweight, highly configurable media player.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/mpv-player/mpv/releases/latest'><img src='https://img.shields.io/github/v/release/mpv-player/mpv?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mpv-player/mpv'><img src='https://img.shields.io/github/stars/mpv-player/mpv?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mpv-player/mpv' alt='License'/>

  **Website:** [https://mpv.io](https://mpv.io)

  **Screenshots:**

  <img src='https://mpv.io/images/mpv-screenshot-34cd36ae.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [OpenShot](https://github.com/OpenShot/openshot-qt) - Easy to use, quick to learn, and surprisingly powerful video editor. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/OpenShot/openshot-qt/releases/latest'><img src='https://img.shields.io/github/v/release/OpenShot/openshot-qt?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/OpenShot/openshot-qt'><img src='https://img.shields.io/github/stars/OpenShot/openshot-qt?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/OpenShot/openshot-qt' alt='License'/>

  </p>
  </details>

- [Quick Caption](https://github.com/LumingYin/Caption) - Transcribe and generate caption files (SRT, ASS and FCPXML) without manually entering time codes.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://apps.apple.com/app/quick-caption/id1363610340'><img src='./icons/app_store-16.png' alt='App Store' title='Download on the Mac App Store' height='16'/> App Store</a> &nbsp; <a href='https://github.com/LumingYin/Caption/releases/latest'><img src='https://img.shields.io/github/v/release/LumingYin/Caption?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/LumingYin/Caption'><img src='https://img.shields.io/github/stars/LumingYin/Caption?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/LumingYin/Caption' alt='License'/>

  **Website:** [https://apps.apple.com/app/quick-caption/id1363610340](https://apps.apple.com/app/quick-caption/id1363610340)

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/LumingYin/Caption/master/screenshot.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [QuickLook Video](https://github.com/Marginal/QLVideo) - This package allows macOS Finder to display thumbnails, static QuickLook previews, cover art and metadata for most types of video files. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Marginal/QLVideo/releases/latest'><img src='https://img.shields.io/github/v/release/Marginal/QLVideo?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Marginal/QLVideo'><img src='https://img.shields.io/github/stars/Marginal/QLVideo?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Marginal/QLVideo' alt='License'/>

  </p>
  </details>

- [Subler](https://bitbucket.org/galad87/subler/src) - Subler is an macOS app created to mux and tag mp4 files. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Website:** [https://subler.org](https://subler.org)

  </p>
  </details>

- [Vid Quiz Creator](https://github.com/sahil-a/vidquizcreator) - macOS application to insert quizzes within video playback and play those videos to receiving devices using the LISNR API. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sahil-a/vidquizcreator/releases/latest'><img src='https://img.shields.io/github/v/release/sahil-a/vidquizcreator?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sahil-a/vidquizcreator'><img src='https://img.shields.io/github/stars/sahil-a/vidquizcreator?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sahil-a/vidquizcreator' alt='License'/>

  </p>
  </details>

- [VLC](https://github.com/videolan/vlc) -  VLC is a free and open source cross-platform multimedia player

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> 

  **Links:** <a href='https://github.com/videolan/vlc/releases/latest'><img src='https://img.shields.io/github/v/release/videolan/vlc?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/videolan/vlc'><img src='https://img.shields.io/github/stars/videolan/vlc?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/videolan/vlc' alt='License'/>

  **Website:** [https://www.videolan.org/vlc/](https://www.videolan.org/vlc/)

  </p>
  </details>

- [WebTorrent Desktop](https://github.com/webtorrent/webtorrent-desktop) - Streaming torrent app. For Mac, Windows, and Linux. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/webtorrent/webtorrent-desktop/releases/latest'><img src='https://img.shields.io/github/v/release/webtorrent/webtorrent-desktop?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/webtorrent/webtorrent-desktop'><img src='https://img.shields.io/github/stars/webtorrent/webtorrent-desktop?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/webtorrent/webtorrent-desktop' alt='License'/>

  **Screenshots:**

  <img src='https://webtorrent.io/img/screenshot-main.png' width='400' loading='lazy'/>

  <img src='https://webtorrent.io/img/screenshot-player3.png' width='400' loading='lazy'/>

  <img src='https://webtorrent.io/img/WebTorrent.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Yoda](https://github.com/whoisandy/yoda) - Nifty macOS application which enables you to browse and download videos from YouTube. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/javascript-16.png' alt='JavaScript icon' title='JavaScript' height='16'/> 

  **Links:** <a href='https://github.com/whoisandy/yoda/releases/latest'><img src='https://img.shields.io/github/v/release/whoisandy/yoda?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/whoisandy/yoda'><img src='https://img.shields.io/github/stars/whoisandy/yoda?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/whoisandy/yoda' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="wallpaper"></a>
### 🖥️ Wallpaper (11)
- [500-mac-wallpaper](https://github.com/markcheeky/500-mac-wallpaper) - Simple macOS app for the status bar to automatically download photos from 500px.com to a local folder that can be set as a source of wallpapers. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/markcheeky/500-mac-wallpaper/releases/latest'><img src='https://img.shields.io/github/v/release/markcheeky/500-mac-wallpaper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/markcheeky/500-mac-wallpaper'><img src='https://img.shields.io/github/stars/markcheeky/500-mac-wallpaper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/markcheeky/500-mac-wallpaper' alt='License'/>

  </p>
  </details>

- [Artify](https://github.com/NghiaTranUIT/artify-macos) - A macOS application for bringing dedicatedly 18th century Arts to everyone 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/NghiaTranUIT/artify-macos/releases/latest'><img src='https://img.shields.io/github/v/release/NghiaTranUIT/artify-macos?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/NghiaTranUIT/artify-macos'><img src='https://img.shields.io/github/stars/NghiaTranUIT/artify-macos?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/NghiaTranUIT/artify-macos' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/NghiaTranUIT/artify-macos/master/images/the-starry-night.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/NghiaTranUIT/artify-macos/master/images/logo.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/NghiaTranUIT/artify-macos/master/images/red-vineyards-at-arles-1888.jpg' width='400' loading='lazy'/>

  *(1 more screenshots available in the repository)*

  </p>
  </details>

- [ArtWall](https://github.com/JustinFincher/ASWP-for-macOS) - ArtStation set as wallpapers from artwork.rss

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/JustinFincher/ASWP-for-macOS/releases/latest'><img src='https://img.shields.io/github/v/release/JustinFincher/ASWP-for-macOS?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/JustinFincher/ASWP-for-macOS'><img src='https://img.shields.io/github/stars/JustinFincher/ASWP-for-macOS?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/JustinFincher/ASWP-for-macOS' alt='License'/>

  </p>
  </details>

- [BingPaper](https://github.com/pengsrc/BingPaper) - Use Bing daily photo as your wallpaper on macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/pengsrc/BingPaper/releases/latest'><img src='https://img.shields.io/github/v/release/pengsrc/BingPaper?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/pengsrc/BingPaper'><img src='https://img.shields.io/github/stars/pengsrc/BingPaper?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/pengsrc/BingPaper' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/pengsrc/BingPaper/master/Screenshots/BingPaper_v0.9.7_en_US.jpg' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/pengsrc/BingPaper/master/Screenshots/BingPaper_v0.9.7_zh_CN.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Desktop Wallpaper Switcher](https://github.com/VioletGiraffe/desktop-wallpaper-switcher) - Win / Linux / macOS tool for managing and cycling desktop wallpapers. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/cpp-16.png' alt='C++ icon' title='C++' height='16'/> 

  **Links:** <a href='https://github.com/VioletGiraffe/desktop-wallpaper-switcher/releases/latest'><img src='https://img.shields.io/github/v/release/VioletGiraffe/desktop-wallpaper-switcher?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/VioletGiraffe/desktop-wallpaper-switcher'><img src='https://img.shields.io/github/stars/VioletGiraffe/desktop-wallpaper-switcher?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/VioletGiraffe/desktop-wallpaper-switcher' alt='License'/>

  </p>
  </details>

- [Muzei](https://github.com/naman14/Muzei-macOS) - Muzei wallpaper app for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/naman14/Muzei-macOS/releases/latest'><img src='https://img.shields.io/github/v/release/naman14/Muzei-macOS?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/naman14/Muzei-macOS'><img src='https://img.shields.io/github/stars/naman14/Muzei-macOS?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/naman14/Muzei-macOS' alt='License'/>

  </p>
  </details>

- [Plash](https://github.com/sindresorhus/Plash) - Make any website your desktop wallpaper.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/sindresorhus/Plash/releases/latest'><img src='https://img.shields.io/github/v/release/sindresorhus/Plash?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/sindresorhus/Plash'><img src='https://img.shields.io/github/stars/sindresorhus/Plash?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/sindresorhus/Plash' alt='License'/>

  **Website:** [https://sindresorhus.com/plash](https://sindresorhus.com/plash)

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/170270/74323375-0287d900-4db8-11ea-8b26-5566565fa8a1.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [pyDailyChanger](https://github.com/IngoMeyer441/pyDailyChanger) - pyDailyChanger is a program that changes your wallpaper daily. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/python-16.png' alt='Python icon' title='Python' height='16'/> 

  **Links:** <a href='https://github.com/IngoMeyer441/pyDailyChanger/releases/latest'><img src='https://img.shields.io/github/v/release/IngoMeyer441/pyDailyChanger?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/IngoMeyer441/pyDailyChanger'><img src='https://img.shields.io/github/stars/IngoMeyer441/pyDailyChanger?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/IngoMeyer441/pyDailyChanger' alt='License'/>

  </p>
  </details>

- [Satellite Eyes](https://github.com/tomtaylor/satellite-eyes) - macOS app to automatically set your desktop wallpaper to the satellite view overhead. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/tomtaylor/satellite-eyes/releases/latest'><img src='https://img.shields.io/github/v/release/tomtaylor/satellite-eyes?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/tomtaylor/satellite-eyes'><img src='https://img.shields.io/github/stars/tomtaylor/satellite-eyes?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/tomtaylor/satellite-eyes' alt='License'/>

  **Screenshots:**

  <img src='https://user-images.githubusercontent.com/836375/31194770-0950b980-a8fd-11e7-8108-9a08555a0832.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Sunscreen](https://github.com/davidcelis/Sunscreen) - Sunscreen is a fun, lightweight application that changes your desktop wallpaper based on sunrise and sunset. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/davidcelis/Sunscreen/releases/latest'><img src='https://img.shields.io/github/v/release/davidcelis/Sunscreen?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/davidcelis/Sunscreen'><img src='https://img.shields.io/github/stars/davidcelis/Sunscreen?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/davidcelis/Sunscreen' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/davidcelis/Sunscreen/master/images/icon.png' width='400' loading='lazy'/>

  </p>
  </details>

- [WallpaperMenu](https://github.com/diogosantos/WallpaperMenu) - macOS menubar application for navigation through beautiful pictures on the web and set them up as your desktop image. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/ruby-16.png' alt='Ruby icon' title='Ruby' height='16'/> 

  **Links:** <a href='https://github.com/diogosantos/WallpaperMenu/releases/latest'><img src='https://img.shields.io/github/v/release/diogosantos/WallpaperMenu?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/diogosantos/WallpaperMenu'><img src='https://img.shields.io/github/stars/diogosantos/WallpaperMenu?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/diogosantos/WallpaperMenu' alt='License'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<a id="window-management"></a>
### 🪟 Window Management (12)
- [AltTab](https://github.com/lwouis/alt-tab-macos) - AltTab brings the power of Windows alt-tab to macOS.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> <img src='./icons/shell-16.png' alt='Shell icon' title='Shell' height='16'/> 

  **Links:** <a href='https://github.com/lwouis/alt-tab-macos/releases/latest'><img src='https://img.shields.io/github/v/release/lwouis/alt-tab-macos?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/lwouis/alt-tab-macos'><img src='https://img.shields.io/github/stars/lwouis/alt-tab-macos?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/lwouis/alt-tab-macos' alt='License'/>

  **Website:** [https://alt-tab-macos.netlify.app/](https://alt-tab-macos.netlify.app/)

  **Screenshots:**

  <img src='https://alt-tab-macos.netlify.app/public/demo/1-row.jpg' width='400' loading='lazy'/>

  <img src='https://alt-tab-macos.netlify.app/public/demo/2-rows.jpg' width='400' loading='lazy'/>

  <img src='https://alt-tab-macos.netlify.app/public/demo/windows-theme.jpg' width='400' loading='lazy'/>

  </p>
  </details>

- [Amethyst](https://github.com/ianyh/Amethyst) - Automatic tiling window manager for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/ianyh/Amethyst/releases/latest'><img src='https://img.shields.io/github/v/release/ianyh/Amethyst?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/ianyh/Amethyst'><img src='https://img.shields.io/github/stars/ianyh/Amethyst?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/ianyh/Amethyst' alt='License'/>

  **Screenshots:**

  <img src='https://ianyh.com/amethyst/images/missioncontrol-shortcuts.png' width='400' loading='lazy'/>

  <img src='https://ianyh.com/amethyst/images/accessibility-window.png' width='400' loading='lazy'/>

  <img src='https://ianyh.com/amethyst/images/windows.png' width='400' loading='lazy'/>

  </p>
  </details>

- [AppGrid](https://github.com/mjolnirapp/AppGrid) - Grid-based keyboard window manager for macOS. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/mjolnirapp/AppGrid/releases/latest'><img src='https://img.shields.io/github/v/release/mjolnirapp/AppGrid?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mjolnirapp/AppGrid'><img src='https://img.shields.io/github/stars/mjolnirapp/AppGrid?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mjolnirapp/AppGrid' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/sdegutis/AppGrid/master/grid.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/sdegutis/AppGrid/master/sshot.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Desktop Profiles](https://github.com/mamiksik/Desktop-Profiles) - An innovative desktop/window manager for macOS

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/mamiksik/Desktop-Profiles/releases/latest'><img src='https://img.shields.io/github/v/release/mamiksik/Desktop-Profiles?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/mamiksik/Desktop-Profiles'><img src='https://img.shields.io/github/stars/mamiksik/Desktop-Profiles?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/mamiksik/Desktop-Profiles' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/mamiksik/Desktop-Profiles/master/doc_assets/Themes.gif' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/mamiksik/Desktop-Profiles/master/doc_assets/iTerm.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Hammerspoon](https://github.com/Hammerspoon/hammerspoon) - Staggeringly powerful macOS desktop automation with Lua.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/Lua-16.png' alt='Lua icon' title='Lua' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/Hammerspoon/hammerspoon/releases/latest'><img src='https://img.shields.io/github/v/release/Hammerspoon/hammerspoon?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/Hammerspoon/hammerspoon'><img src='https://img.shields.io/github/stars/Hammerspoon/hammerspoon?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/Hammerspoon/hammerspoon' alt='License'/>

  </p>
  </details>

- [Ice](https://github.com/jordanbaird/Ice) - Ice is a versatile menu bar manager that goes beyond hiding and showing items to offer a rich set of productivity features.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/jordanbaird/Ice/releases/latest'><img src='https://img.shields.io/github/v/release/jordanbaird/Ice?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jordanbaird/Ice'><img src='https://img.shields.io/github/stars/jordanbaird/Ice?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jordanbaird/Ice' alt='License'/>

  **Website:** [https://icemenubar.app/](https://icemenubar.app/)

  **Screenshots:**

  <img src='https://icemenubar.app/gallery/ice-bar.png' width='400' loading='lazy'/>

  <img src='https://icemenubar.app/gallery/menu-bar-item-search.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Phoenix](https://github.com/kasper/phoenix) - Lightweight macOS window and app manager scriptable with JavaScript. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/kasper/phoenix/releases/latest'><img src='https://img.shields.io/github/v/release/kasper/phoenix?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/kasper/phoenix'><img src='https://img.shields.io/github/stars/kasper/phoenix?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/kasper/phoenix' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/kasper/phoenix/master/assets/screenshot.gif' width='400' loading='lazy'/>

  </p>
  </details>

- [Rectangle](https://github.com/rxhanson/Rectangle) - Rectangle is a window manager heavily based on Spectacle, written in Swift.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/swift-16.png' alt='Swift icon' title='Swift' height='16'/> 

  **Links:** <a href='https://github.com/rxhanson/Rectangle/releases/latest'><img src='https://img.shields.io/github/v/release/rxhanson/Rectangle?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/rxhanson/Rectangle'><img src='https://img.shields.io/github/stars/rxhanson/Rectangle?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/rxhanson/Rectangle' alt='License'/>

  **Website:** [https://rectangleapp.com](https://rectangleapp.com)

  </p>
  </details>

- [ShiftIt](https://github.com/fikovnik/ShiftIt) - Managing windows size and position. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/fikovnik/ShiftIt/releases/latest'><img src='https://img.shields.io/github/v/release/fikovnik/ShiftIt?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/fikovnik/ShiftIt'><img src='https://img.shields.io/github/stars/fikovnik/ShiftIt?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/fikovnik/ShiftIt' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/fikovnik/ShiftIt/develop/artwork/ShiftIt.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/fikovnik/ShiftIt/develop/docs/schreenshot-menu.png' width='400' loading='lazy'/>

  <img src='https://raw.githubusercontent.com/fikovnik/ShiftIt/develop/ShiftIt/AccessibilitySettingsMaverick.png' width='400' loading='lazy'/>

  </p>
  </details>

- [Slate](https://github.com/jigish/slate) - Slate is a window management application similar to Divvy and SizeUp

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/jigish/slate/releases/latest'><img src='https://img.shields.io/github/v/release/jigish/slate?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/jigish/slate'><img src='https://img.shields.io/github/stars/jigish/slate?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/jigish/slate' alt='License'/>

  </p>
  </details>

- [Spectacle](https://github.com/eczarny/spectacle) - Spectacle allows you to organize your windows without using a mouse. 

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/eczarny/spectacle/releases/latest'><img src='https://img.shields.io/github/v/release/eczarny/spectacle?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/eczarny/spectacle'><img src='https://img.shields.io/github/stars/eczarny/spectacle?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/eczarny/spectacle' alt='License'/>

  </p>
  </details>

- [Yabai](https://github.com/koekeishiya/yabai) - A tiling window manager for macOS based on binary space partitioning.

  <details>
  <summary>More</summary>
  <p>

  **Languages:** <img src='./icons/c-16.png' alt='C icon' title='C' height='16'/> <img src='./icons/objective-c-16.png' alt='Objective-C icon' title='Objective-C' height='16'/> 

  **Links:** <a href='https://github.com/koekeishiya/yabai/releases/latest'><img src='https://img.shields.io/github/v/release/koekeishiya/yabai?display_name=tag&sort=semver' alt='Latest Release'/></a> &nbsp; <a href='https://github.com/koekeishiya/yabai'><img src='https://img.shields.io/github/stars/koekeishiya/yabai?style=social' alt='GitHub stars'/></a> &nbsp; <img src='https://img.shields.io/github/license/koekeishiya/yabai' alt='License'/>

  **Screenshots:**

  <img src='https://raw.githubusercontent.com/koekeishiya/yabai/master/assets/screenshot.png' width='400' loading='lazy'/>

  </p>
  </details>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

<div align="right"><a href="#contents">⬆️ Back to Top</a></div>

## Contributors

Thanks to all the people who contribute:

<a href="https://github.com/serhii-londar/open-source-mac-os-apps/graphs/contributors"><img src="https://opencollective.com/open-source-mac-os-apps/contributors.svg?width=890&button=false" /></a>

[app_store]: ./icons/app_store-16.png 'App Store.'
[c_icon]: ./icons/c-16.png 'C language.'
[cpp_icon]: ./icons/cpp-16.png 'C++ language.'
[c_sharp_icon]: ./icons/csharp-16.png 'C# Language'
[clojure_icon]: ./icons/clojure-16.png 'Clojure Language'
[coffee_script_icon]: ./icons/coffeescript-16.png 'CoffeeScript language.'
[css_icon]: ./icons/css-16.png 'CSS language.'
[go_icon]: ./icons/golang-16.png 'Go language.'
[elm_icon]: ./icons/elm-16.png 'Elm Language'
[haskell_icon]: ./icons/haskell-16.png 'Haskell language.'
[java_icon]: ./icons/java-16.png 'Java language.'
[javascript_icon]: ./icons/javascript-16.png 'JavaScript language.'
[lua_icon]: ./icons/Lua-16.png 'Lua language.'
[objective_c_icon]: ./icons/objective-c-16.png 'Objective-C language.'
[python_icon]: ./icons/python-16.png 'Python language.'
[ruby_icon]: ./icons/ruby-16.png 'Ruby language.'
[rust_icon]: ./icons/rust-16.png 'Rust language.'
[shell_icon]: ./icons/shell-16.png 'Shell language.'
[swift_icon]: ./icons/swift-16.png 'Swift language.'
[typescript_icon]: ./icons/typescript-16.png 'TypeScript language.'