# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project you agree to abide by its terms.

---

Ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- Don't open a Draft / WIP pull request while you work on the guidelines. A pull request should be 100% ready and should adhere to all the guidelines when you open it.
- Make an individual pull request for each suggestion.
- The pull request title should be in the following format: `Add Project Name`
	- `Add` not `add`
- The suggestion should be in English.
- Use the following format: `[Title](link) - Description.`
- Additions should be added to the bottom of the relevant category.
- If the submitted project is an open-source project on GitHub:
	- It should have at least 20 stars.
	- Link to the GitHub repo, not its website.
- Keep descriptions short and simple, but descriptive.
	- The description should not be a marketing tagline.
	- The description should not be title-case.
	- The description should not repeat the item title.
	- The description should start with a capital and end with a full stop/period.
- Check your spelling and grammar. You can use ChatGPT for this!
- Make sure your text editor is set to remove trailing whitespace.
- New categories or improvements to the existing categorization are welcome, but should be done in a separate pull request.

Thank you for your suggestion!

### Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult. If the maintainers notice anything that we'd like changed, we'll ask you to edit your PR before we merge it. If you're not sure how to do that, [here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) on the different ways you can update your PR so that we can merge it.
