<div align="center">
	<br>
	<br>
	<div>
		<picture>
			<source media="(prefers-color-scheme: dark)" srcset="media/logo-dark.svg">
			<img alt="Awesome ChatGPT" width="500px" src="media/logo.svg">
		</picture>
		<br>
	</div>
	<p>
		<a href="https://chat.openai.com">ChatGPT</a> is an artificial intelligence (AI) chatbot developed by <a href="https://openai.com">OpenAI</a>
	</p>
	<br>
	<a href="https://awesome.re">
		<img src="https://awesome.re/badge-flat2.svg" alt="Awesome">
	</a>
	<br>
	<br>
	<br>
	<hr>
	<p>
		<p>
			<sup>
				<a href="https://github.com/sponsors/sindresorhus">My open source work is supported by the community</a>
			</sup>
		</p>
		<sup>Special thanks to:</sup>
		<br>
		<br>
		<a href="https://nitric.io/?utm_campaign=github_repo&utm_medium=referral&utm_content=sindresorhus&utm_source=github">
			<div>
				<img width="230" src="https://sindresorhus.com/assets/thanks/nitric-logo.svg" alt="nitric logo">
			</div>
			<b>Effortless backends with infrastructure from code</b>
			<div>
				<sup>An open-source framework that supports any programming language, cloud provider, or deployment automation tool.</sup>
			</div>
		</a>
		<br>
	</p>
	<hr>
	<br>
	<br>
</div>

## Contents

- [Official](#official)
- [Apps](#apps)
- [Web apps](#web-apps)
- [Browser extensions](#browser-extensions)
- [CLI tools](#cli-tools)
- [Bots](#bots)
- [Integrations](#integrations)
- [Packages](#packages)
- [Articles](#articles)
- [Community](#community)
- [Related lists](#related-lists)

## Official

- [Website](https://chat.openai.com)
- [Introduction](https://openai.com/blog/chatgpt)

## Apps

- [QuickGPT](https://sindresorhus.gumroad.com/l/quickgpt) - Access the ChatGPT web UI from the menu bar, Dock, or using a keyboard shortcut on macOS.
- [MacGPT](https://www.macgpt.com) - Native macOS app with a global prompt and also a web UI wrapper.
- [Chatterbox](https://manuelkehl.gumroad.com/l/chatterbox) - Native macOS app that can be shown with a keyboard shortcut.
- [WriteMage](https://writemage.com) - Native macOS app to use ChatGPT in any app. ($)
- [PaletteBrain](https://palettebrain.com) - Native macOS app to use ChatGPT in any app. ($)
- [Machato](https://untimelyunicorn.gumroad.com/l/machato) - Native macOS app. ($)
- [wonderGPT](https://wondergpt.co) - Native macOS app with a focus on simplicity.
- [Petey](https://apps.apple.com/app/id6446047813) - Native iOS and watchOS app. ($)
- [IntelliBar](https://intellibar.app) - macOS app that can be shown with a keyboard shortcut. ($ · Electron)
- [Ask AI](https://sindresorhus.com/ask-ai) - Native watchOS app. ($)
- [Chat Answer](https://github.com/bapaws/answer) - Native iOS and Android app.
- [Chat AI Desktop App](https://github.com/sonnylazuardi/chat-ai-desktop) - Cross-platform web UI wrapper.
- [ChatGPT Desktop Application](https://github.com/lencx/ChatGPT) - Cross-platform web UI wrapper. (Electron)
- [ChatGPT Android](https://github.com/skydoves/chatgpt-android) - Native Android app.
- [ChatARKit](https://github.com/trzy/ChatARKit) - iOS app for creating AR experiences with natural language.
- [Delphi ChatGPT](https://github.com/HemulGM/ChatGPT) - Native cross-platform app.
- [Chatbox](https://github.com/Bin-Huang/chatbox) - Cross-platform app.
- [Short Circuit](https://apps.apple.com/app/id1638522784) - Native iOS and macOS app with support for Siri, Shortcuts, and more. ($)
- [ChatBoost](https://play.google.com/store/apps/details?id=studio.muggle.chatboost) - Native Android app with support for Azure voice, custom prompts, and more. ($)
- [Developer Duck](https://apps.apple.com/app/id1662283032) - Native developer-focused macOS app with Xcode plugin and command line support. ($)
- [Hello History](https://hellohistory.ai) - Chat with historical figures on iOS and Android. ($)
- [Actions](https://github.com/sindresorhus/Actions) - Use ChatGPT from the Shortcuts app on iOS and macOS.
- [EasyChat AI](https://easychat-ai.app) - Native Windows app using the latest Windows 11 design lanquage.
- [pgMagic](https://pgmagic.app) - macOS app that lets you query your PostgreSQL database using natural language. ($)
- [Atua](https://atua.app) - macOS app to use ChatGPT in any app. ($)
- [16x Prompt](https://prompt.16x.engineer) - Cross-platform app to add source code and formatting instructions into prompt for coding tasks. ($)
- [AI Chat](https://www.chatbar.top) - Cross-platform app that provides quick access to chatbots like ChatGPT from the menu bar. (Electron)
- [ScreenSnapAI](https://screensnap.ai) - Native macOS app to chat about captured screenshots. ($)
- [QChatGPT](https://github.com/timamus/QChatGPT) - ChatGPT cross-platform client made with the Quasar framework. (Electron)

## Web apps

### Hosted and self-hosted

- [ShareGPT](https://github.com/domeccleston/sharegpt) - Share permanent links to ChatGPT conversations.
- [Anse](https://github.com/anse-app/anse) - Alternative ChatGPT web UI.
- [chatbot-ui](https://github.com/mckaywrigley/chatbot-ui) - Alternative ChatGPT web UI.
- [ChatGPT Next Web](https://github.com/Yidadaa/ChatGPT-Next-Web) - Alternative ChatGPT web UI.
- [roomGPT](https://github.com/Nutlope/roomGPT) - Generate your dream room.
- [DocsGPT](https://github.com/arc53/DocsGPT) - Documentation assistant.
- [promptsandbox](https://github.com/eg9y/promptsandbox.io) - Visual programming tool for experimenting with ChatGPT.
- [Adrenaline](https://github.com/shobrook/adrenaline/) - Talk to your codebase.
- [DeepWrite AI](https://github.com/simplysabir/AI-Writing-Assistant) - Blog post generator.
- [Chat with GPT](https://github.com/cogentapps/chat-with-gpt) - Open-source ChatGPT web app with a voice.
- [FastChat](https://github.com/lm-sys/FastChat) - An open platform for training, serving, and evaluating large language model based chatbots.
- [kindle-gpt](https://github.com/mckaywrigley/kindle-gpt) - Search and chat on your Kindle highlights.
- [eslint-gpt](https://github.com/ycjcl868/eslint-gpt) - Generate ESLint rules from example code.
- [chatgpt-i18n](https://github.com/ObservedObserver/chatgpt-i18n) - Localize your websites.
- [AgentGPT](https://github.com/reworkd/AgentGPT) - Autonomous AI agents in your browser.
- [OP Vault ChatGPT](https://github.com/pashpashpash/vault-ai) - Give ChatGPT long-term memory using the OP Stack (OpenAI + Pinecone Vector Database).
- [chatgpt-demo](https://github.com/anse-app/chatgpt-demo) - Minimal web UI for ChatGPT.
- [pdfGPT](https://github.com/bhaskatripathi/pdfGPT) - Interactive conversations with the contents of PDF files.
- [Chat Chat](https://github.com/okisdev/ChatChat) - Your own unified AI interface.
- [VLog](https://github.com/showlab/VLog) - Convert videos to documents.
- [Ask-Anything](https://github.com/OpenGVLab/Ask-Anything) - ChatGPT with video understanding and communication.
- [TaskMatrix](https://github.com/microsoft/TaskMatrix) - Combines ChatGPT with Visual Models for enhanced image-chat interactions.
- [OpenChat](https://github.com/openchatai/OpenChat) - Personalized ChatGPT chatbot.
- [gpt-code-ui](https://github.com/ricklamers/gpt-code-ui) - Code interpreter integrated with ChatGPT.
- [ai-chatbot](https://github.com/vercel-labs/ai-chatbot) - Personalized ChatGPT AI chatbot.
- [Open Interpreter](https://github.com/KillianLucas/open-interpreter) - Code interpreter with ChatGPT.
- [Web3-GPT](https://github.com/Markeljan/Web3GPT) - Deploy smart contracts with ChatGPT.
- [Opik](https://github.com/comet-ml/opik) - Open-source end-to-end LLM development platform.
- [OpenAgents](https://github.com/xlang-ai/OpenAgents) - Open-source replicate of ChatGPT Plus products including code interpreter, plugins and web browsing.

### Hosted

- [TypingMind](https://www.typingmind.com) - Alternative web UI.
- [ChatKit](https://chatkit.app) - Refined ChatGPT UI with support for plugins and accessing external resources.
- [Humata.ai](https://www.humata.ai) - Ask anything about your files.
- [Epic Music Quiz](https://epicmusicquiz.com) - Create your own custom music video quiz.
- [FlexGPT](https://flexgpt.io) - Like ChatGPT but for pros, with long-term memory, internet access, unlimited GPT-4, and no subscription.
- [LearnGPT](https://learngpt.art) - Title-based book creation. ($)
- [Wielded](https://wielded.com) - Web UI that works for OpenAI, Azure, Anthropic, and AWS Bedrock. Free for individuals.
- [Price Per Token](https://pricepertoken.com) - Compare LLM API pricing across providers. Includes token counter and cost calculator.

### Self-hosted

- [Auto-GPT](https://github.com/Significant-Gravitas/Auto-GPT) - An experimental open-source attempt to make GPT-4 fully autonomous.
- [ChatGPT-Paper-Reader](https://github.com/talkingwallace/ChatGPT-Paper-Reader) - Read and summarize academic papers.
- [Sidekick](https://github.com/ai-sidekick/sidekick) - Connect external data to ChatGPT APIs through a dashboard.
- [twitterbio](https://github.com/Nutlope/twitterbio) - Generate your Twitter bio.
- [Beelzebub](https://github.com/mariocandela/beelzebub) - Secure honeypot framework.

### Examples

- [ChatGPT-Python-Applications](https://github.com/xiaowuc2/ChatGPT-Python-Applications) - A collection of Python web apps.

## Browser extensions

- [ChatGPT for Google](https://chatgpt4google.com) - Display ChatGPT response alongside search engine results.
- [ChatGPT Prompt Genius](https://github.com/benf2004/ChatGPT-Prompt-Genius) - Discover, share, import, and use the best prompts for ChatGPT.
- [ChatGPT Box](https://github.com/josStorer/chatGPTBox) - Deep ChatGPT integrations in your browser.
- [ChatGPT Export and Share](https://github.com/liady/ChatGPT-pdf) - Download your ChatGPT history to PNG, PDF or a sharable link.
- [Superpower ChatGPT](https://chrome.google.com/webstore/detail/superpower-chatgpt/amhmeenmapldpjdedekalnfifgnpfnkc) - Enhance the ChatGPT web UI with search history, create folders, export all chats, pin messages, and access thousands of prompts.
- [chatgpt-google-summary-extension](https://github.com/sparticleinc/chatgpt-google-summary-extension) - Display ChatGPT summaries alongside Google search results, YouTube videos, etc.
- [FancyGPT](https://chrome.google.com/webstore/detail/fancygpt/meonalmakdjaojaoipfhahcfccoecegk) - Save and share beautiful ChatGPT snippets as images, PDFs, and text files.
- [WritingMate.ai](https://chrome.google.com/webstore/detail/writingmateai-1-chatgpt-a/iihamopomflffiecicbgelncanmfionp) - Writing assistant.
- [Summarize](https://github.com/clmnin/summarize.site) - Summarize websites.
- [WebChatGPT](https://github.com/qunash/chatgpt-advanced/) - Enable web access in ChatGPT.
- [ChatGPT for Chrome & YouTube Summary](https://chrome.google.com/webstore/detail/chatgpt-for-chrome-youtub/cdjifpfganmhoojfclednjdnnpooaojb) - Access ChatGPT from the Chrome toolbar, see transcripts of YouTube videos, and summarize YouTube videos.
- [ChatGPT Enhancement Extension](https://github.com/sailist/chatgpt-enhancement-extension) - Enhancements to the ChatGPT web UI.
- [ChassistantGPT](https://github.com/idosal/assistant-chat-gpt) - Chrome browser extension that embeds ChatGPT as a hands-free voice assistant.
- [Talk-to-ChatGPT](https://github.com/C-Nedelcu/talk-to-chatgpt) - Talk with ChatGPT using your voice and listen to answers.
- [ChatGPT for Google Colab](https://github.com/ali-h-kudeir/ChatGPT-Google-Colab) - Embed ChatGPT inside Google Colab.
- [codereview.gpt](https://github.com/sturdy-dev/codereview.gpt) - Reviews your pull requests.
- [GPT2Markdown](https://github.com/0xreeko/gpt2markdown) - Export your ChatGPT conversations to Markdown.
- [ChatGPT Widescreen Mode](https://github.com/adamlui/chatgpt-widescreen) - Adds widescreen and fullscreen mode to ChatGPT.
- [ChatGPT Infinity](https://github.com/adamlui/chatgpt-infinity) - Makes ChatGPT automatically answer random questions to increase your knowledge.
- [Meeper](https://github.com/pas1ko/meeper) - Transcriptions, summary and more using ChatGPT and Whisper AI for meetings and any browser tab.
- [YouTube Summary by TubeSum](https://chromewebstore.google.com/detail/tubesum/hkhihfjmjgledkdhmlohldmpnolcoabm) - Summarize YouTube videos.
- [SwiftStyle AI](https://github.com/swiftstyleai/swiftstyleai) - An open-source Chrome extension that customizes content to match your unique style and brand voice.

**User scripts**

- [ChatGPT Exporter](https://github.com/pionxzh/chatgpt-exporter) - Export and share ChatGPT conversation history.
- [KeepChatGPT](https://github.com/xcanwin/KeepChatGPT/blob/main/README_EN.md) - Fixes common networks errors and problems with ChatGPT.
- [Autoclear ChatGPT History](https://github.com/adamlui/autoclear-chatgpt-history) - Auto-clear ChatGPT conversation history for increased privacy.
- [ChatGPT Auto Refresh](https://github.com/adamlui/chatgpt-auto-refresh) - Keeps ChatGPT sessions fresh to avoid network errors and Cloudflare checks.
- [ChatGPT Auto-Continue](https://github.com/adamlui/chatgpt-auto-continue) - Automatically clicks "Continue generating" when responses are cut off.

**Bookmarklets**

- [Conversation Saving](https://github.com/jcubic/chat-gpt) - Save your ChatGPT conversation.
- [ChatGPT Export](https://github.com/yaph/chatgpt-export) - Export ChatGPT conversations to Markdown files.

## CLI tools

- [Assistant CLI](https://github.com/diciaup/assistant-cli) - Use ChatGPT from the command-line.
- [SearchGPT](https://github.com/tobiasbueschel/search-gpt) - Connect ChatGPT with the Internet.
- [chatgpt-conversation](https://github.com/platelminto/chatgpt-conversation) - Have a conversation with ChatGPT.
- [CLI for ChatGPT](https://github.com/j178/chatgpt) - Interactive interface for ChatGPT.
- [chat-gpt-ppt](https://github.com/williamfzc/chat-gpt-ppt) - Automatically generate PowerPoint presentations.
- [StackExplain](https://github.com/shobrook/stackexplain) - Have your error messages explained in plain English.
- [clevercli](https://github.com/clevercli/clevercli) - ChatGPT-powered command-line utilities.
- [README-AI](https://github.com/eli64s/README-AI) - Automatically generate README files.
- [aicommits](https://github.com/Nutlope/aicommits) - Automatically generate Git commit messages.
- [happycommit](https://github.com/jackbackes/happycommit) - Automatically generate Git commit messages.
- [commit-assist](https://github.com/dejorrit/commit-assist) - Automatically generate Git commit messages.
- [cz-git](https://github.com/Zhengqbbb/cz-git) - Automatically generate Git commit messages.
- [ai-commit](https://github.com/guanguans/ai-commit) - Automatically generate conventional Git commit messages.
- [gptcommit](https://github.com/zurawiki/gptcommit) - Git hook for authoring commit messages.
- [autodoc](https://github.com/context-labs/autodoc) - Automatically generate codebase documentation.
- [GPT3 WordPress Post Generator](https://github.com/nicolaballotta/gpt3-wordpress-post-generator) - Generate WordPress blog posts.
- [aiac](https://github.com/gofireflyio/aiac) - Infrastructure-as-Code generator.
- [tenere](https://github.com/pythops/tenere) - Terminal interface (TUI) for ChatGPT written in Rust.
- [shellChatGPT](https://github.com/mountaineerbr/shellChatGPT) - Use ChatGPT from the command-line.
- [Shell Genie](https://github.com/dylanjcastillo/shell-genie) - Interact with the terminal in plain English.
- [ShellGPT](https://github.com/TheR1D/shell_gpt) - Use ChatGPT from the command-line.
- [chatGPT-shell-cli](https://github.com/0xacx/chatGPT-shell-cli) - Use ChatGPT from the command-line. Shell script.
- [aifiles](https://github.com/jjuliano/aifiles) - Organize and manage your files using AI.

## Bots

- [chatgpt-twitter-bot](https://github.com/transitive-bullshit/chatgpt-twitter-bot) - Twitter bot.
- [chatgpt-telegram-bot-serverless](https://github.com/franalgaba/chatgpt-telegram-bot-serverless) - Telegram bot.
- [chatgpt-telegram](https://github.com/m1guelpf/chatgpt-telegram) - Telegram bot.
- [myGPTReader](https://github.com/madawei2699/myGPTReader) - Slack bot.
- [ChatGPTSlackBot](https://github.com/pedrorito/ChatGPTSlackBot) - Slack bot.
- [ChatGPT Discord Bot](https://github.com/Zero6992/chatGPT-discord-bot) - Discord bot.
- [chatgpt-discord](https://github.com/m1guelpf/chatgpt-discord) - Discord bot.
- [kubernetes-chatgpt-bot](https://github.com/robusta-dev/kubernetes-chatgpt-bot) - Kubernetes bot.
- [CodeReview Bot](https://github.com/anc95/ChatGPT-CodeReview) - GitHub Actions bot.
- [openai-pr-reviewer](https://github.com/fluxninja/openai-pr-reviewer) - GitHub Actions bot.
- [chatgpt-create-unit-tests](https://github.com/zebroc/chatgpt-create-unit-tests) - GitHub Actions bot that analyses a pull request and adds unit tests if necessary.
- [gpt4-pdf-chatbot-langchain](https://github.com/mayooear/gpt4-pdf-chatbot-langchain) - Chatbot for large PDF files.
- [wechat-chatgpt](https://github.com/fuergaosi233/wechat-chatgpt) - Wechat bot.
- [chatgpt-telegram-bot](https://github.com/karfly/chatgpt_telegram_bot) - Telegram bot that supports voice messages.
- [DuckDuckGPT](https://github.com/kudoai/duckduckgpt) - DuckDuckGo bot.
- [BraveGPT](https://github.com/kudoai/bravegpt) - Brave Search bot.
- [GoogleGPT](https://www.googlegpt.io) - Google Search bot.

## Integrations

- [chatgpt-raycast](https://github.com/abielzulio/chatgpt-raycast) - Raycast extension.
- [mpociot/chatgpt-vscode](https://github.com/mpociot/chatgpt-vscode) - VSCode extension.
- [gencay/vscode-chatgpt](https://github.com/gencay/vscode-chatgpt) - VSCode extension.
- [org-ai](https://github.com/rksm/org-ai) - Emacs org-mode.
- [vim-chatgpt](https://github.com/CoderCookE/vim-chatgpt) - Vim plugin.
- [ChatGPT.nvim](https://github.com/jackMort/ChatGPT.nvim) - Neovim plugin.
- [ChatGPT Jetbrains](https://github.com/dromara/ChatGPT) - Jetbrains plugin.
- [DocGPT](https://workspace.google.com/u/0/marketplace/app/docgpt_ai_writer_for_docs/466607203252) - Writing assistant for Google Docs.
- [docGPT](https://github.com/cesarhuret/docGPT) - Use ChatGPT in Google Docs.
- [SlidesAI](https:/www.slidesai.io) - Create AI-powered presentations in Google Slides.
- [WordGPT](https://github.com/filippofinke/WordGPT) - Use ChatGPT in Microsoft Word.
- [Add ChatGPT to Microsoft Word](https://github.com/analyticsinmotion/add-chatgpt-to-microsoft-word) - How to integrate ChatGPT with Microsoft Word.
- [Open Assistant Helper](https://github.com/AnotiaWang/open-assistant-helper) - Improve Open Assistant with ChatGPT.
- [ChatGPTWizard](https://github.com/AliDehbansiahkarbon/ChatGPTWizard) - Embarcadero RAD Studio (Delphi & C++ Builder) plugin.
- [AICommand](https://github.com/keijiro/AICommand) - ChatGPT integration with Unity Editor.
- [AI Shader](https://github.com/keijiro/AIShader) - ChatGPT-powered shader generator for Unity.
- [Translate GPT](https://github.com/ftp27/fastlane-plugin-translate_gpt) - A fastlane plugin that provides an action to translate localizable strings using ChatGPT.
- [PandasAI](https://github.com/gventuri/pandas-ai) - Integrate ChatGPT capabilities into Pandas.
- [Plus AI for Google Slides](https://www.plusdocs.com/plus-ai-for-google-slides) - Create AI-powered presentations in Google Slides.
- [Scikit-LLM](https://github.com/iryna-kondr/scikit-llm) - Integrate ChatGPT capabilities into scikit-learn.
- [ChatGPT-MD](https://github.com/bramses/chatgpt-md) - ChatGPT integration with Obsidian note-taking software.
- [Chapyter](https://github.com/chapyter/chapyter) - Integrate ChatGPT capabilities into Jupyter Notebook.
- [I Don't Care About Commit Message](https://github.com/mefengl/vscode-i-dont-care-about-commit-message) - Auto-generate commit messages and push actions in VS Code.
- [Python Smart Exceptions](https://github.com/roma-guru/smart-exceptions) - AI-powered Python exceptions debugging.
- [TextCraft](https://github.com/suncloudsmoon/TextCraft) - AI-powered Word add-in for text generation and proofreading.

## Packages

### API clients

- [Swift](https://github.com/MacPaw/OpenAI)
- [Node.js](https://github.com/transitive-bullshit/chatgpt-api)
- [Go](https://github.com/AlmazDelDiablo/gpt3-5-turbo-go)
- [Delphi](https://github.com/HemulGM/DelphiOpenAI)
- [PHP](https://github.com/openai-php/client)
- [Ruby](https://github.com/alexrudall/ruby-openai)

### JavaScript

- [chatgpt.js](https://github.com/kudoai/chatgpt.js) - Easy interaction with the ChatGPT DOM.
- [Vercel AI SDK](https://github.com/vercel-labs/ai) - An open source library for building AI-powered user interfaces.
- [llm-ui](https://github.com/llm-ui-kit/llm-ui) - An open source library for building UIs for LLMs.

### Python

- [GPTCache](https://github.com/zilliztech/GPTCache) - Semantic cache to store responses from LLM queries.
- [knowledge-gpt](https://github.com/geeks-of-data/knowledge-gpt) - Extract knowledge from information sources.

### Go

- [doctorgpt](https://github.com/ingyamilmolinar/doctorgpt) - Diagnosing web app log errors with ChatGPT.

## Articles

- [Create your first app using ChatGPT](https://genez.io/blog/create-your-first-app-using-chatgpt/) - Learn how to build an app that enables users to improve their writing by rephrasing text.
- [Stream data from ChatGPT with JavaScript](https://umaar.com/dev-tips/269-web-streams-openai/) - Learn how to consume streaming data from ChatGPT using vanilla JavaScript.

## Community

- [Reddit](https://www.reddit.com/r/ChatGPT/)
- [Discord](https://discord.com/invite/openai)

## Related lists

- [awesome-chatgpt-prompts](https://github.com/f/awesome-chatgpt-prompts) - Prompt curation.
- [awesome-whisper](https://github.com/sindresorhus/awesome-whisper) - Whisper is an AI-powered speech recognition system.
