# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project you agree to abide by its terms.

---

Ensure your pull request adheres to the following guidelines:

- **The submitted project should be more than 30 days old and the repo should have at least 100 stars.**
- The intent of this list is to gather awesome packages *that most users would need*. This is not the place for niche things, except in the “Mad science” category.
- Don't open a Draft / WIP pull request while you work on the guidelines. A pull request should be 100% ready and should adhere to all the guidelines when you open it.
- Keep in mind that the list is very mature by now, so the bar of getting something accepted is high. Only submit something unique and generally useful. The world (and this list) doesn't need yet another ORM or framework. For CLI tools, the bar is especially high, and unless it's something very awesome, I would suggest submitting to [awesome-cli-apps](https://github.com/aharris88/awesome-cli-apps) instead.
- Boilerplates are not accepted as most boilerplates are too opinionated and low-quality and I don't have time to comment on everything they need to improve.
- SDKs and deploy tools for SaaS' are not accepted.
- If you submit a project that is similar to an existing project in the list, argue how it's better.
- Search previous suggestions before making a new one, as yours may be a duplicate.
- Suggested packages should be tested and documented.
- Make an individual pull request for each suggestion.
- Use the following format: `[package](link) - Description.`
- Additions should be added to the bottom of the relevant category.
- Link to the GitHub repo, not npmjs.com or its website.
- Keep descriptions short and simple, but descriptive.
- Descriptions should not be marketing taglines.
- Descriptions should not be title-case.
- Don't mention `Node.js` in the description as it's implied.
- Start the description with a capital and end with a full stop/period.
- Don't start the description with `A` or `An`.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- The pull request should have a useful title and include a link to the package and why it should be included.
- New categories or improvements to the existing categorization are welcome, but should be done in a separate pull request.

Thank you for your suggestion!

### Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult. If the maintainers notice anything that we'd like changed, we'll ask you to edit your PR before we merge it. If you're not sure how to do that, [here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) on the different ways you can update your PR so that we can merge it.
