# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project you agree to abide by its terms.

### Comments

If you have consumed any of the content here, please add a comment if you think it is awesome. This especially applies if the content has no comments. Please use the format:

```
Commentary. - [@you](https://github.com/you)
```

Thanks!

### New Suggestions

Please ensure your pull request adheres to the following guidelines:

- You should have consumed the content you're suggesting. If you haven't, open an issue to see if anyone has.
- The entry should contain the title and author links, first publication year, rating, description and your personal commentary.
  - For books, please copy the description and rating from [Goodreads](https://goodreads.com) and link to the Goodreads entry.
  - For movies and TV shows, please copy the description and rating from [IMDb](https://www.imdb.com) and link to the IMDb entry.
- Use the following format:

```
[title](link) (year) *by [author](link)* [rating]

Commentary - [@you](https://github.com/you)

<details>
  <summary>Description</summary>

  > Summary of book/film etc here
</details>

* Note the formatting (spaces etc) for "Description" above!
```

- Check your spelling and grammar.
- Please add the entry in the correct section, in alphabetical order. If you don't know what section your entry should go in, just throw it in the general Science Fiction section. Categories for TV shows and movies can be grabbed from the IMDB page.
- The author link should point to the author's [Wikipedia](https://en.wikipedia.org) page. If no such page exists, it should point to the author's [Goodreads](https://goodreads.com) page. If that doesn't exist either, please leave the author name in plain text instead of a link.
- Please add your name to your commentary, so we know who made it.
- Start the description with a capital and end with a full stop/period.
- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make an individual pull request for each suggestion.
- The pull request and commit should have a useful title.
- Pull Requests without a personal comment will not be accepted until one is added.
- If you are adding a movie, please add categories as you see fit, using inline code ticks to mark different categories, in this format:

```
Categories: `ai` `action` `not about batman`
```

Thank you for your suggestion!

### Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult. If the maintainers notice anything that we'd like changed, we'll ask you to edit your PR before we merge it. If you're not sure how to do that, [here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) on the different ways you can update your PR so that we can merge it.
