# Awesome Sci-Fi [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> Sci-Fi worth consuming

I [asked on Twitter](https://twitter.com/sindresorhus/status/557586610850897920) for recommendations as I want to get into reading Sci-Fi novels. The below is the result. Thanks everyone for recommending your favorites! :)

_For fantasy books, see [awesome-fantasy](https://github.com/RichardLitt/awesome-fantasy)._

![](https://cloud.githubusercontent.com/assets/170270/7630100/242bda3a-fa33-11e4-881a-589cffa0c421.gif)

## Contents

- [Novels](#novels)
  - [Science Fiction](#science-fiction)
  - [Hard Science Fiction](#hard-science-fiction)
  - [Cyberpunk](#cyberpunk)
  - [Utopia](#Utopia)
  - [Dystopia](#dystopia)
  - [Space Opera](#space-opera)
  - [Post Apocalyptic](#post-apocalyptic)
  - [Military Science Fiction](#military-science-fiction)
  - [Police Procedural Science Fiction](#police-procedural-science-fiction)
  - [Techno Thriller](#techno-thriller)
  - [Fantasy](#fantasy)
  - [Drama](#drama)
  - [Biopunk](#biopunk)
  - [Speculative Fiction](#speculative-fiction)
  - [Time Travel](#time-travel)
  - [Comedy](#comedy)
  - [Horror](#horror)
- [Short Story Collections](#short-story-collections)
- [Movies](#movies)
- [Movie Series](#movie-series)
- [TV Series](#tv-series)
- [Comic Books](#comic-books)
- [Audiobooks](#audiobooks)
- [Links](#links)

## Novels

🌟 means that it's a classic.

🔥 means that it has more than 100 000 ratings on Goodreads.

_The `[number]` at the end is the rounded version of the rating on Goodreads._

### Science Fiction

#### [Accelerando](https://www.goodreads.com/book/show/17863.Accelerando) (2005) _by [Charles Stross](https://en.wikipedia.org/wiki/Charles_Stross)_ [3.9]

Accelerando is an excellent exploration of Posthumanism. It's my go to recommendation for people wanting to read about that stuff. - [@erbridge](https://github.com/erbridge)

It's also worth mentioning that [the ebook is available for free in a variety of formats on Stross's website](https://www.antipope.org/charlie/blog-static/fiction/accelerando/accelerando-intro.html). - [@AlexKeyes](https://github.com/alex-keyes)

<details>
  <summary>Description</summary>

  > The Singularity. It is the era of the posthuman. Artificial intelligences have surpassed the limits of human intellect. Biotechnological beings have rendered people all but extinct. Molecular nanotechnology runs rampant, replicating and reprogramming at will. Contact with extraterrestrial life grows more imminent with each new day.
  >
  > Struggling to survive and thrive in this accelerated world are three generations of the Macx clan: Manfred, an entrepreneur dealing in intelligence amplification technology whose mind is divided between his physical environment and the Internet; his daughter, Amber, on the run from her domineering mother, seeking her fortune in the outer system as an indentured astronaut; and Sirhan, Amber's son, who finds his destiny linked to the fate of all of humanity.
  >
  > For something is systemically dismantling the nine planets of the solar system. Something beyond human comprehension. Something that has no use for biological life in any form.
</details>

#### [Babel-17](https://www.goodreads.com/book/show/1199688.Babel_17) (1966) _by [Samuel R. Delany](https://en.wikipedia.org/wiki/Samuel_R._Delany)_ [3.8]

This intense linguistic thriller will change the way you think about language. - [@helderroem](https://github.com/helderroem)

<details>
  <summary>Description</summary>

  > Babel-17 is all about the power of language. Humanity, which has spread throughout the universe, is involved in a war with the Invaders, who have been covertly assassinating officials and sabotaging spaceships. The only clues humanity has to go on are strange alien messages that have been intercepted in space. Poet and linguist Rydra Wong is determined to understand the language and stop the alien threat.
</details>

#### [Barsoom series](https://www.goodreads.com/series/43942-barsoom) (1912-1927) _by [Edgar Rice Burroughs](https://en.wikipedia.org/wiki/Edgar_Rice_Burroughs)_ [3.8] 🌟

Now more than a century old, has that unique writing style you can only find in adventure classics. - [@uraimo](https://github.com/uraimo)

Books:

- [A Princess of Mars](https://www.goodreads.com/book/show/40395.A_Princess_of_Mars) [3.8]
- [The Gods of Mars](https://www.goodreads.com/book/show/841973.The_Gods_of_Mars) [3.8]
- [The Warlord of Mars](https://www.goodreads.com/book/show/40379.The_Warlord_of_Mars) [3.8]
- [Thuvia, Maid of Mars](https://www.goodreads.com/book/show/40387.Thuvia_Maid_of_Mars) [3.7]
- [The Chessmen of Mars](https://www.goodreads.com/book/show/40378.The_Chessmen_of_Mars) [3.7]
- [The Master Mind of Mars](https://www.goodreads.com/book/show/40385.The_Master_Mind_of_Mars) [3.8]
- [A Fighting Man of Mars](https://www.goodreads.com/book/show/40386.A_Fighting_Man_of_Mars) [3.8]
- [Swords of Mars](https://www.goodreads.com/book/show/40376.Swords_of_Mars) [4.0]
- [Synthetic Men of Mars](https://www.goodreads.com/book/show/40384.Synthetic_Men_of_Mars) [3.8]
- [Llana of Gathol](https://www.goodreads.com/book/show/215954.Llana_of_Gathol) [3.7]
- [John Carter of Mars](https://www.goodreads.com/book/show/40388.John_Carter_of_Mars) [3.8]

<details>
  <summary>Description</summary>

  > Barsoom is planet Mars from American Edgar Rice Burroughs. First serialized as Under the Moons of Mars in 1912, published as A Princess of Mars in 1917. Dying Mars was based on outdated scientific ideas of canals. The savage, frontier world has honor, noble sacrifice and constant struggle, where martial prowess is paramount and races fight over dwindling resources.
  
</details>

#### [Bobiverse Series](https://www.goodreads.com/book/show/32109569-we-are-legion-we-are-bob) (2016) _by [Dennis E. Taylor](https://www.goodreads.com/author/show/12130438.Dennis_E_Taylor)_ [4.35]

Like Accelerando, this series is an excellent exploration of posthumanism. It also has themes of space exploration, references to various other series, and is all around a great amount of fun to read. It's also free if you have kindle unlimited. - [@AlexKeyes](https://github.com/alex-keyes)

<details>
  <summary>Description</summary>

  > Bob Johansson has just sold his software company and is looking forward to a life of leisure. There are places to go, books to read, and movies to watch. So it's a little unfair when he gets himself killed crossing the street.
  >
  > Bob wakes up a century later to find that corpsicles have been declared to be without rights, and he is now the property of the state. He has been uploaded into computer hardware and is slated to be the controlling AI in an interstellar probe looking for habitable planets. The stakes are high: no less than the first claim to entire worlds. If he declines the honor, he'll be switched off, and they'll try again with someone else. If he accepts, he becomes a prime target. There are at least three other countries trying to get their own probes launched first, and they play dirty.
  >
  > The safest place for Bob is in space, heading away from Earth at top speed. Or so he thinks. Because the universe is full of nasties, and trespassers make them mad - very mad.
</details>

#### [Childhood’s End](https://www.goodreads.com/book/show/414999.Childhood_s_End) (1953) _by [Arthur C. Clarke](https://en.wikipedia.org/wiki/Arthur_C._Clarke)_ [4.0]

This book is interesting for its view of what a golden age of mankind would look like, and what would the shortcomings of that be. It also has a very interesting take on mass psychology - I don't want to give away too much, but the Overlords are a nifty bunch. This is a good early Clarke, and has two of his favorite themes; the first that remote work will be possible with technology, and the second that any sufficiently advanced technology is indistinguishable from magic. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Without warning, giant silver ships from deep space appear in the skies above every major city on Earth. Manned by the Overlords, in fifty years, they eliminate ignorance, disease, and poverty. Then this golden age ends—and then the age of Mankind begins…
</details>

#### [Cities in Flight](https://www.goodreads.com/book/show/141805.Cities_in_Flight) (1970) _by [James Blish](https://en.wikipedia.org/wiki/James_Blish)_ [4.0]

This is a long book, but absolutely fantastic. It redefined for me the scale at which science fiction was possible, especially given the human elements are very fleshed out (as opposed to other massive space epics, like Olaf Stapledon's 'Last and First Men'). A brilliant look at the future, going off of only two small changes - what if we had drugs to defeat death, and cities could fly. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Originally published in four volumes nearly fifty years ago, _Cities in Flight_ brings together the famed “Okie novels” of science fiction master James Blish. Named after the migrant workers of America’s Dust Bowl, these novels convey Blish’s “history of the future,” a brilliant and bleak look at a world where cities roam the Galaxy looking for work and a sustainable way of life.
  >
  > In the first novel, _They Shall Have Stars_, man has thoroughly explored the Solar System, yet the dream of going even further seems to have died in all but one man. His battle to realize his dream results in two momentous discoveries anti-gravity and the secret of immortality. In _A Life for the Stars_, it is centuries later and antigravity generations have enabled whole cities to lift off the surface of the earth to become galactic wanderers. In _Earthman, Come Home_, the nomadic cities revert to barbarism and marauding rogue cities begin to pose a threat to all civilized worlds. In the final novel, _The Triumph of Time_, history repeats itself as the cities once again journey back in to space making a terrifying discovery which could destroy the entire Universe. A serious and haunting vision of our world and its limits, _Cities in Flight_ marks the return to print of one of science fiction’s most inimitable writers.
</details>

#### [Contact](https://www.goodreads.com/book/show/61666.Contact) (1985) _by [Carl Sagan](https://en.wikipedia.org/wiki/Carl_Sagan)_ [4.1]

Based on Sagan's own studies as an astrophysicist and philosopher, Contact provides a possible glimpse of the world's reaction to extraterrestrial life - @augustopedro

<details>
  <summary>Description</summary>

  > At first it seemed impossible - a radio signal that came not from Earth but from far beyond the nearest stars. But then the signal was translated, and what had been impossible became terrifying. For the signal contains the information to build a Machine that can travel to the stars. A Machine that can take a human to meet those that sent the message. They are eager to meet us: they have been watching and waiting for a long time. And now they will judge.
</details>

#### [Dark Matter](https://www.goodreads.com/book/show/27833670-dark-matter) (2016) _by [Blake Crouch](https://en.wikipedia.org/wiki/Blake_Crouch)_ [4.1] 🔥

An interesting take on the possibility of the multiverse, Schrödinger's cat, and how every choice, big or small, has led to this exact moment. - [@thedeany](https://github.com/thedeany)

<details>
  <summary>Description</summary>

  > Jason Dessen is walking home through the chilly Chicago streets one night, looking forward to a quiet evening in front of the fireplace with his wife, Daniela, and their son, Charlie—when his reality shatters.
  >
  > It starts with a man in a mask kidnapping him at gunpoint, for reasons Jason can’t begin to fathom—what would anyone want with an ordinary physics professor?—and grows even more terrifying from there, as Jason’s abductor injects him with some unknown drug and watches while he loses consciousness.
  >
  > When Jason awakes, he’s in a lab, strapped to a gurney—and a man he’s never seen before is cheerily telling him “welcome back!”
  >
  > Jason soon learns that in this world he’s woken up to, his house is not his house. His wife is not his wife. His son was never born.
  >
  > And someone is hunting him.
</details>

#### [Doorways in the Sand](https://www.goodreads.com/book/show/61998.Doorways_in_the_Sand) (1976) _by [Roger Zelazny](https://en.wikipedia.org/wiki/Roger_Zelazny)_ [4.0]

What a weird, funny and lovely little book. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Fred Cassidy, a perpetual student, scrounger, and acrophile, is the last known person to have seen an important stone that his friend had. Various criminals, Anglophile zealots, government agents and aliens torture, shoot, beat, trick, chase, terrorize, assault telepathically, stalk, and importune Fred in attempts to get him to tell them the location of the stone. He denies any knowledge of its whereabouts, and decides to make his own investigation.
</details>

#### [Dune Chronicles](https://www.goodreads.com/series/45935-dune-chronicles) (1963-1994) _by [Frank Herbert](https://en.wikipedia.org/wiki/Frank_Herbert)_ [4.1] 🌟 🔥

I think what is most fascinating about Dune isn't that it is so commonly read, but the ubiquity with which it is referenced. Once you read this, you start seeing Dune quotes everywhere. Dune is monumental in scope, and the cautionary tone in which it was written - this is what happens when you put faith in a single person trained scientifically - almost completely backfires in an amazing story of heroism, revenge, and reconciliation. A book worth reading multiple times. Of course, it is also a series - the first stands alone, and I haven't read beyond the first two. There almost isn't a need. Dune alone is that good. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Set in the far future amidst a sprawling feudal interstellar empire where planetary dynasties are controlled by noble houses that owe an allegiance to the imperial House Corrino, _Dune_ tells the story of young Paul Atreides (the heir apparent to Duke Leto Atreides and heir of House Atreides) as he and his family accept control of the desert planet Arrakis, the only source of the “spice” melange, the most important and valuable substance in the cosmos. The story explores the complex, multilayered interactions of politics, religion, ecology, technology and human emotion, as the forces of the empire confront each other for control of Arrakis.
  >
  > Published in 1965, it won the Hugo Award in 1966 and the inaugural Nebula Award for Best Novel. _Dune_ is frequently cited as the world’s best-selling SF novel.
</details>

#### [Embassytown](https://www.goodreads.com/book/show/9265453-embassytown) (2011) _by [China Miéville](https://en.wikipedia.org/wiki/China_Mi%C3%A9ville)_ [3.8]

<details>
  <summary>Description</summary>

  > In the far future, humans have colonized a distant planet, home to the enigmatic Ariekei, sentient beings famed for a language unique in the universe, one that only a few altered human ambassadors can speak.
  >
  > Avice Benner Cho, a human colonist, has returned to Embassytown after years of deep-space adventure. She cannot speak the Ariekei tongue, but she is an indelible part of it, having long ago been made a figure of speech, a living simile in their language.
  >
  > When distant political machinations deliver a new ambassador to Arieka, the fragile equilibrium between humans and aliens is violently upset. Catastrophe looms, and Avice is torn between competing loyalties—to a husband she no longer loves, to a system she no longer trusts, and to her place in a language she cannot speak yet speaks through her.
</details>

#### [Expanse](https://www.goodreads.com/series/56399-expanse) (2011-2021) _by [James S.A. Corey](https://en.wikipedia.org/wiki/James_S._A._Corey)_ [4.17 (avg)]

A series comprised (as of 2019) of eight full-length novels with a total of nine entries planned. Several shorts not relevant to the main plot also exist. Notable for this series is the attention to detail regarding the actual physics involved in space travel and the challenges of daily life outside a friendly biosphere. The narrative, which is told from the changing perspectives of a cast of diverse characters, offers a healthy mix of humor and suspension, making it an entertaining read. - [@jpkempf](https://github.com/jpkempf)

The books are real page turners with its mix of high politics, space battles, ancient mysteries, day-to-day grit and cultural differences, and the world Expanse starts out with really changes over the course of the books. You may find book four (Cibola Burn) a bit slow, but keep at it, subsequent books really pay dividends. - [@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > Humanity has colonized the solar system - Mars, the Moon, the Asteroid Belt and beyond - but the stars are still out of our reach.
  >
  > Jim Holden is XO of an ice miner making runs from the rings of Saturn to the mining stations of the Belt. When he and his crew stumble upon a derelict ship, "The Scopuli," they find themselves in possession of a secret they never wanted. A secret that someone is willing to kill for - and kill on a scale unfathomable to Jim and his crew. War is brewing in the system unless he can find out who left the ship and why.
</details>

Books:
- [Leviathan Wakes](https://www.goodreads.com/book/show/8855321-leviathan-wakes) [4.2] 🔥
- [Caliban's War](https://www.goodreads.com/book/show/12591698-caliban-s-war) [4.3] 🔥
- [Abaddon's Gate](https://www.goodreads.com/book/show/16131032-abaddon-s-gate) [4.2]
- [Cibola Burn](https://www.goodreads.com/book/show/18656030-cibola-burn) [4.2]
- [Nemesis Games](https://www.goodreads.com/book/show/22886612-nemesis-games) [4.4]
- [Babylon's Ashes](https://www.goodreads.com/book/show/25877663-babylon-s-ashes) [4.2]
- [Persepolis Rising](https://www.goodreads.com/book/show/34600958-persepolis-rising) [4.3]
- [Tiamat's Wrath](https://www.goodreads.com/book/show/28335698-tiamat-s-wrath) [4.5]
- [Leviathan Falls](https://www.goodreads.com/book/show/28335699-leviathan-falls) [4.5]

#### [Flatland](https://www.goodreads.com/book/show/433567.Flatland) (1884) _by [Edwin A. Abbott](https://en.wikipedia.org/wiki/Edwin_Abbott_Abbott)_ [3.8] 🌟

This book will teach you to stretch your imagination and see things in a different way. - [@elssar](https://github.com/elssar)

<details>
  <summary>Description</summary>

  > This masterpiece of science (and mathematical) fiction is a delightfully unique and highly entertaining satire that has charmed readers for more than 100 years. The work of English clergyman, educator and Shakespearean scholar Edwin A. Abbott (1838-1926), it describes the journeys of A. Square, a mathematician and resident of the two-dimensional Flatland, where women—thin, straight lines—are the lowliest of shapes, and where men may have any number of sides, depending on their social status.
  >
  > Through strange occurrences that bring him into contact with a host of geometric forms, Square has adventures in Spaceland (three dimensions), Lineland (one dimension) and Pointland (no dimensions) and ultimately entertains thoughts of visiting a land of four dimensions—a revolutionary idea for which he is returned to his two-dimensional world. Charmingly illustrated by the author, Flatland is not only fascinating reading, it is still a first-rate fictional introduction to the concept of the multiple dimensions of space. “Instructive, entertaining, and stimulating to the imagination.” — _Mathematics Teacher_
</details>

#### [Flowers for Algernon](https://www.goodreads.com/book/show/18373.Flowers_for_Algernon) (1959) _by [Daniel Keyes](https://en.wikipedia.org/wiki/Daniel_Keyes)_ [4.0] 🌟 🔥

This book is often given to high school students, but stands up well as an adult read. I think the best part about it is what Charlie does once he starts being intelligent; he suddenly likes art and making things and scientific theory. I think the altruism and openness of that time shows that the experiment, such as it was, didn't change everything. It's fun to think about. Also, this book made me cry the first time I read it. I was 25. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > With more than five million copies sold, _Flowers for Algernon_ is the beloved, classic story of a mentally disabled man whose experimental quest for intelligence mirrors that of Algernon, an extraordinary lab mouse. In poignant diary entries, Charlie tells how a brain operation increases his IQ and changes his life. As the experimental procedure takes effect, Charlie’s intelligence expands until it surpasses that of the doctors who engineered his metamorphosis. The experiment seems to be a scientific breakthrough of paramount importance—until Algernon begins his sudden, unexpected deterioration. Will the same happen to Charlie?
</details>

#### [Foundation Trilogy]([https://www.goodreads.com/book/show/29579.Foundation](https://www.goodreads.com/series/59386-foundation-publication-order)) (1951) _by [Isaac Asimov](https://en.wikipedia.org/wiki/Isaac_Asimov)_ [4.22 (avg)] 🌟 🔥

Isaac Asimov's original "Foundation Trilogy" is a mesmerizing voyage into the realm of science fiction, presenting a grand game of 4D chess spread over centuries, propelled by the innovative concept of 'psychohistory'. Its thought-provoking exploration of power, control, and inevitability underscores its status as a seminal piece in the pantheon of sci-fi literature. - [@edoardodanna](https://github.com/edoardodanna)

<details>
  <summary>Description</summary>

  > For twelve thousand years the Galactic Empire has ruled supreme. Now it is dying. But only Hari Sheldon, creator of the revolutionary science of psychohistory, can see into the future—to a dark age of ignorance, barbarism, and warfare that will last thirty thousand years. To preserve knowledge and save mankind, Seldon gathers the best minds in the Empire—both scientists and scholars—and brings them to a bleak planet at the edge of the Galaxy to serve as a beacon of hope for a future generations. He calls his sanctuary the Foundation.
  >
  > But soon the fledgling Foundation finds itself at the mercy of corrupt warlords rising in the wake of the receding Empire. Mankind’s last best hope is faced with an agonizing choice: submit to the barbarians and be overrun—or fight them and be destroyed.
</details>

Books:
- [Foundation](https://www.goodreads.com/book/show/29579.Foundation) [4.2] 🔥
- [Foundation and Empire](https://www.goodreads.com/book/show/29581.Foundation_and_Empire) [4.2] 🔥
- [Second Foundation](https://www.goodreads.com/book/show/29580.Second_Foundation) [4.3] 🔥

#### [Frankenstein; or, The Modern Prometheus](https://www.goodreads.com/book/show/18490.Frankenstein) (1818) _by [Mary Wollstonecraft Shelley](https://en.wikipedia.org/wiki/Mary_Shelley)_ [3.7] 🌟 🔥

Archetypal tale of mad science with the theme of 'how far can Science go' that arguably spawned the modern genre of Science Fiction. - [@katamaritaco](https://github.com/katamaritaco)

<details>
  <summary>Description</summary>

  > Mary Shelley began writing Frankenstein when she was only eighteen. At once a Gothic thriller, a passionate romance, and a cautionary tale about the dangers of science, Frankenstein tells the story of committed science student Victor Frankenstein. Obsessed with discovering the cause of generation and life and bestowing animation upon lifeless matter, Frankenstein assembles a human being from stolen body parts but; upon bringing it to life, he recoils in horror at the creature's hideousness. Tormented by isolation and loneliness, the once-innocent creature turns to evil and unleashes a campaign of murderous revenge against his creator, Frankenstein.
  >
  > Frankenstein, an instant bestseller and an important ancestor of both the horror and science fiction genres, not only tells a terrifying story, but also raises profound, disturbing questions about the very nature of life and the place of humankind within the cosmos: What does it mean to be human? What responsibilities do we have to each other? How far can we go in tampering with Nature? In our age, filled with news of organ donation genetic engineering, and bioterrorism, these questions are more relevant than ever.
</details>

#### [Glasshouse](https://www.goodreads.com/book/show/17866.Glasshouse) (2006) _by [Charles Stross](https://en.wikipedia.org/wiki/Charles_Stross)_ [3.8]

<details>
  <summary>Description</summary>

  > When Robin wakes up in a clinic with most of his memories missing, it doesn’t take him long to discover that someone is trying to kill him. It’s the twenty-seventh century, when interstellar travel is by teleport gate and conflicts are fought by network worms that censor refugees’ personalities and target historians. The civil war is over and Robin has been demobilized, but someone wants him out of the picture because of something his earlier self knew.
  >
  > On the run from a ruthless pursuer and searching for a place to hide, he volunteers to participate in a unique experimental polity, the Glasshouse, constructed to simulate a pre-accelerated culture. Participants are assigned anonymized identities: It looks like the ideal hiding place for a posthuman on the run. But in this escape-proof environment, Robin will undergo an even more radical change, placing him at the mercy of the experimenters—and at the mercy of his own unbalanced psyche…
</details>

#### [Home Fires](https://www.goodreads.com/book/show/8694515-home-fires) (2011) _by [Gene Wolfe](https://en.wikipedia.org/wiki/Gene_Wolfe)_ [3.3]

This is a pretty good book. Like later Gene Wolfe books, it reads a bit dry, and the main character is sometimes one sided. But the context and the fleshed out world entirely make up for it, as does Gene Wolfe's standard of never mentioning an important detail more than once as a foreshadowing. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Gene Wolfe takes us to a future North America at once familiar and utterly strange. A young man and woman, Skip and Chelle, fall in love in college and marry, but she is enlisted in the military, there is a war on, and she must serve her tour of duty before they can settle down. But the military is fighting a war with aliens in distant solar systems, and her months in the service will be years in relative time on Earth. Chelle returns to recuperate from severe injuries, after months of service, still a young woman but not necessarily the same person—while Skip is in his forties and a wealthy businessman, but eager for her return.
  >
  > Still in love (somewhat to his surprise and delight), they go on a Caribbean cruise to resume their marriage. Their vacation rapidly becomes a complex series of challenges, not the least of which are spies, aliens, and battles with pirates who capture the ship for ransom. There is no writer in SF like Gene Wolfe and no SF novel like _Home Fires_.
</details>

#### [Jean le Flambeur Series](https://www.goodreads.com/series/57134-jean-le-flambeur) (2010, 2012, 2014) _by [Hannu Rajaniemi](https://en.wikipedia.org/wiki/Hannu_Rajaniemi)_ [4.0 (avg)]

<details>
  <summary>Description</summary>

  > Jean le Flambeur gets up in the morning and has to kill himself before his other self can kill him first. Just another day in the Dilemma Prison. Rescued by the mysterious Mieli and her flirtatious spacecraft, Jean is taken to the Oubliette, the Moving City of Mars, where time is a currency, memories are treasures, and a moon-turned-singularity lights the night. Meanwhile, investigator Isidore Beautrelet, called in to investigate the murder of a chocolatier, finds himself on the trail of an arch-criminal, a man named le Flambeur…
</details>

#### [Jem](https://www.goodreads.com/book/show/591572.Jem) (1979) _by [Frederik Pohl](https://en.wikipedia.org/wiki/Frederik_Pohl)_ [3.6]

This book has a few beautiful passages. It deals mainly with the ethics of using alien species for nationalistic purposes, and for that alone was an interesting read. Like a lot of science fiction, I found it a bit hard to empathize with any particular characters, but it's a short read and worth it anyway. The politics are a bit dated. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > The discovery of another habitable world might spell salvation to the three bitterly competing power blocs of the resource-starved 21st century; but when their representatives arrive on Jem, with its multiple intelligent species, they discover instead the perfect situation into which to export their rivalries. Subtitled, with savage irony, “_The Making of a Utopia_”, Jem is one of Frederik Pohl’s most powerful novels.
</details>

#### [Lord of Light](https://www.goodreads.com/book/show/13821.Lord_of_Light) (1967) _by [Roger Zelazny](https://en.wikipedia.org/wiki/Roger_Zelazny)_ [4.1]

This was like if Hermann Hesse decided he was tired of writing Steppenwolf and Siddhartha and wanted to do something interesting for a change. What a weird book. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Earth is long since dead. On a colony planet, a band of men has gained control of technology, made themselves immortal, and now rule their world as the gods of the Hindu pantheon. Only one dares oppose them: he who was once Siddhartha and is now Mahasamatman. Binder of Demons, Lord of Light.
</details>

#### [Planet Wizard](https://www.goodreads.com/book/show/11796889-the-planet-wizard) (1969) _by [John Jakes](https://en.wikipedia.org/wiki/John_Jakes)_ [3.3]

This book has a banger name. The story of a conman wizard who's not really a wizard, forced to travel to another planet in order to exorcize the demons of a ruined sister planet. John Jakes is more well known for his historical fiction, so it's interesting to read his take on a different genre. - [@just-an-e](https://github.com/just-an-e)

<details>
  <summary>Description</summary>

  > On a post-apocalyptic world far from Earth, Magus Blacklaw, a traveling mountebank, is in trouble with the law. He and his daughter soon fall in with a young man, and pretty soon all three are condemned to ride a skysled to exorcize the demons of a formerly commercial sister planet.
</details>

#### [Red Dwarf](https://www.goodreads.com/book/show/70956.Red_Dwarf_Omnibus) (1989) _by [Grant Naylor](https://en.wikipedia.org/wiki/Grant_Naylor)_ [4.3]

Actually four books by two authors. Based on the TV series of the same name, but the books should be consumed instead. Very high quality over the top deep space trouble with anti-hero Lister and his crew. - [@montao](https://github.com/montao)

<details>
  <summary>Description</summary>

  > ...three million years from Earth, marooned in the wrong dimension of the wrong reality, and down to his last two cigarettes.
</details>

#### [Remembrance of Earth's Past Trilogy](https://www.goodreads.com/series/189931-remembrance-of-earth-s-past) (2014-2016) _by [Liu Cixin](https://en.wikipedia.org/wiki/Liu_Cixin)_

Although each part can be read independently, the whole trilogy has a consistent story line which happens in a very huge time-space context and the first just a beginning. The later two are especially much more hardcore and dramatical, however, gloomy as well. While the first one got the Hugo Award, I'd like to say that it really worth a try for the whole trilogy, don't miss the later two. - [@cp4](https://github.com/cp4)

Books:
- [The Three-Body Problem](https://www.goodreads.com/book/show/20518872-the-three-body-problem) [4.0] 🔥
- [The Dark Forest](https://www.goodreads.com/book/show/23168817-the-dark-forest) [4.4]
- [Death's End](https://www.goodreads.com/book/show/25451264-death-s-end) [4.4]

##### [The Three Body Problem](https://www.goodreads.com/book/show/20518872-the-three-body-problem) (2014) [4.0]

This book is not just filled to the brim with interesting and novel ideas about technology and civilization, it also offers some really great insights into China and its recent history. 

<details>
  <summary>Description</summary>

  > Set against the backdrop of China’s Cultural Revolution, a secret military project sends signals into space to establish contact with aliens. An alien civilization on the brink of destruction captures the signal and plans to invade Earth. Meanwhile, on Earth, different camps start forming, planning to either welcome the superior beings and help them take over a world seen as corrupt, or to fight against the invasion. The result is a science fiction masterpiece of enormous scope and vision.
</details>

##### [The Dark Forest](https://www.goodreads.com/book/show/23168817-the-dark-forest) (2015) [4.4]

<details>
  <summary>Description</summary>

  > In The Dark Forest, Earth is reeling from the revelation of a coming alien invasion — four centuries in the future. The aliens' human collaborators have been defeated but the presence of the sophons, the subatomic particles that allow Trisolaris instant access to all human information, means that Earth's defense plans are exposed to the enemy. Only the human mind remains a secret.
</details>

##### [Death's End](https://www.goodreads.com/book/show/25451264-death-s-end) (2016) [4.4]

<details>
  <summary>Description</summary>

  > Now this epic trilogy concludes with Death's End. Half a century after the Doomsday Battle, the uneasy balance of Dark Forest Deterrence keeps the Trisolaran invaders at bay. Earth enjoys unprecedented prosperity due to the infusion of Trisolaran knowledge. With human science advancing daily and the Trisolarans adopting Earth culture, it seems that the two civilizations will soon be able to co-exist peacefully as equals without the terrible threat of mutually assured annihilation. But the peace has also made humanity complacent.
</details>

#### [Rendezvous with Rama](https://www.goodreads.com/book/show/112537.Rendezvous_with_Rama) (1973) _by [Arthur C. Clarke](https://en.wikipedia.org/wiki/Arthur_C._Clarke)_ [4.0]

This book is filled with a quiet suspense that is almost palpable; in that, it does an extraordinary job of showing how humans respond to alien encounters. The otherworldliness of Rama isn't always interesting, but the reaction of the reader to it is. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > At first, only a few things are known about the celestial object that astronomers dub Rama. It is huge, weighing more than ten trillion tons. And it is hurtling through the solar system at an inconceivable speed. Then a space probe confirms the unthinkable: Rama is no natural object. It is, incredibly, an interstellar spacecraft. Space explorers and planet-bound scientists alike prepare for mankind’s first encounter with alien intelligence. It will kindle their wildest dreams… and fan their darkest fears. For no one knows who the Ramans are or why they have come. And now the moment of rendezvous awaits—just behind a Raman airlock door.
</details>

#### [Roadside Picnic](https://www.goodreads.com/book/show/331256.Roadside_Picnic) (1972) _by [Arkady Strugatsky & Boris Strugatsky](https://en.wikipedia.org/wiki/Arkady_and_Boris_Strugatsky)_ [4.2]

Twitter user: One of the best books I have ever read.

<details>
  <summary>Description</summary>

  > Red Schuhart is a stalker, one of those strange misfits compelled to venture illegally into the Zone and collect the strange artifacts that the alien visitors left scattered there. His whole life, even the nature of his daughter, is determined by the Zone.
</details>

#### [Solaris](https://www.goodreads.com/book/show/95558.Solaris) (1961) _by [Stanisław Lem](https://en.wikipedia.org/wiki/Stanis%C5%82aw_Lem)_ [3.9] 🌟

<details>
  <summary>Description</summary>

  > A classic work of science fiction by renowned Polish novelist and satirist Stanisław Lem.
  >
  > When Kris Kelvin arrives at the planet Solaris to study the ocean that covers its surface, he finds a painful, hitherto unconscious memory embodied in the living physical likeness of a long-dead lover. Others examining the planet, Kelvin learns, are plagued with their own repressed and newly corporeal memories. The Solaris ocean may be a massive brain that creates these incarnate memories, though its purpose in doing so is unknown, forcing the scientists to shift the focus of their quest and wonder if they can truly understand the universe without first understanding what lies within their hearts.
</details>

#### [Space Trilogy: Out of the Silent Planet, Perelandra, and That Hideous Strength](https://www.goodreads.com/book/show/30628.Out_of_the_Silent_Planet_Perelandra_That_Hideous_Strength?ac=1) _by [C. S. Lewis](https://en.wikipedia.org/wiki/C._S._Lewis)_ [4.1]

##### [Out of the Silent Planet](https://www.goodreads.com/book/show/25350.Out_of_the_Silent_Planet) (1938) _by [C. S. Lewis](https://en.wikipedia.org/wiki/C._S._Lewis)_ [3.9]

A fairly well-wrapped first book in a trilogy, that has some very imaginative and well worked through takes on what Martian life may have looked like at the time. I love the imagery, and the theology isn't as worked through everything as the other books. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In the first novel of C. S. Lewis’s classic science fiction trilogy, Dr. Ransom, a Cambridge academic, is abducted and taken on a spaceship to the red planet of Malacandra, which he knows as Mars. His captors are plotting to plunder the planet’s treasures and plan to offer Ransom as a sacrifice to the creatures who live there. Ransom discovers he has come from the “silent planet”–Earth–whose tragic story is known throughout the universe…
</details>

##### [Perelandra](https://www.goodreads.com/book/show/100924.Perelandra) (1944) _by [C. S. Lewis](https://en.wikipedia.org/wiki/C._S._Lewis)_ [4.0]

This book has a wonderful look at non-technological space travel and what paradise might look like on another planet. Lots of good philosophy, too. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > The second novel in Lewis’s science fiction trilogy tells of Dr. Ransom’s voyage to the planet of Perelandra (Venus). Dr. Ransom is sent by the Elida to Perelandra (Venus) to battle against evil incarnate and preserve a second Eden from the evil forces present in the possessed body of his enemy, Weston. Through these works, Lewis explores issues of good and evil, and his remarkable and vividly imaginative descriptions of other worlds cements his place as a first-class author of science fiction adventure.
</details>

##### [That Hideous Strength](https://www.goodreads.com/book/show/100933.That_Hideous_Strength) (1945) _by [C. S. Lewis](https://en.wikipedia.org/wiki/C._S._Lewis)_ [3.9]

One of the weirdest books I have read and enjoyed. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > The third novel in the science-fiction trilogy by C. S. Lewis. This final story is set on Earth, and tells of a terrifying conspiracy against humanity. The story surrounds Mark and Jane Studdock, a newly married couple. Mark is a sociologist who is enticed to join an organization called N.I.C.E. which aims to control all human life. His wife, meanwhile, has bizarre prophetic dreams about a decapitated scientist, Alcasan. As Mark is drawn inextricably into the sinister organization, he discovers the truth of his wife’s dreams when he meets the literal head of Alcasan which is being kept alive by infusions of blood. Jane seeks help concerning her dreams at a community called St. Anne’s, where she meets their leader—Dr. Ransom (the main character of the previous two titles in the trilogy). The story ends in a final spectacular scene at the N.I.C.E. headquarters where Merlin appears to confront the powers of Hell.
</details>

#### [Speaker for the Dead](https://www.goodreads.com/book/show/7967.Speaker_for_the_Dead) (1994) _by [Orson Scott Card](https://en.wikipedia.org/wiki/Orson_Scott_Card)_ [4.0]

I had been putting off reading this book for years, after reading _Ender's Game_ and not knowing wanting to belittle it with a bad sequel (like I thought _Ender's Shadow_ had been). I regret that immensely, having now read this book; it is deep, insightful, and brilliantly written. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In the aftermath of his terrible war, Ender Wiggin disappeared, and a powerful voice arose: the Speaker for the Dead, who told of the true story of the Bugger War.
  >
  > Now long years later, a second alien race has been discovered, but again the aliens’ ways are strange and frightening…again, humans die. And it is only the Speaker for the Dead, who is also Ender Wiggin the Xenocide, who has the courage to confront the mystery…and the truth.
</details>

#### [Spin](https://www.goodreads.com/book/show/910863.Spin) (2005) _by [Robert Charles Wilson](https://en.wikipedia.org/wiki/Robert_Charles_Wilson)_ [4.0]

<details>
  <summary>Description</summary>

  > One night in October when he was ten years old, Tyler Dupree stood in his back yard and watched the stars go out. They all flared into brilliance at once, then disappeared, replaced by a flat, empty black barrier. He and his best friends, Jason and Diane Lawton, had seen what became known as the Big Blackout. It would shape their lives.
  >
  > Life on Earth is about to get much, much stranger.
</details>

#### [Stand on Zanzibar](https://www.goodreads.com/book/show/41069.Stand_on_Zanzibar) (1968) _by [John Brunner](https://en.wikipedia.org/wiki/John_Brunner_%28novelist%29)_ [4.0]

This book was written about 2010, and what the world would be like when the world is over populated. It is still very pertinent today, especially given the style of writing, which seems to have too much information packed in than needed. 'Muckers', the idea of people who go crazy without reason due to overcrowdedness, are a really interesting concept given the rise in anti-terrorist rhetoric in recent years. - [@RichardLitt](https://github.com/RichardLitt)
<details>
  <summary>Description</summary>

  > Norman Niblock House is a rising executive at General Technics, one of a few all-powerful corporations. His work is leading General Technics to the forefront of global domination, both in the marketplace and politically—it’s about to take over a country in Africa. Donald Hogan is his roommate, a seemingly sheepish bookworm. But Hogan is a spy, and he’s about to discover a breakthrough in genetic engineering that will change the world… and kill him. These two men’s lives weave through one of science fiction’s most praised novels. Written in a way that echoes John Dos Passos’ _U.S.A._ trilogy, _Stand on Zanzibar_ is a cross-section of a world overpopulated by the billions. Where society is squeezed into hive-living madness by god-like mega computers, mass-marketed psychedelic drugs, and mundane uses of genetic engineering. Though written in 1968, it speaks of 2010, and is frighteningly prescient and intensely powerful.
</details>

#### [Star Maker](https://www.goodreads.com/book/show/525304.Star_Maker) (1937) _by [Olaf Stapledon](https://en.wikipedia.org/wiki/Olaf_Stapledon)_ [3.9] 🌟

If you're going to read one Science Fiction book to get a broader perspective on what it means to be human and the size of space and time, read this one. It blew me away. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > _Star Maker_ is a science fiction novel by Olaf Stapledon, published in 1937. The book describes a history of life in the universe, dwarfing in scale Stapledon’s previous book, _Last and First Men_ (1930), a history of the human species over two billion years. _Star Maker_ tackles philosophical themes such as the essence of life, of birth, decay and death, and the relationship between creation and creator. A pervading theme is that of progressive unity within and between different civilizations. Some of the elements and themes briefly discussed prefigure later fiction concerning genetic engineering and alien life forms. Arthur C. Clarke considered _Star Maker_ to be one of the finest works of science fiction ever written.
</details>

#### [The Deep Range](https://www.goodreads.com/book/show/20410412-the-deep-range) (1957) _by [Arthur C. Clarke](https://en.wikipedia.org/wiki/Arthur_C._Clarke)_ [3.7]

This is one of Arthur C. Clarke's novels that is less about space and more about humanity, and the oceans. Clarke lived for a large part of his later life in Sri Lanka, and always loved the sea; in this book, that sentiment really comes out. I love it for that. It also has a nice view of ocean management, which is rare for books set in the future. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A century into the future, humanity lives mostly on the sea. Gigantic whale herds are tended by submariners, and vast plankton farms feed the world.
  >
  > Walter Franklin, once a space engineer, now works on a submarine patrol. This novel tells the story of his adventures, including Franklin’s capture of an enormous kraken at 12,000 feet under the sea; his search for a monstrous sea serpent; and the thrilling rescue of a sunken submarine-all set against the backdrop of a futuristic world that’s both imaginative and believable.
</details>

#### [The Fifth Head of Cerberus](https://www.goodreads.com/book/show/845501.The_Fifth_Head_of_Cerberus) (1972) _by [Gene Wolfe](https://en.wikipedia.org/wiki/Gene_Wolfe)_ [4.0]

This is an incredible book. Absolutely incredible. The first section, about a son of a scientist, is a great example of Wolfe's ability to make the future sound like the Victorian past, and to add decay to what, to our eyes, seems incredibly futuristic. The story about the traveler and the aborigines on Saint Croix is something I think about a lot - "old men think long thoughts", in particular, is a thought that I love, especially given its context. Gene Wolfe also uses the epistolary novel technique incredibly well in the third story. But the best part is how you come to realize that each of these stories is intertwined with the others, subtly. Amazing storytelling. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Gene Wolfe’s _The Fifth Head of Cerberus_ is a universally acknowledged masterpiece of science fiction by one of the field’s most brilliant writers. Far out from Earth, two sister planets, Saint Anne and Saint Croix, circle each other in an eternal dance. It is said a race of shapeshifters once lived here, only to perish when men came. But one man believes they can still be found, somewhere in the back of the beyond.
  >
  > In _The Fifth Head of Cerberus_, Wolfe skillfully interweaves three bizarre tales to create a mesmerizing pattern: the harrowing account of the son of a mad genius who discovers his hideous heritage; a young man’s mythic dreamquest for his darker half; the bizarre chronicle of a scientists’ nightmarish imprisonment. Like an intricate, braided knot, the pattern at last unfolds to reveal astonishing truths about this strange and savage alien landscape.
</details>

#### [The First Fifteen Lives of Harry August](https://www.goodreads.com/book/show/35066358-the-first-fifteen-lives-of-harry-august) (2014) _by [Claire North](https://en.wikipedia.org/wiki/Catherine_Webb) [4.01]

An awesome book. Intriguing ,funny and moving. Never mind the negative reviews...I would have given it a 6th star if I could. - [@naz2001](https://github.com/naz2001)

<details>
  <summary>Description</summary>

  > Some stories cannot be told in just one lifetime. Harry August is on his deathbed. Again. No matter what he does or the decisions he makes, when death comes, Harry always returns to where he began, a child with all the knowledge of a life he has already lived a dozen times before. Nothing ever changes. Until now. As Harry nears the end of his eleventh life, a little girl appears at his bedside. "I nearly missed you, Doctor August," she says. "I need to send a message." This is the story of what Harry does next, and what he did before, and how he tries to save a past he cannot change and a future he cannot allow.
</details>

#### [The Gods Themselves](https://www.goodreads.com/book/show/41821.The_Gods_Themselves) (1972) _by [Isaac Asimov](https://en.wikipedia.org/wiki/Isaac_Asimov)_ [4.1]

<details>
  <summary>Description</summary>

  > In the twenty-second century Earth obtains limitless, free energy from a source science little understands: an exchange between Earth and a parallel universe, using a process devised by the aliens. But even free energy has a price. The transference process itself will eventually lead to the destruction of Earth’s Sun—and of Earth itself.
  >
  > Only a few know the terrifying truth—an outcast Earth scientist, a rebellious alien inhabitant who senses the imminent annihilation of the Sun. They know the truth—but who will listen? They have foreseen the cost of abundant energy—but who will believe? These few beings, human and alien, hold the key to Earth’s survival.
</details>

#### [The Golden Age](https://www.goodreads.com/series/41545-golden-age) (2002, 2003) _by [John C. Wright](https://en.wikipedia.org/wiki/John_C._Wright_%28author%29)_ [4.1]

<details>
  <summary>Description</summary>

  > The Golden Age is 10,000 years in the future in our solar system, an interplanetary utopian society filled with immortal humans.
  >
  > Phaethon, of Radamanthus House, is attending a glorious party at his family mansion celebrating the thousand-year anniversary of the High Transcendence. There he meets an old man who accuses him of being an imposter, and then a being from Neptune who claims to be an old friend. The Neptunian tells him that essential parts of his memory were removed and stored by the very government that Phaethon believes to be wholly honorable. It shakes his faith. Is he indeed an exile from himself? He can’t resist investigating, even though to do so could mean the loss of his inheritance, his very place in society. His quest must be to regain his true identity and fulfill the destiny he chose for himself.
  >
  > _The Golden Age_ is just the beginning of Phaethon’s story, which continues in _The Phoenix Exultant_.
</details>

#### [The Ice People](https://www.goodreads.com/book/show/106753.The_Ice_People) (1968) _by [René Barjavel](https://en.wikipedia.org/wiki/Ren%C3%A9_Barjavel)_ [4.1]

A really good book. Many people have described it as "the best book of Sci-Fi / romance". I would like to see it, one day, as a movie. - [@Gibet](https://github.com/Gibet)

<details>
  <summary>Description</summary>

  > When a French expedition in Antarctica reveals ruins of a 900,000 year old civilization, scientists from all over the world flock to the site to help explore & understand. The entire planet watches via global satellite tv, mesmerized, as they uncover a chamber in which a man & a woman have been in suspended animation since, as the French title suggests, 'the night of time'. The woman, Eléa, is awakened. Thru a translating machine she tells the story of her world, herself & her husband Paikan & how war destroyed her civilization. She also hints at an incredibly advanced knowledge her still-dormant companion possesses, knowledge that could give energy & food to all humans at no cost. But the superpowers of the world are not ready to let Eléa's secrets spread, & show that, 900,000 years & an apocalypse later, humankind has not grown up & is ready to make the same mistakes again.
</details>

#### [The Invisible Man](https://www.goodreads.com/book/show/17184.The_Invisible_Man) (1897) _by [H. G. Wells](https://en.wikipedia.org/wiki/H._G._Wells)_ [3.6] 🌟 🔥

This is more of a read about what happens when you are outside the law than anything else. Fascinating, and kind of reads like Sherlock Holmes at times. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > This masterpiece of science fiction is the fascinating story of Griffin, a scientist who creates a serum to render himself invisible, and his descent into madness that follows.
</details>

#### [The Left Hand of Darkness](https://www.goodreads.com/book/show/18423.The_Left_Hand_of_Darkness) (1969) _by [Ursula Le Guin](https://en.wikipedia.org/wiki/Ursula_K._Le_Guin)_ [4.1]

Ursula Le Guin is an amazing writer, and this is one of her seminal works. It explores sexuality and humanity in ways that I didn't know were possible. I loved it. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A groundbreaking work of science fiction, The Left Hand of Darkness tells the story of a lone human emissary to Winter, an alien world whose inhabitants can choose -and change - their gender. His goal is to facilitate Winter's inclusion in a growing intergalactic civilization. But to do so he must bridge the gulf between his own views and those of the completely dissimilar culture that he encounters.
  >
  > Embracing the aspects of psychology, society, and human emotion on an alien world, The Left Hand of Darkness stands as a landmark achievement in the annals of intellectual science fiction.
</details>

#### [The Long Way to a Small, Angry Planet](https://www.goodreads.com/book/show/22733729-the-long-way-to-a-small-angry-planet) (2014) _by [Becky Chambers](https://en.wikipedia.org/wiki/Becky_Chambers_(author))_ [4.17]

Funny, touching, and full of unexpected details. - [@lgierth](https://github.com/lgierth)

<details>
  <summary>Description</summary>

  > Follow a motley crew on an exciting journey through space—and one adventurous young explorer who discovers the meaning of family in the far reaches of the universe—in this light-hearted debut space opera from a rising sci-fi star.
  >
  > Life aboard the Wayfarer is chaotic and crazy—exactly what Rosemary wants. It’s also about to get extremely dangerous when the crew is offered the job of a lifetime. Tunneling wormholes through space to a distant planet is definitely lucrative and will keep them comfortable for years. But risking her life wasn’t part of the plan. In the far reaches of deep space, the tiny Wayfarer crew will confront a host of unexpected mishaps and thrilling adventures that force them to depend on each other. To survive, Rosemary’s got to learn how to rely on this assortment of oddballs—an experience that teaches her about love and trust, and that having a family isn’t necessarily the worst thing in the universe.
</details>

#### [The Murderbot Diaries](https://www.goodreads.com/series/191900) (2017-) _by [Martha Wells](https://en.wikipedia.org/wiki/Martha_Wells)_ [4.3]

_The Murderbot Diaries_ is a series of novellas, each one around 150 pages starring a human-like android who keeps getting sucked back into adventure after adventure, though it just wants to be left alone, away from humanity and small talk and watch tv series. If you enjoy Ann Leckie's _Imperial Raadch_ series or Iain M. Banks' _Culture_ novels, this series of novellas might be for you. They are light, fun to read but yet still engaging enough to get your synapses fired up. - [@oschrenk](https://github.com/oschrenk)

Books:

- [All Systems Red](https://www.goodreads.com/book/show/32758901-all-systems-red) [4.2]
- [Artificial Condition](https://www.goodreads.com/book/show/36223860-artificial-condition) [4.3]
- [Rogue Protocol](https://www.goodreads.com/book/show/35519101-rogue-protocol) [4.4]
- [Exit Strategy](https://www.goodreads.com/book/show/35519109-exit-strategy) [4.4]

<details>
  <summary>Description</summary>

  > In a corporate-dominated spacefaring future, planetary missions must be approved and supplied by the Company. Exploratory teams are accompanied by Company-supplied security androids, for their own safety. But in a society where contracts are awarded to the lowest bidder, safety isn’t a primary concern.
  >
  > On a distant planet, a team of scientists are conducting surface tests, shadowed by their Company-supplied ‘droid — a self-aware SecUnit that has hacked its own governor module, and refers to itself (though never out loud) as “Murderbot.” Scornful of humans, all it really wants is to be left alone long enough to figure out who it is.
  >
  > But when a neighboring mission goes dark, it's up to the scientists and their Murderbot to get to the truth.
</details>

#### [The Polity](https://www.goodreads.com/series/49128-polity-universe-chronological-order) (1998-2018) _by [Neal Asher](https://en.wikipedia.org/wiki/Neal_Asher)_ [4.11]

Neal Asher has written almost 20 books (if you include short story compilations) set within the universe of the Polity, an interstellar human civilization ruled by (mostly) benevolent AIs, all overseen by the most powerful AI of all: Earth Central. There are several distinct series within the larger Polity collection, as well as several standalone novels and short story collections. The _Ian Cormac_ series follows a human agent of Earth Central as he investigates threats towards the Polity. The _Spatterjay_ series explores the hostile world of Spatterjay and the lives of its hoopers: humans infected by an alien virus that grants its hosts functional immortality, immense strength, and incredible durability, but not without a cost. The _Transformations_ series focuses on a rogue AI named Penny Royal capable of granting almost any wish, but its help is always a double-edged sword. His most recent series, _Rise of the Jain_, is about the re-emergence of an ancient and incredibly powerful alien race that disappeared after seeding the galaxy with technological seeds designed to destroy any intelligent civilization that came across one.

All of Asher's _Polity_ novels are chock full of amazing technology, vibrant characters, picture-painting prose, and themes that explore the nature and limits of humanity. I was tempted to put this series under the Hard Sci-Fi category, as Asher introduces very few technologies that can't be extrapolated from existing tech, but a few things (e.g. FTL travel) and the distance in the future in which the series is set convinced me it should probably not be included in the "hard" category. - [@isochronous](https://github.com/isochronous)

<details>
  <summary>Description</summary>

  > The phrase ‘world-building’ brings immediately to mind fantasy especially places like the Middle Earth of Tolkien but we don’t hear ‘universe-building’ nearly enough. SF authors not only have to create the history and society for one place, which isn’t usually even a planet in fantasy, but for an almost unimaginable universe, which needs to be filled with a multitude of races and planets with their own technology and vast history.
  >
  > In the universe of the Polity Neal Asher has created ancient, but no longer completely active, races who remain a threat to the existence of humanity. He tells in passing of how a ‘Quiet War’ replaced humans with the artificial intelligence and in doing so allowed humans more freedom than if they’d remained under their own governance. We get to see a world pre-Polity in The Line of the Polity and post-Polity twenty years later in The Technician, though the comparison is an aside to the storytelling.
</details>

#### [The Voyage of the Space Beagle](https://www.goodreads.com/book/show/1981484.The_Voyage_of_the_Space_Beagle) (1950) _by [A.E. Van Vogt](https://www.goodreads.com/author/show/1293688.A_E_van_Vogt)_ [3.9]

This space opera novel reminds me of a series of _Star Trek_ episodes, if [Roddenberry's final frontier](https://en.wikipedia.org/wiki/Star_Trek_V:_The_Final_Frontier) had been a Machiavellian rather than a utopian vision of the future. Unlike the crew of Trek's _Enterprise_, the _Beagle_ crew engage in power struggles between its civilian and military leaders. The plot of the third section is very reminiscent of the _Alien_ movie. - [@neontapir](https://github.com/neontapir)

<details>
  <summary>Description</summary>

  > The book can be roughly divided into four sections corresponding to the four short stories on which it was based. In the first part, the _Space Beagle_ is infiltrated by Coeurl, a starving, intelligent and vicious cat-like carnivore with tentacles on its shoulders. In the second, the ship is almost destroyed by internal warfare caused by telepathic contact with a race of bird-like aliens. The third features Ixtl, a scarlet alien that kidnaps several crew members in order to implant parasitic eggs in their stomachs. In the last section, the crew battles Anabis, a galaxy-spanning consciousness.
</details>

#### [The War of the Worlds](https://www.goodreads.com/book/show/8909.The_War_of_the_Worlds) (1898) _by [H. G. Wells](https://en.wikipedia.org/wiki/H._G._Wells)_ [3.8] 🌟 🔥

This is always fun; it's a classic, and it is fun remembering what science fiction was like before there were tropes. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Man had not yet learned to fly when H. G. Wells conceived this story of a Martian attack on England. Giant cylinders crash to Earth, disgorging huge, unearthly creatures armed with heat-rays and fighting machines. Amid the boundless destruction they cause, it looks as if the end of the world has come.
</details>

#### [Xenogenesis Trilogy](https://www.goodreads.com/book/show/39334343-lilith-s-brood) (1987-1989) _by [Octavia Butler](https://en.wikipedia.org/wiki/Octavia_E._Butler)_

Very interesting exploration of what happens when aliens arrive on earth, after the planet has been ravaged by war, with their own ideas of a path forward. Humans must learn to coexist with the Oankali, genetic colonizers of the cosmos, and confront what this means for their future — deciding whether to give up an essential part of their identity in order to survive. I enjoyed the first book the most, for the worldbuilding and the way it introduces the Oankali and key concepts, but the series has a satisfying arc so I think it's worth reading all three books. - [@bschlagel](https://github.com/bschlagel)

##### [Dawn](https://www.goodreads.com/book/show/36694961-dawn) (1987) [4.1]

<details>
  <summary>Description</summary>

  > Lilith Iyapo has just lost her husband and son when atomic fire consumes Earth—the last stage of the planet’s final war. Hundreds of years later Lilith awakes, deep in the hold of a massive alien spacecraft piloted by the Oankali—who arrived just in time to save humanity from extinction. They have kept Lilith and other survivors asleep for centuries, as they learned whatever they could about Earth. Now it is time for Lilith to lead them back to her home world, but life among the Oankali on the newly resettled planet will be nothing like it was before.
  >
  > The Oankali survive by genetically merging with primitive civilizations—whether their new hosts like it or not. For the first time since the nuclear holocaust, Earth will be inhabited. Grass will grow, animals will run, and people will learn to survive the planet’s untamed wilderness. But their children will not be human. Not exactly.
</details>

##### [Adulthood Rites](https://www.goodreads.com/book/show/19105727-adulthood-rites) (1988) [4.2]

<details>
  <summary>Description</summary>

  > In this sequel to Dawn, Lilith Iyapo has given birth to what looks like a normal human boy named Akin. But Akin actually has five parents: a male and female human, a male and female Oankali, and a sexless Ooloi. The Oankali and Ooloi are part of an alien race that rescued humanity from a devastating nuclear war, but the price they exact is a high one the aliens are compelled to genetically merge their species with other races, drastically altering both in the process.
  >
  > On a rehabilitated Earth, this "new" race is emerging through human/Oankali/Ooloi mating, but there are also "pure" humans who choose to resist the aliens and the salvation they offer. These resisters are sterilized by the Ooloi so that they cannot reproduce the genetic defect that drives humanity to destroy itself, but otherwise they are left alone (unless they become violent).
  >
  > When the resisters kidnap young Akin, the Oankali choose to leave the child with his captors, for he the most "human" of the Oankali children will decide whether the resisters should be given back their fertility and freedom, even though they will only destroy themselves again.
</details>

##### [Imago](https://www.goodreads.com/book/show/17609348-imago) (1989) [4.2]

<details>
  <summary>Description</summary>

  > Child of two species, but part of neither, a new being must find his way.
  >
  > Human and Oankali have been mating since the aliens first came to Earth to rescue the few survivors of an annihilating nuclear war. The Oankali began a massive breeding project, guided by the ooloi, a sexless subspecies capable of manipulating DNA, in the hope of eventually creating a perfect starfaring race.
  >
  > Jodahs is supposed to be just another hybrid of human and Oankali, but as he begins his transformation to adulthood he finds himself becoming ooloi—the first ever born to a human mother. As his body changes, Jodahs develops the ability to shapeshift, manipulate matter, and cure or create disease at will. If this frightened young man is able to master his new identity, Jodahs could prove the savior of what’s left of mankind. Or, if he is not careful, he could become a plague that will destroy this new race once and for all.
</details>

### Hard Science Fiction

_Novels which place an emphasis on scientific accuracy and/or technical detail; where the science itself is a central topic._

#### [A Deepness in the Sky](https://www.goodreads.com/book/show/226004.A_Deepness_in_the_Sky) (2000) _by [Vernor Vinge](https://en.wikipedia.org/wiki/Vernor_Vinge)_ [4.32]

Though written after _A Fire upon the Deep_, _A Deepness in the Sky_ is a prequel to Vinge's earlier novel, and shares one of its protagonists: the Qeng Ho trader Pham Nuwen. Though I read _A Fire upon the Deep_ once and enjoyed it, I've read _A Deepness in the Sky_ at least half a dozen times, and consider it my favorite hard sci-fi novel, period. Vernor Vinge was one of the first people to propose the idea of the technological singularity, and the near-future novels he wrote a decade or more ago have revealed themselves to be almost eerily prescient. - [@isochronous](https://github.com/isochronous)

<details>
  <summary>Description</summary>

  > After thousands of years searching, humans stand on the verge of first contact with an alien race. Two human groups: the Qeng Ho, a culture of free traders, and the Emergents, a ruthless society based on the technological enslavement of minds.
  >
  > The group that opens trade with the aliens will reap unimaginable riches. But first, both groups must wait at the aliens' very doorstep for their strange star to relight and for their planet to reawaken, as it does every two hundred and fifty years....
</details>

#### [A Fire Upon the Deep](https://www.goodreads.com/book/show/77711.A_Fire_Upon_the_Deep) (1992) _by [Vernor Vinge](https://en.wikipedia.org/wiki/Vernor_Vinge)_ [4.1]

<details>
  <summary>Description</summary>

  > _A Fire upon the Deep_ is the big, breakout book that fulfills the promise of Vinge’s career to date: a gripping tale of galactic war told on a cosmic scale.
  >
  > Thousands of years hence, many races inhabit a universe where a mind’s potential is determined by its location in space, from superintelligent entities in the Transcend, to the limited minds of the Unthinking Depths, where only simple creatures and technology can function. Nobody knows what strange force partitioned space into these “regions of thought,” but when the warring Straumli realm use an ancient Transcendent artifact as a weapon, they unwittingly unleash an awesome power that destroys thousands of worlds and enslaves all natural and artificial intelligence.
  >
  > Fleeing the threat, a family of scientists, including two children, are taken captive by the Tines, an alien race with a harsh medieval culture, and used as pawns in a ruthless power struggle. A rescue mission, not entirely composed of humans, must rescue the children—and a secret that may save the rest of interstellar civilization.
</details>

#### [Aurora](https://www.goodreads.com/book/show/23197269-aurora) (2015) _by [Kim Stanley Robinson](https://en.wikipedia.org/wiki/Kim_Stanley_Robinson)_ [3.7]

This was, I thought, an emotional read. I really connected with the characters and their struggle. It was interesting seeing the ways they overcame each obstacle despite overwhelming odds. It also shows what could happen when desperate people are left to fend for themselves without a governing force. - [@davidmerrique](https://github.com/davidmerrique)

<details>
  <summary>Description</summary>

  > A major new novel from one of science fiction's most powerful voices, AURORA tells the incredible story of our first voyage beyond the solar system.
  >
  > Brilliantly imagined and beautifully told, it is the work of a writer at the height of his powers.
  >
  > Our voyage from Earth began generations ago.
  >
  > Now, we approach our new home.
  >
  > AURORA.
</details>

#### [Blindsight (Firefall #1)](https://www.goodreads.com/book/show/48484.Blindsight) (2006) _by [Peter Watts](https://en.wikipedia.org/wiki/Peter_Watts_%28author%29)_ [4.0]

A cast of strange and wonderful characters. Overarching themes on consciousness, transhumanism, humanity and first contact. This book has everything. - [@davidmerrique](https://github.com/davidmerrique)

<details>
  <summary>Description</summary>

  > It’s been two months since a myriad of alien objects clenched about the Earth, screaming as they burned. The heavens have been silent since—until a derelict space probe hears whispers from a distant comet. Something talks out there: but not to us. Who to send to meet the alien, when the alien doesn’t want to meet? Send a linguist with multiple-personality disorder, and a biologist so spliced to machinery he can’t feel his own flesh. Send a pacifist warrior, and a vampire recalled from the grave by the voodoo of paleogenetics. Send a man with half his mind gone since childhood. Send them to the edge of the solar system, praying you can trust such freaks and monsters with the fate of a world. You fear they may be more alien than the thing they’ve been sent to find—but you’d give anything for that to be true, if you knew what was waiting for them.
</details>

#### [Children of Time (Children of Time #1)](https://www.goodreads.com/book/show/25499718-children-of-time) (2015) _by [Adrian Tchaikovsky](https://en.wikipedia.org/wiki/Adrian_Tchaikovsky)_ [4.29]

A truly epic "evolutionary science fiction" story about animal uplift that feels very well researched. Tchaikovsky manages to perfectly immerse the reader in a radically different mindset. Even arachnofobics will root for the protagonists of the story. - [@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > The last remnants of the human race left a dying Earth, desperate to find a new home among the stars. Following in the footsteps of their ancestors, they discover the greatest treasure of the past age — a world terraformed and prepared for human life. But all is not right in this new Eden. In the long years since the planet was abandoned, the work of its architects has borne disastrous fruit. The planet is not waiting for them, pristine and unoccupied. New masters have turned it from a refuge into mankind's worst nightmare. Now two civilizations are on a collision course, both testing the boundaries of what they will do to survive. As the fate of humanity hangs in the balance, who are the true heirs of this new Earth?
</details>

#### [Diaspora](https://www.goodreads.com/book/show/156785.Diaspora) (1997) _by [Greg Egan](https://en.wikipedia.org/wiki/Greg_Egan)_ [4.1]

<details>
  <summary>Description</summary>

  > By the end of the 30th century humanity has the capability to travel the universe, to journey beyond earth and beyond the confines of the vulnerable human frame.
  >
  > The descendants of centuries of scientific, cultural and physical development divide into three: fleshers—true Homo sapiens; Gleisner robots—embodying human minds within machines that interact with the physical world; and polises—supercomputers teeming with intelligent software, containing the direct copies of billions of human personalities now existing only in the virtual reality of the polis.
  >
  > Diaspora is the story of Yatima—a polis being created from random mutations of the Konishi polis base mind seed—and of humankind, Of an astrophysical accident that spurs the thousandfold cloning of the polises. Of the discovery of an alien race and of a kink in time that means humanity—whatever form it takes—will never again be threatened by acts of God.
</details>

#### [Dragon’s Egg](https://www.goodreads.com/book/show/263466.Dragon_s_Egg) (1980) _by [Robert L. Forward](https://en.wikipedia.org/wiki/Robert_L._Forward)_ [4.1]

<details>
  <summary>Description</summary>

  > In a moving story of sacrifice and triumph, human scientists establish a relationship with intelligent life forms—the cheela—living on Dragon’s Egg, a neutron star where one Earth hour is equivalent to hundreds of their years. The cheela culturally evolve from savagery to the discovery of science, and for a brief time men are their diligent teachers.
</details>

#### [Echopraxia (Firefall #2)](https://www.goodreads.com/book/show/18490708-echopraxia) (2014) _by [Peter Watts](https://en.wikipedia.org/wiki/Peter_Watts_%28author%29)_ [3.8]

<details>
  <summary>Description</summary>

  > Prepare for a different kind of singularity in this follow-up to the Hugo-nominated novel Blindsight
  >
  > It's the eve of the twenty-second century: a world where the dearly departed send postcards back from Heaven and evangelicals make scientific breakthroughs by speaking in tongues; where genetically engineered vampires solve problems intractable to baseline humans and soldiers come with zombie switches that shut off self-awareness during combat. And it’s all under surveillance by an alien presence that refuses to show itself.
  >
  > Daniel Bruks is a living fossil: a field biologist in a world where biology has turned computational, a cat's-paw used by terrorists to kill thousands. Taking refuge in the Oregon desert, he’s turned his back on a humanity that shatters into strange new subspecies with every heartbeat. But he awakens one night to find himself at the center of a storm that will turn all of history inside-out.
  >
  > Now he’s trapped on a ship bound for the center of the solar system. To his left is a grief-stricken soldier, obsessed by whispered messages from a dead son. To his right is a pilot who hasn’t yet found the man she's sworn to kill on sight. A vampire and its entourage of zombie bodyguards lurk in the shadows behind. And dead ahead, a handful of rapture-stricken monks takes them all to a meeting with something they will only call “The Angels of the Asteroids.”
  >
  > Their pilgrimage brings Dan Bruks, the fossil man, face-to-face with the biggest evolutionary breakpoint since the origin of thought itself.
</details>

#### [Manifold series](https://www.goodreads.com/series/49783-manifold) (1999-2003) _by [Stephen Baxter](<https://en.wikipedia.org/wiki/Stephen_Baxter_(author)>)_ [3.8 avg]

Stephen Baxter explores the Fermi Paradox in different ways over the course of three books (and a collection of novellas), in a gloriously hard scifi style. It is very thought provoking, and also utterly brutal and bleak. Space and time is cold and uncaring. - [@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > Each one of the main novels deals with a possible resolution to the Fermi paradox. The first, Time, is set in a universe that is completely devoid of intelligent life beyond that of mankind and its creations (i.e. A.I. and uplifted animals).
  >
  > The second in the series, Space, proposes the opposite: that life is endemic to the universe, and there is intelligence in nearly all possible places of the cosmos. The solution to the Fermi Paradox in this novel is that intelligent life is continually wiped out by cosmic disasters before it has time to spread too far.
  >
  > The third novel, Origin, is set in a multiverse that is a compromise between the ideals in the first two novels: that life is only on Earth, but at the same time is everywhere. This novel solves the Fermi Paradox by suggesting that intelligent life is segregated into separate parallel universes.
</details>

#### [Nexus](https://www.goodreads.com/book/show/24968342-nexus) (2012) _by [Ramez Naam](https://en.wikipedia.org/wiki/Ramez_Naam)_ [4.1]

Near-future hard Sci-Fi at its best. Lots of awards and endorsements, even a [thumbs up](https://twitter.com/ID_AA_Carmack/status/494337667035697152) from John Carmack. Can't go wrong. - [@christianboyle](https://github.com/christianboyle)

<details>
  <summary>Description</summary>

  > In the near future, the experimental nano-drug Nexus can link humans together, mind to mind. There are some who want to improve it. There are some who want to eradicate it. And there are others who just want to exploit it.
  >
  > When a young scientist is caught improving Nexus, he’s thrust over his head into a world of danger and international espionage—for there is far more at stake than anyone realizes.
  >
  > From the halls of academe to the halls of power; from the headquarters of an elite agency in Washington, D.C. to a secret lab beneath Shanghai; from the underground parties of San Francisco to the illegal biotech markets of Bangkok; from an international neuroscience conference to a remote monastery in the mountains of Thailand—Nexus is a thrill ride through a future on the brink of explosion.
</details>

#### [Permutation City](https://www.goodreads.com/book/show/156784.Permutation_City) (1994) _by [Greg Egan](https://en.wikipedia.org/wiki/Greg_Egan)_ [4.1]

With all the ideas contained in Permutation City, a typical Sci-Fi author would have written at least 5 separate books. - [@uraimo](https://github.com/uraimo)

<details>
  <summary>Description</summary>

  > In the not-too-distant future, technology has given birth to a form of immortality. The human mind can be scanned and uploaded into a virtual reality program to become a perfect electronic “Copy,” aware of itself. A new Copy finds himself forced to cooperate in scientific experiments with the flesh-and-blood man he was copied from.
</details>

#### [Red Mars](https://www.goodreads.com/book/show/77507.Red_Mars) (1993) _by [Kim Stanley Robinson](https://en.wikipedia.org/wiki/Kim_Stanley_Robinson)_ [3.8]

An interesting take on the near-future colonization of Mars by one hundred of the world's greatest scientists, filled with political intrigue and "hard science" alike. Admittedly some parts can be a slog, think A Song of Ice and Fire: awesome narrative in the grand scheme, with perhaps a bit too much description of Martian landscape/house sigils. - [@rubzo](https://github.com/rubzo)

<details>
  <summary>Description</summary>

  > For eons, sandstorms have swept the barren desolate landscape of the red planet. For centuries, Mars has beckoned to mankind to come and conquer its hostile climate. Now, in the year 2026, a group of one hundred colonists is about to fulfill that destiny. John Boone, Maya Toitavna, Frank Chalmers, and Arkady Bogdanov lead a mission whose ultimate goal is the terraforming of Mars. For some, Mars will become a passion driving them to daring acts of courage and madness; for others it offers and opportunity to strip the planet of its riches. And for the genetic “alchemists,” Mars presents a chance to create a biomedical miracle, a breakthrough that could change all we know about life… and death.
</details>

#### [Schild’s Ladder](https://www.goodreads.com/book/show/156780.Schild_s_Ladder) (2002) _by [Greg Egan](https://en.wikipedia.org/wiki/Greg_Egan)_ [3.9]

<details>
  <summary>Description</summary>

  > Twenty thousand years into the future, an experiment in quantum physics has had a catastrophic result, creating an enormous, rapidly expanding vacuum that devours everything it comes in contact with. Now humans must confront this deadly expansion. Tchicaya, aboard a starship trawling the border of the vacuum, has allied himself with the Yielders—those determined to study the vacuum while allowing it to grow unchecked. But when his fiery first love, Mariama, reenters his life on the side of the Preservationists—those working to halt and destroy the vacuum—Tchicaya finds himself struggling with an inner turmoil he has known since childhood.
  >
  > However, in the center of the vacuum, something is developing that neither Tchicaya and the Yielders nor Mariama and the Preservationists could ever have imagined possible: life.
</details>

#### [The Martian](https://www.goodreads.com/book/show/18007564-the-martian) (2012) _by [Andy Weir](https://en.wikipedia.org/wiki/Andy_Weir_%28writer%29)_ [4.4]

This is a fun read; Weir manages to write an evocative techno-thriller without having his characters stoop to constant navel gazing and lonesome pining. This could be described as Robinson Crusoe - in Space. The characters on the earth side aren't the greatest, but the humor throughout the book really pulls it together, and watching a master at work as far as mechanical engineering goes was fascinating. Loved it. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > _Apollo 13_ meets _Cast Away_ in this grippingly detailed, brilliantly ingenious man-vs-nature survival thriller, set on the surface of Mars. Six days ago, astronaut Mark Watney became one of the first men to walk on the surface of Mars. Now, he’s sure he’ll be the first man to die there.
  >
  > It started with the dust storm that holed his suit and nearly killed him, and that forced his crew to leave him behind, sure he was already dead. Now he’s stranded millions of miles from the nearest human being, with no way to even signal Earth that he’s alive—and even if he could get word out, his food would be gone years before a rescue mission could arrive. Chances are, though, he won’t have time to starve to death. The damaged machinery, unforgiving environment, or plain-old “human error” are much more likely to get him first.
  
  > But Mark isn’t ready to give up yet. Drawing on his ingenuity, his engineering skills—and a relentless, dogged refusal to quit—he steadfastly confronts one seemingly insurmountable obstacle after the next. But will his resourcefulness be enough to overcome the impossible odds against him?
</details>

#### [The Sands of Mars](https://www.goodreads.com/book/show/149063.The_Sands_of_Mars) (1951) _by [Arthur C. Clarke](https://en.wikipedia.org/wiki/Arthur_C._Clarke)_ [3.7]

This book is most interesting for its pretty cool take on terraforming a planet, and how that goes both for the inhabitants and what it means for nationalism (or planetism, as it were). - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Space writers holiday. When a celebrated science fiction writer takes to space on his first trip to Mars, he’s sure to be in for some heckling from the spaceship crew. But Martin Gibson, man about space, takes it all in his stride. That is, until he lands on the red planet. Once there the intrepid author causes one problem after another as he stumbles upon Mars’ most carefully hidden secrets and threatens the future of an entire planet.
</details>

### Cyberpunk

_Future-based novels with advanced science and technology coupled with a disrupted social order._

#### [Altered Carbon](https://www.goodreads.com/book/show/40445.Altered_Carbon) (2002) _by [Richard K. Morgan](https://en.wikipedia.org/wiki/Richard_K._Morgan)_ [4.1]

A fun and fast-paced hard-boiled cyberpunk noir, almost impossible to put down. - [@helderroem](https://github.com/helderroem)

<details>
  <summary>Description</summary>

  > It’s the twenty-fifth century, and advances in technology have redefined life itself. A person’s consciousness can now be stored in the brain and downloaded into a new body (or “sleeve”,) making death nothing more than a minor blip on a screen. Onetime U.N. Envoy Takeshi Kovacs has been killed before, but his last death was particularly painful. Resleeved into a body in Bay City (formerly San Francisco,) Kovacs is thrown into the dark heart of a shady, far-reaching conspiracy that is vicious even by the standards of a society that treats existence as something that can be bought and sold. For Kovacs, the shell that blew a hole in his chest was only the beginning.
</details>

#### [Greg Mandel Series](https://www.goodreads.com/series/43978-greg-mandel) (1993, 1994, 1995) _by [Peter F. Hamilton](https://en.wikipedia.org/wiki/Peter_F._Hamilton)_ [3.9]

<details>
  <summary>Description</summary>

  > Greg Mandel, late of the Mindstar Battalion, has been many things in his life. Commando. Freedom fighter. Assassin. Now he’s a freelance operative with a very special edge: telepathy.
  >
  > In the high-tech, hard-edged world of computer crime, zero-gravity smuggling, and artificial intelligence, Greg Mandel is the man to call when things get rough. But when an elusive saboteur plagues a powerful organization known as Event Horizon, Mandel must cut his way through a maze of corporate intrigue and startling new scientific discoveries.
  >
  > And nothing less than the future is at stake.
</details>

#### [Hard-Boiled Wonderland and the End of the World](https://www.goodreads.com/book/show/10374.Hard_Boiled_Wonderland_and_the_End_of_the_World) (1985) _by [Haruki Murakami](https://en.wikipedia.org/wiki/Haruki_Murakami)_ [4.2]

My favorite of Murakami's. Great mix of quirky, mundane, and fascinating ideas. Short read too. - [@desandro](https://github.com/desandro)

<details>
  <summary>Description</summary>

  > A narrative particle accelerator that zooms between Wild Turkey Whiskey and Bob Dylan, unicorn skulls and voracious librarians, John Coltrane and _Lord Jim_. Science fiction, detective story and post-modern manifesto all rolled into one rip-roaring novel, _Hard-Boiled Wonderland and the End of the World_ is the tour de force that expanded Haruki Murakami’s international following. Tracking one man’s descent into the Kafkaesque underworld of contemporary Tokyo, Murakami unites East and West, tragedy and farce, compassion and detachment, slang and philosophy.
</details>

#### [Neuromancer](https://www.goodreads.com/book/show/22328.Neuromancer) (1984) _by [William Gibson](https://en.wikipedia.org/wiki/William_Gibson)_ [3.9] 🌟 🔥

<details>
  <summary>Description</summary>

  > The Matrix is a world within the world, a global consensus hallucination, the representation of every byte of data in cyberspace…
  >
  > Case had been the sharpest data-thief in the business, until vengeful former employers crippled his nervous system. But now a new and very mysterious employer recruits him for a last-chance run. The target: an unthinkably powerful artificial intelligence orbiting Earth in service of the sinister Tessier-Ashpool business clan. With a dead man riding shotgun and Molly, mirror-eyed street-samurai, to watch his back, Case embarks on an adventure that ups the ante on an entire genre of fiction.
  >
  > Hotwired to the leading edges of art and technology, _Neuromancer_ ranks with _1984_ and _Brave New World_ as one of the century’s most potent visions of the future.
</details>

#### [REAMDE](https://www.goodreads.com/book/show/10552338-reamde) (2011) _by [Neal Stephenson](https://en.wikipedia.org/wiki/Neal_Stephenson)_ [3.9]

With REAMDE (sic) Neal Stephenson returns with a much more down to earth cyberpunk story, closer to our own future and shaped not by the cyberpunk futures imagined in the early nineties but rather what we actually got instead in the 2000s. A few wrong turns quickly turns into a world-spanning chase, featuring terrorists, russian mobsters, online gaming and a more realistic, contemporary take on cyberpunk storytelling. - [@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > Four decades ago, Richard Forthrast, the black sheep of an Iowa family, fled to a wild and lonely mountainous corner of British Columbia to avoid the draft. Smuggling backpack loads of high-grade marijuana across the border into Northern Idaho, he quickly amassed an enormous and illegal fortune. With plenty of time and money to burn, he became addicted to an online fantasy game in which opposing factions battle for power and treasure in a vast cyber realm. Like many serious gamers, he began routinely purchasing virtual gold pieces and other desirables from Chinese gold farmers—young professional players in Asia who accumulated virtual weapons and armor to sell to busy American and European buyers.
  >
  > For Richard, the game was the perfect opportunity to launder his aging hundred dollar bills and begin his own high-tech start up—a venture that has morphed into a Fortune 500 computer gaming group, Corporation 9592, with its own super successful online role-playing game, T’Rain. But the line between fantasy and reality becomes dangerously blurred when a young gold farmer accidently triggers a virtual war for dominance—and Richard is caught at the center.
  >
  > In this edgy, 21st century tale, Neal Stephenson, one of the most ambitious and prophetic writers of our time, returns to the terrain of his cyberpunk masterpieces Snow Crash and Cryptonomicon, leading readers through the looking glass and into the dark heart of imagination.
</details>

#### [Snow Crash](https://www.goodreads.com/book/show/830.Snow_Crash) (1992) _by [Neal Stephenson](https://en.wikipedia.org/wiki/Neal_Stephenson)_ [4.0] 🔥

<details>
  <summary>Description</summary>

  > In reality, Hiro Protagonist delivers pizza for Uncle Enzo’s CosoNostra Pizza Inc., but in the Metaverse he’s a warrior prince. Plunging headlong into the enigma of a new computer virus that’s striking down hackers everywhere, he races along the neon-lit streets on a search-and-destroy mission for the shadowy virtual villain threatening to bring about infocalypse. _Snow Crash_ is a mind-altering romp through a future America so bizarre, so outrageous… you’ll recognize it immediately.
</details>

#### [The Demolished Man](https://www.goodreads.com/book/show/76740.The_Demolished_Man) (1951) _by [Alfred Bester](https://en.wikipedia.org/wiki/Alfred_Bester)_ [4.0]

I think of this book often, even though initially I had consigned it as a cheap paperback crime thriller set in space. The main part of this book that is interesting is the implications regarding policed thoughts, especially given recent advances in government surveillance. The other part of this book I think about a lot is the advertising jingle - _Tenser, Tenser, said the tensor_ - which plays a major role. I've still got no idea what it is meant to mean. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In a world in which the police have telepathic powers, how do you get away with murder? Ben Reichs heads a huge 24th century business empire, spanning the solar system. He is also an obsessed, driven man determined to murder a rival. To avoid capture, in a society where murderers can be detected even before they commit their crime, is the greatest challenge of his life.
</details>

#### [The Diamond Age: Or, A Young Lady’s Illustrated Primer](https://www.goodreads.com/book/show/827.The_Diamond_Age) (1995) _by [Neal Stephenson](https://en.wikipedia.org/wiki/Neal_Stephenson)_ [4.2]

This book had me looking up more words than any book had me do for a long time. A mildly interesting story, with cunning turns and twists, in a very interesting world. What surprised me most was that the book already foresaw cryptocurrencies, 3d-printers and fleets of UAV's while already being 20+ years old. - [@fritzvd](https://github.com/fritzvd)

<details>
  <summary>Description</summary>

  > _The Diamond Age: Or, A Young Lady’s Illustrated Primer_ is a postcyberpunk novel by Neal Stephenson. It is to some extent a science fiction coming-of-age story, focused on a young girl named Nell, and set in a future world in which nanotechnology affects all aspects of life. The novel deals with themes of education, social class, ethnicity, and the nature of artificial intelligence.
</details>

#### [The Stars My Destination](https://www.goodreads.com/book/show/333867.The_Stars_My_Destination) (1955) _by [Alfred Bester](https://en.wikipedia.org/wiki/Alfred_Bester)_ [4.2]

This book is fantastic not for the novelty of non-technological teleportation, but because of the main character. What happens when someone who has been ignored by society finds himself in a position of power? This book reminds me a tiny bit of Ender's Game - imagine what would happen if Mazer Rackham, another tattooed Maori hero, wanted more than to be a military genius. I loved it. I quote the poem to myself all the time, and have set a variant of it as my twitter bio for years now. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In this pulse-quickening novel, Alfred Bester imagines a future in which people “jaunte” a thousand miles with a single thought, where the rich barricade themselves in labyrinths and protect themselves with radioactive hit men—and where an inarticulate outcast is the most valuable and dangerous man alive. _The Stars My Destination_ is a classic of technological prophecy and timeless narrative enchantment by an acknowledged master of science fiction.
</details>

#### [Thin Air](https://www.goodreads.com/book/show/25835917-thin-air) (2018) _by [Richard K. Morgan](https://en.wikipedia.org/wiki/Richard_K._Morgan)_ [4.0]

Modernized cyberpunk with the noir grit dialled up to eleven. - [@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > An ex-corporate enforcer, Hakan Veil, is forced to bodyguard Madison Madekwe, part of a colonial audit team investigating a disappeared lottery winner on Mars. But when Madekwe is abducted, and Hakan nearly killed, the investigation takes him farther and deeper than he had ever expected. And soon Hakan discovers the heavy price he may have to pay to learn the truth.
</details>

#### [Walkaway](https://www.goodreads.com/book/show/40604388-walkaway) (2017) _by [Cory Doctorow](https://en.wikipedia.org/wiki/Cory_Doctorow)_ [3.7]

Idea-driven scifi about a tech-savvy movement of "walkaways", disenchanted people walking away from an increasingly oppressive capitalist society and creating their own ad-hoc societies. Doctorow manages to combine cyberpunk "high tech, low life" with a bit of utopian science fiction which feels very refreshing. - [nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > In a world of non-work, ruined by human-created climate change and pollution, and where people are under surveillance and ruled over by a mega-rich elite, Hubert, Etc, his friend Seth, and Natalie, decide that they have nothing to lose by turning their backs and walking away from the everyday world or "default reality".
  >
  > With the advent of 3D printing – and especially the ability to use these to fabricate even better fabricators – and with machines that can search for and reprocess waste or discarded materials, they no longer have need of Default for the basic essentials of life, such as food, clothing and shelter.
  >
  > As more and more people choose to "walkaway", the ruling elite do not take these social changes sitting down. They use the military, police and mercenaries to attack and disrupt the walkaways' new settlements.
  >
  > One thing that the elite are especially interested in is scientific research that the walkaways are carrying out which could finally put an end to death – and all this leads to revolution and eventual war.
</details>

#### [Ware](https://www.goodreads.com/series/41816-ware) (1982-2000) _by [Rudy Rucker](https://en.wikipedia.org/wiki/Rudy_Rucker)_ [3.7]

<details>
  <summary>Description</summary>

  > Cobb Anderson created the “boppers,” sentient robots that overthrew their human overlords. But now Cobb is just an aging alcoholic waiting to die, and the big boppers are threatening to absorb all of the little boppers—and eventually every human—into a giant, melded consciousness. Some of the little boppers aren’t too keen on the idea, and a full-scale robot revolt is underway on the moon (where the boppers live). Meanwhile, bopper Ralph Numbers wants to give Cobb immortality by letting a big bopper slice up his brain and tape his “software.” It seems like a good idea to Cobb.
</details>

### Utopia

_Utopian novels deal with imaginary communities or societies that are desirable or pleasant._

#### [A Psalm for the Wild-Built (Monki and Robot #1)](https://www.goodreads.com/book/show/40864002-a-psalm-for-the-wild-built) (2021) _by [Becky Chambers](https://en.wikipedia.org/wiki/Becky_Chambers)_ [4.3]

A lovely balm for the weary science fiction reader about a post-collapse utopian society and the friendship between a human and a robot. -[@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > Centuries before, robots of Panga gained self-awareness, laid down their tools, wandered, en masse into the wilderness, never to be seen again. They faded into myth and urban legend.
  > Now the life of the tea monk who tells this story is upended by the arrival of a robot, there to honor the old promise of checking in. The robot cannot go back until the question of "what do people need?" is answered. But the answer to that question depends on who you ask, and how. They will need to ask it a lot. Chambers' series asks: in a world where people have what they want, does having more matter?
</details>

#### [The Rolling Stones](https://www.goodreads.com/book/show/50848.The_Rolling_Stones) (1952) _by [Robert A. Heinlein](https://en.wikipedia.org/wiki/Robert_A._Heinlein)_ [3.9]

A charming, fast-paced space adventure following the Stone family as they journey through the solar system, offering a delightful mix of humor, family dynamics, and interplanetary escapades. -[@Russolves](https://github.com/Russolves)

<details>
	<summary>Description</summary>
	
  > It doesn’t seem likely for twins to have the same middle name. Even so, it’s clear that Castor and Pollux Stone both have "Trouble" written in that spot on their birth certificates. Of course, anyone who’s met their grandmother Hazel would know that they came by it honestly…
  > Join the Stone twins as they connive, cajole, and bamboozle their way across the Solar System in the company of the most high-spirited and hilarious family in all of science fiction. This light-hearted tale has some of Heinlein’s sassiest dialogue (not to mention the famous Flat Cats incident!). Oddly enough, it’s also a true example of real family values–for when you’re a Stone, your family is your highest priority.
</details>

#### [The Songs of Distant Earth](https://www.goodreads.com/book/show/117842.The_Songs_of_Distant_Earth) (1986) _by [Arthur C. Clarke](https://en.wikipedia.org/wiki/Arthur_C._Clarke)_ [3.9]

My first Arthur C. Clarke Sci-fi book that introduced me to the world of Arthur C. Clarke. The book deals with the utopian society where the aliens are human beings from the old earth. -[@DibeshMSShrestha](https://github.com/DibeshMSShrestha)

<details>
  <summary>Description</summary>

  > Just a few islands in a planetwide ocean, Thalassa was a veritable paradise—home to one of the small colonies founded centuries before by robot Mother Ships when the Sun had gone nova and mankind had fled Earth.
  >
  > Mesmerized by the beauty of Thalassa and overwhelmed by its vast resources, the colonists lived an idyllic existence, unaware of the monumental evolutionary event slowly taking place beneath their seas...
  >
  > Then the Magellan arrived in orbit carrying one million refugees from the last, mad days on Earth. And suddenly uncertainty and change had come to the placid paradise that was Thalassa.
</details>

### Dystopia

_Dystopian novels deal with imaginary communities or societies that are undesirable or frightening._

#### [1984](https://www.goodreads.com/book/show/5470.1984) (1949) _by [George Orwell](https://en.wikipedia.org/wiki/George_Orwell)_ [4.1] 🌟 🔥

<details>
  <summary>Description</summary>

  > Written in 1948, _1984_ was George Orwell’s chilling prophecy about the future.
  >
  > While 1984 has come and gone, Orwell’s narrative is more timely that ever. _1984_ presents a “negative utopia,” that is at once a startling and haunting vision of the world—so powerful that it’s completely convincing from start to finish. No one can deny the power of this novel, its hold on the imaginations of entire generations of readers, or the resiliency of its admonitions—a legacy that seems to grow, not lessen, with the passage of time.
</details>

#### [A Clockwork Orange](https://www.goodreads.com/book/show/227463.A_Clockwork_Orange) (1962) _by [Anthony Burgess](https://en.wikipedia.org/wiki/Anthony_Burgess)_

[3.99]

Better than the movie IMHO. Written in a slang language called Nadsat, the book really draws you into the world Alex occupies, as opposed to Kubrick's version of the story, portrayed in the movie. The endings are also different! - [@alexkeyes](https://github.com/alex-keyes)

<details>
  <summary>Description</summary>

  > A vicious fifteen-year-old "droog" is the central character of this 1963 classic, whose stark terror was captured in Stanley Kubrick's magnificent film of the same title.
  >
  > In Anthony Burgess's nightmare vision of the future, where criminals take over after dark, the story is told by the central character, Alex, who talks in a brutal invented slang that brilliantly renders his and his friends' social pathology. A Clockwork Orange is a frightening fable about good and evil, and the meaning of human freedom. When the state undertakes to reform Alex — to "redeem" him — the novel asks, "At what cost?"
</details>

#### [Brave New World](https://www.goodreads.com/book/show/5129.Brave_New_World) (1932) _by [Aldous Huxley](https://en.wikipedia.org/wiki/Aldous_Huxley)_ [3.9] 🌟 🔥

This book is insidiously horrifying in its applicability, more so than _1984_ or _Fahrenheit 451_. [Here's a comic](https://abetterkuwait.files.wordpress.com/2011/08/orwell-huxley.jpg) that sums up the difference. Well worth the read. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Far in the future, the World Controllers have created the ideal society. Through clever use of genetic engineering, brainwashing and recreational sex and drugs, all its members are happy consumers. Bernard Marx seems alone harbouring an ill-defined longing to break free. A visit to one of the few remaining Savage Reservations, where the old, imperfect life still continues, may be the cure for his distress…
  >
  > Huxley’s ingenious fantasy of the future sheds a blazing light on the present and is considered to be his most enduring masterpiece.
</details>

#### [Dad's Nuke](https://www.goodreads.com/book/show/730945.Dad_s_Nuke) (1985) _by [Marc Laidlaw](https://en.wikipedia.org/wiki/Marc_Laidlaw)_ [3.6]

The debut novel from the guy who would go on to write Half-Life and Portal. A dizzyingly funny dystopia straight from the heart of the 80s. Deftly manages the tightrope walk of absurdity without the world crumbling underneath it. Philip K. Dick would be proud. - [@jackflips](https://github.com/jackflips)

<details>
  <summary>Description</summary>

  > The US is divided into independent, heavily defended neighborhoods; Cobblestone Hill is a planned, self-sufficient community, dreamed up and secretly controlled by the mysterious Doc Edison; here Dad Johnson struggles to raise his oddball family and defend his house against potentially hostile neighbors.
  >
  > One-upmanship is still alive, though, and when Jock Smith plants a rocket launcher in his backyard, Dad responds with a nuclear reactor in his garage. (Doc Edison thoughtfully gene-splices the new Johnson baby so that she eats nuclear waste.)
  >
  > Dad's son P.J., discovering that he's been programmed to be gay (as part of Doc Edison's notions of a "balanced family"), flees the enclave, only to be captured, drugged, and brainwashed by Christian Soldiers. Dad's wife Connie runs off with a salesman from the ubiquitous Cartel; a bunch of Doc Edison clones show up, all quite mad; the Christian Soldiers attempt a computerized invasion; and the feud between Dad and Jock Smith comes to a head.
</details>

#### [Divergent](https://www.goodreads.com/book/show/13335037-divergent) (2012) _by [Veronica Roth](https://es.wikipedia.org/wiki/Veronica_Roth)_ [4.2] 🔥

One of my favorite trilogies! Divergent is a young adult science fiction trilogy. This book is about a dystopian Chicago society divided by five factions: Abnegation, Erudite, Dauntless, Amity, and Candor. Factions that were created to maintain peace within the society. In this book you follow the story of Beatrice, who's decisions leads her to discover who she really is and what is really happening. Through the trilogy you are able to see how the character evolves and becomes more mature with her decisions... decisions that not only impact her life but others too. I highly recommend this book! The ending of the trilogy left me astonished for 3 days after I finished it! (good thing I got to discuss it with one of my friends!) - [@GracielaGarcia](https://github.com/GracielaGarcia)

<details>
  <summary>Description</summary>

  > In Beatrice Prior's dystopian Chicago world, society is divided into five factions, each dedicated to the cultivation of a particular virtue—Candor (the honest), Abnegation (the selfless), Dauntless (the brave), Amity (the peaceful), and Erudite (the intelligent). On an appointed day of every year, all sixteen-year-olds must select the faction to which they will devote the rest of their lives. For Beatrice, the decision is between staying with her family and being who she really is—she can't have both. So she makes a choice that surprises everyone, including herself.
  >
  > During the highly competitive initiation that follows, Beatrice renames herself Tris and struggles alongside her fellow initiates to live out the choice they have made. Together they must undergo extreme physical tests of endurance and intense psychological simulations, some with devastating consequences. As initiation transforms them all, Tris must determine who her friends really are—and where, exactly, a romance with a sometimes fascinating, sometimes exasperating boy fits into the life she's chosen. But Tris also has a secret, one she's kept hidden from everyone because she's been warned it can mean death. And as she discovers unrest and growing conflict that threaten to unravel her seemingly perfect society, she also learns that her secret might help her save those she loves . . . or it might destroy her.
</details>

#### [Fahrenheit 451](https://www.goodreads.com/book/show/17470674-fahrenheit-451) (1953) _by [Ray Bradbury](https://en.wikipedia.org/wiki/Ray_Bradbury)_ [4.0] 🌟 🔥

A classic, beautiful book. A short read that does a good job of making the reader think about the ramifications of censorship, and is still entertaining and beautiful in its own way. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > The terrifyingly prophetic novel of a post-literate future.
  >
  > Guy Montag is a fireman. His job is to burn books, which are forbidden, being the source of all discord and unhappiness. Even so, Montag is unhappy; there is discord in his marriage. Are books hidden in his house? The Mechanical Hound of the Fire Department, armed with a lethal hypodermic, escorted by helicopters, is ready to track down those dissidents who defy society to preserve and read books.
  >
  > The classic dystopian novel of a post-literate future, _Fahrenheit 451_ stands alongside Orwell’s _1984_ and Huxley’s _Brave New World_ as a prophetic account of Western civilization’s enslavement by the media, drugs and conformity.
  >
  > Bradbury’s powerful and poetic prose combines with uncanny insight into the potential of technology to create a novel which, decades on from first publication, still has the power to dazzle and shock.
</details>

#### [Oryx and Crake](https://www.goodreads.com/series/55674-maddaddam) (2003, 2009, 2013) _by [Margaret Atwood](https://en.wikipedia.org/wiki/Margaret_Atwood)_ [4.0] 🔥

This book is a wonderfully constructed tale that can be seen as warning for an age where genetic engineering is up and coming and we haven't the faintest clue where this might lead us. I loved it to bits and only found out there was a sequel by reading about the final episode coming out when I was well done with the first part and devoured the other two as eagerly as the first. That said, I find the first the best of the three books. - [@fritzvd](https://github.com/fritzvd)

<details>
  <summary>Description</summary>

  > _Oryx and Crake_ is at once an unforgettable love story and a compelling vision of the future. Snowman, known as Jimmy before mankind was overwhelmed by a plague, is struggling to survive in a world where he may be the last human, and mourning the loss of his best friend, Crake, and the beautiful and elusive Oryx whom they both loved. In search of answers, Snowman embarks on a journey–with the help of the green-eyed Children of Crake–through the lush wilderness that was so recently a great city, until powerful corporations took mankind on an uncontrolled genetic engineering ride. Margaret Atwood projects us into a near future that is both all too familiar and beyond our imagining.
</details>

#### [Ready Player One](https://www.goodreads.com/book/show/9969571-ready-player-one) (2011) _by [Ernest Cline](https://en.wikipedia.org/wiki/Ernest_Cline)_ [4.3] 🔥

This is easily in one of my top 5 favorite books I've ever read. It's SO fun to read, and every single person I've recommended it to has loved it. Even if you don't understand every single reference, it's still a great story to follow. It has an excellent amount of humor, adventure, and nostalgia. It also has one of the best endings I've ever read, which any reader knows is a hard thing to nail. Ernest Cline really hit it out of the park with this one. Highly recommend it. - [cassidoo](https://github.com/cassidoo)

This book is AWESOME. It's so AWESOME that it makes me want to go back and play arcade games and rewatch all of the Macross saga. The plot is great, the writing is great, it makes you laugh out loud if you're a geek and know the references, and the story is kickass. Warning: Might be a good idea to brush up on your old school fantasy and scifi before reading this. Just don't go rewatch Krull, OK? - [RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > It’s the year 2044, and the real world is an ugly place.
  >
  > Like most of humanity, Wade Watts escapes his grim surroundings by spending his waking hours jacked into the OASIS, a sprawling virtual utopia that lets you be anything you want to be, a place where you can live and play and fall in love on any of ten thousand planets.
  >
  > And like most of humanity, Wade dreams of being the one to discover the ultimate lottery ticket that lies concealed within this virtual world. For somewhere inside this giant networked playground, OASIS creator James Halliday has hidden a series of fiendish puzzles that will yield massive fortune—and remarkable power—to whoever can unlock them.
  >
  > For years, millions have struggled fruitlessly to attain this prize, knowing only that Halliday’s riddles are based in the pop culture he loved—that of the late twentieth century. And for years, millions have found in this quest another means of escape, retreating into happy, obsessive study of Halliday’s icons. Like many of his contemporaries, Wade is as comfortable debating the finer points of John Hughes’s oeuvre, playing Pac-Man, or reciting Devo lyrics as he is scrounging power to run his OASIS rig.
  >
  > And then Wade stumbles upon the first puzzle.
  >
  > Suddenly the whole world is watching, and thousands of competitors join the hunt—among them certain powerful players who are willing to commit very real murder to beat Wade to this prize. Now the only way for Wade to survive and preserve everything he knows is to win. But to do so, he may have to leave behind his oh-so-perfect virtual existence and face up to life—and love—in the real world he’s always been so desperate to escape.
  >
  > A world at stake.
  > A quest for the ultimate prize.
  > Are you ready?
</details>

#### [The Dispossessed](https://www.goodreads.com/book/show/13651.The_Dispossessed) (1974) _by [Ursula K. Le Guin](https://en.wikipedia.org/wiki/Ursula_K._Le_Guin)_ [4.2]

Sci-Fi, sociology and philosophy. - [@NaxYoMizmo](https://twitter.com/NaxYoMizmo)

<details>
  <summary>Description</summary>

  > Shevek, a brilliant physicist, decides to take action. He will seek answers, question the unquestionable, and attempt to tear down the walls of hatred that have isolated his planet of anarchists from the rest of the civilized universe. To do this dangerous task will mean giving up his family and possibly his life—Shevek must make the unprecedented journey to the utopian mother planet, Urras, to challenge the complex structures of life and living, and ignite the fires of change.
</details>

#### [The Handmaid's Tale](https://www.goodreads.com/book/show/12961964-the-handmaid-s-tale) (1986) _by [Margaret Atwood](https://www.goodreads.com/author/show/3472.Margaret_Atwood)_ [4.1]

A bleak and haunting tale, easy to picture playing out in today's political climate. There's a reason the TV series adaptation is popular. - [@neontapir](https://github.com/neontapir)

<details>
  <summary>Description</summary>

  > Set in the near future, it describes life in what was once the United States, now called the Republic of Gilead, a monotheocracy that has reacted to social unrest and a sharply declining birthrate by reverting to, and going beyond, the repressive intolerance of the original Puritans. The regime takes the Book of Genesis absolutely at its word, with bizarre consequences for the women and men of its population.
</details>

#### [Make Room! Make Room!](https://www.goodreads.com/book/show/473850.Make_Room_Make_Room_) (1966) _by [Harry Harrison](https://en.wikipedia.org/wiki/Harry_Harrison_(writer))_ [3.7]

Great dystopian work shows the impact of [Universal basic income](https://en.wikipedia.org/wiki/Universal_basic_income) to society. - [@4ndrej](https://github.com/4ndrej)

<details>
  <summary>Description</summary>

  > Set in a future August 1999, novel of an overpopulated urban jungle, a divided class system—operating within an atmosphere of riots, food shortages, and senseless acts of violence—and a desperate hunt for the truth by a cynical NYC detective tells a classic tale of a dark future. The 1973 science fiction movie Soylent Green is loosely based on this novel.
</details>

#### [The Man in the High Castle](https://www.goodreads.com/book/show/216363.The_Man_in_the_High_Castle) (1962) _by [Philip K. Dick](https://en.wikipedia.org/wiki/Philip_K._Dick)_ [3.8]

My favourite of all Philip K. Dick's novels, the I Ching and the alternate history within an alternate history novel being interesting elements. - [@roryrjb](https://github.com/roryrjb)

<details>
  <summary>Description</summary>

  > An alternate history novel set in 1962, fifteen years after an alternate ending to World War II which in the novel lasted until 1947, the novel concerns intrigues between the victorious Axis Powers—Imperial Japan and Nazi Germany—as they rule over the former United States, as well as daily life under the resulting totalitarian rule.
</details>

#### [The Metamorphosis of Prime Intellect](https://www.goodreads.com/book/show/64341.The_Metamorphosis_of_Prime_Intellect) (2002) _by [Roger Williams](https://www.goodreads.com/author/show/2765575.Roger_Williams)_ [4.2]

An interesting take on the possibly negative consequences of the singularity. A little more vulgar than the average Sci-Fi novel. - [@sylvarant](https://github.com/sylvarant)

<details>
  <summary>Description</summary>

  > In a time not far from our own, Lawrence sets out simply to build an artificial intelligence that can pass as human, and finds himself instead with one that can pass as a god. Taking the Three Laws of Robotics literally, Prime Intellect makes every human immortal and provides instantly for every stated human desire. Caroline finds no meaning in this life of purposeless ease, and forgets her emptiness only in moments of violent and profane exhibitionism. At turns shocking and humorous, Prime Intellect looks unflinchingly at extremes of human behavior that might emerge when all limits are removed.
</details>

#### [Wool Omnibus](https://www.goodreads.com/book/show/13453029-wool-omnibus) (2011) _by [Hugh Howey](https://en.wikipedia.org/wiki/Hugh_Howey)_ [4.3]

Set in the near future, the story follows a number of characters as their lives unfold living in an underground silo. Life underground seems quite grim, people have obviously been down there quite a while, and even though they seem to have quite advanced technology, it's old and decaying. The engineers and mechanics do their best to keep the electricity throughout the 100 levels of the silo, it's a lottery to see who gets to start a family as the population needs to be strictly controlled.

It's set close enough to the present that you can see how things could end up the way they are in the silo, the political structures, the way the silo is organized, the rivalry between the various levels and departments; but what happened to lead to humanity living this way in the first place? Why are they all down there, and what's wrong with the surface?

This series of books is well worth a read, I couldn't put it down once I got into the first few chapters. I think this series will be recognized as a sci-fi classic in the coming years.

Also, the first book is available free on Kindle, so it won't cost you anything to check it out - except maybe a Kindle. - [@elektrovert](https://github.com/elektrovert)

<details>
  <summary>Description</summary>

  > This Omnibus Edition collects the five _Wool_ books into a single volume. It is for those who arrived late to the party and who wish to save a dollar or two while picking up the same stories in a single package.
  >
  > This is the story of mankind clawing for survival, of mankind on the edge. The world outside has grown unkind, the view of it limited, talk of it forbidden. But there are always those who hope, who dream. These are the dangerous people, the residents who infect others with their optimism. Their punishment is simple. They are given the very thing they profess to want: They are allowed outside.
</details>

### Space Opera

_Novels which emphasize adventure, set mainly or entirely in outer space, usually involving conflict between opponents possessing advanced abilities, weapons, and other technology._

#### [Ancillary Justice](https://www.goodreads.com/book/show/17333324-ancillary-justice) (2013) _by [Ann Leckie](https://en.wikipedia.org/wiki/Ann_Leckie)_ [4.0]

_(And all the following [Ancillary Sword](https://www.goodreads.com/book/show/20706284-ancillary-sword))_

<details>
  <summary>Description</summary>

  > On a remote, icy planet, the soldier known as Breq is drawing closer to completing her quest.
  >
  > Once, she was the Justice of Toren—a colossal starship with an artificial intelligence linking thousands of soldiers in the service of the Radch, the empire that conquered the galaxy.
  >
  > Now, an act of treachery has ripped it all away, leaving her with one fragile human body, unanswered questions, and a burning desire for vengeance.
</details>

#### [Battlefield Earth](https://www.goodreads.com/book/show/769658.Battlefield_Earth) (1982) _by [L. Ron Hubbard](https://en.wikipedia.org/wiki/L._Ron_Hubbard)_ [3.4]

<details>
  <summary>Description</summary>

  > Earth has been dominated for 1,000 years by an alien invader—and man is an endangered species. From the handful of surviving humans a courageous leader emerges—Jonnie Goodboy Tyler, who challenges the invincible might of the alien Psychlo empire in a battle of epic scale, danger and intrigue with the fate of the Earth and of the universe in the tenuous balance.
</details>

#### [Commonwealth Saga](https://www.goodreads.com/series/40740-commonwealth-saga) (2004, 2005) _by [Peter F. Hamilton](https://en.wikipedia.org/wiki/Peter_F._Hamilton)_ [4.2]

_(And the sequels in the [Void Trilogy](https://www.goodreads.com/series/43520-void))_

<details>
  <summary>Description</summary>

  > The year is 2380. The Intersolar Commonwealth, a sphere of stars some four hundred light-years in diameter, contains more than six hundred worlds, interconnected by a web of transport “tunnels” known as wormholes. At the farthest edge of the Commonwealth, astronomer Dudley Bose observes the impossible: Over one thousand light-years away, a star… vanishes. It does not go supernova. It does not collapse into a black hole. It simply disappears. Since the location is too distant to reach by wormhole, a faster-than-light starship, the Second Chance, is dispatched to learn what has occurred and whether it represents a threat. In command is Wilson Kime, a five-time rejuvenated ex-NASA pilot whose glory days are centuries behind him.
  >
  > Opposed to the mission are the Guardians of Selfhood, a cult that believes the human race is being manipulated by an alien entity they call the Starflyer. Bradley Johansson, leader of the Guardians, warns of sabotage, fearing the Starflyer means to use the starship’s mission for its own ends.
  >
  > Pursued by a Commonwealth special agent convinced the Guardians are crazy but dangerous, Johansson flees. But the danger is not averted. Aboard the Second Chance, Kime wonders if his crew has been infiltrated. Soon enough, he will have other worries. A thousand light-years away, something truly incredible is waiting: a deadly discovery whose unleashing will threaten to destroy the Commonwealth… and humanity itself. Could it be that Johansson was right?
</details>

#### [Fallen Dragon](https://www.goodreads.com/book/show/45258.Fallen_Dragon) (2001) _by [Peter F. Hamilton](https://en.wikipedia.org/wiki/Peter_F._Hamilton)_ [4.0]

<details>
  <summary>Description</summary>

  > Deploying invulnerable twenty-fifth-century soldiers called Skins, Zantiu-Braun’s corporate starships loot entire planets. But as the Skins invade bucolic Thallspring, Z-B’s strategy is about to go awry, all because of: Sgt. Lawrence Newton, a dreamer whose twenty years as a Skin have destroyed his hopes and desires; Denise Ebourn, a school teacher and resistance leader whose guerrilla tactics rival those of Che Guevara and George Washington and Simon Roderick, the director who serves Z-B with a dedication that not even he himself can understand. Grimly determined to steal, or protect, a mysterious treasure, the three players engage in a private war that will explode into unimaginable quests for personal grace… or galactic domination.
</details>

#### [House of Suns](https://www.goodreads.com/book/show/1126719.House_of_Suns) (2008) _by [Alastair Reynolds](https://en.wikipedia.org/wiki/Alastair_Reynolds)_ [4.1]

<details>
  <summary>Description</summary>

  > Six million years ago, at the dawn of the star-faring era, Abigail Gentian fractured herself into a thousand male and female clones, which she called shatterlings. But now, someone is eliminating the Gentian line. Campion and Purslane—two shatterlings who have fallen in love and shared forbidden experiences—must determine exactly who, or what, their enemy is, before they are wiped out of existence.
</details>

#### [Hyperion](https://www.goodreads.com/book/show/77566.Hyperion) (1989) _by [Dan Simmons](https://en.wikipedia.org/wiki/Dan_Simmons)_ [4.2] 🌟 🔥

<details>
  <summary>Description</summary>

  > On the world called Hyperion, beyond the law of the Hegemony of Man, there waits the creature called the Shrike. There are those who worship it. There are those who fear it. And there are those who have vowed to destroy it. In the Valley of the Time Tombs, where huge, brooding structures move backward through time, the Shrike waits for them all. On the eve of Armageddon, with the entire galaxy at war, seven pilgrims set forth on a final voyage to Hyperion seeking the answers to the unsolved riddles of their lives. Each carries a desperate hope—and a terrible secret. And one may hold the fate of humanity in his hands.
  >
  > A stunning tour de force filled with transcendent awe and wonder, _Hyperion_ is a masterwork of science fiction that resonates with excitement and invention, the first volume in a remarkable new science fiction epic by the multiple-award-winning author of _The Hollow Man_.
</details>

#### [Night’s Dawn Trilogy](https://www.goodreads.com/series/43318-night-s-dawn) (1996, 1997, 1999) _by [Peter F. Hamilton](https://en.wikipedia.org/wiki/Peter_F._Hamilton)_ [4.1]

<details>
  <summary>Description</summary>

  > The trilogy is set in a universe with a wealth of worlds and artificial orbiting colonies. The plot is centered on the souls of the dead coming back from a hellish “beyond” to possess the living, and the latter fighting back. It was followed by a companion to the series, _The Confederation Handbook_, an informational book containing data about the universe of the _Night’s Dawn_ trilogy. Hamilton re-set several earlier short stories in the Confederation timeline, published as the collection _A Second Chance at Eden_, including the newly written title novella.
</details>

#### [Revelation Space](https://www.goodreads.com/series/56392-revelation-space) (2000-2018) _by [Alastair Reynolds](https://en.wikipedia.org/wiki/Alastair_Reynolds)_ [4.0 avg]

Alastair Reynolds' take on the Fermi Paradox is a vast and brutal epic, consisting of the three "main" books (forming the "Inhibitor Trilogy") and a few other books and novellas set in the same universe. Revelation Space is page-turning "hard space opera" - believable but fantastic, and delightfully bizarre at times. - [@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > Nine hundred thousand years ago, something annihilated the Amarantin civilization just as it was on the verge of discovering space flight. Now one scientist, Dan Sylveste, will stop at nothing to solve the Amarantin riddle before ancient history repeats itself. With no other resources at his disposal, Sylveste forges a dangerous alliance with the cyborg crew of the starship Nostalgia for Infinity. But as he closes in on the secret, a killer closes in on him. Because the Amarantin were destroyed for a reason — and if that reason is uncovered, the universe—and reality itself — could be irrecoverably altered...
</details>

#### [Salvation](https://www.goodreads.com/book/show/34068552-salvation) (2018-2020) _by [Peter F. Hamilton](https://en.wikipedia.org/wiki/Peter_F._Hamilton)_ [4.19 avg]

Peter Hamilton is back with another story featuring a wormhole-based multi-planetary society, and this one has elements of both space opera and cyberpunk. The perspective shifts between 2204 and several thousand years into the future. Starts slow but when the shit hits the fan it hits with a vengeance. Three books in total, a very good read. - [@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > In 2204, humanity is expanding into the wider galaxy in leaps and bounds. A new technology of linked jump gates has rendered most forms of transporation--including starships--virtually obsolete. Every place on earth, every distant planet mankind has settled, is now merely a step away from any other. And all seems wonderful...until a crashed alien spaceship is found on a newly-located world 89 light years from Earth, harboring seventeen human victims. And of the high-powered team dispatched to investigate the mystery, one is an alien spy...
</details>

#### [The Culture Series](https://www.goodreads.com/series/49118-culture) (1987-2012) _by [Iain M. Banks](https://en.wikipedia.org/wiki/Iain_Banks)_ [4.5 (avg)]

<details>
  <summary>Description</summary>

  > The war raged across the galaxy. Billions had died, billions more were doomed. Moons, planets, the very stars themselves, faced destruction, cold-blooded, brutal, and worse, random. The Idirans fought for their Faith; the Culture for its moral right to exist. Principles were at stake. There could be no surrender.
</details>

### Post Apocalyptic

_Novels concerning the end of civilization, usually based in a future resulting from a catastrophe of some sort, where only scattered elements of technology remain._

#### [A Canticle for Leibowitz](https://www.goodreads.com/book/show/164154.A_Canticle_for_Leibowitz) (1959) _by [Walter M. Miller, Jr.](https://en.wikipedia.org/wiki/Walter_M._Miller,_Jr.)_ [4.0]

This has a particularly arid and inspired view of humanity after a nuclear holocaust. The discovery of small things and their new importance down the line is well done here. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Winner of the 1961 Hugo Award for Best Novel and widely considered one of the most accomplished, powerful, and enduring classics of modern speculative fiction, Walter M. Miller, Jr.’s _A Canticle for Leibowitz_ is a true landmark of twentieth-century literature—a chilling and still provocative look at a post-apocalyptic future.
  >
  > In a nightmarish ruined world slowly awakening to the light after sleeping in darkness, the infant rediscoveries of science are secretly nourished by cloistered monks dedicated to the study and preservation of the relics and writings of the blessed Saint Isaac Leibowitz. From here the story spans centuries of ignorance, violence, and barbarism, viewing through a sharp, satirical eye the relentless progression of a human race damned by its inherent humanness to recelebrate its grand foibles and repeat its grievous mistakes. Seriously funny, stunning, and tragic, eternally fresh, imaginative, and altogether remarkable, _A Canticle for Leibowitz_ retains its ability to enthrall and amaze. It is now, as it always has been, a masterpiece.
  
</details>

#### [Borne](https://www.goodreads.com/book/show/31451186-borne) (2017) _by [Jeff VanderMeer](https://en.wikipedia.org/wiki/Jeff_VanderMeer)_ [4.0]

A weird, beautiful book, reminiscent of Lovecraft, Stephen King, and Brautigan's _Watermelon Sugar_ all wrapped up in a post-apocalyptic landscape populated by poisonous fire-breathing bears and deprecated biotech. This book is a survival story - how to hang on to the edges of civilization, and what that means for humanity. It also questions identity, love, mothering, and meaning itself. Some of the passages were astoundingly beautiful, and as much as the world would be an awful place to live in, I found myself missing it when I finished. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In the ruins of a nameless city of the future, ruled by a giant grizzly called Mord, a woman named Rachel lives as a scavenger, collecting genetically engineered organisms and experiments created by the biotech firm the Company. Hidden in Mord's fur, she finds a sea anemone shaped creature she calls Borne.
</details>

#### [Do Androids Dream of Electric Sheep?](https://www.goodreads.com/book/show/7083.Do_Androids_Dream_of_Electric_Sheep_) (1968) _by [Philip K. Dick](https://en.wikipedia.org/wiki/Philip_K._Dick)_ [4.1] 🌟 🔥

<details>
  <summary>Description</summary>

  > A final, apocalyptic, world war has killed millions, driving entire species into extinction and sending the majority of mankind off-planet. Those who remain, venerate all remaining examples of life, and owning an animal of your own is both a symbol of status and a necessity. For those who can’t afford an authentic animal, companies build incredibly realistic simulacrae: horses, birds, cats, sheep… even humans.
</details>

#### [Earth Abides](https://www.goodreads.com/book/show/93269.Earth_Abides) (1949) _by [George R. Stewart](https://en.wikipedia.org/wiki/George_R._Stewart)_ [3.9]

Highly plausible outcome after a near-extinction event, the human race will hopelessly go down the path of least resistance. Great and somewhat disheartening ending. - [@uraimo](https://github.com/uraimo)

<details>
  <summary>Description</summary>

  > A disease of unparalleled destructive force has sprung up almost simultaneously in every corner of the globe, all but destroying the human race. One survivor, strangely immune to the effects of the epidemic, ventures forward to experience a world without man. What he ultimately discovers will prove far more astonishing than anything he'd either dreaded or hoped for.
</details>

#### [Riddley Walker](https://www.goodreads.com/book/show/776573.Riddley_Walker) (1980) _by [Russell Hoban](https://en.wikipedia.org/wiki/Russell_Hoban)_ [4.1]

I traveled 500 miles from Edinburgh to Kent just to go to the Canterbury Cathedral to see the painting that inspired this book. It is that good. It was hard for me to read as I normally speed read, and the invented language makes it slow going, but it sticks with you and the imagination of Hoban is uniquely vivid. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > _Riddley Walker_ is a brilliant, unique, completely realized work of fiction. One reads it again and again, discovering new wonders every time through. Set in a remote future in a post-nuclear holocaust England (Inland), Hoban has imagined a humanity regressed to an iron-age, semi-literate state—and invented a language to represent it. Riddley is at once the Huck Finn and the Stephen Dedalus of his culture—rebel, change agent, and artist. Read again or for the first time this masterpiece of 20th-century literature with new material by the author.
</details>

#### [Severance](https://www.goodreads.com/book/show/36348525-severance) (2018) _by [Ling Ma](https://www.goodreads.com/author/show/17343848.Ling_Ma)_ [3.8]

Although I'd like to believe I'd do well in the apocalypse, this story spells out how a younger me might've fared. - [@neontapir](https://github.com/neontapir)

<details>
  <summary>Description</summary>

  > An offbeat office novel turns apocalyptic satire as a young woman transforms from orphan to worker bee to survivor.
  >
  > Candace Chen, a millennial drone self-sequestered in a Manhattan office tower, is devoted to routine. She barely notices when a plague of biblical proportions sweeps New York. Her bosses enlist her as part of a dwindling skeleton crew with a big end-date payoff. Soon entirely alone, still unfevered, she photographs the eerie, abandoned city as the anonymous blogger NY Ghost. Candace won’t be able to make it on her own forever, though. Enter a group of survivors, led by the power-hungry IT tech Bob. They’re traveling to a place called the Facility, where, Bob promises, they will have everything they need to start society anew. But Candace is carrying a secret she knows Bob will exploit. Should she escape from her rescuers?
</details>

#### [The City and the Stars](https://www.goodreads.com/book/show/250024.The_City_and_the_Stars) (1956) _by [Arthur C. Clarke](https://en.wikipedia.org/wiki/Arthur_C._Clarke)_ [4.1]

One of Arthur C. Clarke's best novels. It makes _Childhood's End_ seem a bit immature in comparison, and evokes that strange concept of deep space that was prevalent in the 50s and in the early Star Trek series which seems to be out of fashion more recently. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Clarke’s masterful evocation of the far future of humanity, considered his finest novel. _The City and the Stars_ takes place one billion years in the future, in the city of Diaspar. By this time, the Earth is so old that the oceans have gone and humanity has all but left. As far as the people of Diaspar know, they are the only city left on the planet. The city of Diaspar is completely enclosed. Nobody has come in or left the city for as long as anybody can remember, and everybody in Diaspar has an instinctive insular conservatism. The story behind this fear of venturing outside the city tells of a race of ruthless invaders which beat humanity back from the stars to Earth, and then made a deal that humanity could live—if they never left the planet.
</details>

#### [The City of Ember](https://www.goodreads.com/book/show/307791.The_City_of_Ember) (2003) _by [Jeanne DuPrau](https://www.goodreads.com/author/show/2347.Jeanne_DuPrau)_ [3.9]

A less violent coming of age story in the vein of _Hugo_ or _The Hunger Games_. - [@neontapir](https://github.com/neontapir)

<details>
  <summary>Description</summary>

  > Many hundreds of years ago, the city of Ember was created by the Builders to contain everything needed for human survival. It worked…but now the storerooms are almost out of food, crops are blighted, corruption is spreading through the city and worst of all—the lights are failing. Soon Ember could be engulfed by darkness…
  >
  > But when two children, Lina and Doon, discover fragments of an ancient parchment, they begin to wonder if there could be a way out of Ember. Can they decipher the words from long ago and find a new future for everyone? Will the people of Ember listen to them?
</details>

#### [The Drowned World](https://www.goodreads.com/book/show/16234584-the-drowned-world) (1963) _by [J. G. Ballard](https://en.wikipedia.org/wiki/J._G._Ballard)_ [3.6]

This had some very haunting scenes. The last pages, in particular, will stick with me for a while. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > First published in 1962, J. G. Ballard’s mesmerizing and ferociously prescient novel imagines a terrifying future in which solar radiation and global warming have melted the ice caps and Triassic-era jungles have overrun a submerged and tropical London. Set during the year 2145, the novel follows biologist Dr. Robert Kerans and his team of scientists as they confront a surreal cityscape populated by giant iguanas, albino alligators, and endless swarms of malarial insects. Nature has swallowed all but a few remnants of human civilization, and, slowly, Kerans and his companions are transformed—both physically and psychologically—by this prehistoric environment. Echoing Joseph Conrad’s _Heart of Darkness_—complete with a mad white hunter and his hordes of native soldiers—this “powerful and beautifully clear” (Brian Aldiss) work becomes a thrilling adventure and a haunting examination of the effects of environmental collapse on the human mind.
</details>

#### [The Machine Stops](https://www.goodreads.com/book/show/4711854-the-machine-stops) (1909) _by [Edward Morgan Forster](https://en.wikipedia.org/wiki/E._M._Forster)_ [4.0] 🌟

A short and rather old post-apocalyptic story which remained stuck in my mind like a ROM data. Being under strong impressions after consuming it in an instant, I described this rare pearl of a story to a Norwegian [NTNU](https://en.wikipedia.org/wiki/Norwegian_University_of_Science_and_Technology) professor. To my surprise it ended as a further recommendation to his students or/and an actual part of their course reading materials. You'll definitely want to read about this machine out of wedlock between 'Facebook' and 'Google' from the beginning of 20th century. I have yet to see other such power of prediction as to where the world is now or might go. Advice to readers: Keep in mind while reading that the text has been coined about 100 years ago - it's part of the magic. - [@zarko-tg](https://github.com/zarko-tg)

<details>
  <summary>Description</summary>

  > The story, set in a post-apocalyptic world where humanity lives underground and relies on a giant machine to provide their needs, predicted new technologies such as instant messaging, and the Internet. It describes a world in which most of the human population has lost the ability to live on the surface of the Earth. Each individual now lives in isolation below ground in a standard 'cell', with all bodily and spiritual needs met by the omnipotent, global Machine. Travel is permitted but unpopular and rarely necessary. Communication is made via a kind of instant messaging/video conferencing machine with which people conduct their only activity: the sharing of ideas and what passes for knowledge.
</details>

#### [The Road](https://www.goodreads.com/book/show/6288.The_Road) (2006) _by [Cormac McCarthy](https://www.goodreads.com/author/show/4178.Cormac_McCarthy)_ [4.0]

A dreary story that compels you forward with its unyielding backdrop and vivid characters. - [@neontapir](https://github.com/neontapir)

<details>
  <summary>Description</summary>

  > A father and his son walk alone through burned America. Nothing moves in the ravaged landscape save the ash on the wind. It is cold enough to crack stones, and when the snow falls it is gray. The sky is dark. Their destination is the coast, although they don’t know what, if anything, awaits them there. They have nothing; just a pistol to defend themselves against the lawless bands that stalk the road, the clothes they are wearing, a cart of scavenged food—and each other. It boldly imagines a future in which no hope remains, but in which the father and his son, “each the other’s world entire,” are sustained by love. Winner of the 2007 Pulitzer Prize for fiction.
</details>

#### [The Stand](https://www.goodreads.com/book/show/149267.The_Stand) (1978) _by [Stephen King](https://en.wikipedia.org/wiki/Stephen_King)_ [4.3] 🔥

<details>
  <summary>Description</summary>

  > This is the way the world ends: with a nanosecond of computer error in a Defense Department laboratory and a million casual contacts that form the links in a chain letter of death.
  >
  > And here is the bleak new world of the day after: a world stripped of its institutions and emptied of 99 percent of its people. A world in which a handful of panicky survivors choose sides—or are chosen. A world in which good rides on the frail shoulders of the 108-year-old Mother Abagail—and the worst nightmares of evil are embodied in a man with a lethal smile and unspeakable powers: Randall Flagg, the dark man.
  >
  > In 1978 Stephen King published _The Stand_, the novel that is now considered to be one of his finest works. But as it was first published, _The Stand_ was incomplete, since more than 150,000 words had been cut from the original manuscript.
  >
  > Now Stephen King’s apocalyptic vision of a world blasted by plague and embroiled in an elemental struggle between good and evil has been restored to its entirety. _The Stand: The Complete and Uncut Edition_ includes more than five hundred pages of material previously deleted, along with new material that King added as he reworked the manuscript for a new generation. It gives us new characters and endows familiar ones with new depths. It has a new beginning and a new ending. What emerges is a gripping work with the scope and moral complexity of a true epic.
</details>

#### [Time Storm](https://www.goodreads.com/book/show/536951.Time_Storm) (1977) _by [Gordon R. Dickson](https://en.wikipedia.org/wiki/Gordon_R._Dickson)_ [3.7]

<details>
  <summary>Description</summary>

  > A time storm has devastated the Earth, and only a small fraction of humankind remains. From the rubble, three survivors form an unlikely alliance: a young man, a young woman, and a leopard.
</details>

#### [Where Late the Sweet Birds Sang](https://www.goodreads.com/book/show/968827.Where_Late_the_Sweet_Birds_Sang) (1974) _by [Kate Wilhelm](https://en.wikipedia.org/wiki/Kate_Wilhelm)_ [3.9]

<details>
  <summary>Description</summary>

  > The spellbinding story of an isolated post-holocaust community determined to preserve itself, through a perilous experiment in cloning. Sweeping, dramatic, rich with humanity, and rigorous in its science, _Where Late the Sweet Birds Sang_ is widely regarded as a high point of both humanistic and hard SF, winning SF’s Hugo Award and Locus Award on its first publication.
</details>

### Military Science Fiction

_Novels featuring the use use of technology, mainly weapons, for military purposes and principal characters that are members of a military organization involved in military activity; sometimes occurring in outer space or other planets._

#### [Armor](https://www.goodreads.com/book/show/102327.Armor) (1984) _by [John Steakley](https://en.wikipedia.org/wiki/John_Steakley)_ [4.12]

Steakley puts his readers inside the mind of an armored soldier who lives in constant fear of being torn apart by the enemy he was sent to fight. The book plays brilliantly on our innate fear of bugs and describes the visceral terror of fighting a nearly unstoppable enemy. - [@phmullins](https://github.com/phmullins)

<details>
  <summary>Description</summary>

  > Felix is an Earth soldier, encased in special body armor designed to withstand Earth's most implacable enemy-a bioengineered, insectoid alien horde. But Felix is also equipped with internal mechanisms that enable him, and his fellow soldiers, to survive battle situations that would destroy a man's mind. This is a remarkable novel of the horror, the courage, and the aftermath of combat--and how the strength of the human spirit can be the greatest armor of all.
</details>

#### [The Aurora Cycle Series](https://www.goodreads.com/series/179394-the-aurora-cycle) (2019-2021) _by [Amie Kaufman](https://en.wikipedia.org/wiki/Amie_Kaufman)_ [4.2]

This novel starts as a simple rescue by a cadet that led to the entire universe fighting an epic battle they have no hope of winning.

What makes this novel awesome is the build up to the final epic battle. It starts as a small team of ragtags who were framed for a crime and later find out that the least of their worry is the intergalactic military but rather an incomprehensible galaxy ending force whose sole existence is to added all living things to its hive. - [@sammy4gh](https://github.com/sammy4gh)

<details>
  <summary>Description</summary>

  > The year is 2380, and the graduating cadets of Aurora Academy are being assigned their first missions. Star pupil Tyler Jones is ready to recruit the squad of his dreams, but his own boneheaded heroism sees him stuck with the dregs nobody else in the Academy would touch…
  >
  > A cocky diplomat with a black belt in sarcasm, A sociopath scientist with a fondness for shooting her bunkmates ,A smart-ass techwiz with the galaxy’s biggest chip on his shoulder, An alien warrior with anger management issues ,A tomboy pilot who’s totally not into him, in case you were wondering
  >
  > And Ty’s squad isn’t even his biggest problem—that’d be Aurora Jie-Lin O’Malley, the girl he’s just rescued from interdimensional space. Trapped in cryo-sleep for two centuries, Auri is a girl out of time and out of her depth. But she could be the catalyst that starts a war millions of years in the making, and Tyler’s squad of losers, discipline-cases and misfits might just be the last hope for the entire galaxy.
  >
  > They're not the heroes we deserve. They're just the ones we could find. Nobody panic.
</details>

Books:

- [Aurora Rising](https://www.goodreads.com/book/show/30075662-aurora-rising) [4.1]
- [Aurora Burning](https://www.goodreads.com/book/show/40516960-aurora-burning) [4.3]
- [Aurora's End](https://www.goodreads.com/book/show/40516976-aurora-s-end) [4.2]

#### [Ender’s Game](https://www.goodreads.com/book/show/375802.Ender_s_Game) (1985) _by [Orson Scott Card](https://en.wikipedia.org/wiki/Orson_Scott_Card)_ [4.3] 🌟 🔥

This is a quick read, but it has a slow burn; the more times I read this book, and the more I think of it, the better it becomes. This book is one of the most strategically interesting books I have read. At every turn, you can feel Orson Scott Card manipulating you into seeing how brilliant Ender is. A masterpiece. - [@RichardLitt](https://github.com/RichardLitt)

I’ve lost count of the amount of times I have read _Ender’s Game_. I generally read it around once a year, at least. It is part of a larger series, including _Speaker for the Dead_, and _Xenocide_ - follow-ups which build on _Ender’s Game_ and which are, in their own right, great books. _EG_ was originally just a short story, a kind of prequel to the themes spoken of in _Speaker for the Dead_. It shows Card’s talent that he was able to so fluently make it a stand-alone book.

I love _Ender’s Game_. All things considered, this is not a book about emotional development, or about coming of age. It’s not about taking on the weight of the world. Rather, this is a book about strategy. More happens in the gaps between the pages than in the chapters themselves - taking the time to figure out how Ender worked out an advantage in a game room, and how you would have done it, is an incredibly rewarding experience. Every now and then, there is a wonderful feeling of ‘Damn, I wish I had done that! So smart.’ And, as Card notes in the prologue:

> Fiction, because it is not about somebody who actually lived in the real world, always has the possibility of being about ourself.

So, you’re able to share in Ender’s cleverness, too. That’s what makes this book a fun read. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In order to develop a secure defense against a hostile alien race’s next attack, government agencies breed child geniuses and train them as soldiers. A brilliant young boy—Andrew “Ender” Wiggin—lives with his kind but distant parents, his sadistic brother Peter, and the person he loves more than anyone else, his sister Valentine. Peter and Valentine were candidates for the soldier-training program but didn’t make the cut—young Ender is the Wiggin drafted to the orbiting Battle School for rigorous military training.
  >
  > Ender’s skills make him a leader in school and respected in the Battle Room, where children play at mock battles in zero gravity. Yet growing up in an artificial community of young soldiers Ender suffers greatly from isolation, rivalry from his peers, pressure from the adult teachers, and an unsettling fear of the alien invaders. His psychological battles include loneliness, fear that he is becoming like the cruel brother he remembers, and fanning the flames of devotion to his beloved sister.
  >
  > Is Ender the general Earth needs? But Ender is not the only result of the genetic experiments. The war with the Buggers has been raging for a hundred years, and the quest for the perfect general has been underway for almost as long. Ender’s two older siblings are every bit as unusual as he is, but in very different ways. Between the three of them lie the abilities to remake a world. If, that is, the world survives.
</details>

#### [Expeditionary Force](https://www.goodreads.com/series/185650-expeditionary-force) (2016-) _by [Craig Alanson](https://en.wikipedia.org/wiki/Craig_Alanson)_ [4.38] 

The Expeditionary Force is a sprawling science-fiction saga that blends military sci-fi, space opera, and irreverent humor into a fast-paced, character-driven adventure. Centered on U.S. Army Sergeant Joe Bishop and his unlikely partnership with an all-powerful, arrogant artificial intelligence nicknamed Skippy the Magnificent, the series takes readers from a sudden alien invasion of Earth into the depths of interstellar politics and warfare. While it is corny at times, and there's definitely some deus ex machina going on, the 19 Books, short novel _Trouble on Paradise_, the Audio Only _Homefront_ and the two books in the _Mavericks_ Series create an absolutely gripping story for which I drop everything to listen to the next installment when it releases. The Audio book series spoken by R.C. Bray is just masterfully done as well. [@Anuril](https://github.com/Anuril)

<details>
  <summary>Description</summary>

  > At the outset in Columbus Day, humanity is blindsided when the Ruhar, a fur-covered alien species, devastate Earth in a strike that pushes civilization back toward pre-industrial levels. In the chaos, Bishop is swept up into the fledgling United Nations Expeditionary Force, a human contingent drafted into an intergalactic conflict between the Ruhar and the reptilian Kristang. Against all odds—and armed with little more than grit, military training, and moments of baffling luck—Bishop and a small band of soldiers ally with the Kristang, discovering that humans are hopelessly outclassed in firepower and technology. [Source](https://www.terranceacrow.com/posts/expeditionary-force-book-review/) 

</details>

Books: 
- Columbus Day
- SpecOps
- Paradise
- (Trouble on Paradise)
- Black Ops
- Zero Hour
- Mavericks
- Renegades
- (Homefront) (Audio only)
- Armageddon
- Valkyrie
- Critical Mass
- Brushfire
- Breakaway
- Fallout
- Failure Mode
- Aftermath
- Task Force Hammer
- Gateway
- Ground State

#### [Frontlines Series](https://www.goodreads.com/series/125903-frontlines) (2013-) _by [Marko Kloos](https://www.markokloos.com/)_ [4.05]

A very entertaining military drama that has continued to grow on me, book by book. [@AlexKeyes](https://github.com/alex-keyes)

<details>
  <summary>Description</summary>

  > The year is 2108, and the North American Commonwealth is bursting at the seams. For welfare rats like Andrew Grayson, there are only two ways out of the crime-ridden and filthy welfare tenements, where you're restricted to two thousand calories of badly flavored soy every day.
  >
  > You can hope to win the lottery and draw a ticket on a colony ship settling off-world, or you can join the service.
  >
  > With the colony lottery a pipe dream, Andrew chooses to enlist in the armed forces for a shot at real food, a retirement bonus, and maybe a ticket off Earth. But as he starts a career of supposed privilege, he soon learns that the good food and decent health care come at a steep price…and that the settled galaxy holds far greater dangers than military bureaucrats or the gangs that rule the slums.
  >
  > The debut novel from Marko Kloos, Terms of Enlistment is a new addition to the great military sci-fi tradition of Robert Heinlein, Joe Haldeman, and John Scalzi.
</details>

#### [Old Man’s War](https://www.goodreads.com/series/40789-old-man-s-war) (2005-2015) _by [John Scalzi](https://en.wikipedia.org/wiki/John_Scalzi)_ [4.2]

<details>
  <summary>Description</summary>

  > _Old Man’s War_, _The Last Colony_ and _Zoe’s Tale_ were each nominated for the Hugo Award for Best Novel in their respective years. _Zoe’s Tale_ was additionally nominated for the Andre Norton Award for Best Young Adult Science Fiction/Fantasy. _The Ghost Brigades_ was nominated for the Prometheus Award. _Old Man’s War_ was the winner of the Geffen Award in Israel; _The Last Colony_ the recipient of the Seiun Award in Japan.
</details>

#### [Starship Troopers](https://www.goodreads.com/book/show/17214.Starship_Troopers) (1959) _by [Robert A. Heinlein](https://en.wikipedia.org/wiki/Robert_A._Heinlein)_ [4.0]

<details>
  <summary>Description</summary>

  > In one of Robert Heinlein’s most controversial bestsellers, a recruit of the future goes through the toughest boot camp in the Universe—and into battle with the Terran Mobile Infantry against mankind’s most frightening enemy.
</details>

#### [The Forever War](https://www.goodreads.com/book/show/21611.The_Forever_War) (1974) _by [Joe Haldeman](https://en.wikipedia.org/wiki/Joe_Haldeman)_ [4.1]

<details>
  <summary>Description</summary>

  > The Earth’s leaders have drawn a line in the interstellar sand—despite the fact that the fierce alien enemy that they would oppose is inscrutable, unconquerable, and very far away. A reluctant conscript drafted into an elite Military unit, Private William Mandella has been propelled through space and time to fight in the distant thousand-year conflict; to perform his duties without rancor and even rise up through military ranks. Pvt. Mandella is willing to do whatever it takes to survive the ordeal and return home. But “home” may be even more terrifying than battle, because, thanks to the time dilation caused by space travel, Mandella is aging months while the Earth he left behind is aging centuries.
</details>

#### [The Ultramarines Omnibus](https://www.goodreads.com/book/show/31638.The_Ultramarines_Omnibus) (2008) _by [Graham Mcniell](https://en.wikipedia.org/wiki/Graham_McNeill)_ [3.96]

Conan the Barbarian in space. - [@alex-keyes](https://github.com/alex-keyes)

<details>
  <summary>Description</summary>

  > The Ultramarines are a byword for loyalty and courage, their martial prowess is legendary and is second only to the God-Emperor.
  >
  > Graham Mcneill's epic trilogy of Ultramarines novels is a masterpiece of non-stop action! Containing the novels Nightbringer, Warriors of Ultramar and Dead Sky, Black Sun, plus a connected short story, Chains of Command, the series follows the adventures of Space Marine Captain Uriel Ventris and the Ultramarines as they battle against the enemies of mankind. From their home world of Macragge, into the dreaded Eye of Terror and beyond, Graham McNeill's prose rattles like gunfire and brings the Space Marines to life like never before.
</details>

### Police Procedural Science Fiction

#### [Lock In](https://www.goodreads.com/book/show/21418013-lock-in) (2014) _by [John Scalzi](https://en.wikipedia.org/wiki/John_Scalzi)_ [3.8]

<details>
  <summary>Description</summary>

  > A novel of our near future, from one of the most popular authors in modern SF.
  >
  > Fifteen years from now, a new virus sweeps the globe. 95% of those afflicted experience nothing worse than fever and headaches. Four percent suffer acute meningitis, creating the largest medical crisis in history. And one percent find themselves “locked in”—fully awake and aware, but unable to move or respond to stimulus.
  >
  > One per cent doesn’t seem like a lot. But in the United States, that’s 1.7 million people “locked in”… including the President’s wife and daughter.
  >
  > Spurred by grief and the sheer magnitude of the suffering, America undertakes a massive scientific initiative. Nothing can restore the ability to control their own bodies to the locked in. But then two new technologies emerge. One is a virtual-reality environment, “The Agora,” in which the locked-in can interact with other humans, both locked-in and not. The other is the discovery that a few rare individuals have brains that are receptive to being controlled by others, meaning that from time to time, those who are locked in can “ride” these people and use their bodies as if they were their own.
  >
  > This skill is quickly regulated, licensed, bonded, and controlled. Nothing can go wrong. Certainly nobody would be tempted to misuse it, for murder, for political power, or worse…
</details>

### Techno Thriller

_Novels which draw from sci-fi, thrillers, spying, action and wars. Include lots of technical detail regarding the subject matter._

#### [Cryptonomicon](https://www.goodreads.com/book/show/816.Cryptonomicon) (1999) _by [Neal Stephenson](https://en.wikipedia.org/wiki/Neal_Stephenson)_ [4.2]

<details>
  <summary>Description</summary>

  > _Cryptonomicon_ zooms all over the world, careening conspiratorially back and forth between two time periods—World War II and the present. Our 1940s heroes are the brilliant mathematician Lawrence Waterhouse, cryptanalyst extraordinaire, and gung-ho, morphine-addicted marine Bobby Shaftoe. They’re part of Detachment 2702, an Allied group trying to break Axis communication codes while simultaneously preventing the enemy from figuring out that their codes have been broken. Their job boils down to layer upon layer of deception. Dr. Alan Turing is also a member of 2702, and he explains the unit’s strange workings to Waterhouse. “When we want to sink a convoy, we send out an observation plane first… Of course, to observe is not its real duty—we already know exactly where the convoy is. Its real duty is to be observed… Then, when we come round and sink them, the Germans will not find it suspicious.”
  >
  > All of this secrecy resonates in the present-day story line, in which the grandchildren of the WWII heroes—inimitable programming geek Randy Waterhouse and the lovely and powerful Amy Shaftoe—team up to help create an offshore data haven in Southeast Asia and maybe uncover some gold once destined for Nazi coffers. To top off the paranoiac tone of the book, the mysterious Enoch Root, key member of Detachment 2702 and the Societas Eruditorum, pops up with an unbreakable encryption scheme left over from WWII to befuddle the 1990s protagonists with conspiratorial ties.
</details>

#### [Daemon](https://www.goodreads.com/series/49858-daemon) (2006, 2010) _by [Daniel Suárez](https://en.wikipedia.org/wiki/Daniel_Su%C3%A1rez)_ [4.2]

<details>
  <summary>Description</summary>

  > Already an underground sensation, a high-tech thriller for the wireless age that explores the unthinkable consequences of a computer program running without human control—a daemon—designed to dismantle society and bring about a new world order.
  
  > Technology controls almost everything in our modern-day world, from remote entry on our cars to access to our homes, from the flight controls of our airplanes to the movements of the entire world economy. Thousands of autonomous computer programs, or daemons, make our networked world possible, running constantly in the background of our lives, trafficking e-mail, transferring money, and monitoring power grids. For the most part, daemons are benign, but the same can’t always be said for the people who design them.
  >
  > Matthew Sobol was a legendary computer game designer—the architect behind half-a-dozen popular online games. His premature death depressed both gamers and his company’s stock price. But Sobol’s fans aren’t the only ones to note his passing. When his obituary is posted online, a previously dormant daemon activates, initiating a chain of events intended to unravel the fabric of our hyper-efficient, interconnected world. With Sobol’s secrets buried along with him, and as new layers of his daemon are unleashed at every turn, it’s up to an unlikely alliance to decipher his intricate plans and wrest the world from the grasp of a nameless, faceless enemy—or learn to live in a society in which we are no longer in control…
  >
  > Computer technology expert Daniel Suarez blends haunting high-tech realism with gripping suspense in an authentic, complex thriller in the tradition of Michael Crichton, Neal Stephenson, and William Gibson.
</details>

#### [Sphere](https://www.goodreads.com/book/show/455373.Sphere) (1987) _by [Michael Crichton](https://en.wikipedia.org/wiki/Michael_Crichton)_ [3.7] 🌟 🔥

Twitter user: My favorite novel. Movie was worse than terrible.

<details>
  <summary>Description</summary>

  > A group of American scientists are rushed to a huge vessel that has been discovered resting on the ocean floor in the middle of the South Pacific. What they find defines their imaginations and mocks their attempts at logical explanation. It is a spaceship of phenomenal dimensions, apparently, undamaged by its fall from the sky. And, most startling, it appears to be at least three hundred years old…
</details>

### Fantasy

_Fantasy books which contain elements of science fiction. For pure fantasy, see [this list](https://github.com/RichardLitt/awesome-fantasy)._

#### [The Book of the Long Sun](https://www.goodreads.com/series/43253-the-book-of-the-long-sun) (1993, 1994, 1996) _by [Gene Wolfe](https://en.wikipedia.org/wiki/Gene_Wolfe)_ [4.0]

<details>
  <summary>Description</summary>

  > Set aboard a vast starship traveling for generations, _The Book of the Long Sun_ is a masterpiece of science fiction. The series follows the story of Patera Silk, a priest who becomes a prophet as he learns about the nature of his world and the gods he serves.
</details>

#### [The Book of the New Sun](https://www.goodreads.com/series/41474-the-book-of-the-new-sun) (1980-1987) _by [Gene Wolfe](https://en.wikipedia.org/wiki/Gene_Wolfe)_ [3.9]

This is my favorite book. It is science fiction and, to a certain extent, fantasy, but at places reads more like a philosophical tract of a collection of stories. The plot is minimal, but the character of Severian is fascinating; he forgets nothing, but lies to you. As you read along, it becomes clear that earlier chapters were wrong or lacked important details, which heavily contributes to a sense of wonder and enchantment. Or, in my case, aw at Gene Wolfe's writing abilities. Highly suggested. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > _The Book of the New Sun_ is unanimously acclaimed as Gene Wolfe’s most remarkable work, hailed as “a masterpiece of science fantasy comparable in importance to the major works of Tolkien and Lewis” by _Publishers Weekly_, and “one of the most ambitious works of speculative fiction in the twentieth century” by _The Magazine of Fantasy and Science Fiction_.
  >
  > Young Severian, an apprentice in the Guild of Torturers on the world called Urth, has been exiled for committing the ultimate sin of his profession—showing mercy toward his victim.
</details>

#### [There Are Doors](https://www.goodreads.com/book/show/666601.There_Are_Doors) (1988) _by [Gene Wolfe](https://en.wikipedia.org/wiki/Gene_Wolfe)_ [3.6]

This is debatably science fiction. I mention it here because certain elements, like a lot of Gene Wolfe's works, are science fiction - for instance, the android-esque doll. This book is much more of a fantasy. I love it, but it's a bit weird in places. If you like Gene Wolfe, read it. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > _There Are Doors_ is the story of a man who falls in love with a goddess from an alternate universe. She flees him, but he pursues her through doorways—interdimensional gateways—to the other place, determined to sacrifice his life, if necessary, for her love.
</details>

### Drama

#### [The Bone Clocks](https://www.goodreads.com/book/show/20819685-the-bone-clocks) (2014) _by [David Mitchell](https://en.wikipedia.org/wiki/David_Mitchell_%28author%29)_ [3.9]

If you liked Cloud Atlas this is a good read.

<details>
  <summary>Description</summary>

  > Following a scalding row with her mother, fifteen-year-old Holly Sykes slams the door on her old life. But Holly is no typical teenage runaway: a sensitive child once contacted by voices she knew only as “the radio people,” Holly is a lightning rod for psychic phenomena. Now, as she wanders deeper into the English countryside, visions and coincidences reorder her reality until they assume the aura of a nightmare brought to life.
  >
  > For Holly has caught the attention of a cabal of dangerous mystics—and their enemies. But her lost weekend is merely the prelude to a shocking disappearance that leaves her family irrevocably scarred. This unsolved mystery will echo through every decade of Holly’s life, affecting all the people Holly loves—even the ones who are not yet born.
  >
  > A Cambridge scholarship boy grooming himself for wealth and influence, a conflicted father who feels alive only while reporting from occupied Iraq, a middle-aged writer mourning his exile from the bestseller list—all have a part to play in this surreal, invisible war on the margins of our world. From the medieval Swiss Alps to the nineteenth-century Australian bush, from a hotel in Shanghai to a Manhattan townhouse in the near future, their stories come together in moments of everyday grace and extraordinary wonder.
</details>

### Biopunk

_Novels which focus on the near-future unintended consequences of biotechnology revolutions._

#### [Kiln People](https://www.goodreads.com/book/show/96478.Kiln_People) (2002) _by [David Brin](https://www.goodreads.com/author/show/14078.David_Brin)_ [3.8]

This novel explores how society might adapt to affordable temporary cloning of one's self. - [@neontapir](https://github.com/neontapir)

<details>
  <summary>Description</summary>

  > In a perilous future where disposable duplicate bodies fulfill every legal and illicit whim of their decadent masters, life is cheap. No one knows that better than Albert Morris, a brash investigator with a knack for trouble, who has sent his own duplicates into deadly peril more times than he cares to remember. But when Morris takes on a ring of bootleggers making illegal copies of a famous actress, he stumbles upon a secret so explosive it has incited open warfare on the streets of Dittotown. Morris must enter a shadowy, nightmare world of ghosts and golems where nothing -- and no one -- is what they seem, memory itself is suspect, and the line between life and death may no longer exist.
</details>

#### [Pandemic](https://www.goodreads.com/book/show/34811896-pandemic) (2017) _by [A.G. Riddle](https://www.goodreads.com/author/show/3087199.A_G_Riddle)_ [4.04]

The first book in a two part series called the extinction files, the story explores a bioterrorist plot attempting to usurp the major world governments, with an extra scifi twist . Not what I would call hard SciFi and it has its fair share of cheese and cliche, but enough action and suspense to keep the party going without getting boring. - [@Rogue-System](https://github.com/Rogue-System)

<details>
  <summary>Description</summary>

  > A deadly outbreak in Kenya. A conspiracy beyond imagination. And a race to save humanity in its darkest hour.
  >
  > From A.G. Riddle, the worldwide bestselling author of The Atlantis Gene and Departure, comes a novel that will change everything you think you know about pandemics.
</details>

#### [The Windup Girl](https://www.goodreads.com/book/show/6597651-the-windup-girl) (2009) _by [Paolo Bacigalupi](https://en.wikipedia.org/wiki/Paolo_Bacigalupi)_ [3.7]

<details>
  <summary>Description</summary>

  > Anderson Lake is a company man, AgriGen’s Calorie Man in Thailand. Under cover as a factory manager, Anderson combs Bangkok’s street markets in search of foodstuffs thought to be extinct, hoping to reap the bounty of history’s lost calories. There, he encounters Emiko…
  >
  > Emiko is the Windup Girl, a strange and beautiful creature. One of the New People, Emiko is not human; instead, she is an engineered being, creche-grown and programmed to satisfy the decadent whims of a Kyoto businessman, but now abandoned to the streets of Bangkok. Regarded as soulless beings by some, devils by others, New People are slaves, soldiers, and toys of the rich in a chilling near future in which calorie companies rule the world, the oil age has passed, and the side effects of bio-engineered plagues run rampant across the globe.
  >
  > What happens when calories become currency? What happens when bio-terrorism becomes a tool for corporate profits, when said bio-terrorism’s genetic drift forces mankind to the cusp of post-human evolution? Award-winning author Paolo Bacigalupi delivers one of the most highly acclaimed science fiction novels of the twenty-first century.
</details>

### Speculative Fiction

#### [Anathem](https://www.goodreads.com/book/show/2845024-anathem) (2008) _by [Neal Stephenson](https://en.wikipedia.org/wiki/Neal_Stephenson)_ [4.2]

<details>
  <summary>Description</summary>

  > Fraa Erasmas is a young avout living in the Concent of Saunt Edhar, a sanctuary for mathematicians, scientists, and philosophers, protected from the corrupting influences of the outside “saecular” world by ancient stone, honored traditions, and complex rituals. Over the centuries, cities and governments have risen and fallen beyond the concent’s walls. Three times during history’s darkest epochs violence born of superstition and ignorance has invaded and devastated the cloistered mathic community. Yet the avout have always managed to adapt in the wake of catastrophe, becoming out of necessity even more austere and less dependent on technology and material things. And Erasmas has no fear of the outside—the Extramuros—for the last of the terrible times was long, long ago.
  >
  > Now, in celebration of the week-long, once-in-a-decade rite of Apert, the fraas and suurs prepare to venture beyond the concent’s gates—at the same time opening them wide to welcome the curious “extras” in. During his first Apert as a fraa, Erasmas eagerly anticipates reconnecting with the landmarks and family he hasn’t seen since he was “collected.” But before the week is out, both the existence he abandoned and the one he embraced will stand poised on the brink of cataclysmic change.
  >
  > Powerful unforeseen forces jeopardize the peaceful stability of mathic life and the established ennui of the Extramuros—a threat that only an unsteady alliance of saecular and avout can oppose—as, one by one, Erasmas and his colleagues, teachers, and friends are summoned forth from the safety of the concent in hopes of warding off global disaster. Suddenly burdened with a staggering responsibility, Erasmas finds himself a major player in a drama that will determine the future of his world—as he sets out on an extraordinary odyssey that will carry him to the most dangerous, inhospitable corners of the planet… and beyond.
</details>

#### [Never Let Me Go](https://www.goodreads.com/book/show/6334.Never_Let_Me_Go) (2005) _by [Kazuo Ishiguro](https://www.goodreads.com/author/show/4280.Kazuo_Ishiguro)_ [3.8] 🔥

A heartbreaking coming of age novel with a speculative, mysterious twist. Definitely a character-driven story. - [@sunrein](https://github.com/sunrein)

<details>
  <summary>Description</summary>

  > As children, Kathy, Ruth, and Tommy were students at Hailsham, an exclusive boarding school secluded in the English countryside. It was a place of mercurial cliques and mysterious rules where teachers were constantly reminding their charges of how special they were. Now, years later, Kathy is a young woman. Ruth and Tommy have reentered her life, and for the first time she is beginning to look back at their shared past and understand just what it is that makes them special— and how that gift will shape the rest of their time together.
</details>

#### [Stranger in a Strange Land](https://www.goodreads.com/book/show/350.Stranger_in_a_Strange_Land) (1961) _by [Robert A. Heinlein](https://en.wikipedia.org/wiki/Robert_A._Heinlein)_ [3.9] 🌟 🔥

<details>
  <summary>Description</summary>

  > NAME: Valentine Michael Smith
  > ANCESTRY: Human
  > ORIGIN: Mars
  >
  > Here is Heinlein’s masterpiece—the brilliant spectacular and incredibly popular novel that grew from a cult favorite to a bestseller to a classic in a few short years. It is the story of Valentine Michael Smith, the man from Mars who taught humankind grokking and water-sharing. And love.
</details>

#### [The End of Eternity](https://www.goodreads.com/book/show/509784.The_End_of_Eternity) (1955) _by [Isaac Asimov](https://en.wikipedia.org/wiki/Isaac_Asimov)_ [4.2]

<details>
  <summary>Description</summary>

  > Andrew Harlan is an Eternal, a man whose job it is to range through past and present Centuries, monitoring and, where necessary, altering Time’s myriad cause-and-effect relationships. But when Harlan meets and falls for a non-Eternal woman, he seeks to use the awesome powers and techniques of the Eternals to twist time for his own purposes, so that he and his love can survive together.
</details>

#### [The Shrinking Man](https://www.goodreads.com/book/show/33549.The_Shrinking_Man) (1956) _by [Richard Matheson](https://en.wikipedia.org/wiki/Richard_Matheson)_ [3.8] 🔥

This was pretty good; it's pretty obvious what it is about, and it reads predictably, but the ending is strong enough to make the entire book worth reading. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > While on holiday, Scott Carey is exposed to a cloud of radioactive spray shortly after he accidentally ingests insecticide. The radioactivity acts as a catalyst for the bug spray, causing his body to shrink at a rate of approximately 1/7 of an inch per day. A few weeks later, Carey can no longer deny the truth: not only is he losing weight, he is also shorter than he was and deduces, to his dismay, that his body will continue to shrink.
</details>

#### [The Years of Rice and Salt](https://www.goodreads.com/book/show/2723.The_Years_of_Rice_and_Salt) (2002) _by [Kim Stanley Robinson](https://www.goodreads.com/author/show/1858.Kim_Stanley_Robinson)_ [3.7]

The alternate history worldbuilding is the draw here, and the scale and depth of it is impressive. - [@neontapir](https://github.com/neontapir)

<details>
  <summary>Description</summary>

  > It is the fourteenth century and one of the most apocalyptic events in human history is set to occur - the coming of the Black Death. History teaches us that a third of Europe's population was destroyed. But what if? What if the plague killed 99 percent of the population instead? How would the world have changed? This is a look at the history that could have been: a history that stretches across centuries, a history that sees dynasties and nations rise and crumble, a history that spans horrible famine and magnificent innovation. These are the years of rice and salt.
</details>

### Time Travel

#### [Behold the Man](https://www.goodreads.com/book/show/60146.Behold_the_Man) (1969) _by [Michael Moorcock](https://en.wikipedia.org/wiki/Michael_Moorcock)_ [3.8]

Easily one of the most disrespectful, sacrilegious, memorable and funny books I have read. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Karl Glogauer is a disaffected modern professional casting about for meaning in a series of half-hearted relationships, a dead-end job, and a personal struggle. His questions of faith surrounding his father’s run-of-the-mill Christianity and his mother’s suppressed Judaism lead him to a bizarre obsession with the idea of the messiah. After the collapse of his latest affair and his introduction to a reclusive physics professor, Karl is given the opportunity to confront his obsession and take a journey that no man has taken before, and from which he knows he cannot return.
  >
  > Upon arriving in Palestine, A.D. 29, Glogauer finds that Jesus Christ is not the man that history and faith would like to believe, but that there is an opportunity for someone to change the course of history by making the ultimate sacrifice.
  >
  > First published in 1969, _Behold the Man_ broke through science fiction’s genre boundaries to create a poignant reflection on faith, disillusion and self-sacrifice. This is the classic novel that established the career of perhaps contemporary science fiction’s most cerebral and innovative author.
</details>

#### [Future Times Three](https://www.goodreads.com/book/show/2509242.Future_Times_Three) (1968) _by [René Barjavel](https://en.wikipedia.org/wiki/Ren%C3%A9_Barjavel)_ [3.8]

A really good story about time travels, their consequences and the famous [Grandfather paradox](https://en.wikipedia.org/wiki/Grandfather_paradox). - [@Gibet](https://github.com/Gibet)

<details>
  <summary>Description</summary>

  > Here is a fantastic journey that takes you from the past into the near-future—then to the year 300,000 A.D. into a world where a single female creature, the size of a mountain, gives birth to all of society!
</details>

#### [The Dancers at the End of Time](https://www.goodreads.com/book/show/60147.The_Dancers_at_the_End_of_Time) (1977) _by [Michael Moorcock](https://en.wikipedia.org/wiki/Michael_Moorcock)_ [4.0]

I liked this series so much I got a tattoo partially inspired by it. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > _The Dancers at the End of Time_ is a series of science fiction novels and short stories, the setting of which is the End of Time, an era “where entropy is king and the universe has begun collapsing upon itself.” The inhabitants of this era are immortal decadents, who create flights of fancy using power rings which draw on energy devised and stored by their ancestors millions of years prior. Time travel is possible, and throughout the series various points in time are visited and revisited. Space travellers are also common, but most residents of the End of Time find leaving the planet distasteful and clichéd.
</details>

#### [The Door Into Summer](https://www.goodreads.com/book/show/348.The_Door_Into_Summer) (1957) _by [Robert A. Heinlein](https://en.wikipedia.org/wiki/Robert_A._Heinlein)_ [4.0]

<details>
  <summary>Description</summary>

  > It is 1970, and electronics engineer Dan Davis has finally made the invention of a lifetime: a household robot with extraordinary abilities, destined to dramatically change the landscape of everyday routine. Then, with wild success just within reach, Dan’s greedy partner and even greedier fiancée steal his work and leave him penniless, and trick him into taking the long sleep—suspended animation for thirty years.
  >
  > They never imagine that the future time in which Dan awakens has a very limited form of time travel, just enough that Davis can travel back and recover his research. He then again undergoes suspended animation, and awakens again in the high-tech future of the year 2000, with his reputation, fortune, and his sweetheart.
</details>

#### [The Eyre Affair](https://www.goodreads.com/book/show/27003.The_Eyre_Affair) (2001) _by [Jasper Fforde](https://www.goodreads.com/author/show/4432.Jasper_Fforde)_ [3.9]

This novel is absurd fun -- think Douglas Adams style with a literary flair. Though flawed, the later novels in the series are in my reading pile. - [@neontapir](https://github.com/neontapir)

<details>
  <summary>Description</summary>

  > Great Britain circa 1985: time travel is routine, cloning is a reality (dodos are the resurrected pet of choice), and literature is taken very, very seriously. Acheron Hades, Third Most Wanted Man In the World, steals the original manuscript of Martin Chuzzlewit and kills a minor character, who then disappears from every volume of the novel ever printed! Hades' real target is the beloved Jane Eyre, and it's not long before he plucks her from the pages of Bronte's novel. Enter Thursday Next, the Special Operative's renowned literary detective. With the help of her uncle Mycroft's Prose Portal, Thursday enters the novel to rescue Jane Eyre from this heinous act of literary homicide. Can Thursday save Jane Eyre and Bronte's masterpiece?
</details>

#### [The Gone World](https://www.goodreads.com/book/show/33413556-the-gone-world) (2018) _by [Tom Sweterlitsch](https://www.goodreads.com/author/show/6981174.Tom_Sweterlitsch)_ [3.94]

This novel shows interesting mix of hard sci-fi, Nordic noir, parallel / alternative universe tree and path backtracking. The main protagonist is fighting the global cataclysm in its own style. The storytelling is so unique I'm afraid no one would be able to make a film based on this masterpiece. There is a [great book ending explanation](https://www.thisisbarry.com/book/the-gone-world-ending-explained-tom-sweterlitsch-book/) there. - [@4ndrej](https://github.com/4ndrej)

<details>
  <summary>Description</summary>

  > Shannon Moss is part of a clandestine division within the Naval Criminal Investigative Service. In western Pennsylvania, 1997, she is assigned to solve the murder of a Navy SEAL's family--and to locate his vanished teenage daughter. Though she can't share the information with conventional law enforcement, Moss discovers that the missing SEAL was an astronaut aboard the spaceship U.S.S. Libra—a ship assumed lost to the currents of Deep Time. Moss knows first-hand the mental trauma of time-travel and believes the SEAL's experience with the future has triggered this violence. Determined to find the missing girl and driven by a troubling connection from her own past, Moss travels ahead in time to explore possible versions of the future, seeking evidence to crack the present-day case. To her horror, the future reveals that it's not only the fate of a family that hinges on her work, for what she witnesses rising over time's horizon and hurtling toward the present is the Terminus: the terrifying and cataclysmic end of humanity itself.
</details>

#### [The Time Machine](https://www.goodreads.com/book/show/2493.The_Time_Machine) (1895) _by [H. G. Wells](https://en.wikipedia.org/wiki/H._G._Wells)_ [3.8] 🌟 🔥

Worth the read, mostly because it is the first time the words 'time machine' were used, and because the story, while a bit cliched to modern ears, is still good and gripping. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > “I’ve had a most amazing time…”
  >
  > So begins the Time Traveller’s astonishing firsthand account of his journey 800,000 years beyond his own era—and the story that launched H. G. Wells’s successful career and earned him his reputation as the father of science fiction. With a speculative leap that still fires the imagination, Wells sends his brave explorer to face a future burdened with our greatest hopes… and our darkest fears. A pull of the Time Machine’s lever propels him to the age of a slowly dying Earth. There he discovers two bizarre races—the ethereal Eloi and the subterranean Morlocks—who not only symbolize the duality of human nature, but offer a terrifying portrait of the men of tomorrow as well. Published in 1895, this masterpiece of invention captivated readers on the threshold of a new century. Thanks to Wells’s expert storytelling and provocative insight, _The Time Machine_ will continue to enthrall readers for generations to come.
</details>

### Comedy

#### [Magic 2.0 Series](https://www.goodreads.com/series/131379-magic-2-0) (2013, 2014, 2015, 2017) _by [Scott Meyer](<https://en.wikipedia.org/wiki/Scott_Meyer_(author)>)_ [3.9]

A quick, fun mashup of two if my favorite genres. - [@damenleeturks](https://github.com/damenleeturks)

Books:

- [Off to Be the Wizard](https://www.goodreads.com/book/show/18616975-off-to-be-the-wizard) [3.98]
- [Spell or High Water](https://www.goodreads.com/book/show/21483760-spell-or-high-water) [4.02]
- [An Unwelcome Quest](https://www.goodreads.com/book/show/23249416-an-unwelcome-quest) [3.98]
- [Fight and Flight](https://www.goodreads.com/book/show/36566205-fight-and-flight) [3.61]
- [Out of Spite, Out of Mind](https://www.goodreads.com/book/show/39751936-out-of-spite-out-of-mind) [3.79]

<details>
  <summary>Description</summary>

  > Martin Banks is just a normal guy who has made an abnormal discovery: he can manipulate reality, thanks to reality being nothing more than a computer program. With every use of this ability, though, Martin finds his little “tweaks” have not escaped notice. Rather than face prosecution, he decides instead to travel back in time to the Middle Ages and pose as a wizard.
  >
  > What could possibly go wrong?
  >
  > An American hacker in King Arthur’s court, Martin must now train to become a full-fledged master of his powers, discover the truth behind the ancient wizard Merlin… and not, y’know, die or anything.
</details>

#### [The Hitchhiker’s Guide to the Galaxy](https://www.goodreads.com/book/show/11.The_Hitchhiker_s_Guide_to_the_Galaxy) (1979) _by [Douglas Adams](https://en.wikipedia.org/wiki/Douglas_Adams)_ [4.2] 🌟 🔥

One of the funniest series I have ever read. I laugh to myself and think about this all of the time. Changed how I view the galaxy and lost pens irreversibly. I also celebrate [International Towel Day](https://en.wikipedia.org/wiki/Towel_Day) every year now. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Seconds before the Earth is demolished to make way for a galactic freeway, Arthur Dent is plucked off the planet by his friend Ford Prefect, a researcher for the revised edition of _The Hitchhiker’s Guide to the Galaxy_ who, for the last fifteen years, has been posing as an out-of-work actor.
  >
  > Together this dynamic pair begin a journey through space aided by quotes from _The Hitchhiker’s Guide_ (“A towel is about the most massively useful thing an interstellar hitchhiker can have”) and a galaxy-full of fellow travelers: Zaphod Beeblebrox—the two-headed, three-armed ex-hippie and totally out-to-lunch president of the galaxy; Trillian, Zaphod’s girlfriend (formally Tricia McMillan), whom Arthur tried to pick up at a cocktail party once upon a time zone; Marvin, a paranoid, brilliant, and chronically depressed robot; Veet Voojagig, a former graduate student who is obsessed with the disappearance of all the ballpoint pens he bought over the years.
</details>

#### [The Laundry Series](https://www.goodreads.com/book/show/101869.The_Atrocity_Archives) (2004) _by [Charles Stross](https://en.wikipedia.org/wiki/Charles_Stross)_ [3.9]

A bit of a lighthearted series, it's a great drama - [@alexkeyes](https://github.com/alex-keyes)

<details>
  <summary>Description</summary>

  > NEVER VOLUNTEER FOR ACTIVE DUTY ...Bob Howard is a low-level techie working for a super-secret government agency. While his colleagues are out saving the world, Bob's under a desk restoring lost data. His world was dull and safe - but then he went and got Noticed. Now, Bob is up to his neck in spycraft, parallel universes, dimension-hopping terrorists, monstrous elder gods and the end of the world. Only one thing is certain: it will take more than a full system reboot to sort this mess out ...This is the first novel in the Laundry Files.
</details>

### Horror

#### [House of Leaves](https://www.goodreads.com/book/show/24800.House_of_Leaves) (2000) _by [Mark Z. Danielewski](https://en.wikipedia.org/wiki/Mark_Z._Danielewski)_ [4.12] 🔥

This book has a cult following, and upon reading it this summer, I fully understand why people are still so enamored with it almost twenty years after its first publish. I still think back to it often, and I will eventually re-read it (at least once) to get details I missed the first time. You can get lost in this book both figuratively and literally, so it's best to take your time with it. Shout-out to [Austin McConnell's video](https://www.youtube.com/watch?v=bLpAd9j9n7k) for introducing me to _House of Leaves!_ - [@thedeany](https://github.com/thedeany)

<details>
  <summary>Description</summary>

  > Years ago, when House of Leaves was first being passed around, it was nothing more than a badly bundled heap of paper, parts of which would occasionally surface on the Internet. No one could have anticipated the small but devoted following this terrifying story would soon command. Starting with an odd assortment of marginalized youth—musicians, tattoo artists, programmers, strippers, environmentalists, and adrenaline junkies—the book eventually made its way into the hands of older generations, who not only found themselves in those strangely arranged pages but also discovered a way back into the lives of their estranged children.
  >
  > Now, for the first time, this astonishing novel is made available in book form, complete with the original colored words, vertical footnotes, and newly added second and third appendices.
  >
  > The story remains unchanged, focusing on a young family that moves into a small home on Ash Tree Lane where they discover something is terribly wrong: their house is bigger on the inside than it is on the outside.
  >
  > Of course, neither Pulitzer Prize-winning photojournalist Will Navidson nor his companion Karen Green was prepared to face the consequences of that impossibility, until the day their two little children wandered off and their voices eerily began to return another story—of creature darkness, of an ever-growing abyss behind a closet door, and of that unholy growl which soon enough would tear through their walls and consume all their dreams.
</details>

## Short Story Collections

#### [Axiomatic](https://www.goodreads.com/book/show/156783.Axiomatic) (1995) _by [Greg Egan](https://en.wikipedia.org/wiki/Greg_Egan)_ [4.2]

Hard-as-nails science fiction, but wonderfully fresh and imaginative (especially if you haven't had a chance to read anything written by Greg Egan before.) The stories have aged surprisingly well — which only underlines Egan’s penchant for sounding out the shape of the future. - [@mihailim](https://github.com/mihailim)

<details>
  <summary>Description</summary>

  > _Axiomatic_ is a collection of Greg Egan’s short stories that appeared in various science fiction magazines (mostly _Interzone_ and _Asimov’s_) between 1989 and 1992. Like most of Egan’s work, the stories focus on science and ideas, sometimes at the expense of the writing. But although Egan may lack a certain stylistic flair, he more than makes up for it with his wonderful visions of the future. Some of the more interesting stories include _Into Darkness_, the tale of a rescue worker whose territory is a runaway wormhole, and the title story _Axiomatic_, which is about a man looking to find meaning in the senseless death of his wife.
  
  > Contents: _The Infinite Assassin_ (1991), _The Hundred Light-Year Diary_ (1992), _Eugene_ (1990), _The Caress_ (1990), _Blood Sisters_ (1991), _Axiomatic_ (1990), _The Safe-Deposit Box_ (1990), _Seeing_ (1995), _A Kidnapping_ (1995), _Learning to Be Me_ (1990), _The Moat_ (1991), _The Walk_ (1992), _The Cutie_ (1989), _Into Darkness_ (1992), _Appropriate Love_ (1991), _The Moral Virologist_ (1990), _Closer_ (1992), _Unstable Orbits in the Space of Lies_ (1992)
</details>

#### [City](https://www.goodreads.com/book/show/222093.City) (1952) _by [Clifford D. Simak](https://en.wikipedia.org/wiki/Clifford_D._Simak)_ [4.1]

You will never think about ants the same way again. - [@uraimo](https://github.com/uraimo)

<details>
  <summary>Description</summary>

  > Simak's "City" is a series of connected stories, a series of legends, myths, and campfire stories told by Dogs about the end of human civilization, centering on the Webster family, who, among their other accomplishments, designed the ships that took Men to the stars and gave Dogs the gift of speech and robots to be their hands.
</details>

#### [I, Robot](https://www.goodreads.com/book/show/41804.I_Robot) (1950) _by [Isaac Asimov](https://en.wikipedia.org/wiki/Isaac_Asimov)_ [4.1] 🌟 🔥

<details>
  <summary>Description</summary>

  > The three laws of Robotics:
  >
  > 1. A robot may not injure a human being or, through inaction, allow a human being to come to harm.
  >
  > 2. A robot must obey orders given to it by human beings except where such orders would conflict with the First Law.
  >
  > 3. A robot must protect its own existence as long as such protection does not conflict with the First or Second Law.
  >
  > With these three, simple directives, Isaac Asimov changed our perception of robots forever when he formulated the laws governing their behavior. In _I, Robot_, Asimov chronicles the development of the robot through a series of interlinked stories: from its primitive origins in the present to its ultimate perfection in the not-so-distant future—a future in which humanity itself may be rendered obsolete.
  >
  > Here are stories of robots gone mad, of mind-read robots, and robots with a sense of humor. Of robot politicians, and robots who secretly run the world—all told with the dramatic blend of science fact and science fiction that has become Asimov’s trademark.
</details>

#### [Manhattan in Reverse](https://www.goodreads.com/book/show/10710770-manhattan-in-reverse) (2011) _by [Peter F. Hamilton](https://en.wikipedia.org/wiki/Peter_F._Hamilton)_ [3.9]

<details>
  <summary>Description</summary>

  > This is a collection of short stories from the master of space opera. Peter F. Hamilton takes us on a journey from a murder mystery in an alternative Oxford in the 1800s to a story featuring Paula Mayo, deputy director of the Intersolar Commonwealth’s Serious Crimes Directorate.
  
  > Contents: _Watching Trees Grow_ (2000), _Footvote_ (2004), _If at First…_ (2007), _The Forever Kitten_ (2005), _Blessed by an Angel_ (2007), _The Demon Trap_ (2008), _Manhattan in Reverse_ (2011)
</details>

#### [Of Time and Stars](https://www.goodreads.com/book/show/21798296-of-time-and-stars) (1972) _by [Arthur C. Clarke](https://en.wikipedia.org/wiki/Arthur_C._Clarke)_ [4.1]

I can't praise this book enough. _The Nine Billion Names of God_ is brilliantly done; well written, executed, and frisson-inducing. _If I Forget Thee, Oh Earth_ is also a stark reminder that we only have one planet. One of the most memorable Science Fiction stories I have ever read. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > _Of Time and Stars_ is a collection of short stories by science fiction writer Arthur C. Clarke. The stories all originally appeared in a number of different publications including the periodicals _Dude_, _The Evening Standard_, _Lilliput_, _The Magazine of Fantasy & Science Fiction_, _Future_, _New Worlds_, _Startling Stories_, _Astounding_, _Fantasy_, _King’s College Review_, _Satellite_, _Amazing Stories_, _London Evening News_, _Infinity Science Fiction_ and _Ten Story Fantasy_ as well as the anthologies _Star Science Fiction Stories No.1_ edited by Frederik Pohl and _Time to Come_ edited by August Derleth.
  
  > Contents: _The Nine Billion Names of God_ (1953), _An Ape About the House_ (1962), _Green Fingers_ (1956), _Trouble with the Natives_ (1951), _Into the Comet_ (1960), _No Morning After_ (1954), _‘If I Forget Thee, Oh Earth…’_ (1951), _Who’s There?_ (1958), _All the Time in the World_ (1952), _Hide and Seek_ (1949), _Robin Hood, F.R.S._ (1956), _The Fires Within_ (1949), _The Forgotten Enemy_ (1953), _The Reluctant Orchid_ (1956), _Encounter at Dawn_ (1953), _Security Check_ (1957), _Feathered Friend_ (1957), _The Sentinel_ (1951)
</details>

#### [Radicalized](https://www.goodreads.com/book/show/41447687-radicalized) (2019) _by [Cory Doctorow](https://en.wikipedia.org/wiki/Cory_Doctorow)_ [4.03]

The all-too-near-future novella _Unauthorized Bread_ embodies what cyberpunk should be all about: high tech, low life. _Radicalized_ and _The Masque of the Red Death_ delve deep into some dark corners of society, while _Model Minority_ is a pretty interesting take on Superman and racism. The book had me turning pages late into the night. - [@nahkampf](https://github.com/nahkampf)

<details>
  <summary>Description</summary>

  > Radicalized explores such issues as digital rights management, police brutality, radicalization in internet communities, and doomsday preppers. Doctorow has stated that the collection was inspired by "dealing with the stress and anxiety of being alive in the Trump era," and that the stories are not meant to be predictive, but rather allegorical.
  
  > Contents: _Unauthorized Bread_ (2019), _Model Minority_ (2019), _Radicalized_ (2019), _The Masque of the Red Death_ (2019)
</details>

#### [Stories of Your Life and Others](https://www.goodreads.com/book/show/729760.Stories_of_Your_Life_and_Others) (2002) _by [Ted Chiang](https://en.wikipedia.org/wiki/Ted_Chiang)_ [4.4]

What amazes me most about Ted Chiang’s stories is their _richness_—the level of detail which the author managed to weave into the stories without having them turn into fluff. Artfully executed, uniformly good through excellent—which is by no means par for the course in single-author collections! Reminds me the most of Greg Egan’s _Axiomatic_ collection, except Chiang manages to keep his characters optimistic. - [@mihailim](https://github.com/mihailim)

<details>
  <summary>Description</summary>

  > Ted Chiang’s first published story, “_Tower of Babylon_,” won the Nebula Award in 1990. Subsequent stories have won the Asimov’s SF Magazine reader poll, a second Nebula Award, the Theodore Sturgeon Memorial Award, and the Sidewise Award for alternate history. He won the John W. Campbell Award for Best New Writer in 1992. Story for story, he is the most honored young writer in modern SF.
  >
  > What if men built a tower from Earth to Heaven—and broke through to Heaven’s other side? What if we discovered that the fundamentals of mathematics were arbitrary and inconsistent? What if there were a science of naming things that calls life into being from inanimate matter? What if exposure to an alien language forever changed our perception of time? What if all the beliefs of fundamentalist Christianity were literally true, and the sight of sinners being swallowed into fiery pits were a routine event on city streets? These are the kinds of outrageous questions posed by the stories of Ted Chiang. Stories of your life… and others.
  
  > Contents: _Tower of Babylon_ (1990), _Understand_ (1991), _Division by Zero_ (1991), _Story of Your Life_ (1998), _Seventy-Two Letters_ (2000), _The Evolution of Human Science_ (2000), _Hell Is the Absence of God_ (2001), _Liking What You See: A Documentary_ (2002)
</details>

#### [The Illustrated Man](https://www.goodreads.com/book/show/24830.The_Illustrated_Man) (1951) _by [Ray Bradbury](https://en.wikipedia.org/wiki/Ray_Bradbury)_ [4.1] 🌟

<details>
  <summary>Description</summary>

  > That _The Illustrated Man_ has remained in print since being published in 1951 is fair testimony to the universal appeal of Ray Bradbury’s work. Only his second collection (the first was _Dark Carnival_, later reworked into _The October Country_), it is a marvelous, if mostly dark, quilt of science fiction, fantasy, and horror. In an ingenious framework to open and close the book, Bradbury presents himself as a nameless narrator who meets the Illustrated Man—a wanderer whose entire body is a living canvas of exotic tattoos. What’s even more remarkable, and increasingly disturbing, is that the illustrations are themselves magically alive, and each proceeds to unfold its own story, such as “The Veldt,” wherein rowdy children take a game of virtual reality way over the edge. Or “Kaleidoscope,” a heartbreaking portrait of stranded astronauts about to reenter our atmosphere—without the benefit of a spaceship. Or “Zero Hour,” in which invading aliens have discovered a most logical ally—our own children. Even though most were written in the 1940s and 1950s, these 18 classic stories will be just as chillingly effective 50 years from now. —Stanley Wiater
</details>

#### [The Island of Dr. Death and Other Stories and Other Stories](https://www.goodreads.com/book/show/271587.The_Island_of_Dr_Death_and_Other_Stories_and_Other_Stories) (1980) _by [Gene Wolfe](https://en.wikipedia.org/wiki/Gene_Wolfe)_ [4.1]

I think of these stories often; The Death of Dr. Island won a Nebula and offers a startling view into the rehabilitation and justice system we currently deal with and what we might have. The Doctor of Death Island is the same - I often think of him taking off the book cover, "like Mephistopholes". It takes an amazing talent to make three beautiful short stories out of permutations on a title. Also, Feather Tigers made me view the jungles in South East Asia a bit differently than I would have, and I think about Nashwonk a lot more than I should. I highly suggest this book. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A superb collection of science fiction and fantasy stories, _The Island of Doctor Death and Other Stories and Other Stories_ is a book that transcends all genre definitions. The stories within are mined with depth charges, explosions of meaning and illumination that will keep you thinking and feeling long after you have finished reading.
  
  > Contents: _The Island of Doctor Death and Other Stories_ (1970), _Alien Stones_ (1972), _La Befana_ (1973), _The Hero as Werwolf_ (1975), _Three Fingers_ (1976), _The Death of Dr. Island_ (1973), _Feather Tigers_ (1973), _Hour of Trust_ (1973), _Tracking Song_ (1975), _The Toy Theater_ (1971), _The Doctor of Death Island_ (1978), _Cues_ (1974), _The Eyeflash Miracles_ (1976), _Seven American Nights_ (1978)
</details>

## Movies

#### [2001: A Space Odyssey](https://www.imdb.com/title/tt0062622/) (1968) [8.3]

Categories: `space` `ai` `singularity`<br>
Director: _Stanley Kubrick_

Cinematically, this movie is a masterpiece. This is one of the few films on this list that is important as a film in itself, not just to the genre. From the beginning to the end, it is captivating - if you don't mind a bit of a slower pace than most of the other films on here. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Humanity finds a mysterious, obviously artificial, object buried beneath the Lunar surface and, with the intelligent computer H.A.L. 9000, sets off on a quest.
</details>

#### [A Clockwork Orange](https://www.imdb.com/title/tt0066921/) (1971) [8.4]

Categories: `dystopia`

<details>
  <summary>Description</summary>

  > In future Britain, charismatic delinquent Alex DeLarge is jailed and volunteers for an experimental aversion therapy developed by the government in an effort to solve society’s crime problem—but not all goes according to plan.
</details>

#### [A Scanner Darkly](https://www.imdb.com/title/tt0405296/) (2006) [7.1]

Categories: `dystopia` `cyberpunk`

<details>
  <summary>Description</summary>

  > An undercover cop in a not-too-distant future becomes involved with a dangerous new drug and begins to lose his own identity as a result.
</details>

#### [Akira](https://www.imdb.com/title/tt0094625/) (1988) [8.1]

Categories: `anime` `dystopia` `thriller`

One of the first mainstream anime movies. Psychologically horrifying in more than a few ways. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A secret military project endangers Neo-Tokyo when it turns a biker gang member into a rampaging psionic psychopath that only two kids and a group of psionics can stop.
</details>

#### [Arrival](https://www.imdb.com/title/tt2543164/) (2016) [8.3]

Categories: `aliens` `linguistics`<br />
Director: _Denis Villeneuve_

A beautiful film, weaving together memory, languages, and the other. The film is less about aliens and more about our perception of them; like District 9, this film functions as a good mirror for how different people and governments deal with alien interaction. The music is also exceptional. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > When 12 mysterious spacecraft appear around the world, linguistics professor Louise Banks is tasked with interpreting the language of the apparent alien visitors.
</details>

#### [Blade Runner](https://www.imdb.com/title/tt0083658/) (1982) [8.2]

Categories: `dystopia` `ai` `cyberpunk` `singularity`<br>
Director: _Ridley Scott_

Very few films can stand up to as many rewatches as this film can - there are layers upon layers, and the bleak image of the future hasn't lost its power in the thirty years the film has been around. This was a reworking of the Phillip K. Dick book (above), but without a lot of unnecessary or largely spurious subplots, and it focuses much more on identity, sexuality, and the psychological ramifications of technology. A masterpiece. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A blade runner must pursue and try to terminate four replicants who stole a ship in space and have returned to Earth to find their creator.
</details>

#### [Blade Runner 2049](https://www.imdb.com/title/tt1856101/) (2017) [8.0]

Categories: `dystopia` `ai` `cyberpunk` `thriller` `mystery`<br>
Director: _Denis Villeneuve_

Blade Runner 2049 returns to the original book's deep philosophical questions about the nature of humanity, and expressed through a captivating, epic mystery it amounts to a breathtaking, mind-bending cinematic experience. - [@TheSherlockHomie](https://github.com/TheSherlockHomie)s

<details>
  <summary>Description</summary>

  > A young blade runner's discovery of a long-buried secret leads him to track down former blade runner Rick Deckard, who's been missing for thirty years.
</details>

#### [Brazil](https://www.imdb.com/title/tt0088846/) (1985) [8.0]

Categories: `dystopia` `police`

If you're looking to replicate the experience of taking acid without actually doing drugs, than this film is for you. Weird as hell, and De Niro's cameo is strange, but this film is very good. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A bureaucrat in a retro-future world tries to correct an administrative error and himself becomes an enemy of the state.
</details>

#### [Cargo](https://www.imdb.com/title/tt0381940/) (2009) [6.2]

Categories: `space` `dystopia`

Why not try something out of the ordinary with this Swiss sci-fi thriller? [@Lekoaf](https://github.com/lekoaf)

<details>
  <summary>Description</summary>

  > In 2270, Earth is completely depleted and no one lives there anymore. Those that have money move to Rhea; but most of the population lives in orbit in space stations. Dr. Laura Portmann decides to work in the cargo ship Kassandra in an eight year travel to Station 42 that is in orbit of RH278 to raise money to meet her sister Arianne in Rhea.
</details>

#### [Chappie](https://www.imdb.com/title/tt1823672/) (2015) [7.1]

Categories: `ai` `police`

A movie about an AI robot "growing up" (as in, learning about the world and learning the difference between good and bad). An amazing story, you really feel like Chappie is your friend by the end of the movie. Visual effects are not that great in a couple of scenes. - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

<details>
  <summary>Description</summary>

  > In the near future, crime is patrolled by a mechanized police force. When one police droid, Chappie, is stolen and given new programming, he becomes the first robot with the ability to think and feel for himself.
</details>

#### [Children of Men](https://www.imdb.com/title/tt0206634/) (2006) [7.9]

Categories: `dystopia` `drama`

Imagine a world where no baby has been born for 18 years because of the global human infertility. Think which kinds of consequences would that bring. Then, imagine a girl getting pregnant in that kind of world. This movie is absolutely fantastic! The action shots are magnificent. I rewatched it tonight and the movie gave me the same kind of goosebumps it did when I first watched it a couple of years ago. I have no compaints about this movie. It's the perfect way to spend two hours. It gets 10/10 from me. - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

Absolutely beautiful film. The cinematography is fantastic; Michael Caine has a memorable and well-played role (as ever, I mean, he's Michael Caine); and the soundtrack is spectacular, with both Radiohead's _Life in a Glasshouse_ and King Crimson's _The Court of the Crimson King_ actually managing to work in the same film. The best. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In 2027, in a chaotic world in which women have become somehow infertile, a former activist agrees to help transport a miraculously pregnant woman to a sanctuary at sea.
</details>

#### [Cloud Atlas](https://www.imdb.com/title/tt1371111/) (2012) [7.5]

Categories: `drama` `thriller`

This is an awesome movie. It is a deep movie, with a complex plot. You don't want to be distracted while watching it. I liked how the six different stories played by different characters are played by the same actors and how the stories can be different but are linked by small things. Also, if you like non standard narratives this is your movie. - [@damaru2](https://github.com/damaru2)

<details>
  <summary>Description</summary>

  > An exploration of how the actions of individual lives impact one another in the past, present and future, as one soul is shaped from a killer into a hero, and an act of kindness ripples across centuries to inspire a revolution.
</details>

#### [Coherence](https://www.imdb.com/title/tt2866360/) (2013) [7.1]

<details>
  <summary>Description</summary>

  > Strange things begin to happen when a group of friends gather for a dinner party on an evening when a comet is passing overhead.
</details>

#### [Contact](https://www.imdb.com/title/tt0118884/) (1997) [7.4]

Categories: `aliens` `space` `drama` `mystery` `thriller`<br>
Director: _Robert Zemeckis_<br>

Based on a novel by the fantastic Carl Sagan, this is a painstakingly realistic piece of sci-fi art. - [@abhineet97](https://github.com/abhineet97)

<details>
  <summary>Description</summary>

  > Dr. Ellie Arroway, after years of searching, finds conclusive radio proof of extraterrestrial intelligence, sending plans for a mysterious machine.
</details>

#### [Dark City](https://www.imdb.com/title/tt0118929/) (1998) [7.7]

Categories: `aliens` `mystery` `sci-fi` `thriller`<br>
Director: _Alex Proyas_<br>

Excellent neo-noir about a man trapped in a city permanently in nighttime. He suffers from amnesia, and he may or may not have killed several women. Both the police and a group of men called the Strangers are hot on his trail. I love the 1940s sci-fi setting and the plot full of mysteries. - [@CodeWritingCow](https://github.com/CodeWritingCow)

<details>
  <summary>Description</summary>

  > A man struggles with memories of his past, including a wife he cannot remember, in a nightmarish world with no sun.
</details>

#### [District 9](https://www.imdb.com/title/tt1136608/) (2009) [8.0]

Categories: `aliens` `thriller` `apartheid`<br>
Director: _Neill Blomkamp_<br>
Writer: _Neill Blomkamp, Terri Tatchell_

:+1: I liked it. Very original. - [@sindresorhus](https://github.com/sindresorhus)

Yep, the idea is pretty cool and original. Although I have some doubts about the realization. I hope in twenty years someone will make a better remake :) - [@marcoslhc](https://github.com/marcoslhc)

I thought it was pretty awesome, even just linguistically. Special effects were great. Interesting given it was South African, too. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > An extraterrestrial race forced to live in slum-like conditions on Earth suddenly finds a kindred spirit in a government agent who is exposed to their biotechnology.
</details>

#### [Dune](https://www.imdb.com/title/tt0087182/) (1984) [6.6]

Categories: `space` `aliens`<br>
Director: _David Lynch_

This is based on the Dune book by Herbert, listed above. This version is legendary - it has Patrick Stewart and Sting as actors, and David Lynch's direction is weird and weighty. The soundtrack, by Toto, is good enough to stand on its own. I can't imagine reading the books without thinking of this viewing. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A Duke’s son leads desert warriors against the galactic emperor and his father’s evil nemesis when they assassinate his father and free their desert world from the emperor’s rule.
  
</details>

#### [Edge of Tomorrow](https://www.imdb.com/title/tt1631867/) (2014) [7.9]

Categories: `thriller` `police` `aliens`

Thrilling and original. Feels like a cross between Halo (the game), Groundhog Day and The Butterfly Effect. - [@sindresorhus](https://github.com/sindresorhus)

I was thinking that this movie would be like the rest of the movies starring Tom Cruise, but I was pleasantly surprised. The first half of the movie had nice humoristic scenes. They made the repeating of the day far more interesting than in the Groundhog Day. The love story between the main characters doesn't look cheap. The visual effects is not in the center of the attention, it's the story. I have to say that the movie was way better than I expected it to be by looking at the trailers for it. I highly recommend it. - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

It was pretty good, the premise is quiet interesting, and the acting was quite good. - [@elssar](https://github.com/elssar)

I thought it was great, and I was a bit anxious about there being so many scenes repeating the same thing, but it worked! - [@tjFogarty](https://github.com/tjFogarty)

One of my favorite sci-fi movies of all time. The source material is supposed to be good too, which is a manga called "All You Need is Kill". Haven't read it yet, but if you liked the movie then you would probably like this too. - [@wulfshadow](https://github.com/wulfshadow)

<details>
  <summary>Description</summary>

  > A military officer is brought into an alien war against an extraterrestrial enemy who can reset the day and know the future. When this officer is enabled with the same power, he teams up with a Special Forces warrior to try and end the war.
</details>

#### [Eraserhead](https://www.imdb.com/title/tt0074486/) (1977) [7.4]

<details>
  <summary>Description</summary>

  > Henry Spencer tries to survive his industrial environment, his angry girlfriend, and the unbearable screams of his newly born mutant child.
</details>

#### [Europa Report](https://www.imdb.com/title/tt2051879/) (2013) [6.5]

Categories: `space`

<details>
  <summary>Description</summary>

  > An international crew of astronauts undertakes a privately funded mission to search for life on Jupiter’s fourth largest moon.
</details>

#### [Ex Machina](https://www.imdb.com/title/tt0470752/) (2015) [7.9]

Categories: `ai`

Thought-provoking movie that explores what it means to be human. Deep, suspenseful, and at times claustrophobic. Acting is to perfection. Visual effects are so well done and natural you don't even notice them. Truly the best sci-fi movie I've watched in years. - [@sindresorhus](https://sindresorhus.com)

Kind of a parody about Google. The owner of a huge search provider creates an A.I. humanoid in a complete secrecy and calls a young programmer to perform a slight variation of a [Turing test](https://en.wikipedia.org/wiki/Turing_test) to test his creation in a secret underground lab. Can be a good introduction to Turing test to people interested in A.I. To be honest, the end of the movie was a bit disappointing to me. - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

<details>
  <summary>Description</summary>

  > A young programmer is selected to participate in a breakthrough experiment in artificial intelligence by evaluating the human qualities of a breathtaking female A.I.
</details>

#### [eXistenZ](https://www.imdb.com/title/tt0120907/) (1999) [6.8]

Categories: `thriller`

This is an independent movie, their budget wasn't very good and thus maybe the shots and the special effects are not the best, but it has all the good elements of a scifi movie and a thriller. I liked all the details about how the perfect virtual reality devices work and what the users feel when in game. - [@damaru2](https://github.com/damaru2)

<details>
  <summary>Description</summary>

  > A game designer on the run from assassins must play her latest virtual reality creation with a marketing trainee to determine if the game has been damaged.
</details>

#### [Forbidden Planet](https://www.imdb.com/title/tt0049223/) (1956) [7.6]

Categories: `Action` `Adventure` `Sci-Fi`

Forbidden Planet is one of, if not the most iconic Science Fiction movie to have have been released during the 1950's. It stands shoulder to shoulder with the likes of "The Day the Earth Stood Still" and "The Invasion of the Body Snatchers".

Forbidden Planet takes the "hard" Sci-Fi route, whilst retaining fantastical elements that are associated with space dramas. The film carries a level of class that elevates it above its genre contemporaries due to the fantastic production values. The special effects and set designs hold up remarkably well even by today's standards. - @augustopedro

<details>
  <summary>Description</summary>

  > A starship crew goes to investigate the silence of a planet's colony only to find two survivors and a deadly secret that one of them has.
</details>

#### [Galaxy Quest](https://www.imdb.com/title/tt0177789/) (1999) [7.3]

Categories: `comedy` `space` `aliens`

If you've heard of Star Trek, and like comedy, this is for you - the entire film is a giant joke on the scifi industry, played by fantastic actors. Hilarious. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > The alumni cast of a space opera television series have to play their roles as the real thing when an alien race needs their help.
</details>

#### [Gattaca](https://www.imdb.com/title/tt0119177/) (1997) [7.8]

Categories: `biopunk` `space`

This film gets more relevant every year. Slow at times, the questions it raises are especially pertinent as your data becomes more important to insurance companies and governments, and as Western culture is increasingly becoming aware of genetic advantages and privilege. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A genetically inferior man assumes the identity of a superior one in order to pursue his lifelong dream of space travel.
</details>

#### [Ghost in the Shell](https://www.imdb.com/title/tt0113568/) (1995) [8.0]

Categories: `anime` `ai` `police`

<details>
  <summary>Description</summary>

  > A female cyborg cop and her partner hunt a mysterious and powerful hacker called the Puppet Master.
</details>

#### [Godzilla](https://www.imdb.com/title/tt0047034/) (1954) [7.5]

Categories: `apocalypse` `aliens` `action`

<details>
  <summary>Description</summary>

  > American nuclear weapons testing results in the creation of a seemingly unstoppable, dinosaur-like beast.
</details>

#### [Hackers](https://www.imdb.com/title/tt0113243/) (1995) [6.2]

Categories: `cyberpunk` `police` `thriller`

In a strange loop, a lot of the statements made in this film about who hackers are have gone full circle and been incorporated into our culture (Substack's ending most of his slides with 'Hack the planet', for instance). The actual hacking is ridiculous, but the punks on the edge of society coming into their own makes this worth watching. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A young boy is arrested by the U.S. Secret Service for writing a computer virus and is banned from using a computer until his 18th birthday. Years later, he and his new-found friends discover a plot to unleash a dangerous computer virus, but they must use their computer skills to find the evidence while being pursued by the Secret Service and the evil computer genius behind the virus.
</details>

#### [Her](https://www.imdb.com/title/tt1798709/) (2014) [8.0]

Categories: `ai` `drama` `singularity`

Hey, lets all fall in love in our operating systems! The movie seems like a plausible love story and it takes the reality of our addiction to technology to a whole new level. - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

This is a beautiful film; the plot was forced at times, especially towards the end, but the character development was fantastic, and Joaquin Phoenix's acting carries the film. The set design and clothes are also impeccable, with a few of what the near future might look like. I cried. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A lonely writer develops an unlikely relationship with his newly purchased operating system that’s designed to meet his every need.
</details>

#### [I Origins](https://www.imdb.com/title/tt2884206/) (2014) [7.3]

Categories: `cyberpunk`

<details>
  <summary>Description</summary>

  > A molecular biologist and his laboratory partner uncover evidence that may fundamentally change society as we know it.
</details>

#### [I, Robot](https://www.imdb.com/title/tt0343818/) (2004) [7.1]

Categories: `ia` `crime`

The name of this movie comes from the Asimov's book of the same name, which consists of science fiction short stories. The movie could perfectly be another of Asimov's stories. It mimics his style and shows an interesting movie posing questions about artificial intelligence, conscience and emotion. - [@damaru2](https://github.com/damaru2)

<details>
  <summary>Description</summary>

  > In 2035, a technophobic cop investigates a crime that may have been perpetrated by a robot, which leads to a larger threat to humanity.
</details>

#### [Inception](https://www.imdb.com/title/tt1375666/) (2010) [8.8]

Categories: `cyberpunk`

A major blockbuster, this film stretches the limits of recursion while maintaining its action. Well acted and beautifully shot. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A thief who steals corporate secrets through use of dream-sharing technology is given the inverse task of planting an idea into the mind of a CEO.
</details>

#### [Interstellar](https://www.imdb.com/title/tt0816692/) (2014) [8.7]

Categories: `space`

An interesting (and long) movie about a humanity trying to safe itself by leaving Earth after a huge climate change that made it difficult to grow food. Truly remarkable story and amazing graphic. - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

The visuals are pretty good. There are plotholes here and there, but overall I really liked this movie. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A team of explorers travel through a wormhole in an attempt to ensure humanity’s survival.
</details>

#### [La Jetée](https://www.imdb.com/title/tt0056119/) (1962) [8.4]

Categories: `time travel` `drama`

This film inspired Twelve Monkeys, but is more notable for being one of the earliest short scifi films that deals with time travel and its ramifications for revolutions and society as a whole. Black and white and beautiful. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Time travel, still images, a past, present and future and the aftermath of World War III. The tale of a man, a slave, sent back and forth, in and out of time, to find a solution to the world’s fate. To replenish its decreasing stocks of food, medicine and energies, and in doing so, resulting in a perpetual memory of a lone female, life, death and past events that are recreated on an airports jetée.
</details>

#### [Metropolis](https://www.imdb.com/title/tt0017136/) (1927) [8.3]

Categories: `apocalypse`

This is the kind of film that sells out art houses when someone finds an early roll of the film in a theatre in Buenos Aires, stacked away behind decades of other movies. Seminal in its ability to show a technological future when we were just beginning to understand what that would look like, this film is a masterpiece of class statements, and is much braver at times than a lot of modern, 'edgy' scripts. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In a futuristic city sharply divided between the working class and the city planners, the son of the city’s mastermind falls in love with a working class prophet who predicts the coming of a savior to mediate their differences.
</details>

#### [Minority Report](https://www.imdb.com/title/tt0181689/) (2002) [7.7]

Categories: `ai` `police`

Predicting future crimes? Sure, I am all for it, _until_ they make a mistake and implicate the hero himself. After watching the movie, you could be thinking, _we_ should probably not try to predict the future! Nevertheless, great movie! - [@icyflame](https://github.com/icyflame)

<details>
  <summary>Description</summary>

  > In a future where a special police unit is able to arrest murderers before they commit their crimes, an officer from that unit is himself accused of a future murder.
</details>

#### [Moon](https://www.imdb.com/title/tt1182345/) (2009) [8.0]

Categories: `space` `drama`

This is one of the best drawn-out psychodrama films about space out there, along with 2001: A Space Odyssey and Solaris. Sam Bell is pretty much the only actor in the film, and his lonely acting makes you feel the loneliness of isolation. This film is also fantastic for its powerful score. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Astronaut Sam Bell has a quintessentially personal encounter toward the end of his three-year stint on the Moon, where he, working alongside his computer, GERTY, sends back to Earth parcels of a resource that has helped diminish our planet’s power problems.
</details>

#### [Mr. Nobody](https://www.imdb.com/title/tt0485947) (2009) [7.9]

Categories: `drama` `romance`

This is one of my favourite movies. A myriad of stories are told: the different ramifications of how Mr. Nobody's life would have been if he had made different choices or if different things happened around him. What's best of this movie is that each of these **lifes** is completely different (and **would have been equally meaningful** :D) which means a lot of stuff is happening all the time and you have to follow what is going on now in this life, how it relates to its past which is probably another life shown in the movie and it's the common past of several of the lives you'll see. At the same time you have to understand the common theme of the movie, which I think it is what is trying to communicate after all. The end is surprising and difficult to grasp at first. The film also makes substantial use of chaos theory and the butterfly effect to accentuate the lack of control that humanity as individuals possesses - [@damaru2](https://github.com/damaru2)

<details>
  <summary>Description</summary>

  > A boy stands on a station platform as a train is about to leave. Should he go with his mother or stay with his father? Infinite possibilities arise from this decision. As long as he doesn't choose, anything is possible.
</details>

#### [Oblivion](https://www.imdb.com/title/tt1483013/) (2013) [7.0]

Categories: `apocalypse`

A post-apocalyptic movie, starring Tom Cruise as Jack Harper (Tech 49) and Andrea Riseborough as Victoria (Vica). Jack has a lot of questions, Vica shrugs them off, and then, they get answered and Jack can barely live with it! Beuatifully shot! - [@icyflame](https://github.com/icyflame)

<details>
  <summary>Description</summary>

  > A veteran assigned to extract Earth’s remaining resources begins to question what he knows about his mission and himself.
</details>

#### [Open Your Eyes](https://www.imdb.com/title/tt0125659/) (1997) [7.8]

Categories: `drama` `romance`

The original spanish movie [Vanilla Sky](#vanilla-sky-2001-69) was based on, way better acting, you should watch this first. - [@uraimo](https://github.com/uraimo)

<details>
  <summary>Description</summary>

  > A very handsome man finds the love of his life, but he suffers an accident and needs to have his face rebuilt by surgery after it is severely disfigured.
</details>

#### [Paprika](https://www.imdb.com/title/tt0851578/) (2006) [7.7]

Categories: `ai`

<details>
  <summary>Description</summary>

  > When a machine that allows therapists to enter their patients’ dreams is stolen, all hell breaks loose. Only a young female therapist can stop it: Paprika. 
</details>

#### [Possible Worlds](https://www.imdb.com/title/tt0222293/) (2000) [6.9]

Categories: `philosophy` `drama`

This is an extraordinary film that manages to give an expose of possible worlds without ending with a completely deranged plot. It is well done, and the mystery and romance of the characters involved adds to the constanct feeling of apprehension. Which reality is the viewer in? Also, Tilda Swinton is great in this. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A man lives in parallel worlds, falling in love with the same woman, while the police hunt down a serial killer who steals brains.
</details>

#### [Predestination](https://www.imdb.com/title/tt2397535/) (2014) [7.5]

Categories: `time travel`

<details>
  <summary>Description</summary>

  > The life of a time-traveling Temporal Agent. On his final assignment, he must pursue the one criminal that has eluded him throughout time.
</details>

#### [Primer](https://www.imdb.com/title/tt0390384/) (2004) [7.0]

<details>
  <summary>Description</summary>

  > Four friends/fledgling entrepreneurs, knowing that there’s something bigger and more innovative than the different error-checking devices they’ve built, wrestle over their new invention.
</details>

#### [Screamers](https://www.imdb.com/title/tt0114367/) (1995) [6.3]

Categories: `apocalyptic` `artificial intelligence` `space`

A thrilling ride that expertly blends suspense with thought-provoking themes about technology and warfare. If you enjoy films that challenge your perceptions of humanity and technology, this is definitely one to watch! - [@johan-stenqvist](https://github.com/johan-stenqvist)

<details>
  <summary>Description</summary>

  > A military commander stationed off planet during an interplanetary war travels through the devastated landscape to negotiate a peace treaty, but discovers that the primitive robots they built to kill enemy combatants have gained sentience.
</details>

#### [Serenity (Firefly)](https://www.imdb.com/title/tt0379786/) (2005) [8.0]

Categories: `space` `western` `action`

Watch the Firefly series before seeing this film. It is good in itself, for the special effects if nothing else, but it wraps up and solidifies a lot of things that the cancelled show left open, to the equal chagrin and joy of its fanatic fanbase. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > The crew of the ship Serenity tries to evade an assassin sent to recapture one of their number who is telepathic.
</details>

#### [Snowpiercer](https://www.imdb.com/title/tt1706620/) (2013) [7.0]

Categories: `apocalypse` `action`

<details>
  <summary>Description</summary>

  > Set in a future where a failed climate-change experiment kills all life on the planet except for a lucky few who boarded the Snowpiercer, a train that travels around the globe, where a class system emerges.
</details>

#### [Solaris](https://www.imdb.com/title/tt0069293/) (1972) [8.1]

Categories: `space` `drama`<br>
Director: _Andrei Tarkovsky_

This is the original film based on the book. It is much slower than the remake, but a classic. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A psychologist is sent to a station orbiting a distant planet in order to discover what has caused the crew to go insane.
</details>

#### [Solaris](https://www.imdb.com/title/tt0307479/) (2002) [6.2]

Categories: `space` `drama`<br>
Director: _Steven Soderbergh_

Starring George Clooney and Natasha McElhone, this is much more of a modern psychodrama with fantastic shots and a more colored atmosphere than the original film. The original score by Cliff Martinez really adds to the film, and is great on its own. One of my favorite films. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A troubled psychologist is sent to investigate the crew of an isolated research station orbiting a bizarre planet.
</details>

#### [Source Code](https://www.imdb.com/title/tt0945513/) (2011) [7.5]

Categories: `ai` `action`

<details>
  <summary>Description</summary>

  > A soldier wakes up in someone else’s body and discovers he’s part of an experimental government program to find the bomber of a commuter train. A mission he has only 8 minutes to complete.
</details>

#### [Stalker](https://www.imdb.com/title/tt0079944/) (1979) [8.2]

Stalker is a philosophical art movie and aesthetic masterpiece, based on "Roadside Picnic". - [@ggb](https://github.com/ggb)

<details>
  <summary>Description</summary>

  > Near a gray and unnamed city is the Zone, an alien place guarded by barbed wire and soldiers. Over his wife’s objections, a man rises in the early morning and leaves her with their disabled daughter to meet two men. He’s a Stalker, one of a handful who have the mental gifts (and who risk imprisonment) to lead people into the Zone to the Room, a place where one’s secret hopes come true.
</details>

#### [Strange Days](https://www.imdb.com/title/tt0114558/) (1995) [7.2]

Categories: `action` `police` `thriller`
Director: _Kathryn Bigelow_
Writer: _James Cameron_, _Jay Cocks_

Borrowing copiously from cyperpunk but giving things enough spin to keep them interesting, "Strange Days" gives an orginal sci-fi version of the old washed-up-cop turns soft-hearted criminal. Set in the futuristic year of 1999, during new years eve, the main character has to solve a case in which he unwittingly finds himself, if he wants to survive the night. The movie also contains music performance by Juliette Lewis and the band Skunk Anansie.
- [@potherca](https://github.com/potherca)

<details>
  <summary>Description</summary>

  > A former cop turned street-hustler accidentally uncovers a conspiracy in Los Angeles in 1999.
</details>

#### [Sunshine](https://www.imdb.com/title/tt0448134/) (2007) [7.3]

Categories: `space` `action`

This is a pretty good movie. The science is ridiculous, but the characters are great and the CGI is fantastic. At points, chilling. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A team of international astronauts is sent on a dangerous mission to reignite the dying Sun with a nuclear fission bomb in 2057.
</details>

#### [Tenet](https://www.imdb.com/title/tt6723592/) (2020) [7.3]

Categories: `time travel` `action` `thriller`

A great watch for those who like complex movies that you probably have to watch several times to understand everything. - [@gilStettler](https://github.com/gilStettler)

<details>
  <summary>Description</summary>
	
  > Armed with only the word "Tenet," and fighting for the survival of the entire world, CIA operative, The Protagonist, journeys through a twilight world of international espionage on a global mission that unfolds beyond real time.
</details>	

#### [The City of Lost Children](https://www.imdb.com/title/tt0112682/) (1995) [7.7]

<details>
  <summary>Description</summary>

  > A scientist in a surrealist society kidnaps children to steal their dreams, hoping that they slow his aging process.
</details>

#### [The Fifth Element](https://www.imdb.com/title/tt0119116/) (1997) [7.6]

Categories: `space` `action`

This movie is ridiculous. Worth watching just for the amazing opera scene - the 'science' in 'science fiction' isn't really worth it, though. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > In the colorful future, a cab driver unwittingly becomes the central figure in the search for a legendary cosmic weapon to keep Evil and Mr Zorg at bay.
</details>

#### [The Hitchhiker’s Guide to the Galaxy](https://www.imdb.com/title/tt0371724/) (2005) [6.8]

Categories: `adventure` `comedy`

Pretty much like the first book of the trilogy of five books with the same name, with some Holywood adaptations. (Why, Hollywood?). Very funny and enjoyable. - [@damaru2](https://github.com/damaru2)

<details>
  <summary>Description</summary>

  > Mere seconds before the Earth is to be demolished by an alien construction crew, journeyman Arthur Dent is swept off the planet by his friend Ford Prefect, a researcher penning a new edition of "The Hitchhiker's Guide to the Galaxy."
</details>

#### [The Island](https://www.imdb.com/title/tt0399201/) (2005) [6.9]

Categories: `action`

I rather liked this film; Steve Buscemi's acting abilities brings a poorly-written character above and beyond what I would have thought possible, and Ewan McGregor and Scarlett Johanssen were perfectly cast. This was a solid film. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Lincoln Six-Echo is a resident of a seemingly Utopian but contained facility in the year 2019. Like all of the inhabitants of this carefully controlled environment, Lincoln hopes to be chosen to go to the "The Island" - reportedly the last uncontaminated spot on the planet. But Lincoln soon discovers that everything about his existence is a lie. He and all of the other inhabitants of the facility are actually human clones. Lincoln makes a daring escape with a beautiful fellow resident named Jordan Two-Delta. Relentlessly pursued by the forces of the sinister institute that once housed them, Lincoln and Jordan engage in a race for their lives to literally meet their makers.
</details>

#### [The Man from Earth](https://www.imdb.com/title/tt0756683/) (2007) [8.0]

<details>
  <summary>Description</summary>

  > An impromptu goodbye party for Professor John Oldman becomes a mysterious interrogation after the retiring scholar reveals to his colleagues he never ages and has walked the earth for 14,000 years.
</details>

#### [The Martian](https://www.imdb.com/title/tt3659388/) (2015) [8.2]

This is a fairly accurate representation of the awesome book, but it focuses much more on Watney's personality than on the science (which is a given, as we can actually see Watney in this, as opposed to just read his logs in the book). The space shots were incredibly well done, and one scene with a ribbon like an umbilical chord floating in zero g - absolutely beautiful. This film had great actors, marvelously cast. And there's even a reference to Glorfindel at the council of Elrond; I don't think I've laughed that hard in a theatre in years. Loved it. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > During a manned mission to Mars, Astronaut Mark Watney is presumed dead after a fierce storm and left behind by his crew. But Watney has survived and finds himself stranded and alone on the hostile planet. With only meager supplies, he must draw upon his ingenuity, wit and spirit to subsist and find a way to signal to Earth that he is alive.
</details>

#### [The Matrix](https://www.imdb.com/title/tt0133093/) (1999) [8.7]

Categories: `ai` `action` `apocalypse` `singularity`

One of the most well known scifi films, this is a great expose on what people thought of hackers in the late 90s. The first in a trilogy, this film stands on its own legs, for its well-written script, great casting, and solid score. The unworldly choreography combined with slow motion filming was so influential it is now a cliché. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A computer hacker learns from mysterious rebels about the true nature of his reality and his role in the war against its controllers.
</details>

#### [The Signal](https://www.imdb.com/title/tt2910814/) (2014) [6.2]

<details>
  <summary>Description</summary>

  > On a road trip, Nic and two friends are drawn to an isolated area by a computer genius. When everything suddenly goes dark, Nic regains consciousness - only to find himself in a waking nightmare.
</details>

#### [The Thirteenth Floor](https://www.imdb.com/title/tt0139809/) (1999) [7.0]

Categories: `thriller` `ai`

It's a classic, came out the same year of the matrix but is focused on the interactions between the real world and the virtual, no slow motion gun fights here. - [@uraimo](https://github.com/uraimo)

<details>
  <summary>Description</summary>

  > Computer scientist Hannon Fuller has discovered something extremely important. He's about to tell the discovery to his colleague, Douglas Hall, but knowing someone is after him, the old man leaves a letter in the computer generated parallel world his company has created (which looks like the 30's with seemingly real people with real emotions). Fuller is murdered in our real world the same night, and his colleague is suspected. Douglas discovers a bloody shirt in his bathroom and he cannot recall what he was doing the night Fuller was murdered. He logs into the system in order to find the letter, but has to confront the unexpected. The truth is harsher than he could ever imagine...
</details>

#### [The Time Machine](https://www.imdb.com/title/tt0268695/) (2002) [4.2]

Categories: `remake` `steampunk`

It is an entertaining and a well done movie with lots of scifi topics: time travels, artificial intelligence, a post apocalyptic world with a new race of humans and more. - [@damaru2](https://github.com/damaru2)

<details>
  <summary>Description</summary>

  > Hoping to alter the events of the past, a 19th century inventor instead travels 800,000 years into the future, where he finds humankind divided into two warring races.
</details>

#### [Transcendence](https://www.imdb.com/title/tt2209764/) (2014) [6.3]

Categories: `ai`

A love story between a woman and her husband uploaded into a computer. What makes the movie a bit scary is that, although a bit unrealistic, it is placed in a near future. - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

<details>
  <summary>Description</summary>

  > A scientist’s drive for artificial intelligence, takes on dangerous implications when his consciousness is uploaded into one such program.
</details>

#### [Twelve Monkeys](https://www.imdb.com/title/tt0114746/) (1996) [8.1]

Categories: `time travel` `action`

<details>
  <summary>Description</summary>

  > In a future world devastated by disease, a convict is sent back in time to gather information about the man-made virus that wiped out most of the human population on the planet.
</details>

#### [Vanilla Sky](https://www.imdb.com/title/tt0259711/) (2001) [6.9]

Categories: `drama` `romance`

This is an early version of [Inception](#inception) in a lot of ways, and a remake of Possible Worlds in others. While the acting isn't spectactular (notably Tom Cruise's), what is interesting is the myriad level of interpretations of the film and possibly realities involved. The budget ensured that the actual plot was well done, as opposed to just a poor implementation of possible world ideas. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A self-indulgent and vain publishing magnate finds his privileged life upended after a vehicular accident with a resentful lover.
</details>

## Movie Series

### Star Trek

![](https://cloud.githubusercontent.com/assets/170270/7905777/f4fc5402-081e-11e5-9a71-8dad63e3b30b.gif)

#### [Star Trek II: The Wrath of Khan](https://www.imdb.com/title/tt0084726/) [7.7]

This is a classic film, and well worth watching if only for the incredible and iconic 'khaaaaan' echo. More impressive, however, is Ricardo Montalban's performance, which is incredible on its own. As well, in a move that goes against mainstream whitewashing, a Mexican and not a Caucasian plays a genetically engineered superhuman, making this a movie that showed the power of diversity well ahead of its time. This movie is great to watch. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > With the assistance of the Enterprise crew, Admiral Kirk must stop an old nemesis, Khan Noonien Singh, from using his son’s life-generating device, the Genesis Device, as the ultimate weapon.
</details>

## TV Series

#### [Babylon 5](https://www.imdb.com/title/tt0105946/) (1994–1998) [8.2]

Categories: `action` `adventure` `drama`

Babylon 5's special effects left a lot to be desired, but the plot was amazing. - [@elektrovert](https://github.com/elektrovert)

The CGI hasn't aged well—but the show's strength lies in character development and (on a meta level) the pre-planned structure which is fairly unique for TV series. On the other hand, it's a polarizing show... So my vote is a conditional yes :) - [@mihailim](https://github.com/mihailim)

This is awesome for its nostalgic value, if little else. The line about frictionless sheets is hilarious. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > A space station in neutral territory is the focus of a unique five year saga.
</details>

#### [Battlestar Galactica](https://www.imdb.com/title/tt0407362/) (2004–2009) [8.8]

Categories: `action` `adventure` `drama`

This show. Watch this show. It's military science fiction done right. The interpersonal relationships are the best part, and the constant questioning of what it means to be human. At times it is a bit heavy handed. At other times it paints humanity as a desperate and stupid species, but at least it does so faithfully and self-referentially. The show is written tremendously well. Gaius Baltar, in particular, is a character worth watching out for. Be warned: once you start, you can't really stop. Portlandia even made a skit about needing [one more episode](https://www.youtube.com/watch?v=yYjLrJRuMnY). - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > When an old enemy, the Cylons, resurfaces and obliterate the 12 colonies, the crew of the aged Galactica protects a small civilian fleet - the last of humanity - as they journey toward the fabled 13th colony of Earth.
</details>

#### [Black Mirror](https://www.imdb.com/title/tt2085059/) (2011– ) [8.8]

Categories: `drama` `thriller`

<details>
  <summary>Description</summary>

  > A television anthology series that shows the dark side of life and technology.
</details>

#### [Blakes 7](https://www.imdb.com/title/tt0076987/) (1978–1981) [8.0]

Categories: `adventure` `drama`

<details>
  <summary>Description</summary>

  > A group of convicts and outcasts fight a guerrilla war against the totalitarian Terran Federation from a highly advanced alien spaceship.
</details>

#### [Children of Dune](https://www.imdb.com/title/tt0287839/) (2003) [7.7]

Categories: `adventure` `drama` `fantasy`

James McAvoy's acting as Leto II is absolutely incredible in this short series, as is Susan Sarandon's as Princess Corrinno. This miniseries is short and sweet, and manages to make the most out of what really is one of the lesser of the Dune book series. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > The twins of Paul "Muad'dib" Atreides become embroiled in the political landscape of Arrakis ("Dune") and the rest of the universe.
</details>

#### [Continuum](https://www.imdb.com/title/tt1954347/) (2012–2015) [7.8]

Categories: `action` `thriller`

<details>
  <summary>Description</summary>

  > A detective from the year 2077 finds herself trapped in present day Vancouver and searching for ruthless criminals from the future.
</details>

#### [Doctor Who](https://www.imdb.com/title/tt0436992/) (1964-1989, 2005– ) [8.9]

Categories: `adventure` `drama` `family`

<details>
  <summary>Description</summary>

  > The further adventures of the time traveling alien adventurer and his companions.
</details>

#### [Dune](https://www.imdb.com/title/tt0142032/) (2000) [7.1]

Categories: `adventure` `drama` `fantasy`

Out of all--big or small screen--Dune adaptations, I felt this one has come closest to Herbert's vision. They didn't go too crazy on the CGI either, in that it didn't distract from the story. The acting was a bit meh, but that's usually a question of budget (wasn't HBO... :wink:). Given the dearth of good SF on TV, I would consider it awesome by comparison. - [@mihailim](https://github.com/mihailim)

<details>
  <summary>Description</summary>

  > A three-part miniseries on politics, betrayal, lust, greed and the coming of a Messiah. Based on Frank Herbert's classic science fiction novel.
</details>

#### [Eureka](https://www.imdb.com/title/tt0796264/) (2006-2012) [7.9]

Categories: `adventure` `drama` `family`

It is all about a fictional town called Eureka. Inhabitants are geniuses and scientists. This is where the most major technology inventions in the last five decades did happen. Very enjoyable and entertaining show. Most of the episodes were keeping me guessing 'what will happen next?' and 'how this all will end?'. - [@vovinacci](https://github.com/vovinacci)

<details>
  <summary>Description</summary>

  > A U.S. Marshall becomes the sheriff of a remote cozy little Northwestern town of Eureka where the best minds in the US have secretly been tucked away to build futuristic inventions for the government which often go disastrously wrong.
</details>

#### [Farscape](https://www.imdb.com/title/tt0187636/) (1999–2003) [8.4]

Categories: `adventure` `drama`

<details>
  <summary>Description</summary>

  > Thrown into a distant part of the universe, an Earth astronaut finds himself part of a fugitive alien starship crew.
</details>

#### [Firefly](https://www.imdb.com/title/tt0303461/) (2002–2003) [9.2]

Categories: `adventure` `drama` `western`

![Rise again](https://cloud.githubusercontent.com/assets/170270/11022860/c94c77c2-869c-11e5-9830-ec232159f00e.gif)

Asking someone if they wish Firefly would be rebooted tells me everything I need to know about a person.

It's in my opinion the best scifi TV-show ever made. - [@sindresorhus](https://github.com/sindresorhus)

What he said. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > Five hundred years in the future, a renegade crew aboard a small spacecraft tries to survive as they travel the unknown parts of the galaxy and evade warring factions as well as authority agents out to get them.
</details>

#### [Fringe](https://www.imdb.com/title/tt1119644/) (2008–2013) [8.5]

Categories: `drama` `mystery`

<details>
  <summary>Description</summary>

  > A television drama centered around a female FBI agent who is forced to work with an institutionalized scientist in order to rationalize a brewing storm of unexplained phenomena.
</details>

#### [Hitchhiker’s Guide to the Galaxy](https://www.imdb.com/title/tt0081874/) (1981) [8.0]

Categories: `comedy` `adventure`

<details>
  <summary>Description</summary>

  > An Earth man and his alien friend escape Earth’s destruction and go on a truly strange adventure as space hitchhikers.
</details>

#### [Mr. Robot](https://www.imdb.com/title/tt4158110/) (2015- ) [8.6]

Categories: `crime` `drama` `thriller`

Mr. Robot is a sci fi series which actually is close enogh to reality, it uses technical terms properly and is fun to watch. - [@iamzubin](https://github.com/iamzubin)

<details>
  <summary>Description</summary>

  > Elliot, a brilliant but highly unstable young cyber-security engineer and vigilante hacker, becomes a key figure in a complex game of global dominance when he and his shadowy allies try to take down the corrupt corporation he works for.
</details>

#### [Neon Genesis Evangelion](https://www.imdb.com/title/tt0112159/) (1995–1996) [8.6]

Categories: `animation` `action` `drama`

<details>
  <summary>Description</summary>

  > 15 years after the enormous catastrophe that killed half of the world population, another crisis has come—the unidentified invaders called “Angels” begin to attack human-kind. Mankind’s only hope lies with giant organic mecha and their teenage pilots.
</details>

#### [Person of Interest](https://www.imdb.com/title/tt1839578/) (2011-2016) [8.5]

Categories: `action` `crime` `drama` `artificial intelligence`

Starting with crime prevention, the show progresses to gradually touching on AI and man's misuse of technology such as mass surveillance, which is the key focus. Add to that the complicated pasts of the two protagonists' government work and you have a genre defining TV Show standing apart from it's peers by tackling relevant issues in the modern digital era. "You are being watched." - [@AB1908](https://github.com/AB1908)

<details>
  <summary>Description</summary>

  > An ex-assassin and a wealthy programmer save lives via a surveillance AI that sends them the identities of civilians involved in impending crimes. However, the details of the crimes--including the civilians' roles--are left a mystery.
</details>

#### [Red Dwarf](https://www.imdb.com/title/tt0094535/) (1988–1999, 2009– ) [8.5]

Categories: `comedy`

This stretched my ideas of how stupid and silly space travel could be. It's smegging awesome. - [@RichardLitt](https://github.com/RichardLitt)

<details>
  <summary>Description</summary>

  > The adventures of the last human alive and his friends, stranded three million years into deep space on the mining ship Red Dwarf.
</details>

#### [Rick and Morty](https://www.imdb.com/title/tt2861424/) (2013-) [9.3]

Categories: `animation` `adventure` `comedy`

Rick and Morty is one of the best animated shows to have come out in the last decade. The commentary that the show delivers on the society as a whole, while describing the adventures of an old man and his grandon is hilarious. This is a must-watch for anyone who is into veiled sarcasm, animation and sci-fi. - [@ArindumRoy](https://github.com/AsliRoy)

<details>
  <summary>Description</summary>

  > An animated series that follows the exploits of a super scientist and his not-so-bright grandson.
</details>

#### [Star Trek: Deep Space Nine](https://www.imdb.com/title/tt0106145/) (1993–1999) [7.9]

Categories: `action` `adventure` `drama`

In contrast to the setting of the other Star Trek TV shows, DS9 takes place on a space station instead of a starship. This made continuing story arcs and appearance of recurring characters much more feasible. The show is noted for well-developed characters, originality, complex plots, religious themes and for starring the only black captain of all the Star Trek series to be featured as the show's protagonist. The series often showcased darker themes, less physical exploration of space, and (in later seasons) an emphasis on many aspects of war. - @augustopedro

<details>
  <summary>Description</summary>

  > Orbiting the liberated planet of Bajor, a Federation space station guards the opening of a stable wormhole to the far side of the galaxy.
</details>

#### [Star Trek: Discovery](https://www.imdb.com/title/tt5171438/) (2017-) [7.3]

Categories: `action` `adventure` `drama`

While Discovery is fundamentally quite different from much of the Trek that's come before, its engagement with the franchise, and willingness to both celebrate and examine its core values, keep it true to that spirit. As the medium of television evolves, it's comforting to know that Star Trek is there to evolve right along with it. - @augustopedro

<details>
  <summary>Description</summary>

  > Ten years before Kirk, Spock and the Enterprise, the USS Discovery discovers new worlds and lifeforms as one Starfleet officer learns to understand all things alien.
</details>

#### [Star Trek: Enterprise](https://www.imdb.com/title/tt0244365/) (2001–2005) [7.5]

Categories: `action` `adventure` `mystery`

A worthy successor to The Next Generation, well developed characters, great Xindi/Time War story arc. - [@uraimo](https://github.com/uraimo)

<details>
  <summary>Description</summary>

  > A century before Captain Kirk's five-year mission, Jonathan Archer captains Earth ship Enterprise NX-01 during the early years of Starfleet leading up to the formation of the Federation and the Earth-Romulan War.
</details>

#### [Star Trek: The Next Generation](https://www.imdb.com/title/tt0092455/) (1987–1994) [8.7]

Categories: `action` `adventure` `mystery`

Similar in ethic and setting to the Star Trek: The Original Series, but with new enemies and technologies; continues to deal with issues of morality, culture, and politics. The stories and the acting are excellent, and it has pretty amazing special effects for that time. There's also 4 movies which take place after the series. - @augustopedro

<details>
  <summary>Description</summary>

  > Set decades after Captain James T. Kirk's 5-year mission, a new generation of Starfleet officers in a new Enterprise set off on their own mission to go where no one has gone before.
</details>

#### [Star Trek: The Original Series](https://www.imdb.com/title/tt0060028/) (1966–1969) [8.4]

Categories: `action` `adventure` `mystery`

A science-fiction masterpiece, Star Trek has been a really important vision not only of what future technology could look like, but also a reflection of what the hopes were, especially in the 60's, for what human society could look like.

The Original Series, in many ways, is Star Trek at its purest. It's true that it could be campy and slow, but don't mistake that for it being unsophisticated. It was very smartly written, and while it can vary wildly in quality (like many shows from the 60's) it has a solid philosophical core, and often had some interesting things to say.

Plus, I'm not sure the franchise has ever quite topped the amazing chemistry between Shatner, Nimoy, and Kelly. It's worth watching for them alone. - @augustopedro

<details>
  <summary>Description</summary>

  > Captain James T. Kirk and the crew of the Starship Enterprise explore the Galaxy and defend the United Federation of Planets.
</details>

#### [Stargate Atlantis](https://www.imdb.com/title/tt0374455/) (2004–2009) [8.1]

Categories: `action` `drama`

<details>
  <summary>Description</summary>

  > An international team of scientists and military personnel discover a Stargate network in the Pegasus Galaxy and come face-to-face with a new, powerful enemy, The Wraith.
</details>

#### [Stargate SG1](https://www.imdb.com/title/tt0118480/) (1997–2007) [8.5]

Categories: `action` `adventure` `drama`

Well worth the 9000+ minutes you'll need to watch all the series. Finally a series where the human race, starting from a position of abysmal inferiority, defeats superior enemies against all odds with a mix of cleverness and intelligent exploitation of alien technology. - [@uraimo](https://github.com/uraimo)

<details>
  <summary>Description</summary>

  > A secret military team, SG-1, is formed to explore the recently discovered Stargates.
</details>

#### [Stargate Universe](https://www.imdb.com/title/tt1286039/) (2009–2011) [7.7]

Categories: `drama`

The show feels completely different than Stargate SG-1 and Atlantis, it is certainly the most cinematic looking of the three series. It is darker, the plot seems slower, but also more realistic and intense, which provides a higher dose of suspense to the show. - [@HQarroum](https://github.com/HQarroum)

<details>
  <summary>Description</summary>

  > Trapped on an Ancient spaceship billions of light years from home, a group of soldiers and civilians struggle to survive and find their way back to Earth.
</details>

#### [The 100](https://www.imdb.com/title/tt2661044/) (2014–) [7.7]

Categories: `drama` `mystery`

I never really understood the need or reason for binge watching until I encountered The 100. The first and second season were absolutely mesmerizing and compelling. The character development, the story, the plot twists; all amazing! Literally, pulled a few all-nighters because I had to know what happened next in the series. The premise of the show is after evacuating Earth do to global nuclear bombings and radiation, the International Space Station decide to send '100' of the stations adolescent deliquents down to earth so see if it is habitable again. Middle to end of season 3 start to get a little weird and supposedly it was supposed to end after season 3 so they attempt to wrap up the series. I have tried to continue watching but am no where as entranced as I was with seasons 1 and 2. - [@kyebrowning](https://github.com/kyebrowning)

<details>
  <summary>Description</summary>

  > Set ninety-seven years after a nuclear war has destroyed civilization, when a spaceship housing humanity's lone survivors sends one hundred juvenile delinquents back to Earth, in hopes of possibly re-populating the planet.
</details>

#### [The Orville](https://www.imdb.com/title/tt5691552/) (2017–) [7.9]

Categories: `adventure` `comedy` `drama`

The Orville does an awesome job recreating the feeling of past Star Trek series. The look and feel is very TNG-era. Many episodes tackle modern day social issues like LGBTQ rights, social media and religion. The characters are interesting and relatable, since they talk and behave like real, imperfect people. Though the series has a comedic element, it doesn't interfere with the other messages, and we get a very good balance of sci-fi, humor, drama and moral. Highly recommended for (but not only) Trekkies. - [@GabiAxel](https://github.com/gabiaxel)

<details>
  <summary>Description</summary>

  > Follows the crew of the not-so-functional exploratory ship in the Earth's interstellar fleet, 400 years in the future.
</details>

#### [The Prisoner](https://www.imdb.com/title/tt0061287/) (1967–1968) [8.8]

Categories: `drama` `mystery`

<details>
  <summary>Description</summary>

  > After resigning, a secret agent is abducted and taken to what looks like an idyllic village, but is really a bizarre prison. His warders demand information. He gives them nothing, but only tries to escape.
</details>

#### [The X-Files](https://www.imdb.com/title/tt0106179/) (1993-2002, 2016- ) [8.8]

Categories: `drama` `mystery`

<details>
  <summary>Description</summary>

  > Two FBI agents, Fox Mulder the believer and Dana Scully the skeptic, investigate the strange and unexplained while hidden forces work to impede their efforts.
</details>

#### [Twilight Zone](https://www.imdb.com/title/tt0052520/) (1959–1964) [9.0]

Categories: `drama` `fantasy` `horror`

<details>
  <summary>Description</summary>

  > Rod Serling’s seminal anthology series focused on ordinary folks who suddenly found themselves in extraordinary, usually supernatural, situations. The stories would typically end with an ironic twist that would see the guilty punished.
</details>

## Comic Books

#### [Alex + Ada](https://www.goodreads.com/book/show/30896668-alex-ada) (2013-2015) _by [Jonathan Luna](https://en.wikipedia.org/wiki/Luna_Brothers), [Sarah Vaughn](https://www.goodreads.com/author/show/7372180.Sarah_Vaughn)_ [4.11]

Categories: `ai` `drama` `sci-fi`

Alex + Ada is a thought provoking and moving exploration of what it means to be alive, and what rights can and should be afforded to non-human sentient beings. It's a short and effective near-future look at the obligations we have to both each other and to the intelligent life we create. - [@thejessleigh](https://github.com/thejessleigh)

<details>
  <summary>Description</summary>

  > From JONATHAN LUNA (THE SWORD, GIRLS, Spider-Woman: Origin) and SARAH VAUGHN (Sparkshooter, Ruined) comes ALEX + ADA, a sci-fi/drama set in the near future. The last thing in the world Alex wanted was an X5, the latest in realistic androids. But after Ada is dropped into his life, he discovers she is more than just a robot. Alex takes a huge risk to unlock Ada so she can think for herself and explore life as a sentient android.
</details>

#### [Arzach](https://www.goodreads.com/book/show/8748185-arzach) (1975) _by Moebius_ [4.06]

Categories: `hard-science-fiction` `sci-fi` `cyberpunk`

One of the most influential french sci-fi comics. It inspired a lot of what became Heavy Metal Magazine. Moebius in this onirical tale uses no words to this graphical prose. - [@matheusteixeira](https://github.com/matheusteixeira)

<details>
  <summary>Description</summary>

  > Arzach fut une révolution pour la bande dessinée de l'époque. Elle est constituée d'une série de cinq histoires autonomes, sortes de « nouvelles graphiques » de quelques planches chacune. Sa particularité réside tout d'abord en son absence totale de dialogues : on y croise un voire deux personnages récurrents (Arzach et son Ptéroïde, sorte de ptérodactyle) mais apparemment muets, en tout cas l'auteur ne leur autorise pas la parole pour s'exprimer.
</details>

#### [Black Science](https://www.goodreads.com/book/show/20881139-black-science-vol-1) (2014) _by [Rick Remender](https://en.wikipedia.org/wiki/Rick_Remender)_ [3.93]

Categories: `space-opera` `sci-fi`

Black Science is one of those stories where you explain it to people at a really high level and gradually get more excited as you do so. It's essentially what happens if Rick & Morty had a less skilled and lucky Rick. Grant McKay goes through some really dark experiences, and the multiverse around him feels nothing for his plight. It's a story to read and revisit. - [@EricPonvelle](https://github.com/EricPonvelle)

<details>
  <summary>Description</summary>

  > Grant McKay, former member of The Anarchistic Order of Scientists, has finally done the impossible: He has deciphered Black Science and punched through the barriers of reality. But what lies beyond the veil is not epiphany, but chaos. Now Grant and his team are lost, living ghosts shipwrecked on an infinite ocean of alien worlds, barreling through the long-forgotten, ancient, and unimaginable dark realms. The only way is forward. The only question is how far are they willing to go, and how much can they endure, to get home again? Join writer RICK REMENDER and the superstar art team of MATTEO SCALERA & DEAN WHITE for this face-melting science fiction epic spanning the lifetimes of a cast of dimensional castaways lead by the man who caused it all.
</details>

#### [Global Frequency](https://www.goodreads.com/book/show/15819022-global-frequency) (2002-2004) _by Warren Ellis_ [4.05]

Categories: `hard-science-fiction` `sci-fi`

Global Frequency is a very livid, strong, and fast-paced adventure/action-packed sci-fi. Each of the twelve issues is kinda independent and all of them are bursting with life. - [@matheusteixeira](https://github.com/matheusteixeira)

<details>
  <summary>Description</summary>

  > Created by Entertainment Weekly "It" writer, Global Frequency is a worldwide rescue organization that offers the last shred of hope when all other options have failed. Manned by 1001 operatives, the Frequency is made up of experts in fields as diverse as bio-weapon engineering and Le Parkour Running. Each agent-equipped with a special mobile vid-phone-is speciffically chosen by Miranda Zero, enigmatic leader of the Global Frequency, based on proximity, expertise, and, in some cases, sheer desperation!
</details>

#### [Saga](https://www.goodreads.com/book/show/17131869-saga-vol-2) (2014-) _by Brian K. Vaughan_ [4.56]

Categories: `fantasy` `sci-fi` `space-opera`

Saga is a comic that is an elevator pitch proof. It's impossible to describe it in a sentence. All I can say is that it's a beautifully written and drawn story about love and family, in a very interesting space opera-like world. It's kinda like Star Wars, but not at all. While in Star Wars the heroes are in a huge journey to end the war, in Saga they just want to be left alone to live with their family. - [@matheusteixeira](https://github.com/matheusteixeira)

<details>
  <summary>Description</summary>

  > Saga is an epic space opera/fantasy comic book series created by writer Brian K. Vaughan and artist Fiona Staples, published monthly by Image Comics. The series is heavily influenced by Star Wars, and based on ideas Vaughan conceived both as a child and as a parent. It depicts two lovers from long-warring extraterrestrial races, Alana and Marko, fleeing authorities from both sides of a galactic war as they struggle to care for their newborn daughter, Hazel, who occasionally narrates the series.
</details>

#### [The Incal](https://www.goodreads.com/book/show/10842223-the-incal) (1981) _by Alejandro Jodorowsky and Mœbius_ [4.2]

Categories: `sci-fi` `dystopian` `surrealist` `space-opera`

Highly imaginative, hilarious, sprawling epic graphic novel — a collaboration between two giants of weird storytelling. Jodorowsky is an auteur of avant-garde film, and Mœbius is a legendary cartoonist; together their work has been a huge influence on such classic films as Alien, Tron, and Star Wars. The story is all kinds of preposterous, a dazzling display of surrealist science fiction, and the illustrations render it way-larger-than-life on the page. This single-volume collection of the complete series is well-worth the read. - [@bschlagel](https://github.com/bschlagel)

<details>
  <summary>Description</summary>

  > John Difool, a low-class detective in a degenerate dystopian world, finds his life turned upside down when he discovers an ancient, mystical artifact called "The Incal." Difool's adventures will bring him into conflict with the galaxy's greatest warrior, the Metabaron, and will pit him against the awesome powers of the Technopope. These encounters and many more make up a tale of comic and cosmic proportions that has Difool fighting for not only his very survival, but also the survival of the entire universe.
</details>

#### [The Manhattan Projects](https://www.goodreads.com/book/show/15736709-the-manhattan-projects-volume-1) (2015-) _by Jonathan Hickman_ [3.9]

Categories: `hard-science-fiction` `sci-fi`

Mind boggling, crazy high concepts based on historical events. - [@matheusteixeira](https://github.com/matheusteixeira)

<details>
  <summary>Description</summary>

  > What if the research and development department created to produce the first atomic bomb was a front for a series of other, more unusual, programs?
</details>

#### [Transmetropolitan](https://www.goodreads.com/book/show/22416.Transmetropolitan_Vol_1) (1998) _by Warren Ellis_ [4.23]

Categories: `hard-science-fiction` `sci-fi` `cyberpunk`

One of the most anarchistic comics I ever read. Transmetropolitan has no mercy for anyone. Strong polical and social commentary in a world that is not that far from ours. - [@matheusteixeira](https://github.com/matheusteixeira)

<details>
  <summary>Description</summary>

  > After years of self-imposed exile from a civilization rife with degradation and indecency, cynical journalist Spider Jerusalem is forced to return to a job that he hates and a city that he loathes. Working as an investigative reporter for the newspaper The Word, Spider attacks the injustices of his surreal 23rd Century surroundings. Combining black humor, life-threatening situations, and moral ambiguity, this book is the first look into the mind of an outlaw journalist and the world he seeks to destroy.
</details>

#### [We3](https://www.goodreads.com/book/show/22358.We3) (2005) _by Grant Morrison_ [3.95]

Categories: `hard-science-fiction` `sci-fi` `society`

One of the most emotional stories I ever read. We3 is a very visceral and incredibly well drawn tale of freedom. - [@matheusteixeira](https://github.com/matheusteixeira)

<details>
  <summary>Description</summary>

  > Writer Grant Morrison and artist Frank Quitely tell the unforgettable story of three innocent pets-a dog, a cat and a rabbit-who have been converted into deadly cyborgs by a sinister military weapons program.With nervous systems amplified to match their terrifying mechanical exoskeletons, the members of Animal Weapon 3 have the firepower of a battalion between them. But they are just the program's prototypes, and now that their testing is complete, they're slated to be permanently "de-commissioned"-until they seize their one chance to make a desperate run for freedom. Relentlessly pursued by their makers, the WE3 team must navigate a frightening and confusing world where their instincts and heightened abilities make them as much a threat as those hunting them-but a world, nonetheless, in which somewhere there is something called "home."
</details>

#### [Y: The Last Man](https://www.goodreads.com/series/86528-y-the-last-man) (2003-2008) _by Brian K. Vaughan_ [4.33]

Categories: `dystopian` `sci-fi`

Y: The Last Man is graphic novel series unlike any other I have read. The "last man" struggles with trying to learn why every other man on earth is dead and how did he survive. Adding to his own internal struggle, the women on earth are divided between wanting to ensure humanity lives on, and those who believe they should be the last generation of humans on earth. - [@derekneuland](https://github.com/derekneuland)

<details>
  <summary>Description</summary>

  > Y: The Last Man is a dystopian science fiction comic book series by Brian K. Vaughan and Pia Guerra published by Vertigo beginning in 2002. The series is about the only man to survive the apparent simultaneous death of every male mammal (barring the same man's pet monkey) on Earth.
</details>

## Audiobooks

Some books are also exceptional as audiobooks. Some are not. Here is a space for the former.

#### [The Martian](https://www.audible.com/pd/The-Martian-Audiobook/B082BHJMFF) _by Andy Weir_, narrated by _R.C. Bray_ 

I loved this audiobook. I am not sure if this narrator's edition is still publicly available, however. - [@RichardLitt](https://github.com/RichardLitt)

See the book above for the description.

## Links

- [What are your favourite sci-fi books?](https://news.ycombinator.com/item?id=9056319) - Hacker News
- [Whats the best Sci-Fi novel you have ever read?](https://www.reddit.com/r/AskReddit/comments/k70dh/whats_the_best_scifi_novel_you_have_ever_read/) - Reddit
- [Top 100 sci-fi and fantasy books as picked by NPR listeners](https://www.npr.org/2011/08/11/139085843/your-picks-top-100-science-fiction-fantasy-books) - NPR
- [List of all the movies from this list on Letterboxd](https://letterboxd.com/potherca/list/the-awesome-sci-fi-list/)
- [List of all the novels, short story collections, and comic books from this list on Goodreads](https://www.goodreads.com/list/show/148073.The_Awesome_Sci_Fi_List)

## Credit

Maintained by [Richard Littauer](https://github.com/RichardLitt) and [these marvelous humanoids](https://github.com/sindresorhus/awesome-scifi/graphs/contributors).
