# The awesome manifesto

If you want your list to be included on `awesome`, try to only include actual awesome stuff in your list. After all, it's a curation, not a collection.

But **what is awesome?**

## Only awesome is awesome

Research if the stuff you're including is actually awesome. Only put stuff on the list that you or another contributor can personally recommend. You should rather leave stuff out than include too much.

## Awesome badge

This badge is for Awesome lists.

[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
[![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)
[![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

Add an awesome badge to the top of your list, right next to the title. [Example](https://github.com/sindresorhus/awesome-nodejs). You can choose either the regular badge or the flat one.

```md
[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
[![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)
[![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)
```

You are allowed to use the badge on lists not included here and also on private lists.

*The badges should not be modified in any way.*

## Awesome mentioned badge

This badge is intended for projects featured in an Awesome list (**not for Awesome lists themselves**). For example, the [Chalk](https://github.com/chalk/chalk) project could feature this badge because it's listed in [Awesome Node.js](https://github.com/sindresorhus/awesome-nodejs). It's totally optional for projects, but it's a nice way to show they've been featured in an Awesome list. You can choose either the regular badge or the flat one.

[![Mentioned in Awesome](https://awesome.re/mentioned-badge.svg)](https://awesome.re)
[![Mentioned in Awesome](https://awesome.re/mentioned-badge-flat.svg)](https://awesome.re)

**Fill in the placeholders (Name and URL):**

```md
[![Mentioned in Awesome <INSERT LIST NAME>](https://awesome.re/mentioned-badge.svg)](https://github.com/<INSERT LIST URL>)
[![Mentioned in Awesome <INSERT LIST NAME>](https://awesome.re/mentioned-badge-flat.svg)](https://github.com/<INSERT LIST URL>)
```

Example:

```md
[![Mentioned in Awesome Node.js](https://awesome.re/mentioned-badge.svg)](https://github.com/sindresorhus/awesome-nodejs)
```

If you're an Awesome list maintainer, you could encourage projects in your list to add the badge.

*The badges should not be modified in any way.*

## Comment on why something is awesome

Apart from suggesting a particular item on your list, you should also inform your readers *why* it's on the list and how they will benefit from it.

## Make it clear what the list is about

Have a succinct description at the top of your readme. Make sure your list covers a certain scope and nothing else. Link to other awesome lists if you think they already cover a certain subject well enough.

## Pay attention to grammar

Ensure your list is grammatically correct, typo-free and has no Markdown formatting errors. This should also apply to pull requests.

## Choose an appropriate license

Keep in mind that if you [haven't selected a license](https://choosealicense.com/no-license/), it basically means the people are *not* allowed to reproduce, distribute or create derivative works.

[Creative Commons licenses](https://creativecommons.org/) are perfect for this purpose. **We would recommend [`CC0`](https://creativecommons.org/publicdomain/zero/1.0/).** Code licenses like MIT, BSD, GPL, and so forth are not recommended.

## Include contribution guidelines

People who are contributing to your list should have a clear understanding of how they should do so.

If you don't feel like writing one from scratch, feel free to take our [contributing.md](contributing.md) and modify it to your own needs.

## Stylize your list properly

Create a [table of contents](https://github.com/sindresorhus/stuff/blob/main/toc-generators.md), organize the content into different categories, and use images if suitable. Ensure all entries are consistent (e.g. all entry descriptions end in a `.`).

## Accept other people's opinion

If you're an owner of the list, respect other people's opinions. If there are plenty of users not agreeing with your decision, give it a second thought.
