<div align="center">
	<img width="500" height="350" src="media/logo.svg" alt="Awesome">
	<br>
	<br>
	<br>
	<br>
	<div>
		<sub>Check out my macOS app</sub>
		<br>
		<h2>
			<a href="https://sindresorhus.com/supercharge">Supercharge</a>
			<br>
			<sup>Elevate your Mac experience</sup>
		</h2>
	</div>
	<br>
	<br>
	<br>
	<br>
	<hr>
	<p>
		<p>
			<sup>
				<a href="https://github.com/sponsors/sindresorhus">My open source work is supported by the community</a>
			</sup>
		</p>
		<sup>Special thanks to:</sup>
		<br>
		<br>
		<br>
		<a href="https://nitric.io/?utm_campaign=github_repo&utm_medium=referral&utm_content=sindresorhus&utm_source=github">
			<div>
				<img width="230" src="https://sindresorhus.com/assets/thanks/nitric-logo.svg" alt="nitric logo">
			</div>
			<b>Effortless backends with infrastructure from code</b>
			<div>
				<sup>An open-source framework that supports any programming language, cloud provider, or deployment automation tool.</sup>
			</div>
		</a>
		<br>
		<br>
		<br>
		<h3>
			<a href="https://ref.wisprflow.ai/VjA6dYR">Wispr Flow</a>
		</h3>
		<a href="https://ref.wisprflow.ai/VjA6dYR">
			<div>
				<img width="150" src="https://sindresorhus.com/assets/thanks/flow-logo.svg" alt="Wispr Flow logo">
			</div>
			<b>Talk to code, stay in the Flow.</b>
			<div>
				<sup>Flow is built for devs who live in their tools. Speak and give more context, get better results.</sup>
			</div>
		</a>
		<br>
		<br>
		<br>
		<a href="https://depot.dev?utm_source=github&utm_medium=sindresorhus">
			<div>
				<picture>
					<source width="180" media="(prefers-color-scheme: dark)" srcset="https://sindresorhus.com/assets/thanks/depot-logo-dark.svg">
					<source width="180" media="(prefers-color-scheme: light)" srcset="https://sindresorhus.com/assets/thanks/depot-logo-light.svg">
					<img width="180" src="https://sindresorhus.com/assets/thanks/depot-logo-light.svg" alt="Depot logo">
				</picture>
			</div>
			<b>Fast remote container builds and GitHub Actions runners.</b>
		</a>
		<br>
		<br>
		<br>
	</p>
	<hr>
	<br>
	<br>
	<br>
	<br>
</div>
<p align="center">
	<a href="awesome.md">What is an awesome list?</a>&nbsp;&nbsp;&nbsp;
	<a href="contributing.md">Contribution guide</a>&nbsp;&nbsp;&nbsp;
	<a href="create-list.md">Creating a list</a>&nbsp;&nbsp;&nbsp;
	<a href="https://twitter.com/awesome__re">Twitter</a>&nbsp;&nbsp;&nbsp;
</p>
<br>
<br>
<p align="center">
	Just type <a href="https://awesome.re"><code>awesome.re</code></a> to go here. Check out my <a href="https://sindresorhus.com/apps">apps</a> and follow me on <a href="https://twitter.com/sindresorhus">Twitter</a>.
</p>
<br>
<br>
<br>

## Contents

- [Platforms](#platforms)
- [Programming Languages](#programming-languages)
- [Front-End Development](#front-end-development)
- [Back-End Development](#back-end-development)
- [Computer Science](#computer-science)
- [Big Data](#big-data)
- [Theory](#theory)
- [Books](#books)
- [Editors](#editors)
- [Gaming](#gaming)
- [Development Environment](#development-environment)
- [Entertainment](#entertainment)
- [Databases](#databases)
- [Media](#media)
- [Learn](#learn)
- [Security](#security)
- [Content Management Systems](#content-management-systems)
- [Hardware](#hardware)
- [Business](#business)
- [Work](#work)
- [Networking](#networking)
- [Decentralized Systems](#decentralized-systems)
- [Health and Social Science](#health-and-social-science)
- [Events](#events)
- [Testing](#testing)
- [Miscellaneous](#miscellaneous)
- [Related](#related)

## Platforms

- [Node.js](https://github.com/sindresorhus/awesome-nodejs#readme) - Async non-blocking event-driven JavaScript runtime built on Chrome's V8 JavaScript engine.
	- [Cross-Platform](https://github.com/bcoe/awesome-cross-platform-nodejs#readme) - Writing cross-platform code on Node.js.
- [Frontend Development](https://github.com/dypsilon/frontend-dev-bookmarks#readme)
- [iOS](https://github.com/vsouza/awesome-ios#readme) - Mobile operating system for Apple phones and tablets.
- [Android](https://github.com/JStumpp/awesome-android#readme) - Mobile operating system developed by Google.
- [IoT & Hybrid Apps](https://github.com/weblancaster/awesome-IoT-hybrid#readme)
- [Electron](https://github.com/sindresorhus/awesome-electron#readme) - Cross-platform native desktop apps using JavaScript/HTML/CSS.
- [Cordova](https://github.com/busterc/awesome-cordova#readme) - JavaScript API for hybrid apps.
- [React Native](https://github.com/jondot/awesome-react-native#readme) - JavaScript framework for writing natively rendering mobile apps for iOS and Android.
- [Xamarin](https://github.com/XamSome/awesome-xamarin#readme) - Mobile app development IDE, testing, and distribution.
- [Linux](https://github.com/inputsh/awesome-linux#readme)
	- [Containers](https://github.com/Friz-zy/awesome-linux-containers#readme)
	- [eBPF](https://github.com/zoidbergwill/awesome-ebpf#readme) - Virtual machine that allows you to write more efficient and powerful tracing and monitoring for Linux systems.
	- [Arch-based Projects](https://github.com/PandaFoss/Awesome-Arch#readme) - Linux distributions and projects based on Arch Linux.
	- [AppImage](https://github.com/AppImage/awesome-appimage#readme) - Package apps in a single file that works on various mainstream Linux distributions.
	- [Omarchy](https://github.com/aorumbayev/awesome-omarchy#readme) - Opinionated Arch Linux and Hyprland desktop environment from the creator of Ruby on Rails.
- macOS - Operating system for Apple's Mac computers.
	- [Screensavers](https://github.com/agarrharr/awesome-macos-screensavers#readme)
	- [Apps](https://github.com/jaywcjlove/awesome-mac#readme)
	- [Open Source Apps](https://github.com/serhii-londar/open-source-mac-os-apps#readme)
- [watchOS](https://github.com/yenchenlin/awesome-watchos#readme) - Operating system for the Apple Watch.
- [JVM](https://github.com/deephacks/awesome-jvm#readme)
- [Salesforce](https://github.com/mailtoharshit/awesome-salesforce#readme)
- [Amazon Web Services](https://github.com/donnemartin/awesome-aws#readme)
- [Windows](https://github.com/0pandadev/awesome-windows#readme) - Consumer desktop operating system.
	- [PowerToys Run Plugins](https://github.com/hlaueriksson/awesome-powertoys-run-plugins#readme) - Community plugins for the Windows quick launcher.
- [IPFS](https://github.com/ipfs/awesome-ipfs#readme) - P2P hypermedia protocol.
- [Fuse](https://github.com/fuse-compound/awesome-fuse#readme) - Mobile development tools.
- [Heroku](https://github.com/ianstormtaylor/awesome-heroku#readme) - Cloud platform as a service.
- [Raspberry Pi](https://github.com/thibmaek/awesome-raspberry-pi#readme) - Credit card-sized computer aimed at teaching kids programming, but capable of a lot more.
- [Qt](https://github.com/JesseTG/awesome-qt#readme) - Cross-platform GUI app framework.
- [WebExtensions](https://github.com/fregante/Awesome-WebExtensions#readme) - Cross-browser extension system.
- [Smart TV](https://github.com/vitalets/awesome-smart-tv#readme) - Create apps for different TV platforms.
- [GNOME](https://github.com/Kazhnuz/awesome-gnome#readme) - Simple and distraction-free desktop environment for Linux.
- [KDE](https://github.com/francoism90/awesome-kde#readme) - A free software community dedicated to creating an open and user-friendly computing experience.
- [.NET](https://github.com/quozd/awesome-dotnet#readme)
	- [Core](https://github.com/thangchung/awesome-dotnet-core#readme)
	- [Roslyn](https://github.com/ironcev/awesome-roslyn#readme) - Open-source compilers and code analysis APIs for C# and VB.NET languages.
- [Amazon Alexa](https://github.com/miguelmota/awesome-amazon-alexa#readme) - Virtual home assistant.
- [DigitalOcean](https://github.com/jonleibowitz/awesome-digitalocean#readme) - Cloud computing platform designed for developers.
- [Flutter](https://github.com/Solido/awesome-flutter#readme) - Google's mobile SDK for building native iOS and Android apps from a single codebase written in Dart.
- [Home Assistant](https://github.com/frenck/awesome-home-assistant#readme) - Open source home automation that puts local control and privacy first.
- [IBM Cloud](https://github.com/victorshinya/awesome-ibmcloud#readme) - Cloud platform for developers and companies.
- [Firebase](https://github.com/jthegedus/awesome-firebase#readme) - App development platform built on Google Cloud.
- [Robot Operating System 2.0](https://github.com/fkromer/awesome-ros2#readme) - Set of software libraries and tools that help you build robot apps.
- [Adafruit IO](https://github.com/adafruit/awesome-adafruitio#readme) - Visualize and store data from any device.
- [Cloudflare](https://github.com/irazasyed/awesome-cloudflare#readme) - CDN, DNS, DDoS protection, and security for your site.
- [Actions on Google](https://github.com/ravirupareliya/awesome-actions-on-google#readme) - Developer platform for Google Assistant.
- [ESP](https://github.com/agucova/awesome-esp#readme) - Low-cost microcontrollers with WiFi and broad IoT applications.
- [Deno](https://github.com/denolib/awesome-deno#readme) - A secure runtime for JavaScript and TypeScript that uses V8 and is built in Rust.
- [DOS](https://github.com/balintkissdev/awesome-dos#readme) - Operating system for x86-based personal computers that was popular during the 1980s and early 1990s.
- [Nix](https://github.com/nix-community/awesome-nix#readme) - Package manager for Linux and other Unix systems that makes package management reliable and reproducible.
- [Integration](https://github.com/stn1slv/awesome-integration#readme) - Linking together different IT systems (components) to functionally cooperate as a whole.
- [Node-RED](https://github.com/naimo84/awesome-nodered#readme) - A programming tool for wiring together hardware devices, APIs, and online services.
- [Low Code](https://github.com/zenitysec/awesome-low-code#readme) - Allowing business professionals to address their needs on their own with little to no coding skills.
- [Capacitor](https://github.com/riderx/awesome-capacitor#readme) - Cross-platform open source runtime for building Web Native apps.
- [ArcGIS Developer](https://github.com/Esri/awesome-arcgis-developer#readme) - Mapping and location analysis platform for developers.
- [Bluetooth Low Energy](https://github.com/dotintent/awesome-ble#readme) - Low-power wireless communication protocol ideal for IoT, wearables, and other battery-powered applications.
- [Uno Platform](https://github.com/MartinZikmund/awesome-uno-platform#readme) - Open-source .NET UI platform for building cross-platform apps.
- [Google Cloud](https://github.com/GoogleCloudPlatform/awesome-google-cloud#readme) - Cloud computing services by Google.
- [Firebase Genkit](https://github.com/xavidop/awesome-firebase-genkit#readme) - An open-source framework for building AI-powered apps and features.
- [Backstage](https://github.com/shano/awesome-backstage#readme) - Open-source platform for building Internal Developer Portals that unify tools and workflows.

## Programming Languages

- [JavaScript](https://github.com/sorrycc/awesome-javascript#readme)
	- [Promises](https://github.com/wbinnssmith/awesome-promises#readme)
	- [Standard Style](https://github.com/standard/awesome-standard#readme) - Style guide and linter.
	- [Must Watch Talks](https://github.com/bolshchikov/js-must-watch#readme)
	- [Tips](https://github.com/loverajoel/jstips#readme)
	- [Network Layer](https://github.com/Kikobeats/awesome-network-js#readme)
	- [Micro npm Packages](https://github.com/parro-it/awesome-micro-npm-packages#readme)
	- [Mad Science npm Packages](https://github.com/feross/awesome-mad-science#readme) - Impossible sounding projects that exist.
	- [Maintenance Modules](https://github.com/maxogden/maintenance-modules#readme) - For npm packages.
	- [npm](https://github.com/sindresorhus/awesome-npm#readme) - Package manager.
	- [AVA](https://github.com/avajs/awesome-ava#readme) - Test runner.
	- [ESLint](https://github.com/dustinspecker/awesome-eslint#readme) - Linter.
	- [Functional Programming](https://github.com/stoeffel/awesome-fp-js#readme)
	- [Observables](https://github.com/sindresorhus/awesome-observables#readme)
	- [npm scripts](https://github.com/RyanZim/awesome-npm-scripts#readme) - Task runner.
	- [30 Seconds of Code](https://github.com/30-seconds/30-seconds-of-code#readme) - Code snippets you can understand in 30 seconds.
	- [Ponyfills](https://github.com/Richienb/awesome-ponyfills#readme) - Like polyfills but without overriding native APIs.
- [Swift](https://github.com/matteocrippa/awesome-swift#readme) - Apple's compiled programming language that is secure, modern, programmer-friendly, and fast.
	- [Education](https://github.com/hsavit1/Awesome-Swift-Education#readme)
	- [Playgrounds](https://github.com/uraimo/Awesome-Swift-Playgrounds#readme)
- [Python](https://github.com/vinta/awesome-python#readme) - General-purpose programming language designed for readability.
	- [Asyncio](https://github.com/timofurrer/awesome-asyncio#readme) - Asynchronous I/O in Python 3.
	- [Scientific Audio](https://github.com/faroit/awesome-python-scientific-audio#readme) - Scientific research in audio/music.
	- [CircuitPython](https://github.com/adafruit/awesome-circuitpython#readme) - A version of Python for microcontrollers.
	- [Data Science](https://github.com/krzjoa/awesome-python-data-science#readme) - Data analysis and machine learning.
	- [Typing](https://github.com/typeddjango/awesome-python-typing#readme) - Optional static typing for Python.
	- [MicroPython](https://github.com/mcauser/awesome-micropython#readme) - A lean and efficient implementation of Python 3 for microcontrollers.
- [Rust](https://github.com/rust-unofficial/awesome-rust#readme)
	- [Pest](https://github.com/pest-parser/awesome-pest#readme) - Parser generator.
- [Haskell](https://github.com/krispo/awesome-haskell#readme)
- [PureScript](https://github.com/passy/awesome-purescript#readme)
- [Go](https://github.com/avelino/awesome-go#readme)
- [Scala](https://github.com/lauris/awesome-scala#readme)
	- [Scala Native](https://github.com/tindzk/awesome-scala-native#readme) - Optimizing ahead-of-time compiler for Scala based on LLVM.
- [Ruby](https://github.com/markets/awesome-ruby#readme)
- [Clojure](https://github.com/razum2um/awesome-clojure#readme)
- [ClojureScript](https://github.com/hantuzun/awesome-clojurescript#readme)
- [Elixir](https://github.com/h4cc/awesome-elixir#readme)
- [Elm](https://github.com/sporto/awesome-elm#readme)
- [Erlang](https://github.com/drobakowski/awesome-erlang#readme)
- [Julia](https://github.com/svaksha/Julia.jl#readme) - High-level dynamic programming language designed to address the needs of high-performance numerical analysis and computational science.
- [Lua](https://github.com/LewisJEllis/awesome-lua#readme)
- [C](https://github.com/inputsh/awesome-c#readme)
- [C/C++](https://github.com/fffaraz/awesome-cpp#readme) - General-purpose language with a bias toward system programming and embedded, resource-constrained software.
- [R](https://github.com/qinwf/awesome-R#readme) - Functional programming language and environment for statistical computing and graphics.
	- [Learning](https://github.com/iamericfletcher/awesome-r-learning-resources#readme)
- [D](https://github.com/dlang-community/awesome-d#readme)
- [Common Lisp](https://github.com/CodyReichert/awesome-cl#readme) - Powerful dynamic multiparadigm language that facilitates iterative and interactive development.
	- [Learning](https://github.com/GustavBertram/awesome-common-lisp-learning#readme)
- [Perl](https://github.com/hachiojipm/awesome-perl#readme)
- [Groovy](https://github.com/kdabir/awesome-groovy#readme)
- [Dart](https://github.com/yissachar/awesome-dart#readme)
- [Java](https://github.com/akullpp/awesome-java#readme) - Popular secure object-oriented language designed for flexibility to "write once, run anywhere".
	- [RxJava](https://github.com/eleventigers/awesome-rxjava#readme)
 	- [J2ME](https://github.com/hstsethi/awesome-j2me#readme) - Java specification designed for old keypad phones and PDAs.
- [Kotlin](https://github.com/KotlinBy/awesome-kotlin#readme)
- [OCaml](https://github.com/ocaml-community/awesome-ocaml#readme)
- [ColdFusion](https://github.com/seancoyne/awesome-coldfusion#readme)
- [Fortran](https://github.com/rabbiabram/awesome-fortran#readme)
- [PHP](https://github.com/ziadoz/awesome-php#readme) - Server-side scripting language.
	- [Composer](https://github.com/jakoch/awesome-composer#readme) - Package manager.
- [Pascal](https://github.com/Fr0sT-Brutal/awesome-pascal#readme)
- [AutoHotkey](https://github.com/ahkscript/awesome-AutoHotkey#readme)
- [AutoIt](https://github.com/J2TeaM/awesome-AutoIt#readme)
- [Crystal](https://github.com/veelenga/awesome-crystal#readme)
- [Frege](https://github.com/sfischer13/awesome-frege#readme) - Haskell for the JVM.
- [CMake](https://github.com/onqtam/awesome-cmake#readme) - Build, test, and package software.
- [ActionScript 3](https://github.com/robinrodricks/awesome-actionscript3#readme) - Object-oriented language targeting Adobe AIR.
- [Eta](https://github.com/sfischer13/awesome-eta#readme) - Functional programming language for the JVM.
- [Idris](https://github.com/joaomilho/awesome-idris#readme) - General purpose pure functional programming language with dependent types influenced by Haskell and ML.
- [Ada/SPARK](https://github.com/ohenley/awesome-ada#readme) - Modern programming language designed for large, long-lived apps where reliability and efficiency are essential.
- [Q#](https://github.com/ebraminio/awesome-qsharp#readme) - Domain-specific programming language used for expressing quantum algorithms.
- [Imba](https://github.com/koolamusic/awesome-imba#readme) - Programming language inspired by Ruby and Python and compiles to performant JavaScript.
- [Vala](https://github.com/desiderantes/awesome-vala#readme) - Programming language designed to take full advantage of the GLib and GNOME ecosystems, while preserving the speed of C code.
- [Coq](https://github.com/coq-community/awesome-coq#readme) - Formal language and environment for programming and specification which facilitates interactive development of machine-checked proofs.
- [V](https://github.com/vlang/awesome-v#readme) - Simple, fast, safe, compiled language for developing maintainable software.
- [Move](https://github.com/MystenLabs/awesome-move#readme) - Domain-specific programming language for writing safe smart contracts.
- [Esolangs](https://github.com/angrykoala/awesome-esolangs#readme) - Programming languages designed for experimentation or as jokes rather than actual use.
- [VBA](https://github.com/sancarn/awesome-vba#readme) - An event-driven version of Visual Basic 6.0 built into most Microsoft Office apps for automation and scripting.
- [F#](https://github.com/fsprojects/awesome-fsharp#readme) - A .NET-based language with focus on functional programming.

<br>
<hr>
<br>
<br>
<a href="https://vshymanskyy.github.io/StandWithUkraine">
	<img src="https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/banner2-direct.svg">
</a>
<br>
<br>
<hr>
<br>

## Front-End Development

- [ES6 Tools](https://github.com/addyosmani/es6-tools#readme)
- [Web Performance Optimization](https://github.com/davidsonfellipe/awesome-wpo#readme)
- [Web Tools](https://github.com/lvwzhen/tools#readme)
- [CSS](https://github.com/awesome-css-group/awesome-css#readme) - Style sheet language that specifies how HTML elements are displayed on screen.
	- [Critical-Path Tools](https://github.com/addyosmani/critical-path-css-tools#readme)
	- [Scalability](https://github.com/davidtheclark/scalable-css-reading-list#readme)
	- [Must-Watch Talks](https://github.com/AllThingsSmitty/must-watch-css#readme)
	- [Protips](https://github.com/AllThingsSmitty/css-protips#readme)
	- [Frameworks](https://github.com/troxler/awesome-css-frameworks#readme)
- [React](https://github.com/enaqx/awesome-react#readme) - JavaScript library for building user interfaces.
	- [Relay](https://github.com/expede/awesome-relay#readme) - Framework for building data-driven React apps.
	- [React Hooks](https://github.com/glauberfc/awesome-react-hooks#readme) - Lets you use state and other React features without writing a class.
- [Web Components](https://github.com/web-padawan/awesome-web-components#readme)
- [Polymer](https://github.com/Granze/awesome-polymer#readme) - JavaScript library to develop Web Components.
- [Angular](https://github.com/PatrickJS/awesome-angular#readme) - App framework.
- [Backbone](https://github.com/sadcitizen/awesome-backbone#readme) - App framework.
- [HTML5](https://github.com/diegocard/awesome-html5#readme) - Markup language used for websites & web apps.
- [SVG](https://github.com/willianjusten/awesome-svg#readme) - XML-based vector image format.
- [Canvas](https://github.com/raphamorim/awesome-canvas#readme)
- [KnockoutJS](https://github.com/dnbard/awesome-knockout#readme) - JavaScript library.
- [Dojo Toolkit](https://github.com/petk/awesome-dojo#readme) - JavaScript toolkit.
- [Inspiration](https://github.com/NoahBuscher/Inspire#readme)
- [Ember](https://github.com/ember-community-russia/awesome-ember#readme) - App framework.
- [Android UI](https://github.com/wasabeef/awesome-android-ui#readme)
- [iOS UI](https://github.com/cjwirth/awesome-ios-ui#readme)
- [Meteor](https://github.com/Urigo/awesome-meteor#readme)
- [BEM](https://github.com/sturobson/BEM-resources#readme)
- [Flexbox](https://github.com/afonsopacifer/awesome-flexbox#readme)
- [Web Typography](https://github.com/deanhume/typography#readme)
- [Web Accessibility](https://github.com/brunopulis/awesome-a11y#readme)
- [Material Design](https://github.com/sachin1092/awesome-material#readme)
- [D3](https://github.com/wbkd/awesome-d3#readme) - Library for producing dynamic, interactive data visualizations.
- [Emails](https://github.com/jonathandion/awesome-emails#readme)
- [jQuery](https://github.com/petk/awesome-jquery#readme) - Easy to use JavaScript library for DOM manipulation.
	- [Tips](https://github.com/AllThingsSmitty/jquery-tips-everyone-should-know#readme)
- [Web Audio](https://github.com/notthetup/awesome-webaudio#readme)
- [Offline-First](https://github.com/pazguille/offline-first#readme)
- [Static Website Services](https://github.com/agarrharr/awesome-static-website-services#readme)
- [Cycle.js](https://github.com/cyclejs-community/awesome-cyclejs#readme) - Functional and reactive JavaScript framework.
- [Text Editing](https://github.com/dok/awesome-text-editing#readme)
- [Motion UI Design](https://github.com/fliptheweb/motion-ui-design#readme)
- [Vue.js](https://github.com/vuejs/awesome-vue#readme) - App framework.
- [Marionette.js](https://github.com/sadcitizen/awesome-marionette#readme) - App framework.
- [Aurelia](https://github.com/aurelia-contrib/awesome-aurelia#readme) - App framework.
- [Charting](https://github.com/zingchart/awesome-charting#readme)
- [Ionic Framework](https://github.com/candelibas/awesome-ionic#readme)
- [Chrome DevTools](https://github.com/ChromeDevTools/awesome-chrome-devtools#readme)
- [PostCSS](https://github.com/jdrgomes/awesome-postcss#readme) - CSS tool.
- [Draft.js](https://github.com/nikgraf/awesome-draft-js#readme) - Rich text editor framework for React.
- [Service Workers](https://github.com/TalAter/awesome-service-workers#readme)
- [Progressive Web Apps](https://github.com/TalAter/awesome-progressive-web-apps#readme)
- [choo](https://github.com/choojs/awesome-choo#readme) - App framework.
- [Redux](https://github.com/brillout/awesome-redux#readme) - State container for JavaScript apps.
- [Browserify](https://github.com/browserify/awesome-browserify#readme) - Module bundler.
- [Sass](https://github.com/Famolus/awesome-sass#readme) - CSS preprocessor.
- [Ant Design](https://github.com/websemantics/awesome-ant-design#readme) - Enterprise-class UI design language.
- [Less](https://github.com/LucasBassetti/awesome-less#readme) - CSS preprocessor.
- [WebGL](https://github.com/sjfricke/awesome-webgl#readme) - JavaScript API for rendering 3D graphics.
- [Preact](https://github.com/preactjs/awesome-preact#readme) - App framework.
- [Progressive Enhancement](https://github.com/jbmoelker/progressive-enhancement-resources#readme)
- [Next.js](https://github.com/unicodeveloper/awesome-nextjs#readme) - Framework for server-rendered React apps.
- [lit](https://github.com/web-padawan/awesome-lit#readme) - Library for building web components with a declarative template system.
- [JAMstack](https://github.com/automata/awesome-jamstack#readme) - Modern web development architecture based on client-side JavaScript, reusable APIs, and prebuilt markup.
- [WordPress-Gatsby](https://github.com/henrikwirth/awesome-wordpress-gatsby#readme) - Web development technology stack with WordPress as a back end and Gatsby as a front end.
- [Mobile Web Development](https://github.com/myshov/awesome-mobile-web-development#readme) - Creating a great mobile web experience.
- [Storybook](https://github.com/lauthieb/awesome-storybook#readme) - Development environment for UI components.
- [Blazor](https://github.com/AdrienTorris/awesome-blazor#readme) - .NET web framework using C#/Razor and HTML that runs in the browser with WebAssembly.
- [PageSpeed Metrics](https://github.com/csabapalfi/awesome-pagespeed-metrics#readme) - Metrics to help understand page speed and user experience.
- [Tailwind CSS](https://github.com/aniftyco/awesome-tailwindcss#readme) - Utility-first CSS framework for rapid UI development.
- [Seed](https://github.com/seed-rs/awesome-seed-rs#readme) - Rust framework for creating web apps running in WebAssembly.
- [Web Performance Budget](https://github.com/pajaydev/awesome-web-performance-budget#readme) - Techniques to ensure certain performance metrics for a website.
- [Web Animation](https://github.com/sergey-pimenov/awesome-web-animation#readme) - Animations in the browser with JavaScript, CSS, SVG, etc.
- [Yew](https://github.com/jetli/awesome-yew#readme) - Rust framework inspired by Elm and React for creating multi-threaded frontend web apps with WebAssembly.
- [Material-UI](https://github.com/nadunindunil/awesome-material-ui#readme) - Material Design React components for faster and easier web development.
- [Building Blocks for Web Apps](https://github.com/componently-com/awesome-building-blocks-for-web-apps#readme) - Standalone features to be integrated into web apps.
- [Svelte](https://github.com/TheComputerM/awesome-svelte#readme) - App framework.
- [Design systems](https://github.com/klaufel/awesome-design-systems#readme) - Collection of reusable components, guided by rules that ensure consistency and speed.
- [Inertia.js](https://github.com/innocenzi/awesome-inertiajs#readme) - Make single-page apps without building an API.
- [MDBootstrap](https://github.com/mdbootstrap/awesome-mdbootstrap#readme) - Templates, layouts, components, and widgets to rapidly build websites.
- [Master CSS](https://github.com/master-co/awesome-master-css#readme) - A virtual CSS language with enhanced syntax.
- [Hydrogen](https://github.com/shopify/awesome-hydrogen#readme) - Edge-first framework for building Shopify storefronts with React.
- [Tiny JS](https://github.com/thoughtspile/awesome-tiny-js#readme) - Frontend libraries that fit into 2 kB with dependencies.
- [Frontend GIS](https://github.com/joewdavies/awesome-frontend-gis#readme) - Geographic Information Systems (GIS) for web browsers.
- [WebGPU](https://github.com/mikbry/awesome-webgpu#readme) - JavaScript API for rendering and compute on GPUs.
- [WebAssembly](https://github.com/idematos/awesome-webassembly#readme) - A portable binary format for running code efficiently across platforms.

## Back-End Development

- [Flask](https://github.com/mjhea0/awesome-flask#readme) - Python framework.
- [Docker](https://github.com/veggiemonk/awesome-docker#readme)
- [Vagrant](https://github.com/iJackUA/awesome-vagrant#readme) - Automation virtual machine environment.
- [Pyramid](https://github.com/uralbash/awesome-pyramid#readme) - Python framework.
- [Play1 Framework](https://github.com/PerfectCarl/awesome-play1#readme)
- [CakePHP](https://github.com/friendsofcake/awesome-cakephp#readme) - PHP framework.
- [Symfony](https://github.com/sitepoint-editors/awesome-symfony#readme) - PHP framework.
	- [Education](https://github.com/pehapkari/awesome-symfony-education#readme)
- [Laravel](https://github.com/chiraggude/awesome-laravel#readme) - PHP framework.
	- [Education](https://github.com/fukuball/Awesome-Laravel-Education#readme)
	- [TALL Stack](https://github.com/livewire/awesome-tall-stack#readme) - Full-stack development solution featuring libraries built by the Laravel community.
- [Rails](https://github.com/gramantin/awesome-rails#readme) - Web app framework for Ruby.
	- [Gems](https://github.com/hothero/awesome-rails-gem#readme) - Packages.
- [Phalcon](https://github.com/phalcon/awesome-phalcon#readme) - PHP framework.
- [Useful `.htaccess` Snippets](https://github.com/phanan/htaccess#readme)
- [nginx](https://github.com/fcambus/nginx-resources#readme) - Web server.
- [Dropwizard](https://github.com/stve/awesome-dropwizard#readme) - Java framework.
- [Kubernetes](https://github.com/ramitsurana/awesome-kubernetes#readme) - Open-source platform that automates Linux container operations.
- [Lumen](https://github.com/unicodeveloper/awesome-lumen#readme) - PHP micro-framework.
- [Serverless Framework](https://github.com/pmuens/awesome-serverless#readme) - Serverless computing and serverless architectures.
- [Apache Wicket](https://github.com/PhantomYdn/awesome-wicket#readme) - Java web app framework.
- [Vert.x](https://github.com/vert-x3/vertx-awesome#readme) - Toolkit for building reactive apps on the JVM.
- [Terraform](https://github.com/shuaibiyy/awesome-terraform#readme) - Tool for building, changing, and versioning infrastructure.
- [Vapor](https://github.com/vapor-community/awesome-vapor#readme) - Server-side development in Swift.
- [Dash](https://github.com/ucg8j/awesome-dash#readme) - Python web app framework.
- [FastAPI](https://github.com/mjhea0/awesome-fastapi#readme) - Python web app framework.
- [CDK](https://github.com/kolomied/awesome-cdk#readme) - Open-source software development framework for defining cloud infrastructure in code.
- [IAM](https://github.com/kdeldycke/awesome-iam#readme) - User accounts, authentication and authorization.
- [Slim](https://github.com/nekofar/awesome-slim#readme) - PHP framework.
- [Fiber](https://github.com/gofiber/awesome-fiber#readme) - Web framework built on top of Fasthttp, the fastest HTTP engine for Go.
- [Kustomize](https://github.com/DevOpsHiveHQ/awesome-kustomize#readme) - Kubernetes native declarative configuration management tool.
- [OpenTofu](https://github.com/virtualroot/awesome-opentofu#readme) - Open-source infrastructure as code tool.
- [Reflex](https://github.com/reflex-dev/awesome-reflex#readme) - Python web framework for building both your frontend and backend with no JavaScript.

## Computer Science

- [University Courses](https://github.com/prakhar1989/awesome-courses#readme)
- [Data Science](https://github.com/academic/awesome-datascience#readme)
	- [Tutorials](https://github.com/siboehm/awesome-learn-datascience#readme)
- [Machine Learning](https://github.com/josephmisiti/awesome-machine-learning#readme)
	- [Tutorials](https://github.com/ujjwalkarn/Machine-Learning-Tutorials#readme)
	- [ML with Ruby](https://github.com/arbox/machine-learning-with-ruby#readme) - Learning, implementing, and applying Machine Learning using Ruby.
	- [Core ML Models](https://github.com/likedan/Awesome-CoreML-Models#readme) - Models for Apple's machine learning framework.
	- [H2O](https://github.com/h2oai/awesome-h2o#readme) - Open source distributed machine learning platform written in Java with APIs in R, Python, and Scala.
	- [Software Engineering for Machine Learning](https://github.com/SE-ML/awesome-seml#readme) - From experiment to production-level machine learning.
	- [AI in Finance](https://github.com/georgezouq/awesome-ai-in-finance#readme) - Solving problems in finance with machine learning.
	- [JAX](https://github.com/n2cholas/awesome-jax#readme) - Automatic differentiation and XLA compilation brought together for high-performance machine learning research.
	- [XAI](https://github.com/altamiracorp/awesome-xai#readme) - Providing insight, explanations, and interpretability to machine learning methods.
- [Speech and Natural Language Processing](https://github.com/edobashira/speech-language-processing#readme)
	- [Spanish](https://github.com/dav009/awesome-spanish-nlp#readme)
	- [NLP with Ruby](https://github.com/arbox/nlp-with-ruby#readme)
	- [Question Answering](https://github.com/seriousran/awesome-qa#readme) - The science of asking and answering in natural language with a machine.
	- [Natural Language Generation](https://github.com/accelerated-text/awesome-nlg#readme) - Generation of text used in data-to-text, conversational agents, and narrative generation applications.
- [Linguistics](https://github.com/theimpossibleastronaut/awesome-linguistics#readme)
- [Cryptography](https://github.com/sobolevn/awesome-cryptography#readme)
	- [Papers](https://github.com/pFarb/awesome-crypto-papers#readme) - Theory basics for using cryptography by non-cryptographers.
- [Computer Vision](https://github.com/jbhuang0604/awesome-computer-vision#readme)
- [Deep Learning](https://github.com/ChristosChristofidis/awesome-deep-learning#readme) - Neural networks.
	- [TensorFlow](https://github.com/jtoy/awesome-tensorflow#readme) - Library for machine intelligence.
	- [TensorFlow.js](https://github.com/aaronhma/awesome-tensorflow-js#readme) - WebGL-accelerated machine learning JavaScript library for training and deploying models.
	- [TensorFlow Lite](https://github.com/margaretmz/awesome-tensorflow-lite#readme) - Framework that optimizes TensorFlow models for on-device machine learning.
	- [Papers](https://github.com/terryum/awesome-deep-learning-papers#readme) - The most cited deep learning papers.
	- [Education](https://github.com/guillaume-chevalier/awesome-deep-learning-resources#readme)
- [Deep Vision](https://github.com/kjw0612/awesome-deep-vision#readme)
- [Open Source Society University](https://github.com/ossu/computer-science#readme)
- [Functional Programming](https://github.com/lucasviola/awesome-functional-programming#readme)
- [Empirical Software Engineering](https://github.com/dspinellis/awesome-msr#readme) - Evidence-based research on software systems.
- [Static Analysis & Code Quality](https://github.com/analysis-tools-dev/static-analysis#readme)
- [Information Retrieval](https://github.com/harpribot/awesome-information-retrieval#readme) - Learn to develop your own search engine.
- [Quantum Computing](https://github.com/desireevl/awesome-quantum-computing#readme) - Computing that utilizes quantum mechanics and qubits on quantum computers.
- [Theoretical Computer Science](https://github.com/mostafatouny/awesome-theoretical-computer-science#readme) - The interplay of computer science and pure mathematics, distinguished by its emphasis on mathematical rigour and technique.
- [Conversational AI](https://github.com/jyguyomarch/awesome-conversational-ai#readme) - Build awesome chatbots and digital assistants.
- [Generative AI](https://github.com/steven2358/awesome-generative-ai#readme) - Automatically generates a wide range of unique content in text, image, and audio format.
- [Position-Based Quantum Cryptography](https://github.com/Renaller/awesome-position-based-quantum-cryptography#readme) - Theory on quantum cryptography that utilizes special relativistic constraints to achieve quantum-security under certain conditions.

## Big Data

- [Big Data](https://github.com/0xnr/awesome-bigdata#readme)
- [Public Datasets](https://github.com/awesomedata/awesome-public-datasets#readme)
- [Hadoop](https://github.com/youngwookim/awesome-hadoop#readme) - Framework for distributed storage and processing of very large data sets.
- [Data Engineering](https://github.com/igorbarinov/awesome-data-engineering#readme)
- [Streaming](https://github.com/manuzhang/awesome-streaming#readme)
- [Apache Spark](https://github.com/awesome-spark/awesome-spark#readme) - Unified engine for large-scale data processing.
- [Qlik](https://github.com/ambster-public/awesome-qlik#readme) - Business intelligence platform for data visualization, analytics, and reporting apps.
- [Splunk](https://github.com/sduff/awesome-splunk#readme) - Platform for searching, monitoring, and analyzing structured and unstructured machine-generated big data in real time.
- [Network Analysis](https://github.com/briatte/awesome-network-analysis#readme)

## Theory

- [Papers We Love](https://github.com/papers-we-love/papers-we-love#readme)
- [Talks](https://github.com/JanVanRyswyck/awesome-talks#readme)
- [Algorithms](https://github.com/tayllan/awesome-algorithms#readme)
	- [Education](https://github.com/gaerae/awesome-algorithms-education#readme) - Learning and practicing.
- [Algorithm Visualizations](https://github.com/enjalot/algovis#readme)
- [Artificial Intelligence](https://github.com/owainlewis/awesome-artificial-intelligence#readme)
- [Search Engine Optimization](https://github.com/marcobiedermann/search-engine-optimization#readme)
- [Competitive Programming](https://github.com/lnishan/awesome-competitive-programming#readme)
- [Math](https://github.com/rossant/awesome-math#readme)
- [Recursion Schemes](https://github.com/passy/awesome-recursion-schemes#readme) - Traversing nested data structures.
- [Audit Algorithms](https://github.com/erwanlemerrer/awesome-audit-algorithms#readme) - Algorithmic audits of algorithms.
- [AGI & CoCoSci](https://github.com/YuzheSHI/awesome-agi-cocosci#readme) - The reciprocation of Artificial General Intelligence (AGI) and Computational Cognitive Sciences (CoCoSci).
- [Complex Systems](https://github.com/sellisd/awesome-complexity#readme) - The scientific field studying systems with multiple interacting parts and emergent properties.
- [VLM Architectures](https://github.com/gokayfem/awesome-vlm-architectures#readme) - Vision Language Model architectures.

## Books

- [Free Programming Books](https://github.com/EbookFoundation/free-programming-books#readme)
- [Go Books](https://github.com/dariubs/GoBooks#readme)
- [R Books](https://github.com/RomanTsegelskyi/rbooks#readme)
- [Mind Expanding Books](https://github.com/hackerkid/Mind-Expanding-Books#readme)
- [Book Authoring](https://github.com/TalAter/awesome-book-authoring#readme)
- [Elixir Books](https://github.com/sger/ElixirBooks#readme)

## Editors

- [Sublime Text](https://github.com/dreikanter/sublime-bookmarks#readme)
- [Vim](https://github.com/mhinz/vim-galore#readme)
- [Neovim](https://github.com/rockerBOO/awesome-neovim#readme) - Vim-fork focused on extensibility and usability.
- [Emacs](https://github.com/emacs-tw/awesome-emacs#readme)
- [Atom](https://github.com/mehcode/awesome-atom#readme) - Open-source and hackable text editor.
- [Visual Studio Code](https://github.com/viatsko/awesome-vscode#readme) - Cross-platform open-source text editor.

## Gaming

- [Game Development](https://github.com/ellisonleao/magictools#readme)
- [Game Talks](https://github.com/hzoo/awesome-gametalks#readme)
- [Godot](https://github.com/godotengine/awesome-godot#readme) - Game engine.
- [Open Source Games](https://github.com/michelpereira/awesome-open-source-games#readme)
- [Unity](https://github.com/RyanNielson/awesome-unity#readme) - Game engine.
- [Chess](https://github.com/hkirat/awesome-chess#readme)
- [LÖVE](https://github.com/love2d-community/awesome-love2d#readme) - Game engine.
- [PICO-8](https://github.com/pico-8/awesome-PICO-8#readme) - Fantasy console.
- [Game Boy Development](https://github.com/gbdev/awesome-gbdev#readme)
- [Construct 2](https://github.com/ConstructCommunity/awesome-construct#readme) - Game engine.
- [Gideros](https://github.com/stetso/awesome-gideros#readme) - Game engine.
- [Minecraft](https://github.com/bs-community/awesome-minecraft#readme) - Sandbox video game.
- [ComputerCraft](https://github.com/tomodachi94/awesome-computercraft#readme) - Minecraft mod that adds programmable computers.
- [Game Datasets](https://github.com/leomaurodesenv/game-datasets#readme) - Materials and datasets for Artificial Intelligence in games.
- [Haxe Game Development](https://github.com/Dvergar/awesome-haxe-gamedev#readme) - A high-level strongly typed programming language used to produce cross-platform native code.
- [libGDX](https://github.com/rafaskb/awesome-libgdx#readme) - Java game framework.
- [PlayCanvas](https://github.com/playcanvas/awesome-playcanvas#readme) - Game engine.
- [Game Remakes](https://github.com/radek-sprta/awesome-game-remakes#readme) - Actively maintained open-source game remakes.
- [Flame](https://github.com/flame-engine/awesome-flame#readme) - Game engine for Flutter.
- [Discord Communities](https://github.com/mhxion/awesome-discord-communities#readme) - Chat with friends and communities.
- [CHIP-8](https://github.com/tobiasvl/awesome-chip-8#readme) - Virtual computer game machine from the 70s.
- [Games of Coding](https://github.com/michelpereira/awesome-games-of-coding#readme) - Learn a programming language by making games.
- [Esports](https://github.com/strift/awesome-esports#readme) - Video games played as a sport.
- [Learn Gamedev](https://github.com/notpresident35/awesome-learn-gamedev#readme) - The craft of video game creation.
- [Game Engine Development](https://github.com/stevinz/awesome-game-engine-dev#readme) - Building software to speed up game creation.
- [GameMaker](https://github.com/bytecauldron/awesome-gamemaker#readme) - Game engine.
- [Game Production](https://github.com/vhladiienko/awesome-game-production#readme) - Leading the process of designing, developing, testing and distributing a video game from concept to release.
- [Babylon.js](https://github.com/Symbitic/awesome-babylonjs#readme) - Game engine for cross-platform web and native game development.
- [Roblox](https://github.com/awesome-roblox/awesome-roblox#readme) - Immersive platform for hosting millions of diverse experiences.

## Development Environment

- [Quick Look Plugins](https://github.com/sindresorhus/quick-look-plugins#readme) - For macOS.
- [Dev Env](https://github.com/jondot/awesome-devenv#readme)
- [Dotfiles](https://github.com/webpro/awesome-dotfiles#readme)
- [Shell](https://github.com/alebcay/awesome-shell#readme)
- [Fish](https://github.com/jorgebucaran/awsm.fish#readme) - User-friendly shell.
- [Command-Line Apps](https://github.com/agarrharr/awesome-cli-apps#readme)
- [ZSH Plugins](https://github.com/unixorn/awesome-zsh-plugins#readme)
- [GitHub](https://github.com/phillipadsmith/awesome-github#readme) - Hosting service for Git repositories.
	- [Browser Extensions](https://github.com/stefanbuck/awesome-browser-extensions-for-github#readme)
	- [Cheat Sheet](https://github.com/tiimgreen/github-cheat-sheet#readme)
	- [Pinned Gists](https://github.com/matchai/awesome-pinned-gists#readme) - Dynamic pinned gists for your GitHub profile.
- [Git Cheat Sheet & Git Flow](https://github.com/arslanbilal/git-cheat-sheet#readme)
- [Git Tips](https://github.com/git-tips/tips#readme)
- [Git Add-ons](https://github.com/stevemao/awesome-git-addons#readme) - Enhance the `git` CLI.
- [Git Hooks](https://github.com/compscilauren/awesome-git-hooks#readme) - Scripts for automating tasks during `git` workflows.
- [SSH](https://github.com/moul/awesome-ssh#readme)
- [FOSS for Developers](https://github.com/tvvocold/FOSS-for-Dev#readme)
- [Hyper](https://github.com/bnb/awesome-hyper#readme) - Cross-platform terminal app built on web technologies.
- [PowerShell](https://github.com/janikvonrotz/awesome-powershell#readme) - Cross-platform object-oriented shell.
- [Alfred Workflows](https://github.com/alfred-workflows/awesome-alfred-workflows#readme) - Productivity app for macOS.
- [Terminals Are Sexy](https://github.com/k4m4/terminals-are-sexy#readme)
- [GitHub Actions](https://github.com/sdras/awesome-actions#readme) - Create tasks to automate your workflow and share them with others on GitHub.
- [WezTerm](https://github.com/michaelbrusegard/awesome-wezterm#readme) - Powerful cross-platform terminal emulator.

## Entertainment

- [Science Fiction](https://github.com/sindresorhus/awesome-scifi#readme) - Scifi.
- [Fantasy](https://github.com/RichardLitt/awesome-fantasy#readme)
- [Podcasts](https://github.com/ayr-ton/awesome-geek-podcasts#readme)
- [Email Newsletters](https://github.com/zudochkin/awesome-newsletters#readme)
- [IT Quotes](https://github.com/victorlaerte/awesome-it-quotes#readme)

## Databases

- [Database](https://github.com/numetriclabz/awesome-db#readme)
- [MySQL](https://github.com/shlomi-noach/awesome-mysql#readme)
- [SQLAlchemy](https://github.com/dahlia/awesome-sqlalchemy#readme)
- [InfluxDB](https://github.com/mark-rushakoff/awesome-influxdb#readme)
- [Neo4j](https://github.com/neueda/awesome-neo4j#readme)
- [MongoDB](https://github.com/ramnes/awesome-mongodb#readme) - NoSQL database.
- [RethinkDB](https://github.com/d3viant0ne/awesome-rethinkdb#readme)
- [TinkerPop](https://github.com/mohataher/awesome-tinkerpop#readme) - Graph computing framework.
- [PostgreSQL](https://github.com/dhamaniasad/awesome-postgres#readme) - Object-relational database.
- [CouchDB](https://github.com/quangv/awesome-couchdb#readme) - Document-oriented NoSQL database.
- [HBase](https://github.com/rayokota/awesome-hbase#readme) - Distributed, scalable, big data store.
- [NoSQL Guides](https://github.com/erictleung/awesome-nosql-guides#readme) - Help on using non-relational, distributed, open-source, and horizontally scalable databases.
- [Database Tools](https://github.com/mgramin/awesome-db-tools#readme) - Everything that makes working with databases easier.
- [TypeDB](https://github.com/vaticle/typedb-awesome#readme) - Logical database to organize large and complex networks of data as one body of knowledge.
- [Cassandra](https://github.com/Anant/awesome-cassandra#readme) - Open-source, distributed, wide column store, NoSQL database management system.
- [TDengine](https://github.com/taosdata/awesome-tdengine#readme) - An open-source time-series database with high-performance, scalability, and SQL support.
- [Supabase](https://github.com/lyqht/awesome-supabase#readme) - An open-source alternative to Firebase.
- [PocketBase](https://github.com/benallfree/awesome-pocketbase#readme) - An open-source, Go-based backend in one file.
- [Neon](https://github.com/tyaga001/awesome-neon#readme) - An open-source alternative to AWS Aurora.

## Media

- [Fonts](https://github.com/brabadu/awesome-fonts#readme)
- [Codeface](https://github.com/chrissimpkins/codeface#readme) - Text editor fonts.
- [Stock Resources](https://github.com/neutraltone/awesome-stock-resources#readme)
- [GIF](https://github.com/davisonio/awesome-gif#readme) - Image format known for animated images.
- [Music](https://github.com/ciconia/awesome-music#readme)
- [Open Source Documents](https://github.com/44bits/awesome-opensource-documents#readme)
- [Audio Visualization](https://github.com/willianjusten/awesome-audio-visualization#readme)
- [Broadcasting](https://github.com/ebu/awesome-broadcasting#readme)
- [Pixel Art](https://github.com/Siilwyn/awesome-pixel-art#readme) - Pixel-level digital art.
- [FFmpeg](https://github.com/transitive-bullshit/awesome-ffmpeg#readme) - Cross-platform solution to record, convert and stream audio and video.
- [Icons](https://github.com/notlmn/awesome-icons#readme) - Downloadable SVG/PNG/font icon projects.
- [Audiovisual](https://github.com/stingalleman/awesome-audiovisual#readme) - Lighting, audio and video in professional environments.
- [VLC](https://github.com/mfkl/awesome-vlc#readme) - Cross-platform media player software and streaming server.
- [Audio Over IP](https://github.com/Mo-way/awesome-aoip#readme) - Reliably transmit uncompressed, low-latency audio over an IP (layer 3) network.

## Learn

- [CLI Workshoppers](https://github.com/therebelrobot/awesome-workshopper#readme) - Interactive tutorials.
- [Learn to Program](https://github.com/karlhorky/learn-to-program#readme)
- [Speaking](https://github.com/matteofigus/awesome-speaking#readme)
- [Tech Videos](https://github.com/lucasviola/awesome-tech-videos#readme)
- [Dive into Machine Learning](https://github.com/hangtwenty/dive-into-machine-learning#readme)
- [Computer History](https://github.com/watson/awesome-computer-history#readme)
- [Programming for Kids](https://github.com/HollyAdele/awesome-programming-for-kids#readme)
- [STEAM](https://github.com/RahulBirCodes/awesome-steam#readme) - Supplements for specific science, technology, engineering, arts, and math (STEAM) courses across all grade levels.
- [Educational Games](https://github.com/yrgo/awesome-educational-games#readme) - Learn while playing.
- [JavaScript Learning](https://github.com/micromata/awesome-javascript-learning#readme)
- [CSS Learning](https://github.com/micromata/awesome-css-learning#readme) - Mainly about CSS – the language and the modules.
- [Product Management](https://github.com/dend/awesome-product-management#readme) - Learn how to be a better product manager.
- [Roadmaps](https://github.com/liuchong/awesome-roadmaps#readme) - Gives you a clear route to improve your knowledge and skills.
- [YouTubers](https://github.com/JoseDeFreitas/awesome-youtubers#readme) - Watch video tutorials from YouTubers that teach you about technology.
- [Hackathon](https://github.com/dribdat/awesome-hackathon#readme) - Running fun and productive hackathons.
- [Certificates](https://github.com/PanXProject/awesome-certificates#readme) - Free computer science certifications to showcase your knowledge.

## Security

- [Application Security](https://github.com/paragonie/awesome-appsec#readme)
- [Security](https://github.com/sbilly/awesome-security#readme)
- [CTF](https://github.com/apsdehal/awesome-ctf#readme) - Capture The Flag.
- [Cyber Security University](https://github.com/brootware/awesome-cyber-security-university#readme) - Free educational resources that focus on learning by doing.
- [Malware Analysis](https://github.com/rshipp/awesome-malware-analysis#readme)
- [Android Security](https://github.com/ashishb/android-security-awesome#readme)
- [Hacking](https://github.com/carpedm20/awesome-hacking#readme)
- [Hacking Spots](https://github.com/daviddias/awesome-hacking-locations#readme)
- [Honeypots](https://github.com/paralax/awesome-honeypots#readme) - Deception trap, designed to entice an attacker into attempting to compromise the information systems in an organization.
- [Incident Response](https://github.com/meirwah/awesome-incident-response#readme)
- [Vehicle Security and Car Hacking](https://github.com/jaredthecoder/awesome-vehicle-security#readme)
- [Web Security](https://github.com/qazbnm456/awesome-web-security#readme) - Security of web apps & services.
- [Lockpicking](https://github.com/fabacab/awesome-lockpicking#readme) - The art of unlocking a lock by manipulating its components without the key.
- [Cybersecurity Blue Team](https://github.com/fabacab/awesome-cybersecurity-blueteam#readme) - Groups of individuals who identify security flaws in information technology systems.
- [Fuzzing](https://github.com/cpuu/awesome-fuzzing#readme) - Automated software testing technique that involves feeding pseudo-randomly generated input data.
- [Embedded and IoT Security](https://github.com/fkie-cad/awesome-embedded-and-iot-security#readme)
- [GDPR](https://github.com/bakke92/awesome-gdpr#readme) - Regulation on data protection and privacy for all individuals within EU.
- [DevSecOps](https://github.com/TaptuIT/awesome-devsecops#readme) - Integration of security practices into [DevOps](https://en.wikipedia.org/wiki/DevOps).
- [Executable Packing](https://github.com/dhondta/awesome-executable-packing#readme) - Packing and unpacking executable formats.
- [Malware Persistence](https://github.com/Karneades/awesome-malware-persistence#readme) - Techniques that adversaries use to keep access to systems across restarts.
- [EVM Security](https://github.com/kareniel/awesome-evm-security#readme) - Understanding the Ethereum Virtual Machine security ecosystem.
- [Password Cracking](https://github.com/n0kovo/awesome-password-cracking#readme) - The process of recovering passwords from data that has been stored in or transmitted by a system in scrambled form.
- [Security Card Games](https://github.com/Karneades/awesome-security-card-games#readme) - Train your skills and discuss various security topics.
- [Suricata](https://github.com/satta/awesome-suricata#readme) - Intrusion detection/prevention system and network security monitoring engine.
- [Prompt Injection](https://github.com/FonduAI/awesome-prompt-injection#readme) - A type of vulnerability that specifically targets machine learning models.
- [Detection Engineering](https://github.com/infosecB/awesome-detection-engineering#readme) - Design, build, and operate detective cybersecurity controls.
- [Annual Security Reports](https://github.com/jacobdjwilson/awesome-annual-security-reports#readme) - Exploring cybersecurity trends, insights, and challenges.
- [CI/CD Attacks](https://github.com/TupleType/awesome-cicd-attacks#readme) - Offensive research of systems and processes related to developing and deploying code.
- [OpenID Connect](https://github.com/cerberauth/awesome-openid-connect#readme) - Identity standard and authentication protocol built on OAuth 2.0 for user identity assertion.

## Content Management Systems

- [Umbraco](https://github.com/umbraco-community/awesome-umbraco#readme)
- [Refinery CMS](https://github.com/refinerycms-contrib/awesome-refinerycms#readme) - Ruby on Rails CMS.
- [Wagtail](https://github.com/springload/awesome-wagtail#readme) - Django CMS focused on flexibility and user experience.
- [Textpattern](https://github.com/drmonkeyninja/awesome-textpattern#readme) - Lightweight PHP-based CMS.
- [Drupal](https://github.com/nirgn975/awesome-drupal#readme) - Extensible PHP-based CMS.
- [Craft CMS](https://github.com/craftcms/awesome#readme) - Content-first CMS.
- [Sitecore](https://github.com/MartinMiles/Awesome-Sitecore#readme) - .NET digital marketing platform that combines CMS with tools for managing multiple websites.
- [Silverstripe CMS](https://github.com/wernerkrauss/awesome-silverstripe-cms#readme) - PHP MVC framework that serves as a classic or headless CMS.
- [Directus](https://github.com/directus-community/awesome-directus#readme) - A real-time API and app dashboard for managing SQL database content.
- [Plone](https://github.com/collective/awesome-plone#readme) - Open source Python CMS.
- [Payload](https://github.com/DanailMinchev/awesome-payload#readme) - Next.js native and open source headless CMS.

## Hardware

- [Robotics](https://github.com/Kiloreux/awesome-robotics#readme)
- [Internet of Things](https://github.com/HQarroum/awesome-iot#readme)
- [Electronics](https://github.com/kitspace/awesome-electronics#readme) - For electronic engineers and hobbyists.
- [Bluetooth Beacons](https://github.com/rabschi/awesome-beacon#readme)
- [Electric Guitar Specifications](https://github.com/gitfrage/guitarspecs#readme) - Checklist for building your own electric guitar.
- [Plotters](https://github.com/beardicus/awesome-plotters#readme) - Computer-controlled drawing machines and other visual art robots.
- [Robotic Tooling](https://github.com/protontypes/awesome-robotic-tooling#readme) - Free and open tools for professional robotic development.
- [LIDAR](https://github.com/szenergy/awesome-lidar#readme) - Sensor for measuring distances by illuminating the target with laser light.
- [Open Hardware](https://github.com/delftopenhardware/awesome-open-hardware#readme) - Open-source hardware projects.
- [ADS-B](https://github.com/rickstaa/awesome-adsb#readme) - Technology broadcasting aircraft's identity, position, and data periodically.
- [Flying FPV](https://github.com/Matthias84/awesome-flying-fpv#readme) - Open hardware and software related to drones / UAVs.

## Business

- [Open Companies](https://github.com/opencompany/awesome-open-company#readme)
- [Places to Post Your Startup](https://github.com/mmccaff/PlacesToPostYourStartup#readme)
- [OKR Methodology](https://github.com/domenicosolazzo/awesome-okr#readme) - Goal setting & communication best practices.
- [Indie](https://github.com/mezod/awesome-indie#readme) - Independent developer businesses.
- [Tools of the Trade](https://github.com/cjbarber/ToolsOfTheTrade#readme) - Tools used by companies on Hacker News.
- [Clean Tech](https://github.com/nglgzz/awesome-clean-tech#readme) - Fighting climate change with technology.
- [Wardley Maps](https://github.com/wardley-maps-community/awesome-wardley-maps#readme) - Provides high situational awareness to help improve strategic planning and decision making.
- [Social Enterprise](https://github.com/RayBB/awesome-social-enterprise#readme) - Building an organization primarily focused on social impact that is at least partially self-funded.
- [Engineering Team Management](https://github.com/kdeldycke/awesome-engineering-team-management#readme) - How to transition from software development to engineering management.
- [Developer-First Products](https://github.com/agamm/awesome-developer-first#readme) - Products that target developers as the user.
- [Billing](https://github.com/kdeldycke/awesome-billing#readme) - Payments, invoicing, pricing, accounting, marketplace, fraud, and business intelligence.
- [Engineering Strategy](https://github.com/aleixmorgadas/awesome-engineering-strategy#readme) - How to design and execute engineering strategies for tech leadership.

## Work

- [Slack](https://github.com/matiassingers/awesome-slack#readme) - Team collaboration.
	- [Communities](https://github.com/filipelinhares/awesome-slack#readme)
- [Remote Jobs](https://github.com/lukasz-madon/awesome-remote-job#readme)
- [Productivity](https://github.com/jyguyomarch/awesome-productivity#readme)
- [Niche Job Boards](https://github.com/tramcar/awesome-job-boards#readme)
- [Programming Interviews](https://github.com/DopplerHQ/awesome-interview-questions#readme)
- [Code Review](https://github.com/joho/awesome-code-review#readme) - Reviewing code.
- [Creative Technology](https://github.com/j0hnm4r5/awesome-creative-technology#readme) - Businesses & groups that specialize in combining computing, design, art, and user experience.
- [Internships](https://github.com/lodthe/awesome-internships#readme) - CV writing guides and companies that hire interns.

## Networking

- [Software-Defined Networking](https://github.com/sdnds-tw/awesome-sdn#readme)
- [PCAPTools](https://github.com/caesar0301/awesome-pcaptools#readme)
- [Real-Time Communications](https://github.com/rtckit/awesome-rtc#readme) - Network protocols for near simultaneous exchange of media and data.
- [SNMP](https://github.com/eozer/awesome-snmp#readme) - A protocol for collecting, modifying, and organizing information about managed devices on IP networks.
- [Scapy](https://github.com/secdev/awesome-scapy#readme) - Python-based interactive packet manipulation.
- [Cilium](https://github.com/seifrajhi/awesome-cilium#readme) - Provides networking and security capabilities for containerized apps, microservices, and virtual machines.

## Decentralized Systems

- [Bitcoin](https://github.com/igorbarinov/awesome-bitcoin#readme) - Bitcoin services and tools for software developers.
- [Ripple](https://github.com/vhpoet/awesome-ripple#readme) - Open source distributed settlement network.
- [Non-Financial Blockchain](https://github.com/machinomy/awesome-non-financial-blockchain#readme) - Non-financial blockchain applications.
- [Mastodon](https://github.com/hyperupcall/awesome-mastodon#readme) - Open source decentralized microblogging network.
- [Ethereum](https://github.com/ttumiel/Awesome-Ethereum#readme) - Distributed computing platform for smart contract development.
- [Blockchain AI](https://github.com/steven2358/awesome-blockchain-ai#readme) - Blockchain projects for artificial intelligence and machine learning.
- [EOSIO](https://github.com/DanailMinchev/awesome-eosio#readme) - A decentralized operating system supporting industrial-scale apps.
- [Corda](https://github.com/chainstack/awesome-corda#readme) - Open source blockchain platform designed for business.
- [Waves](https://github.com/msmolyakov/awesome-waves#readme) - Open source blockchain platform and development toolset for Web 3.0 apps and decentralized solutions.
- [Substrate](https://github.com/substrate-developer-hub/awesome-substrate#readme) - Framework for writing scalable, upgradeable blockchains in Rust.
- [Golem](https://github.com/golemfactory/awesome-golem#readme) - Open source peer-to-peer marketplace for computing resources.
- [Stacks](https://github.com/friedger/awesome-stacks-chain#readme) - A smart contract platform secured by Bitcoin.
- [Algorand](https://github.com/aorumbayev/awesome-algorand#readme) - An open-source, proof of stake blockchain and smart contract computing platform.
- [ZeroNet](https://github.com/zolagonano/awesome-zeronet#readme) - A decentralized web-like network of peer-to-peer users.
- [Cosmos SDK](https://github.com/cosmos/awesome-cosmos#readme) - Modular framework for building app-specific blockchains in Go.
- [Tor](https://github.com/polycarbohydrate/awesome-tor#readme) - A free overlay network for enabling anonymous communication.
- [ATProto](https://github.com/atblueprints/awesome-atproto#readme) - Open, decentralized network for building social apps.

## Health and Social Science

- [Biomedical Information Extraction](https://github.com/caufieldjh/awesome-bioie#readme) - How to extract information from unstructured biomedical data and text.
- [Computational Neuroscience](https://github.com/eselkin/awesome-computational-neuroscience#readme) - A multidisciplinary science which uses computational approaches to study the nervous system.
- [Diversity](https://github.com/folkswhocode/awesome-diversity#readme) - Creating a more inclusive and diverse tech community.
- [Digital History](https://github.com/maehr/awesome-digital-history#readme) - Computer-aided scientific investigation of history.
- [Empathy in Engineering](https://github.com/KimberlyMunoz/empathy-in-engineering#readme) - Building and promoting more compassionate engineering cultures.
- [Healthcare](https://github.com/kakoni/awesome-healthcare#readme) - Open source healthcare software for facilities, providers, developers, policy experts, and researchers.
- [Humane Technology](https://github.com/humanetech-community/awesome-humane-tech#readme) - Open source projects that help improve society.
- [Mental Health](https://github.com/dreamingechoes/awesome-mental-health#readme) - Mental health awareness and self-care in the software industry.
- [Neuroscience](https://github.com/analyticalmonk/awesome-neuroscience#readme) - Study of the nervous system and brain.
- [Digital Humanities](https://github.com/dh-tech/awesome-digital-humanities#readme) - Software for humanities scholars using quantitative or computational methods.
- [Lucid Dreams](https://github.com/IAmCoder/awesome-lucid-dreams#readme) - A dream where one becomes aware they are dreaming.
- [Neuroimaging](https://github.com/NPACore/awesome-neuroimaging#readme) - Software for analyzing brain data from living subjects.
- [Transgender](https://github.com/cvyl/awesome-transgender#readme) - Someone whose gender identity differs from their assigned birth sex.

## Events

- [Creative Tech Events](https://github.com/danvoyce/awesome-creative-tech-events#readme) - Events around the globe for creative coding, tech, design, music, arts and cool stuff.
- [Events in Italy](https://github.com/ildoc/awesome-italy-events#readme) - Tech-related events in Italy.
- [Events in the Netherlands](https://github.com/awkward/awesome-netherlands-events#readme) - Tech-related events in the Netherlands.

## Testing

- [Testing](https://github.com/TheJambo/awesome-testing#readme) - Software testing.
- [Visual Regression Testing](https://github.com/mojoaxel/awesome-regression-testing#readme) - Ensures changes did not break the functionality or style.
- [Selenium](https://github.com/christian-bromann/awesome-selenium#readme) - Open-source browser automation framework and ecosystem.
- [Appium](https://github.com/SrinivasanTarget/awesome-appium#readme) - Test automation tool for apps.
- [TAP](https://github.com/sindresorhus/awesome-tap#readme) - Test Anything Protocol.
- [JMeter](https://github.com/aliesbelik/awesome-jmeter#readme) - Load testing and performance measurement tool.
- [k6](https://github.com/grafana/awesome-k6#readme) - Open-source, developer-centric performance monitoring and load testing solution.
- [Playwright](https://github.com/mxschmitt/awesome-playwright#readme) - Node.js library to automate Chromium, Firefox and WebKit with a single API.
- [Quality Assurance Roadmap](https://github.com/fityanos/awesome-quality-assurance-roadmap#readme) - How to start & build a career in software testing.
- [Gatling](https://github.com/aliesbelik/awesome-gatling#readme) - Open-source load and performance testing framework based on Scala, Akka, and Netty.
- [CodeRabbit](https://github.com/coderabbitai/awesome-coderabbit#readme) - AI-powered code review platform.

## Miscellaneous

- [Scientific Writing](https://github.com/writing-resources/awesome-scientific-writing#readme) - Distraction-free scientific writing with Markdown, reStructuredText and Jupyter notebooks.
- [JSON](https://github.com/burningtree/awesome-json#readme) - Text based data interchange format.
	- [GeoJSON](https://github.com/tmcw/awesome-geojson#readme)
	- [Datasets](https://github.com/jdorfman/awesome-json-datasets#readme)
- [CSV](https://github.com/secretGeek/awesomeCSV#readme) - A text file format that stores tabular data and uses a comma to separate values.
- [Discounts for Student Developers](https://github.com/AchoArnold/discount-for-student-dev#readme)
- [Radio](https://github.com/kyleterry/awesome-radio#readme)
- [Awesome](https://github.com/sindresorhus/awesome#readme) - Recursion illustrated.
- [Analytics](https://github.com/0xnr/awesome-analytics#readme)
- [REST](https://github.com/marmelab/awesome-rest#readme)
- [Continuous Integration and Continuous Delivery](https://github.com/cicdops/awesome-ciandcd#readme)
- [Services Engineering](https://github.com/mmcgrana/services-engineering#readme)
- [Free for Developers](https://github.com/ripienaar/free-for-dev#readme)
- [Answers](https://github.com/cyberglot/awesome-answers#readme) - Stack Overflow, Quora, etc.
- [Sketch](https://github.com/diessica/awesome-sketch#readme) - Design app for macOS.
- [Boilerplate Projects](https://github.com/melvin0008/awesome-projects-boilerplates#readme)
- [Readme](https://github.com/matiassingers/awesome-readme#readme)
- [GitHub Wiki](https://github.com/MyHoneyBadger/awesome-github-wiki#readme) - Comprehensive documentation on GitHub beyond README.
- [Design and Development Guides](https://github.com/NARKOZ/guides#readme)
- [Software Engineering Blogs](https://github.com/kilimchoi/engineering-blogs#readme)
- [Self Hosted](https://github.com/awesome-selfhosted/awesome-selfhosted#readme)
- [FOSS Production Apps](https://github.com/DataDaoDe/awesome-foss-apps#readme)
- [Gulp](https://github.com/alferov/awesome-gulp#readme) - Task runner.
- [AMA](https://github.com/sindresorhus/amas#readme) - Ask Me Anything.
	- [Answers](https://github.com/stoeffel/awesome-ama-answers#readme)
- [Open Source Photography](https://github.com/ibaaj/awesome-OpenSourcePhotography#readme)
- [OpenGL](https://github.com/eug/awesome-opengl#readme) - Cross-platform API for rendering 2D and 3D graphics.
- [GraphQL](https://github.com/chentsulin/awesome-graphql#readme)
- [Urban & Regional Planning](https://github.com/APA-Technology-Division/urban-and-regional-planning-resources#readme) - Concerning the built environment and communities.
- [Transit](https://github.com/CUTR-at-USF/awesome-transit#readme)
- [Research Tools](https://github.com/emptymalei/awesome-research#readme)
- [Data Visualization](https://github.com/javierluraschi/awesome-dataviz#readme)
- [Microservices](https://github.com/mfornos/awesome-microservices#readme)
- [Unicode](https://github.com/jagracey/Awesome-Unicode#readme) - Unicode standards, quirks, packages and resources.
	- [Code Points](https://github.com/Codepoints/awesome-codepoints#readme)
- [Beginner-Friendly Projects](https://github.com/MunGell/awesome-for-beginners#readme)
- [Katas](https://github.com/gamontal/awesome-katas#readme)
- [Tools for Activism](https://github.com/drewrwilson/toolsforactivism#readme)
- [Citizen Science](https://github.com/dylanrees/citizen-science#readme) - For community-based and non-institutional scientists.
- [MQTT](https://github.com/hobbyquaker/awesome-mqtt#readme) - "Internet of Things" connectivity protocol.
- [For Girls](https://github.com/cristianoliveira/awesome4girls#readme)
- [Vorpal](https://github.com/vorpaljs/awesome-vorpal#readme) - Node.js CLI framework.
- [Vulkan](https://github.com/vinjn/awesome-vulkan#readme) - Low-overhead, cross-platform 3D graphics and compute API.
- [LaTeX](https://github.com/egeerardyn/awesome-LaTeX#readme) - Typesetting language.
- [Economics](https://github.com/antontarasenko/awesome-economics#readme) - An economist's starter kit.
- [Funny Markov Chains](https://github.com/sublimino/awesome-funny-markov#readme)
- [Bioinformatics](https://github.com/danielecook/Awesome-Bioinformatics#readme)
- [Cheminformatics](https://github.com/hsiaoyi0504/awesome-cheminformatics#readme) - Informatics techniques applied to problems in chemistry.
- [Colorful](https://github.com/Siddharth11/Colorful#readme) - Choose your next color scheme.
- [Steam](https://github.com/scholtzm/awesome-steam#readme) - Digital distribution platform.
- [Bots](https://github.com/hackerkid/bots#readme) - Building bots.
- [Site Reliability Engineering](https://github.com/dastergon/awesome-sre#readme)
- [DTrace](https://github.com/xen0l/awesome-dtrace#readme) - Dynamic tracing framework.
- [Userscripts](https://github.com/bvolpato/awesome-userscripts#readme) - Enhance your browsing experience.
- [Pokémon](https://github.com/tobiasbueschel/awesome-pokemon#readme) - Pokémon and Pokémon GO.
- [ChatOps](https://github.com/exAspArk/awesome-chatops#readme) - Managing technical and business operations through a chat.
- [Falsehood](https://github.com/kdeldycke/awesome-falsehood#readme) - Falsehoods programmers believe in.
- [Domain-Driven Design](https://github.com/heynickc/awesome-ddd#readme) - Software development approach for complex needs by connecting the implementation to an evolving model.
- [Quantified Self](https://github.com/woop/awesome-quantified-self#readme) - Self-tracking through technology.
- [SaltStack](https://github.com/hbokh/awesome-saltstack#readme) - Python-based config management system.
- [Web Design](https://github.com/nicolesaidy/awesome-web-design#readme) - For digital designers.
- [Creative Coding](https://github.com/terkelg/awesome-creative-coding#readme) - Programming something expressive instead of something functional.
- [No-Login Web Apps](https://github.com/aviaryan/awesome-no-login-web-apps#readme) - Web apps that work without login.
- [Free Software](https://github.com/johnjago/awesome-free-software#readme) - Free as in freedom.
- [Framer](https://github.com/podo/awesome-framer#readme) - Prototyping interactive UI designs.
- [Markdown](https://github.com/BubuAnabelas/awesome-markdown#readme) - Markup language.
- [Dev Fun](https://github.com/mislavcimpersak/awesome-dev-fun#readme) - Funny developer projects.
- [Magento 2](https://github.com/DavidLambauer/awesome-magento2#readme) - Open Source eCommerce built with PHP.
- [TikZ](https://github.com/xiaohanyu/awesome-tikz#readme) - Graph drawing packages for TeX/LaTeX/ConTeXt.
- [Ad-Free](https://github.com/johnjago/awesome-ad-free#readme) - Ad-free alternatives.
- [Prometheus](https://github.com/roaldnefs/awesome-prometheus#readme) - Open-source monitoring system.
- [Homematic](https://github.com/homematic-community/awesome-homematic#readme) - Smart home devices.
- [Ledger](https://github.com/sfischer13/awesome-ledger#readme) - Double-entry accounting on the command-line.
- [Web Monetization](https://github.com/thomasbnt/awesome-web-monetization#readme) - A free open web standard service that allows you to send money directly in your browser.
- [Uncopyright](https://github.com/johnjago/awesome-uncopyright#readme) - Public domain works.
- [Crypto Currency Tools & Algorithms](https://github.com/Zheaoli/awesome-coins#readme) - Digital currency where encryption is used to regulate the generation of units and verify transfers.
- [Open Source Supporters](https://github.com/zachflower/awesome-open-source-supporters#readme) - Companies that offer their tools and services for free to open source projects.
- [Design Principles](https://github.com/robinstickel/awesome-design-principles#readme) - Create better and more consistent designs and experiences.
- [Theravada](https://github.com/johnjago/awesome-theravada#readme) - Teachings from the Theravada Buddhist tradition.
- [inspectIT](https://github.com/inspectit-labs/awesome-inspectit#readme) - Open source Java app performance management tool.
- [Open Source Maintainers](https://github.com/nayafia/awesome-maintainers#readme) - The experience of being an open source maintainer.
- [Calculators](https://github.com/xxczaki/awesome-calculators#readme) - Calculators for every platform.
- [Captcha](https://github.com/ZYSzys/awesome-captcha#readme) - A type of challenge–response test used in computing to determine whether or not the user is human.
- [Jupyter](https://github.com/markusschanta/awesome-jupyter#readme) - Create and share documents that contain code, equations, visualizations and narrative text.
- [FIRST Robotics Competition](https://github.com/andrewda/awesome-frc#readme) - International high school robotics championship.
- [Speakers](https://github.com/karlhorky/awesome-speakers#readme) - Conference and meetup speakers in the programming and design community.
- [Board Games](https://github.com/edm00se/awesome-board-games#readme) - Table-top gaming fun for all.
- [Software Patreons](https://github.com/uraimo/awesome-software-patreons#readme) - Fund individual programmers or the development of open source projects.
- [Parasite](https://github.com/ecohealthalliance/awesome-parasite#readme) - Parasites and host-pathogen interactions.
- [Food](https://github.com/jzarca01/awesome-food#readme) - Food-related projects on GitHub.
- [Bitcoin Payment Processors](https://github.com/alexk111/awesome-bitcoin-payment-processors#readme) - Start accepting Bitcoin.
- [Scientific Computing](https://github.com/nschloe/awesome-scientific-computing#readme) - Solving complex scientific problems using computers.
- [Amazon Sellers](https://github.com/ScaleLeap/awesome-amazon-seller#readme)
- [Agriculture](https://github.com/brycejohnston/awesome-agriculture#readme) - Open source technology for farming and gardening.
- [Product Design](https://github.com/ttt30ga/awesome-product-design#readme) - Design a product from the initial concept to production.
- [Prisma](https://github.com/catalinmiron/awesome-prisma#readme) - Turn your database into a GraphQL API.
- [Software Architecture](https://github.com/simskij/awesome-software-architecture#readme) - The discipline of designing and building software.
- [Connectivity Data and Reports](https://github.com/stevesong/awesome-connectivity-info#readme) - Better understand who has access to telecommunication and internet infrastructure and on what terms.
- [Stacks](https://github.com/stackshareio/awesome-stacks#readme) - Tech stacks for building different apps and features.
- [Cytodata](https://github.com/cytodata/awesome-cytodata#readme) - Image-based profiling of biological phenotypes for computational biologists.
- [IRC](https://github.com/davisonio/awesome-irc#readme) - Open source messaging protocol.
- [Advertising](https://github.com/cenoura/awesome-ads#readme) - Advertising and programmatic media for websites.
- [Earth](https://github.com/philsturgeon/awesome-earth#readme) - Find ways to resolve the climate crisis.
- [Naming](https://github.com/gruhn/awesome-naming#readme) - Naming things in computer science done right.
- [Web Archiving](https://github.com/iipc/awesome-web-archiving#readme) - An effort to preserve the Web for future generations.
- [WP-CLI](https://github.com/schlessera/awesome-wp-cli#readme) - Command-line interface for WordPress.
- [Credit Modeling](https://github.com/mourarthur/awesome-credit-modeling#readme) - Methods for classifying credit applicants into risk classes.
- [Ansible](https://github.com/ansible-community/awesome-ansible#readme) - A Python-based, open-source IT configuration management and automation platform.
- [Biological Visualizations](https://github.com/keller-mark/awesome-biological-visualizations#readme) - Interactive visualization of biological data on the web.
- [QR Code](https://github.com/make-github-pseudonymous-again/awesome-qr-code#readme) - A type of matrix barcode that can be used to store and share a small amount of information.
- [Veganism](https://github.com/sdassow/awesome-veganism#readme) - Making the plant-based lifestyle easy and accessible.
- [Translations](https://github.com/mbiesiad/awesome-translations#readme) - The transfer of the meaning of a text from one language to another.
- [Scriptable](https://github.com/dersvenhesse/awesome-scriptable#readme) - An iOS app for automation in JavaScript.
- [WebXR](https://github.com/msub2/awesome-webxr#readme) - Enables immersive virtual reality and augmented reality content on the web.
- [Computational Geometry](https://github.com/atkirtland/awesome-computational-geometry#readme) - Computational approaches for problems in geometry.
- [OpenStreetMap](https://github.com/osmlab/awesome-openstreetmap#readme) - An open data mapping project utilized by many apps and devices.
- [Computational Biology](https://github.com/inoue0426/awesome-computational-biology#readme) - Computational approaches applied to problems in biology.
- [Read the Docs](https://github.com/readthedocs-examples/awesome-read-the-docs#readme) - Example documentation projects to inspire and help bootstrap new documentation projects.
- [Quarto](https://github.com/mcanouil/awesome-quarto#readme) - Scientific and technical open-source publishing system built on Pandoc.
- [Biological Image Analysis](https://github.com/hallvaaw/awesome-biological-image-analysis#readme) - Interpreting biological phenomena using images.
- [ChatGPT](https://github.com/sindresorhus/awesome-chatgpt#readme) - Artificial intelligence chatbot developed by OpenAI.
- [Whisper](https://github.com/sindresorhus/awesome-whisper#readme) - Open-source AI-powered speech recognition system developed by OpenAI.
- [Stock Trading](https://github.com/shi-rudo/awesome-stock-trading#readme) - Purchase and sale of equities of publicly traded companies to generate profits.
- [Steam Deck](https://github.com/airscripts/awesome-steam-deck#readme) - A handheld gaming computer developed by Valve.
- [Astrophotography](https://github.com/lunohodov/awesome-astrophotography#readme) - Photography of astronomical objects, celestial events, or areas of the night sky.
- [HPC](https://github.com/dstdev/awesome-hpc#readme) - High Performance Computing.
- [Geocaching](https://github.com/FoxFil/awesome-geocaching#readme) - Outdoor treasure-hunting activity that uses GPS-enabled devices.
- [Regex](https://github.com/slevithan/awesome-regex#readme) - Specialized language for matching patterns in text.
- [Event-Driven Architecture](https://github.com/lutzh/awesome-event-driven-architecture#readme) - A software architecture approach where services collaborate by publishing and subscribing to events.
- [Permacomputing](https://github.com/idematos/awesome-permacomputing#readme) - Resilient and regenerative computing practices inspired by permaculture.
- [Standards](https://github.com/donBarbos/awesome-standards#readme) - Standards and proposals that define and enhance software, languages, and related technologies.
- [Claude Code](https://github.com/hesreallyhim/awesome-claude-code#readme) - Terminal-based AI coding assistant by Anthropic.
- [Gemini CLI](https://github.com/Piebald-AI/awesome-gemini-cli#readme) - Terminal-based AI coding assistant by Google.
- [SAP Commerce](https://github.com/eminyagiz42/awesome-sap-commerce#readme) - An e-commerce platform built with Java, Spring MVC, and Angular.
- [Tech Ethics](https://github.com/sampart/awesome-tech-ethics#readme) - Mitigating and avoiding the potential negative effects of technology on society.
- [Copilot Agents](https://github.com/Code-and-Sorts/awesome-copilot-agents#readme) - AI pair programming assistant by GitHub that provides code suggestions and completions.

## Related

- [All Awesome Lists](https://github.com/topics/awesome) - All the Awesome lists on GitHub.
- [Awesome Search](https://awesomelists.top) - Quick search for Awesome lists.
- [StumbleUponAwesome](https://github.com/basharovV/StumbleUponAwesome) - Discover random pages from the Awesome dataset using a browser extension.
- [Awesome CLI](https://github.com/umutphp/awesome-cli) - A simple command-line tool to dive into Awesome lists.
- [Track Awesome List](https://www.trackawesomelist.com) - View the latest updates of Awesome lists.
