# Contribution Guidelines

Please ensure your pull request adheres to the following guidelines:

> If you forget any of these I will nicely ask you to change it in the pull request.

# Updating [README.md](https://github.com/sjfricke/awesome-webgl/blob/master/README.md)

- Make an individual pull request for each suggestion.
- You can either add a link or new categories, or improvements... all are welcome.
  - If you have other ideas for discussion please leave an issue.
- Use the following format: \[NAME\]\(LINK\) - DESCRIPTION.
  - Keep descriptions simple.
- Titles should be [capitalized](http://grammar.yourdictionary.com/capitalization/rules-for-capitalization-in-titles.html).
- Make pull request titles descriptive i.e. not `Updated README`.
- Link additions should be added to the bottom of the relevant category.
- New sub-category are placed in alphabetical order.
- New entries for the libraries/frameworks section are placed in alphabetical order.
- New categories or improvements to the existing categorization are welcome.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- End all descriptions with a period.
- No Amazon affiliate codes in links for books.
- Add authors in book listing with `by **Author**` format.

# How to contribute from GitHub.com

- Make sure you have a free [GitHub.com](https://github.com/join) account and you are logged in.
- Find an appropriate topic category in the [README.md](https://github.com/sjfricke/awesome-webgl/blob/master/README.md) file to add it under, or add your own if you think it is needed.
- Click the :pencil: button [Edit link](https://github.com/sjfricke/awesome-webgl/edit/master/README.md) on the top right-hand corner of the README.md. This will do two things:
  - Fork the repository to your account.
  - Create a new branch so you can send your changes in a pull request.
- Add your changes.
- Scroll down to the `Propose file change` box and write a commit message and optional extended description.
- Click the `Propose file change` button.

> NOTE: this works the same for any of the files
