# Contribution Guidelines

Please ensure your pull request adheres to the following guidelines:

> If you forget any of these I will nicely ask you to change it in the pull request.

**NOTE:** Just because the library isn't in the README.md file doesn't mean it can't be in the Libraries.md file

# Updating [Features.md](https://github.com/sjfricke/awesome-webgl/blob/master/Libraries/Features.md)

- Always keep lines aligned vertically to make it easier to edit.
- Feel free to edit/add in the Column Key.
- If adding or removing a mark from the table please acknowledge why you made that decision in your pull request description.
  - If adding, put the `**X**` left aligned in the box.
- If adding a library make sure it is in alphabetical order.
  - Also make the name linked to the libraries' main page.
- If adding a column you need to do the following:
  - Make sure it is placed in alphabetical order.
  - add the spaces to each row for that column (Alt+Shift in Notepad++ takes care of that easily).
  - Add in the Column Key in the alphabetical order and give description for what that column means.
  - Use the `[Category](#category)` format to link it to the Column Key.

# Updating [File_Size.md](https://github.com/sjfricke/awesome-webgl/blob/master/Libraries/File_Size.md)

- Always keep lines aligned vertically to make it easier to edit.
- All items in cell are left aligned.
- If adding a library make sure it is in alphabetical order.
  - Also make the name linked to the libraries' main page.
- All sizes are listed as either:
  - MB with 2 decimal places.
	- (Example: 3.23)
  - KB as MB with leading zero and 3 decimal.
	- (Example: 0.304)

> **MATH NOTE**: 400KB != 0.400MB
>
> You need to divide by 1024
>
> So 400KB is 400 / 1024 = 0.332MB

# How to contribute from GitHub.com

- Make sure you have a free GitHub.com account and you are logged in.
- Find an appropriate topic category in the [README.md](https://github.com/sjfricke/awesome-webgl/blob/master/README.md) file to add it under, or add your own if you think it is needed.
- Click the :pencil: button [Edit link](https://github.com/sjfricke/awesome-webgl/edit/master/README.md) on the top right-hand corner of the README.md. This will do two things:
  - Fork the repository to your account.
  - Create a new branch so you can send your changes in a pull request.
- Add your changes.
- Scroll down to the `Propose file change` box and write a commit message and optional extended description.
- Click the `Propose file change` button.

> NOTE: this works the same for any of the files
