<!--lint disable alphabetize-lists-->

[![test](https://github.com/sobolevn/awesome-cryptography/actions/workflows/test.yml/badge.svg?event=push)](https://github.com/sobolevn/awesome-cryptography/actions/workflows/test.yml)

# Contributing

Your contributions are always welcome!

## Guidelines

- Add one link per commit.

- Add one commit per Pull Request.

- Add the link: `- [project-name](http://example.com/) - A short description ends with a period.`

  - Keep descriptions concise, maximum number of characters is 350.

- Add a section if needed.

  - Add the section description.
  - Add the section title to Table of Contents.

- Search previous suggestions before making a new one, as yours may be a duplicate.

- Check your spelling and grammar.

- Remove any trailing whitespace.

- Send a Pull Request with the reason why the library is awesome.

- Make sure the tests are passing.

## Styleguide

We enforce you all to use the same style for your submissions.
We are using [`remark-lint`](https://github.com/wooorm/remark-lint) to validate the style of the `README.md` and `CONTRIBUTING.md`.

Please, refer to [`Rules`](https://github.com/wooorm/remark-lint/blob/master/doc/rules.md) documentation, when in doubt.

## Testing

To run tests locally you will need to:

```shell
$ yarn install
$ yarn test
```
