"""
Datasets module
"""
from statsmodels.tools._test_runner import PytestTester

from . import (
    anes96,
    cancer,
    ccard,
    china_smoking,
    co2,
    committee,
    copper,
    cpunish,
    danish_data,
    elnino,
    engel,
    fair,
    fertility,
    grunfeld,
    heart,
    interest_inflation,
    longley,
    macrodata,
    modechoice,
    nile,
    randhie,
    scotland,
    spector,
    stackloss,
    star98,
    statecrime,
    strikes,
    sunspots,
)
from .utils import (
    check_internet,
    clear_data_home,
    get_data_home,
    get_rdataset,
    webuse,
)

__all__ = [
    "anes96",
    "cancer",
    "ccard",
    "check_internet",
    "china_smoking",
    "clear_data_home",
    "co2",
    "committee",
    "copper",
    "cpunish",
    "danish_data",
    "elnino",
    "engel",
    "fair",
    "fertility",
    "get_data_home",
    "get_rdataset",
    "grunfeld",
    "heart",
    "interest_inflation",
    "longley",
    "macrodata",
    "modechoice",
    "nile",
    "randhie",
    "scotland",
    "spector",
    "stackloss",
    "star98",
    "statecrime",
    "strikes",
    "sunspots",
    "test",
    "webuse",
]

test = PytestTester()
