import numpy as np

from statsmodels.tools.tools import Bunch

mpg_bs = Bunch()

mpg_bs.smooth0 = Bunch()
mpg_bs.smooth0.term = "weight"
mpg_bs.smooth0.bs_dim = 12
mpg_bs.smooth0.dim = 1
mpg_bs.smooth0.p_order = np.array([
    3, 2
    ])
mpg_bs.smooth0.by = "NA"
mpg_bs.smooth0.label = "s(weight)"
mpg_bs.smooth0.sp = -1
mpg_bs.smooth0.m = np.array([
    3, 2
    ])
mpg_bs.smooth0.knots = np.array([
    1488, 1488, 1488, 1488, 1953.22222222, 2118.77777778, 2275,
    2383.88888889, 2515.55555556, 2757.33333333, 3016.44444444,
    3208.11111111, 4066, 4066, 4066, 4066
    ])
mpg_bs.smooth0.rank = 10
mpg_bs.smooth0.null_space_dim = 1
mpg_bs.smooth0.df = 11
mpg_bs.smooth0.S_scale = 2.44395544177397e-06
mpg_bs.smooth0.vn = "weight"
mpg_bs.smooth0.first_para = 5
mpg_bs.smooth0.last_para = 15
mpg_bs.smooth0.S = np.array([
    0.130569121544375, -0.0191732921244136, 0.0202548028417763,
    0.0393112950002946, 0.032061392663319, 0.0241651485426007,
    0.0238771778381105, 0.0389406835250852, 0.0171569521441248,
    0.00680570834700402, 0.00541920498010491, -0.0191732921244136,
    0.0631473273216884, -0.0592997810399249, 0.0178641542128365,
    0.00461438941034586, 0.00793912465273829, 0.00408821971418319,
    -0.000681869049168392, 0.00213834646721613, 0.000935846814259467,
    0.000163463753965317, 0.0202548028417763, -0.0592997810399249,
    0.201022514824508, -0.186241322892132, 0.00284878067469136,
    0.0287314367063779, 0.00263260805442764, -0.00708846456492193,
    0.00065385484055723, 0.000395067932117418, -0.000586348849229599,
    0.0393112950002947, 0.0178641542128365, -0.186241322892132,
    0.479322071007576, -0.286380917395105, 0.0563704638942206,
    0.0348887744557148, 0.0255203052273876, 0.0138979985789615,
    0.00560832050247454, 0.00383270204450356, 0.032061392663319,
    0.00461438941034587, 0.00284878067469137, -0.286380917395105,
    0.414581586658592, -0.181289913269406, -0.00412646444222532,
    -0.00354719180127285, -0.00206283566879658, -0.000685858743449883,
    -0.00142523589453221, 0.0241651485426007, 0.00793912465273829,
    0.0287314367063779, 0.0563704638942206, -0.181289913269406,
    0.213321319885371, -0.0483506678191679, 0.0110304252072989,
    0.0122299348640366, 0.00357726593043956, 0.00234383478372281,
    0.0238771778381105, 0.00408821971418319, 0.00263260805442764,
    0.0348887744557148, -0.00412646444222533, -0.0483506678191679,
    0.0999220996092033, -0.0356092452156359, 0.00921547832469341,
    0.00389860712399989, 0.00147745030481206, 0.0389406835250852,
    -0.000681869049168392, -0.00708846456492192, 0.0255203052273876,
    -0.00354719180127286, 0.0110304252072989, -0.0356092452156359,
    0.0574427000604467, -0.0102653399490586, -0.000311188772793241,
    0.00285258581655637, 0.0171569521441248, 0.00213834646721613,
    0.000653854840557233, 0.0138979985789615, -0.00206283566879658,
    0.0122299348640366, 0.00921547832469341, -0.0102653399490586,
    0.0189789273643945, -0.0062453384832703, 0.00255839876648785,
    0.00680570834700402, 0.000935846814259467, 0.000395067932117419,
    0.00560832050247454, -0.000685858743449884, 0.00357726593043956,
    0.00389860712399989, -0.000311188772793241, -0.0062453384832703,
    0.0211496391608495, -0.0111654555301857, 0.00541920498010491,
    0.000163463753965317, -0.000586348849229599, 0.00383270204450356,
    -0.00142523589453221, 0.00234383478372281, 0.00147745030481206,
    0.00285258581655637, 0.00255839876648785, -0.0111654555301857,
    0.00794139033444708
    ]).reshape(11, 11, order="F")

mpg_bs.coefficients = np.array([
    29.6272774569595, -6.21365498504518, 1.43986598470837, 1.01128095138012,
    20.1053719083286, -1.26007449980292, -5.26871981200625,
    -4.544036357677, -7.60063071956733, -5.01036711884368,
    -6.96226144900638, -9.06722069409647, -8.81829781369916,
    -7.9145836553663, -6.28068941724657, 5.09307848346347,
    1.90848821039499, -0.646225516186639, -1.50240395085899,
    -4.19244286007642, -5.72993924243941, -6.83323296859843,
    -5.77088950575513, -4.29112523442438
    ])
mpg_bs.fitted_values = np.array([
    21.9396113442978, 21.9396113442978, 18.7594768791121, 23.978775547494,
    19.6605284085114, 22.5415570425591, 21.4364029092864, 21.5001397125411,
    19.345544773382, 17.3284985371825, 23.0829354555269, 23.0829354555269,
    20.5257074462847, 20.350418275392, 20.0920273672739, 16.3475493433762,
    15.2683918200041, 14.6016645854518, 48.1414677548395, 34.6770647570973,
    33.3220963193152, 34.9078179723597, 34.9078179723597, 25.7413956426768,
    31.8998747894453, 31.4406608644666, 31.4406608644666, 25.4076816004152,
    24.637322541799, 19.5423694752458, 43.7120662014648, 36.1794319009933,
    37.8600814894106, 31.3973345386248, 30.9527603762328, 29.8740452948944,
    29.6825700516209, 26.8853631419929, 26.3600803699054, 26.1773024038522,
    25.3856227340742, 23.3020193188726, 24.7100852851954, 26.4172597325081,
    34.6770647570973, 33.3220963193152, 23.0296498930938, 14.7476201253168,
    14.7476201253168, 14.0557212409125, 34.34782143196, 33.965299405798,
    33.7800699350403, 32.4689563918131, 32.329358068477, 23.1906404151376,
    23.1906404151376, 23.1512875039068, 20.6941238423555, 25.5363151316018,
    25.3886549365523, 25.5363151316018, 25.3886549365523, 34.4607486893619,
    25.3326646650999, 20.7768158749875, 31.8441811103844, 23.0217104934054,
    22.4301358955383, 23.1106217353394, 22.4200843547568, 14.7491664060278,
    14.8191667947128, 14.012803756677, 13.9581303982076, 18.1760880728356,
    33.3190101477328, 32.4975851853098, 31.1829311245072, 25.6555703896226,
    22.6046524037776, 25.6230700315092, 19.5479517982215, 19.6165588348237,
    19.6186479966108, 25.1994604891903, 24.8987688972877, 22.3628638356355,
    22.3628638356355, 34.2300125601631, 39.2885271153262, 33.1621106074804,
    32.5172901213345, 30.742747639841, 32.1452590079292, 30.6934785442198,
    31.6517339944659, 30.5907093672281, 30.9641455088909, 24.6266167464042,
    24.9022880874316, 18.78153275305, 17.1521355867311, 19.0141306741668,
    18.231718904575, 16.8216593127165, 17.7202420891745, 22.0561680452922,
    27.2153336488053, 20.5096211586017, 25.567299743712, 21.9831410020533,
    26.7629956266796, 20.2961667790902, 25.2853678595518, 21.7669720922915,
    26.7629956266796, 18.4910047689371, 33.3190101477328, 25.7413956426768,
    31.8998747894453, 31.4406608644666, 29.7789375739066, 24.637322541799,
    19.1142432042937, 19.2193336362723, 17.6365280620964, 17.6365280620964,
    17.579806089837, 15.8168257322192, 21.8960566915, 21.7074289198647,
    21.6525958338155, 21.4785952775663, 18.9756522798894, 18.9897722666541,
    30.4602645168316, 29.3805961723331, 27.2238321670602, 27.9694092954432,
    27.7274373142384, 24.7585135497211, 24.3629123288499, 21.0288767895242,
    26.8745904429808, 24.038604652806, 24.1756501080763, 20.4312780252146,
    32.4709598995115, 31.6700176166953, 31.9735144592214, 30.0023513412019,
    28.4464554097632, 25.3419682258173, 30.061904278659, 29.8978667285749,
    37.2387365989938, 37.2387365989938, 29.9813024611395, 29.8303048561215,
    29.7392162621016, 29.1611058213974, 28.9573381148783, 23.6489155519235,
    23.2515846177326, 21.6472193877583, 21.6596390100383, 21.6094248571684,
    20.9701064457552, 20.8066296061343, 20.6663348110776, 25.161054576378,
    33.0089371917933, 24.3712852430277, 24.3712852430277, 24.2659916432858,
    18.5704777306123, 18.4763039586984, 17.9248313386425, 17.7576418795043,
    38.0290768582748, 27.2115396047694, 37.9994882599177, 27.1914558802737,
    26.6487573286281, 34.7866136817861, 24.6246815506878, 26.2295193582235,
    26.4988154777346, 21.8800181352396, 33.5183981701922, 24.5373651901876,
    20.8017272859603, 20.6222748754003, 20.8111189208126, 20.5838532565161,
    18.3170655814092, 17.5023519244001, 20.8093138226564, 18.3617172827568,
    19.5919656568361, 26.0100107405061, 20.4732985733418
    ])
mpg_bs.linear_predictors = mpg_bs.fitted_values
mpg_bs.deviance = 871.169775911354
mpg_bs.null_deviance = 8721.1724137931
mpg_bs.iter = 1
mpg_bs.weights = np.array([
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
    ])
mpg_bs.prior_weights = np.array([
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
    ])
mpg_bs.df_null = 202
mpg_bs.y = np.array([
    21, 21, 19, 24, 18, 19, 19, 19, 17, 16, 23, 23, 21, 21, 20, 16, 16, 15,
    47, 38, 38, 37, 31, 24, 31, 31, 31, 24, 24, 19, 49, 31, 38, 30, 30, 30,
    30, 27, 27, 27, 27, 24, 25, 24, 38, 38, 24, 15, 15, 13, 30, 31, 31, 31,
    31, 17, 17, 17, 16, 26, 26, 26, 26, 36, 26, 19, 31, 22, 22, 22, 22, 16,
    16, 14, 14, 19, 37, 31, 31, 24, 23, 25, 19, 19, 19, 25, 25, 23, 23, 31,
    45, 31, 31, 31, 31, 31, 31, 31, 31, 27, 27, 17, 17, 19, 19, 17, 19, 19,
    28, 19, 25, 19, 28, 19, 25, 19, 28, 18, 37, 24, 31, 31, 31, 24, 19, 19,
    17, 17, 17, 17, 21, 21, 21, 21, 19, 19, 31, 26, 26, 32, 28, 26, 24, 24,
    28, 25, 23, 23, 35, 31, 31, 31, 27, 27, 30, 30, 34, 38, 38, 28, 28, 29,
    29, 26, 26, 24, 24, 24, 24, 24, 24, 29, 30, 27, 27, 27, 20, 19, 20, 19,
    37, 27, 37, 27, 27, 37, 26, 24, 24, 19, 33, 25, 23, 23, 24, 24, 17, 17,
    23, 19, 18, 26, 19
    ])
mpg_bs.residuals = mpg_bs.y - mpg_bs.fitted_values
mpg_bs.sig2 = 4.70648213227865
mpg_bs.edf_all = np.array([
    0.999999999999898, 1.00000000000005, 1.00000000000003, 1.00000000000002,
    0.715182726327133, 0.945523457125076, 0.933952133938362,
    0.910787981046657, 0.918439669310707, 0.936922915439925,
    0.967620005020078, 0.978502846618072, 0.979593620228742,
    0.973114724412765, 0.993928896515985, 0.206529848573726,
    0.134722764346217, 0.130032558435079, 0.214058208629181,
    0.428628830751172, 0.480753053928721, 0.728730191076721,
    0.464984912297227, 0.858004843431828
    ])
mpg_bs.edf1 = np.array([
    0.999999999999765, 1.00000000000012, 1.00000000000008, 1.00000000000005,
    0.895328939039617, 0.985281018312391, 0.980485303917254,
    0.985115307594987, 0.979973329752608, 0.991029113855046,
    0.996293301947028, 0.996456521529546, 0.997881056094132,
    0.998369079216076, 0.999638164901435, 0.263857404503542,
    0.167489975859197, 0.241183045516588, 0.33714799512247,
    0.51312433111897, 0.537892914498989, 0.811390270624644,
    0.600430783273412, 0.922162336898961
    ])
mpg_bs.hat = np.array([
    0.078074509536494, 0.078074509536494, 0.065030323239247,
    0.0401345230539626, 0.168187944335173, 0.0664399958506056,
    0.0736573430018038, 0.0780134136835909, 0.070154483540544,
    0.180767093886445, 0.0664593954539867, 0.0664593954539867,
    0.0594553974001933, 0.0675038468082751, 0.0536944450768444,
    0.0970468595627894, 0.125358300385429, 0.125631704260218,
    0.944302622125637, 0.0519142263263012, 0.0379831848669348,
    0.0493844279965059, 0.0493844279965059, 0.0949083347321329,
    0.0309819618026538, 0.029589102491272, 0.029589102491272,
    0.0670447385890157, 0.0842123937662785, 0.0687733897932081,
    0.422927507867707, 0.1328199698695, 0.096736475340286,
    0.0419915413707043, 0.0396238084435642, 0.0346918436236485,
    0.0363065585955308, 0.0491064279890273, 0.0441863897171056,
    0.0388360718854439, 0.0414457600258062, 0.0451305758954266,
    0.0505018876352514, 0.0744589274009074, 0.0519142263263012,
    0.0379831848669348, 0.101629248471346, 0.436525380451652,
    0.436525380451652, 0.410550032148353, 0.0425422548236529,
    0.039274955616929, 0.0380389889031733, 0.0330421266803994,
    0.0325988284653424, 0.066244431441902, 0.066244431441902,
    0.0666221560337819, 0.0952529331187707, 0.046598430925228,
    0.0484713995290722, 0.046598430925228, 0.0484713995290722,
    0.11544865825422, 0.0480259855055657, 0.0566600271329405,
    0.137824712103277, 0.112620492286817, 0.182195648532627,
    0.11200306230358, 0.188335501134619, 0.169514959934583,
    0.158055134563875, 0.160687809078496, 0.168998857825895,
    0.0681007619372312, 0.0357408884807467, 0.0331290501952606,
    0.0300353569162307, 0.0866855568546318, 0.0663539796978426,
    0.0330200310685004, 0.0646249177791591, 0.0586792000782014,
    0.0592011499253728, 0.0382030583658832, 0.0445521201486119,
    0.067008407725231, 0.067008407725231, 0.0432898262619123,
    0.12461566211325, 0.0358742808101827, 0.03362714942096,
    0.0325446423810936, 0.0323846714084075, 0.0335509666038901,
    0.0303353227561161, 0.0362607404205336, 0.0298241376272862,
    0.0362837776795306, 0.0432688893651977, 0.0709252762463711,
    0.147397446518277, 0.0723900341977973, 0.0517894283747262,
    0.106665126964701, 0.0503219409131233, 0.0834357951937577,
    0.100818501015755, 0.105292582127573, 0.104194456647628,
    0.0762380011365815, 0.105895524421508, 0.131464943163143,
    0.105727045973233, 0.0727635750299144, 0.105895524421508,
    0.0437337708748914, 0.0357408884807467, 0.0949083347321329,
    0.0309819618026538, 0.029589102491272, 0.0529778772840967,
    0.0842123937662785, 0.0607153181824941, 0.0672240685836559,
    0.144807911379215, 0.144807911379215, 0.141129878619691,
    0.688420146600013, 0.0609351365077056, 0.0626297831888101,
    0.0648027622574709, 0.0759997034218865, 0.0782103847541935,
    0.0707477713155958, 0.0410921970518355, 0.0589697594313821,
    0.152256577677227, 0.056765876958851, 0.0440206300688631,
    0.0331810206918762, 0.145634415508243, 0.171438771769591,
    0.045261532361592, 0.041840944187868, 0.143150260376584,
    0.156242430028033, 0.0410741399980494, 0.0522187899853102,
    0.0442706334210004, 0.0971923907649902, 0.165585071470526,
    0.238054218005531, 0.0532738449881275, 0.0604428830039113,
    0.111392476904907, 0.111392476904907, 0.057580243342699,
    0.0605291866378679, 0.0573770911039481, 0.0885019494515106,
    0.0862447970676653, 0.0955397769716847, 0.081739783220223,
    0.0812965346829218, 0.0809796720150843, 0.0813844390983633,
    0.0553602073413133, 0.0595903222287986, 0.0580738296478883,
    0.0331472062547294, 0.117186329269605, 0.0421565210307805,
    0.0421565210307805, 0.0431360897292105, 0.0601728243619919,
    0.0608147839961041, 0.0469900387599093, 0.0511099791683115,
    0.133968859142191, 0.0454828817219972, 0.134269192729732,
    0.045677409250904, 0.0484924110945302, 0.0915494575563987,
    0.0473953480872363, 0.0521826902889385, 0.0499074879741539,
    0.0607510996298348, 0.138895050565221, 0.0906618240478993,
    0.0545651794730959, 0.0588322152774606, 0.0555824719807064,
    0.0578268424764083, 0.0579806773332134, 0.0555747554696179,
    0.0570504628526928, 0.0556475846732603, 0.0510369790482531,
    0.105422478219541, 0.0549738873644795
    ])
mpg_bs.R = np.array([
    -14.247806848775, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -12.8440820360878, 0.373532783001862, -4.2296607322892,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -8.28197639485442, 7.02914411540082, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.33415428821132, -6.28488179729956,
    0.275366266013156, 0.350799946868301, -0.320832128978794,
    -0.400140439924557, -2.75411074826349, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 6.93889390390723e-18, 0.232054372832382,
    -0.059045600449299, 0.180812355115842, 0.128163547439293,
    0.144886567744466, -0.0269730574249025, -0.184599966726543,
    0.118427787192217, 0.122053978888216, -0.0642672707517637,
    0.0681043144407656, -0.060071867550458, -0.150958262500398,
    0.0229223735842404, 0.0444276150539449, -0.348767846881924,
    0.400671529738335, -0.0077479495898858, -0.0233519344455665,
    -0.0016530657606304, 0.252520737261296, -0.0010134977318948,
    -0.440010476997986, -2.77555756156289e-17, 1.09497230004704,
    -0.214931983948417, 0.930799141411998, 0.550394857028419,
    0.709391063166251, -0.109782318058198, -0.842294484569631,
    0.695883635886005, 0.497451233152266, -0.43887148186347,
    0.581743977285481, -0.402315830184767, -0.709015800353095,
    0.0516077442049284, 0.028185898732357, -0.352543779422061,
    1.27839021341958, 0, 0, 0, 0, 0, 0, -1.38777878078145e-16,
    1.46496369379118, -0.201247454925983, 1.35850779046971,
    0.280404550518566, 1.0970677381965, -0.0446546144567612,
    0.111447137155272, 1.10339850569991, 0.314461688316244,
    -0.822981973569381, 0.910711177150427, -0.465095093337983,
    -0.492817626024387, -0.0302680940522306, -0.250587565379533,
    1.36321225401071, 0, 0, 0, 0, 0, 0, 0, -5.55111512312578e-17,
    0.636539976078798, 0.334849603625203, -0.801543168266999,
    -0.153261416776597, 0.590531348112483, 0.179469236924221,
    2.6920602822558, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1.52655665885959e-16, 0.386544461276061, 0.0617187417679946,
    -3.3375034414008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2.22044604925031e-16, -0.268086271294675, 0.0357997911433628,
    -0.811541848512822, -0.417713567994733, -0.549046879404324,
    0.191376270418331, -0.760481136635749, 1.0789013415145,
    -0.49182262459782, 0.630320008138126, 0.0469111147236198,
    1.777708468755, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.52655665885959e-16,
    -0.638506225101581, -0.252213861766942, 0.590961092489265,
    -0.376498675165681, -1.05466211118764, 0.161726074180775,
    -0.307990147500367, 0.53052971421346, -0.419174109920259,
    2.18021214925427, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    2.4980018054066e-16, -1.88284158749395, -0.158199593825249,
    1.30601514580108, -0.263143162777336, -1.19466765891104,
    -0.0392202790218998, -0.553059650646982, -2.5833579317638, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -7.63278329429795e-17,
    -1.03018120754794, 0.633410571283583, 0.425787563324548,
    -0.117069541181738, -0.15949862209609, -0.203120611440518,
    -0.24794544312747, -0.577954387092811, -0.392668668150195,
    -0.742414613515821, -0.0517296981247248, -0.180774236277864,
    -0.0985346957439217, -0.0346679818369825, -0.522507884861262,
    -0.444065964414515, -0.178453142391426, 0.368705729297475,
    0.951128380630708, 0, 0, 0, 0, -1.35308431126191e-16,
    -0.465120271023632, 0.406195493272399, 0.070203506724658,
    0.112046096976311, -0.200096302157889, -0.152715842062604,
    0.0104383470658289, 0.342550835873512, -0.273815544285267,
    -0.401207001497804, -0.040780018432021, -0.303740748176209,
    -0.0609839545858858, 0.319068530448539, -0.260734203657871,
    -0.260132352451617, -0.0932586655435074, 0.203432578212413,
    0.317497529276374, -0.83938821954848, 0, 0, 0, -4.85722573273506e-17,
    -0.390650961425867, 0.0330907911134603, 0.00733620315637045,
    0.228118285854502, -0.0868790621492882, -0.191943985560395,
    0.0744153770730219, 0.343145769098306, -0.095185581001596,
    -0.223303572468095, -0.150287745525581, -0.158778635381907,
    0.0110735369943658, 1.59565825328421, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1.11022302462516e-16, 0.274167363775303, 0.474667692897905,
    0.106124488726352, 0.284328629467105, 0.186661254435535,
    0.187571744571793, 0.20413327819365, -0.0397206127231053,
    0.383068904117848, 0.0739013097506463, -0.570930211792512,
    0.0925572774037632, -0.322045428454689, -0.0206704824306383,
    0.138827717514351, 0.305979392429139, 0.329598188006108,
    0.056917317683023, 0.166351113868783, -0.0429579563012386,
    0.698123470574497, 0, 0, 2.77555756156289e-17, 1.28869031811426,
    0.159462695223405, 0.94874511527323, 1.22041060990194,
    1.23041883682224, 0.214295232212795, -0.421272049466657,
    0.484873150940021, 1.22340399746876, -0.126213059047102,
    0.586508858858053, 0.0387247897517475, -1.73048932450117, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3.33066907387547e-16, 1.38101651269374,
    -0.161333143580265, 0.26879941823133, 1.5843908766769,
    1.56675922898707, 0.130712348793346, -0.15459448409081,
    0.322441342868708, 0.032841704236906, -0.040628028706388,
    1.95780421180254, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -4.71844785465692e-16, 0.547361386973655, -0.0560623687491847,
    -1.42773410582977, -0.319295075080351, 1.10930671785576,
    -0.249435864270354, 0.376460682854174, -0.859698359693027,
    -2.22778539317977, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1.16573417585641e-15, -0.680782403896811, -0.0829421876833989,
    -1.06575902669119, -3.08847910097662, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, -3.05311331771918e-16, -1.73716924091107,
    -0.427903820099444, 0.508003939493925, 0.0674537346537795,
    -3.01780655906657, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, -8.32667268468867e-17, -0.907178653618356, -0.442910523756854,
    0.50555822069335, 0.912713271576068, -0.893880669315821,
    -0.303415799851323, 0.00713986966174707, -0.565052960394418,
    -0.0893598475014228, 0.1719971566722, -0.455461128044599,
    -0.0927359754631413, 0.109881340577719, 0.546762409477948,
    -1.42658278966991, 0, 0, 0, 0, 0, 0, 0, 0, -5.89805981832114e-17,
    -0.358468733615153, -0.156326542139889, 0.124611476610136,
    0.261720342968014, 0.0035504239879391, -0.178906878260252,
    -0.00818092652923195, -0.0665839339476971, 0.00890831066007731,
    0.21700219401572, -0.192545410574642, -0.0251881401918565,
    0.0596236111422667, 0.356927030887266, -0.559501871586496,
    0.00939356269184223, 0.00808635023879492, 0.174506073397661,
    -0.00768811220727605, -0.0824771518664715, 0.00281995201714263,
    0.552896914606241, 0, -8.15320033709099e-17, -0.153937258650552,
    -0.0600660535926754, 0.0307742140033325, 0.0538665072365687,
    0.107288075694366, -0.0951443583796005, -0.0122161530644771,
    0.00205111921342145, 0.00850795594637679, 0.0131768142662108,
    -0.0351898170323615, -0.00506295245698965, 0.000521970211206223,
    0.172268163286512, 0.0600225535087082, -0.0453855401632395,
    -0.0806877659326075, 1.10081916052039, 0, 0, 0, 0, 0
    ]).reshape(24, 24, order="F")

mpg_bs.sp = np.array([
    0.830689464223685, 425.361212061649
    ])
mpg_bs.nsdf = 4
mpg_bs.Ve = np.array([
    1.18849578741713, -0.569737725624008, -0.680858316482058,
    -0.683616810254248, 0.377412685416274, 0.162104128449963,
    0.0284282197471564, -0.170886673387626, -0.194448131082813,
    -0.235607054710811, -0.334637151301396, -0.298355349820224,
    -0.598813240305989, -0.484066776146491, -0.222539433922648,
    -0.343523840336231, -0.124699240656557, 0.0511301117304156,
    0.112522894520982, 0.282177537241417, 0.387281538045199,
    0.418871839073582, 0.402617068797253, 0.425257369102146,
    -0.569737725624005, 0.510619669380942, 0.112546264990929,
    0.117538151789885, -0.278500464239846, -0.106503131214755,
    -0.0142727895051468, 0.119693314820498, 0.122566162544252,
    0.141792166493477, 0.258713037741001, 0.167091968978498,
    0.548140901913199, 0.402802042938447, 0.176247371186236,
    0.253097604219116, 0.0912014747571045, -0.0380177304877867,
    -0.0817277273105231, -0.204215321526615, -0.280746382175004,
    -0.319748198891912, -0.318839637675066, -0.346791704585694,
    -0.680858316482058, 0.112546264990932, 0.638516918399206,
    0.556227307650149, -0.149549094619738, -0.0901476474252184,
    -0.0314272288120588, 0.0594285832238709, 0.0785867343964528,
    0.126531869912634, 0.115344796918859, 0.183217693464862,
    0.163894193990623, 0.162198493812758, 0.106799415384204,
    0.109314043840205, 0.039603794069169, -0.0171925190894075,
    -0.0379071720667663, -0.0926771979192517, -0.125253415978965,
    -0.130401583734828, -0.0977251095986251, -0.0934734674925854,
    -0.683616810254247, 0.117538151789886, 0.55622730765015,
    0.679340900017709, -0.105294697611617, -0.0365742456166672,
    0.0072290114551591, 0.0759677008568446, 0.102238529018836,
    0.0914408551091774, 0.0917917075151983, 0.110113392915614,
    0.0251287873829862, 0.0712284135539027, 0.00420927820895315,
    0.138413432144903, 0.0519845825338026, -0.0183348782823596,
    -0.0449069366586222, -0.118088511396914, -0.163969226310945,
    -0.146443105973786, -0.155948004456154, -0.155717037163534,
    0.377412685416275, -0.278500464239846, -0.149549094619738,
    -0.105294697611618, 8.01906586668495, -2.27352940533633,
    0.45239432853495, -0.433803454982267, -0.321923610858328,
    -0.318990687433886, -0.433465009208203, -0.525137481608645,
    -0.506872937415426, -0.438726607538563, -0.289330429361372,
    -0.318378214065367, -0.101315898912012, 0.0702660843270244,
    0.125057219633613, 0.2769143210106, 0.359103233667746,
    0.354041831289896, 0.282213763036391, 0.281665967664165,
    0.162104128449962, -0.106503131214755, -0.0901476474252181,
    -0.0365742456166671, -2.27352940533632, 2.37285683619595,
    -0.213131606980922, 0.767615270864913, 0.45140474706449,
    0.349810131981814, 0.213475199524978, 0.508125482025884,
    0.103391649249744, -0.128745904515542, -0.0765211944825074,
    -0.14210598704292, -0.0700821910069956, -0.00835991045569704,
    0.0238183516288048, 0.114417262260653, 0.189728622537479,
    0.1859026399357, 0.137259047130605, 0.138169217600521,
    0.0284282197471565, -0.0142727895051469, -0.0314272288120594,
    0.00722901145515861, 0.45239432853495, -0.213131606980925,
    1.48167014860297, 0.358254593363372, 0.821714985190383,
    0.435917484658345, 0.483749368795539, 0.794954101917704,
    0.324483058344503, 0.0820494696682664, 0.0547331327769316,
    0.0486413023665632, -0.000893288118834948, -0.0422342223315039,
    -0.0525140148744463, -0.0607809292570511, -0.0402549081797533,
    0.0356219564069622, 0.00604280956565075, 0.0117467988521824,
    -0.170886673387627, 0.119693314820499, 0.0594285832238702,
    0.0759677008568449, -0.433803454982266, 0.767615270864913,
    0.358254593363373, 1.13763489477576, 0.451943034662882,
    0.597170540589345, 0.419838151190159, 0.780586637924992,
    0.403663838323704, 0.203586408121847, 0.0871329612292375,
    0.109134911376121, 0.0232034159348934, -0.0477316317501318,
    -0.0695234156209474, -0.112765387491885, -0.112306705383561,
    -0.0376954736643469, -0.0615606161698961, -0.0647075752932795,
    -0.194448131082812, 0.122566162544252, 0.0785867343964518,
    0.102238529018836, -0.321923610858328, 0.451404747064489,
    0.821714985190384, 0.451943034662882, 1.30968147581624,
    0.280173059312136, 0.785275069851208, 0.944589724869548,
    0.582120239085169, 0.251692801313291, 0.177417447612862,
    0.236534565581584, 0.063697071092112, -0.0798064294015515,
    -0.128298735246426, -0.232002717105217, -0.259819418835401,
    -0.132041678675547, -0.144238622217655, -0.135794945401223,
    -0.235607054710811, 0.141792166493477, 0.126531869912634,
    0.0914408551091777, -0.318990687433885, 0.349810131981813,
    0.435917484658346, 0.597170540589345, 0.280173059312136,
    1.40453967538731, -0.0549248400788445, 0.887407266694885,
    0.182255134228699, 0.44876824071208, 0.0819989625257823,
    0.195295673825192, 0.0572040232059282, -0.0577601415985759,
    -0.09986577100187, -0.199632793168151, -0.245270473624566,
    -0.071594291206518, -0.0275251080861387, -0.0486598136301801,
    -0.334637151301396, 0.258713037741001, 0.115344796918858,
    0.0917917075151987, -0.433465009208205, 0.213475199524978,
    0.483749368795539, 0.419838151190159, 0.785275069851208,
    -0.0549248400788439, 1.62111742405635, 0.489616865304753,
    1.19779245625055, 0.0892464546337603, 0.446642767986137,
    0.34570878083834, 0.130478144837288, -0.0410385359578811,
    -0.100929223732173, -0.277310119566828, -0.401938968295842,
    -0.433555535429798, -0.425894949004986, -0.422397788871241,
    -0.298355349820222, 0.167091968978497, 0.18321769346486,
    0.110113392915613, -0.525137481608645, 0.508125482025883,
    0.794954101917703, 0.780586637924992, 0.944589724869547,
    0.887407266694884, 0.489616865304751, 2.00741767223713,
    -0.341867060574754, 1.35779003650178, 0.290856050655419,
    0.357337142424838, 0.13148384296731, -0.0486525097265586,
    -0.111064872524035, -0.295277046615757, -0.433706834878977,
    -0.484441193814012, -0.171094901190814, -0.0593737345467254,
    -0.598813240305986, 0.548140901913199, 0.16389419399062,
    0.0251287873829865, -0.506872937415427, 0.103391649249744,
    0.324483058344504, 0.403663838323703, 0.582120239085168,
    0.182255134228698, 1.19779245625054, -0.341867060574751,
    3.99861269607432, -2.00886429180448, 0.881002722046794,
    0.356715486780007, 0.114035128649945, -0.081859095815927,
    -0.144619951057461, -0.29572669309598, -0.350426493349162,
    -0.371609126526997, -0.613212031156679, -0.829918754600024,
    -0.484066776146489, 0.402802042938446, 0.162198493812755,
    0.0712284135539022, -0.438726607538561, -0.128745904515543,
    0.0820494696682656, 0.203586408121846, 0.251692801313291,
    0.448768240712079, 0.0892464546337585, 1.35779003650177,
    -2.00886429180448, 5.69767997552633, -0.950166465577867,
    0.386516976943115, 0.162579206564945, -0.0135283061654258,
    -0.0788824543667668, -0.297040770247142, -0.492669425332621,
    -0.562105275521641, -0.341961974289066, -0.336529822591599,
    -0.222539433922648, 0.176247371186237, 0.106799415384203,
    0.0042092782089533, -0.289330429361373, -0.0765211944825078,
    0.0547331327769319, 0.0871329612292375, 0.177417447612863,
    0.0819989625257824, 0.446642767986138, 0.29085605065542,
    0.881002722046795, -0.950166465577866, 2.43458440656306,
    0.225417044852558, 0.100628997996125, 0.00778427056629371,
    -0.0196130120822873, -0.124385518181094, -0.214499024431833,
    -0.511121699992081, -0.620166616003633, -0.60645532848849,
    -0.343523840336231, 0.253097604219116, 0.109314043840204,
    0.138413432144904, -0.318378214065368, -0.14210598704292,
    0.0486413023665631, 0.109134911376121, 0.236534565581584,
    0.195295673825192, 0.34570878083834, 0.357337142424838,
    0.356715486780007, 0.386516976943115, 0.225417044852558,
    0.39392854398882, 0.127125584382261, -0.0886497989809537,
    -0.161435653471641, -0.34944548551855, -0.449697110002955,
    -0.376881691271306, -0.321387399770619, -0.313722205092763,
    -0.124699240656557, 0.0912014747571047, 0.0396037940691688,
    0.0519845825338027, -0.101315898912011, -0.0700821910069957,
    -0.000893288118835158, 0.0232034159348933, 0.063697071092112,
    0.0572040232059281, 0.130478144837288, 0.13148384296731,
    0.114035128649945, 0.162579206564945, 0.100628997996125,
    0.127125584382261, 0.0574406818774124, -0.00173302682023446,
    -0.0287499587058463, -0.104275328896744, -0.161636207057517,
    -0.160756204797398, -0.130142697810604, -0.13018206203756,
    0.0511301117304161, -0.038017730487787, -0.0171925190894076,
    -0.01833487828236, 0.0702660843270248, -0.0083599104556969,
    -0.0422342223315041, -0.0477316317501321, -0.0798064294015518,
    -0.057760141598576, -0.0410385359578815, -0.0486525097265592,
    -0.0818590958159274, -0.0135283061654262, 0.00778427056629371,
    -0.0886497989809539, -0.00173302682023456, 0.0682701229991469,
    0.0825822726440073, 0.0985048806897502, 0.0706692739185619,
    -0.000645718260510867, 0.0195562281836991, 0.0117075505963419,
    0.112522894520982, -0.0817277273105231, -0.0379071720667655,
    -0.044906936658622, 0.125057219633614, 0.0238183516288047,
    -0.0525140148744461, -0.0695234156209473, -0.128298735246425,
    -0.0998657710018698, -0.100929223732172, -0.111064872524035,
    -0.144619951057461, -0.0788824543667667, -0.0196130120822869,
    -0.161435653471641, -0.0287499587058462, 0.0825822726440071,
    0.117052981020959, 0.17162156214383, 0.155502600429989,
    0.0424939853288228, 0.0710929826375929, 0.0587657751998833,
    0.282177537241414, -0.204215321526614, -0.0926771979192491,
    -0.118088511396912, 0.276914321010599, 0.114417262260653,
    -0.0607809292570516, -0.112765387491884, -0.232002717105217,
    -0.19963279316815, -0.277310119566827, -0.295277046615757,
    -0.295726693095979, -0.297040770247141, -0.124385518181093,
    -0.349445485518549, -0.104275328896744, 0.0985048806897497,
    0.17162156214383, 0.342091764619944, 0.401295877515778,
    0.209313810556492, 0.220115583303013, 0.210671136673818,
    0.387281538045201, -0.280746382175005, -0.125253415978966,
    -0.163969226310947, 0.359103233667747, 0.18972862253748,
    -0.040254908179753, -0.112306705383561, -0.259819418835401,
    -0.245270473624566, -0.401938968295843, -0.433706834878978,
    -0.350426493349163, -0.492669425332622, -0.214499024431833,
    -0.449697110002955, -0.161636207057517, 0.0706692739185617,
    0.15550260042999, 0.40129587751578, 0.587032652011506,
    0.368781744389901, 0.258422103020345, 0.320444922617658,
    0.418871839073582, -0.319748198891913, -0.130401583734826,
    -0.146443105973786, 0.354041831289896, 0.185902639935701,
    0.035621956406963, -0.0376954736643463, -0.132041678675547,
    -0.0715942912065177, -0.433555535429798, -0.484441193814012,
    -0.371609126526998, -0.562105275521643, -0.511121699992081,
    -0.376881691271307, -0.160756204797398, -0.000645718260511014,
    0.0424939853288234, 0.209313810556494, 0.3687817443899,
    1.11545557505271, 0.290647701203176, 0.0774280344372213,
    0.402617068797252, -0.318839637675066, -0.0977251095986237,
    -0.155948004456154, 0.282213763036391, 0.137259047130605,
    0.00604280956565094, -0.0615606161698963, -0.144238622217655,
    -0.0275251080861385, -0.425894949004986, -0.171094901190814,
    -0.613212031156679, -0.341961974289066, -0.620166616003633,
    -0.321387399770619, -0.130142697810604, 0.0195562281836988,
    0.0710929826375929, 0.220115583303014, 0.258422103020344,
    0.290647701203175, 1.86569693342601, 1.41062610423399,
    0.425257369102145, -0.346791704585695, -0.0934734674925844,
    -0.155717037163535, 0.281665967664164, 0.138169217600522,
    0.0117467988521817, -0.0647075752932792, -0.135794945401224,
    -0.0486598136301801, -0.422397788871241, -0.0593737345467268,
    -0.829918754600025, -0.3365298225916, -0.60645532848849,
    -0.313722205092763, -0.13018206203756, 0.0117075505963417,
    0.0587657751998836, 0.210671136673819, 0.320444922617657,
    0.077428034437221, 1.41062610423399, 3.20765551205844
    ]).reshape(24, 24, order="F")

mpg_bs.Vp = np.array([
    1.226257739946, -0.598954657895286, -0.693991747115123,
    -0.693738296346539, 0.404255923420743, 0.152502921378066,
    0.00918450889439832, -0.209302670605415, -0.240267712628183,
    -0.262649114511732, -0.365619814022882, -0.327688080888645,
    -0.677140166341306, -0.482724236080649, -0.237502268332879,
    -0.394504397805591, -0.124407237788995, 0.0889824986249079,
    0.166767589068027, 0.334266702799051, 0.407758566331903,
    0.47826420385775, 0.385179621333107, 0.448761523202594,
    -0.598954657895286, 0.53430888394443, 0.121729206748625,
    0.124279255191775, -0.304552854849217, -0.0916575260440732,
    0.0065056153509031, 0.150496284941485, 0.162046172228289,
    0.162469531644191, 0.286540735503703, 0.191866647181026,
    0.613174101669279, 0.400604659764261, 0.188505316042605,
    0.296392591782633, 0.0853113158261075, -0.0756702387932951,
    -0.125698012402281, -0.246372406481652, -0.300946575673317,
    -0.369984827436232, -0.300763838199813, -0.36676854858092,
    -0.693991747115123, 0.121729206748625, 0.644395132027891,
    0.560069134869483, -0.154206546410626, -0.0936367010188792,
    -0.0316633843634197, 0.0722647584400985, 0.0888778951412027,
    0.136117294041357, 0.119855730051766, 0.191533981589997,
    0.18839422518101, 0.161358399661349, 0.111490691845143,
    0.122188815638708, 0.0452150644285857, -0.0220226812226592,
    -0.0556777449240322, -0.106839588557335, -0.124419677875331,
    -0.15802574281452, -0.0722707700506129, -0.105116727222253,
    -0.693738296346539, 0.124279255191775, 0.560069134869483,
    0.6841791124165, -0.107031678165138, -0.0412583559665033,
    0.00896442684349225, 0.0844786906931047, 0.113582954198454,
    0.0990000691857173, 0.100538046096834, 0.115895712613785,
    0.0397115077690524, 0.074237842466752, 0.00737613155330012,
    0.150345634380864, 0.0566752746370431, -0.0212778570711782,
    -0.0563304001336339, -0.13372261621447, -0.171318995103557,
    -0.141228583028678, -0.192417498343195, -0.152318039573587,
    0.404255923420743, -0.304552854849217, -0.154206546410626,
    -0.107031678165138, 11.9670976422831, -3.61736029523771,
    1.34326036379293, -0.494153536158182, 0.0834074623603979,
    -0.226433455900482, -0.192957457020386, -0.209244998351617,
    -0.379519786733706, -0.389683690480388, -0.230781621465011,
    -0.316949554505238, -0.0794032910847186, 0.0892123902485899,
    0.134636493675703, 0.25972163924313, 0.34046358953534,
    0.359567685263677, 0.241143867637169, 0.283588971081093,
    0.152502921378066, -0.0916575260440732, -0.0936367010188792,
    -0.0412583559665033, -3.61736029523771, 2.970388896856,
    -0.526929630639825, 0.882729262382722, 0.311472631824992,
    0.378478323406872, 0.140426378273093, 0.456737474558485,
    0.0613966244883271, -0.122964335843988, -0.0922074692604644,
    -0.128708029908938, -0.124621699881393, -0.0591566177055406,
    0.0184560491961697, 0.113879979649421, 0.164485847186027,
    0.18744932016437, 0.127614304692519, 0.147051420502851,
    0.00918450889439832, 0.0065056153509031, -0.0316633843634197,
    0.00896442684349225, 1.34326036379293, -0.526929630639825,
    1.81242957779768, 0.322362109775063, 1.0323933349731,
    0.457360886283924, 0.600444054321793, 0.91370612119665,
    0.434301465723446, 0.088055761039491, 0.0848436101740658,
    0.12744269016312, -0.0422129416844794, -0.135413959815355,
    -0.118116683956611, -0.140107289290965, -0.104129953113642,
    -0.0176599234366945, -0.0234972191406761, -0.00396736798305567,
    -0.209302670605415, 0.150496284941485, 0.0722647584400985,
    0.0844786906931047, -0.494153536158182, 0.882729262382722,
    0.322362109775063, 1.27384764314234, 0.436524282156763,
    0.700073089805124, 0.42086785868429, 0.839439528040047,
    0.457304590724931, 0.226988664621102, 0.0985281278677041,
    0.149735868306737, 0.00757050756523659, -0.0912854085559435,
    -0.113724893986152, -0.155881623417337, -0.140317119716309,
    -0.0713406095842423, -0.0716633370687491, -0.0803273684693989,
    -0.240267712628183, 0.162046172228289, 0.0888778951412027,
    0.113582954198454, 0.0834074623603979, 0.311472631824992,
    1.0323933349731, 0.436524282156763, 1.53314803627766, 0.25417552361178,
    0.924685362467373, 1.02972297718702, 0.744949808908217,
    0.233388656964272, 0.217427541094708, 0.336055700676656,
    0.03743876914053, -0.176903580046802, -0.226786128357071,
    -0.334988155952527, -0.319776388666983, -0.219028256501927,
    -0.17608697725841, -0.170430448469263, -0.262649114511732,
    0.162469531644191, 0.136117294041357, 0.0990000691857173,
    -0.226433455900482, 0.378478323406872, 0.457360886283924,
    0.700073089805124, 0.25417552361178, 1.5644915898195,
    -0.0975959025442556, 0.97584002950171, 0.168966508584049,
    0.522744745835193, 0.0695516714823915, 0.233037922998919,
    0.0395396435819605, -0.095915399510004, -0.131051837524492,
    -0.237143604722523, -0.301242506702221, -0.0532025767899828,
    -0.0391505765515488, -0.0655180027477513, -0.365619814022882,
    0.286540735503703, 0.119855730051766, 0.100538046096834,
    -0.192957457020386, 0.140426378273093, 0.600444054321793,
    0.42086785868429, 0.924685362467373, -0.0975959025442556,
    1.75709614368116, 0.519892887281196, 1.34059888676236,
    0.0494466626673817, 0.484653667289698, 0.4084580005862,
    0.114791375213036, -0.095987442819961, -0.154931741342113,
    -0.33903979770467, -0.45909753833617, -0.453485705029258,
    -0.522724292505745, -0.433667169565367, -0.327688080888645,
    0.191866647181026, 0.191533981589997, 0.115895712613785,
    -0.209244998351617, 0.456737474558485, 0.91370612119665,
    0.839439528040047, 1.02972297718702, 0.97584002950171,
    0.519892887281196, 2.13968207395045, -0.336164257008457,
    1.46238357432731, 0.283248342097559, 0.418961909633758,
    0.100598943813762, -0.113838923311929, -0.163977417541771,
    -0.348791715965874, -0.506114865794541, -0.545497271000249,
    -0.0923819541519448, -0.0813491527908169, -0.677140166341306,
    0.613174101669279, 0.18839422518101, 0.0397115077690524,
    -0.379519786733706, 0.0613966244883271, 0.434301465723446,
    0.457304590724931, 0.744949808908217, 0.168966508584049,
    1.34059888676236, -0.336164257008457, 4.35482101642386,
    -2.21992012490562, 0.9807810786271, 0.462108282803803,
    0.102236590809152, -0.17410468003079, -0.266734242517673,
    -0.42033089744795, -0.347661934619728, -0.575867027882068,
    -0.498450427127264, -0.934477998886557, -0.482724236080649,
    0.400604659764261, 0.161358399661349, 0.074237842466752,
    -0.389683690480388, -0.122964335843988, 0.088055761039491,
    0.226988664621102, 0.233388656964272, 0.522744745835193,
    0.0494466626673817, 1.46238357432731, -2.21992012490562,
    5.99371147921815, -1.04859890355395, 0.398421384908712,
    0.156461542733891, -0.019434665724302, -0.0755469444958039,
    -0.280486183344505, -0.58136563218615, -0.484634147345514,
    -0.356292120764518, -0.321958833095722, -0.237502268332879,
    0.188505316042605, 0.111490691845143, 0.00737613155330012,
    -0.230781621465011, -0.0922074692604644, 0.0848436101740658,
    0.0985281278677041, 0.217427541094708, 0.0695516714823915,
    0.484653667289698, 0.283248342097559, 0.9807810786271,
    -1.04859890355395, 2.48580346896528, 0.24501910446873,
    0.0969773944957306, -0.0119475871587249, -0.0484689252547535,
    -0.149760547646666, -0.199911474519641, -0.552166680756775,
    -0.678892603460011, -0.5732539695505, -0.394504397805591,
    0.296392591782633, 0.122188815638708, 0.150345634380864,
    -0.316949554505238, -0.128708029908938, 0.12744269016312,
    0.149735868306737, 0.336055700676656, 0.233037922998919,
    0.4084580005862, 0.418961909633758, 0.462108282803803,
    0.398421384908712, 0.24501910446873, 0.498918611844292,
    0.101227030650827, -0.178108615875722, -0.244469114785688,
    -0.433333724585524, -0.51389265638907, -0.438018959207985,
    -0.33953374106696, -0.343184385441028, -0.124407237788995,
    0.0853113158261075, 0.0452150644285857, 0.0566752746370431,
    -0.0794032910847186, -0.124621699881393, -0.0422129416844794,
    0.00757050756523659, 0.03743876914053, 0.0395396435819605,
    0.114791375213036, 0.100598943813762, 0.102236590809152,
    0.156461542733891, 0.0969773944957306, 0.101227030650827,
    0.11580938727038, 0.0398795020188062, -0.0127386826369836,
    -0.078440365893966, -0.126321924455581, -0.142568428815273,
    -0.128344286246162, -0.12956213066101, 0.0889824986249079,
    -0.0756702387932951, -0.0220226812226592, -0.0212778570711782,
    0.0892123902485899, -0.0591566177055406, -0.135413959815355,
    -0.0912854085559435, -0.176903580046802, -0.095915399510004,
    -0.095987442819961, -0.113838923311929, -0.17410468003079,
    -0.019434665724302, -0.0119475871587249, -0.178108615875722,
    0.0398795020188062, 0.193099358293502, 0.160470436488742,
    0.175008323309716, 0.136917954502474, 0.0674161405311557,
    0.0279662107609871, 0.0326656898702012, 0.166767589068027,
    -0.125698012402281, -0.0556777449240322, -0.0563304001336339,
    0.134636493675703, 0.0184560491961697, -0.118116683956611,
    -0.113724893986152, -0.226786128357071, -0.131051837524492,
    -0.154931741342113, -0.163977417541771, -0.266734242517673,
    -0.0755469444958039, -0.0484689252547535, -0.244469114785688,
    -0.0127386826369836, 0.160470436488742, 0.226474480900493,
    0.241440219382646, 0.201381320129549, 0.122080977992512,
    0.081142778241122, 0.0898255256880958, 0.334266702799051,
    -0.246372406481652, -0.106839588557335, -0.13372261621447,
    0.25972163924313, 0.113879979649421, -0.140107289290965,
    -0.155881623417337, -0.334988155952527, -0.237143604722523,
    -0.33903979770467, -0.348791715965874, -0.42033089744795,
    -0.280486183344505, -0.149760547646666, -0.433333724585524,
    -0.078440365893966, 0.175008323309716, 0.241440219382646,
    0.46452011571498, 0.431899381842666, 0.29910894777825,
    0.240131184980999, 0.241496481383994, 0.407758566331903,
    -0.300946575673317, -0.124419677875331, -0.171318995103557,
    0.34046358953534, 0.164485847186027, -0.104129953113642,
    -0.140317119716309, -0.319776388666983, -0.301242506702221,
    -0.45909753833617, -0.506114865794541, -0.347661934619728,
    -0.58136563218615, -0.199911474519641, -0.51389265638907,
    -0.126321924455581, 0.136917954502474, 0.201381320129549,
    0.431899381842666, 0.744405673993396, 0.24778593600495,
    0.4134406891463, 0.339886403782703, 0.47826420385775,
    -0.369984827436232, -0.15802574281452, -0.141228583028678,
    0.359567685263677, 0.18744932016437, -0.0176599234366945,
    -0.0713406095842423, -0.219028256501927, -0.0532025767899828,
    -0.453485705029258, -0.545497271000249, -0.575867027882068,
    -0.484634147345514, -0.552166680756775, -0.438018959207985,
    -0.142568428815273, 0.0674161405311557, 0.122080977992512,
    0.29910894777825, 0.24778593600495, 1.6826091216262,
    -0.575046038411989, 0.249267438526421, 0.385179621333107,
    -0.300763838199813, -0.0722707700506129, -0.192417498343195,
    0.241143867637169, 0.127614304692519, -0.0234972191406761,
    -0.0716633370687491, -0.17608697725841, -0.0391505765515488,
    -0.522724292505745, -0.0923819541519448, -0.498450427127264,
    -0.356292120764518, -0.678892603460011, -0.33953374106696,
    -0.128344286246162, 0.0279662107609871, 0.081142778241122,
    0.240131184980999, 0.4134406891463, -0.575046038411989,
    4.04150194703527, 0.746794237585425, 0.448761523202594,
    -0.36676854858092, -0.105116727222253, -0.152318039573587,
    0.283588971081093, 0.147051420502851, -0.00396736798305567,
    -0.0803273684693989, -0.170430448469263, -0.0655180027477513,
    -0.433667169565367, -0.0813491527908169, -0.934477998886557,
    -0.321958833095722, -0.5732539695505, -0.343184385441028,
    -0.12956213066101, 0.0326656898702012, 0.0898255256880958,
    0.241496481383994, 0.339886403782703, 0.249267438526421,
    0.746794237585425, 3.59868564812178
    ]).reshape(24, 24, order="F")

mpg_bs.rV = np.array([
    -0.0297518795017788, -0.0279144173114223, -0.0184650622756606,
    -0.0101929107895547, -5.5865624793419e-05, -0.000249849893142171,
    -0.000309898734480696, -5.42025622874735e-06, -2.22599252448511e-05,
    6.60370601160911e-05, 4.41786063148996e-05, 0.000264079369629404,
    0.000312739927356773, 0.000166746800984281, 6.22512704032769e-05,
    0.00023873784102746, -0.000189663494086306, -0.000244118781964904,
    -5.82504534029272e-05, 0.000142876370789319, 0.000217254008213435,
    4.53282887363646e-05, 1.82517606339378e-05, 8.58792421331435e-06,
    0.000370322487453743, 0.000201992910699855, -0.000469164613014575,
    0.000774270041235595, -5.68115342516726e-05, -0.000380679224700556,
    -0.000422010861587262, 0.000101142157681932, 0.000187113782707615,
    0.000120435765907176, 0.000158193260135929, 0.000318437252371348,
    0.000133569503239669, 5.14508949733296e-05, 3.72708649769547e-05,
    0.0481141951754968, -0.0112467428647124, 0.0133577786074344,
    0.00971188595873735, 0.0144420339639255, 0.0153033177968391,
    0.006359918898083, 0.00184703219892869, 0.000682133802387619,
    -0.000618858940479052, -0.00012511342698143, 0.00231285339396231,
    -0.00300932642921946, 0.000227034785457444, 0.00126423894576831,
    0.00172845539987259, -1.90970302574768e-05, -0.000518679088367633,
    -0.000314832607266587, -0.000362678746564177, -0.00132787136055019,
    -0.000746870682613774, -0.000241398551814824, -0.000143617623861035,
    -0.00996822090390736, -0.0382661384394529, 0.0513779162167389,
    -0.0396501876325656, -0.00490503889374995, -0.00956222014702774,
    -0.00419055937855679, -0.00120170608842117, -0.000442360718664101,
    0.00823791090945297, 0.00500218745429801, -0.0517063795773348,
    0.0587814382937658, -0.00240356824834935, -0.0116880128887736,
    -0.015836689892777, -0.00705290752700762, -0.0039889034038224,
    0.00281650986526543, 0.00772245566351641, 0.0200045321896821,
    0.00964527245902078, 0.00407247631168687, 0.00331966549593053,
    -0.00966284279156194, -0.0244550895551929, -0.0152784731227065,
    -0.00892356302821995, 0.00598614795507797, 0.0158743389962298,
    0.00817417514516272, 0.00287736815670271, 0.00110289732817891,
    -0.00103701249016703, -0.000122137810058872, 0.00491339128850968,
    -0.00573539965315568, -0.000796427359226435, -0.00388683923076641,
    -0.00364002687200746, 0.00340316885739129, 0.00523232146797231,
    0.000284396807821315, -0.0011396146450857, -0.0013542090929267,
    -0.000300937391353895, -0.000115763147393071, -0.000113504718932038,
    -0.0103409915589158, -0.0589537326887811, 0.000653338095905729,
    0.0678869795656213, -0.0576789285604959, 0.00122346111634506,
    -0.00217093925795169, -0.000950153161210469, -0.000423266456563166,
    0.000873934414598948, 0.00266494641426755, -0.0160583032713915,
    0.0167861190077875, 0.00321515210369582, 0.0158650063077605,
    0.0144562648728826, -0.013440701985568, -0.0245813860385962,
    -0.00906420988685205, 0.00147317779331179, 0.0113275107771079,
    0.00436237793605965, 0.00281967623170031, 0.00331841030626531,
    0.00926071280185207, 0.0652218789424438, 0.0488676855220674,
    -0.0072693899726496, -0.0844631836304519, 0.0520383960295573,
    0.0176119917063159, 0.0050650149241255, 0.00173077764428115,
    -0.0178422395520497, 0.0122414128180879, 0.0530935081682878,
    -0.0700498524474214, -0.00205958513348335, -0.0151068167123392,
    -0.0306537850616411, -0.0330147097107778, -0.0291440083012776,
    0.0131315762801279, 0.0479834543078199, 0.0494812459172924,
    -0.00647839147888454, -0.00707071034488417, -0.00646049648120873,
    -0.00466121288355426, -0.0485035049559369, -0.0749934388385525,
    -0.0682272537597176, -0.0210539362448509, 0.103013289479923,
    0.0200363284031645, -0.00191733491201945, -0.00488933018302833,
    0.0021827419970009, 0.011596465584245, -0.0155626706843001,
    -0.00907106241734132, -0.0122285794757302, -0.0645401411913822,
    -0.0840936295641952, 0.0442913399580051, 0.142338108122544,
    0.0765593704205363, 0.0182446328667233, -0.0695935839925863,
    -0.0356318919794637, -0.00586377697109934, -0.000387720862907859,
    -0.0219182358925276, 0.0350060947556832, 0.035455153691358,
    -0.0031346913093081, -0.00606431483213071, 0.0744278437298835,
    -0.0182229735631128, -0.00495131827816417, -0.00206650282892026,
    -0.0969804831618052, 0.180887878378089, -0.0859863312102999,
    -0.0609843554208379, 0.00613665590152679, 0.0296030378774339,
    0.0222065834111922, -0.0578738162737623, -0.00993826601192342,
    0.0247694369149481, 0.0422289709919424, 0.00870315910426681,
    -0.0486402858772571, -0.0339176010353395, -0.00725340819016587,
    -0.0277893072125588, 0.00738941478298226, 0.0360521314155386,
    0.0453211474077115, 0.0414500649801317, -0.0160358299801778,
    0.024230734733359, 0.0112559983037238, 0.00198150289794027,
    0.0109534489965432, -0.0247890865548996, -0.0123156930059525,
    0.0511677755860601, 0.0152213730389165, 0.0828149195741336,
    0.097348221323021, -0.0623669711182891, -0.039401135913146,
    0.117141213376684, 0.0779973249031316, -0.167651800783608,
    -0.0541136339904111, 0.013955651874827, 0.0203115237423255,
    0.0300361102737562, -0.0341507246067295, -0.0570717986255995,
    -0.0329428638477796, -0.0291234190210299, 0.0135950582743237,
    -0.0694590225085228, -0.00876695808804125, -0.00155150163487863,
    -0.0415052621951564, 0.0855413818045413, -0.0567489326054377,
    -0.0124458922312971, -0.00849044899817017, -0.020202207151624,
    0.0791647388775217, 0.184676364774685, -0.00395852520670578,
    -0.11284909647847, -0.0836319344577794, -0.0813903370310093,
    -0.0387960849097079, 0.00490532414058196, 0.0302521473022626,
    0.0308252615863213, -0.0365395275622032, -0.0797417067400042,
    -0.074085098207374, -0.0482177700552885, 0.0419597883633913,
    -0.00238151885267258, 0.00195645701970412, 0.00191752776718316,
    0.0220696134622902, -0.032189920392082, 0.00758470649527134,
    0.00885780502368493, -0.0328712034530519, -0.116584971692872,
    0.0126625346626522, 0.18030014524035, -0.174387401016797,
    0.0280216194648148, 0.206880690893945, 0.0111317590905542,
    -0.0604125476723619, -0.0402701113502636, -0.0411940611934523,
    -0.0292431192114974, 0.0287905486343225, 0.0603522262221798,
    0.05380622472953, 0.0381256769879428, -0.00877866079967804,
    -0.0114198930646073, 0.00290846811747617, -0.00936224527565544,
    -0.00280843716449172, -0.00498629441063645, 0.0179721340474412,
    -0.00861873414462067, 0.00565208536719023, -0.0144866624993919,
    -0.0744953444072861, 0.00894509365512418, 0.0188715647674098,
    0.0196999853322494, 0.0901680207441546, -0.0749065688345394,
    -0.00838753112833702, 0.0531697564511473, 0.136959461408073,
    0.043435117577396, -0.000485715784516, -0.0344794393341381,
    -0.0460327568324399, -0.0675385675778985, -0.146473249882646,
    0.278372094764221, 0.120489449499735, 0.0188465131812548,
    0.0715025240762291, 0.00799416409681597, -0.105021738754416,
    -0.0426408431374772, 0.0331758188834319, 0.0290793232106494,
    -0.152422969531859, -0.00411226278463431, 0.0169944032769387,
    -0.0129986174021856, 0.0347047561592154, 0.0623646729345188,
    -0.118206811803022, -0.140694522708572, -0.140683762744576,
    0.158094209672232, 0.0203620052526992, -0.0727348020063609,
    -0.0884287943888251, -0.151955239271556, -0.178956415657029,
    -0.099476919504814, -0.0320494342177646, -0.0236748823993347,
    -0.154971928176839, -0.0330459295223386, 0.173731829954425,
    0.217169238800757, 0.054629549842133, 0.164557995022997,
    -0.0388578143313742, -0.00960551120542888, 0.147879602189961,
    -0.272183551848361, 0.176820407653075, 0.0079050431715667,
    -0.183982203945459, -0.0775309023980952, -0.0135909620051159,
    -0.033800534622957, -0.00767215662608992, 0.0139341286859032,
    0.0215587946038859, 0.0361091178670791, 0.0433219068631611,
    -0.000962112014663084, 0.0162979158854552, -0.0476608330744487,
    0.0628596343632427, 0.0333630844392246, -0.0844837951002203,
    -0.114740877395659, 0.150283648331406, 0.280085162961297,
    -0.282164998837566, 0.124839802199115, -0.0933873943147368,
    -0.0824336720662143, 0.102655758878417, -0.0583274276749742,
    0.142228337313126, 0.171933875689057, 0.135946640527651,
    -0.0271990653138554, 0.0020746672622744, 0.0280363329077379,
    0.0361726682845661, 0.0480894942387795, 0.0514325292442759,
    -0.140942452660974, -0.0230057637890896, 0.0922577554817711,
    -0.262236828942001, 0.0740944233948668, 0.197601525405761,
    0.207334066529231, 0.0946452985476689, 0.118327385420593,
    -0.186208569630427, 0.172171406366479, -0.168836309107086,
    0.296396954609535, -0.228737880107238, 0.0103931906647384,
    0.0340260435380178, -0.0826979747389254, -0.105218425287459,
    0.0115530411165066, 0.0021601328799856, -0.00794017743252516,
    -0.0160157183232517, -0.0217791382952013, -0.0210064613984729,
    0.0604954298804515, -0.0134611171569919, 0.0107077476297973,
    0.0192096848992328, -0.0359539928007615, 0.0184131758362472,
    0.00718334337401242, -0.00513274287181537, -0.0395478786695696,
    -0.0338833714451987, -0.0101066402795655, -0.0702469691868337,
    0.0899019452166869, -0.130857170784601, 0.194797566536871,
    -0.293985247792722, -0.127956937593321, 0.538381198123075,
    0.0132062121841276, 0.0166577109173017, 0.0204570452515256,
    0.0210302553780223, 0.00948829280246407, -0.00259466527516782,
    -0.169050776708552, 0.0176449742622338, -0.0277900221053683,
    -0.177046985121443, 0.0823278124705666, 0.111508059634237,
    0.0974492057959729, -0.0803727412741088, -0.256237431105662,
    -0.0589818545148105, -0.137232151521597, -0.0356995098286272,
    -0.101362799946221, 0.0644887385614398, -0.0672851177363907,
    0.0652912510995767, 0.0426358861206711, 0.0600691466471638,
    0.0852565075962193, 0.0328913153615828, -0.0134924524347108,
    -0.0339518938589891, -0.074055543117041, -0.0878817068993808,
    -0.164392063467643, -0.118882970850557, 0.567291815602786,
    0.147055341317559, -0.0948604513437437, -0.0732028485321263,
    -0.0481401820760952, 0.0538839024444461, 0.241400054042709,
    0.16755779144261, 0.159482918490435, 0.14059723990491,
    0.122190788139167, 0.0330484822016492, 0.155417089643274,
    -0.123967330958311, -0.133730317847849, 0.0123153144117149,
    -0.0572155235331402, -0.0322422402398889, -0.00516798160954242,
    0.0112436179619514, 0.0389807303731987, 0.0330850630219065,
    0.327209565123676, -0.530425233903229, 0.32825889338139,
    -0.0476988900717266, 0.0370773036879646, 0.00647572364840762,
    0.0274282286286442, -0.0482426726846349, -0.211521604729665,
    -0.264316078930412, -0.218782113040786, -0.251492880093616,
    -0.193646739359928, -0.0968005854286071, -0.305314578727092,
    -0.0974925243314355, 0.121045535316297, 0.072269403918501,
    0.0019236279382869, 0.0268726912598391, 0.0370657911406326,
    0.0297657267836094, 0.017596390730566, -0.021527152312842,
    0.147079124119788, -0.632808359857734, -0.380412144540749,
    -0.277096815862218, 0.191496518567932, 0.110751871116004,
    0.104890944779502, 0.151215885925301, -0.0937289078155581,
    0.274319394407329, 0.198603116965817, 0.329834669046153,
    0.227801827008104, 0.33668362438987, 0.454974005598239,
    0.229550331629555, 0.607282526089242, 0.149507241400591,
    0.229720790556087, 0.0621158786424302, -0.0595549536705348,
    -0.0938159474177122, -0.191483104083124, -0.252967102522184,
    -0.219249991152887, -0.339524784291672, -0.353176242378271,
    0.0813353348970341, -0.0654587134463156, -0.0246701130782029,
    -0.0207301123061629, -0.0315039164064682, 0.0212813111780791,
    -0.0768046947818802, -0.0393295302908703, -0.116127290200662,
    0.0435247410072016, -0.245414122054282, 0.158908303150518,
    -0.816734417627416, 0.881877093561075, -0.364638309241683,
    -0.056786256722417, -0.00968527020423421, 0.0265910927732837,
    0.0380557354124225, 0.053493718904318, 0.0242576056241561,
    0.0557321652408447, 0.162137334893874, 0.217365341750675,
    0.0816311056865962, -0.0596536181056574, -0.0310250346933758,
    -0.0258598033359973, 1.57157757262447, -0.551846529931971,
    0.178630089646898, -0.121940697227273, -0.025984796272873,
    -0.0676047713589873, -0.0647127382787066, -0.0818438736871805,
    -0.0939009139216642, -0.0902348993636832, -0.0508630584433755,
    -0.0609219372551081, -0.013009064200119, 0.0192798284833754,
    0.0264362938415028, 0.0497024606324435, 0.0643121575768081,
    0.0663163083142627, 0.0640123302445087, 0.0750880869238639
    ]).reshape(24, 24, order="F")

mpg_bs.gcv_ubre = 5.16162045425616
mpg_bs.aic = 909.585145453506
mpg_bs.rank = 24
mpg_bs.gcv_ubre_dev = 5.16162045425363
mpg_bs.method = "GCV"
mpg_bs.cmX = np.array([
    1, 0.901477832512315, 0.58128078817734, 0.374384236453202, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    ])
mpg_bs.assign = np.array([
    0, 1, 2, 2
    ])
mpg_bs.offset = np.array([
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    ])
mpg_bs.df_residual = 185.099985812547
mpg_bs.min_edf = 6
mpg_bs.optimizer = "magic"
mpg_bs.p_coeff = np.array([
    29.6272774569595, -6.21365498504518, 1.43986598470837, 1.01128095138012
    ])
mpg_bs.se = np.array([
    1.10736522428059, 0.730964352033962, 0.802742257532199,
    0.82715120287436, 3.45934930908735, 1.72348162068993, 1.34626504738022,
    1.128648591521, 1.23820355203725, 1.25079638223793, 1.32555503230954,
    1.46276521490991, 2.08682079164069, 2.44820576733618, 1.57664310132803,
    0.706341710395395, 0.340307783146933, 0.439430720698385,
    0.475893350342798, 0.681557125789893, 0.862789472579143,
    1.29715423972101, 2.01034871279469, 1.89702020234941
    ])
mpg_bs.p_t = np.array([
    26.7547479434413, -8.50062655963349, 1.7936840513851, 1.22260712172806
    ])
mpg_bs.p_pv = np.array([
    1.61958620027156e-65, 6.17307801841172e-15, 0.0744959485685591,
    0.223032563883354
    ])
mpg_bs.residual_df = 185.099985812547
mpg_bs.m = 2
mpg_bs.chi_sq = np.array([
    132.00007563458, 69.3539925351537
    ])
mpg_bs.s_pv = np.array([
    4.72304400617769e-18, 6.21718617954453e-12
    ])
mpg_bs.scale = 4.70648213227865
mpg_bs.r_sq = 0.890988350463498
mpg_bs.n = 203
mpg_bs.dev_expl = 0.900108639690056
mpg_bs.edf = np.array([
    10.2535689759835, 3.64644521146987
    ])
mpg_bs.dispersion = 4.70648213227865
mpg_bs.pTerms_pv = np.array([
    6.1730780184117e-15, 0.175815884801339
    ])
mpg_bs.pTerms_chi_sq = np.array([
    72.2606519063463, 3.50949117352962
    ])
mpg_bs.pTerms_df = np.array([
    1, 2
    ])
mpg_bs.cov_unscaled = np.array([
    0.260546562269068, -0.127261644910421, -0.147454452733496,
    -0.147400601308703, 0.0858934363413853, 0.0324027409627562,
    0.001951459420489, -0.0444711495173745, -0.051050382403525,
    -0.0558058242079355, -0.0776843093730959, -0.0696248432860819,
    -0.143873948165499, -0.102565827833482, -0.0504628003799288,
    -0.0838215012227384, -0.0264331690405809, 0.0189063712819891,
    0.0354335965549041, 0.0710226222907629, 0.086637653107266,
    0.101618191765279, 0.081840238740399, 0.0953496710685112,
    -0.127261644910421, 0.11352616857503, 0.025864159966478,
    0.026405976204483, -0.0647092342623571, -0.0194747421679251,
    0.0013822670878288, 0.0319763850603683, 0.034430423334006,
    0.0345203757451707, 0.0608821466756475, 0.0407664667130339,
    0.130282891645105, 0.0851176416918229, 0.0400522748720902,
    0.0629753993433594, 0.0181263443541013, -0.0160778765682171,
    -0.0267074236912963, -0.0523474645302372, -0.0639429975967239,
    -0.0786117565174105, -0.063904170832196, -0.077928384358563,
    -0.147454452733496, 0.025864159966478, 0.136916515120372,
    0.118999524300398, -0.0327647151474401, -0.0198952632533516,
    -0.00672761172219511, 0.015354304214709, 0.0188841458743991,
    0.0289212388819706, 0.0254660969027705, 0.0406957842836357,
    0.0400286710723789, 0.0342842902886422, 0.0236887528118937,
    0.0259618144092581, 0.00960697675201729, -0.00467922337824681,
    -0.0118300130244149, -0.022700519316666, -0.0264358122220455,
    -0.0335761909581523, -0.0153555815191469, -0.022334457938622,
    -0.147400601308703, 0.026405976204483, 0.118999524300398,
    0.145369533589466, -0.0227413331564733, -0.0087662833528124,
    0.00190469794456696, 0.0179494340611051, 0.0241333019028084,
    0.0210348337470021, 0.0213616121916855, 0.0246247004357953,
    0.00843762000002028, 0.0157735311385979, 0.00156722820696845,
    0.0319443758959039, 0.0120419610749916, -0.00452096841614408,
    -0.011968684582334, -0.028412434692433, -0.0364006470838577,
    -0.0300072493763622, -0.0408835076677611, -0.0323634585859656,
    0.0858934363413853, -0.0647092342623571, -0.0327647151474401,
    -0.0227413331564733, 2.54268417598119, -0.76859110341217,
    0.285406451366382, -0.104994244590691, 0.0177218270496262,
    -0.0481109774851848, -0.0409982342644028, -0.0444588957252262,
    -0.0806376771582389, -0.0827972314624984, -0.0490348449178703,
    -0.0673431972324915, -0.0168710490878408, 0.0189552170264795,
    0.0286066089048379, 0.0551838149903664, 0.0723392929084603,
    0.0763983959054345, 0.0512365416163641, 0.0602549766706101,
    0.0324027409627562, -0.0194747421679251, -0.0198952632533516,
    -0.0087662833528124, -0.76859110341217, 0.631127201457765,
    -0.111958277080447, 0.187556063652864, 0.066179499479836,
    0.0804163944044619, 0.0298368025897733, 0.0970443447402095,
    0.0130451200626575, -0.0261265914515338, -0.0195915902087622,
    -0.0273469708991807, -0.0264787364275103, -0.0125691792814477,
    0.00392141065820518, 0.0241964117675904, 0.0349487881953121,
    0.0398279043446865, 0.0271145839091361, 0.0312444446552389,
    0.001951459420489, 0.0013822670878288, -0.00672761172219511,
    0.00190469794456696, 0.285406451366382, -0.111958277080447,
    0.385092204083263, 0.0684932186535236, 0.21935562612521,
    0.0971768028496673, 0.127578101317701, 0.194137807287134,
    0.0922773004373818, 0.0187094646414516, 0.0180269695686678,
    0.0270781204690177, -0.00896910696738203, -0.028771799405471,
    -0.0250965967014997, -0.0297690048221073, -0.0221247951627148,
    -0.00375225549366836, -0.00499252275484576, -0.000842958258748316,
    -0.0444711495173745, 0.0319763850603683, 0.015354304214709,
    0.0179494340611051, -0.104994244590691, 0.187556063652864,
    0.0684932186535236, 0.270658127947807, 0.0927495887348496,
    0.148746573370328, 0.0894230227281297, 0.178358167405521,
    0.0971648415678839, 0.0482289443030786, 0.0209345589972529,
    0.031814817117821, 0.00160852784573758, -0.0193956772787635,
    -0.0241634602639173, -0.033120623649721, -0.0298135881052149,
    -0.0151579476090994, -0.015226518459989, -0.0170673905077609,
    -0.051050382403525, 0.034430423334006, 0.0188841458743991,
    0.0241333019028084, 0.0177218270496262, 0.066179499479836,
    0.21935562612521, 0.0927495887348496, 0.32575243954775,
    0.0540054156093696, 0.196470598735639, 0.21878824740985,
    0.158281660903183, 0.0495887693620706, 0.0461974644721407,
    0.0714027358930935, 0.00795472458798096, -0.0375872201518705,
    -0.0481859108317218, -0.0711759115486841, -0.0679438229402484,
    -0.0465375731482666, -0.0374137141732135, -0.03621185498621,
    -0.0558058242079355, 0.0345203757451707, 0.0289212388819706,
    0.0210348337470021, -0.0481109774851848, 0.0804163944044619,
    0.0971768028496673, 0.148746573370328, 0.0540054156093696,
    0.332412095881484, -0.0207364863609935, 0.207339580194955,
    0.0359008074045836, 0.111069102387542, 0.0147778467074979,
    0.0495142478924261, 0.00840110351440287, -0.0203794249747989,
    -0.0278449665463922, -0.0503865940754587, -0.0640058749264548,
    -0.0113041068243097, -0.00831843730650562, -0.0139208013344843,
    -0.0776843093730959, 0.0608821466756475, 0.0254660969027705,
    0.0213616121916855, -0.0409982342644028, 0.0298368025897733,
    0.127578101317701, 0.0894230227281297, 0.196470598735639,
    -0.0207364863609935, 0.373335347781393, 0.1104631596741,
    0.284840959571074, 0.0105060767846668, 0.102975779715763,
    0.0867862639453907, 0.0243900586439621, -0.0203947322272078,
    -0.0329187994318598, -0.0720367757012015, -0.0975457943816516,
    -0.0963534317742545, -0.111064756608917, -0.0921425296807421,
    -0.0696248432860819, 0.0407664667130339, 0.0406957842836357,
    0.0246247004357953, -0.0444588957252262, 0.0970443447402095,
    0.194137807287134, 0.178358167405521, 0.21878824740985,
    0.207339580194955, 0.1104631596741, 0.454624497408751,
    -0.0714258011738595, 0.310716907708582, 0.0601826022359559,
    0.089018060168629, 0.0213745513074023, -0.0241876884076926,
    -0.0348407606643524, -0.0741087942465015, -0.107535703221613,
    -0.11590339783913, -0.0196286635230926, -0.0172844920058013,
    -0.143873948165499, 0.130282891645105, 0.0400286710723789,
    0.00843762000002028, -0.0806376771582389, 0.0130451200626575,
    0.0922773004373818, 0.0971648415678839, 0.158281660903183,
    0.0359008074045836, 0.284840959571074, -0.0714258011738595,
    0.925281535981413, -0.471672910363488, 0.208389419328838,
    0.0981854960490571, 0.0217225069458946, -0.0369925296936159,
    -0.0566738032825664, -0.0893089330064972, -0.073868746305302,
    -0.12235614875335, -0.105907217560377, -0.198551268786848,
    -0.102565827833482, 0.0851176416918229, 0.0342842902886422,
    0.0157735311385979, -0.0827972314624984, -0.0261265914515338,
    0.0187094646414516, 0.0482289443030786, 0.0495887693620706,
    0.111069102387542, 0.0105060767846668, 0.310716907708582,
    -0.471672910363488, 1.27350137762369, -0.222798870596428,
    0.0846537549088317, 0.0332438408000797, -0.00412934016917062,
    -0.016051679868851, -0.059595718301114, -0.123524453263925,
    -0.10297163225623, -0.0757024271527446, -0.0684075332800308,
    -0.0504628003799288, 0.0400522748720902, 0.0236887528118937,
    0.00156722820696845, -0.0490348449178703, -0.0195915902087622,
    0.0180269695686678, 0.0209345589972529, 0.0461974644721407,
    0.0147778467074979, 0.102975779715763, 0.0601826022359559,
    0.208389419328838, -0.222798870596428, 0.52816592076634,
    0.0520599245003621, 0.0206050701500866, -0.00253853872657549,
    -0.0102983340619392, -0.0318200608092311, -0.0424757746658764,
    -0.117320466802546, -0.144246293596641, -0.121800944620384,
    -0.0838215012227384, 0.0629753993433594, 0.0259618144092581,
    0.0319443758959039, -0.0673431972324915, -0.0273469708991807,
    0.0270781204690177, 0.031814817117821, 0.0714027358930935,
    0.0495142478924261, 0.0867862639453907, 0.089018060168629,
    0.0981854960490571, 0.0846537549088317, 0.0520599245003621,
    0.106006694134147, 0.0215080027514771, -0.037843257632743,
    -0.0519430665866201, -0.0920716816523268, -0.109188273097782,
    -0.0930671671318803, -0.0721417252895369, -0.0729173883583565,
    -0.0264331690405809, 0.0181263443541013, 0.00960697675201729,
    0.0120419610749916, -0.0168710490878408, -0.0264787364275103,
    -0.00896910696738203, 0.00160852784573758, 0.00795472458798096,
    0.00840110351440287, 0.0243900586439621, 0.0213745513074023,
    0.0217225069458946, 0.0332438408000797, 0.0206050701500866,
    0.0215080027514771, 0.0246063586380409, 0.00847331422875254,
    -0.00270662509257549, -0.0166664535611419, -0.0268399881068754,
    -0.0302919303225419, -0.0272696852211407, -0.0275284441796622,
    0.0189063712819891, -0.0160778765682171, -0.00467922337824681,
    -0.00452096841614408, 0.0189552170264795, -0.0125691792814477,
    -0.028771799405471, -0.0193956772787635, -0.0375872201518705,
    -0.0203794249747989, -0.0203947322272078, -0.0241876884076926,
    -0.0369925296936159, -0.00412934016917062, -0.00253853872657549,
    -0.037843257632743, 0.00847331422875254, 0.0410283844422061,
    0.0340956221608027, 0.0371845294194256, 0.0290913575478051,
    0.0143241042112522, 0.00594206245237508, 0.00694057449961806,
    0.0354335965549041, -0.0267074236912963, -0.0118300130244149,
    -0.011968684582334, 0.0286066089048379, 0.00392141065820518,
    -0.0250965967014997, -0.0241634602639173, -0.0481859108317218,
    -0.0278449665463922, -0.0329187994318598, -0.0348407606643524,
    -0.0566738032825664, -0.016051679868851, -0.0102983340619392,
    -0.0519430665866201, -0.00270662509257549, 0.0340956221608027,
    0.0481196941867164, 0.0512995083369737, 0.0427880770540714,
    0.025938901829721, 0.0172406430026829, 0.0190854917034619,
    0.0710226222907629, -0.0523474645302372, -0.022700519316666,
    -0.028412434692433, 0.0551838149903664, 0.0241964117675904,
    -0.0297690048221073, -0.033120623649721, -0.0711759115486841,
    -0.0503865940754587, -0.0720367757012015, -0.0741087942465015,
    -0.0893089330064972, -0.059595718301114, -0.0318200608092311,
    -0.0920716816523268, -0.0166664535611419, 0.0371845294194256,
    0.0512995083369737, 0.0986979452294408, 0.0917669226619505,
    0.0635525514325997, 0.0510213739757127, 0.0513114624886664,
    0.086637653107266, -0.0639429975967239, -0.0264358122220455,
    -0.0364006470838577, 0.0723392929084603, 0.0349487881953121,
    -0.0221247951627148, -0.0298135881052149, -0.0679438229402484,
    -0.0640058749264548, -0.0975457943816516, -0.107535703221613,
    -0.073868746305302, -0.123524453263925, -0.0424757746658764,
    -0.109188273097782, -0.0268399881068754, 0.0290913575478051,
    0.0427880770540714, 0.0917669226619505, 0.158166046969139,
    0.0526478012750861, 0.0878449503315404, 0.072216656566408,
    0.101618191765279, -0.0786117565174105, -0.0335761909581523,
    -0.0300072493763622, 0.0763983959054345, 0.0398279043446865,
    -0.00375225549366836, -0.0151579476090994, -0.0465375731482666,
    -0.0113041068243097, -0.0963534317742545, -0.11590339783913,
    -0.12235614875335, -0.10297163225623, -0.117320466802546,
    -0.0930671671318803, -0.0302919303225419, 0.0143241042112522,
    0.025938901829721, 0.0635525514325997, 0.0526478012750861,
    0.357508872728168, -0.122181710723627, 0.0529625804413154,
    0.081840238740399, -0.063904170832196, -0.0153555815191469,
    -0.0408835076677611, 0.0512365416163641, 0.0271145839091361,
    -0.00499252275484576, -0.015226518459989, -0.0374137141732135,
    -0.00831843730650562, -0.111064756608917, -0.0196286635230926,
    -0.105907217560377, -0.0757024271527446, -0.144246293596641,
    -0.0721417252895369, -0.0272696852211407, 0.00594206245237508,
    0.0172406430026829, 0.0510213739757127, 0.0878449503315404,
    -0.122181710723627, 0.858709718521459, 0.158673552049344,
    0.0953496710685112, -0.077928384358563, -0.022334457938622,
    -0.0323634585859656, 0.0602549766706101, 0.0312444446552389,
    -0.000842958258748316, -0.0170673905077609, -0.03621185498621,
    -0.0139208013344843, -0.0921425296807421, -0.0172844920058013,
    -0.198551268786848, -0.0684075332800308, -0.121800944620384,
    -0.0729173883583565, -0.0275284441796622, 0.00694057449961806,
    0.0190854917034619, 0.0513114624886664, 0.072216656566408,
    0.0529625804413154, 0.158673552049344, 0.764623246615722
    ]).reshape(24, 24, order="F")

mpg_bs.cov_scaled = mpg_bs.cov_unscaled * mpg_bs.scale

mpg_bs.p_table = np.array([
    29.6272774569595, -6.21365498504518, 1.43986598470837, 1.01128095138012,
    1.10736522428059, 0.730964352033962, 0.802742257532199,
    0.82715120287436, 26.7547479434413, -8.50062655963349, 1.7936840513851,
    1.22260712172806, 1.61958620027156e-65, 6.17307801841172e-15,
    0.0744959485685591, 0.223032563883354
    ]).reshape(4, 4, order="F")

mpg_bs.pTerms_table = np.array([
    1, 2, 72.2606519063463, 1.75474558676481, 6.1730780184117e-15,
    0.175815884801339
    ]).reshape(2, 3, order="F")

mpg_bs.s_table = np.array([
    10.2535689759835, 3.64644521146987, 10.8058511361601, 4.39467905741677,
    12.2156111509682, 15.7813555049275, 4.72304400617769e-18,
    6.21718617954453e-12
    ]).reshape(2, 4, order="F")

mpg_bs.method = "GCV"
mpg_bs.sp_criterion = 5.16162045425616
mpg_bs.rank = 24
mpg_bs.np = 24
mpg_bs.params = np.array([
    29.6272774569595, -6.21365498504518, 1.43986598470837, 1.01128095138012,
    20.1053719083286, -1.26007449980292, -5.26871981200625,
    -4.544036357677, -7.60063071956733, -5.01036711884368,
    -6.96226144900638, -9.06722069409647, -8.81829781369916,
    -7.9145836553663, -6.28068941724657, 5.09307848346347,
    1.90848821039499, -0.646225516186639, -1.50240395085899,
    -4.19244286007642, -5.72993924243941, -6.83323296859843,
    -5.77088950575513, -4.29112523442438
    ])
