import numpy as np

from statsmodels.tools.tools import Bunch

mpg_bs_poisson = Bunch()

mpg_bs_poisson.smooth0 = Bunch()
mpg_bs_poisson.smooth0.term = "weight"
mpg_bs_poisson.smooth0.bs_dim = 12
mpg_bs_poisson.smooth0.dim = 1
mpg_bs_poisson.smooth0.p_order = np.array([
    3, 2
    ])
mpg_bs_poisson.smooth0.by = "NA"
mpg_bs_poisson.smooth0.label = "s(weight)"
mpg_bs_poisson.smooth0.sp = -1
mpg_bs_poisson.smooth0.m = np.array([
    3, 2
    ])
mpg_bs_poisson.smooth0.knots = np.array([
    1488, 1488, 1488, 1488, 1953.22222222, 2118.77777778, 2275,
    2383.88888889, 2515.55555556, 2757.33333333, 3016.44444444,
    3208.11111111, 4066, 4066, 4066, 4066
    ])
mpg_bs_poisson.smooth0.rank = 10
mpg_bs_poisson.smooth0.null_space_dim = 1
mpg_bs_poisson.smooth0.df = 11
mpg_bs_poisson.smooth0.S_scale = 2.44395544177397e-06
mpg_bs_poisson.smooth0.vn = "weight"
mpg_bs_poisson.smooth0.first_para = 5
mpg_bs_poisson.smooth0.last_para = 15
mpg_bs_poisson.smooth0.S = np.array([
    0.130569121544375, -0.0191732921244136, 0.0202548028417763,
    0.0393112950002946, 0.032061392663319, 0.0241651485426007,
    0.0238771778381105, 0.0389406835250852, 0.0171569521441248,
    0.00680570834700402, 0.00541920498010491, -0.0191732921244136,
    0.0631473273216884, -0.0592997810399249, 0.0178641542128365,
    0.00461438941034586, 0.00793912465273829, 0.00408821971418319,
    -0.000681869049168392, 0.00213834646721613, 0.000935846814259467,
    0.000163463753965317, 0.0202548028417763, -0.0592997810399249,
    0.201022514824508, -0.186241322892132, 0.00284878067469136,
    0.0287314367063779, 0.00263260805442764, -0.00708846456492193,
    0.00065385484055723, 0.000395067932117418, -0.000586348849229599,
    0.0393112950002947, 0.0178641542128365, -0.186241322892132,
    0.479322071007576, -0.286380917395105, 0.0563704638942206,
    0.0348887744557148, 0.0255203052273876, 0.0138979985789615,
    0.00560832050247454, 0.00383270204450356, 0.032061392663319,
    0.00461438941034587, 0.00284878067469137, -0.286380917395105,
    0.414581586658592, -0.181289913269406, -0.00412646444222532,
    -0.00354719180127285, -0.00206283566879658, -0.000685858743449883,
    -0.00142523589453221, 0.0241651485426007, 0.00793912465273829,
    0.0287314367063779, 0.0563704638942206, -0.181289913269406,
    0.213321319885371, -0.0483506678191679, 0.0110304252072989,
    0.0122299348640366, 0.00357726593043956, 0.00234383478372281,
    0.0238771778381105, 0.00408821971418319, 0.00263260805442764,
    0.0348887744557148, -0.00412646444222533, -0.0483506678191679,
    0.0999220996092033, -0.0356092452156359, 0.00921547832469341,
    0.00389860712399989, 0.00147745030481206, 0.0389406835250852,
    -0.000681869049168392, -0.00708846456492192, 0.0255203052273876,
    -0.00354719180127286, 0.0110304252072989, -0.0356092452156359,
    0.0574427000604467, -0.0102653399490586, -0.000311188772793241,
    0.00285258581655637, 0.0171569521441248, 0.00213834646721613,
    0.000653854840557233, 0.0138979985789615, -0.00206283566879658,
    0.0122299348640366, 0.00921547832469341, -0.0102653399490586,
    0.0189789273643945, -0.0062453384832703, 0.00255839876648785,
    0.00680570834700402, 0.000935846814259467, 0.000395067932117419,
    0.00560832050247454, -0.000685858743449884, 0.00357726593043956,
    0.00389860712399989, -0.000311188772793241, -0.0062453384832703,
    0.0211496391608495, -0.0111654555301857, 0.00541920498010491,
    0.000163463753965317, -0.000586348849229599, 0.00383270204450356,
    -0.00142523589453221, 0.00234383478372281, 0.00147745030481206,
    0.00285258581655637, 0.00255839876648785, -0.0111654555301857,
    0.00794139033444708
    ]).reshape(11, 11, order="F")

mpg_bs_poisson.coefficients = np.array([
    3.38155196812657, -0.2398057983025, 0.0385574655971876,
    0.0308789097162079, 0.322087207070371, 0.114222640046661,
    -0.0703319473834318, -0.0932993942273026, -0.164529819124519,
    -0.150860338924587, -0.19827414261489, -0.318132823476157,
    -0.277920321049033, -0.291752287584618, -0.335850782440607,
    0.147266917321495, 0.0655746640077953, 0.00329634588440575,
    -0.0178203244735351, -0.0949069908870388, -0.162736107333124,
    -0.267760412623755, -0.31426029441775, -0.36537967845964
    ])
mpg_bs_poisson.residuals = np.array([
    -0.0597164611104715, -0.0597164611104715, 0.0070681780740447,
    -0.0244130279937029, -0.109459035981563, -0.167042459441988,
    -0.105640645333752, -0.0887544418878843, -0.0954712805695528,
    -0.0784623437350325, -0.0430169241934606, -0.0430169241934606,
    0.0030916078609633, 0.0137773951290736, 0.0148539285398903,
    -0.0370396919392229, -0.0112736908607727, -0.052100214301857,
    0.05696516521011, 0.132586599766586, 0.152452919091744,
    0.0958117450422904, -0.0818874568564589, -0.0996285128088896,
    -0.039947957328768, -0.0297876572186078, -0.0297876572186078,
    -0.0757627215899457, -0.0131089324697808, -0.0233738731200743,
    0.286760172557162, -0.0814957361302606, 0.0714671532989226,
    -0.0558415218265038, -0.0484787948859533, -0.0236434176492324,
    -0.0172259149323173, 0.00318143181414277, 0.0231117802042631,
    0.0285924230117791, 0.0524599141234474, 0.0116354361716793,
    -0.00558296033674166, -0.0940825558878515, 0.132586599766586,
    0.152452919091744, 0.0461585732431811, 0.036440559843717,
    0.036440559843717, 0.00758219423801565, -0.105282911203192,
    -0.0708600665943635, -0.0685585970304921, -0.0501105407364437,
    -0.0478013558335348, -0.295992218769999, -0.295992218769999,
    -0.294876506179699, -0.243930144705301, 0.010594364536701,
    0.0184495378782166, 0.010594364536701, 0.0184495378782166,
    0.0421491667369525, 0.0230515193544041, -0.102317831424696,
    -0.00921877268202032, -0.04273337969419, -0.00119636037327275,
    -0.0461713804461907, 0.00242207736643074, -0.00206774027200307,
    -0.0119510982296829, -0.0463162166023352, -0.0776191103317818,
    0.0686101070886802, 0.118868895618542, -0.0505723217649421,
    -0.0228687782317891, -0.0931020215865397, -0.0139373055232768,
    -0.0329425423946335, -0.019547742575587, -0.00462341430485536,
    -0.0037863985625175, -0.0209367502247506, -0.00850079663664394,
    -0.00363892191661508, -0.00363892191661508, -0.0725184022338961,
    0.0701390830766382, -0.0591199977863917, -0.0498592974299408,
    -0.0100344019333893, -0.0438341236186641, -0.00819025184245747,
    -0.0345607099570335, -0.00404629308005688, -0.017423468562916,
    0.0751572654869439, 0.0669394971058765, -0.0679255314192151,
    -0.0349740550587878, 0.0355822453431487, 0.0642764024494471,
    0.0402581086152893, 0.0766500282298974, -0.108739714671304,
    0.0579475740333115, -0.0762240417848723, -0.0158254364629684,
    -0.106391902749726, 0.0681088212932508, -0.073453881324304,
    -0.00607566275315818, -0.100457295597509, 0.0681088212932508,
    -0.0228550021478378, 0.118868895618542, -0.0996285128088896,
    -0.039947957328768, -0.0297876572186078, 0.0607856968972396,
    -0.0131089324697808, -0.0146135261048062, -0.0264261656715257,
    -0.0145337592605999, -0.0145337592605999, -0.0064905487190714,
    0.226809817977968, -0.0459953733057028, -0.0386603873101858,
    -0.0363408944476897, -0.0267731783454677, 0.00999638170999839,
    0.0169931451495056, 0.00192444906825173, -0.120308776123272,
    -0.0400164322133238, 0.130247697154032, 0.00746981127430812,
    0.0306709674011021, -0.0372819368771609, 0.0976557161110208,
    0.0465873287478877, 0.0269883944212412, -0.0674146853454123,
    0.0873341779571093, 0.0693951026504345, -0.0280641297469413,
    -0.0392924504624044, 0.0735437039091389, -0.0247046596041458,
    0.171463552666685, -0.013091147087648, -0.000813946803385424,
    -0.0956269920449824, 0.0107698324203134, 0.25732769645148,
    -0.0621561621420588, -0.0549179845713752, -0.00160856625504557,
    0.0126062678583092, 0.0705449231002744, 0.0842095493097967,
    0.0883081440038147, 0.0872170109597095, 0.0912812221820642,
    0.123175492931149, 0.131142517763956, 0.184711504210098,
    0.136459914352958, -0.0929831907336212, 0.0885449049874016,
    0.0885449049874016, 0.102638885670704, 0.104987186006888,
    0.0567660298014965, 0.121868643941937, 0.0694291967778775,
    -0.0353205301526058, -0.0107460163888975, -0.0342456641975604,
    -0.00957686458378415, 0.0143852426645283, 0.0450346063721021,
    0.0367753899157743, -0.0896986969406739, -0.101104390140708,
    -0.136305098940538, 0.00460226286555798, 0.0351388253204785,
    0.116934978569832, 0.13995662419881, 0.170013018072364,
    0.191118649321067, -0.0478214884195327, -0.0295329898984451,
    0.124455798890416, 0.0603367500448151, -0.0610962381564639,
    0.0212222309861203, -0.0538512733755478
    ])
mpg_bs_poisson.fitted_values = np.array([
    22.3336888624052, 22.3336888624052, 18.8666471780851, 24.6005745142783,
    20.2124334840001, 22.8102863289666, 21.2442570213741, 20.8505817458946,
    18.7943175653995, 17.3622856225417, 24.0338628565774, 24.0338628565774,
    20.9352763351109, 20.7146066788422, 19.7072696252699, 16.6154304243557,
    16.1824357783393, 15.8244576339389, 44.4669337713292, 33.5515182749217,
    32.9731474236258, 33.764923735666, 33.764923735666, 26.6556641802072,
    32.2899161942785, 31.9517683223134, 31.9517683223134, 25.9673576911837,
    24.3187934206985, 19.4547324478203, 38.080134157885, 33.7505237802536,
    35.4653895670086, 31.7743267613674, 31.5284618343364, 30.7264789753035,
    30.5258354446067, 26.9143737550779, 26.3900783105141, 26.2494642153229,
    25.6541837248854, 23.723961361835, 25.1403576194408, 26.4924802541156,
    33.5515182749217, 32.9731474236258, 22.9410728104038, 14.4726099895799,
    14.4726099895799, 12.9021732165794, 33.5301520174866, 33.3641886280506,
    33.2817500931026, 32.6353763563543, 32.5562320319588, 24.1474603736604,
    24.1474603736604, 24.1092519948462, 21.1620657641, 25.7274341836643,
    25.5290017158504, 25.7274341836643, 25.5290017158504, 34.5439992172317,
    25.4141648862486, 21.1656203778165, 31.2884410253879, 22.9821029307089,
    22.0263514540474, 23.0649401255032, 21.9468430481884, 16.0331523948941,
    16.1935304733726, 14.6799182745066, 15.1781115120846, 17.7801050860014,
    33.0691112648595, 32.6512494955146, 31.725523972003, 26.4638366952653,
    23.3250888902206, 25.8516180226821, 19.3788120289629, 19.0882529015196,
    19.0722150074884, 25.5346117891147, 25.2143419936145, 23.0840008767134,
    23.0840008767134, 33.4238437448952, 42.0506088522863, 32.9478785042368,
    32.6267466662015, 31.3142194643355, 32.4211528205977, 31.2559944662652,
    32.1097352466569, 31.1259446946281, 31.5497052984366, 25.1126052594469,
    25.3060272613759, 18.2388860257967, 17.6161066851271, 18.3471666161138,
    17.8525051915754, 16.3420980420225, 17.6473315393281, 21.3181270530784,
    26.4663398142244, 20.5677576159384, 25.401997700644, 21.2621170941322,
    26.2145573950957, 20.5062647363485, 25.1528200519264, 21.1218432510333,
    26.2145573950957, 18.4210122751131, 33.0691112648595, 26.6556641802072,
    32.2899161942785, 31.9517683223134, 29.2236217839983, 24.3187934206985,
    19.2817747181913, 19.5157258032775, 17.2507177792766, 17.2507177792766,
    17.1110601696662, 13.8570785388883, 22.01247186061, 21.8445175074418,
    21.7919385382283, 21.5777037097056, 18.8119485812727, 18.6825251385611,
    30.9404566669959, 29.5558251512617, 27.0837969236757, 28.3123779686312,
    27.7923960466705, 25.2262854221658, 24.92941694908, 21.8647793180832,
    26.7536202960708, 24.343020949218, 24.662622967121, 21.1526506443608,
    32.7287827606976, 31.8951084621752, 32.2678842431506, 28.8763278915599,
    27.6839218662126, 23.048092224925, 30.3979439554833, 30.0244382955741,
    37.5951069978098, 37.5951069978098, 30.2228290263917, 29.8557167725841,
    29.6270583323936, 29.0467235793694, 28.6389694795548, 24.2866968391243,
    23.9806041337226, 22.052577785282, 22.0747097939672, 21.9924979117765,
    21.3679875950349, 21.2174855273261, 20.2580965194576, 25.5178380106008,
    33.0754619909028, 24.8037539620954, 24.8037539620954, 24.4867112441592,
    18.0997574028658, 17.9793818727964, 17.8273990524644, 17.7664870729599,
    38.3547086431239, 27.2932941866366, 38.3120205919209, 27.2610756297141,
    26.6171064644809, 35.4055260700386, 25.0777557539364, 26.3648968966003,
    26.6994295408305, 21.998508937234, 32.8488210905178, 24.1513499334353,
    20.5920670775752, 20.1762062799231, 20.5125922782815, 20.1491262131442,
    17.8537950533904, 17.5173394077775, 20.4543389101606, 17.9188356898853,
    19.171293940347, 25.4596886075362, 20.0814094711999
    ])
mpg_bs_poisson.linear_predictors = np.array([
    3.10609624980832, 3.10609624980832, 2.93739566357681, 3.20276979690456,
    3.00629793406294, 3.12721158899991, 3.05608660102651, 3.03738184933733,
    2.9335545669874, 2.85430036085041, 3.17946378824737, 3.17946378824737,
    3.04143559905492, 3.03083908808588, 2.98098758418526, 2.81033180724024,
    2.78392644284256, 2.76155669470604, 3.79474585164685, 3.51308211648978,
    3.4956935157856, 3.51942250434414, 3.51942250434414, 3.28300166762353,
    3.4747549893589, 3.46422752584326, 3.46422752584326, 3.25684027583847,
    3.19124944323147, 2.96809035398114, 3.63969273297066, 3.51899593661304,
    3.56855727914211, 3.45865862916789, 3.45089068817213, 3.42512479018631,
    3.41857338881492, 3.2926604842363, 3.27298811794221, 3.26764557798449,
    3.24470666649875, 3.1664855653221, 3.2244744281779, 3.27686092872792,
    3.51308211648978, 3.4956935157856, 3.13292887653641, 2.67225789684402,
    2.67225789684402, 2.55739576358026, 3.51244509424318, 3.50748312800355,
    3.50500920150253, 3.48539686431283, 3.48296881060363, 3.18417921405787,
    3.18417921405787, 3.18259566702687, 3.05221022812765, 3.24755790051531,
    3.23981512809367, 3.24755790051531, 3.23981512809367, 3.54223385111242,
    3.23530669126982, 3.05237818503949, 3.44324873302594, 3.13471577957874,
    3.09223952994195, 3.13831372110367, 3.08862330449352, 2.77465860323819,
    2.78461180897998, 2.68648045603917, 2.71985435790984, 2.87808014041708,
    3.49859965227091, 3.48588312437807, 3.45712152952405, 3.27577914799641,
    3.14952955766808, 3.25237319174925, 2.96418030576864, 2.94907311450918,
    2.9482325642825, 3.24003485689474, 3.22741295935692, 3.13913977482799,
    3.13913977482799, 3.50926952986597, 3.73887386555994, 3.4949268735718,
    3.48513240187112, 3.44407229037009, 3.47881107460801, 3.44221118070723,
    3.46915926286833, 3.43804170595891, 3.45156424816504, 3.22336992164832,
    3.23104259903575, 2.90355590963404, 2.86881363611135, 2.90947515473725,
    2.88214384524492, 2.79374448033398, 2.87058458437584, 3.05955774614591,
    3.27587372992023, 3.02372468537151, 3.23482782056342, 3.0569269490534,
    3.26631488223122, 3.02073043635419, 3.22497001956098, 3.05030773017343,
    3.26631488223122, 2.91349198453504, 3.49859965227091, 3.28300166762353,
    3.4747549893589, 3.46422752584326, 3.37497734744367, 3.19124944323147,
    2.9591603346448, 2.97122059201258, 2.84785375300452, 2.84785375300452,
    2.83972504797555, 2.62879618791377, 3.09160919548466, 3.08394997506595,
    3.0815401095808, 3.07166054590621, 2.93449223078504, 2.92758860238871,
    3.43206460479669, 3.38628085306311, 3.29893564957711, 3.34329909307524,
    3.32476245978116, 3.22788652320362, 3.21604850974011, 3.08487709188384,
    3.2866698023555, 3.1922451944518, 3.20528885733209, 3.05176522361415,
    3.48825489749758, 3.46245265828934, 3.47407243971087, 3.36302215537105,
    3.32085180663105, 3.13758299920276, 3.41437497308165, 3.4020116599001,
    3.62687390889084, 3.62687390889084, 3.40859756683735, 3.39637633817112,
    3.38868807661617, 3.36890569137327, 3.35476835958596, 3.18992874525813,
    3.17724534251483, 3.09342950142183, 3.09443260003746, 3.09070139119307,
    3.06189389526813, 3.05482563075123, 3.00855454176395, 3.23937773743491,
    3.49879167788239, 3.21099501115507, 3.21099501115507, 3.19813057220198,
    2.89589853502537, 2.88922564985387, 2.88073654644261, 2.8773139339888,
    3.64687730106182, 3.30664103782876, 3.64576370051983, 3.30545988365993,
    3.28155410925581, 3.56686791163023, 3.22198122826548, 3.27203346235845,
    3.28464219966599, 3.09097467548117, 3.49191585663117, 3.18434027640117,
    3.02490590830647, 3.00450400319504, 3.0210389550426, 3.00316092334049,
    2.88221609366084, 2.86319121368963, 3.01819503162959, 2.88585243277332,
    2.95341405297199, 3.23709636239996, 2.99979448514897
    ])
mpg_bs_poisson.deviance = 37.5688885982924
mpg_bs_poisson.null_deviance = 337.261844954099
mpg_bs_poisson.iter = 2
mpg_bs_poisson.weights = np.array([
    22.3336888624052, 22.3336888624052, 18.8666471780852, 24.6005745142783,
    20.2124334840002, 22.8102863289666, 21.2442570213741, 20.8505817458947,
    18.7943175653996, 17.3622856225417, 24.0338628565775, 24.0338628565775,
    20.935276335111, 20.7146066788423, 19.70726962527, 16.6154304243558,
    16.1824357783394, 15.8244576339389, 44.4669337713293, 33.5515182749217,
    32.9731474236259, 33.7649237356661, 33.7649237356661, 26.6556641802073,
    32.2899161942786, 31.9517683223135, 31.9517683223135, 25.9673576911838,
    24.3187934206986, 19.4547324478204, 38.0801341578851, 33.7505237802537,
    35.4653895670087, 31.7743267613674, 31.5284618343365, 30.7264789753035,
    30.5258354446068, 26.9143737550779, 26.3900783105142, 26.249464215323,
    25.6541837248854, 23.7239613618351, 25.1403576194409, 26.4924802541157,
    33.5515182749217, 32.9731474236259, 22.9410728104039, 14.47260998958,
    14.47260998958, 12.9021732165794, 33.5301520174867, 33.3641886280507,
    33.2817500931026, 32.6353763563543, 32.5562320319589, 24.1474603736604,
    24.1474603736604, 24.1092519948462, 21.1620657641001, 25.7274341836644,
    25.5290017158505, 25.7274341836644, 25.5290017158505, 34.5439992172318,
    25.4141648862487, 21.1656203778166, 31.2884410253879, 22.982102930709,
    22.0263514540475, 23.0649401255033, 21.9468430481884, 16.0331523948941,
    16.1935304733727, 14.6799182745067, 15.1781115120846, 17.7801050860015,
    33.0691112648596, 32.6512494955146, 31.7255239720031, 26.4638366952653,
    23.3250888902207, 25.8516180226822, 19.3788120289629, 19.0882529015196,
    19.0722150074884, 25.5346117891148, 25.2143419936146, 23.0840008767135,
    23.0840008767135, 33.4238437448953, 42.0506088522863, 32.9478785042369,
    32.6267466662016, 31.3142194643356, 32.4211528205978, 31.2559944662652,
    32.1097352466569, 31.1259446946282, 31.5497052984367, 25.112605259447,
    25.306027261376, 18.2388860257968, 17.6161066851272, 18.3471666161139,
    17.8525051915755, 16.3420980420226, 17.6473315393282, 21.3181270530784,
    26.4663398142245, 20.5677576159385, 25.4019977006441, 21.2621170941323,
    26.2145573950958, 20.5062647363486, 25.1528200519265, 21.1218432510334,
    26.2145573950958, 18.4210122751131, 33.0691112648596, 26.6556641802073,
    32.2899161942786, 31.9517683223135, 29.2236217839984, 24.3187934206986,
    19.2817747181913, 19.5157258032775, 17.2507177792766, 17.2507177792766,
    17.1110601696662, 13.8570785388883, 22.0124718606101, 21.8445175074419,
    21.7919385382284, 21.5777037097057, 18.8119485812728, 18.6825251385612,
    30.940456666996, 29.5558251512618, 27.0837969236757, 28.3123779686313,
    27.7923960466706, 25.2262854221659, 24.9294169490801, 21.8647793180832,
    26.7536202960709, 24.343020949218, 24.6626229671211, 21.1526506443609,
    32.7287827606977, 31.8951084621753, 32.2678842431507, 28.87632789156,
    27.6839218662126, 23.048092224925, 30.3979439554834, 30.0244382955742,
    37.5951069978099, 37.5951069978099, 30.2228290263918, 29.8557167725842,
    29.6270583323937, 29.0467235793695, 28.6389694795549, 24.2866968391243,
    23.9806041337226, 22.0525777852821, 22.0747097939672, 21.9924979117766,
    21.3679875950349, 21.2174855273262, 20.2580965194577, 25.5178380106008,
    33.0754619909028, 24.8037539620955, 24.8037539620955, 24.4867112441593,
    18.0997574028658, 17.9793818727964, 17.8273990524644, 17.7664870729599,
    38.3547086431239, 27.2932941866367, 38.312020591921, 27.2610756297141,
    26.6171064644809, 35.4055260700387, 25.0777557539365, 26.3648968966003,
    26.6994295408305, 21.9985089372341, 32.8488210905178, 24.1513499334354,
    20.5920670775753, 20.1762062799232, 20.5125922782816, 20.1491262131442,
    17.8537950533905, 17.5173394077776, 20.4543389101607, 17.9188356898853,
    19.1712939403471, 25.4596886075362, 20.0814094712
    ])
mpg_bs_poisson.working_weights = np.array([
    22.3336888624052, 22.3336888624052, 18.8666471780852, 24.6005745142783,
    20.2124334840002, 22.8102863289666, 21.2442570213741, 20.8505817458947,
    18.7943175653996, 17.3622856225417, 24.0338628565775, 24.0338628565775,
    20.935276335111, 20.7146066788423, 19.70726962527, 16.6154304243558,
    16.1824357783394, 15.8244576339389, 44.4669337713293, 33.5515182749217,
    32.9731474236259, 33.7649237356661, 33.7649237356661, 26.6556641802073,
    32.2899161942786, 31.9517683223135, 31.9517683223135, 25.9673576911838,
    24.3187934206986, 19.4547324478204, 38.0801341578851, 33.7505237802537,
    35.4653895670087, 31.7743267613674, 31.5284618343365, 30.7264789753035,
    30.5258354446068, 26.9143737550779, 26.3900783105142, 26.249464215323,
    25.6541837248854, 23.7239613618351, 25.1403576194409, 26.4924802541157,
    33.5515182749217, 32.9731474236259, 22.9410728104039, 14.47260998958,
    14.47260998958, 12.9021732165794, 33.5301520174867, 33.3641886280507,
    33.2817500931026, 32.6353763563543, 32.5562320319589, 24.1474603736604,
    24.1474603736604, 24.1092519948462, 21.1620657641001, 25.7274341836644,
    25.5290017158505, 25.7274341836644, 25.5290017158505, 34.5439992172318,
    25.4141648862487, 21.1656203778166, 31.2884410253879, 22.982102930709,
    22.0263514540475, 23.0649401255033, 21.9468430481884, 16.0331523948941,
    16.1935304733727, 14.6799182745067, 15.1781115120846, 17.7801050860015,
    33.0691112648596, 32.6512494955146, 31.7255239720031, 26.4638366952653,
    23.3250888902207, 25.8516180226822, 19.3788120289629, 19.0882529015196,
    19.0722150074884, 25.5346117891148, 25.2143419936146, 23.0840008767135,
    23.0840008767135, 33.4238437448953, 42.0506088522863, 32.9478785042369,
    32.6267466662016, 31.3142194643356, 32.4211528205978, 31.2559944662652,
    32.1097352466569, 31.1259446946282, 31.5497052984367, 25.112605259447,
    25.306027261376, 18.2388860257968, 17.6161066851272, 18.3471666161139,
    17.8525051915755, 16.3420980420226, 17.6473315393282, 21.3181270530784,
    26.4663398142245, 20.5677576159385, 25.4019977006441, 21.2621170941323,
    26.2145573950958, 20.5062647363486, 25.1528200519265, 21.1218432510334,
    26.2145573950958, 18.4210122751131, 33.0691112648596, 26.6556641802073,
    32.2899161942786, 31.9517683223135, 29.2236217839984, 24.3187934206986,
    19.2817747181913, 19.5157258032775, 17.2507177792766, 17.2507177792766,
    17.1110601696662, 13.8570785388883, 22.0124718606101, 21.8445175074419,
    21.7919385382284, 21.5777037097057, 18.8119485812728, 18.6825251385612,
    30.940456666996, 29.5558251512618, 27.0837969236757, 28.3123779686313,
    27.7923960466706, 25.2262854221659, 24.9294169490801, 21.8647793180832,
    26.7536202960709, 24.343020949218, 24.6626229671211, 21.1526506443609,
    32.7287827606977, 31.8951084621753, 32.2678842431507, 28.87632789156,
    27.6839218662126, 23.048092224925, 30.3979439554834, 30.0244382955742,
    37.5951069978099, 37.5951069978099, 30.2228290263918, 29.8557167725842,
    29.6270583323937, 29.0467235793695, 28.6389694795549, 24.2866968391243,
    23.9806041337226, 22.0525777852821, 22.0747097939672, 21.9924979117766,
    21.3679875950349, 21.2174855273262, 20.2580965194577, 25.5178380106008,
    33.0754619909028, 24.8037539620955, 24.8037539620955, 24.4867112441593,
    18.0997574028658, 17.9793818727964, 17.8273990524644, 17.7664870729599,
    38.3547086431239, 27.2932941866367, 38.312020591921, 27.2610756297141,
    26.6171064644809, 35.4055260700387, 25.0777557539365, 26.3648968966003,
    26.6994295408305, 21.9985089372341, 32.8488210905178, 24.1513499334354,
    20.5920670775753, 20.1762062799232, 20.5125922782816, 20.1491262131442,
    17.8537950533905, 17.5173394077776, 20.4543389101607, 17.9188356898853,
    19.1712939403471, 25.4596886075362, 20.0814094712
    ])
mpg_bs_poisson.prior_weights = np.array([
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
    ])
mpg_bs_poisson.df_null = 202
mpg_bs_poisson.y = np.array([
    21, 21, 19, 24, 18, 19, 19, 19, 17, 16, 23, 23, 21, 21, 20, 16, 16, 15,
    47, 38, 38, 37, 31, 24, 31, 31, 31, 24, 24, 19, 49, 31, 38, 30, 30, 30,
    30, 27, 27, 27, 27, 24, 25, 24, 38, 38, 24, 15, 15, 13, 30, 31, 31, 31,
    31, 17, 17, 17, 16, 26, 26, 26, 26, 36, 26, 19, 31, 22, 22, 22, 22, 16,
    16, 14, 14, 19, 37, 31, 31, 24, 23, 25, 19, 19, 19, 25, 25, 23, 23, 31,
    45, 31, 31, 31, 31, 31, 31, 31, 31, 27, 27, 17, 17, 19, 19, 17, 19, 19,
    28, 19, 25, 19, 28, 19, 25, 19, 28, 18, 37, 24, 31, 31, 31, 24, 19, 19,
    17, 17, 17, 17, 21, 21, 21, 21, 19, 19, 31, 26, 26, 32, 28, 26, 24, 24,
    28, 25, 23, 23, 35, 31, 31, 31, 27, 27, 30, 30, 34, 38, 38, 28, 28, 29,
    29, 26, 26, 24, 24, 24, 24, 24, 24, 29, 30, 27, 27, 27, 20, 19, 20, 19,
    37, 27, 37, 27, 27, 37, 26, 24, 24, 19, 33, 25, 23, 23, 24, 24, 17, 17,
    23, 19, 18, 26, 19
    ])
mpg_bs_poisson.rV = np.array([
    0, 0, 0, 0, -8.9130297985463e-05, -0.000176684273823698,
    0.0011584583691732, -0.00390049177471793, 0.00344010782379437,
    -0.00135790861015704, -0.000111385074008239, -0.000176972060004861,
    -9.86203908496754e-05, -3.64890558944375e-05, -3.08026950210881e-05, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.00732908209018e-08,
    -1.9968429523216e-08, 1.3092616450685e-07, -4.40824151599687e-07,
    3.88792670366615e-07, -1.53467548605631e-07, -1.25884718098402e-08,
    -2.00009544217366e-08, -1.11458381757212e-08, -4.12390489107036e-09,
    -3.48124613097974e-09, 0.000484189713776837, 0.00176326319300196,
    -0.00213289729840957, 0.00171891163782342, 0.000158871132568822,
    0.000404028755237099, 0.000172315861842303, 4.89726562858341e-05,
    1.83249073133473e-05, 0, 0, 0, 0, -0.000254544577467626,
    -0.001035854174059, 0.0046293795015643, -0.00326301657903083,
    -0.00369019497478088, 0.00424113890068213, -0.00111478223779753,
    -8.31563834028823e-05, 3.46682153808709e-06, -1.64898555754477e-05,
    -9.07732254822129e-06, 6.0169393955401e-07, 2.19117578684648e-06,
    -2.65051351077577e-06, 2.13606089860863e-06, 1.97426328806317e-07,
    5.0207934310591e-07, 2.14133854581071e-07, 6.08574483361064e-08,
    2.27720361659973e-08, 0, 0, 0, 0, -8.67530824448457e-07,
    -3.50085835082344e-06, 1.5704337049189e-05, -1.1558369799142e-05,
    -1.18261820387094e-05, 1.40035677392858e-05, -3.75511703912262e-06,
    -3.06863463308056e-07, -4.02009554224386e-09, -6.10721916028877e-08,
    -3.5318767498273e-08, -0.000382530042043907, -0.00255975045612884,
    -2.99883291413828e-06, 0.00294330517341526, -0.00281607442586145,
    0.000253368944788171, -0.000122754106081541, -4.2763005163725e-05,
    -1.30236129168315e-05, 0, 0, 0, 0, -0.00966644355174144,
    0.00269105367197029, -0.00334645589725531, -0.00234181093625769,
    -0.00216540983679256, -0.00066383484979213, -0.00237599704209698,
    -0.0025908794761289, -0.00118961452521134, -0.00047380312071635,
    -0.000383619934532888, 5.15841833882531e-08, -1.94845144065131e-07,
    -7.80952028852524e-07, 1.59403673671029e-06, -8.65625953468978e-07,
    2.30856760369028e-07, 2.27477703785993e-08, 3.88153165550371e-09,
    2.42916435116361e-09, 0, 0, 0, 0, 0.00206071513456646,
    0.00259032221886972, -0.00462767183063042, -0.000812824166230881,
    0.00327127979674583, 0.00636775605071208, -0.00706904029020125,
    0.0038451705444942, -4.78467478660841e-05, 3.51536747705564e-06,
    0.000141313878548576, 2.10782460099238e-07, 3.38869931168823e-06,
    2.86390520594828e-06, -8.91501199000953e-06, 6.11375240450779e-06,
    -1.11044209821123e-06, 4.49490645479527e-08, 3.046867980894e-08,
    4.71123050344579e-09, 0, 0, 0, 0, 0.00216388091005572,
    0.0072785576896648, -0.00311587959475874, -0.00239308716572744,
    0.00144238479341897, 0.00678208940398299, 0.00874004674289753,
    -0.00685793621788863, 0.0033588493044311, 0.000612698808337676,
    0.000171678666979125, -6.30057645838362e-07, -5.07268731106957e-06,
    -1.24429998247157e-06, 8.00582245681437e-06, -6.61366914887778e-06,
    8.37690225444627e-07, -1.92360546261274e-07, -7.34241156464652e-08,
    -2.03835562953002e-08, 0, 0, 0, 0, -2.2318052171308e-05,
    1.00187730987837e-06, 5.83061748307947e-05, -3.45050041792168e-05,
    -5.05331594075182e-05, 9.27165882205839e-06, 7.16977964102637e-05,
    -5.71805931575351e-05, 1.06595362126306e-05, 1.37331425262819e-06,
    -1.03861037743204e-06, -6.16816513887191e-05, -0.00397223763403223,
    -0.00331945740763105, 0.00040255086143712, 0.00378466857534277,
    -0.00325030280975968, -0.000271335113409458, -7.80253442210804e-05,
    -4.36513398991459e-05, 0, 0, 0, 0, 0.00182160098394648,
    0.0140353939250751, 0.00184333025785555, -0.00371605504172841,
    -0.00536561351594821, -0.00495181859482273, 0.00458467528732412,
    0.0128362620543724, -0.00605747342330702, 0.00204832461339022,
    -7.6277769152395e-05, -4.19141107502209e-06, -0.000129533993153208,
    -9.63657701282369e-05, 4.2472204591931e-05, 7.84167279344425e-05,
    -8.63726646261737e-05, -8.24485498650714e-06, -2.44196733700831e-06,
    -1.2846096191467e-06, 0, 0, 0, 0, -0.000111854458371005,
    -0.0030362002288163, -0.00103705133742332, 0.000437977493539271,
    0.00133786612382401, 0.00225092840905142, 0.000927619479306194,
    -0.00201944800380486, -0.0101339323949803, 0.0226636304940929,
    -0.0123761853740514, 1.01542617077534e-06, 2.85681463258814e-05,
    2.05230490131649e-05, -8.90719228375958e-06, -1.70051211426309e-05,
    1.88733138779214e-05, 1.83051339841541e-06, 5.41785688208812e-07,
    2.8339017949807e-07, 0, 0, 0, 0, 4.65402191088959e-05,
    0.000191816594322909, -4.54028851717489e-06, -3.18890377626848e-05,
    -5.7674071220918e-05, -3.79391537768814e-05, 2.39849167980979e-05,
    0.000203747166481438, -0.000106995289962793, 7.69291581175877e-05,
    -2.64037729668823e-05, -0.00177978600426665, 0.00388593763522146,
    0.00772623228480497, 0.00736829029955221, 0.00358935560508782,
    -0.00791584614212573, 0.00260070979940973, 0.000494193187052966,
    -5.16890264935234e-06, 0, 0, 0, 0, -0.000752774096418275,
    0.0145172326131151, 0.0135584669346244, 0.0084247696435658,
    0.00341964710536383, -0.00534543003921537, -0.0119819810541305,
    -0.00576414999763685, 0.0175467982472431, 0.00703564364103214,
    -0.0075588975595249, 0.000162124661698533, -0.000517363075356893,
    -0.000843527567273272, -0.000640702296616474, -0.000228240599694238,
    0.000629209863537068, -0.000252521203049104, -4.90223702087604e-05,
    -1.08712652734942e-06, 0, 0, 0, 0, -0.00572677403360511,
    0.00870397569070348, 0.0156669586701219, 0.0147970077092393,
    0.0140991545215927, 0.00845910163493166, 0.000446479103855692,
    -0.00616089183508052, -0.0303069331722817, -0.0036612206130011,
    0.0217792101261298, 0.000189946466274698, -0.000505169752388413,
    -0.000908200445697714, -0.000760865821994572, -0.000317806093180382,
    0.000783677174543439, -0.000284599371195069, -5.46600275429753e-05,
    -3.4861779513484e-07, 0, 0, 0, 0, 0.000154872794432739,
    0.000347867145902534, -0.000103102401856294, -0.000392898983966799,
    -0.000575837864553121, -0.000562899412506052, -9.71872572167717e-05,
    0.000520814308366405, 0.00099813091123171, 2.08971401302817e-05,
    -0.000592020227328858, -0.00410594365252939, -9.93367498970981e-05,
    0.0033499368419802, 0.00467254784048401, 0.00668857971950258,
    0.0067164286612312, -0.0212771297885921, 0.0294716435709253,
    -0.0154755121605764, 0, 0, 0, 0, -0.000206206119749145,
    0.00205597864873973, 0.00168384931295861, 0.000749679428496663,
    8.41486634926737e-05, -0.000706726922678021, -0.000617139988013067,
    0.000167185618961349, 0.000492348623290797, 8.87037243629349e-05,
    0.000157329110308255, -0.0116748017186726, -0.00163015109322018,
    0.00682422864381095, 0.00998251986633975, 0.016148092859733,
    0.0177601065922889, -0.017874797540282, -0.0213772410986876,
    0.0157985614102532, 0, 0, 0, 0, 0.037193198873555,
    0.000276975159045285, -0.0237629718390942, -0.0244127800075447,
    -0.0310757874145892, -0.0255575206850703, -0.026673251680601,
    -0.0350111136488692, -0.00886521071472492, 0.0245404712666937,
    0.0463326363220799, -0.00253188718079104, -0.000653429116975908,
    0.0011620482733327, 0.00211589034759339, 0.00367778201322326,
    0.0040677604350883, -0.00507376363738053, -0.00223095373191136,
    0.00206213937427957, 0, 0, 0, 0, 0.00873021053727884,
    0.00788912587315529, 0.00315035854914982, 0.000729499906725857,
    -0.00328134349842095, -0.00644376475504463, -0.0116331903146275,
    -0.015288226128054, -0.00792058428914374, 0.00838656968634575,
    0.0196142787782849, -0.0222070071311449, -0.0085523948160152,
    0.00197984349190124, 0.00552409581369225, 0.0173231753198411,
    0.0269502786230045, 0.0444699184443161, -0.00195308066417439,
    -0.0363223282917489, 0, 0, 0, 0, 0.00169163794738931,
    -0.00383399031151375, -0.00585177655081489, -0.00499725225479528,
    -0.00415592538210646, -0.00148907462126999, 0.00173577250006001,
    0.00294429784532539, 0.00458477957640236, -0.000484638769799792,
    -0.00384943847580776, 0.00842349237381884, 0.00485500145690797,
    0.00281845357221204, 0.00271275264035418, -0.000438520740299198,
    -0.00382130619094318, -0.017249675475828, -0.0858405600961884,
    -0.135935077467396, -0.014351805995054, 0, 0, 0, 0.00040660604880189,
    0.000316745017030137, 3.28762155221662e-05, -7.65210725613372e-05,
    -0.000234228657698133, -0.000311673452153201, -0.000437967535817843,
    -0.000585886587938954, -0.000192461378311277, 0.000391244883140083,
    0.000693129601873483, 0.00416984196146825, 0.00191987715157721,
    0.000233531125633939, -0.000325479295859366, -0.00247433282397362,
    -0.00446616198281691, -0.00803899886321839, -0.0106982256522182,
    -0.0133066416160238, 0.0144487468289665, 0, 0, -0.039021573780305,
    0.00178251131609767, -0.00314872170017292, -0.00526317798364386,
    -0.00471582757742263, -0.00426509391962734, -0.0021098532647336,
    0.000449733415313781, 0.00250944131155914, 0.00679139580304206,
    0.000266584356546392, -0.00499157509254186, -0.0129502842323007,
    -0.00584017124814522, -0.00038900758484735, 0.00154888351611733,
    0.00854704220691514, 0.0147435174902231, 0.0220373114764713,
    0.0277678791681642, 0.0330732757720991, 0.0673687811308531, 0,
    -0.0727577715645542, -0.0660767215034692, 0.0046318104807724,
    0.00279923327002594, -0.000344618926583256, -0.00145801819850269,
    -0.00309674677991799, -0.0036486478609869, -0.00464834984362868,
    -0.00576615440314964, -0.00207127569768669, 0.00378666514448286,
    0.00764068847822383, 8.88247243745535e-06, 7.70568572451843e-05,
    0.000176716367242848, 0.000255560590323436, 0.000237005166038077,
    4.52872126430998e-05, -0.000545209712186102, -0.00184078849724724,
    -0.00263833664383721, 0.0503224185461385, -0.0469900909623995,
    -0.00485618033033583, -0.0146940851269257, 0.00309766417715181,
    0.00358739721584392, 0.00126780489916931, -4.04115178473884e-05,
    -0.00135981454962773, -0.00215240226396701, -0.00310950655627377,
    -0.004402851468672, -0.00541141005760902, 0.00216272414867472,
    0.00871843645875338, -0.011066944059589, -0.00438326526061835,
    0.000734116197365618, 0.00238488961743991, 0.0079891741761364,
    0.0124369238374935, 0.0172500599680547, 0.018005707666409,
    0.0201741350091917, 0.0401636589575239, -0.0318988645890763,
    -0.01850999070435, -0.00394626508026133, 0.0551382157508856,
    0.0217807180807445, -0.00622899826733438, -0.00923850673879829,
    -0.0212137461370569, -0.020091132050748, -0.0314646112389824,
    -0.0563797107234094, -0.0618781724522286, -0.0809883829460941,
    -0.101451533937108, -0.0294660248157941, -0.0129461041972885,
    -0.000317118828092305, 0.00404893245763359, 0.0193119490827826,
    0.0326887256219942, 0.0524397613334577, 0.0599889895213543,
    0.0707562479561827, -0.00014417166463547, 0.000112486137657318,
    2.93195506570937e-05, 7.11989286865333e-05, 0.000298020443190303,
    7.43500900776159e-05, -0.000123025591619351, -0.000150144864483587,
    -0.000213602220981072, -0.000182287600073906, -0.000196294549615607,
    -0.000273238798774471, -0.000134016463849165, -5.87892574426707e-05,
    -3.61576064062375e-05, 0.00212707138394515, -0.000435955193172209,
    0.000604997293885961, 0.000392867571322303, 0.000561225223337066,
    0.00056952076942879, 0.000186965781647446, 2.43190236830834e-05,
    -1.49153748573756e-05
    ]).reshape(24, 24, order="F")

mpg_bs_poisson.db_drho = np.array([
    -0.00955607829508903, 0.00430986949109399, 0.00462834751450597,
    0.00835107524076425, -0.0333302515945607, 0.00139610358751732,
    0.0263076303556022, 0.0268343416489505, 0.0314648272214792,
    0.0226413860328889, 0.0162437421056309, 0.0181827810783155,
    0.000275213760239914, 0.00115455787426117, 0.00197111543707827,
    0.00493118340740466, 0.00145534674747094, -0.00147150121604032,
    -0.00260852436899397, -0.00515405425200522, -0.00625733949412647,
    -0.00215131919228267, 0.000695879282559118, 0.00245613544165302,
    0.0165502705938555, -0.0120739288987487, -0.00539618833686599,
    -0.00676715282188502, 0.0196760486043603, 0.00772600754507691,
    -0.00364486556122667, -0.00558444320663137, -0.0105223419591228,
    -0.0104699677543541, -0.0139344474571075, -0.0207299030874315,
    -0.0154990384672306, -0.0114599389957355, -0.0101038003601939,
    -0.020380893865003, -0.00665329046642183, 0.00475504810058412,
    0.00904455059277683, 0.0203739259385563, 0.026657106982953,
    0.0214205189927133, -0.0170394753092789, -0.0478344361350309
    ]).reshape(24, 2, order="F")

mpg_bs_poisson.dw_drho = np.array([
    0.198451577496262, 0.198451577496262, 0.0211323116265804,
    0.176795914312368, -0.158842940220042, 0.136552595840399,
    -0.0788956246522186, -0.145800287459428, -0.18078320916676,
    -0.227604968605315, 0.270528113197353, 0.270528113197353,
    0.0871931177612735, 0.0488040223227676, -0.11212062083582,
    -0.0921466191935143, -0.0872523607945422, -0.0726475180150896,
    -2.03674569674128, -0.399858629869372, -0.294145790144752,
    -0.384037673792421, -0.384037673792421, 0.0374542295773345,
    -0.126689730715761, -0.0732225659783105, -0.0732225659783105,
    0.103260641535857, 0.179088091909104, -0.0488091379129944,
    -0.947578113843131, -0.606019988745503, -0.473334587346908,
    -0.236955919521633, -0.195526007765597, -0.0688010780860252,
    -0.0392834493026195, 0.189928469830611, 0.21717147287679,
    0.222511836808396, 0.234040644079886, 0.168755657511205,
    0.169728133790599, 0.366698379522312, -0.399858629869372,
    -0.294145790144752, 0.121380760680706, 0.00910595279608145,
    0.00910595279608145, 0.0340607755348701, -0.340709976973792,
    -0.310583848151182, -0.295779107765152, -0.18359861595662,
    -0.170364313792911, 0.271469840167182, 0.271469840167182,
    0.271257913696808, 0.204605902971062, 0.242930319240712,
    0.240554295492994, 0.242930319240712, 0.240554295492994,
    0.290076687028269, 0.237905640625681, 0.114993524063036,
    0.152699599788878, -0.24062847407969, -0.177222382324359,
    -0.245297972873039, -0.1716897049522, -0.0498413922857943,
    -0.0602427120173084, -0.00606488931871212, -0.0365248804113624,
    -0.0161146042525035, -0.258096696454203, -0.186266616268125,
    -0.0387572286849415, 0.0575914455113098, 0.157609243121204,
    0.220346301053061, -0.0626777547324119, -0.113851702484695,
    -0.116475605634303, 0.22526164753013, 0.223826799079261,
    0.156828878422261, 0.156828878422261, -0.348685874833428,
    -0.0903521318069049, -0.263248163466929, -0.207718489967913,
    -0.00114280263869193, -0.173123855988071, 0.00717472807613134,
    -0.122226134658981, 0.025464920617837, -0.0355698249808467,
    0.187431184982238, 0.181218694001414, -0.170463957448774,
    -0.182265636600245, -0.162639928396832, -0.08984634445544,
    -0.0728162435542022, -0.102375349892814, -0.083518458576145,
    -0.26562651277574, -0.124224763801435, -0.247398017325716,
    -0.0987361747211609, -0.267357057917193, -0.121190412683788,
    -0.235390425297552, -0.102224269330431, -0.267357057917193,
    -0.11647321800326, -0.258096696454203, 0.0374542295773345,
    -0.126689730715761, -0.0732225659783105, 0.25371891049452,
    0.179088091909104, 0.0189353803356997, 0.0439242698170608,
    0.0885475465440703, 0.0885475465440703, 0.0627230661721545,
    -0.0267785017213478, 0.0513972263582553, 0.0260420185827092,
    0.0176322762568806, -0.0186260827562727, -0.0357699577049284,
    -0.0594521157329645, 0.0508444244300699, 0.142346989140971,
    0.125278734192754, 0.126468071771089, 0.17321276456908,
    0.200109710036431, 0.127527720685718, 0.0276890383196247,
    0.23637704520406, 0.191366461532249, 0.124763311559562,
    -0.0443449571558454, -0.0475135961354155, 0.074234409804811,
    0.0216623623678642, 0.352213438519467, 0.21463189015559,
    -0.189097828932044, 0.100405735385079, 0.144407665462729,
    0.336395360175917, 0.336395360175917, 0.12155167143745,
    0.16287496031754, 0.18641467013746, 0.32607579411487,
    0.357175125935867, 0.224343769580642, 0.237299332647382,
    0.196244695452164, 0.198230836612474, 0.190617207491118,
    0.111580641946218, 0.0872289438148001, -0.0809563578119795,
    0.204355413307292, 0.209639717051386, 0.207342466515434,
    0.207342466515434, 0.197169181872743, -0.0572474800374093,
    -0.0728827033179431, -0.10460003726393, -0.107196252644019,
    0.361813401969034, 0.175102284300755, 0.363949986843691,
    0.177442308769387, 0.215769343564575, 0.261298864778967,
    0.172202480804323, 0.184076703337005, 0.163188602303023,
    0.0493811888871374, 0.175827850286979, 0.163383083228185,
    -0.0462305614889876, -0.10500182436349, -0.0595021447805033,
    -0.107718395073629, -0.081368118853961, -0.10288400064567,
    -0.0687391241662543, -0.0840863186508532, -0.0922241572577749,
    -0.279777090829456, -0.113889925777426, 0.0930136922441679,
    0.0930136922441679, 0.0582604661375774, 0.181541045905811,
    0.160535840342632, 0.138401158506572, 0.0244932126510834,
    0.00542933620282285, 0.0633164368215588, 0.128659554552638,
    0.101233497721208, 0.101233497721208, 0.0760249394180194,
    0.0608979020662987, 0.012262059474567, -0.0816046841286946,
    -0.0831343394498383, -0.0814694950097439, -0.109232145394468,
    0.0770377761224491, 0.041925391053174, 0.0274589171017179,
    0.0274589171017179, 0.347617575580373, -0.0596237774820829,
    -0.0794752848265101, -0.0794752848265101, 0.2925962616859,
    -0.0887185089091997, 0.101775115170702, -0.0645242547362925,
    0.27126368025602, -0.137133999832565, 0.1427646918224,
    0.12693641285656, 0.0754012256843574, 0.0625093748503227,
    0.0612182250236711, 0.022647781585492, 0.0122598524089968,
    -0.031821546967195, 0.0950948808259056, 0.194301250561357,
    -0.176407422753569, 0.0770377761224491, 0.041925391053174,
    -0.162369831909575, -0.0320855187783016, -0.0320855187783016,
    -0.553307949537856, 0.0135199811625741, 0.00368762745876068,
    -0.00119025497296702, -0.0393155997407192, -0.0439714980600599,
    0.110325691275902, 0.110325691275902, 0.107266760517285,
    0.18135826013452, -0.070138627603902, -0.084586374173829,
    -0.070138627603902, -0.084586374173829, -0.18934706121959,
    -0.0929298188222547, 0.0852655356749052, -0.179394458894588,
    0.279166751287957, 0.275139241012056, 0.279948761371457,
    0.275155694583494, 0.0121935242055421, 0.0105151849876446,
    -0.0734774746915535, -0.0830825997308687, -0.0261494773912439,
    -0.0137546788196909, -0.0383815439915174, -0.092751399768813,
    0.332355694092576, 0.245345164899538, 0.0254896012212449,
    0.0970805551002128, 0.0811025946105638, 0.0803177348400819,
    0.00164450882011678, -0.0224311131933797, 0.224672875336535,
    0.224672875336535, 0.0383303142014232, -0.0317090718898804,
    0.0098303983136882, -0.00933161038990583, -0.0873586528394907,
    -0.0215767942260494, -0.0908195449342244, -0.040099049184707,
    -0.0985530505261142, -0.0733677092344781, 0.141756395019668,
    0.157166003405932, 0.0508331038597551, 0.0390688659098563,
    0.0540369357658138, 0.0099459590057849, -0.177557776337536,
    0.00493496128474215, -0.130643486152668, 0.113817128307549,
    -0.142574086775631, 0.100786016919189, -0.15587973038,
    0.109227489252925, -0.163440665982954, 0.099878533303345,
    -0.135287923148148, 0.109227489252925, 0.0333059944181948,
    -0.0137546788196909, 0.347617575580373, -0.0596237774820829,
    -0.0794752848265101, -0.241561147836771, -0.0887185089091997,
    0.0730471534751108, 0.0835002138786142, -0.189280927404009,
    -0.189280927404009, -0.19628855825041, -0.837484070977975,
    0.0753082580083826, 0.0630294638001513, 0.0592929776175618,
    0.0447029449409758, 0.0723308379811164, 0.0645975264797624,
    -0.109593771541039, -0.0811243820180713, -0.0188474302547651,
    0.0685021880400987, 0.0321368032444232, 0.0966486930237446,
    0.0363801672252788, 0.255050941838437, -0.0415198183216256,
    0.0275908041907373, 0.0158480616637525, 0.194606530344896,
    -0.220059902653218, -0.265372977366032, -0.245100901081693,
    -0.434187429432454, -0.274154387736992, -0.498079277975881,
    -0.113234390595495, -0.13592301549537, -0.27298841850198,
    -0.27298841850198, -0.123853386260785, -0.146226945009001,
    -0.160255725328499, -0.220696627341507, -0.245525340689894,
    0.265599932544055, 0.240132044079803, 0.12044536185896,
    0.122242899082191, 0.11558414739394, 0.0672807026649379,
    0.0565215464236424, 0.00320786060661828, 0.0811815737084521,
    0.00442292020833086, 0.0259650355832699, 0.0259650355832699,
    0.00159130624929899, 0.0167237159821922, 0.0123103421759687,
    0.0151464759374235, 0.0138398492897789, -0.378259152221767,
    0.0663775142988527, -0.380910748552257, 0.0640455341462561,
    0.0171809160567121, 0.0133244698759663, 0.189239788364039,
    0.105896755907438, 0.131163117931394, 0.0742692098161327,
    -0.17392768225168, -0.100700445594839, 0.0036126603654632,
    -0.0123831512006035, 5.23650575074128e-05, -0.0132043382182284,
    0.00660287534316686, -0.00167186752805072, -0.00240546718672251,
    0.0118803438893343, 0.0424368089424911, 0.219430516658537,
    -0.0151485147157889
    ]).reshape(203, 2, order="F")

mpg_bs_poisson.aic = 1077.25052939687
mpg_bs_poisson.rank = 24
mpg_bs_poisson.sp = np.array([
    40491.3940640059, 232455.530262537
    ])
mpg_bs_poisson.gcv_ubre = -0.733688545240377
mpg_bs_poisson.scale = 1
mpg_bs_poisson.method = "UBRE"
mpg_bs_poisson.Vp = np.array([
    0.00909877938596195, -0.0036458463607326, -0.00588941030822462,
    -0.00591326964084843, 0.00270235043019556, 0.00119384910564329,
    -0.000286097332788069, -0.000538328684681065, -0.00118730774061063,
    -0.00118703780057675, -0.00172055345918883, -0.00282973019584382,
    -0.00279619972795585, -0.00289060805206229, -0.00320325258490701,
    -0.00198704716570621, -0.000847222204131792, 2.70515273679747e-05,
    0.000326844162490547, 0.00135256413351957, 0.0022188465918784,
    0.00337126604512471, 0.00374620280538731, 0.00434814343158575,
    -0.0036458463607326, 0.00322561886385797, 0.000818643340518427,
    0.00081636578104383, -0.00190437247620751, -0.000863343934846812,
    0.000139109866047115, 0.000296579927149878, 0.000740568197543185,
    0.000742005374071472, 0.00114977928877198, 0.00200530841336703,
    0.00222811101992064, 0.0024818042434364, 0.00282650455393769,
    0.00146020870965775, 0.000618887019138287, -2.43124025263358e-05,
    -0.000241178336099445, -0.000991378139936192, -0.00162708135143005,
    -0.00248332970180653, -0.00275966775911108, -0.00320503008932793,
    -0.00588941030822462, 0.000818643340518427, 0.00565989642595176,
    0.00495199955352287, -0.00137264214791527, -0.000624245731910545,
    0.000134212108893823, 0.000277278672318982, 0.000624575880555572,
    0.00064780126403512, 0.000935707806932052, 0.00148449349573531,
    0.00132234065473106, 0.00121308059577345, 0.00127960812345634,
    0.000598575017370257, 0.000255298927663316, -1.05348849084324e-05,
    -0.000105109656554569, -0.000413488381353818, -0.000668742250888912,
    -0.00101475517128789, -0.00106390221980279, -0.00121570767202619,
    -0.00591326964084843, 0.00081636578104383, 0.00495199955352287,
    0.00612031056002729, -0.000638697385813232, -0.000200756794681808,
    0.000234092062788641, 0.000317400792863984, 0.000474734639710034,
    0.000434320019657147, 0.000459443487096387, 0.000570251932991725,
    0.000195546004426462, 2.72052297316331e-05, -3.78499050833033e-05,
    0.000783804355084115, 0.000338266801002889, -5.98980579055969e-06,
    -0.00012832043843202, -0.000542743279532203, -0.000890014730820339,
    -0.00128430664220486, -0.00146322120108432, -0.00169190306471577,
    0.00270235043019556, -0.00190437247620751, -0.00137264214791527,
    -0.000638697385813232, 0.00467632009472188, 0.00125238169504067,
    -0.00129877704188898, -0.0015159828401994, -0.00244941224999582,
    -0.00216501742563322, -0.00281375885789835, -0.00449408146252495,
    -0.00364816304284394, -0.00343278843606667, -0.0037656405854337,
    -0.0019530192987073, -0.000823926841909847, 5.56765347348377e-05,
    0.000369977630385713, 0.00139228419735132, 0.00223783577417036,
    0.00315107722344203, 0.00316419340408527, 0.00352917384733862,
    0.00119384910564329, -0.000863343934846812, -0.000624245731910545,
    -0.000200756794681808, 0.00125238169504067, 0.00114727766243173,
    0.000242162647776926, 4.77172748392219e-06, -0.00037150498020405,
    -0.000523254030404203, -0.000886617935612452, -0.00140688678525427,
    -0.00151777207774812, -0.00163789857683012, -0.0018417095344788,
    -0.000869233941992018, -0.000381264599266638, -2.19177180982826e-06,
    0.000134563688210397, 0.000592929102356622, 0.000989340528530486,
    0.00149625051966445, 0.00155348190492993, 0.00176000748685542,
    -0.000286097332788069, 0.000139109866047115, 0.000134212108893823,
    0.000234092062788641, -0.00129877704188898, 0.000242162647776926,
    0.0011787952545672, 0.00103397353567405, 0.00113707718574448,
    0.000747670650180816, 0.000637468318331369, 0.000963934771472604,
    0.000259239399462997, -3.13740933986805e-05, -9.8258454258689e-05,
    0.000164389952506784, 4.78756078126526e-05, -4.80106456474847e-05,
    -8.33829838965235e-05, -0.000166890570625039, -0.000205380711729347,
    -9.50907045530586e-05, 1.1901907320833e-05, 7.14426605544705e-05,
    -0.000538328684681065, 0.000296579927149878, 0.000277278672318982,
    0.000317400792863984, -0.0015159828401994, 4.77172748392219e-06,
    0.00103397353567405, 0.00107361395477902, 0.00125357393902288,
    0.000898511162091638, 0.000812608069611423, 0.00117847586239195,
    0.000443230767944589, 0.00015806917585112, 0.000106018646194562,
    0.000333721015978061, 0.000120100408758941, -5.31389194723373e-05,
    -0.000117871111748406, -0.000291886194606976, -0.000404124403497883,
    -0.000356618262057166, -0.000229210620899383, -0.000185219275316426,
    -0.00118730774061063, 0.000740568197543185, 0.000624575880555572,
    0.000474734639710034, -0.00244941224999582, -0.00037150498020405,
    0.00113707718574448, 0.00125357393902288, 0.00175782412570737,
    0.00141365990412939, 0.00148450143229436, 0.00216483804024586,
    0.00123800831660394, 0.000907681260528922, 0.000916494035161101,
    0.000815197396104502, 0.000324866910653185, -6.44236841260061e-05,
    -0.000207212018218033, -0.000635132377386486, -0.000959491791422852,
    -0.00113713913236256, -0.000994541303512086, -0.00102792706388811,
    -0.00118703780057675, 0.000742005374071472, 0.00064780126403512,
    0.000434320019657147, -0.00216501742563322, -0.000523254030404203,
    0.000747670650180816, 0.000898511162091638, 0.00141365990412939,
    0.00136045936923501, 0.0014680793668956, 0.00203686187559336,
    0.00119847526169048, 0.000904176981254769, 0.000896852593619694,
    0.000848078442321369, 0.000345820664123864, -5.15527865984296e-05,
    -0.000197519992775655, -0.000645609416220365, -0.000997761381187661,
    -0.0012404390560521, -0.00109680508351927, -0.00113967714137046,
    -0.00172055345918883, 0.00114977928877198, 0.000935707806932052,
    0.000459443487096387, -0.00281375885789835, -0.000886617935612452,
    0.000637468318331369, 0.000812608069611423, 0.00148450143229436,
    0.0014680793668956, 0.00217084016500343, 0.0029750070358662,
    0.00208433309826413, 0.00172182542303662, 0.00174611536201217,
    0.00129960828944164, 0.000548751370569655, -3.79946139891241e-05,
    -0.000250001401133244, -0.00093656323979694, -0.00150718818010699,
    -0.00208363853621429, -0.00197367970588831, -0.00213273444541255,
    -0.00282973019584382, 0.00200530841336703, 0.00148449349573531,
    0.000570251932991725, -0.00449408146252495, -0.00140688678525427,
    0.000963934771472604, 0.00117847586239195, 0.00216483804024586,
    0.00203686187559336, 0.0029750070358662, 0.00501513876862512,
    0.00399535121928084, 0.00350598390589745, 0.00362456785335549,
    0.00212078488398862, 0.000906131205084277, -3.6454396313134e-05,
    -0.000372397355810615, -0.0014864096281366, -0.00242880305206317,
    -0.00353282386838665, -0.00350718581597741, -0.00389458456296836,
    -0.00279619972795585, 0.00222811101992064, 0.00132234065473106,
    0.000195546004426462, -0.00364816304284394, -0.00151777207774812,
    0.000259239399462997, 0.000443230767944589, 0.00123800831660394,
    0.00119847526169048, 0.00208433309826413, 0.00399535121928084,
    0.0054507568567451, 0.00470241993895167, 0.00493055279786896,
    0.00201853749109608, 0.000885809556650048, 1.83923039664673e-05,
    -0.000283050691529295, -0.00133250331426772, -0.00225236010538653,
    -0.00359833596867777, -0.00395366352736832, -0.00461628776343853,
    -0.00289060805206229, 0.0024818042434364, 0.00121308059577345,
    2.72052297316331e-05, -0.00343278843606667, -0.00163789857683012,
    -3.13740933986805e-05, 0.00015806917585112, 0.000907681260528922,
    0.000904176981254769, 0.00172182542303662, 0.00350598390589745,
    0.00470241993895167, 0.0078325224613628, 0.00915323598243506,
    0.00210730280021935, 0.000947137882568041, 7.05701947291954e-05,
    -0.000224872498960712, -0.00130765819682263, -0.00228758006518242,
    -0.0039547935932424, -0.00485413154696321, -0.00588024148548991,
    -0.00320325258490701, 0.00282650455393769, 0.00127960812345634,
    -3.78499050833033e-05, -0.0037656405854337, -0.0018417095344788,
    -9.8258454258689e-05, 0.000106018646194562, 0.000916494035161101,
    0.000896852593619694, 0.00174611536201217, 0.00362456785335549,
    0.00493055279786896, 0.00915323598243506, 0.0136836741339633,
    0.00237864146497212, 0.00108182905868904, 0.000109069014228716,
    -0.000213065408232925, -0.00142680000774472, -0.00254134923813102,
    -0.00458047582769968, -0.00592196661560628, -0.00727888553074047,
    -0.00198704716570621, 0.00146020870965775, 0.000598575017370257,
    0.000783804355084115, -0.0019530192987073, -0.000869233941992018,
    0.000164389952506784, 0.000333721015978061, 0.000815197396104502,
    0.000848078442321369, 0.00129960828944164, 0.00212078488398862,
    0.00201853749109608, 0.00210730280021935, 0.00237864146497212,
    0.0019076370303838, 0.000759586105406085, -0.000122960434399537,
    -0.000420867297024075, -0.00139652592551323, -0.0021704465936693,
    -0.00288314395021324, -0.00291742522906299, -0.00325655842738453,
    -0.000847222204131792, 0.000618887019138287, 0.000255298927663316,
    0.000338266801002889, -0.000823926841909847, -0.000381264599266638,
    4.78756078126526e-05, 0.000120100408758941, 0.000324866910653185,
    0.000345820664123864, 0.000548751370569655, 0.000906131205084277,
    0.000885809556650048, 0.000947137882568041, 0.00108182905868904,
    0.000759586105406085, 0.0003656939785206, 2.82567281665219e-05,
    -0.000101646821262282, -0.000512930233362397, -0.000872443999184792,
    -0.00131618762009045, -0.00140260317866891, -0.00159801030917644,
    2.70515273679747e-05, -2.43124025263358e-05, -1.05348849084324e-05,
    -5.98980579055969e-06, 5.56765347348377e-05, -2.19177180982826e-06,
    -4.80106456474847e-05, -5.31389194723373e-05, -6.44236841260061e-05,
    -5.15527865984296e-05, -3.79946139891241e-05, -3.6454396313134e-05,
    1.83923039664673e-05, 7.05701947291954e-05, 0.000109069014228716,
    -0.000122960434399537, 2.82567281665219e-05, 0.000149057409866348,
    0.000158033153508944, 0.000181471124454999, 0.000130884181218961,
    -0.00015302847096016, -0.000310903996678885, -0.000420681148041455,
    0.000326844162490547, -0.000241178336099445, -0.000105109656554569,
    -0.00012832043843202, 0.000369977630385713, 0.000134563688210397,
    -8.33829838965235e-05, -0.000117871111748406, -0.000207212018218033,
    -0.000197519992775655, -0.000250001401133244, -0.000372397355810615,
    -0.000283050691529295, -0.000224872498960712, -0.000213065408232925,
    -0.000420867297024075, -0.000101646821262282, 0.000158033153508944,
    0.000255704147038991, 0.000426656151552186, 0.000483132475498153,
    0.000219787363688364, 1.1439794023618e-05, -9.02272784316804e-05,
    0.00135256413351957, -0.000991378139936192, -0.000413488381353818,
    -0.000542743279532203, 0.00139228419735132, 0.000592929102356622,
    -0.000166890570625039, -0.000291886194606976, -0.000635132377386486,
    -0.000645609416220365, -0.00093656323979694, -0.0014864096281366,
    -0.00133250331426772, -0.00130765819682263, -0.00142680000774472,
    -0.00139652592551323, -0.000512930233362397, 0.000181471124454999,
    0.000426656151552186, 0.00117095478565454, 0.00164149083642214,
    0.00169588353149587, 0.00141489783224005, 0.00143202572023981,
    0.0022188465918784, -0.00162708135143005, -0.000668742250888912,
    -0.000890014730820339, 0.00223783577417036, 0.000989340528530486,
    -0.000205380711729347, -0.000404124403497883, -0.000959491791422852,
    -0.000997761381187661, -0.00150718818010699, -0.00242880305206317,
    -0.00225236010538653, -0.00228758006518242, -0.00254134923813102,
    -0.0021704465936693, -0.000872443999184792, 0.000130884181218961,
    0.000483132475498153, 0.00164149083642214, 0.00265334294416382,
    0.00305296134009041, 0.00272287720213162, 0.00283652481021948,
    0.00337126604512471, -0.00248332970180653, -0.00101475517128789,
    -0.00128430664220486, 0.00315107722344203, 0.00149625051966445,
    -9.50907045530586e-05, -0.000356618262057166, -0.00113713913236256,
    -0.0012404390560521, -0.00208363853621429, -0.00353282386838665,
    -0.00359833596867777, -0.0039547935932424, -0.00458047582769968,
    -0.00288314395021324, -0.00131618762009045, -0.00015302847096016,
    0.000219787363688364, 0.00169588353149587, 0.00305296134009041,
    0.00667821352504447, 0.00531692615725814, 0.00566170373323159,
    0.00374620280538731, -0.00275966775911108, -0.00106390221980279,
    -0.00146322120108432, 0.00316419340408527, 0.00155348190492993,
    1.1901907320833e-05, -0.000229210620899383, -0.000994541303512086,
    -0.00109680508351927, -0.00197367970588831, -0.00350718581597741,
    -0.00395366352736832, -0.00485413154696321, -0.00592196661560628,
    -0.00291742522906299, -0.00140260317866891, -0.000310903996678885,
    1.1439794023618e-05, 0.00141489783224005, 0.00272287720213162,
    0.00531692615725814, 0.0135149981987308, 0.0166147008644102,
    0.00434814343158575, -0.00320503008932793, -0.00121570767202619,
    -0.00169190306471577, 0.00352917384733862, 0.00176000748685542,
    7.14426605544705e-05, -0.000185219275316426, -0.00102792706388811,
    -0.00113967714137046, -0.00213273444541255, -0.00389458456296836,
    -0.00461628776343853, -0.00588024148548991, -0.00727888553074047,
    -0.00325655842738453, -0.00159801030917644, -0.000420681148041455,
    -9.02272784316804e-05, 0.00143202572023981, 0.00283652481021948,
    0.00566170373323159, 0.0166147008644102, 0.0269823093695889
    ]).reshape(24, 24, order="F")

mpg_bs_poisson.hat = np.array([
    0.0278593212349963, 0.027859321234996, 0.0271835195981152,
    0.0165279929083336, 0.106781936158984, 0.0194662437332315,
    0.032295750296588, 0.0392619596780691, 0.0387156790274354,
    0.114565355904326, 0.0347318387160548, 0.0347318387160548,
    0.0228149079107915, 0.0217158582339006, 0.0226951242421406,
    0.0312506509654928, 0.0318481724122817, 0.0352629615723995,
    0.229347195519636, 0.0253668202191401, 0.0208533777040901,
    0.0247060214667431, 0.0247060214667431, 0.0261095683466317,
    0.016415969487458, 0.0154908151248992, 0.0154908151248992,
    0.0215702656628941, 0.0246341814860533, 0.033024840861246,
    0.0660866602564387, 0.040500099040622, 0.0329890825445826,
    0.0196669792093725, 0.0180524070739387, 0.0141322217010847,
    0.0134767343098439, 0.0123733758938561, 0.0132174514515368,
    0.0135856020119763, 0.0160613943332619, 0.0171673739746131,
    0.0162889185023652, 0.0485512446138166, 0.02536682021914,
    0.0208533777040901, 0.0404724478456156, 0.135373825547302,
    0.135373825547302, 0.192162273241016, 0.0228948602165343,
    0.0217338579929625, 0.0211927837843807, 0.0177283103805098,
    0.0173951893767073, 0.0355359517267947, 0.0355359517267947,
    0.0352622341187835, 0.0386500855278607, 0.017655808362093,
    0.0190761298888524, 0.017655808362093, 0.0190761298888524,
    0.0752191165687181, 0.0199904451725522, 0.0238501163229081,
    0.0891159763302456, 0.0657836672940597, 0.0963530173668623,
    0.0646615754412069, 0.100691872326665, 0.06033845881374,
    0.051792376639415, 0.0842503682370257, 0.052617884986705,
    0.0355957283088215, 0.0199032628746703, 0.017797453185194,
    0.0150732837773955, 0.0247293015271973, 0.0239780538499133,
    0.0139263614080384, 0.03309919684783, 0.0341928110637857,
    0.0342941422407387, 0.015130443108706, 0.0168053218757406,
    0.022918472066971, 0.022918472066971, 0.0230879899045791,
    0.105985842333657, 0.019847007766673, 0.0180867449319177,
    0.0142596333538319, 0.0171312035471302, 0.0142156281620368,
    0.0159333133036568, 0.0141551440885177, 0.0145460670838214,
    0.0147268920838561, 0.0148410373945601, 0.0406040382229733,
    0.0500664761273972, 0.0395694935907428, 0.0222494280433288,
    0.0489485080155037, 0.0217807712860658, 0.0417801872726058,
    0.0616984761864518, 0.0552866936833232, 0.0686076962087453,
    0.0474517838023861, 0.0621959473606664, 0.0633944902963094,
    0.0726748960865953, 0.0445267766286251, 0.0621959473606664,
    0.0190408664090557, 0.0199032628746703, 0.0261095683466317,
    0.016415969487458, 0.0154908151248992, 0.020050321292679,
    0.0246341814860533, 0.0234112464358267, 0.0243908733143132,
    0.0861043314604194, 0.0861043314604194, 0.081590807360981,
    0.302520797377801, 0.0232324062134501, 0.0247834182699543,
    0.0253300650870489, 0.0278009383597399, 0.0414535179805262,
    0.0409418131857217, 0.014157417875456, 0.0130282960809025,
    0.138598903485126, 0.0119217227225527, 0.0118879906828549,
    0.0141551657727111, 0.123783953258847, 0.11912545095407,
    0.0142268306190214, 0.0172399619813334, 0.121846395543782,
    0.110470500089909, 0.0201551990336182, 0.0206310745751254,
    0.0201536865625068, 0.0381417658252338, 0.147146341940793,
    0.19291538753225, 0.0138996856259478, 0.0145038473004087,
    0.0816344563835501, 0.0816344563835501, 0.0141422035219747,
    0.0148789474728842, 0.0154853081668733, 0.0606395671173926,
    0.0600386292911446, 0.0489884539186971, 0.0451161294598349,
    0.0286513771162332, 0.0288498072754457, 0.0281198522360051,
    0.0237262441315675, 0.0231072922711262, 0.0233676261568825,
    0.013768548515088, 0.0737736816925903, 0.0160520266152111,
    0.0160520266152111, 0.0178865660055972, 0.0246890354271123,
    0.0236757874745378, 0.0207029571112752, 0.0208006880192332,
    0.0871658869688338, 0.0121224793768177, 0.0871468068056535,
    0.012134436832306, 0.0130273070409246, 0.0770270710340484,
    0.0161554288190356, 0.0130060409476929, 0.0131560893519169,
    0.0233495425653485, 0.076546096962634, 0.026653503029336,
    0.0232595679594293, 0.025927102793454, 0.0236164317298477,
    0.0261567967057281, 0.0234612845321249, 0.0224086568560985,
    0.023932672432481, 0.0226000918010269, 0.0185252878980513,
    0.0596358457431316, 0.0267683181821813
    ])
mpg_bs_poisson.Ve = np.array([
    0.00872816910147373, -0.00339468396176873, -0.00574795519757804,
    -0.00574495699516135, 0.00224716621100421, 0.000990731701491968,
    -0.000189207067857561, -0.000360006731927612, -0.000886141060022117,
    -0.000893283809269308, -0.00139841232780236, -0.0024252281957883,
    -0.00248459469487803, -0.00272342482840153, -0.00317621552813653,
    -0.00157392814822113, -0.000726932119992933, -9.18102761507539e-05,
    0.000118849290312744, 0.000936311632940437, 0.00169780728892799,
    0.00302963699787248, 0.00399780133211975, 0.00495376916948824,
    -0.00339468396176873, 0.00304577329137564, 0.00073225495104467,
    0.000711491834517779, -0.00160491657736677, -0.000740799055737486,
    6.70583600031394e-05, 0.000178733920236327, 0.000549296431166237,
    0.00056281173695013, 0.00095383610203774, 0.00175022827549142,
    0.00196954338218556, 0.00232358726439227, 0.00278825293492344,
    0.00117312403915761, 0.000540827007066709, 6.60591721757886e-05,
    -9.18905851433959e-05, -0.000701585089614169, -0.00126800242591629,
    -0.00224803934627821, -0.0029510939846369, -0.00364975898650794,
    -0.00574795519757804, 0.000732254951044672, 0.00559376431953148,
    0.0048832815861983, -0.00121036529463201, -0.000522618964878643,
    0.000129331466175766, 0.000229756269964103, 0.000520627200771865,
    0.000528242761654376, 0.000793896658595473, 0.00131409709061904,
    0.00123306001882202, 0.00121204524436677, 0.00133977901167853,
    0.000447066868582399, 0.000206656393910154, 2.68120895197694e-05,
    -3.23982830841326e-05, -0.000264147901782724, -0.000480668169091168,
    -0.000866639543186555, -0.00114766823435088, -0.00142207357353394,
    -0.00574495699516135, 0.000711491834517781, 0.0048832815861983,
    0.00602768596209419, -0.000389954497461, -0.000109284543659045,
    0.000153323471341307, 0.000194516540158586, 0.000286655256402351,
    0.00026181962881677, 0.000286745600159159, 0.000364719729750488,
    0.000127132330375839, -3.57259747391055e-05, -0.000113354870958816,
    0.000604247534774847, 0.00027994556193377, 3.70691109006243e-05,
    -4.34292704409193e-05, -0.000357747093695074, -0.000651937681315584,
    -0.0011691635350969, -0.00154193389436139, -0.0019129550615053,
    0.00224716621100421, -0.00160491657736676, -0.001210365294632,
    -0.000389954497460996, 0.00347808865504033, 0.00132323474863319,
    -0.000620379681534514, -0.000875315126296074, -0.00166180989091369,
    -0.00157415573423987, -0.00219719238769074, -0.00359642853432569,
    -0.00322310081671098, -0.00324508176487169, -0.0036754827978078,
    -0.00145489369244191, -0.000673422622792495, -8.44792620426521e-05,
    0.000114439223651904, 0.00087738477088068, 0.0015899315444895,
    0.00279655824015247, 0.00351931576929605, 0.00428313495351485,
    0.000990731701491967, -0.000740799055737486, -0.000522618964878641,
    -0.000109284543659043, 0.00132323474863319, 0.000655127288184895,
    -3.31949485214243e-05, -0.000155323487931888, -0.000485224036488008,
    -0.000525887940251636, -0.000857444735942005, -0.0014710758798172,
    -0.00151889596210613, -0.00162673243857201, -0.00186770956717347,
    -0.000670576872257768, -0.000305910136989141, -3.36803230282656e-05,
    5.49951643130221e-05, 0.000401887575890236, 0.000723619175878996,
    0.00128476848340608, 0.00167460705387823, 0.00206379845655073,
    -0.000189207067857561, 6.70583600031395e-05, 0.000129331466175766,
    0.000153323471341307, -0.000620379681534514, -3.3194948521424e-05,
    0.000422458211239026, 0.000450910733051421, 0.000553014417977397,
    0.000427638664078662, 0.000375078726813327, 0.000462151976988038,
    4.37628716599336e-05, -0.000142399734941993, -0.000215753222618727,
    6.94222854016504e-05, 3.58176880944216e-05, 8.26729602061187e-06,
    -4.16972909429667e-06, -4.68178715508534e-05, -9.04312099550322e-05,
    -0.000138757953946595, -6.84432214995606e-05, -3.56841324345881e-05,
    -0.00036000673192761, 0.000178733920236327, 0.000229756269964101,
    0.000194516540158584, -0.000875315126296073, -0.000155323487931888,
    0.00045091073305142, 0.000513445751471091, 0.000684361386829758,
    0.000564523613103732, 0.000557127530201139, 0.000728321718348602,
    0.000247319319788527, 3.11813102293091e-05, -3.58495709368964e-05,
    0.000176725478403447, 8.40441853814431e-05, 1.2884063367738e-05,
    -1.32156712780233e-05, -0.000111399922319692, -0.000207007843868899,
    -0.000346549982398979, -0.000324707449587645, -0.000345070178668886,
    -0.000886141060022115, 0.000549296431166237, 0.000520627200771863,
    0.000286655256402349, -0.00166180989091369, -0.000485224036488007,
    0.000553014417977398, 0.000684361386829759, 0.00104717798807282,
    0.000930183695210662, 0.00108239688315768, 0.00156796247592839,
    0.000988503792692421, 0.000743709136203547, 0.000748419274879713,
    0.000519816001740406, 0.000241988207312757, 3.16745566880191e-05,
    -4.08380043721362e-05, -0.000317995564807066, -0.000580057658691823,
    -0.00100671784474982, -0.00116031132861809, -0.00136423560665091,
    -0.000893283809269305, 0.000562811736950129, 0.000528242761654373,
    0.000261819628816767, -0.00157415573423987, -0.000525887940251636,
    0.000427638664078662, 0.000564523613103732, 0.000930183695210662,
    0.000867331523647151, 0.00106939619159995, 0.00155756066124217,
    0.0010416712048185, 0.000776436361361746, 0.000757354625789488,
    0.000541961987886794, 0.000250102803056663, 2.95822869438755e-05,
    -4.5444100946543e-05, -0.000331604928389911, -0.000598935425865254,
    -0.00104269195496842, -0.00123615285468088, -0.00147065125925875,
    -0.00139841232780236, 0.00095383610203774, 0.00079389665859547,
    0.000286745600159156, -0.00219719238769074, -0.000857444735942005,
    0.000375078726813327, 0.00055712753020114, 0.00108239688315768,
    0.00106939619159995, 0.00149905346295801, 0.0023405849562749,
    0.00191121806564683, 0.00164358471205581, 0.0017027266462958,
    0.000904783145661926, 0.000415377716654449, 4.56470624574401e-05,
    -7.92803869682595e-05, -0.000552385079626244, -0.000988604209615911,
    -0.00171872712720447, -0.00215133730382456, -0.00261401889078434,
    -0.0024252281957883, 0.00175022827549142, 0.00131409709061904,
    0.000364719729750487, -0.00359642853432569, -0.0014710758798172,
    0.000462151976988038, 0.000728321718348603, 0.00156796247592839,
    0.00155756066124217, 0.0023405849562749, 0.0039088898099519,
    0.00364159235175025, 0.00349905560597342, 0.0038280072030944,
    0.00160819428106233, 0.00074093038951584, 8.64602484454594e-05,
    -0.000134359425008037, -0.000974546598810599, -0.0017520858786637,
    -0.00305919315908029, -0.00391522429010944, -0.00478876794679771,
    -0.00248459469487803, 0.00196954338218556, 0.00123306001882202,
    0.000127132330375837, -0.00322310081671099, -0.00151889596210613,
    4.37628716599345e-05, 0.000247319319788529, 0.000988503792692423,
    0.00104167120481851, 0.00191121806564683, 0.00364159235175025,
    0.00427747479690955, 0.00482928519286143, 0.00563321398275932,
    0.00171333375611591, 0.000795214335892069, 0.000106073729510994,
    -0.000123743108712854, -0.00101566834189828, -0.00185063249872698,
    -0.00330927681181626, -0.00437251673625904, -0.00540106432140404,
    -0.00272342482840152, 0.00232358726439227, 0.00121204524436677,
    -3.57259747391077e-05, -0.0032450817648717, -0.00162673243857201,
    -0.000142399734941992, 3.1181310229311e-05, 0.000743709136203549,
    0.000776436361361748, 0.00164358471205581, 0.00349905560597342,
    0.00482928519286144, 0.00679529287071828, 0.00867848826510314,
    0.00191454657067405, 0.000893686518678206, 0.000131097434522782,
    -0.000120621416599359, -0.0011120366898956, -0.00204532106563245,
    -0.00375476941624536, -0.00508809209712206, -0.00637650927364873,
    -0.00317621552813653, 0.00278825293492344, 0.00133977901167853,
    -0.000113354870958815, -0.00367548279780781, -0.00186770956717347,
    -0.000215753222618726, -3.58495709368943e-05, 0.000748419274879716,
    0.00075735462578949, 0.0017027266462958, 0.0038280072030944,
    0.00563321398275933, 0.00867848826510315, 0.0114797679780233,
    0.00225266160157913, 0.00105267921968938, 0.000157467497218995,
    -0.000137250335155586, -0.00130186657852725, -0.00239998833772016,
    -0.00442972809291755, -0.00604742087075733, -0.00762459540851679,
    -0.00157392814822113, 0.00117312403915761, 0.000447066868582396,
    0.000604247534774846, -0.00145489369244191, -0.000670576872257768,
    6.94222854016507e-05, 0.000176725478403448, 0.000519816001740407,
    0.000541961987886795, 0.000904783145661927, 0.00160819428106233,
    0.00171333375611591, 0.00191454657067405, 0.00225266160157912,
    0.00138295707156965, 0.000624543916825117, 4.93371286792608e-05,
    -0.000145621616781563, -0.0008685953533989, -0.00152273289335141,
    -0.00253967960701902, -0.00314876360829266, -0.0038150828662408,
    -0.000726932119992933, 0.000540827007066709, 0.000206656393910153,
    0.000279945561933769, -0.000673422622792496, -0.000305910136989141,
    3.58176880944217e-05, 8.40441853814434e-05, 0.000241988207312757,
    0.000250102803056663, 0.000415377716654449, 0.00074093038951584,
    0.000795214335892069, 0.000893686518678206, 0.00105267921968938,
    0.000624543916825117, 0.000287643505998226, 3.39635762765042e-05,
    -5.12049900753606e-05, -0.000377085568870121, -0.000679123650043239,
    -0.00119117072751177, -0.00153274854087477, -0.00188156469729417,
    -9.18102761507542e-05, 6.60591721757888e-05, 2.68120895197695e-05,
    3.70691109006244e-05, -8.44792620426523e-05, -3.36803230282657e-05,
    8.26729602061192e-06, 1.2884063367738e-05, 3.16745566880192e-05,
    2.95822869438756e-05, 4.56470624574404e-05, 8.64602484454597e-05,
    0.000106073729510994, 0.000131097434522782, 0.000157467497218995,
    4.9337128679261e-05, 3.39635762765042e-05, 2.66906844580494e-05,
    2.64717949099258e-05, 2.6942083569786e-06, -3.43810706259764e-05,
    -0.000187245806988418, -0.000361958427993108, -0.00049570481303046,
    0.000118849290312744, -9.18905851433959e-05, -3.23982830841322e-05,
    -4.34292704409189e-05, 0.000114439223651904, 5.49951643130221e-05,
    -4.16972909429665e-06, -1.32156712780234e-05, -4.08380043721362e-05,
    -4.54441009465431e-05, -7.92803869682594e-05, -0.000134359425008036,
    -0.000123743108712854, -0.000120621416599359, -0.000137250335155585,
    -0.000145621616781563, -5.12049900753606e-05, 2.64717949099258e-05,
    5.63250510334895e-05, 0.000136116105336803, 0.000188342525646407,
    0.000141805903619892, -5.6569241879348e-06, -8.72594247231751e-05,
    0.000936311632940437, -0.000701585089614169, -0.000264147901782722,
    -0.000357747093695073, 0.000877384770880681, 0.000401887575890236,
    -4.68178715508535e-05, -0.000111399922319692, -0.000317995564807066,
    -0.000331604928389912, -0.000552385079626245, -0.000974546598810599,
    -0.00101566834189828, -0.0011120366898956, -0.00130186657852725,
    -0.0008685953533989, -0.000377085568870121, 2.69420835697873e-06,
    0.000136116105336803, 0.000596700760715439, 0.000993015790871507,
    0.00145969880241004, 0.00156609372992679, 0.00178733690750938,
    0.00169780728892799, -0.0012680024259163, -0.000480668169091165,
    -0.000651937681315582, 0.0015899315444895, 0.000723619175878997,
    -9.04312099550323e-05, -0.000207007843868899, -0.000580057658691824,
    -0.000598935425865255, -0.000988604209615911, -0.0017520858786637,
    -0.00185063249872698, -0.00204532106563245, -0.00239998833772016,
    -0.00152273289335141, -0.000679123650043239, -3.43810706259762e-05,
    0.000188342525646407, 0.000993015790871507, 0.00171294384116696,
    0.0027222383901314, 0.00310105715221944, 0.00362843568148568,
    0.00302963699787247, -0.00224803934627821, -0.000866639543186551,
    -0.0011691635350969, 0.00279655824015248, 0.00128476848340608,
    -0.000138757953946596, -0.000346549982398981, -0.00100671784474982,
    -0.00104269195496842, -0.00171872712720447, -0.00305919315908029,
    -0.00330927681181626, -0.00375476941624536, -0.00442972809291755,
    -0.00253967960701902, -0.00119117072751177, -0.000187245806988417,
    0.000141805903619892, 0.00145969880241004, 0.0027222383901314,
    0.00515370886632995, 0.0065551716667555, 0.00794460693942517,
    0.00399780133211975, -0.00295109398463691, -0.00114766823435088,
    -0.00154193389436139, 0.00351931576929606, 0.00167460705387823,
    -6.8443221499562e-05, -0.000324707449587647, -0.00116031132861809,
    -0.00123615285468089, -0.00215133730382457, -0.00391522429010945,
    -0.00437251673625905, -0.00508809209712206, -0.00604742087075734,
    -0.00314876360829266, -0.00153274854087477, -0.000361958427993108,
    -5.65692418793445e-06, 0.00156609372992679, 0.00310105715221944,
    0.00655517166675551, 0.0113123859861714, 0.0152750741086272,
    0.00495376916948825, -0.00364975898650795, -0.00142207357353394,
    -0.0019129550615053, 0.00428313495351486, 0.00206379845655074,
    -3.56841324345902e-05, -0.000345070178668888, -0.00136423560665091,
    -0.00147065125925876, -0.00261401889078435, -0.00478876794679772,
    -0.00540106432140405, -0.00637650927364873, -0.0076245954085168,
    -0.00381508286624081, -0.00188156469729417, -0.00049570481303046,
    -8.72594247231747e-05, 0.00178733690750939, 0.00362843568148569,
    0.00794460693942518, 0.0152750741086272, 0.0213508475270903
    ]).reshape(24, 24, order="F")

mpg_bs_poisson.edf_all = np.array([
    1, 1, 1, 0.999999999999997, 0.138685243481343, 0.168020596767126,
    0.0480405022511898, 0.18786734224937, 0.263638943922787,
    0.146831418768435, 0.125821886761792, 0.418244018451644,
    0.291958034715267, 0.259042421165291, 0.491718306066333,
    0.0608764913352002, 0.0736205393644838, 0.0110857218278732,
    0.028133863911819, 0.110523411158202, 0.279890851829335,
    0.403214040630245, 0.283218020486634, 0.455736703811175
    ])
mpg_bs_poisson.edf1 = np.array([
    1, 1, 1, 1, 0.165131311402747, 0.216628750997608, 0.129858492449922,
    0.280058095563882, 0.341868441797401, 0.189284980057434,
    0.176944029164426, 0.479986234409329, 0.34393973921471,
    0.289638759873068, 0.596490313025557, 0.0984847261596164,
    0.0965664680726603, 0.0206746315637887, 0.0529176753037307,
    0.200932398735361, 0.350970375831462, 0.461975872101362,
    0.300898156007137, 0.569596548903937
    ])
mpg_bs_poisson.R = np.array([
    -71.5821206726932, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -63.1163195158524, 1.95757286856305, -23.03254478422, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -46.8273357718321, 34.0470354731819, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -21.8490313684801, -30.0505437246368,
    1.40770182956625, 1.68556625008646, -2.33893485610153,
    -1.33644268314491, 1.21748327751584, -13.039284154087, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.477512967307601, 1.36236539597893,
    -0.516947348486553, 1.07236058110657, 1.08928898765604,
    -0.965998498019831, -0.580778688841, -0.103016956860158,
    0.0184449837168278, 0.361357837171709, -0.464334724997202,
    -1.02057754551832, -0.299987104352742, 1.80074339194746,
    -0.807813756458929, 2.40827617334435, -0.068186720122408,
    0.0120341609759849, -0.0714580439975603, 1.60007697893804,
    -0.0315471704511174, 0.00174858263390992, -2.55467758285728, 0,
    -1.94900954154811, 6.19817892188406, -1.8514278254703,
    5.39525477464455, 6.19207697202972, -4.25530534923462,
    -2.51014242072305, -0.586660999222762, 1.17041680362472,
    2.12445724226536, -2.39192663928419, -4.04595116579218,
    -1.79447003222895, 0.804202405659664, -2.11710630419854,
    7.37240445494639, 0, 0, 0, 0, 0, 0, 0, 0, -2.21982688976771,
    7.7395352430774, -1.6751571140575, 7.56715279972929, 7.30080835108233,
    1.30107966459169, -1.80079225151029, -0.806502495251811,
    3.32849433060211, 3.92547834938874, -3.50082013772898,
    -2.24037842904234, -1.52868797203916, -8.53164933157901, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -0.779934937130817, 2.62565093082503, 2.37073115328689,
    -4.28817123758634, -0.080751581857798, 14.6440439255311, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.00721786546787323,
    0.98127850057242, 0.642005259909329, -16.9010047937415, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.559947748920377,
    -1.80166368984726, 0.489168077483038, -4.15787304705626,
    -1.16413896794078, -4.1032957977653, 0.00909265186432576,
    0.752308897124599, 1.84302277997761, 3.63848082642309,
    5.19246694919925, 0.48720611571256, 9.04725561644245, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1.33514967817744, -3.49667821149016, -0.949152089498797,
    2.33399066330522, -2.80504453980125, -2.10518798719649,
    -0.343186214002096, 0.309526050154829, 0.661705900096051,
    0.315536573689153, 11.3726887141719, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2.73373491518617, -9.14611149382971, -0.463450746514161,
    5.26288495850026, -4.16738776540214, -3.20802369644502,
    2.78287983487152, -0.0939459297044367, -0.834978565680418,
    -12.2261879092477, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1.10004440041883, -4.93728604305982, 2.91932210864771,
    1.89037492948015, -0.932939049536182, -1.38193812679339,
    2.80775419027974, -0.601410745457799, 0.180123074039231,
    -2.26092553127237, -2.77311967088501, -0.0475111049957128,
    -0.298723876097052, 0.49295938848852, -2.50496710148361,
    -0.363824334720354, -2.26911551733168, -0.800331975389022,
    4.71516553087557, 0, 0, 0, 0, 0, 0.521119657625995, -2.05376381949499,
    1.7637835270072, 0.382058703847093, -0.157138929322969,
    -0.352470776826791, 0.442095459819672, -0.620896142051542,
    -0.457143594021276, 1.11701211900279, -0.771197137215035,
    0.382509579433449, -0.637920544080794, -0.19636944712839,
    -2.76095163778409, -0.0947648491593383, -1.60128758325565,
    1.05889279565606, 1.78283600847369, 0.0827697362327962,
    0.218447667335008, 3.56313091806667, 0, 0, 0.631212637260466,
    -1.43181573732286, 0.231747714762957, 0.0817399534247477,
    -0.0191900919104383, 0.00315244044777415, -0.211271235128332,
    -0.654119719624449, -0.857096543383966, 1.01894195349241,
    -0.341970246302318, 0.20866595535429, -0.226607932020836,
    -0.382067742181455, -1.16014914733138, 0.313204150352656,
    -2.23313682027299, 5.8383560790515, 0, 0, 0, 0, 0, 0,
    -0.77739992608371, 1.70512529554269, 3.26377154649538,
    0.616731997782261, -1.22884035403489, 1.42732927607925,
    -1.78350620625032, 1.34408727146986, -2.22109103908636,
    0.374505046759324, -0.766005558718678, -2.75743149949993,
    -0.0443578352818244, -1.12197437067228, 2.10278895946825,
    2.07430877165134, 0.881169500456017, 0.203003516625478,
    0.627165413354841, 4.0985822451904, 0, 0, 0, 0, -2.61037802516482,
    7.10140197572962, 0.597866576138827, 5.21643971120884,
    9.17062486512179, -1.56538905540272, -5.72360591829728,
    0.857449637772138, -0.644155500096225, 0.949492249967968,
    -2.26262138985532, -10.5362935297102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, -2.26318396694959, 6.97084348380242, -1.5006632362559,
    1.66744909447148, 15.7888497366534, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0.0496774228639256, 1.86310661230033,
    -0.8272677443453, -7.44929919853572, 0.995164284588838,
    3.01067551468633, 13.2219405804393, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1.18880771256503, -4.58559767759348, -0.974627218954948,
    -5.46919176135887, -7.86735032370101, 0.861962770166428,
    2.69197570190762, -0.734283418223097, 12.644321994236, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.07623547346335, -8.62932481974462,
    -2.13857134893133, 1.5825646709196, -6.58768256173109,
    -2.58784289247216, -4.30598759996588, -1.26625993853579,
    -2.48907995763337, -4.65911790973383, 4.62545007584609,
    3.11445832767583, 2.20915643341365, -3.26733566329173,
    -7.7493938227666, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.87720554340571,
    -3.76749683704365, -1.73164309687615, 1.81639739721087,
    -1.47932696365048, -0.948605303989834, -0.410383046915831,
    -1.05087501851937, -4.8979223147175, -3.30035763721004,
    1.46248036466027, 0.437677409315923, -0.0283492883614992,
    -1.55967175361477, -0.671687000238254, 0.218048691423501,
    -6.70295046711722, 0, 0, 0, 0, 0, 0, 0, 0.625033934606065,
    -1.35783399962003, -0.576223529002243, 0.453104537893816,
    -0.0700080316501341, -0.132805233101403, 0.0232107773508051,
    -0.533797950669129, -1.2242088732616, -0.292185501092755,
    0.653783193502416, -0.203012833152524, -0.233292506440238,
    -0.257179556553545, 0.701886900587847, 0.180875662130529,
    -2.78710370715732, 0.501821705771827, 0.199861513010874,
    0.0705449671051595, 0.65845009000007, 0.271741081238087,
    0.0296247577347264, 2.29204423094291, 0.295179535981046,
    -0.498021301042363, -0.191083976072719, 0.10022620819189,
    0.149938173134123, -0.000647738071340076, 0.0932506134932401,
    -0.255992650247112, -0.173965873880064, 0.0746464264713858,
    -0.0438028632249015, -0.161854602228138, -0.0578372113962488,
    0.157297649723395, 0.195127506637709, -0.126981325801707,
    -0.201542068281104, 0.633451731139413, 1.23686433543792,
    0.0741286829376448, 3.93651436085439, 0, 0, 0
    ]).reshape(24, 24, order="F")

mpg_bs_poisson.nsdf = 4
mpg_bs_poisson.sig2 = 1
mpg_bs_poisson.cmX = np.array([
    1, 0.901477832512315, 0.58128078817734, 0.374384236453202, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    ])
mpg_bs_poisson.assign = np.array([
    0, 1, 2, 2
    ])
mpg_bs_poisson.offset = np.array([
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    ])
mpg_bs_poisson.df_residual = 194.753831641044
mpg_bs_poisson.min_edf = 6
mpg_bs_poisson.optimizer = np.array([
 "outer", "newton"
    ])
mpg_bs_poisson.p_coeff = np.array([
    3.38155196812657, -0.2398057983025, 0.0385574655971876,
    0.0308789097162079
    ])
mpg_bs_poisson.se = np.array([
    0.0953875221712041, 0.0567945319890742, 0.0752322831366413,
    0.0782324137428169, 0.0683836244631848, 0.0338714874552585,
    0.0343335878487408, 0.0327660488124372, 0.0419264132225423,
    0.036884405501987, 0.0465922758083723, 0.0708176444724415,
    0.0738292412039099, 0.0885015393163463, 0.116977237674529,
    0.0436765043288013, 0.0191231267976919, 0.0122089069890121,
    0.0159907519222515, 0.0342192166136885, 0.0515106100154504,
    0.0817203372793118, 0.116254024441009, 0.164262927556978
    ])
mpg_bs_poisson.p_t = np.array([
    35.4506741673956, -4.22233954403625, 0.512512235301397,
    0.394707362829427
    ])
mpg_bs_poisson.p_pv = np.array([
    2.83211381163377e-275, 2.41779512472801e-05, 0.608292559428079,
    0.693058868325634
    ])
mpg_bs_poisson.residual_df = 194.753831641044
mpg_bs_poisson.m = 2
mpg_bs_poisson.chi_sq = np.array([
    24.0890023854214, 12.9900133623474
    ])
mpg_bs_poisson.s_pv = np.array([
    4.50054787026542e-05, 0.0019804834204652
    ])
mpg_bs_poisson.scale = 1
mpg_bs_poisson.r_sq = 0.88083178283537
mpg_bs_poisson.n = 203
mpg_bs_poisson.dev_expl = 0.888606170071194
mpg_bs_poisson.edf = np.array([
    2.53986871460058, 1.70629964435497
    ])
mpg_bs_poisson.dispersion = 1
mpg_bs_poisson.pTerms_pv = np.array([
    2.41779512472801e-05, 0.874926047858207
    ])
mpg_bs_poisson.pTerms_chi_sq = np.array([
    17.8281512251323, 0.267231825859481
    ])
mpg_bs_poisson.pTerms_df = np.array([
    1, 2
    ])
mpg_bs_poisson.cov_unscaled = np.array([
    0.00909877938596195, -0.0036458463607326, -0.00588941030822462,
    -0.00591326964084843, 0.00270235043019556, 0.00119384910564329,
    -0.000286097332788069, -0.000538328684681065, -0.00118730774061063,
    -0.00118703780057675, -0.00172055345918883, -0.00282973019584382,
    -0.00279619972795585, -0.00289060805206229, -0.00320325258490701,
    -0.00198704716570621, -0.000847222204131792, 2.70515273679747e-05,
    0.000326844162490547, 0.00135256413351957, 0.0022188465918784,
    0.00337126604512471, 0.00374620280538731, 0.00434814343158575,
    -0.0036458463607326, 0.00322561886385797, 0.000818643340518427,
    0.00081636578104383, -0.00190437247620751, -0.000863343934846812,
    0.000139109866047115, 0.000296579927149878, 0.000740568197543185,
    0.000742005374071472, 0.00114977928877198, 0.00200530841336703,
    0.00222811101992064, 0.0024818042434364, 0.00282650455393769,
    0.00146020870965775, 0.000618887019138287, -2.43124025263358e-05,
    -0.000241178336099445, -0.000991378139936192, -0.00162708135143005,
    -0.00248332970180653, -0.00275966775911108, -0.00320503008932793,
    -0.00588941030822462, 0.000818643340518427, 0.00565989642595176,
    0.00495199955352287, -0.00137264214791527, -0.000624245731910545,
    0.000134212108893823, 0.000277278672318982, 0.000624575880555572,
    0.00064780126403512, 0.000935707806932052, 0.00148449349573531,
    0.00132234065473106, 0.00121308059577345, 0.00127960812345634,
    0.000598575017370257, 0.000255298927663316, -1.05348849084324e-05,
    -0.000105109656554569, -0.000413488381353818, -0.000668742250888912,
    -0.00101475517128789, -0.00106390221980279, -0.00121570767202619,
    -0.00591326964084843, 0.00081636578104383, 0.00495199955352287,
    0.00612031056002729, -0.000638697385813232, -0.000200756794681808,
    0.000234092062788641, 0.000317400792863984, 0.000474734639710034,
    0.000434320019657147, 0.000459443487096387, 0.000570251932991725,
    0.000195546004426462, 2.72052297316331e-05, -3.78499050833033e-05,
    0.000783804355084115, 0.000338266801002889, -5.98980579055969e-06,
    -0.00012832043843202, -0.000542743279532203, -0.000890014730820339,
    -0.00128430664220486, -0.00146322120108432, -0.00169190306471577,
    0.00270235043019556, -0.00190437247620751, -0.00137264214791527,
    -0.000638697385813232, 0.00467632009472188, 0.00125238169504067,
    -0.00129877704188898, -0.0015159828401994, -0.00244941224999582,
    -0.00216501742563322, -0.00281375885789835, -0.00449408146252495,
    -0.00364816304284394, -0.00343278843606667, -0.0037656405854337,
    -0.0019530192987073, -0.000823926841909847, 5.56765347348377e-05,
    0.000369977630385713, 0.00139228419735132, 0.00223783577417036,
    0.00315107722344203, 0.00316419340408527, 0.00352917384733862,
    0.00119384910564329, -0.000863343934846812, -0.000624245731910545,
    -0.000200756794681808, 0.00125238169504067, 0.00114727766243173,
    0.000242162647776926, 4.77172748392219e-06, -0.00037150498020405,
    -0.000523254030404203, -0.000886617935612452, -0.00140688678525427,
    -0.00151777207774812, -0.00163789857683012, -0.0018417095344788,
    -0.000869233941992018, -0.000381264599266638, -2.19177180982826e-06,
    0.000134563688210397, 0.000592929102356622, 0.000989340528530486,
    0.00149625051966445, 0.00155348190492993, 0.00176000748685542,
    -0.000286097332788069, 0.000139109866047115, 0.000134212108893823,
    0.000234092062788641, -0.00129877704188898, 0.000242162647776926,
    0.0011787952545672, 0.00103397353567405, 0.00113707718574448,
    0.000747670650180816, 0.000637468318331369, 0.000963934771472604,
    0.000259239399462997, -3.13740933986805e-05, -9.8258454258689e-05,
    0.000164389952506784, 4.78756078126526e-05, -4.80106456474847e-05,
    -8.33829838965235e-05, -0.000166890570625039, -0.000205380711729347,
    -9.50907045530586e-05, 1.1901907320833e-05, 7.14426605544705e-05,
    -0.000538328684681065, 0.000296579927149878, 0.000277278672318982,
    0.000317400792863984, -0.0015159828401994, 4.77172748392219e-06,
    0.00103397353567405, 0.00107361395477902, 0.00125357393902288,
    0.000898511162091638, 0.000812608069611423, 0.00117847586239195,
    0.000443230767944589, 0.00015806917585112, 0.000106018646194562,
    0.000333721015978061, 0.000120100408758941, -5.31389194723373e-05,
    -0.000117871111748406, -0.000291886194606976, -0.000404124403497883,
    -0.000356618262057166, -0.000229210620899383, -0.000185219275316426,
    -0.00118730774061063, 0.000740568197543185, 0.000624575880555572,
    0.000474734639710034, -0.00244941224999582, -0.00037150498020405,
    0.00113707718574448, 0.00125357393902288, 0.00175782412570737,
    0.00141365990412939, 0.00148450143229436, 0.00216483804024586,
    0.00123800831660394, 0.000907681260528922, 0.000916494035161101,
    0.000815197396104502, 0.000324866910653185, -6.44236841260061e-05,
    -0.000207212018218033, -0.000635132377386486, -0.000959491791422852,
    -0.00113713913236256, -0.000994541303512086, -0.00102792706388811,
    -0.00118703780057675, 0.000742005374071472, 0.00064780126403512,
    0.000434320019657147, -0.00216501742563322, -0.000523254030404203,
    0.000747670650180816, 0.000898511162091638, 0.00141365990412939,
    0.00136045936923501, 0.0014680793668956, 0.00203686187559336,
    0.00119847526169048, 0.000904176981254769, 0.000896852593619694,
    0.000848078442321369, 0.000345820664123864, -5.15527865984296e-05,
    -0.000197519992775655, -0.000645609416220365, -0.000997761381187661,
    -0.0012404390560521, -0.00109680508351927, -0.00113967714137046,
    -0.00172055345918883, 0.00114977928877198, 0.000935707806932052,
    0.000459443487096387, -0.00281375885789835, -0.000886617935612452,
    0.000637468318331369, 0.000812608069611423, 0.00148450143229436,
    0.0014680793668956, 0.00217084016500343, 0.0029750070358662,
    0.00208433309826413, 0.00172182542303662, 0.00174611536201217,
    0.00129960828944164, 0.000548751370569655, -3.79946139891241e-05,
    -0.000250001401133244, -0.00093656323979694, -0.00150718818010699,
    -0.00208363853621429, -0.00197367970588831, -0.00213273444541255,
    -0.00282973019584382, 0.00200530841336703, 0.00148449349573531,
    0.000570251932991725, -0.00449408146252495, -0.00140688678525427,
    0.000963934771472604, 0.00117847586239195, 0.00216483804024586,
    0.00203686187559336, 0.0029750070358662, 0.00501513876862512,
    0.00399535121928084, 0.00350598390589745, 0.00362456785335549,
    0.00212078488398862, 0.000906131205084277, -3.6454396313134e-05,
    -0.000372397355810615, -0.0014864096281366, -0.00242880305206317,
    -0.00353282386838665, -0.00350718581597741, -0.00389458456296836,
    -0.00279619972795585, 0.00222811101992064, 0.00132234065473106,
    0.000195546004426462, -0.00364816304284394, -0.00151777207774812,
    0.000259239399462997, 0.000443230767944589, 0.00123800831660394,
    0.00119847526169048, 0.00208433309826413, 0.00399535121928084,
    0.0054507568567451, 0.00470241993895167, 0.00493055279786896,
    0.00201853749109608, 0.000885809556650048, 1.83923039664673e-05,
    -0.000283050691529295, -0.00133250331426772, -0.00225236010538653,
    -0.00359833596867777, -0.00395366352736832, -0.00461628776343853,
    -0.00289060805206229, 0.0024818042434364, 0.00121308059577345,
    2.72052297316331e-05, -0.00343278843606667, -0.00163789857683012,
    -3.13740933986805e-05, 0.00015806917585112, 0.000907681260528922,
    0.000904176981254769, 0.00172182542303662, 0.00350598390589745,
    0.00470241993895167, 0.0078325224613628, 0.00915323598243506,
    0.00210730280021935, 0.000947137882568041, 7.05701947291954e-05,
    -0.000224872498960712, -0.00130765819682263, -0.00228758006518242,
    -0.0039547935932424, -0.00485413154696321, -0.00588024148548991,
    -0.00320325258490701, 0.00282650455393769, 0.00127960812345634,
    -3.78499050833033e-05, -0.0037656405854337, -0.0018417095344788,
    -9.8258454258689e-05, 0.000106018646194562, 0.000916494035161101,
    0.000896852593619694, 0.00174611536201217, 0.00362456785335549,
    0.00493055279786896, 0.00915323598243506, 0.0136836741339633,
    0.00237864146497212, 0.00108182905868904, 0.000109069014228716,
    -0.000213065408232925, -0.00142680000774472, -0.00254134923813102,
    -0.00458047582769968, -0.00592196661560628, -0.00727888553074047,
    -0.00198704716570621, 0.00146020870965775, 0.000598575017370257,
    0.000783804355084115, -0.0019530192987073, -0.000869233941992018,
    0.000164389952506784, 0.000333721015978061, 0.000815197396104502,
    0.000848078442321369, 0.00129960828944164, 0.00212078488398862,
    0.00201853749109608, 0.00210730280021935, 0.00237864146497212,
    0.0019076370303838, 0.000759586105406085, -0.000122960434399537,
    -0.000420867297024075, -0.00139652592551323, -0.0021704465936693,
    -0.00288314395021324, -0.00291742522906299, -0.00325655842738453,
    -0.000847222204131792, 0.000618887019138287, 0.000255298927663316,
    0.000338266801002889, -0.000823926841909847, -0.000381264599266638,
    4.78756078126526e-05, 0.000120100408758941, 0.000324866910653185,
    0.000345820664123864, 0.000548751370569655, 0.000906131205084277,
    0.000885809556650048, 0.000947137882568041, 0.00108182905868904,
    0.000759586105406085, 0.0003656939785206, 2.82567281665219e-05,
    -0.000101646821262282, -0.000512930233362397, -0.000872443999184792,
    -0.00131618762009045, -0.00140260317866891, -0.00159801030917644,
    2.70515273679747e-05, -2.43124025263358e-05, -1.05348849084324e-05,
    -5.98980579055969e-06, 5.56765347348377e-05, -2.19177180982826e-06,
    -4.80106456474847e-05, -5.31389194723373e-05, -6.44236841260061e-05,
    -5.15527865984296e-05, -3.79946139891241e-05, -3.6454396313134e-05,
    1.83923039664673e-05, 7.05701947291954e-05, 0.000109069014228716,
    -0.000122960434399537, 2.82567281665219e-05, 0.000149057409866348,
    0.000158033153508944, 0.000181471124454999, 0.000130884181218961,
    -0.00015302847096016, -0.000310903996678885, -0.000420681148041455,
    0.000326844162490547, -0.000241178336099445, -0.000105109656554569,
    -0.00012832043843202, 0.000369977630385713, 0.000134563688210397,
    -8.33829838965235e-05, -0.000117871111748406, -0.000207212018218033,
    -0.000197519992775655, -0.000250001401133244, -0.000372397355810615,
    -0.000283050691529295, -0.000224872498960712, -0.000213065408232925,
    -0.000420867297024075, -0.000101646821262282, 0.000158033153508944,
    0.000255704147038991, 0.000426656151552186, 0.000483132475498153,
    0.000219787363688364, 1.1439794023618e-05, -9.02272784316804e-05,
    0.00135256413351957, -0.000991378139936192, -0.000413488381353818,
    -0.000542743279532203, 0.00139228419735132, 0.000592929102356622,
    -0.000166890570625039, -0.000291886194606976, -0.000635132377386486,
    -0.000645609416220365, -0.00093656323979694, -0.0014864096281366,
    -0.00133250331426772, -0.00130765819682263, -0.00142680000774472,
    -0.00139652592551323, -0.000512930233362397, 0.000181471124454999,
    0.000426656151552186, 0.00117095478565454, 0.00164149083642214,
    0.00169588353149587, 0.00141489783224005, 0.00143202572023981,
    0.0022188465918784, -0.00162708135143005, -0.000668742250888912,
    -0.000890014730820339, 0.00223783577417036, 0.000989340528530486,
    -0.000205380711729347, -0.000404124403497883, -0.000959491791422852,
    -0.000997761381187661, -0.00150718818010699, -0.00242880305206317,
    -0.00225236010538653, -0.00228758006518242, -0.00254134923813102,
    -0.0021704465936693, -0.000872443999184792, 0.000130884181218961,
    0.000483132475498153, 0.00164149083642214, 0.00265334294416382,
    0.00305296134009041, 0.00272287720213162, 0.00283652481021948,
    0.00337126604512471, -0.00248332970180653, -0.00101475517128789,
    -0.00128430664220486, 0.00315107722344203, 0.00149625051966445,
    -9.50907045530586e-05, -0.000356618262057166, -0.00113713913236256,
    -0.0012404390560521, -0.00208363853621429, -0.00353282386838665,
    -0.00359833596867777, -0.0039547935932424, -0.00458047582769968,
    -0.00288314395021324, -0.00131618762009045, -0.00015302847096016,
    0.000219787363688364, 0.00169588353149587, 0.00305296134009041,
    0.00667821352504447, 0.00531692615725814, 0.00566170373323159,
    0.00374620280538731, -0.00275966775911108, -0.00106390221980279,
    -0.00146322120108432, 0.00316419340408527, 0.00155348190492993,
    1.1901907320833e-05, -0.000229210620899383, -0.000994541303512086,
    -0.00109680508351927, -0.00197367970588831, -0.00350718581597741,
    -0.00395366352736832, -0.00485413154696321, -0.00592196661560628,
    -0.00291742522906299, -0.00140260317866891, -0.000310903996678885,
    1.1439794023618e-05, 0.00141489783224005, 0.00272287720213162,
    0.00531692615725814, 0.0135149981987308, 0.0166147008644102,
    0.00434814343158575, -0.00320503008932793, -0.00121570767202619,
    -0.00169190306471577, 0.00352917384733862, 0.00176000748685542,
    7.14426605544705e-05, -0.000185219275316426, -0.00102792706388811,
    -0.00113967714137046, -0.00213273444541255, -0.00389458456296836,
    -0.00461628776343853, -0.00588024148548991, -0.00727888553074047,
    -0.00325655842738453, -0.00159801030917644, -0.000420681148041455,
    -9.02272784316804e-05, 0.00143202572023981, 0.00283652481021948,
    0.00566170373323159, 0.0166147008644102, 0.0269823093695889
    ]).reshape(24, 24, order="F")

mpg_bs_poisson.cov_scaled = mpg_bs_poisson.cov_unscaled

mpg_bs_poisson.p_table = np.array([
    3.38155196812657, -0.2398057983025, 0.0385574655971876,
    0.0308789097162079, 0.0953875221712041, 0.0567945319890742,
    0.0752322831366413, 0.0782324137428169, 35.4506741673956,
    -4.22233954403625, 0.512512235301397, 0.394707362829427,
    2.83211381163377e-275, 2.41779512472801e-05, 0.608292559428079,
    0.693058868325634
    ]).reshape(4, 4, order="F")

mpg_bs_poisson.pTerms_table = np.array([
    1, 2, 17.8281512251323, 0.267231825859481, 2.41779512472801e-05,
    0.874926047858207
    ]).reshape(2, 3, order="F")

mpg_bs_poisson.s_table = np.array([
    2.53986871460058, 1.70629964435497, 3.20982914795608, 2.15301685267905,
    24.0890023854214, 12.9900133623474, 4.50054787026542e-05,
    0.0019804834204652
    ]).reshape(2, 4, order="F")

mpg_bs_poisson.method = "UBRE"
mpg_bs_poisson.sp_criterion = -0.733688545240377
mpg_bs_poisson.rank = 24
mpg_bs_poisson.np = 24
mpg_bs_poisson.params = np.array([
    3.38155196812657, -0.2398057983025, 0.0385574655971876,
    0.0308789097162079, 0.322087207070371, 0.114222640046661,
    -0.0703319473834318, -0.0932993942273026, -0.164529819124519,
    -0.150860338924587, -0.19827414261489, -0.318132823476157,
    -0.277920321049033, -0.291752287584618, -0.335850782440607,
    0.147266917321495, 0.0655746640077953, 0.00329634588440575,
    -0.0178203244735351, -0.0949069908870388, -0.162736107333124,
    -0.267760412623755, -0.31426029441775, -0.36537967845964
    ])
