"""
Created on Jan. 10, 2024 12:01:42 p.m.

Author: Josef Perktold
License: BSD-3
"""

import numpy as np

from statsmodels.tools.testing import Holder

# > ccogk = CovOgk(hbk, control = CovControlOgk(beta=0.9, smrob="s_mad"))
# > cat(convert(ccogk$cov, name="cov"))
cov = np.array([
    1.09582222222222, 0.0923888888888889, 0.139311111111111,
    0.0791333333333334, 0.0923888888888889, 1.10443055555556,
    0.115486111111111, -0.0216666666666667, 0.139311111111111,
    0.115486111111111, 1.05683055555556, -0.1179, 0.0791333333333334,
    -0.0216666666666667, -0.1179, 0.305733333333333
    ]).reshape(4, 4, order="F")
# > cat(convert(ccogk$center, name="center"))
center = np.array([
    1.51333333333333, 1.80833333333333, 1.70166666666667, -0.06
    ])
# > # cat(convert(ccogk$wcov, name="wcov"))
# > # cat(convert(ccogk$wcenter, name="wcenter"))
# > cat(convert(ccogk$raw.cov, name="cov_raw"))
cov_raw = np.array([
    1.9407276011319, -0.345451662256964, 0.366369160423434, 0.190853625223746,
    -0.345451662256964, 1.73225519884252, 0.136984423781046,
    -0.0993064484478497, 0.366369160423435, 0.136984423781046,
    1.48544656301605, 0.00519089032391373, 0.190853625223746,
    -0.0993064484478496, 0.00519089032391377, 0.50256738790616
    ]).reshape(4, 4, order="F")
# > cat(convert(ccogk$raw.center, name="center_raw"))
center_raw = np.array([
    1.31579959868769, 2.20579763353799, 2.21911403105542, 0.00899362163513043
    ])
# > cat(convert(ccogk$mah, name="mah"))
# > cat(convert(ccogk$raw.mah, name="mah_raw"))
mah_raw = np.array([
    531.257464576749, 566.735535698569, 617.601502340093, 629.350845325439,
    623.460283038062, 571.109274777988, 598.637648167718, 558.466297239649,
    603.727595973789, 581.737055421246, 619.71994086676, 663.864663410114,
    632.709272085056, 787.965579892721, 2.56481689495561, 3.79177369502846,
    2.19649722906119, 0.48019047958174, 0.430972335009587, 2.20114817452459,
    1.53206883712648, 0.810208582175715, 2.42856732140317, 2.01254218097462,
    3.28333887666359, 1.20602525870766, 2.55803789487139, 0.820525457004909,
    1.48476149941901, 1.97433350901779, 2.29097245168692, 1.8724954251156,
    1.19894464703326, 3.73150858570722, 1.2719728274182, 1.45612664881518,
    1.05185147507508, 3.02198599209725, 3.33349482645145, 0.873831491583734,
    1.67069756290631, 2.00705318916057, 2.1881459049135, 2.53578934752395,
    3.33375999977988, 1.82258076787966, 5.18156875988233, 1.22422852048766,
    2.19056821582843, 0.786627007255493, 2.60661427302475, 3.48165930435463,
    3.71142947824888, 2.74842447586242, 0.874017547395219, 1.65799984219254,
    2.27465018103286, 1.75408052039669, 0.427184006365251, 2.4683827422497,
    1.05936362355657, 3.45715101019995, 2.16657671133355, 1.7212295481511,
    1.34591939904947, 2.13272710736085, 1.34572824033396, 3.46331755540967,
    2.6637869025017, 1.02726297685493, 0.37218181182601, 0.39029706942247,
    0.861689042081113, 1.52042567119062, 2.27431881174842
    ])
# > cat(convert(ccogk$det, name="det"))
det = -1

results_ogk_mad = Holder(
    cov=cov,
    cov_raw=cov_raw,
    center=center,
    center_raw=center_raw,
    mah_raw=mah_raw,
    )


# > ccogk = CovOgk(hbk, control = CovControlOgk(beta=0.9, smrob="scaleTau2"))
# > cat(convert(ccogk$cov, name="cov"))
cov = np.array([
    1.10609722222222, 0.0218055555555555, 0.151166666666667,
    0.0748888888888889, 0.0218055555555555, 1.11998888888889,
    0.178466666666667, 0.0199555555555556, 0.151166666666667,
    0.178466666666667, 1.02606666666667, -0.126633333333333,
    0.0748888888888889, 0.0199555555555556, -0.126633333333333,
    0.307155555555555
    ]).reshape(4, 4, order="F")
# > cat(convert(ccogk$center, name="center"))
center = np.array([
    1.55833333333333, 1.80333333333333, 1.66, -0.0866666666666667
    ])
# > cat(convert(ccogk$raw.cov, name="cov_raw"))
cov_raw = np.array([
    1.55608196098389, 0.0784052222419514, 0.236094218667106, 0.237198197389775,
    0.0784052222419515, 1.4612592842126, 0.374939637956948,
    0.0184287391597945, 0.236094218667106, 0.374939637956948,
    1.47721455029234, 0.083480499238493, 0.237198197389775,
    0.0184287391597945, 0.083480499238493, 0.347944274344394
    ]).reshape(4, 4, order="F")
# > cat(convert(ccogk$raw.center, name="center_raw"))
center_raw = np.array([
    1.568388618305, 1.81083915058248, 1.91970363122717, -0.1005398925951
    ])
# > cat(convert(ccogk$mah, name="mah"))
# > cat(convert(ccogk$raw.mah, name="mah_raw"))
mah_raw = np.array([
    443.899259030748, 475.753883889401, 515.028542860693, 519.085382813057,
    517.249930086342, 475.216297490806, 503.81909766891, 470.714702177619,
    500.656767136332, 487.445807275572, 528.821593649342, 572.28895294165,
    529.373253808243, 664.889088065593, 2.30980390178108, 3.04243137071211,
    1.89389540863922, 0.224769311045195, 1.03042360605995, 1.97028174097441,
    1.82556711806329, 1.98994177618517, 1.86320827724144, 2.58325276227863,
    1.81606558096562, 1.83671302100292, 2.86844669360201, 0.717154501071419,
    1.12005361153132, 2.00582732819216, 1.44355400874396, 1.72860195167575,
    1.31049475134173, 2.17886517391375, 1.23944847875147, 1.75961121571385,
    1.75860978501382, 3.32079082695011, 2.31801358864702, 0.701440205562862,
    1.72089020985908, 1.76537825078415, 4.09910370987578, 2.65362067074378,
    1.92456769764021, 1.79273161044741, 4.16882415230184, 1.2790689726097,
    2.22773976564953, 0.971798063289236, 2.30555343594957, 2.73181757446068,
    4.52411346171433, 3.75624910237992, 1.19867301097419, 1.69562752849515,
    2.13841586824182, 1.60369521114501, 0.573845565454945, 2.58869712557787,
    1.90572318356443, 3.15104415476603, 1.93489246305855, 1.88041129930582,
    1.69472051158961, 1.65504494381539, 0.897211773247318, 3.66317107203905,
    1.64504705046865, 1.94868118357482, 0.400029998983977, 0.426176048393805,
    1.56131160096187, 1.59991963264426, 2.34430745546549
    ])
# > cat(convert(ccogk$det, name="det"))
det = -1

results_ogk_tau = Holder(
    cov=cov,
    cov_raw=cov_raw,
    center=center,
    center_raw=center_raw,
    mah_raw=mah_raw,
    )
