import numpy as np

from statsmodels.tools.testing import ParamsTableTestBunch

est = dict(
    rank=13,
    N=758,
    Q=0.0150568875809373,
    J=11.41312078635046,
    J_df=2,
    k_1=13,
    converged=1,
    has_xtinst=0,
    type=1,
    n_eq=1,
    k=13,
    n_moments=15,
    k_aux=13,
    k_eq_model=0,
    ic=6,
    k_eq=13,
    cmdline="gmm (lw - {xb:s iq expr tenure rns smsa dyear*} - {b0}) , instruments(expr tenure rns smsa dyear* med kww age mrt) igmm",
    cmd="gmm",
    estat_cmd="gmm_estat",
    predict="gmm_p",
    marginsnotok="_ALL",
    eqnames="1",
    technique="gn",
    winit="Unadjusted",
    estimator="igmm",
    wmatrix="robust",
    vce="robust",
    vcetype="Robust",
    params="xb_s xb_iq xb_expr xb_tenure xb_rns xb_smsa xb_dyear_67 xb_dyear_68 xb_dyear_69 xb_dyear_70 xb_dyear_71 xb_dyear_73 b0",
    inst_1="expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73 med kww age mrt _cons",
    params_1="xb_s xb_iq xb_expr xb_tenure xb_rns xb_smsa xb_dyear_67 xb_dyear_68 xb_dyear_69 xb_dyear_70 xb_dyear_71 xb_dyear_73 b0",
    sexp_1="lw - ({xb_s} *s + {xb_iq} *iq + {xb_expr} *expr + {xb_tenure} *tenure + {xb_rns} *rns + {xb_smsa} *smsa + {xb_dyear_67} *dyear_67 + {xb_dyear_68} *dyear_68 + {xb_dyear_69} *dyear_69 + {xb_dyear_70} *dyear_70 + {xb_dyear_71} *dyear_71 + {xb_dyear_73} *dyear_73) - {b0}",
    properties="b V",
)

params_table = np.array(
    [
        0.17587739850768,
        0.02085563162829,
        8.4330890400415,
        3.366583555e-17,
        0.1350011116414,
        0.21675368537396,
        np.nan,
        1.9599639845401,
        0,
        -0.00928586712743,
        0.00491894287617,
        -1.88777697997,
        0.05905589683705,
        -0.01892681800673,
        0.00035508375188,
        np.nan,
        1.9599639845401,
        0,
        0.05031651549731,
        0.00810558790493,
        6.2076330659127,
        5.378855978e-10,
        0.03442985513012,
        0.0662031758645,
        np.nan,
        1.9599639845401,
        0,
        0.04246235782951,
        0.00956418082077,
        4.4397276280375,
        9.007280073e-06,
        0.02371690787918,
        0.06120780777985,
        np.nan,
        1.9599639845401,
        0,
        -0.1039476753865,
        0.03373281188749,
        -3.0815004611293,
        0.00205960157647,
        -0.17006277178325,
        -0.03783257898975,
        np.nan,
        1.9599639845401,
        0,
        0.12477256813508,
        0.03099244898605,
        4.0259021864082,
        0.0000567572801,
        0.06402848432973,
        0.18551665194043,
        np.nan,
        1.9599639845401,
        0,
        -0.05297127223127,
        0.0517946935923,
        -1.0227162003936,
        0.30644204936546,
        -0.15448700626247,
        0.04854446179993,
        np.nan,
        1.9599639845401,
        0,
        0.04564516152971,
        0.05001865637643,
        0.91256272831865,
        0.36147256434055,
        -0.05238960352318,
        0.1436799265826,
        np.nan,
        1.9599639845401,
        0,
        0.15574543741982,
        0.04802004585645,
        3.2433421218593,
        0.00118136262363,
        0.06162787700523,
        0.24986299783442,
        np.nan,
        1.9599639845401,
        0,
        0.16681173496168,
        0.06134387289984,
        2.7192892635594,
        0.00654223677971,
        0.0465799534058,
        0.28704351651757,
        np.nan,
        1.9599639845401,
        0,
        0.08417610675323,
        0.05582688740597,
        1.507805838092,
        0.13160422753823,
        -0.02524258193145,
        0.19359479543791,
        np.nan,
        1.9599639845401,
        0,
        0.09964580476612,
        0.06124947866865,
        1.6268841291727,
        0.10376170930541,
        -0.02040096749628,
        0.21969257702853,
        np.nan,
        1.9599639845401,
        0,
        4.0027753075622,
        0.33649589464938,
        11.895465505554,
        1.249543428e-32,
        3.3432554731038,
        4.6622951420205,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(13, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = ["_cons"] * 13

cov = np.array(
    [
        0.00043495737061,
        -0.00007938790704,
        0.00002809207919,
        0.00001486824321,
        -0.00017806650894,
        -6.696078938e-06,
        -0.00011595347261,
        -0.00018816769626,
        -0.00012205118386,
        -0.00008281236274,
        -0.00031504876539,
        -0.00063574245306,
        0.00264272738846,
        -0.00007938790704,
        0.00002419599902,
        4.932871670e-06,
        -0.00001114848619,
        0.00006618803917,
        -0.00002202930782,
        4.808220835e-07,
        0.00003206765662,
        -0.00002261059773,
        -0.00006024105579,
        -0.00001412126593,
        0.00001474591556,
        -0.00144330101198,
        0.00002809207919,
        4.932871670e-06,
        0.00006570055528,
        -0.0000203894891,
        0.00005213529923,
        -0.00003297805448,
        0.00003595284891,
        0.00008758906787,
        0.00003058926358,
        0.00001696423798,
        -0.00008568569767,
        -0.00013140753648,
        -0.00094326672008,
        0.00001486824321,
        -0.00001114848619,
        -0.0000203894891,
        0.00009147355477,
        -0.00003774547245,
        7.828122784e-06,
        0.00008484461309,
        0.00006729820252,
        0.00011236802193,
        0.00010082715772,
        0.00011217081931,
        0.00009440153548,
        0.00075659901252,
        -0.00017806650894,
        0.00006618803917,
        0.00005213529923,
        -0.00003774547245,
        0.00113790259784,
        0.00013005865302,
        0.00018021354375,
        0.00018779266096,
        -9.435310865e-06,
        0.0000165483542,
        -0.00005323328914,
        0.00008265052168,
        -0.00499436873124,
        -6.696078938e-06,
        -0.00002202930782,
        -0.00003297805448,
        7.828122784e-06,
        0.00013005865302,
        0.00096053189415,
        0.00005704546746,
        0.00011160225767,
        0.00025285680201,
        0.00010656723202,
        0.00030213005331,
        0.00030792696913,
        0.00157128168902,
        -0.00011595347261,
        4.808220835e-07,
        0.00003595284891,
        0.00008484461309,
        0.00018021354375,
        0.00005704546746,
        0.00268269028432,
        0.00085942321667,
        0.00091151417222,
        0.00096327250114,
        0.00090372304081,
        0.00102768195348,
        0.00034563629591,
        -0.00018816769626,
        0.00003206765662,
        0.00008758906787,
        0.00006729820252,
        0.00018779266096,
        0.00011160225767,
        0.00085942321667,
        0.0025018659857,
        0.00092591134763,
        0.00088266305412,
        0.0008241186538,
        0.00095084381197,
        -0.00206285154639,
        -0.00012205118386,
        -0.00002261059773,
        0.00003058926358,
        0.00011236802193,
        -9.435310865e-06,
        0.00025285680201,
        0.00091151417222,
        0.00092591134763,
        0.00230592480406,
        0.00118265696692,
        0.0011106470199,
        0.00129290662149,
        0.00256049741814,
        -0.00008281236274,
        -0.00006024105579,
        0.00001696423798,
        0.00010082715772,
        0.0000165483542,
        0.00010656723202,
        0.00096327250114,
        0.00088266305412,
        0.00118265696692,
        0.00376307074235,
        0.00124584145426,
        0.00155915431219,
        0.00599086304364,
        -0.00031504876539,
        -0.00001412126593,
        -0.00008568569767,
        0.00011217081931,
        -0.00005323328914,
        0.00030213005331,
        0.00090372304081,
        0.0008241186538,
        0.0011106470199,
        0.00124584145426,
        0.00311664135744,
        0.0018437604357,
        0.00431259131307,
        -0.00063574245306,
        0.00001474591556,
        -0.00013140753648,
        0.00009440153548,
        0.00008265052168,
        0.00030792696913,
        0.00102768195348,
        0.00095084381197,
        0.00129290662149,
        0.00155915431219,
        0.0018437604357,
        0.00375149863718,
        0.00538769349865,
        0.00264272738846,
        -0.00144330101198,
        -0.00094326672008,
        0.00075659901252,
        -0.00499436873124,
        0.00157128168902,
        0.00034563629591,
        -0.00206285154639,
        0.00256049741814,
        0.00599086304364,
        0.00431259131307,
        0.00538769349865,
        0.11322948711589,
    ]
).reshape(13, 13)

cov_colnames = ["_cons"] * 13

cov_rownames = ["_cons"] * 13


results = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)
