import numpy as np

from statsmodels.tools.testing import ParamsTableTestBunch

est = dict(
    rank=8,
    N=3629,
    Q=4.59536484786e-20,
    J=1.66765790329e-16,
    J_df=0,
    k_1=8,
    converged=1,
    has_xtinst=0,
    type=1,
    n_eq=1,
    k=8,
    n_moments=8,
    k_aux=8,
    k_eq_model=0,
    k_eq=8,
    cmdline="gmm ( docvis - exp({xb:private medicaid aget aget2 educyr actlim totchr}+{b0})), instruments(incomet ssiratio aget aget2 educyr actlim totchr) onestep vce(robust)",
    cmd="gmm",
    estat_cmd="gmm_estat",
    predict="gmm_p",
    marginsnotok="_ALL",
    eqnames="1",
    technique="gn",
    winit="Unadjusted",
    estimator="onestep",
    wmatrix="robust",
    vce="robust",
    vcetype="Robust",
    params="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    inst_1="incomet ssiratio aget aget2 educyr actlim totchr _cons",
    params_1="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    sexp_1="docvis - exp( ({xb_private} *private + {xb_medicaid} *medicaid + {xb_aget} *aget + {xb_aget2} *aget2 + {xb_educyr} *educyr + {xb_actlim} *actlim + {xb_totchr} *totchr) + {b0} )",
    properties="b V",
)

params_table = np.array(
    [
        0.62093805844748,
        0.35860052573857,
        1.731559252928,
        0.08335206643438,
        -0.08190605683724,
        1.3237821737322,
        np.nan,
        1.9599639845401,
        0,
        0.68895699568302,
        0.43817618784254,
        1.5723286997298,
        0.11587434043505,
        -0.1698525513714,
        1.5477665427374,
        np.nan,
        1.9599639845401,
        0,
        0.25750627258076,
        0.05009451793791,
        5.1404082358855,
        2.741421857e-07,
        0.15932282159956,
        0.35568972356197,
        np.nan,
        1.9599639845401,
        0,
        -0.05352997420414,
        0.01103202674353,
        -4.8522339048464,
        1.220785200e-06,
        -0.07515234929795,
        -0.03190759911034,
        np.nan,
        1.9599639845401,
        0,
        0.03106248018916,
        0.01032090201131,
        3.0096671933432,
        0.00261534090329,
        0.01083388395902,
        0.05129107641931,
        np.nan,
        1.9599639845401,
        0,
        0.14175365608301,
        0.0494498280382,
        2.8666157539212,
        0.00414886404159,
        0.04483377408643,
        0.23867353807958,
        np.nan,
        1.9599639845401,
        0,
        0.23128095221422,
        0.01565221628818,
        14.776243054406,
        2.084750820e-49,
        0.20060317201116,
        0.26195873241727,
        np.nan,
        1.9599639845401,
        0,
        0.34763567088735,
        0.31615794015526,
        1.0995633091379,
        0.27152243570261,
        -0.27202250524333,
        0.96729384701803,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(8, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = ["_cons"] * 8

cov = np.array(
    [
        0.12859433705998,
        0.13265896898444,
        0.00910916927048,
        -0.00144786113189,
        -0.00037337560793,
        -0.00152379041042,
        -0.00336772308907,
        -0.09899309651531,
        0.13265896898444,
        0.19199837159222,
        0.00979636564963,
        -0.00135323134276,
        0.00180599814286,
        -0.00930935415071,
        -0.00460031335865,
        -0.13429156867927,
        0.00910916927048,
        0.00979636564963,
        0.00250946072743,
        -0.00052373946978,
        5.155389870e-07,
        -0.00016461502154,
        -0.00025816911604,
        -0.00869892550441,
        -0.00144786113189,
        -0.00135323134276,
        -0.00052373946978,
        0.00012170561407,
        8.334416260e-06,
        -0.00002526568199,
        0.00003797456789,
        0.00131001446811,
        -0.00037337560793,
        0.00180599814286,
        5.155389870e-07,
        8.334416260e-06,
        0.00010652101833,
        -0.00026856403693,
        -0.00003344387872,
        -0.00122933496346,
        -0.00152379041042,
        -0.00930935415071,
        -0.00016461502154,
        -0.00002526568199,
        -0.00026856403693,
        0.00244528549301,
        0.00003610001892,
        0.00527355381855,
        -0.00336772308907,
        -0.00460031335865,
        -0.00025816911604,
        0.00003797456789,
        -0.00003344387872,
        0.00003610001892,
        0.00024499187473,
        0.00300075896709,
        -0.09899309651531,
        -0.13429156867927,
        -0.00869892550441,
        0.00131001446811,
        -0.00122933496346,
        0.00527355381855,
        0.00300075896709,
        0.09995584312322,
    ]
).reshape(8, 8)

cov_colnames = ["_cons"] * 8

cov_rownames = ["_cons"] * 8


results_addonestep = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)


est = dict(
    rank=8,
    N=3629,
    Q=6.09567389485e-33,
    J=2.21212005644e-29,
    J_df=0,
    k_1=8,
    converged=1,
    has_xtinst=0,
    type=1,
    n_eq=1,
    k=8,
    n_moments=8,
    k_aux=8,
    k_eq_model=0,
    k_eq=8,
    cmdline="gmm ( docvis - exp({xb:private medicaid aget aget2 educyr actlim totchr}+{b0})), instruments(incomet ssiratio aget aget2 educyr actlim totchr) twostep vce(robust)",
    cmd="gmm",
    estat_cmd="gmm_estat",
    predict="gmm_p",
    marginsnotok="_ALL",
    eqnames="1",
    technique="gn",
    winit="Unadjusted",
    estimator="twostep",
    wmatrix="robust",
    vce="robust",
    vcetype="Robust",
    params="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    inst_1="incomet ssiratio aget aget2 educyr actlim totchr _cons",
    params_1="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    sexp_1="docvis - exp( ({xb_private} *private + {xb_medicaid} *medicaid + {xb_aget} *aget + {xb_aget2} *aget2 + {xb_educyr} *educyr + {xb_actlim} *actlim + {xb_totchr} *totchr) + {b0} )",
    properties="b V",
)

params_table = np.array(
    [
        0.6209380584426,
        0.35860052570457,
        1.7315592530786,
        0.08335206640755,
        -0.08190605677548,
        1.3237821736607,
        np.nan,
        1.9599639845401,
        0,
        0.68895699501744,
        0.43817618789764,
        1.5723286980131,
        0.11587434083298,
        -0.16985255214498,
        1.5477665421799,
        np.nan,
        1.9599639845401,
        0,
        0.25750627271754,
        0.05009451794125,
        5.1404082382732,
        2.741421823e-07,
        0.15932282172979,
        0.35568972370529,
        np.nan,
        1.9599639845401,
        0,
        -0.05352997423123,
        0.01103202674378,
        -4.8522339071944,
        1.220785186e-06,
        -0.07515234932551,
        -0.03190759913694,
        np.nan,
        1.9599639845401,
        0,
        0.03106248018903,
        0.01032090201422,
        3.0096671924822,
        0.0026153409107,
        0.01083388395319,
        0.05129107642488,
        np.nan,
        1.9599639845401,
        0,
        0.14175365616691,
        0.04944982804302,
        2.8666157553386,
        0.00414886402301,
        0.04483377416089,
        0.23867353817294,
        np.nan,
        1.9599639845401,
        0,
        0.23128095224221,
        0.01565221628892,
        14.776243055497,
        2.084750786e-49,
        0.20060317203771,
        0.26195873244672,
        np.nan,
        1.9599639845401,
        0,
        0.34763567064032,
        0.31615794015859,
        1.099563308345,
        0.27152243604826,
        -0.27202250549689,
        0.96729384677754,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(8, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = ["_cons"] * 8

cov = np.array(
    [
        0.12859433703559,
        0.1326589689683,
        0.00910916927021,
        -0.00144786113188,
        -0.00037337560766,
        -0.00152379040753,
        -0.00336772308885,
        -0.09899309649807,
        0.1326589689683,
        0.1919983716405,
        0.00979636565235,
        -0.00135323134324,
        0.00180599814488,
        -0.00930935415256,
        -0.00460031335946,
        -0.13429156869395,
        0.00910916927021,
        0.00979636565235,
        0.00250946072777,
        -0.00052373946983,
        5.155391569e-07,
        -0.00016461502162,
        -0.00025816911611,
        -0.00869892550672,
        -0.00144786113188,
        -0.00135323134324,
        -0.00052373946983,
        0.00012170561408,
        8.334416227e-06,
        -0.00002526568198,
        0.0000379745679,
        0.00131001446858,
        -0.00037337560766,
        0.00180599814488,
        5.155391569e-07,
        8.334416227e-06,
        0.00010652101839,
        -0.00026856403706,
        -0.00003344387875,
        -0.00122933496459,
        -0.00152379040753,
        -0.00930935415256,
        -0.00016461502162,
        -0.00002526568198,
        -0.00026856403706,
        0.00244528549348,
        0.00003610001887,
        0.00527355381795,
        -0.00336772308885,
        -0.00460031335946,
        -0.00025816911611,
        0.0000379745679,
        -0.00003344387875,
        0.00003610001887,
        0.00024499187475,
        0.00300075896724,
        -0.09899309649807,
        -0.13429156869395,
        -0.00869892550672,
        0.00131001446858,
        -0.00122933496459,
        0.00527355381795,
        0.00300075896724,
        0.09995584312533,
    ]
).reshape(8, 8)

cov_colnames = ["_cons"] * 8

cov_rownames = ["_cons"] * 8

results_addtwostep = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)


est = dict(
    rank=8,
    N=3629,
    Q=0.0002538911897719,
    J=0.9213711276820714,
    J_df=1,
    k_1=8,
    converged=1,
    has_xtinst=0,
    type=1,
    n_eq=1,
    k=8,
    n_moments=9,
    k_aux=8,
    k_eq_model=0,
    k_eq=8,
    cmdline="gmm ( (docvis / exp({xb:private medicaid aget aget2 educyr actlim totchr}+{b0})) - 1), instruments(income ssiratio medicaid aget aget2 educyr actlim totchr) onestep vce(robust)",
    cmd="gmm",
    estat_cmd="gmm_estat",
    predict="gmm_p",
    marginsnotok="_ALL",
    eqnames="1",
    technique="gn",
    winit="Unadjusted",
    estimator="onestep",
    wmatrix="robust",
    vce="robust",
    vcetype="Robust",
    params="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    inst_1="income ssiratio medicaid aget aget2 educyr actlim totchr _cons",
    params_1="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    sexp_1="(docvis / exp( ({xb_private} *private + {xb_medicaid} *medicaid + {xb_aget} *aget + {xb_aget2} *aget2 + {xb_educyr} *educyr + {xb_actlim} *actlim + {xb_totchr} *totchr) + {b0} )) - 1",
    properties="b V",
)

params_table = np.array(
    [
        0.67045580921478,
        0.25039046077656,
        2.6776411814389,
        0.00741425985435,
        0.17969952402034,
        1.1612120944092,
        np.nan,
        1.9599639845401,
        0,
        0.28551241628798,
        0.10358919281318,
        2.7561988710819,
        0.00584774303307,
        0.08248132918657,
        0.4885435033894,
        np.nan,
        1.9599639845401,
        0,
        0.2672004738793,
        0.05203985579809,
        5.1345352476769,
        2.828420839e-07,
        0.16520423075439,
        0.36919671700421,
        np.nan,
        1.9599639845401,
        0,
        -0.0560702624564,
        0.01191485946838,
        -4.7059105149509,
        2.527353692e-06,
        -0.07942295789528,
        -0.03271756701753,
        np.nan,
        1.9599639845401,
        0,
        0.01448379701656,
        0.00782559934942,
        1.8508227127214,
        0.06419506241955,
        -0.00085409586574,
        0.02982168989887,
        np.nan,
        1.9599639845401,
        0,
        0.18130374188096,
        0.0382173439987,
        4.7440173206998,
        2.095209222e-06,
        0.10639912405874,
        0.25620835970318,
        np.nan,
        1.9599639845401,
        0,
        0.28146161235562,
        0.01380395117777,
        20.389931022715,
        2.054354003e-92,
        0.25440636520284,
        0.30851685950839,
        np.nan,
        1.9599639845401,
        0,
        0.51399857133918,
        0.10262653035745,
        5.0084375799215,
        5.487366567e-07,
        0.31285426798028,
        0.71514287469808,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(8, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = ["_cons"] * 8

cov = np.array(
    [
        0.0626953828479,
        0.02323594786658,
        0.00535172023578,
        -0.00103050587759,
        -0.00154311442856,
        0.00154515839603,
        -0.00043159973572,
        -0.01570852578318,
        0.02323594786658,
        0.01073072086769,
        0.00207768328305,
        -0.00039713375955,
        -0.00049396171685,
        0.00027652302157,
        -0.00020408147523,
        -0.00701276303887,
        0.00535172023578,
        0.00207768328305,
        0.00270814659149,
        -0.00059652725999,
        -0.00012298559534,
        0.00021079055266,
        -0.00004341699196,
        -0.0031278522429,
        -0.00103050587759,
        -0.00039713375955,
        -0.00059652725999,
        0.00014196387615,
        0.00002481291175,
        -0.00006035908648,
        0.00001093157006,
        0.00059187926133,
        -0.00154311442856,
        -0.00049396171685,
        -0.00012298559534,
        0.00002481291175,
        0.00006124000518,
        -0.00001857594061,
        0.00001436652009,
        0.00008106194688,
        0.00154515839603,
        0.00027652302157,
        0.00021079055266,
        -0.00006035908648,
        -0.00001857594061,
        0.00146056538231,
        -0.00016708887634,
        -0.00074321753343,
        -0.00043159973572,
        -0.00020408147523,
        -0.00004341699196,
        0.00001093157006,
        0.00001436652009,
        -0.00016708887634,
        0.00019054906812,
        -0.00028024031412,
        -0.01570852578318,
        -0.00701276303887,
        -0.0031278522429,
        0.00059187926133,
        0.00008106194688,
        -0.00074321753343,
        -0.00028024031412,
        0.01053220473321,
    ]
).reshape(8, 8)

cov_colnames = ["_cons"] * 8

cov_rownames = ["_cons"] * 8


results_multonestep = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)


est = dict(
    rank=8,
    N=3629,
    Q=0.0002589826272982,
    J=0.9398479544653281,
    J_df=1,
    k_1=8,
    converged=1,
    has_xtinst=0,
    type=1,
    n_eq=1,
    k=8,
    n_moments=9,
    k_aux=8,
    k_eq_model=0,
    k_eq=8,
    cmdline="gmm ( (docvis / exp({xb:private medicaid aget aget2 educyr actlim totchr}+{b0})) - 1), instruments(income ssiratio medicaid aget aget2 educyr actlim totchr) twostep vce(robust)",
    cmd="gmm",
    estat_cmd="gmm_estat",
    predict="gmm_p",
    marginsnotok="_ALL",
    eqnames="1",
    technique="gn",
    winit="Unadjusted",
    estimator="twostep",
    wmatrix="robust",
    vce="robust",
    vcetype="Robust",
    params="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    inst_1="income ssiratio medicaid aget aget2 educyr actlim totchr _cons",
    params_1="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    sexp_1="(docvis / exp( ({xb_private} *private + {xb_medicaid} *medicaid + {xb_aget} *aget + {xb_aget2} *aget2 + {xb_educyr} *educyr + {xb_actlim} *actlim + {xb_totchr} *totchr) + {b0} )) - 1",
    properties="b V",
)

params_table = np.array(
    [
        0.67815288158883,
        0.25053953449054,
        2.7067699433856,
        0.00679413212727,
        0.18710441728393,
        1.1692013458937,
        np.nan,
        1.9599639845401,
        0,
        0.28872837589732,
        0.1032733938985,
        2.7957672833051,
        0.00517766683505,
        0.08631624329503,
        0.49114050849961,
        np.nan,
        1.9599639845401,
        0,
        0.27067071818542,
        0.05199695467114,
        5.2055109745809,
        1.934635127e-07,
        0.16875855972422,
        0.37258287664662,
        np.nan,
        1.9599639845401,
        0,
        -0.05690856524563,
        0.01189861686254,
        -4.7827882772482,
        1.728801925e-06,
        -0.08022942576205,
        -0.03358770472921,
        np.nan,
        1.9599639845401,
        0,
        0.01438118999252,
        0.00783219080428,
        1.8361644081315,
        0.06633334485657,
        -0.00096962190392,
        0.02973200188896,
        np.nan,
        1.9599639845401,
        0,
        0.18038262255626,
        0.03826653224544,
        4.7138481584715,
        2.430818311e-06,
        0.10538159754195,
        0.25538364757056,
        np.nan,
        1.9599639845401,
        0,
        0.28251027986119,
        0.01378475918788,
        20.494393555287,
        2.415775858e-93,
        0.25549264831739,
        0.30952791140498,
        np.nan,
        1.9599639845401,
        0,
        0.5077134442587,
        0.10235830367214,
        4.9601588346456,
        7.043556343e-07,
        0.30709485554269,
        0.7083320329747,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(8, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = ["_cons"] * 8

cov = np.array(
    [
        0.06277005834274,
        0.02315710174743,
        0.00533574120292,
        -0.00102544979294,
        -0.00154463417995,
        0.0015508406274,
        -0.00043796451278,
        -0.01559999387335,
        0.02315710174743,
        0.01066539388732,
        0.00206217803508,
        -0.00039331197813,
        -0.00049172930967,
        0.00027603135609,
        -0.00020644763374,
        -0.00694810289238,
        0.00533574120292,
        0.00206217803508,
        0.00270368329507,
        -0.0005950942106,
        -0.00012276584915,
        0.00021462173623,
        -0.00004681980342,
        -0.00310767551047,
        -0.00102544979294,
        -0.00039331197813,
        -0.0005950942106,
        0.00014157708324,
        0.00002474211336,
        -0.00006134660609,
        0.00001178280314,
        0.00058658157366,
        -0.00154463417995,
        -0.00049172930967,
        -0.00012276584915,
        0.00002474211336,
        0.00006134321279,
        -0.00001855941375,
        0.00001443470174,
        0.0000776612477,
        0.0015508406274,
        0.00027603135609,
        0.00021462173623,
        -0.00006134660609,
        -0.00001855941375,
        0.00146432749009,
        -0.00016643326394,
        -0.00074847803836,
        -0.00043796451278,
        -0.00020644763374,
        -0.00004681980342,
        0.00001178280314,
        0.00001443470174,
        -0.00016643326394,
        0.00019001958587,
        -0.00027573517109,
        -0.01559999387335,
        -0.00694810289238,
        -0.00310767551047,
        0.00058658157366,
        0.0000776612477,
        -0.00074847803836,
        -0.00027573517109,
        0.01047722233064,
    ]
).reshape(8, 8)

cov_colnames = ["_cons"] * 8

cov_rownames = ["_cons"] * 8

results_multtwostep = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)


est = dict(
    rank=8,
    N=3629,
    Q=0.0002590497181628,
    J=0.940091427212973,
    J_df=1,
    k_1=8,
    converged=1,
    has_xtinst=0,
    type=1,
    n_eq=1,
    k=8,
    n_moments=9,
    k_aux=8,
    k_eq_model=0,
    k_eq=8,
    cmdline="gmm ( (docvis / exp({xb:private medicaid aget aget2 educyr actlim totchr}+{b0})) - 1), instruments(income ssiratio medicaid aget aget2 educyr actlim totchr) twostep wmatrix(robust) vce(unadjusted) center",
    cmd="gmm",
    estat_cmd="gmm_estat",
    predict="gmm_p",
    marginsnotok="_ALL",
    eqnames="1",
    technique="gn",
    winit="Unadjusted",
    estimator="twostep",
    wmatrix="robust",
    vce="unadjusted",
    params="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    inst_1="income ssiratio medicaid aget aget2 educyr actlim totchr _cons",
    params_1="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    sexp_1="(docvis / exp( ({xb_private} *private + {xb_medicaid} *medicaid + {xb_aget} *aget + {xb_aget2} *aget2 + {xb_educyr} *educyr + {xb_actlim} *actlim + {xb_totchr} *totchr) + {b0} )) - 1",
    properties="b V",
)

params_table = np.array(
    [
        0.67815486150911,
        0.25018082946574,
        2.7106587781218,
        0.00671496899138,
        0.1878094461339,
        1.1685002768843,
        np.nan,
        1.9599639845401,
        0,
        0.28872920226215,
        0.10311429027815,
        2.8000891193967,
        0.00510884999633,
        0.08662890702558,
        0.49082949749873,
        np.nan,
        1.9599639845401,
        0,
        0.27067161407481,
        0.0518802415232,
        5.2172388972735,
        1.816099638e-07,
        0.16898820918009,
        0.37235501896953,
        np.nan,
        1.9599639845401,
        0,
        -0.05690878166227,
        0.0118728670827,
        -4.7931793783164,
        1.641587211e-06,
        -0.08017917353758,
        -0.03363838978695,
        np.nan,
        1.9599639845401,
        0,
        0.01438116368432,
        0.00781887593806,
        1.8392878718448,
        0.0658728559523,
        -0.00094355155385,
        0.0297058789225,
        np.nan,
        1.9599639845401,
        0,
        0.18038238197017,
        0.03819661477822,
        4.7224703816696,
        2.329970297e-06,
        0.10551839267351,
        0.25524637126682,
        np.nan,
        1.9599639845401,
        0,
        0.28251055147828,
        0.01376659609161,
        20.521452768591,
        1.385109204e-93,
        0.25552851894901,
        0.30949258400755,
        np.nan,
        1.9599639845401,
        0,
        0.50771182444237,
        0.10208891085993,
        4.9732318639284,
        6.584582712e-07,
        0.30762123593598,
        0.70780241294876,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(8, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = [
    "xb_private",
    "xb_medicaid",
    "xb_aget",
    "xb_aget2",
    "xb_educyr",
    "xb_actlim",
    "xb_totchr",
    "b0",
]

cov = np.array(
    [
        0.06259044743217,
        0.02308524749042,
        0.00531802921719,
        -0.0010223122446,
        -0.00154027662468,
        0.00154945994717,
        -0.00043816683551,
        -0.01554486097815,
        0.02308524749042,
        0.01063255685957,
        0.00205438168765,
        -0.00039193802388,
        -0.00049039628782,
        0.0002760841411,
        -0.0002064504141,
        -0.00691934867666,
        0.00531802921719,
        0.00205438168765,
        0.00269155946051,
        -0.00059250696972,
        -0.00012247118567,
        0.00021403084056,
        -0.00004749600121,
        -0.00308951213731,
        -0.0010223122446,
        -0.00039193802388,
        -0.00059250696972,
        0.00014096497276,
        0.00002468288871,
        -0.00006115240604,
        0.00001190303672,
        0.00058327928125,
        -0.00154027662468,
        -0.00049039628782,
        -0.00012247118567,
        0.00002468288871,
        0.00006113482093,
        -0.00001854325518,
        0.00001439868646,
        0.00007784185009,
        0.00154945994717,
        0.0002760841411,
        0.00021403084056,
        -0.00006115240604,
        -0.00001854325518,
        0.00145898138052,
        -0.00016596475072,
        -0.00074697007542,
        -0.00043816683551,
        -0.0002064504141,
        -0.00004749600121,
        0.00001190303672,
        0.00001439868646,
        -0.00016596475072,
        0.00018951916795,
        -0.00027350320218,
        -0.01554486097815,
        -0.00691934867666,
        -0.00308951213731,
        0.00058327928125,
        0.00007784185009,
        -0.00074697007542,
        -0.00027350320218,
        0.01042214572057,
    ]
).reshape(8, 8)

cov_colnames = [
    "xb_private",
    "xb_medicaid",
    "xb_aget",
    "xb_aget2",
    "xb_educyr",
    "xb_actlim",
    "xb_totchr",
    "b0",
]

cov_rownames = [
    "xb_private",
    "xb_medicaid",
    "xb_aget",
    "xb_aget2",
    "xb_educyr",
    "xb_actlim",
    "xb_totchr",
    "b0",
]


results_multtwostepdefault = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)


est = dict(
    rank=8,
    N=3629,
    Q=0.0002590497181628,
    J=0.940091427212973,
    J_df=1,
    k_1=8,
    converged=1,
    has_xtinst=0,
    type=1,
    n_eq=1,
    k=8,
    n_moments=9,
    k_aux=8,
    k_eq_model=0,
    k_eq=8,
    cmdline="gmm ( (docvis / exp({xb:private medicaid aget aget2 educyr actlim totchr}+{b0})) - 1), instruments(income ssiratio medicaid aget aget2 educyr actlim totchr) twostep wmatrix(robust) center",
    cmd="gmm",
    estat_cmd="gmm_estat",
    predict="gmm_p",
    marginsnotok="_ALL",
    eqnames="1",
    technique="gn",
    winit="Unadjusted",
    estimator="twostep",
    wmatrix="robust",
    vce="robust",
    vcetype="Robust",
    params="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    inst_1="income ssiratio medicaid aget aget2 educyr actlim totchr _cons",
    params_1="xb_private xb_medicaid xb_aget xb_aget2 xb_educyr xb_actlim xb_totchr b0",
    sexp_1="(docvis / exp( ({xb_private} *private + {xb_medicaid} *medicaid + {xb_aget} *aget + {xb_aget2} *aget2 + {xb_educyr} *educyr + {xb_actlim} *actlim + {xb_totchr} *totchr) + {b0} )) - 1",
    properties="b V",
)

params_table = np.array(
    [
        0.67815486150911,
        0.25053960844836,
        2.7067770469869,
        0.00679398676131,
        0.18710625224955,
        1.1692034707687,
        np.nan,
        1.9599639845401,
        0,
        0.28872920226215,
        0.10327332768441,
        2.7957770775479,
        0.00517750993835,
        0.08631719943712,
        0.49114120508719,
        np.nan,
        1.9599639845401,
        0,
        0.27067161407481,
        0.05199697557915,
        5.2055261110869,
        1.934477426e-07,
        0.16875941463467,
        0.37258381351495,
        np.nan,
        1.9599639845401,
        0,
        -0.05690878166227,
        0.01189862079945,
        -4.7828048831437,
        1.728659059e-06,
        -0.08022964989488,
        -0.03358791342965,
        np.nan,
        1.9599639845401,
        0,
        0.01438116368432,
        0.00783219272776,
        1.8361605982125,
        0.06633390816397,
        -0.00096965198207,
        0.02973197935072,
        np.nan,
        1.9599639845401,
        0,
        0.18038238197017,
        0.03826654814775,
        4.71383991244,
        2.430916736e-06,
        0.10538132578791,
        0.25538343815243,
        np.nan,
        1.9599639845401,
        0,
        0.28251055147828,
        0.01378476509846,
        20.494404471929,
        2.415234157e-93,
        0.25549290834996,
        0.3095281946066,
        np.nan,
        1.9599639845401,
        0,
        0.50771182444237,
        0.10235828870929,
        4.960143734762,
        7.044103886e-07,
        0.307093265053,
        0.70833038383174,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(8, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = ["_cons"] * 8

cov = np.array(
    [
        0.06277009540146,
        0.02315708886727,
        0.00533574465012,
        -0.0010254503134,
        -0.00154463481696,
        0.00155084007911,
        -0.00043796389511,
        -0.01559997980204,
        0.02315708886727,
        0.01066538021101,
        0.00206217721135,
        -0.00039331175814,
        -0.00049172883672,
        0.00027603038575,
        -0.00020644729789,
        -0.00694809209467,
        0.00533574465012,
        0.00206217721135,
        0.00270368546938,
        -0.00059509464294,
        -0.000122765895,
        0.00021462183651,
        -0.00004681968717,
        -0.003107676362,
        -0.0010254503134,
        -0.00039331175814,
        -0.00059509464294,
        0.00014157717693,
        0.00002474211983,
        -0.00006134664668,
        0.00001178278294,
        0.00058658166731,
        -0.00154463481696,
        -0.00049172883672,
        -0.000122765895,
        0.00002474211983,
        0.00006134324292,
        -0.00001855938213,
        0.00001443468876,
        0.00007766055925,
        0.00155084007911,
        0.00027603038575,
        0.00021462183651,
        -0.00006134664668,
        -0.00001855938213,
        0.00146432870714,
        -0.00016643336248,
        -0.00074847778305,
        -0.00043796389511,
        -0.00020644729789,
        -0.00004681968717,
        0.00001178278294,
        0.00001443468876,
        -0.00016643336248,
        0.00019001974882,
        -0.00027573582025,
        -0.01559997980204,
        -0.00694809209467,
        -0.003107676362,
        0.00058658166731,
        0.00007766055925,
        -0.00074847778305,
        -0.00027573582025,
        0.0104772192675,
    ]
).reshape(8, 8)

cov_colnames = ["_cons"] * 8

cov_rownames = ["_cons"] * 8


results_multtwostepcenter = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)
