import numpy as np

from statsmodels.tools.testing import ParamsTableTestBunch

param_names = [
    "s",
    "iq",
    "expr",
    "tenure",
    "rns",
    "smsa",
    "dyear_67",
    "dyear_68",
    "dyear_69",
    "dyear_70",
    "dyear_71",
    "dyear_73",
    "_cons",
]


est = dict(
    N=758,
    inexog_ct=10,
    exexog_ct=4,
    endog_ct=2,
    partial_ct=0,
    df_m=12,
    sdofminus=0,
    dofminus=0,
    r2=0.2279825291623523,
    rmse=0.3766456260250817,
    rss=107.5313411236999,
    mss=31.75480871825532,
    r2_a=0.2155473484240278,
    F=37.63903370585436,
    Fp=1.04881083780e-68,
    Fdf1=12,
    Fdf2=745,
    yy=24652.2466174172,
    yyc=139.2861498419552,
    r2u=0.9956380713371686,
    partialcons=0,
    cons=1,
    cdf=12.55161416131593,
    widstat=12.55161416131593,
    cd=0.0675726199801665,
    idp=2.15251425210e-10,
    iddf=3,
    idstat=47.97804382236573,
    sarganp=0.0013146751383334,
    sargandf=2,
    sargan=13.26833137393004,
    jp=0.0013146751383334,
    jdf=2,
    j=13.26833137393004,
    ll=-335.4059158173529,
    rankV=13,
    rankxx=13,
    rankzz=15,
    r2c=0.2279825291623523,
    hacsubtitleV="Statistics consistent for homoskedasticity only",
    hacsubtitleB="Estimates efficient for homoskedasticity only",
    title="IV (2SLS) estimation",
    predict="ivreg2_p",
    version="02.2.08",
    cmdline="ivreg2 lw expr tenure rns smsa dyear* (s iq=med kww age mrt)",
    cmd="ivreg2",
    model="iv",
    depvar="lw",
    partialsmall="small",
    exexog="med kww age mrt",
    inexog="expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    insts="med kww age mrt expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    instd="s iq",
    properties="b V",
)

params_table = np.array(
    [
        0.17242531190423,
        0.02073807855911,
        8.3144304527925,
        9.219394861e-17,
        0.13177942481982,
        0.21307119898864,
        np.nan,
        1.9599639845401,
        0,
        -0.00909883103476,
        0.00470440157185,
        -1.9341101935687,
        0.05309958088226,
        -0.01831928868441,
        0.00012162661488,
        np.nan,
        1.9599639845401,
        0,
        0.04928948974574,
        0.008154589406,
        6.0443864542646,
        1.499796319e-09,
        0.03330678820126,
        0.06527219129022,
        np.nan,
        1.9599639845401,
        0,
        0.04221709210309,
        0.00884287446052,
        4.774136768712,
        1.804797032e-06,
        0.02488537664065,
        0.05954880756552,
        np.nan,
        1.9599639845401,
        0,
        -0.10179345001799,
        0.03417647128271,
        -2.9784657747708,
        0.00289695381119,
        -0.16877810285078,
        -0.03480879718521,
        np.nan,
        1.9599639845401,
        0,
        0.12611094946923,
        0.03092747922238,
        4.0776342799379,
        0.00004549625503,
        0.06549420406076,
        0.18672769487769,
        np.nan,
        1.9599639845401,
        0,
        -0.05961710621535,
        0.05529546018534,
        -1.0781555305902,
        0.28096435347028,
        -0.16799421668718,
        0.04876000425648,
        np.nan,
        1.9599639845401,
        0,
        0.04867955999401,
        0.05201609347935,
        0.93585574651683,
        0.34934746462842,
        -0.05327010984199,
        0.15062922983,
        np.nan,
        1.9599639845401,
        0,
        0.15281763322545,
        0.0515629903814,
        2.9637077309732,
        0.0030395682829,
        0.05175602914272,
        0.25387923730817,
        np.nan,
        1.9599639845401,
        0,
        0.17443605148569,
        0.05975759031645,
        2.9190610023255,
        0.00351087511908,
        0.05731332666255,
        0.29155877630882,
        np.nan,
        1.9599639845401,
        0,
        0.09166596656323,
        0.05414400395495,
        1.6930031003894,
        0.09045487706511,
        -0.01445433116727,
        0.19778626429372,
        np.nan,
        1.9599639845401,
        0,
        0.09323976497853,
        0.0571819085978,
        1.6305815469428,
        0.10297864547348,
        -0.01883471644041,
        0.20531424639747,
        np.nan,
        1.9599639845401,
        0,
        4.0335098946211,
        0.31542152364325,
        12.787681221092,
        1.921209213e-37,
        3.4152950683316,
        4.6517247209107,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(13, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = param_names

cov = np.array(
    [
        0.00043006790232,
        -0.00007669911732,
        0.00003390383154,
        0.00001947510761,
        -0.00014211117725,
        0.00001984430949,
        0.00001313809086,
        -0.00010726217801,
        -0.0000934373525,
        0.00003291577926,
        -0.00026067342405,
        -0.00058025280789,
        0.00230075400852,
        -0.00007669911732,
        0.00002213139415,
        4.388754481e-06,
        -8.774272042e-06,
        0.00005855699916,
        -0.00001627155824,
        -0.00001175114527,
        0.00001447038262,
        -0.00001630144788,
        -0.00007254738147,
        -0.0000221423658,
        0.00001715527313,
        -0.00125964216852,
        0.00003390383154,
        4.388754481e-06,
        0.00006649732838,
        -0.00001561989737,
        0.00003340985346,
        -6.286271714e-06,
        0.00004284715305,
        0.00006535720207,
        0.00002474647562,
        2.348670591e-06,
        -0.00012774309302,
        -0.00013889592824,
        -0.00097053265371,
        0.00001947510761,
        -8.774272042e-06,
        -0.00001561989737,
        0.00007819642872,
        -0.00001656102532,
        -1.454183906e-06,
        0.00006415542548,
        0.0000658729123,
        0.00007759572764,
        0.00006755177717,
        0.00006035533972,
        0.00007925563165,
        0.00048915076309,
        -0.00014211117725,
        0.00005855699916,
        0.00003340985346,
        -0.00001656102532,
        0.00116803118934,
        0.00009910080232,
        0.00010687488928,
        0.0000916567869,
        -0.00004794231232,
        -0.00018139826234,
        -0.00013904727086,
        -0.00016941373862,
        -0.00453388036786,
        0.00001984430949,
        -0.00001627155824,
        -6.286271714e-06,
        -1.454183906e-06,
        0.00009910080232,
        0.00095650897105,
        2.293607157e-06,
        -4.175180521e-06,
        0.00008023363682,
        0.0000277191399,
        0.00011455631826,
        7.627834100e-06,
        0.00071035658346,
        0.00001313809086,
        -0.00001175114527,
        0.00004284715305,
        0.00006415542548,
        0.00010687488928,
        2.293607157e-06,
        0.00305758791711,
        0.00082806878751,
        0.00084056268139,
        0.00086879959596,
        0.00072687243235,
        0.00079702544855,
        0.00005969922435,
        -0.00010726217801,
        0.00001447038262,
        0.00006535720207,
        0.0000658729123,
        0.0000916567869,
        -4.175180521e-06,
        0.00082806878751,
        0.00270567398085,
        0.00090000327564,
        0.0008652672979,
        0.00075215815711,
        0.00093055832029,
        -0.0011308128858,
        -0.0000934373525,
        -0.00001630144788,
        0.00002474647562,
        0.00007759572764,
        -0.00004794231232,
        0.00008023363682,
        0.00084056268139,
        0.00090000327564,
        0.00265874197707,
        0.00106768253686,
        0.00097403133741,
        0.00118960267354,
        0.00179874271988,
        0.00003291577926,
        -0.00007254738147,
        2.348670591e-06,
        0.00006755177717,
        -0.00018139826234,
        0.0000277191399,
        0.00086879959596,
        0.0008652672979,
        0.00106768253686,
        0.00357096960043,
        0.00115404290469,
        0.00134956217212,
        0.00598978065251,
        -0.00026067342405,
        -0.0000221423658,
        -0.00012774309302,
        0.00006035533972,
        -0.00013904727086,
        0.00011455631826,
        0.00072687243235,
        0.00075215815711,
        0.00097403133741,
        0.00115404290469,
        0.00293157316427,
        0.00171538928992,
        0.0048030008792,
        -0.00058025280789,
        0.00001715527313,
        -0.00013889592824,
        0.00007925563165,
        -0.00016941373862,
        7.627834100e-06,
        0.00079702544855,
        0.00093055832029,
        0.00118960267354,
        0.00134956217212,
        0.00171538928992,
        0.00326977067089,
        0.00483241607215,
        0.00230075400852,
        -0.00125964216852,
        -0.00097053265371,
        0.00048915076309,
        -0.00453388036786,
        0.00071035658346,
        0.00005969922435,
        -0.0011308128858,
        0.00179874271988,
        0.00598978065251,
        0.0048030008792,
        0.00483241607215,
        0.09949073757743,
    ]
).reshape(13, 13)

cov_colnames = param_names

cov_rownames = param_names


results = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)


est = dict(
    N=758,
    inexog_ct=10,
    exexog_ct=4,
    endog_ct=2,
    partial_ct=0,
    df_m=12,
    sdofminus=0,
    dofminus=0,
    r2=0.2279825291623523,
    rmse=0.3766456260250817,
    rss=107.5313411236999,
    mss=31.75480871825532,
    r2_a=0.2155473484240278,
    F=40.08955571761713,
    Fp=1.50331141073e-72,
    Fdf1=12,
    Fdf2=745,
    yy=24652.2466174172,
    yyc=139.2861498419552,
    r2u=0.9956380713371686,
    partialcons=0,
    cons=1,
    cdf=12.55161416131593,
    widstat=11.46142788662503,
    cd=0.0675726199801665,
    idp=6.77658650925e-09,
    iddf=3,
    idstat=40.92698219921901,
    jp=0.0030253131145893,
    jdf=2,
    j=11.60148136780177,
    ll=-335.4059158173529,
    rankV=13,
    rankS=15,
    rankxx=13,
    rankzz=15,
    r2c=0.2279825291623523,
    hacsubtitleV="Statistics robust to heteroskedasticity",
    hacsubtitleB="Estimates efficient for homoskedasticity only",
    title="IV (2SLS) estimation",
    predict="ivreg2_p",
    version="02.2.08",
    cmdline="ivreg2 lw expr tenure rns smsa dyear* (s iq=med kww age mrt), robust",
    cmd="ivreg2",
    model="iv",
    depvar="lw",
    vcetype="Robust",
    partialsmall="small",
    exexog="med kww age mrt",
    inexog="expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    insts="med kww age mrt expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    instd="s iq",
    properties="b V",
)

params_table = np.array(
    [
        0.17242531190423,
        0.02073946970741,
        8.3138727429773,
        9.262847918e-17,
        0.13177669821925,
        0.21307392558922,
        np.nan,
        1.9599639845401,
        0,
        -0.00909883103476,
        0.00488623921475,
        -1.862133766863,
        0.06258423744885,
        -0.01867568391553,
        0.000478021846,
        np.nan,
        1.9599639845401,
        0,
        0.04928948974574,
        0.00804979771814,
        6.1230718424932,
        9.178828239e-10,
        0.03351217613534,
        0.06506680335614,
        np.nan,
        1.9599639845401,
        0,
        0.04221709210309,
        0.00946363451747,
        4.4609808235038,
        8.158539136e-06,
        0.02366870928599,
        0.06076547492018,
        np.nan,
        1.9599639845401,
        0,
        -0.10179345001799,
        0.03371052765435,
        -3.0196338384772,
        0.0025308044732,
        -0.16786487012036,
        -0.03572202991563,
        np.nan,
        1.9599639845401,
        0,
        0.12611094946923,
        0.03081138055695,
        4.0929989889975,
        0.0000425829578,
        0.06572175326364,
        0.18650014567481,
        np.nan,
        1.9599639845401,
        0,
        -0.05961710621535,
        0.05171372338658,
        -1.1528295065836,
        0.24898037077447,
        -0.16097414155951,
        0.04173992912881,
        np.nan,
        1.9599639845401,
        0,
        0.04867955999401,
        0.04981322391886,
        0.97724170740882,
        0.32844950437829,
        -0.04895256484079,
        0.14631168482881,
        np.nan,
        1.9599639845401,
        0,
        0.15281763322545,
        0.04792849748217,
        3.1884503219051,
        0.00143037585571,
        0.05887950432728,
        0.24675576212361,
        np.nan,
        1.9599639845401,
        0,
        0.17443605148569,
        0.06112514588945,
        2.8537527223437,
        0.00432061472656,
        0.0546329669926,
        0.29423913597877,
        np.nan,
        1.9599639845401,
        0,
        0.09166596656323,
        0.05546180250571,
        1.6527765492979,
        0.09837634843385,
        -0.01703716886563,
        0.20036910199209,
        np.nan,
        1.9599639845401,
        0,
        0.09323976497853,
        0.06084900555321,
        1.5323137022675,
        0.12544504141872,
        -0.02602209440084,
        0.21250162435791,
        np.nan,
        1.9599639845401,
        0,
        4.0335098946211,
        0.33503289255951,
        12.039145959093,
        2.212341116e-33,
        3.3768574915682,
        4.6901622976741,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(13, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = param_names

cov = np.array(
    [
        0.00043012560374,
        -0.00007821948167,
        0.00002814664043,
        0.00001470659468,
        -0.0001813729733,
        -8.404214148e-06,
        -0.00011649583596,
        -0.000190986044,
        -0.0001267060192,
        -0.00008672920729,
        -0.00031350033086,
        -0.00062509206513,
        0.00258704275336,
        -0.00007821948167,
        0.00002387533366,
        4.911669726e-06,
        -0.00001098678321,
        0.00006618473559,
        -0.00002158670033,
        8.107545182e-07,
        0.00003255315461,
        -0.00002143051923,
        -0.00005975353088,
        -0.00001402380853,
        0.00001385883995,
        -0.00142630445991,
        0.00002814664043,
        4.911669726e-06,
        0.0000647992433,
        -0.00001977796198,
        0.00005110284339,
        -0.00003232809925,
        0.00003557970375,
        0.00008581782551,
        0.00002961847493,
        0.00001478700432,
        -0.00008727552542,
        -0.00012994173162,
        -0.000941201163,
        0.00001470659468,
        -0.00001098678321,
        -0.00001977796198,
        0.00008956037828,
        -0.00003784800305,
        7.059546852e-06,
        0.0000815195063,
        0.00006348047141,
        0.00010852497853,
        0.00009624187487,
        0.0001082378721,
        0.0000913295716,
        0.00074787094515,
        -0.0001813729733,
        0.00006618473559,
        0.00005110284339,
        -0.00003784800305,
        0.00113639967473,
        0.0001331351818,
        0.00019039509428,
        0.00020009655722,
        7.191780470e-06,
        0.00002329093699,
        -0.00005087978262,
        0.00009086571417,
        -0.0049574872418,
        -8.404214148e-06,
        -0.00002158670033,
        -0.00003232809925,
        7.059546852e-06,
        0.0001331351818,
        0.00094934117183,
        0.00006195450043,
        0.00011810217306,
        0.00025505395801,
        0.00011081126682,
        0.0003013467353,
        0.00030676742453,
        0.00155300401661,
        -0.00011649583596,
        8.107545182e-07,
        0.00003557970375,
        0.0000815195063,
        0.00019039509428,
        0.00006195450043,
        0.0026743091865,
        0.00086135304687,
        0.00092017339013,
        0.00095567351458,
        0.00088700647379,
        0.00102883960334,
        0.00031676175972,
        -0.000190986044,
        0.00003255315461,
        0.00008581782551,
        0.00006348047141,
        0.00020009655722,
        0.00011810217306,
        0.00086135304687,
        0.00248135727719,
        0.00093026821071,
        0.00087773786421,
        0.00081079994607,
        0.0009428852573,
        -0.00207087031744,
        -0.0001267060192,
        -0.00002143051923,
        0.00002961847493,
        0.00010852497853,
        7.191780470e-06,
        0.00025505395801,
        0.00092017339013,
        0.00093026821071,
        0.0022971408709,
        0.00117701812528,
        0.00109484405896,
        0.00129252524214,
        0.00250083573092,
        -0.00008672920729,
        -0.00005975353088,
        0.00001478700432,
        0.00009624187487,
        0.00002329093699,
        0.00011081126682,
        0.00095567351458,
        0.00087773786421,
        0.00117701812528,
        0.00373628346001,
        0.00123495172003,
        0.00154490399913,
        0.00600809353497,
        -0.00031350033086,
        -0.00001402380853,
        -0.00008727552542,
        0.0001082378721,
        -0.00005087978262,
        0.0003013467353,
        0.00088700647379,
        0.00081079994607,
        0.00109484405896,
        0.00123495172003,
        0.00307601153718,
        0.00181187884386,
        0.00430884303329,
        -0.00062509206513,
        0.00001385883995,
        -0.00012994173162,
        0.0000913295716,
        0.00009086571417,
        0.00030676742453,
        0.00102883960334,
        0.0009428852573,
        0.00129252524214,
        0.00154490399913,
        0.00181187884386,
        0.00370260147681,
        0.00534911865268,
        0.00258704275336,
        -0.00142630445991,
        -0.000941201163,
        0.00074787094515,
        -0.0049574872418,
        0.00155300401661,
        0.00031676175972,
        -0.00207087031744,
        0.00250083573092,
        0.00600809353497,
        0.00430884303329,
        0.00534911865268,
        0.11224703909679,
    ]
).reshape(13, 13)

cov_colnames = param_names

cov_rownames = param_names


results_robust = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)


est = dict(
    N=758,
    inexog_ct=10,
    exexog_ct=4,
    endog_ct=2,
    partial_ct=0,
    df_r=745,
    df_m=12,
    sdofminus=0,
    dofminus=0,
    r2=0.2279825291623523,
    rmse=0.3799175840045295,
    rss=107.5313411236999,
    mss=31.75480871825532,
    r2_a=0.2155473484240278,
    F=37.63903370585438,
    Fp=1.04881083780e-68,
    Fdf1=12,
    Fdf2=745,
    yy=24652.2466174172,
    yyc=139.2861498419552,
    partialcons=0,
    cons=1,
    cdf=12.55161416131593,
    widstat=12.55161416131593,
    cd=0.0675726199801665,
    idp=2.15251425210e-10,
    iddf=3,
    idstat=47.97804382236573,
    sarganp=0.0013146751383334,
    sargandf=2,
    sargan=13.26833137393004,
    jp=0.0013146751383334,
    jdf=2,
    j=13.26833137393004,
    ll=-335.4059158173529,
    rankV=13,
    rankxx=13,
    rankzz=15,
    r2c=0.2279825291623523,
    r2u=0.9956380713371686,
    hacsubtitleV="Statistics consistent for homoskedasticity only",
    hacsubtitleB="Estimates efficient for homoskedasticity only",
    title="IV (2SLS) estimation",
    predict="ivreg2_p",
    version="02.2.08",
    cmdline="ivreg2 lw expr tenure rns smsa dyear* (s iq=med kww age mrt), small",
    cmd="ivreg2",
    model="iv",
    depvar="lw",
    partialsmall="small",
    small="small",
    exexog="med kww age mrt",
    inexog="expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    insts="med kww age mrt expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    instd="s iq",
    properties="b V",
)

params_table = np.array(
    [
        0.17242531190423,
        0.02091823230823,
        8.2428242197305,
        7.570254109e-16,
        0.13135961443277,
        0.2134910093757,
        745,
        1.9631533327653,
        0,
        -0.00909883103476,
        0.00474526917577,
        -1.917453088061,
        0.055562500369,
        -0.01841452203205,
        0.00021685996252,
        745,
        1.9631533327653,
        0,
        0.04928948974574,
        0.00822542913447,
        5.9923304839106,
        3.219967401e-09,
        0.03314171112698,
        0.0654372683645,
        745,
        1.9631533327653,
        0,
        0.04221709210309,
        0.00891969338965,
        4.7330205488974,
        2.647391010e-06,
        0.02470636629795,
        0.05972781790823,
        745,
        1.9631533327653,
        0,
        -0.10179345001799,
        0.03447336568476,
        -2.9528143828148,
        0.00324794122176,
        -0.16946995275367,
        -0.03411694728232,
        745,
        1.9631533327653,
        0,
        0.12611094946923,
        0.03119614930755,
        4.0425165370872,
        0.00005838098525,
        0.06486812498666,
        0.18735377395179,
        745,
        1.9631533327653,
        0,
        -0.05961710621535,
        0.05577581734252,
        -1.0688701493919,
        0.28547438462206,
        -0.16911358791902,
        0.04987937548832,
        745,
        1.9631533327653,
        0,
        0.04867955999401,
        0.05246796245209,
        0.92779589141575,
        0.35381393703187,
        -0.05432309535722,
        0.15168221534524,
        745,
        1.9631533327653,
        0,
        0.15281763322545,
        0.0520109232025,
        2.9381834394759,
        0.00340336072573,
        0.05071221600025,
        0.25492305045064,
        745,
        1.9631533327653,
        0,
        0.17443605148569,
        0.06027671044146,
        2.8939212211172,
        0.00391575116799,
        0.0561036264944,
        0.29276847647697,
        745,
        1.9631533327653,
        0,
        0.09166596656323,
        0.05461435829744,
        1.678422477547,
        0.09368402236573,
        -0.01555039294523,
        0.19888232607168,
        745,
        1.9631533327653,
        0,
        0.09323976497853,
        0.05767865351978,
        1.6165385162217,
        0.10640126701552,
        -0.01999227590824,
        0.20647180586531,
        745,
        1.9631533327653,
        0,
        4.0335098946211,
        0.31816162176165,
        12.677550083784,
        1.723599587e-33,
        3.4089098465017,
        4.6581099427405,
        745,
        1.9631533327653,
        0,
    ]
).reshape(13, 9)

params_table_colnames = "b se t pvalue ll ul df crit eform".split()

params_table_rownames = param_names

cov = np.array(
    [
        0.0004375724429,
        -0.00007803749118,
        0.00003449544203,
        0.0000198149417,
        -0.00014459096961,
        0.00002019058603,
        0.00001336734613,
        -0.00010913386703,
        -0.00009506780295,
        0.00003349014856,
        -0.00026522208782,
        -0.00059037802467,
        0.0023409013939,
        -0.00007803749118,
        0.00002251757955,
        4.465336774e-06,
        -8.927380145e-06,
        0.00005957879915,
        -0.00001655549147,
        -0.00001195619881,
        0.00001472288594,
        -0.00001658590268,
        -0.00007381330893,
        -0.00002252874265,
        0.00001745462689,
        -0.00128162250166,
        0.00003449544203,
        4.465336774e-06,
        0.00006765768445,
        -0.00001589245933,
        0.00003399284419,
        -6.395965046e-06,
        0.0000435948215,
        0.00006649766331,
        0.00002517829331,
        2.389654105e-06,
        -0.00012997216713,
        -0.00014131961558,
        -0.00098746812283,
        0.0000198149417,
        -8.927380145e-06,
        -0.00001589245933,
        0.00007956093017,
        -0.00001685000965,
        -1.479558927e-06,
        0.00006527491612,
        0.00006702237252,
        0.00007894974705,
        0.00006873053302,
        0.00006140852014,
        0.00008063861583,
        0.00049768627977,
        -0.00014459096961,
        0.00005957879915,
        0.00003399284419,
        -0.00001685000965,
        0.00118841294164,
        0.00010083007806,
        0.00010873982024,
        0.00009325616707,
        -0.00004877888958,
        -0.00018456360114,
        -0.00014147359908,
        -0.00017236995151,
        -0.00461299505884,
        0.00002019058603,
        -0.00001655549147,
        -6.395965046e-06,
        -1.479558927e-06,
        0.00010083007806,
        0.00097319973162,
        2.333629833e-06,
        -4.248036020e-06,
        0.00008163368686,
        0.00002820282959,
        0.00011655528757,
        7.760937245e-06,
        0.00072275206747,
        0.00001336734613,
        -0.00001195619881,
        0.0000435948215,
        0.00006527491612,
        0.00010873982024,
        2.333629833e-06,
        0.00311094180023,
        0.00084251830998,
        0.00085523021811,
        0.00088395985737,
        0.00073955611238,
        0.00081093327517,
        0.00006074095578,
        -0.00010913386703,
        0.00001472288594,
        0.00006649766331,
        0.00006702237252,
        0.00009325616707,
        -4.248036020e-06,
        0.00084251830998,
        0.00275288708387,
        0.00091570803079,
        0.00088036592189,
        0.00076528306455,
        0.00094679625072,
        -0.00115054519119,
        -0.00009506780295,
        -0.00001658590268,
        0.00002517829331,
        0.00007894974705,
        -0.00004877888958,
        0.00008163368686,
        0.00085523021811,
        0.00091570803079,
        0.00270513613238,
        0.00108631323884,
        0.00099102785739,
        0.001210360841,
        0.00183013017674,
        0.00003349014856,
        -0.00007381330893,
        2.389654105e-06,
        0.00006873053302,
        -0.00018456360114,
        0.00002820282959,
        0.00088395985737,
        0.00088036592189,
        0.00108631323884,
        0.00363328182164,
        0.00117418056612,
        0.00137311157915,
        0.0060943003149,
        -0.00026522208782,
        -0.00002252874265,
        -0.00012997216713,
        0.00006140852014,
        -0.00014147359908,
        0.00011655528757,
        0.00073955611238,
        0.00076528306455,
        0.00099102785739,
        0.00117418056612,
        0.00298272813224,
        0.00174532225739,
        0.0048868116328,
        -0.00059037802467,
        0.00001745462689,
        -0.00014131961558,
        0.00008063861583,
        -0.00017236995151,
        7.760937245e-06,
        0.00081093327517,
        0.00094679625072,
        0.001210360841,
        0.00137311157915,
        0.00174532225739,
        0.00332682707186,
        0.00491674011099,
        0.0023409013939,
        -0.00128162250166,
        -0.00098746812283,
        0.00049768627977,
        -0.00461299505884,
        0.00072275206747,
        0.00006074095578,
        -0.00115054519119,
        0.00183013017674,
        0.0060943003149,
        0.0048868116328,
        0.00491674011099,
        0.101226817562,
    ]
).reshape(13, 13)

cov_colnames = param_names

cov_rownames = param_names


# not autogenerated
# calculated with `ivendog` after ivreg2
hausman = dict(
    df_r=743,
    df=2,
    WHFp=1.47099195224e-16,
    WHF=38.30408858936179,
    DWHp=4.12270104038e-16,
    DWH=70.84970589405181,
)

results_small = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    hausman=hausman,
    **est,
)


est = dict(
    N=758,
    inexog_ct=10,
    exexog_ct=4,
    endog_ct=2,
    partial_ct=0,
    df_r=745,
    df_m=12,
    sdofminus=0,
    dofminus=0,
    r2=0.2279825291623523,
    rmse=0.3799175840045295,
    rss=107.5313411236999,
    mss=31.75480871825532,
    r2_a=0.2155473484240278,
    F=40.08955571761724,
    Fp=1.50331141073e-72,
    Fdf1=12,
    Fdf2=745,
    yy=24652.2466174172,
    yyc=139.2861498419552,
    partialcons=0,
    cons=1,
    cdf=12.55161416131593,
    widstat=11.46142788662503,
    cd=0.0675726199801665,
    idp=6.77658650925e-09,
    iddf=3,
    idstat=40.92698219921901,
    jp=0.0030253131145893,
    jdf=2,
    j=11.60148136780177,
    ll=-335.4059158173529,
    rankV=13,
    rankS=15,
    rankxx=13,
    rankzz=15,
    r2c=0.2279825291623523,
    r2u=0.9956380713371686,
    hacsubtitleV="Statistics robust to heteroskedasticity",
    hacsubtitleB="Estimates efficient for homoskedasticity only",
    title="IV (2SLS) estimation",
    predict="ivreg2_p",
    version="02.2.08",
    cmdline="ivreg2 lw expr tenure rns smsa dyear* (s iq=med kww age mrt), small robust",
    cmd="ivreg2",
    model="iv",
    depvar="lw",
    vcetype="Robust",
    partialsmall="small",
    small="small",
    exexog="med kww age mrt",
    inexog="expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    insts="med kww age mrt expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    instd="s iq",
    properties="b V",
)

params_table = np.array(
    [
        0.17242531190423,
        0.02091963554158,
        8.2422713130704,
        7.602390656e-16,
        0.13135685967055,
        0.21349376413792,
        745,
        1.9631533327653,
        0,
        -0.00909883103476,
        0.00492868646034,
        -1.8460965427549,
        0.06527471189517,
        -0.01877459828554,
        0.00057693621602,
        745,
        1.9631533327653,
        0,
        0.04928948974574,
        0.00811972711081,
        6.0703382112603,
        2.032123371e-09,
        0.03334922040701,
        0.06522975908447,
        745,
        1.9631533327653,
        0,
        0.04221709210309,
        0.0095458460509,
        4.4225615915015,
        0.00001120706314,
        0.0234771326142,
        0.06095705159197,
        745,
        1.9631533327653,
        0,
        -0.10179345001799,
        0.0340033743578,
        -2.9936278954812,
        0.00284801771574,
        -0.16854728771377,
        -0.03503961232222,
        745,
        1.9631533327653,
        0,
        0.12611094946923,
        0.03107904208149,
        4.057748920915,
        0.00005477891606,
        0.0650980244278,
        0.18712387451065,
        745,
        1.9631533327653,
        0,
        -0.05961710621535,
        0.05216296564028,
        -1.1429010119263,
        0.25344683532742,
        -0.16202100605898,
        0.04278679362828,
        745,
        1.9631533327653,
        0,
        0.04867955999401,
        0.05024595634484,
        0.96882542467533,
        0.33294671206223,
        -0.04996095666234,
        0.14732007665036,
        745,
        1.9631533327653,
        0,
        0.15281763322545,
        0.04834485710231,
        3.1609904834768,
        0.00163599246861,
        0.05790926588299,
        0.24772600056791,
        745,
        1.9631533327653,
        0,
        0.17443605148569,
        0.06165614610562,
        2.8291753945643,
        0.00479228267652,
        0.05339558277297,
        0.2954765201984,
        745,
        1.9631533327653,
        0,
        0.09166596656323,
        0.05594360469515,
        1.638542368922,
        0.10173082236229,
        -0.01815990744096,
        0.20149184056742,
        745,
        1.9631533327653,
        0,
        0.09323976497853,
        0.06137760691084,
        1.5191169820938,
        0.12915730016675,
        -0.02725388858564,
        0.21373341854271,
        745,
        1.9631533327653,
        0,
        4.0335098946211,
        0.33794335658841,
        11.935461419748,
        3.577808889e-30,
        3.3700752678487,
        4.6969445213936,
        745,
        1.9631533327653,
        0,
    ]
).reshape(13, 9)

params_table_colnames = "b se t pvalue ll ul df crit eform".split()

params_table_rownames = param_names

cov = np.array(
    [
        0.00043763115119,
        -0.00007958438537,
        0.00002863778986,
        0.00001496321982,
        -0.00018453787082,
        -8.550864865e-06,
        -0.0001185286492,
        -0.00019431868638,
        -0.00012891699672,
        -0.00008824260285,
        -0.00031897080643,
        -0.0006359997119,
        0.00263218578127,
        -0.00007958438537,
        0.00002429195022,
        4.997376715e-06,
        -0.00001117849889,
        0.00006733963701,
        -0.00002196338101,
        8.249019125e-07,
        0.00003312119623,
        -0.0000218044746,
        -0.00006079620995,
        -0.00001426851928,
        0.00001410067206,
        -0.00145119299411,
        0.00002863778986,
        4.997376715e-06,
        0.00006592996835,
        -0.00002012308078,
        0.00005199457086,
        -0.00003289221373,
        0.00003620055764,
        0.00008731531776,
        0.00003013530738,
        0.00001504503258,
        -0.00008879845405,
        -0.00013220917123,
        -0.00095762480745,
        0.00001496321982,
        -0.00001117849889,
        -0.00002012308078,
        0.00009112317683,
        -0.000038508438,
        7.182733576e-06,
        0.00008294199433,
        0.00006458818434,
        0.00011041870299,
        0.00009792126329,
        0.00011012658665,
        0.00009292324197,
        0.00076092104218,
        -0.00018453787082,
        0.00006733963701,
        0.00005199457086,
        -0.000038508438,
        0.00115622946772,
        0.00013545834604,
        0.00019371742478,
        0.000203588175,
        7.317274626e-06,
        0.00002369735603,
        -0.00005176761775,
        0.00009245129039,
        -0.00504399373059,
        -8.550864865e-06,
        -0.00002196338101,
        -0.00003289221373,
        7.182733576e-06,
        0.00013545834604,
        0.0009659068567,
        0.00006303558567,
        0.00012016301635,
        0.00025950456399,
        0.00011274488624,
        0.00030660513471,
        0.00031212041314,
        0.00158010341555,
        -0.0001185286492,
        8.249019125e-07,
        0.00003620055764,
        0.00008294199433,
        0.00019371742478,
        0.00006303558567,
        0.00272097498439,
        0.0008763833685,
        0.000936230107,
        0.00097234969671,
        0.0009024844391,
        0.00104679250917,
        0.00032228914613,
        -0.00019431868638,
        0.00003312119623,
        0.00008731531776,
        0.00006458818434,
        0.000203588175,
        0.00012016301635,
        0.0008763833685,
        0.00252465612901,
        0.00094650107881,
        0.0008930540954,
        0.00082494813305,
        0.00095933828863,
        -0.00210700630956,
        -0.00012891699672,
        -0.0000218044746,
        0.00003013530738,
        0.00011041870299,
        7.317274626e-06,
        0.00025950456399,
        0.000936230107,
        0.00094650107881,
        0.00233722520824,
        0.0011975566966,
        0.00111394872039,
        0.00131507937389,
        0.00254447447521,
        -0.00008824260285,
        -0.00006079620995,
        0.00001504503258,
        0.00009792126329,
        0.00002369735603,
        0.00011274488624,
        0.00097234969671,
        0.0008930540954,
        0.0011975566966,
        0.0038014803526,
        0.00125650121313,
        0.00157186205549,
        0.00611293275102,
        -0.00031897080643,
        -0.00001426851928,
        -0.00008879845405,
        0.00011012658665,
        -0.00005176761775,
        0.00030660513471,
        0.0009024844391,
        0.00082494813305,
        0.00111394872039,
        0.00125650121313,
        0.00312968690629,
        0.00184349552167,
        0.0043840308983,
        -0.0006359997119,
        0.00001410067206,
        -0.00013220917123,
        0.00009292324197,
        0.00009245129039,
        0.00031212041314,
        0.00104679250917,
        0.00095933828863,
        0.00131507937389,
        0.00157186205549,
        0.00184349552167,
        0.0037672106301,
        0.00544245897816,
        0.00263218578127,
        -0.00145119299411,
        -0.00095762480745,
        0.00076092104218,
        -0.00504399373059,
        0.00158010341555,
        0.00032228914613,
        -0.00210700630956,
        0.00254447447521,
        0.00611293275102,
        0.0043840308983,
        0.00544245897816,
        0.11420571226224,
    ]
).reshape(13, 13)

cov_colnames = param_names

cov_rownames = param_names


results_small_robust = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)


est = dict(
    N=758,
    inexog_ct=10,
    exexog_ct=4,
    endog_ct=2,
    partial_ct=0,
    df_m=12,
    sdofminus=0,
    dofminus=0,
    r2=0.2168305947462866,
    rmse=0.3793562300139549,
    rss=109.0846511318037,
    mss=30.20149871015154,
    r2_a=0.2042157855341463,
    F=41.97598961240392,
    Fp=1.89290505854e-75,
    Fdf1=12,
    Fdf2=745,
    yy=24652.2466174172,
    yyc=139.2861498419552,
    r2u=0.995575062475047,
    partialcons=0,
    cons=1,
    cdf=12.55161416131593,
    widstat=11.46142788662503,
    cd=0.0675726199801665,
    idp=6.77658650925e-09,
    iddf=3,
    idstat=40.92698219921901,
    jp=0.0030253131145893,
    jdf=2,
    j=11.60148136780177,
    ll=-340.8414755627023,
    rankV=13,
    rankS=15,
    rankxx=13,
    rankzz=15,
    r2c=0.2168305947462866,
    hacsubtitleV="Statistics robust to heteroskedasticity",
    hacsubtitleB="Estimates efficient for arbitrary heteroskedasticity",
    title="2-Step GMM estimation",
    predict="ivreg2_p",
    version="02.2.08",
    cmdline="ivreg2 lw expr tenure rns smsa dyear* (s iq=med kww age mrt), gmm2s robust",
    cmd="ivreg2",
    model="gmm2s",
    depvar="lw",
    vcetype="Robust",
    partialsmall="small",
    exexog="med kww age mrt",
    inexog="expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    insts="med kww age mrt expr tenure rns smsa dyear_67 dyear_68 dyear_69 dyear_70 dyear_71 dyear_73",
    instd="s iq",
    properties="b V",
)

params_table = np.array(
    [
        0.17579576800916,
        0.02067662557145,
        8.5021498020418,
        1.861114268e-17,
        0.13527032656731,
        0.21632120945101,
        np.nan,
        1.9599639845401,
        0,
        -0.00928615655484,
        0.00488241935929,
        -1.9019579989933,
        0.05717664576009,
        -0.01885552265647,
        0.00028320954679,
        np.nan,
        1.9599639845401,
        0,
        0.0502827590727,
        0.00804384217519,
        6.251087226427,
        4.076051363e-10,
        0.03451711811201,
        0.06604840003339,
        np.nan,
        1.9599639845401,
        0,
        0.04252138311207,
        0.00945488880069,
        4.4972906618407,
        6.882486994e-06,
        0.0239901415849,
        0.06105262463925,
        np.nan,
        1.9599639845401,
        0,
        -0.10409306761385,
        0.03352385821237,
        -3.105044382255,
        0.00190250475151,
        -0.16979862233293,
        -0.03838751289477,
        np.nan,
        1.9599639845401,
        0,
        0.12475123235604,
        0.03077474836143,
        4.0536881371349,
        0.00005041641801,
        0.06443383393436,
        0.18506863077773,
        np.nan,
        1.9599639845401,
        0,
        -0.05304317352459,
        0.05146091261443,
        -1.0307468490116,
        0.30265954893659,
        -0.15390470886044,
        0.04781836181126,
        np.nan,
        1.9599639845401,
        0,
        0.04595459037414,
        0.04957352345681,
        0.92699867126001,
        0.35392722417214,
        -0.05120773018796,
        0.14311691093625,
        np.nan,
        1.9599639845401,
        0,
        0.15548006234452,
        0.04763105506,
        3.264258206094,
        0.00109751095685,
        0.06212490988128,
        0.24883521480777,
        np.nan,
        1.9599639845401,
        0,
        0.16698745539298,
        0.06100058345996,
        2.7374730850337,
        0.00619131861175,
        0.04742850877554,
        0.28654640201043,
        np.nan,
        1.9599639845401,
        0,
        0.08464846645323,
        0.05540348923564,
        1.5278544297672,
        0.12654868468826,
        -0.02394037706648,
        0.19323730997294,
        np.nan,
        1.9599639845401,
        0,
        0.09960684400937,
        0.06070338085689,
        1.6408780302402,
        0.10082273637942,
        -0.01936959620995,
        0.2185832842287,
        np.nan,
        1.9599639845401,
        0,
        4.0039243729942,
        0.33484233500232,
        11.957640819123,
        5.922056626e-33,
        3.3476454558904,
        4.6602032900981,
        np.nan,
        1.9599639845401,
        0,
    ]
).reshape(13, 9)

params_table_colnames = "b se z pvalue ll ul df crit eform".split()

params_table_rownames = param_names

cov = np.array(
    [
        0.00042752284502,
        -0.00007792910934,
        0.00002799053689,
        0.00001411255161,
        -0.00017627354771,
        -6.164167361e-06,
        -0.00011238067476,
        -0.0001840592946,
        -0.00012075971225,
        -0.00008045016526,
        -0.00030956302647,
        -0.00062213915849,
        0.0025864317125,
        -0.00007792910934,
        0.0000238380188,
        4.908457545e-06,
        -0.0000109083863,
        0.00006550360735,
        -0.00002187678826,
        4.129956698e-08,
        0.00003161755605,
        -0.00002236410253,
        -0.00006047183643,
        -0.0000144130349,
        0.00001326368633,
        -0.00142544425011,
        0.00002799053689,
        4.908457545e-06,
        0.00006470339694,
        -0.00001976276105,
        0.00005093819277,
        -0.0000323622135,
        0.00003452531659,
        0.00008555059005,
        0.0000288422901,
        0.00001508898973,
        -0.00008682961428,
        -0.00013087868262,
        -0.00093791708189,
        0.00001411255161,
        -0.0000109083863,
        -0.00001976276105,
        0.00008939492223,
        -0.00003640760589,
        7.669817608e-06,
        0.00008322349071,
        0.00006546263505,
        0.00011054793547,
        0.00009771882719,
        0.00010901321979,
        0.0000926582973,
        0.00074577978354,
        -0.00017627354771,
        0.00006550360735,
        0.00005093819277,
        -0.00003640760589,
        0.00112384906944,
        0.00012782990916,
        0.0001752536517,
        0.00018281146997,
        -0.00001062129812,
        0.0000105829103,
        -0.00005745271672,
        0.00007901951626,
        -0.00493822443862,
        -6.164167361e-06,
        -0.00002187678826,
        -0.0000323622135,
        7.669817608e-06,
        0.00012782990916,
        0.00094708513671,
        0.00005587818268,
        0.0001108109152,
        0.00024772966236,
        0.00010526192189,
        0.00029836672951,
        0.0003020559345,
        0.00155999842113,
        -0.00011238067476,
        4.129956698e-08,
        0.00003452531659,
        0.00008322349071,
        0.0001752536517,
        0.00005587818268,
        0.00264822552711,
        0.00084013008538,
        0.00089372787896,
        0.00094462335409,
        0.00088393735147,
        0.00100740924129,
        0.00036769011237,
        -0.0001840592946,
        0.00003161755605,
        0.00008555059005,
        0.00006546263505,
        0.00018281146997,
        0.0001108109152,
        0.00084013008538,
        0.00245753422792,
        0.00090550111616,
        0.00086043845508,
        0.00080197738555,
        0.00092623266791,
        -0.00204303139567,
        -0.00012075971225,
        -0.00002236410253,
        0.0000288422901,
        0.00011054793547,
        -0.00001062129812,
        0.00024772966236,
        0.00089372787896,
        0.00090550111616,
        0.00226871740613,
        0.00116169566043,
        0.00108859648529,
        0.00127118636737,
        0.00254572878148,
        -0.00008045016526,
        -0.00006047183643,
        0.00001508898973,
        0.00009771882719,
        0.0000105829103,
        0.00010526192189,
        0.00094462335409,
        0.00086043845508,
        0.00116169566043,
        0.00372107118246,
        0.00122563410541,
        0.00153681917159,
        0.00601243235865,
        -0.00030956302647,
        -0.0000144130349,
        -0.00008682961428,
        0.00010901321979,
        -0.00005745271672,
        0.00029836672951,
        0.00088393735147,
        0.00080197738555,
        0.00108859648529,
        0.00122563410541,
        0.00306954661948,
        0.00181011399651,
        0.00430171295221,
        -0.00062213915849,
        0.00001326368633,
        -0.00013087868262,
        0.0000926582973,
        0.00007901951626,
        0.0003020559345,
        0.00100740924129,
        0.00092623266791,
        0.00127118636737,
        0.00153681917159,
        0.00181011399651,
        0.00368490044746,
        0.00539258837124,
        0.0025864317125,
        -0.00142544425011,
        -0.00093791708189,
        0.00074577978354,
        -0.00493822443862,
        0.00155999842113,
        0.00036769011237,
        -0.00204303139567,
        0.00254572878148,
        0.00601243235865,
        0.00430171295221,
        0.00539258837124,
        0.11211938930981,
    ]
).reshape(13, 13)

cov_colnames = param_names

cov_rownames = param_names


results_gmm2s_robust = ParamsTableTestBunch(
    params_table=params_table,
    params_table_colnames=params_table_colnames,
    params_table_rownames=params_table_rownames,
    cov=cov,
    cov_colnames=cov_colnames,
    cov_rownames=cov_rownames,
    **est,
)
