<!-- markdown-link-check-disable -->

# Archive

These links sometimes fail link validation. They should still work, but may not. They are kept here because they are excellent resources.

<br />
<br />

## Libraries
_Language specific game engine development libraries / frameworks / code._

### C
- C: Fonts
    - 🎉 [msdf-c](https://github.com/solenum/msdf-c) - Multi-channel signed distance field generator.

### C++
- C++: Game Engine w/Editor
    - 🎉 [SGEEngine](https://github.com/ongamex/SGEEngine) - Game engine with an editor usable as a sandbox.

### Zig
- 🌎 [Zig Learn](https://ziglearn.org/) - Excellent Zig language resource.

<br />
<br />

## Specialty Topics
_Exploring specialty application / game engine / game development topics and features._

### Animation Info
- 📚 [Skeletons and Inverse Kinematics](https://venturebeat.com/2017/08/09/character-animation-skeletons-and-inverse-kinematics/) - Principles for using skeletons with IK for animation.

### Geometry
- Algorithms
    - 📚 [Practical Geometry Algorithms](http://geomalgorithms.com/index.html) - Geometries, convex hulls, polyline simplification and more.

### Lighting / Shadows
- Lighting 2D
    - 📚 [Lighting a 2D Game](http://www.wholehog-games.com/devblog/2013/06/07/lighting-in-a-2d-game/) - Proper 2D lighting with diffuse, self illumination and normal maps.
- Volumetric
    - 📚 [Volumetric Light Approximation](http://bkcore.com/blog/3d/webgl-three-js-volumetric-light-godrays.html) - Volumetric light approximation (godrays) with Three.js.

### Physics
- Platformer
    - 📚 [Ledge Grabbing](https://gamedevelopment.tutsplus.com/tutorials/basic-2d-platformer-physics-part-4--cms-26046) - Tutorial on ledge grabbing in 2D platformer physics.
- Soft Body
    - 📚 [Box2D Soft Body Blobs](https://www.emanueleferonato.com/2012/09/21/step-by-step-creation-of-a-box2d-soft-body-blob/) - Step by step creation of a Box2D soft body blob.

### Shaders
- Displacement
    - 📚 [Basic GLSL Displacement Shader](http://benchung.com/basic-glsl-displacement-shader-three-js/) - Basic vertex displacement shader using Three.js.
- Noise
    - 🎉 [Direct Computational Noise](https://weber.itn.liu.se/~stegu/jgt2011/supplement.pdf) - GLSL 2D simplex noise function many games use. [[Source](https://github.com/ashima/webgl-noise/)]
- Wireframe
    - 📚 [Easy Wireframe Display](https://web.archive.org/web/20190220052115/http://codeflow.org/entries/2012/aug/02/easy-wireframe-display-with-barycentric-coordinates/) - Rendering triangles as wireframe using [Barycentric Coordinates](https://en.wikipedia.org/wiki/Barycentric_coordinate_system).

### Tiling
- 📚 [Blob Tileset](http://www.cr31.co.uk/stagecast/wang/blob.html) - Tutorial on 2D edge and corner matched tilesets.


<br />
<br />

## Tools / Software
_Software to help with game engine / video game development._

### Audio Tools
- Music
    - 🆓 [PixiTracker](https://warmplace.ru/soft/pixitracker/) - Quickly create musical sketches, chiptunes and sound experiments.
    - 🆓 [SunVox](https://warmplace.ru/soft/sunvox/) - Powerful [modular synthesizer](https://en.wikipedia.org/wiki/Modular_synthesizer) with pattern-based sequencer ([tracker](https://en.wikipedia.org/wiki/Music_tracker)).

<br />
<br />

## Video Game Assets
_Resources to help bring video games and game engines alive._

### Audio Assets
- Music
    - 💸 [Royalty Free Music Clips](https://www.royaltyfreemusicclips.com/pir/free_music_loops.shtml) - Huge collection of free and paid royalty free music tracks.

### Model Assets
- 🆓 [3D Models CC0](https://www.3dmodelscc0.com) - Public domain 3D models.

<br />
<br />
