
## Contribution Guide

Thanks for your interest in contributing. This list aims to provide excellent resources for Game Engine Development. It has been curated to provide the best examples available for each category and does not aim to be an exhaustive list of links to all available areas of Game Engine Development. With that said, here are a few basic guidelines for contributing:

- The link you are adding should not already be present in the list.
- The link you are adding should not take up more than a single line (i.e. should fit in the regular Github readme column).
- The link you are adding should include the proper [license emoji](https://github.com/stevinz/awesome-game-engine-dev#legend). The link and description should not include any additional emoji.
- The link's primary target should be a [GitHub](https://github.com/) repository (if applicable).
- The link you are adding should be relevant to Game Engine Development. New categories are possible if they improve the scope of the list as it pertains to Game Engine Development.
- The link you are adding should be currently maintained and not deprecated. Exceptions may be allowed for resources that are well known and have large community support.
- The links that are listed for each category are in alphabetical order, new links should be inserted within this order.
- The link you are adding may not be accepted if:
    - The owner of this repo feels the link does not adhere to these rules.
    - The link is not a good fit for a list about Game Engine Development.

## Existing Links

If you are the maintainer of a project or website already in this list and would like the link removed, or the description changed, feel free to submit a pull request to do so.