<!--lint ignore no-dead-urls-->

<div align="center">
    <a href="https://github.com/stevinz/awesome-game-engine-dev"><img width="1100" src="aged-title.png" alt="Awesome Game Engine Dev Logo"/></a>
</div>

# Awesome Game Engine Development [![Awesome](https://awesome.re/badge-flat.svg)](https://github.com/sindresorhus/awesome#readme)

Curated list of resources related to the development of game engines (tools that improve and speed up game creation). Specifically toward the development of high-level, fully featured game engines (e.g., Godot / Unity).

This includes things typically not found in low-level game engines, app / game frameworks, or graphics libraries (e.g., MonoGame / SDL). Most importantly of which would be a visual scene editor, but also capabilities like scripting, physics, asset management, special effects, monetization, etc.

<br />

## Contents

- [Game Engines](#game-engines)
    - [Awesome Collections](#awesome-collections)
    - [Popular](#popular)
    - [AAA](#aaa)
    - [Commercial](#commercial)
    - [Specialty](#specialty)
- [Learning](#learning)
    - [Computer Graphics](#computer-graphics)
    - [Engine Development](#engine-development)
    - [Game Development](#game-development)
    - [Graphical User Interface](#graphical-user-interface)
    - [Programming](#programming)
- [Libraries](#libraries)
    - [BASIC](#basic)
    - [C](#c)
    - [C++](#c-1)
    - [C#](#c-2)
    - [Dart](#dart)
    - [F#](#f)
    - [Go](#go)
    - [Haxe](#haxe)
    - [Lua](#lua)
    - [Java](#java)
    - [JavaScript](#javascript)
    - [Kotlin](#kotlin)
    - [Pascal](#pascal)
    - [Python](#python)
    - [Ruby](#ruby)
    - [Rust](#rust)
    - [Zig](#zig)
- [Open Source Games](#open-source-games)
    - [Awesome Collections](#awesome-collections-1)
    - [C](#c-3)
    - [C++](#c-4)
    - [Java](#java-1)
- [Specialty Topics](#specialty-topics)
    - [AI / Pathfinding](#ai--pathfinding)
    - [Color Manipulation](#color-manipulation)
    - [Entity Component Systems](#entity-component-systems)
    - [Fluid / Smoke](#fluid--smoke)
    - [Geometry](#geometry)
    - [Hair](#hair)
    - [Lighting / Shadows](#lighting--shadows)
    - [Network](#network)
    - [Particles](#particles)
    - [Physics](#physics)
    - [Rendering](#rendering)
    - [Scripting](#scripting)
    - [Shaders](#shaders)
    - [Signed Distance Fields](#signed-distance-fields)
    - [Tiling](#tiling)
    - [Transparency](#transparency)
- [Tools / Software](#tools--software)
    - [2D Game Dev](#2d-game-dev)
    - [AI Assistants](#ai-assistants)
    - [Animation Software](#animation-software)
    - [Audio Tools](#audio-tools)
    - [Color / Palettes](#color--palettes)
    - [Generative Art](#generative-art)
    - [Image Editors](#image-editors)
    - [Level Editors](#level-editors)
    - [Materials / Textures](#materials--textures)
    - [Modeling Tools](#modeling-tools)
    - [Particle Tools](#particle-tools)
    - [Pixel Art](#pixel-art)
    - [Vector Editors](#vector-editors)
    - [Voxel](#voxel)
- [Video Game Assets](#video-game-assets)
    - [Audio Assets](#audio-assets)
    - [Graphic Assets](#graphic-assets)
    - [Material Assets](#material-assets)
    - [Model Assets](#model-assets)
- [Archive](#archive)
- [Legend](#legend)

<br />
<br />

## Game Engines
_Production ready game engines to tinker with, explore, learn and inspire._

### Awesome Collections
- 📚 [CoolEngines](https://github.com/JohnClarking/CoolEngines) - List of open source graphic & game engines.
- 📚 [Wikipedia: List of Game Engines](https://en.wikipedia.org/wiki/List_of_game_engines) - Game engines along with their platforms and licenses.

### Popular
- 🎉 [Godot](https://github.com/godotengine/godot#readme) 🔥 - Feature-packed, open source engine. Excellent! [[Awesome](https://github.com/godotengine/awesome-godot#readme) | [Website](https://godotengine.org)]
- 💸 [Unity](https://unity.com) - Biggest name in game engines, industry standard. [[Awesome](https://github.com/RyanNielson/awesome-unity)]
- 💸 [Unreal Engine](https://www.unrealengine.com) - AAA quality, insane feature set, photoreal visuals. [[Awesome](https://github.com/insthync/awesome-ue4#readme)]

### AAA
- 🎉 [Amazon Lumberyard](https://github.com/aws/lumberyard) - AAA engine integrated with AWS and Twitch. Forked from _CRYENGINE_.
- 💰 [C4 Engine](http://c4engine.com) - Modern console engine.
- 💸 [CRYENGINE](https://www.cryengine.com) - Powerful real-time game development platform by _Crytek_.
- 🆓 [Evergine](https://evergine.com) - High-quality 3D and 2D solutions. Formerly _Wave Engine_. [[Samples](https://github.com/EvergineTeam/Samples)]
- 💸 [Flax Engine](https://github.com/FlaxEngine/FlaxEngine) - Modern 3D game engine written in C++ and C#.
- 💰 [Gamebryo](http://www.gamebryo.com) - Complete toolset, flexible workflow, rapid prototyping.
- 🎉 [O3DE](https://github.com/o3de/o3de/) - Multi-platform AAA engine. Cinema-quality 3D. Successor to _Lumberyard_.
- 💸 [Unigine](https://unigine.com) - Real-time 3D engine. Photorealistic graphics, large virtual worlds, C++ and C# API.

### Commercial
- 💰 [AppGameKit](https://www.appgamekit.com/studio) - Easy and quick game making by _TheGameCreators_.
- 💸 [Buildbox](https://www.buildbox.com) - Create 3D & 2D video games without coding.
- 💸 [Construct](https://www.construct.net/) - Drag and drop game builder. [[Awesome](https://github.com/ConstructCommunity/awesome-construct#readme)]
- 💰 [Corgi Engine](https://corgi-engine.moremountains.com/) - 2D/2.5D platformer engine built on top of _Unity_.
- 🎉 [Defold](https://github.com/defold/defold) - Open sourced game engine by _King_. [[Website](https://defold.com)]
- 💸 [Felgo](https://felgo.com/games) - Build cross-platform 2D games in days, built with _Qt_.
- 💰 [GameGuru](https://www.game-guru.com/) - Game builder, 3D, no coding required by _TheGameCreators_.
- 💸 [GameMaker Studio](https://www.yoyogames.com/en/gamemaker) - Popular 2D game development environment by _YoYo Games_.
- 💸 [GameSalad](https://gamesalad.com) - Sophisticated visual programming interface.
- 💸 [Luxe](https://luxeengine.com/) - 2D first engine, with a 2D/3D renderer.
- 💸 [MANU](https://manu.co) - Unique animation system helps you create games without coding.
- 💸 [NeoAxis](https://github.com/NeoAxis/NeoAxisEngine) - Versatile real-time platform for making games and apps. [[Website](https://www.neoaxis.com)]
- 💰 [Phaser Editor 2D](https://phasereditor2d.com) - Commercial, web-based editor for _Phaser_. [[GitHub](https://github.com/PhaserEditor2D/PhaserEditor2D-v3)]
- 💸 [PlayCanvas](https://playcanvas.com) - Popular (_Flappy Bird_) WebGL game engine. [[Awesome](https://github.com/playcanvas/awesome-playcanvas#readme) | [GitHub](https://github.com/playcanvas/engine)]
- 💸 [Roblox](https://www.roblox.com/create) - Create immersive 3D experiences with Lua scripting.
- 💸 [Simulation Starter Kit](https://benmorris.itch.io/plugin-based-scene-editor) - Create interactive 3D apps across a range of platforms.
- 💸 [Stencyl](https://www.stencyl.com/) - Quick and easy game making with visual scripting. [[GitHub](https://github.com/Stencyl/stencyl-engine)]
- 💸 [Titan Engine](https://esenthel.com/) - Cross-platform engine, started in 2000. Formerly _Esenthel Engine_.

### Specialty
- 💰 [3dSen](https://geod.itch.io/3dnes) - Emulator that lets you play _NES_ games in 3D. [[Website](http://www.geodstudio.net)]
- 💸 [DopeFish](https://lemontoast-games.itch.io/dopefish) - _Doom_ / _Heretic_ map loading system for _GameMaker_.
- 🎉 [GB Studio](https://github.com/chrismaltby/gb-studio) - Retro adventure game creator for _Game Boy_.
- 🔒 [HARFANG 3D](https://github.com/harfang3d/harfang3d) - 3D visualization library for industry professionals, usable in C++, Python, Lua, Go.
- 💰 [Platforming Engine](https://robvansaaze.itch.io/platforming-engine) - Everything you need to create your own platformer in _GameMaker_.
- 🎉 [Ren'Py](https://github.com/renpy/renpy) - Visual novel engine. [[Website](https://www.renpy.org/)]
- 💰 [RPG in a Box](https://www.rpginabox.com) - Turn your stories and ideas into games, built with _Godot_.
- 💰 [RPG Maker](https://www.rpgmakerweb.com) - Create an original role-playing game without any specialized knowledge.
- 🔒 [Twine](https://github.com/klembot/twinejs) - Tool for telling interactive, nonlinear stories.
- 💸 [Unbound](https://www.unbound.io/) - SDF‑powered game engine. Intuitively sculpt & script 3D games.

<br />
<br />

## Learning
_Info on topics necessary for designing and developing game engines._

### Computer Graphics
- Awesome Collections
    - 📚 [Awesome Demoscene](https://github.com/psykon/awesome-demoscene) - Underground computer art culture exploring computer graphics and sound.
    - 📚 [Awesome Graphics Libraries](https://github.com/jslee02/awesome-graphics-libraries#readme) - Curated list of 3D graphics libraries and resources.
- Blog Articles
    - 📚 [Comparison of Modern Graphics APIs](https://alain.xyz/blog/comparison-of-modern-graphics-apis) - Modern graphics APIs vs older APIs.
    - 📚 [GPU Performance for Game Artists](http://www.fragmentbuffer.com/gpu-performance-for-game-artists/) - Common art-related performance issues.
- Books
    - 📚 [GPU Gems](https://developer.nvidia.com/gpugems/gpugems/contributors) - Programming techniques, tips, and tricks for real-time graphics.
    - 📚 [GPU Gems 2](https://developer.nvidia.com/gpugems/gpugems2/copyright) - Programming techniques for high-performance graphics.
    - 📚 [GPU Gems 3](https://developer.nvidia.com/gpugems/gpugems3/contributors) - Collection of state-of-the-art GPU programming examples hosted by _NVIDIA_.
    - 📚 [Interactive Computer Graphics](https://www.cs.unm.edu/~angel/) - Top down approach to computer graphics.
    - 📚 [Physically-Based Rendering](https://www.pbrt.org) - From the Academy Award winning authority on PBR.
- Education Portals
    - 📚 [Game Art Tricks](http://simonschreibt.de/game-art-tricks/) - Articles exploring different graphics techniques.
    - 📚 [Lighthouse3d.com](http://www.lighthouse3d.com/tutorials/) - Collection of tutorials on OpenGL, GLSL and other graphics topics.
    - 📚 [Paper Bug](https://www.jeremyong.com/paperbug/) - Indexed compendium of graphics programming papers.
    - 📚 [Scratchapixel](https://www.scratchapixel.com) - In depth coverage of computer graphics topics.
- Graphics API: DirectX
    - 🌎 [DirectX](https://docs.microsoft.com/en-us/windows/win32/directx) - _Microsoft_ API used to create 2D/3D games and apps. [[Blog](https://devblogs.microsoft.com/directx/) | [Samples](https://github.com/microsoft/DirectX-Graphics-Samples)]
    - 📚 [DirectXTutorial.com](http://www.directxtutorial.com/default.aspx) - Older resource with lots of tutorials on DirectX versions 9 & 11.
- Graphics API: Glide
    - 📚 [Glide](https://en.wikipedia.org/wiki/Glide_(API)) - Developed by _3dfx Interactive_ for their _Voodoo Graphics_ in the 1990's.
    - 🌎 [Glide Open Source Project](https://glide.sourceforge.net/) - Glide open source project.
- Graphics API: Mantle
    - 📚 [Mantle](https://en.wikipedia.org/wiki/Mantle_(API)) - Developed by _AMD_ as an alternative to Direct3D and OpenGL.
- Graphics API: Metal
    - 🌎 [Metal](https://developer.apple.com/metal/) - API for developing 3D apps on _Apple_ platforms. [[Samples](https://developer.apple.com/metal/sample-code/)]
    - 📚 [Metal Tutorial](https://www.raywenderlich.com/7475-metal-tutorial-getting-started) - Learn how to get started with Metal at _RayWenderlich.com_.
- Graphics API: OpenGL
    - 📚 [LearnOpenGL](https://learnopengl.com) 🔥 - Incredible! In depth tutorials for modern graphics programming.
    - 🌎 [Mesa 3D](https://www.mesa3d.org/) - Open source implementations of OpenGL.
    - 🌎 [OpenGL](https://www.opengl.org/) - The industry's foundation for high-performance graphics.
    - 📚 [OpenGL Tutorial](https://www.opengl-tutorial.org) - Collection of OpenGL tutorials with source code examples.
- Graphics API: Vulkan
    - 🌎 [Vulkan](https://www.vulkan.org) - Modern cross-platform graphics API. [[Samples](https://github.com/khronosGroup/Vulkan-samples)]
    - 📚 [Vulkan Tutorial](https://github.com/Overv/VulkanTutorial) - Teaches the basics of using Vulkan graphics and compute API.
- Graphics API: WebGL
    - 🌎 [WebGL](https://www.khronos.org/webgl/) - Open web standard 3D graphics API. [[GitHub](https://github.com/KhronosGroup/WebGL)]
    - 📚 [WebGL Fundamentals](https://webglfundamentals.org) 🔥 - Full understanding of what WebGL really is and how it works.
    - 📚 [WebGL 2 Fundamentals](https://webgl2fundamentals.org) - Updated to use the WebGL2 standard.
    - 📚 [WebGL 2 Samples](https://github.com/WebGLSamples/WebGL2Samples) - Short and easy to understand samples demonstrating WebGL 2 features.
    - 📚 [WebGL Tutorial](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API/Tutorial) - How to use the canvas element to draw WebGL graphics.
- Graphics API: WebGPU
    - 🌎 [Dawn](https://dawn.googlesource.com/dawn) - Open source, cross-platform implementation of the WebGPU standard, by _Google_.
    - 🌎 [WebGPU](https://github.com/gpuweb/gpuweb/wiki/Implementation-Status) - Next generation web 3D graphics API. [[GitHub](https://github.com/gpuweb/gpuweb)]
    - 🌎 [WebGPU Demos](https://webkit.org/demos/webgpu/) - Collection of simple WebGPU examples by _Apple_.
- Pipeline: GPGPU
    - 🌎 [CUDA](https://developer.nvidia.com/cuda-zone) - Developed by _NVIDIA_ for parallel computing and programming.
    - 📚 [DirectCompute](https://en.wikipedia.org/wiki/DirectCompute) - Developed by _Microsoft_ for using compute shaders with DirectX 10 & 11.
    - 🌎 [OpenCL](https://www.khronos.org/opencl/) - For writing programs that execute across CPUs, GPUs, and other processors.
- Platform: XNA
    - 📚 [RB Whitaker's Wiki](http://rbwhitaker.wikidot.com/) - Tutorials on C#, MonoGame, XNA, and more.
    - 📚 [Riemer's MonoGame Tutorials](https://github.com/SimonDarksideJ/XNAGameStudio/wiki/RiemersArchiveOverview) - Everything you need to start programming with MonoGame.
    - 📚 [XNA Game Studio Archive](https://github.com/SimonDarksideJ/XNAGameStudio) 🔥 - Required visit for [MonoGame](https://en.wikipedia.org/wiki/MonoGame) / [FNA](https://fna-xna.github.io/) / [XNA](https://en.wikipedia.org/wiki/Microsoft_XNA) developers.

### Engine Development
- Blog Articles
    - 📚 [How to Become a Game Engine Developer](https://www.haroldserrano.com/blog/how-to-become-a-game-engine-developer) - Starting point on game engine development.
- Books
    - 📚 [Game Engine Architecture](https://www.gameenginebook.com) - Theory and practice of game engine development.
- Commercial Studios Research Divisions
    - 🌎 [Activision Research](https://research.activision.com/) - Blog posts, articles and presentations from research within _Activision_.
    - 🌎 [EA Technology](https://www.ea.com/technology/research) - Research on game tech including info on the _Frostbite_ engine.
    - 🌎 [tri-Ace Research](https://research.tri-ace.com/) - Publications from the Research and Development Department at _tri-Ace Inc_.
    - 🌎 [Ubisoft Technology](https://www.ubisoft.com/en-us/company/how-we-make-games/technology) - Learn about in-house tech including the _Anvil_ and _Snowdrop_ engines.
- Education Portals
    - 📚 [3D Game Engine Programming](https://www.3dgep.com) - Articles on graphics, physics, AI, I/O and more.

### Game Development
- Awesome Collections
    - 📚 [Awesome Gamedev](https://github.com/Calinou/awesome-gamedev#readme) - Collection of free resources for making games.
    - 📚 [GameDev-Resources](https://github.com/Kavex/GameDev-Resources) - Wonderful list of game development resources.
    - 📚 [Magictools](https://github.com/ellisonleao/magictools#readme) - List of game development resources to make magic happen.
    - 🌎 [Web Game Dev](https://www.webgamedev.com) - Resources on techniques and tools around JavaScript game development.
- Books
    - 📚 [Art of Game Design](https://www.amazon.com/Art-Game-Design-Book-Lenses/dp/0123694965) - Teaches game design in an accessible manner.
    - 📚 [Game Programming Patterns](https://gameprogrammingpatterns.com) - Patterns found in games that make code easier to understand.
- Developer Portals
    - 🌎 [Game Developer](https://www.gamedeveloper.com) - Industry blogs, events, jobs, updates and more. Formerly _Gamasutra_.
    - 🌎 [GameDev.net](https://www.gamedev.net/) - Game dev forums, tutorials, blogs, projects, portfolios, and news.
    - 🌎 [GameFromScratch.com](https://gamefromscratch.com) - Game dev news, tutorials and much more.
    - 🌎 [itch.io](https://itch.io) - Game dev resources and platform to showcase / promote / buy & sell games.
- Education Portals
    - 🌎 [Lazy Foo' Tutorials](https://lazyfoo.net/tutorials/SDL/) - Beginning game programming with SDL.

### Graphical User Interface
- 📚 [List of Widget Toolkits](https://en.wikipedia.org/wiki/List_of_widget_toolkits) - Gui frameworks across all platforms and languages.

### Programming
- 📚 [Big-O Cheat Sheet](https://www.bigocheatsheet.com) - Big-O complexities of algorithms used in computer science.
- 🌎 [Deadlock Empire](https://deadlockempire.github.io/#menu) - Interactive tutorial to master threads and concurrency.
- 📚 [Every Programmer Should Know](https://github.com/mtdvio/every-programmer-should-know) - Technical things every developer should know.
- 📚 [Games of Coding](https://github.com/michelpereira/awesome-games-of-coding#readme) - Games that teach you a programming language.
- 🌎 [Geeks for Geeks](https://www.geeksforgeeks.org) - Tutorials, articles, courses, coding competitions, jobs and more.
- 📚 [Learn to Program](https://github.com/karlhorky/learn-to-program#readme) - Educational resources to learn to program.
- 📚 [TIOBE Index](https://www.tiobe.com/tiobe-index/) - Popularity of programming languages, updated monthly.

<br />
<br />

## Libraries
_Language specific game engine development libraries / frameworks / code._

### BASIC
- 📚 [Awesome Basic](https://github.com/JohnBlood/awesome-basic) - List of awesome BASIC dialects, IDEs, and tutorials.
- BASIC: App Framework
    - 💰 [Basic for Qt](https://www.q7basic.org/index.html) - BASIC language and environment built with _Qt_. Formerly _Q7Basic_.
    - 🎉 [QB64](https://github.com/QB64Team/qb64) - Modern BASIC+OpenGL language, retains _QBasic_ / _QB4.5_ compatibility.
    - 📚 [Visual Basic](https://docs.microsoft.com/en-us/dotnet/visual-basic/) - Object-oriented language for Windows by _Microsoft_.
- BASIC: Game Framework
    - 🎉 [Dark Basic](https://github.com/TheGameCreators/Dark-Basic-Pro) - BASIC programming language for creating apps and games. [[Website](https://www.thegamecreators.com/product/dark-basic-pro-open-source)]

### C
- 📚 [Learn C Programming](https://www.programiz.com/c-programming) - Excellent tutorials that will guide you to learn C programming.
- C: App Framework
    - 🎉 [Allegro](https://github.com/liballeg/allegro5) - Cross-platform library aimed at video game and multimedia apps.
    - 🎉 [glfw](https://github.com/glfw/glfw) - Cross-platform API for windowing, graphics contexts, input and events.
    - 🎉 [MiniFB](https://github.com/emoon/minifb) - Creates a cross-platform frame buffer for drawing pixels.
    - 🎉 [SDL](https://github.com/libsdl-org/SDL) 🔥 - Low-level access to audio, keyboard, mouse, joystick, and graphics hardware.
    - 🎉 [Sokol](https://github.com/floooh/sokol) 🔥 - Single-file libraries for graphics, windowing, file handling, audio and more.
- C: Audio
    - ⭐ [Miniaudio](https://github.com/mackron/miniaudio) - Single-file audio playback and capture library.
    - 🎉 [SDL_mixer](https://github.com/libsdl-org/SDL_mixer) - Audio mixer that supports various file formats for SDL.
    - 🎉 [SoLoud](https://github.com/jarikomppa/soloud) 🔥 - Free, easy, portable audio engine for games.
- C: Cross-Platform
    - 🎉 [Cosmopolitan](https://github.com/jart/cosmopolitan) - Build-once run-anywhere C library.
- C: Entity Component System
    - 🎉 [Flecs](https://github.com/SanderMertens/flecs) - Fast and lightweight entity component system in C99.
- C: File Formats
    - 🎉 [Assimp](https://github.com/assimp/assimp) - Open Asset Importer Library. Loads 40+ 3D file formats.
    - 🎉 [cgltf](https://github.com/jkuhlmann/cgltf) - Single-file glTF 2.0 loader and writer in C99.
    - ⭐ [dr_libs](https://github.com/mackron/dr_libs) - Single-file audio decoding libraries.
    - 🎉 [Libspng](https://github.com/randy408/libspng) - Simple, modern libpng alternative.
    - 🎉 [Miniz](https://github.com/richgel999/miniz) - Single-file drop-in replacement for zlib's most used APIs (_libpng_ and _libzip_).
    - 🎉 [OBJ GL Loader v2](https://github.com/karolek471/objgl) - Quite fast wavefront OBJ loader for OpenGL.
    - 🎉 [PL_MPEG](https://github.com/phoboslab/pl_mpeg) - Single-file library for decoding MPEG1 Video and MP2 Audio.
    - 🎉 [QOI](https://github.com/phoboslab/qoi) - The “Quite OK Image Format” for fast, lossless image compression.
    - ⭐ [stb_vorbis](https://github.com/nothings/stb/blob/master/stb_vorbis.c) - Ogg Vorbis audio decoder.
- C: File System
    - 🎉 [HexEmbed](https://github.com/codeplea/hexembed) - Small utility to help embed files in C/C++ programs in an easy, cross-platform way.
    - ⭐ [Incbin](https://github.com/graphitemaster/incbin) - Include binary and text files in your C/C++ apps with ease.
    - 🎉 [PhysicsFS](https://github.com/icculus/physfs) - Portable, flexible file I/O abstraction. Provides access to various archives.
    - ⭐ [Where Am I](https://github.com/gpakosz/whereami) - Locates the current path on the local file system.
- C: Fonts
    - 🎉 [Font Stash](https://github.com/memononen/fontstash) - Lightweight library that uses stb_truetype to render fonts to a texture atlas.
    - 🎉 [IconFontCppHeaders](https://github.com/juliettef/IconFontCppHeaders) - C/C++ headers and C# classes for icon fonts.
    - ⭐ [stb_truetype](https://github.com/nothings/stb/blob/master/stb_truetype.h) - Single-header file library that processes TrueType font files.
    - 🎉 [Vertext](https://github.com/kevinmkchin/vertext) - Generates vertices for rendering text, requires stb_truetype.
- C: Game Engine w/Editor
    - ⭐ [AVA](https://github.com/r-lyeh/AVA) - Tiny, minimalistic 3D game engine.
    - 🎉 [TIC-80](https://github.com/nesbox/TIC-80) - Virtual computer for making & sharing tiny games. [[Website](https://tic80.com/)]
- C: Game Framework
    - 🎉 [CGL](https://github.com/Jaysmito101/cgl) - Single-header file, lots of graphics & utility functions.
    - 🎉 [DOME](https://github.com/domeengine/dome) - Melds SDL2 and the Wren scripting language. [[Website](https://domeengine.com/)]
    - 🎉 [Entrypoint](https://github.com/jimon/entrypoint) - Lightweight entry point for games.
    - ⭐ [FWK](https://github.com/r-lyeh/FWK) - 3D game framework.
    - 🎉 [Gunslinger](https://github.com/MrFrenik/gunslinger) - Header-only C99 framework for multimedia apps.
    - 🎉 [RayLib](https://github.com/raysan5/raylib) 🔥 - Simple and easy-to-use library to enjoy 2D/3D videogame programming.
- C: Geometry
    - 🎉 [Blob](https://github.com/BlockoS/blob) - Single-header implementation of a contour tracing algorithm.
    - 🎉 [Marching Squares](https://github.com/prideout/par/blob/master/par_msquares.h) - Convert images into triangles. [[Info](https://prideout.net/marching-squares)]
    - 🎉 [Octasphere](https://github.com/prideout/par/blob/master/par_octasphere.h) - Generates triangle meshes for spheres, boxes, and capsules. [[Info](https://prideout.net/blog/octasphere/)]
    - 🎉 [Par_Shapes](https://github.com/prideout/par/blob/master/par_shapes.h) - Triangle meshes including solids, spheres and more. [[Info](https://prideout.net/shapes)]
    - 🎉 [Par_Streamlines](https://github.com/prideout/par/blob/master/par_streamlines.h) - Triangulating thick lines, béziers, streamlines. [[Demo](https://github.com/prideout/streamlines_demo) | [Info](https://prideout.net/blog/par_streamlines/)]
- C: Graphics - 2D
    - 🎉 [NanoVG](https://github.com/memononen/nanovg) - OpenGL-based 2D vector drawing library for UI and visualizations.
    - 🎉 [Tilengine](https://github.com/megamarc/Tilengine) - 2D graphics with raster effects for retro style game development.
- C: Graphics - 3D
    - 🎉 [Sokol Gfx](https://github.com/floooh/sokol/blob/master/sokol_gfx.h) - Cross-platform, single-file graphics. [[Examples](https://floooh.github.io/sokol-html5/)]
    - 🎉 [Sokol Graphics Painter](https://github.com/edubart/sokol_gp) - 2D graphics painter implemented with _Sokol_.
- C: Gui
    - 🎉 [cImgui](https://github.com/cimgui/cimgui) - Thin C wrapper generated for Dear ImGui.
    - 🎉 [lvgl](https://github.com/lvgl/lvgl) 🔥 - Embedded gui library, many widgets and advanced visual effects.
    - 🎉 [NAppGUI](https://github.com/frang75/nappgui_src) - Professional, well documented SDK to build desktop apps.
    - 🎉 [Native File Dialog](https://github.com/mlabbe/nativefiledialog) - Portably invoke native file open / save dialogs.
    - 🎉 [Nuklear](https://github.com/Immediate-Mode-UI/Nuklear) - Single-header immediate mode cross-platform gui library.
- C: Input
    - 🎉 [libGamepad](https://github.com/mtwilliams/libgamepad) - Cross-platform library for gamepad input.
    - 🎉 [Sokol Gamepad](https://github.com/floooh/sokol/pull/393/commits/26a9da9dafd4adb22a1ace0de0d2569da31ae427) - Branch with addon support for gamepads in _Sokol_.
- C: Layout
    - 🎉 [Clay](https://github.com/nicbarker/clay) - High performance 2D UI layout library.
- C: Libraries
    - ⭐ [Cute Headers](https://github.com/RandyGaul/cute_headers) - Single-file libraries primarily used for games, by [Randy Gaul](https://github.com/RandyGaul).
    - ⭐ [Libs](https://github.com/mattiasgustavsson/libs) - Single-file public domain libraries for C/C++, by [Mattias Gustavsson](https://github.com/mattiasgustavsson).
    - ⭐ [Pico Headers](https://github.com/empyreanx/pico_headers) - Single-file, cross-platform libraries for game development.
    - 📚 [Single-file Libs](https://github.com/nothings/single_file_libs) - Amazing collection of single-file C/C++ libraries compiled from many authors.
    - ⭐ [stb](https://github.com/nothings/stb) 🔥 - Single-file public domain libraries for C/C++, by [Sean Barrett](https://github.com/nothings).
- C: Lighting
    - ⭐ [Light Mapper](https://github.com/ands/lightmapper) - Single-file library for lightmap baking by using your existing OpenGL renderer.
- C: Math
    - 🎉 [Cglm](https://github.com/recp/cglm) - Highly optimized OpenGL math.
    - ⭐ [Handmade Math](https://github.com/HandmadeMath/Handmade-Math) 🔥 - Simple, public domain math library for games and computer graphics.
    - 🎉 [Kazmath](https://github.com/Kazade/kazmath) - Math library targeted at games.
    - 🎉 [Raymath](https://github.com/raysan5/raylib/blob/master/src/raymath.h) - Math library included in the _RayLib_ game framework.
- C: Network
    - 🎉 [ENet](https://github.com/zpl-c/enet) - Simple, lightweight and reliable UDP networking library.
    - 🎉 [librg](https://github.com/zpl-c/librg) - Middleware between networking / file-streaming libraries and app logic.
    - 🎉 [netcode](https://github.com/mas-bandwidth/netcode) - Secure client/server protocol for multiplayer games built on top of UDP.
- C: Physics
    - 🎉 [Chipmunk](https://github.com/slembcke/Chipmunk2D) - Fast, lightweight 2D game physics library. [[Docs](https://chipmunk-physics.net/documentation.php)]
- C: Scripting
    - 🎉 [Duktape](https://github.com/svaarala/duktape) - Embeddable JavaScript engine with a focus on portability and compact footprint.
    - 🎉 [JerryScript](https://github.com/jerryscript-project/jerryscript) - Ultra-lightweight JavaScript engine for the Internet of Things.
    - 🎉 [Lua](https://github.com/lua/lua) - Powerful, efficient, lightweight, embeddable scripting language.
    - 🎉 [QuickJS](https://github.com/bellard/quickjs) - Small and embeddable JavaScript engine.

### C++
- 📚 [Awesome C++](https://github.com/fffaraz/awesome-cpp#readme) - List of awesome C++ frameworks, libraries, and resources.
- 📚 [Awesome C++ Game Dev](https://github.com/Caerind/AwesomeCppGameDev#readme) - List of awesome C++ things for Game Development.
- 📚 [Awesome Hpp](https://github.com/p-ranav/awesome-hpp) - List of awesome header-only C++ libraries.
- 🌎 [C++ Papyrus](https://caiorss.github.io/C-Cpp-Notes/index.html) - Basic to advanced topics with modern C++ examples.
- 🌎 [cppreference.com](https://en.cppreference.com/w/cpp) - Online reference for C, C++, and the STL.
- 📚 [Learn C++](https://www.learncpp.com) 🔥 - Walks you through all the steps to write, compile, and debug C++.
- 📚 [Modern Cpp Features](https://github.com/AnthonyCalandra/modern-cpp-features) - Cheatsheet of modern C++ language and library features.
- C++: App Framework
    - 🎉 [Cinder](https://github.com/cinder/Cinder) - App / graphics library for macOS, Windows, Linux, iOS. [[Website](https://libcinder.org)]
    - 🎉 [Cross Window](https://github.com/alaingalvan/CrossWindow) - Platform library for managing windows and other OS tasks.
    - 🎉 [SFML](https://github.com/SFML/SFML) 🔥 - Cross-platform access to windowing, graphics, audio and networking.
- C++: Animation
    - 🎉 [Ozz-Animation](https://github.com/guillaumeblanc/ozz-animation) - Skeletal animation library and toolset.
    - 🎉 [Tweeny](https://github.com/mobius3/tweeny) - Inbetweening library for complex animations for games / apps.
- C++: Audio
    - 🎉 [Amplitude Audio SDK](https://github.com/SparkyStudios/AmplitudeAudioSDK) - Cross-platform audio engine designed for the needs of games.
    - 💰 [irrKlang](https://www.ambiera.com/irrklang/) - High level 2D/3D sound engine and audio library.
    - 💰 [Juce](https://github.com/juce-framework/JUCE) - The leading framework for multi-platform audio apps.
    - 🔒 [OpenAL Soft](https://github.com/kcat/openal-soft) - Software implementation of the _OpenAL_ 3D audio API.
    - 🎉 [PortAudio](https://github.com/PortAudio/portaudio) - Cross-platform audio library.
    - 🎉 [Steam Audio](https://github.com/ValveSoftware/steam-audio) - Cross-platform spatial audio SDK for games and VR.
- C++: Cross-Platform
    - 🌎 [emscripten](https://github.com/emscripten-core/emscripten) - The C/C++ to JavaScript (as WebAssembly) compiler. [[Website](https://emscripten.org/)]
- C++: Entity Component System
    - 🎉 [EntityX](https://github.com/alecthomas/entityx) - Fast, type-safe C++ entity component system.
    - 🎉 [Entt](https://github.com/skypjack/entt) - Gaming meets modern C++, a fast and reliable entity component system.
- C++: Fonts
    - 🎉 [HarfBuzz](https://github.com/harfbuzz/harfbuzz) - Text shaping library. Formatted and positioned glyph output.
    - 🎉 [msdfgen](https://github.com/Chlumsky/msdfgen) - Multi-channel signed distance field generator.
    - 💰 [Slug](http://sluglibrary.com) - High-quality, resolution-independent text and vector graphics for 3D apps.
- C++: File Formats
    - ⭐ [Jpeg-Compressor](https://github.com/richgel999/jpeg-compressor) - Single-file library that writes baseline JPEG compressed images.
    - 🎉 [TinyDNG](https://github.com/syoyo/tinydng) - Header-only DNG / TIFF loader and writer.
    - 🎉 [TinyEXR](https://github.com/syoyo/tinyexr) - Tiny OpenEXR image loader / saver library.
    - 🎉 [TinyGLTF](https://github.com/syoyo/tinygltf) - Header-only C++11 tiny glTF 2.0 library.
    - 🎉 [TinyOBJLoader](https://github.com/tinyobjloader/tinyobjloader) - Tiny but powerful single-file wavefront obj loader.
- C++: File System
    - 🎉 [Imgui-Filebrowser](https://github.com/AirGuanZ/imgui-filebrowser) - Header-only file browser implementation for _Dear ImGui_ in C++17.
- C++: Game Engine w/Editor
    - 🎉 [AnKi 3D Engine](https://github.com/godlikepanos/anki-3d-engine) - Vulkan backend, modern renderer, scripting, physics and more.
    - 🔒 [Crown Engine](https://github.com/crownengine/crown) - Data-driven 3D and 2D game engine.
    - 🎉 [Crystal Engine](https://github.com/neelmewada/CrystalEngine) - Vulkan backend with PBR and styled GUI (_CrystalWidgets_).
    - 🎉 [Drop Creator](https://github.com/scidian/drop) - No code, 2.5D game engine built with _Qt_, OpenGL and _Chipmunk Physics_.
    - 🔒 [Enigma](https://github.com/enigma-dev/enigma-dev) - GameMaker compatible 2D engine.
    - 🎉 [Esoterica Engine](https://github.com/BobbyAnguelov/Esoterica) - High-performance game engine with editor and AAA quality animation graph.
    - 🎉 [Ethereal Engine](https://github.com/ir-engine/etherealengine-archive) - Cross-platform game engine and editor.
    - 🎉 [ezEngine](https://github.com/ezEngine/ezEngine) - Game engine in active development.
    - 🎉 [FIFE](https://github.com/fifengine/fifengine) - Multi-platform isometric game engine.
    - 🎉 [Irrlicht](https://sourceforge.net/projects/irrlicht/) - Cross-platform 3D engine worked on for nearly 2 decades. [[Website](https://irrlicht.sourceforge.io/)]
    - 🎉 [Limon Engine](https://github.com/enginmanap/limonEngine) - 3D FPS game engine with full dynamic lighting and shadows.
    - 🎉 [Lina Engine](https://github.com/inanevin/LinaEngine) - Modular game engine, aimed to develop 3D desktop games.
    - 🎉 [Lumos](https://github.com/jmorton06/Lumos) - Cross-platform 2D/3D game engine, supports both OpenGL and Vulkan.
    - 🎉 [Lumix Engine](https://github.com/nem0/LumixEngine) - A 3D game engine with _Dear ImGui_ based editor.
    - 🎉 [MxEngine](https://github.com/asc-community/MxEngine) - Modern-C++ general-purpose 3D game engine.
    - 🔒 [neoGFX](https://github.com/i42output/neogfx) - Cross-platform app and game engine.
    - 🎉 [ÖbEngine](https://github.com/ObEngine/ObEngine) - 2D engine with Lua scripting built with _SFML_.
    - 🎉 [Overload](https://github.com/adriengivry/Overload) - Well documented 3D game engine inspired by industry standards.
    - 🎉 [Razix Engine](https://github.com/Pikachuxxxx/Razix) - High-performance research engine for production pipeline.
    - 🎉 [Rootex](https://github.com/sdslabs/rootex) - Advanced C++ 3D game engine powering an in-production game.
    - 🎉 [Skylicht](https://github.com/skylicht-lab/skylicht-engine) - Upgraded features including audio, physics and particles. Built on _Irrlicht_.
    - 🎉 [Spartan Engine](https://github.com/PanosK92/SpartanEngine) - Emphasis on quality and performance.
    - 🎉 [Torque 3D](https://github.com/GarageGames/Torque3D) - High-performance 3D engine built on _The Forge_.
    - 🔒 [UPBGE](https://github.com/UPBGE/upbge) - Blender game engine, originally forked from _Blender_.
- C++: Game Framework
    - 🎉 [Acid](https://github.com/EQMG/Acid) - Modern C++17 and structured to be fast, simple, and modular.
    - 🎉 [blah](https://github.com/NoelFB/blah) - Small 2D game framework.
    - 🎉 [Cocos2d-x](https://github.com/cocos2d/cocos2d-x) - Widely used in indie game dev community.
    - 🎉 [Cute Framework](https://github.com/RandyGaul/cute_framework) - Simple and consise framework for making 2D games.
    - 🔒 [Fireworks Engine](https://github.com/Pikachuxxxx/Fireworks-Engine) - Lightweight OpenGL framework for quick prototyping.
    - 🎉 [Halley](https://github.com/amzeratul/halley) - Modern C++17. Used for _Wargroove_, a strategy game on desktop and consoles.
    - 🎉 [is::Engine](https://github.com/Is-Daouda/is-Engine) - 2D framework built on _SDL2_ and _SFML_.
    - 🎉 [JNGL](https://github.com/jhasse/jngl) - 2D framework. Develop anywhere, deploy everywhere.
    - 🔒 [KlayGE](https://github.com/gongminmin/KlayGE) - Cross-platform game framework with plugin-based architecture.
    - 🎉 [Koala Engine](https://github.com/phisko/kengine) - Framework with an ECS architecture, aka _Kengine_.
    - 🎉 [Lumino](https://github.com/LuminoEngine/Lumino) - Framework for building real-time graphics apps.
    - 🎉 [Nazara Engine](https://github.com/NazaraEngine/NazaraEngine) - Custom shaders, ECS, 2D/3D, networking and more.
    - 🎉 [nCine](https://github.com/nCine/nCine) - Cross-platform 2D game framework.
    - 🎉 [Octave](https://github.com/mholtkamp/octave) - 3D game engine for GameCube, Wii, 3DS, and more.
    - 🎉 [ORX](https://github.com/orx/orx) - 2.5D data-driven game development framework.
    - 🎉 [Oryol](https://github.com/floooh/oryol) - Small, 3D, portable and extensible coding framework.
    - ⭐ [Ouzel](https://github.com/elnormous/ouzel) - Public domain, targeted for development of 2D games.
    - 🎉 [Polycode](https://github.com/ivansafrin/Polycode) - Cross-platform engine for creative code.
    - 🎉 [Solar2D](https://github.com/coronalabs/corona) - Focus on ease of iterations and usage. Formerly _Corona_.
    - 🎉 [Supernova](https://github.com/supernovaengine/supernova) - Cross-platform for 2D/3D projects.
    - 🎉 [Thunder](https://github.com/thunder-engine/thunder) - Cross-platform 2D/3D with module architecture.
    - 🎉 [Two](https://github.com/hugoam/two) - Toolkit for rapid development of live graphical apps and games.
    - 🎉 [Urho3D](https://github.com/urho3d/Urho3D) - Cross-platform 2D/3D game framework.
    - 💸 [Valve Source SDK](https://github.com/ValveSoftware/source-sdk-2013) - The 2013 edition of the Source SDK by [Valve Software](https://www.valvesoftware.com/). [[Info](https://en.wikipedia.org/wiki/Source_(game_engine)) | [Wiki](https://developer.valvesoftware.com/wiki/Source_SDK_2013)]
- C++: Geometry
    - 🎉 [CinoLib](https://github.com/mlivesu/cinolib) - Header-only library for processing polygonal and polyhedral meshes.
    - 🎉 [Delabella](https://github.com/msokalski/delabella) - Super stable 2D delaunay triangulation.
    - 🎉 [Delaunator-Cpp](https://github.com/soerendd/delaunator-cpp) - Really fast library for Delaunay triangulation of 2D points.
    - 🔒 [Easy3D](https://github.com/LiangliangNan/Easy3D) - Easy-to-use library for 3D modeling, geometry processing, and rendering.
    - 🎉 [Extrude](https://github.com/stevinz/extrude) - Converts 2D images into 3D extruded meshes.
    - 🔒 [Generator](https://github.com/ilmola/generator) - Procedural geometry generation library for C++11.
    - 🎉 [Geometric Tools](https://www.geometrictools.com/index.html) - Mathematics, geometry, graphics, image analysis and physics in C++14.
    - 🎉 [GeometronLib](https://github.com/LukasBanana/GeometronLib) - Meshes for 3D shapes (cube, sphere, etc.) and ray / geometry intersection.
    - 🔒 [Libigl](https://github.com/libigl/libigl) - Simple geometry processing library.
    - 🎉 [MeshOptimizer](https://github.com/zeux/meshoptimizer) - Mesh optimization library that makes meshes smaller and faster to render.
    - 🎉 [Polygon Mesh Processing Library](https://github.com/pmp-library/pmp-library) - Processing / visualizing polygon surface meshes.
    - 🎉 [PolyPartition](https://github.com/ivanfratric/polypartition) - 2D polygon partitioning and triangulation.
    - ⭐ [RamerDouglasPeucker](https://gist.github.com/TimSC/0813573d77734bcb6f2cd2cf6cc7aa51) - Reduces number of points along a 2D line.
    - 🎉 [Recast & Detour](https://github.com/recastnavigation/recastnavigation) - Navigation-mesh toolset for games.
    - 🎉 [Seam-aware Decimater](https://github.com/songrun/SeamAwareDecimater) - Simplifies mesh while preserving UVs.
    - 🎉 [Spheres](https://github.com/caosdoar/spheres) - Four methods to create a sphere mesh.
    - 🔒 [Trimesh2](https://gfx.cs.princeton.edu/proj/trimesh2/) - Utilities for input, output, and manipulation of 3D triangle meshes.
    - 🎉 [V-HACD](https://github.com/kmammou/v-hacd) - Decomposes a 3D surface into a set of "near" convex parts.
- C++: Graphics - 2D
    - 🎉 [Blend2D](https://github.com/blend2d/blend2d) - High-performance 2D vector graphics engine. [[Website](https://blend2d.com/)]
    - 🎉 [C++ Bitmap Library](https://github.com/ArashPartow/bitmap) - Featured bitmap loading and manipulation library.
    - 🎉 [QNanoPainter](https://github.com/QUItCoding/qnanopainter) - OpenGL accelerated vector drawing library for _Qt_, powered by _NanoVG_.
    - 🎉 [Skia](https://github.com/google/skia) - Complete 2D graphics library used in Chrome by _Google_. [[Website](https://skia.org)]
    - 🎉 [vg-renderer](https://github.com/jdryg/vg-renderer) - 2D vector graphics renderer for _Bgfx_, based on ideas from _NanoVG_.
- C++: Graphics - 3D
    - 🎉 [Bgfx](https://github.com/bkaradzic/bgfx) - Cross-platform, graphics API agnostic, rendering library.
    - 🎉 [Diligent Engine](https://github.com/DiligentGraphics/DiligentEngine) - Modern cross-platform graphics API abstraction library.
    - 🎉 [Ember](https://github.com/strah19/Ember) - Graphics framework using SDL2 and OpenGL.
    - 🎉 [Filament](https://github.com/google/filament) - Mobile-first, real-time physically-based renderer by _Google_.
    - 🎉 [Forge](https://github.com/ConfettiFX/The-Forge) 🔥 - Cross-platform rendering framework supporting all major platforms and consoles.
    - 🎉 [Horde3D](https://github.com/horde3d/Horde3D) - 3D rendering and animation engine.
    - 🎉 [Intermediate Graphics Library (IGL)](https://github.com/facebook/igl) - Cross-platform abstraction layer by _Facebook_.
    - 🎉 [LLGL](https://github.com/LukasBanana/LLGL) - Thin abstraction layer for OpenGL, Direct3D, Vulkan, and Metal.
    - 🎉 [Magnum Engine](https://github.com/mosra/magnum) - Modular C++11 graphics middleware for games and apps.
    - 🎉 [NVRHI](https://github.com/NVIDIA-RTX/NVRHI) - _NVIDIA_ abstraction layer over multiple graphics APIs.
    - 🎉 [Ogre](https://github.com/OGRECave/ogre) - Scene-oriented, flexible 3D engine.
    - 🎉 [OSRE](https://github.com/kimkulling/osre) - Just another "Open Source Render Engine".
    - 🔒 [StratusGFX](https://github.com/KTStephano/StratusGFX) - Realtime 3D rendering engine implementing modern graphics techniques.
    - 🎉 [Threepp](https://github.com/markaren/threepp) - Cross-platform C++17 port of the popular 3D JavaScript library _Three.js_ (r129).
    - 🎉 [Tungsten](https://github.com/tunabrain/tungsten) - High-performance physically-based renderer in C++11.
    - 🎉 [Wicked Engine](https://github.com/turanszkij/WickedEngine) - Engine focusing on performance & modern rendering techniques.
- C++: Gui
    - 🎉 [Crazy Eddie's GUI](https://github.com/cegui/cegui) - Versatile, multi-platform gui library.
    - 🎉 [Dear ImGui](https://github.com/ocornut/imgui) 🔥 - Bloat-free immediate mode gui library. Ported to many other languages.
    - 🔒 [FLTK](https://github.com/fltk/fltk) - Fast Light Toolkit, cross-platform gui. [[Website](https://www.fltk.org/)]
    - 🔒 [GTK](https://gitlab.gnome.org/GNOME/gtk/) - GIMP Toolkit, a multi-platform toolkit for creating guis.
    - 🎉 [GuiLite](https://github.com/idea4good/GuiLite) - Header-only, cross-platform gui library.
    - 📚 [List of C++ UI Libraries](https://philippegroarke.com/posts/2018/c++_ui_solutions/) - List of C++ gui libraries, with pictures and descriptions.
    - 🎉 [Litehtml](https://github.com/litehtml/litehtml) - Lightweight HTML / CSS rendering engine.
    - 🎉 [Nana](https://github.com/cnjinhao/nana) - Cross-platform gui library in modern C++.
    - ⭐ [Portable File Dialogs](https://github.com/samhocevar/portable-file-dialogs) - Single-header C++11 native dialogs on Windows, macOS, and Linux.
    - 🔒 [Qt](https://github.com/qt) - Industry standard gui library. [[Awesome](https://github.com/mikeroyal/Qt-Guide) | [Website](https://www.qt.io)]
    - ⭐ [RmlUi](https://github.com/mikke89/RmlUi) - Turns HTML / CSS source files into vertices and draw commands. [[Docs](https://mikke89.github.io/RmlUiDoc/)]
    - ⭐ [Turbo Badger](https://github.com/fruxo/turbobadger) - Gui library for hardware accelerated apps & games. [[Oryol Example](https://floooh.github.io/oryol-samples/wasm/TurboBadgerDemo.html)]
    - 🔒 [Wt](https://github.com/emweb/wt) - Web gui library in modern C++. [[Website](https://www.webtoolkit.eu/wt)]
    - 🔒 [wxWidgets](https://github.com/wxWidgets/wxWidgets) - Cross-platform gui using native controls. [[Website](https://wxwidgets.org)]
- C++: Input
    - 🎉 [Gainput](https://github.com/jkuhlmann/gainput) - Easy to use input library.
    - 🎉 [OIS](https://github.com/wgois/OIS) - Object-oriented input system. Compatiable with many operating systems.
    - 🎉 [Oryol Input](https://github.com/floooh/oryol/tree/043683dcb3181beb64ae1c85ea76e4a4eb71c124/code/Modules/Input) - Input module from the _Oryol_ game framework.
- C++: Layout
    - 🎉 [Yoga](https://github.com/facebook/yoga) - Cross-platform [flexbox](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Flexible_Box_Layout/Basic_Concepts_of_Flexbox) layout engine by _Facebook_. [[Website](https://yogalayout.com/)]
- C++: Libraries
    - 🎉 [Boost Libraries](https://github.com/boostorg) - Wide range of C++ libraries, many end up as part of the STL. [[Website](https://www.boost.org)]
    - 📚 [Gamedev Libraries](https://github.com/raizam/gamedev_libraries) - Collection of open source C/C++ libraries for game development.
    - 📚 [Inqlude](https://inqlude.org) - List of libraries for developers of _Qt_-based apps.
    - 📚 [List of Open Source C++ Libraries](https://en.cppreference.com/w/cpp/links/libs) - Comprehensive list of open source C++ libraries.
    - 📚 [NVIDIA GameWorks](https://github.com/NVIDIAGameWorks) - _NVIDIA_ technologies for game & app developers.
- C++: Lighting
    - 🎉 [Thekla Atlas](https://github.com/Thekla/thekla_atlas) - Atlas generation tool.
    - 🎉 [UVAtlas](https://github.com/Microsoft/UVAtlas) - DirectX library for creating and packing texture atlases.
- C++: Math
    - 🎉 [OpenGL Mathematics](https://github.com/g-truc/glm) - Header-only math library for graphics software.
- C++: Network
    - 🎉 [Cpp-HttpLib](https://github.com/yhirose/cpp-httplib) - Single-header file HTTP server and client library in C++11.
    - 🎉 [GameNetworkingSockets](https://github.com/ValveSoftware/GameNetworkingSockets) - Messages over UDP, message fragmentation & reassembly, P2P networking, encryption.
    - 🎉 [yojimbo](https://github.com/mas-bandwidth/yojimbo) - Network library for client/server games.
- C++: Physics
    - 🎉 [Box2D](https://github.com/erincatto/box2d) - Battle tested 2D physics for games. [[Docs](https://box2d.org/documentation/) | [Fixed Time-Step](https://www.unagames.com/blog/daniele/2010/06/fixed-time-step-implementation-box2d) | [Tutorials](http://www.iforce2d.net/b2dtut/introduction)]
    - 🎉 [Bullet Physics](https://github.com/bulletphysics/bullet3) - Popular 3D physics libary.
    - 🎉 [Chrono](https://github.com/projectchrono/chrono) - High-performance multiphysics and multibody dynamics simulations. [[Gallery](https://projectchrono.org/gallery/)]
    - 🎉 [Edyn](https://github.com/xissburg/edyn) - Multi-threaded, networked physics engine. Supports large dynamic worlds. [[Testbed](https://github.com/xissburg/edyn-testbed)]
    - 🎉 [Jolt Physics](https://github.com/jrouwe/JoltPhysics) - Multi-core friendly rigid body 3D physics and collision detection.
    - 🎉 [Liquid Fun](https://github.com/google/liquidfun) - Extension of _Box2D_, adds particle-based fluid and soft bodies. [[Demos](http://google.github.io/liquidfun/)]
    - 🎉 [Newton Dynamics](https://github.com/MADEAPPS/newton-dynamics/) - Real-time simulation of 3D environments.
    - 🎉 [ODE](http://www.ode.org/) - Open Dynamics Engine, 3D rigid body physics.
    - 🎉 [Qu3e](https://github.com/RandyGaul/qu3e) - Fast 3D physics engine, created to be used in games.
    - 🎉 [ReactPhysics3D](https://github.com/DanielChappuis/reactphysics3d) - 3D physics engine.
    - 🎉 [Slingshot](https://github.com/Slingshot-Physics/slingshot-community) - Constraint-based physics engine for 3D rigid body dynamics.
- C++: Reflection
    - 🎉 [Boost.PFR](https://github.com/boostorg/pfr) - Basic reflection C++14 library, part of the Boost Libraries.
    - 🎉 [Magic Enum](https://github.com/Neargye/magic_enum) - Header-only C++17, provides static reflection for enums.
    - 🎉 [Meta](https://github.com/skypjack/meta) - Header-only, non-intrusive and macro-free runtime reflection system in C++17.
    - 🎉 [Nameof](https://github.com/Neargye/nameof) - Header-only C++17, provides nameof macros to obtain name of a variable.
    - 🎉 [Ponder](https://github.com/billyquith/ponder) - Expose C++17 classes and objects so they can used as data.
    - 🎉 [Reflect](https://github.com/stevinz/reflect) - Small, flexible, single-header library for runtime reflection and meta data in C++11.
    - 🎉 [RTTR](https://github.com/rttrorg/rttr) - Reflection for C++11.
- C++: Scripting
    - 🎉 [AngelScript](http://www.angelcode.com/angelscript/) - Cross-platform scripting library, follows the widely known syntax of C/C++.
    - 🔒 [ArkScript](https://github.com/ArkScript-lang/Ark) - Small, fast, functional and scripting language.
    - 🎉 [ChaiScript](https://github.com/ChaiScript/ChaiScript) - Embedded scripting language designed from to directly target C++17.
    - 🎉 [GameMonkey Script](https://github.com/publicrepo/gmscript) - Embedded scripting language for apps, tools and games.
    - 🎉 [v8](https://github.com/v8/v8) - High-performance JavaScript and WebAssembly engine by _Google_.
- C++: Serialization
    - 🎉 [Cap'n Proto](https://github.com/capnproto/capnproto) - Fast data interchange format and capability-based RPC system.
    - 🎉 [Cereal](https://github.com/USCiLab/cereal) - Header-only C++11 serialization library.
    - 🎉 [Cista++](https://github.com/felixguendling/cista) - Simple, high-performance serialization & reflection library.
    - 🎉 [FlatBuffers](https://github.com/google/flatbuffers) - Efficient cross-platform serialization library by _Google_.
    - 🎉 [JSON for Modern C++](https://github.com/nlohmann/json) - JSON support for Modern C++.
    - 🎉 [Protobuf](https://github.com/protocolbuffers/protobuf) - Protocol Buffers, for platform-neutral serialized data by _Google_.
    - 🎉 [RapidJSON](https://github.com/Tencent/rapidjson/) - Fast JSON parser / generator.
- C++: Terrain
    - 🎉 [Terra Forge 3D](https://github.com/Jaysmito101/TerraForge3D) - Procedural 3D terrain generation and texturing tool.
- C++: Utility
    - 🎉 [Any-Lite](https://github.com/martinmoene/any-lite) - Header-only 'any' type for C++98 and above.
    - 🎉 [EASTL](https://github.com/electronicarts/EASTL/) - Electronic Arts STL replacement, emphasis on performance.
    - 🎉 [faker-cxx](https://github.com/cieslarmichal/faker-cxx) - C++20 Faker library for generating fake (but realistic) data for testing and development.
    - 🎉 [Parallel Hashmap](https://github.com/greg7mdp/parallel-hashmap) - Header-only, fast and memory-friendly hashmap and binary tree containers.
    - 🎉 [Spdlog](https://github.com/gabime/spdlog) - Fast logging library.
    - 🎉 [Tiny-Process-Library](https://gitlab.com/eidheim/tiny-process-library) - Making it simple to create and stop new processes.
    - 🎉 [TinyXML-2](https://github.com/leethomason/tinyxml2) - XML parser that can be easily integrated into other programs.
- C++: Visual Programming / Nodes
    - 🎉 [NodeEditor](https://github.com/paceholder/nodeeditor) - Graph-controlled data processing, built with _Qt_.
    - 🎉 [QuickQanava](https://github.com/cneben/QuickQanava) - Display graphs and relational content in a _QtQuick_-based app, in C++14.
    - 🎉 [Visual Script Engine](https://github.com/kovacsv/VisualScriptEngine) - Visual scripting engine designed for embedding.

### C#
- 📚 [Dot Net Perls](https://www.dotnetperls.com) - Reference for the C# language.
- C#: App Framework
    - 🎉 [ATF](https://github.com/SonyWWS/ATF) - Components for making tools on Windows, started in 2005.
- C#: Audio
    - 🎉 [NAudio](https://github.com/naudio/NAudio) - Audio and MIDI library for .NET.
- C#: Cross-Platform
    - 🌎 [Blazor](https://github.com/dotnet/aspnetcore/blob/main/src/Components/README.md) - C# to JavaScript (as WebAssembly) technology by _Microsoft_. [[Website]((https://dotnet.microsoft.com/en-us/apps/aspnet/web-apps/blazor))]
    - 🎉 [Mono](https://github.com/mono/mono) - Open source implementation of _Microsoft_'s .NET Framework.
- C#: Entity Component System
    - 🎉 [Arch](https://github.com/genaray/Arch) - High-performance ECS with optional multithreading.
    - 🎉 [DefaultEcs](https://github.com/Doraku/DefaultEcs) - ECS framework designed for game development.
    - 🔒 [Friflo.Engine.ECS](https://github.com/friflo/Friflo.Json.Fliox/blob/main/Engine/README.md) - Archetype based ECS with focus on performance, cache locality and DX.
    - 🎉 [LeoECS](https://github.com/Leopotam/ecs) - ECS framework powered by C# with optional integration to _Unity_.
- C#: Game Engine w/Editor
    - 🎉 [Duality](https://github.com/AdamsLair/duality) - Modular 2D engine, editor built with _OpenTK_.
    - 🎉 [Flat Red Ball](https://github.com/vchelaru/FlatRedBall) - 2D game engine & design tools, built with _MonoGame_. [[Website](https://flatredball.com/)]
    - 🎉 [Murder](https://github.com/isadorasophia/murder) - Pixel-art, ECS game engine built on _MonoGame_. [[Docs](https://isadorasophia.com/murder/)]
    - 🎉 [Stride](https://github.com/stride3d/stride) - Game engine for realistic rendering and VR. Formerly _Xenko_. [[Website](https://www.stride3d.net/)]
    - 💸 [Unity](https://store.unity.com/) - Biggest name in game engines, industry standard.
- C#: Game Framework
    - 🎉 [FNA](https://github.com/FNA-XNA/FNA) - Reimplementation of the Microsoft XNA Game Studio 4.0 libraries.
    - 🎉 [Monofoxe](https://github.com/Martenfur/Monofoxe) - Game engine designed to simplify working with _MonoGame_.
    - 🎉 [MonoGame](https://github.com/MonoGame/MonoGame) 🔥 - Framework for creating cross-platform games. [[Website](https://www.monogame.net/)]
    - 🎉 [Nez](https://github.com/prime31/Nez) - Feature-rich 2D framework built on _MonoGame_.
    - 🎉 [Protogame](https://github.com/RedpointGames/Protogame) - Cross-platform 2D/3D game engine built on _MonoGame_.
- C#: Geometry
    - 🎉 [DotRecast](https://github.com/ikpil/DotRecast) - A port of _Recast & Detour_, navigation mesh toolset for games, Unity3D, servers, C#.
- C#: Graphics - 3D
    - 🎉 [OpenTK](https://github.com/opentk/opentk) - Open Toolkit, C# bindings for OpenGL. [[LearnOpenTK](https://github.com/opentk/LearnOpenTK)]
    - 🎉 [Veldrid](https://github.com/mellinoe/veldrid) - Cross-platform, graphics API-agnostic rendering and compute library for .NET.
- C#: Gui
    - 🎉 [Apos.Gui](https://github.com/Apostolique/Apos.Gui) - UI library for _MonoGame_.
    - 🎉 [Avalonia](https://github.com/AvaloniaUI/Avalonia) - Cross-platform gui framework for .NET. [[Website](https://avaloniaui.net/)]
    - 🎉 [GeonBit.UI](https://github.com/RonenNess/GeonBit.UI) - Gui for _MonoGame_ projects.
    - 🎉 [MGUI](https://github.com/Videogamers0/MGUI) - UI framework for the _MonoGame_ game framework.
    - 🎉 [MonoGame.Forms](https://github.com/BlizzCrafter/MonoGame.Forms) - _MonoGame_ render window for Windows Forms.
    - 🎉 [Myra](https://github.com/rds1983/Myra) - Gui library for _MonoGame_, _FNA_, and _Stride_.
    - 🎉 [Squid](https://github.com/Roderik11/Squid) - C# Realtime GUI System.
    - 🎉 [Uno](https://github.com/unoplatform/uno) - Mobile, desktop and WebAssembly gui library. [[Website](https://platform.uno/)]
- C#: Layout
    - 🎉 [Gum](https://github.com/vchelaru/Gum) - Flexible layout tool for creating UI on any platform.
- C#: Physics
    - 🎉 [Aether Physics](https://github.com/tainicom/Aether.Physics2D) - 2D physics library with continuous collision detection.
    - 🎉 [Box2D.NET](https://github.com/ikpil/Box2D.NET) - A port of Box2D. 2D physics engine for games, .NET C#, Unity3D, servers.
    - 🎉 [Velcro Physics](https://github.com/Genbox/VelcroPhysics) - C# port of Box2D. Formerly _Farseer Physics_.
- C#: Utility
    - 🎉 [Facepunch.Steamworks](https://github.com/Facepunch/Facepunch.Steamworks) - Steamworks implementation.
    - 🎉 [Monogame.Extended](https://github.com/MonoGame-Extended/Monogame-Extended) - Extensions to make _MonoGame_ more awesome.

### Dart
- 📚 [Awesome Dart](https://github.com/yissachar/awesome-dart) - Curated list of awesome Dart frameworks, libraries, and software.
- 🌎 [Dart](https://dart.dev) - Client-optimized language for fast apps on any platform. [[GitHub](https://github.com/dart-lang/)]
- Dart: App Framework
    - 🎉 [Flutter](https://flutter.dev) - Open source app framework by _Google_. [[Awesome](https://github.com/Solido/awesome-flutter) | [GitHub](https://github.com/flutter)]
- Dart: File Formats
    - 🎉 [image](https://github.com/brendan-duncan/image) - Library for decoding / encoding image formats and image processing.
- Dart: Game Framework
    - 🎉 [Flame](https://github.com/flame-engine/flame) - Minimalist _Flutter_ based 2D game engine. [[Awesome](https://github.com/flame-engine/awesome-flame#readme) | [Examples](https://examples.flame-engine.org/#/) | [Website](https://flame-engine.org/)]

### F#
- 📚 [Awesome F#](https://github.com/fsprojects/awesome-fsharp) - Curated list of frameworks, libraries, software and resources.
- 🌎 [F#](https://fsharp.org) - Functional-first language for .NET, prioritizing expressive code and parallelism.
- F#: Audio
    - 🔒 [FSound](https://github.com/albertp007/FSound) - Sound processing library.
- F#: Entity Component System
    - 🎉 [Garnet](https://github.com/bcarruthers/garnet) - Game composition library with ECS and actor-like messaging features.
- F#: Game Engine w/Editor
    - 🎉 [Nu Game Engine](https://github.com/bryanedds/Nu) - Cross-platform game engine built in the functional style.
- F#: Gui
    - 🎉 [Fabulous](https://github.com/fabulous-dev/Fabulous) - Declarative UI framework for cross-platform apps.

### Go
- 📚 [Awesome Go](https://github.com/avelino/awesome-go) - Awesome Go frameworks, libraries and software.
- 🌎 [Go](https://go.dev/) - Statically typed, compiled programming language designed at _Google_. [[GitHub](https://github.com/golang)]
- Go: Audio
    - 🎉 [Beep](https://github.com/faiface/beep) - Playback and audio-processing.
- Go: Game Engine w/Editor
    - 🎉 [G3N](https://github.com/g3n/engine) - OpenGL 3D game engine.
- Go: Game Framework
    - 🎉 [Ebitengine](https://github.com/hajimehoshi/ebiten) - Dead simple 2D game library.
    - 🎉 [Engo](https://github.com/EngoEngine/engo) - A 2D game framework.
    - 🎉 [Pixel](https://github.com/faiface/pixel) - Hand-crafted 2D game library. [[Examples](https://github.com/faiface/pixel-examples)]
- Go: Geometry
    - 🎉 [3D Mesh Simplification](https://github.com/fogleman/simplify) - 3D mesh simplification.
- Go: Graphics
    - 🎉 [ln](https://github.com/fogleman/ln) - The 3D Line Art Engine, a vector-based 3D renderer. [[Docs](https://pkg.go.dev/github.com/fogleman/ln/ln)]

### Haxe
- 📚 [Awesome Haxe](https://github.com/nadako/awesome-haxe#readme) - Awesome curated list of useful Haxe links.
- 📚 [Awesome Haxe Game Dev](https://github.com/Dvergar/awesome-haxe-gamedev#readme) - Awesome list of game dev resources for Haxe.
- 🌎 [Haxe](https://haxe.org) - Produce cross-platform native code. [[GitHub](https://github.com/HaxeFoundation/haxe)]
- 📚 [Haxe Blog: Game Engine](https://kircode.com/post/how-i-wrote-my-own-3d-game-engine-and-shipped-a-game-with-it-in-20-months) - "How I wrote my own 3D game engine and shipped a game in 20 months".
- 📚 [Haxe Blog: OpenFL](https://www.gamedeveloper.com/programming/flash-is-dead-long-live-openfl-) - "Flash is dead, long live OpenFL".
- Haxe: Animation
    - 🎉 [Actuate](https://github.com/jgranick/actuate) - Flexible, fast tween library.
    - 🎉 [DragonBones](https://github.com/openfl/dragonbones) - Runtime support for _DragonBones_ skeletal animation.
    - 🎉 [Spine-Hx](https://github.com/jeremyfa/spine-hx) - _Spine_ runtime for Haxe.
- Haxe: App Framework
    - 🎉 [Lime](https://github.com/haxelime/lime) - Flexible, lightweight layer for Haxe cross-platform developers.
    - 🎉 [nme](https://github.com/haxenme/nme) - Cross-platform native backend for Haxe projects.
- Haxe: Cross-Platform
    - 🎉 [HashLink](https://github.com/HaxeFoundation/hashlink/) - Virtual machine for Haxe.
- Haxe: Entity Component System
    - 🎉 [Ecx](https://github.com/eliasku/ecx) - Entity component system framework for Haxe.
    - 🎉 [GASM](https://github.com/HacksawStudios/GASM) - Framework agnostic entity component system for Haxe.
- Haxe: Game Engine w/Editor
    - 🎉 [Armory](https://github.com/armory3d/armory) - 3D game engine with full _Blender_ integration.
    - 🎉 [Away3D](https://github.com/openfl/away3d) - Real-time 3D engine for OpenFL. [[Website](http://away3d.com)]
    - 🎉 [Flixel-Studio](https://github.com/Dovyski/flixel-studio) - Embeddable, in-game editor for _HaxeFlixel_.
    - 🎉 [Hide](https://github.com/heapsio/hide) - Extensible IDE for the _Heaps_ 3D graphic engine.
    - 🎉 [LDtk](https://github.com/deepnight/ldtk) 🔥 - Modern, lightweight and efficient 2D level editor. [[Website](https://ldtk.io)]
    - 🎉 [Starling](https://github.com/openfl/starling) - Popular (_Angry Birds_) 2D game engine built on _OpenFL_. [[Editor](http://starlingbuilder.github.io) | [Website](https://gamua.com/starling/)]
- Haxe: Game Framework
    - 🎉 [Ceramic](https://github.com/ceramic-engine/ceramic) - Cross-platform 2D framework. [[Examples](https://ceramic-engine.com/examples/)]
    - 🎉 [Citrus](https://github.com/DaVikingCode/Citrus-Engine) - ActionScript 3 based 2D/3D framework. [[Website](http://citrusengine.com/)]
    - 🎉 [Clay](https://github.com/clay2d/clay) - Cross-platform 2D game framework.
    - 🎉 [gameBase](https://github.com/deepnight/gameBase) - Base structure for Haxe games, using _Heaps_ graphics framework. [[Tutorial](https://deepnight.net/tutorial/using-my-gamebase-to-create-a-heaps-game/)]
    - 🎉 [HaxeFlixel](https://github.com/HaxeFlixel/flixel) - Cross-platform 2D game framework powered by _OpenFL_. [[Website](https://haxeflixel.com/)]
    - 🎉 [OpenFL](https://github.com/openfl/openfl) - Open source implementation of the [Adobe Flash](https://en.wikipedia.org/wiki/Adobe_Flash) API. [[Website](https://www.openfl.org/)]
- Haxe: Graphics
    - 🎉 [Heaps](https://github.com/HeapsIO/heaps) 🔥 - Cross-platform 2D/3D engine (by creators of Haxe). [[Website](https://heaps.io)]
    - 🎉 [Kha](https://github.com/Kode/Kha) - Ultra-portable, high-performance multimedia framework.
    - 🎉 [Sparkler](https://github.com/AndreiRudenko/sparkler) - Modular macro-powered particle system.
- Haxe: Gui
    - 🎉 [HaxeUI](https://github.com/haxeui/haxeui-core) - Cross-platform set of styleable gui components.
    - 🎉 [Zui](https://github.com/armory3d/zui) - Immediate mode user interface, used in _ArmorPaint_.
- Haxe: Libraries
    - 📚 [HaxeLibs](https://lib.haxe.org/all) - List of every library uploaded to the Haxe website.
    - 📚 [HaxeTink](https://github.com/haxetink) - Various addon libraries for Haxe.
    - 🌎 [Snowkit](https://github.com/snowkit) - Collective of Haxe developers.
- Haxe: Physics
    - 🎉 [Haxe Bullet](https://github.com/armory3d/haxebullet) - _Bullet 3D_ physics bindings for Haxe.
    - 🎉 [HeapsIO/bullet](https://github.com/HeapsIO/bullet) - _Bullet 3D_ physics for _Heaps_ (Haxe's native low-level game framework).
    - 🎉 [Jelly Physics](https://github.com/michaelapfelbeck/jellyPhysics) - Soft body 2D physics engine.
    - 🎉 [Nape](https://github.com/HaxeFlixel/nape-haxe4) - Fast, friendly 2D rigid body physics engine. [[Demos](https://joecreates.github.io/napephys/)]
- Haxe: Serialization / Storage
    - 🎉 [CastleDB](https://github.com/ncannasse/castle) - Structured database with a local web service to edit it.
    - 🎉 [Format](https://github.com/HaxeFoundation/format) - Various files formats support for Haxe.
    - 🎉 [HxBit](https://github.com/HeapsIO/hxbit) - Binary serialization and network synchronization library.
- Haxe: Utility
    - 🎉 [hexMachina](https://github.com/DoclerLabs/hexCore) - Powerful modular MVC framework. [[Website](http://hexmachina.org/)]
    - 🎉 [HxColorToolkit](https://github.com/andyli/hxColorToolkit) - Library for color conversion and color scheme generation.
    - 🎉 [HxMath](https://github.com/tbrosman/hxmath) - Game-oriented math library for the Haxe language.
    - 🎉 [SteamWrap](https://github.com/larsiusprime/SteamWrap) - Haxe native extension for the Steam API.
- Haxe: Visual Programming / Nodes
    - 🎉 [Haxe-Blockly](https://github.com/nickmain/haxe-blockly) - Haxe wrapper for [Blockly](https://developers.google.com/blockly)

### Lua
- 📚 [Awesome Lua](https://github.com/LewisJEllis/awesome-lua) - Awesome Lua packages and resources.
- Lua: Game Framework
    - 🎉 [3DreamEngine](https://github.com/3dreamengine/3DreamEngine) - 3D engine on top of _LÖVE_.
    - 🎉 [Gideros](https://github.com/gideros/gideros) - 2D/3D cross-platform games with Lua. [[Website](http://giderosmobile.com/)]
    - 🎉 [INSTEAD](https://github.com/instead-hub/instead) - Simple Text Adventure Interpreter.
    - 🎉 [LÖVE](https://github.com/love2d/love) - 2D framework for writing game code with Lua. [[Awesome](https://github.com/love2d-community/awesome-love2d) | [Website](https://love2d.org)]

### Java
- 📚 [Awesome Java](https://github.com/akullpp/awesome-java) - Awesome frameworks, libraries and software for Java.
- 🌎 [Java](https://dev.java) - General-purpose language, runs on [Java virtual machines](https://en.wikipedia.org/wiki/Java_virtual_machine). [[GitHub](https://github.com/openjdk)]
- 📚 [Learn Java](https://dev.java/learn/) - Official docs and tutorials.
- 📚 [OpenGL & GLSL Tutorials](https://github.com/mattdesl/lwjgl-basics/wiki) - OpenGL / GLSL tutorials for _LWJGL_ and _libGDX_.
- Java: Game Framework
    - 🎉 [jMonkeyEngine](https://github.com/jMonkeyEngine/jmonkeyengine) - Modern 3D game development suite.
    - 🎉 [libGDX](https://github.com/libgdx/libgdx) - Game framework built on, and adds to _LWJGL_. [[Awesome](https://github.com/rafaskb/awesome-libgdx#readme) | [Website](https://libgdx.com/)]
    - 🎉 [LWJGL](https://github.com/LWJGL/lwjgl3) - Graphics, audio, parallel computing, XR and more. [[Website](https://www.lwjgl.org/)]
- Java: Gui
    - 🎉 [VisUI](https://github.com/kotcrab/vis-ui) - A _libGDX_ UI toolkit.

### JavaScript
- 📚 [Eloquent JavaScript](https://eloquentjavascript.net) - Modern JavaScript programming, with examples.
- 🌎 [MDN](https://developer.mozilla.org/en-US/) - Mozilla Developer Network, excellent learning resource.
- 🌎 [W3 Schools](https://www.w3schools.com/default.asp) - Learn to code with the world's largest web developer site.
- JavaScript: Animation
    - 🎉 [Animate.css](https://github.com/animate-css/animate.css) - Ready-to-use, pure CSS animations. [[Examples](https://animate.style/)]
    - 🎉 [D3.js](https://github.com/d3/d3) - Data-Driven Documents. Bring data to life with SVG, canvas and HTML. [[Examples](https://observablehq.com/@d3/gallery) | [Website](https://d3js.org)]
    - 💸 [GreenSock](https://github.com/greensock/GSAP) - Robust animation toolset. [[Website](https://greensock.com)]
    - 🎉 [Ossos](https://github.com/sketchpunklabs/ossos) - Web-based character animation system.
    - 🎉 [React-Spring](https://github.com/pmndrs/react-spring) - Spring physics based React animation library.
    - 🎉 [Scene.js](https://github.com/daybrush/scenejs) - JavaScript & CSS timeline-based animation library.
    - 🎉 [Theatre](https://github.com/theatre-js/theatre) - Motion design editor for the web.
    - 🎉 [Tween.js](https://github.com/tweenjs/tween.js) - Tweening engine for easy animations using Robert Penner's equations.
    - 🎉 [TweenJS](https://github.com/CreateJS/TweenJS) - Tweening / animation library, part of the _CreateJS_ suite.
- JavaScript: Audio
    - 🎉 [Howler.js](https://github.com/goldfire/howler.js) - Audio made easy and reliable across all platforms.
    - 🎉 [PixiJS Sound](https://github.com/pixijs/sound) - Audio library with filters, built on _PixiJS_. [[Examples](https://pixijs.io/sound/examples/)]
    - 🎉 [SoundJS](https://github.com/CreateJS/SoundJS) - Simple API and powerful features, part of the _CreateJS_ suite.
    - 🎉 [Sonant-X](https://github.com/nicolas-van/sonant-x) - Small JavaScript synthesizer library. [[Online Composer](https://nicolas-van.github.io/sonant-x-live/)]
    - 🎉 [SpessaSynth](https://github.com/spessasus/SpessaSynth) - MIDI player and synthesizer.
    - 🎉 [Tone.js](https://github.com/Tonejs/Tone.js) - WebAudio framework for creating interactive music in the browser.
    - 🎉 [tuna](https://github.com/Theodeus/tuna) - Audio effects library for the WebAudio API.
    - 🎉 [Waveform Playlist](https://github.com/naomiaro/waveform-playlist) - Multitrack web audio editor and player with canvas waveform preview.
- JavaScript: Color
    - 🎉 [Chroma.js](https://github.com/gka/chroma.js) - Library for all kinds of color manipulations.
- JavaScript: Cross-Platform
    - 🎉 [Apache Cordova](https://cordova.apache.org) - Mobile apps (iOS / Android) with with JavaScript, HTML, and CSS.
    - 🎉 [Capacitor](https://github.com/ionic-team/capacitor) - Run web apps natively on iOS, Android, Web, and more. [[Website](https://capacitorjs.com/)]
    - 🎉 [Electron](https://github.com/electron/electron) - Cross-platform desktop apps with JavaScript, HTML, and CSS. [[Website](https://www.electronjs.org/)]
    - 📚 [Electron Alternatives](https://github.com/sudhakar3697/electron-alternatives) - Cross-platform gui app development options.
    - 🎉 [Ejecta](https://github.com/phoboslab/Ejecta) - JavaScript canvas & audio implementation for iOS. App store compatible.
    - 🎉 [NW.js](https://github.com/nwjs/nw.js) - Desktop apps with JavaScript. Formerly _Node-Webkit_. [[Website](https://nwjs.io)]
    - 🎉 [nx.js](https://github.com/TooTallNate/nx.js/) - JavaScript runtime for Nintendo Switch homebrew applications.
    - 📚 [Progressive Web Apps](https://web.dev/progressive-web-apps/) - Using web tech in a way that feels like platform-specific apps.
    - 🎉 [React Native](https://github.com/facebook/react-native) - Framework for building native apps using React. [[Website](https://reactnative.dev/)]
    - 🎉 [Tauri](https://github.com/tauri-apps/tauri) - Smaller, faster, and more secure desktop applications. [[Website](https://tauri.app/)]
    - 💸 [Ultralight](https://ultralig.ht/) - Supports modern HTML5, CSS, and JavaScript. Based on _WebKit_.
    - 🎉 [WebView2](https://developer.microsoft.com/en-us/microsoft-edge/webview2/) - Microsoft Edge control allows you to embed web in native apps. [[Docs](https://docs.microsoft.com/en-us/microsoft-edge/webview2/)]
    - 🎉 [Window.js](https://github.com/windowjs/windowjs) - JavaScript runtime for desktop graphics programming. [[Docs](https://windowjs.org/)]
- JavaScript: Docking
    - 🎉 [Dock Spawn TS](https://github.com/node-projects/dock-spawn-ts) - Maintained, TypeScript version of [Dock Spawn](https://github.com/coderespawn/dock-spawn), a JavaScript docking framework.
    - 🎉 [FlexLayout](https://github.com/caplin/FlexLayout) - Multi-tab layout manager.
    - 🎉 [Golden Layout](https://github.com/golden-layout/golden-layout) - Multi-window layout manager for web apps.
    - 🎉 [PhosphorJS](https://github.com/phosphorjs/phosphor) - High-performance, pluggable, desktop-style web apps.
    - 🎉 [React Mosaic](https://github.com/nomcopter/react-mosaic) - React tiling window manager.
    - 🎉 [RC-Dock](https://github.com/ticlo/rc-dock) - Dock layout component for React.
    - 🎉 [wcDocker](https://github.com/WebCabin/wcDocker) - Window layout system with a responsive and interactive design.
- JavaScript: Entity Component System
    - 🎉 [Becsy](https://github.com/LastOliveGames/becsy) - Multithreaded ECS for TypeScript and JavaScript.
    - 🔒 [bitECS](https://github.com/NateTheGreatt/bitECS) - Functional, minimal, data-oriented, ultra-high performance ECS library.
    - 🎉 [Ecsy](https://github.com/ecsyjs/ecsy) - Experimental ECS aiming to be lightweight, easy to use.
    - 🎉 [Miniplex](https://github.com/hmans/miniplex) - Entity management system for games.
- JavaScript: File Formats
    - 🎉 [JSMpeg](https://github.com/phoboslab/jsmpeg) - MPEG1 Video Decoder in JavaScript.
- JavaScript: Framework
    - 🎉 [Alpine](https://github.com/alpinejs/alpine) - Rugged, minimal framework for composing JavaScript behavior in your markup.
    - 🎉 [Angular](https://github.com/angular/angular) - The modern web developer's platform.
    - 🎉 [Aurelia](https://github.com/aurelia/framework) - Modern, front-end framework for browser, mobile, and desktop apps.
    - 🎉 [Ember](https://github.com/emberjs/ember.js) - Framework for ambitious web developers.
    - 🎉 [Preact](https://github.com/preactjs/preact) - Fast 3kB React alternative with the same modern API.
    - 🎉 [React](https://github.com/facebook/react/) - Declarative, efficient, and flexible JavaScript library for building user interfaces.
    - 🎉 [Svelte](https://github.com/sveltejs/svelte) - Takes your declarative components and converts them into efficient JavaScript.
    - 🎉 [Vue](https://github.com/vuejs/vue) - Progressive JavaScript framework for building UI on the web.
- JavaScript: Game Engines
    - 📚 [JavaScript Game Engines](https://github.com/collections/javascript-game-engines) - GitHub Collection of JavaScript / HTML5 game engines.
    - 📚 [JavaScript Wiki: Game Engines](https://github.com/bebraw/jswiki/wiki/Game-Engines) - JavaScript / HTML5 game engines and frameworks.
- JavaScript: Game Engine w/Editor
    - 🎉 [A-Frame](https://github.com/aframevr/aframe/) - Web framework for building VR experiences. [[Website](https://aframe.io)]
    - 🎉 [Cocos Creator](https://github.com/cocos-creator/engine) - Cross-Platform 2D/3D game creation. [[Website](https://www.cocos.com/en/creator)]
    - 🎉 [ct.js](https://github.com/ct-js/ct-js) - Desktop 2D game engine, built on _PixiJS_.
    - 🎉 [Egret](https://github.com/egret-labs/egret-core) - Mobile game engine. [[Editor](https://github.com/egret-labs/egret-ui-editor-opensource)]
    - 🎉 [GDevelop](https://github.com/4ian/GDevelop) - Full-featured 2D game development. [[Website](https://gdevelop.io/)]
    - 🎉 [Impact](https://github.com/phoboslab/impact) - Game engine for desktop and mobile browsers. [[2D Level Editor](https://impactjs.com/documentation/weltmeister)]
    - 🎉 [Isogenic](https://github.com/irrelon/ige) - Engine with advanced multiplayer, based on _Valve_'s multiplayer system.
    - 🎉 [melonJS](https://github.com/melonjs/melonJS) - Modern 2D game engine, level editing with [Tiled](https://doc.mapeditor.org/en/stable/). [[Examples](https://melonjs.github.io/examples/) | [Website](https://melonjs.org)]
    - 🎉 [microStudio](https://github.com/pmgl/microstudio/) - Online game engine. Learn and practice programming.
    - 🎉 [Pixelbox.js](https://github.com/cstoquer/pixelbox) - Sandbox to fast-prototype 2D tile-based games. [[Download](https://pixwlk.itch.io/pixelbox)]
    - 🎉 [QICI Engine](https://github.com/qiciengine/qiciengine) - Toolset for making games.
    - 🎉 [Superpowers](https://github.com/superpowers) - Both 2D & 3D game making for indies. [[Website](http://superpowers-html5.com/index.en.html)]
    - 🎉 [Taro](https://github.com/moddio/taro) - Multiplayer engine with _Box2D_ physics, aka _Moddio_. [[Website](https://www.modd.io)]
- JavaScript: Game Framework
    - 🎉 [Crafty](https://github.com/craftyjs/Crafty) - Create 2D games in a structured way.
    - 🎉 [Excalibur](https://github.com/excaliburjs/Excalibur) - Friendly TypeScript 2D game engine for the web.
    - 🎉 [Galacean](https://github.com/galacean/engine) - Web/Mobile-first engine built on WebGL and glTF.
    - 🎉 [Kaboom](https://github.com/replit/kaboom) - Simple 2D framework.
    - 🎉 [LittleJS](https://github.com/KilledByAPixel/LittleJS) - Lightweight 2D framework with WebGL rendering.
    - 🎉 [Meep](https://github.com/Usnul/meep) - ECS game framework.
    - 🎉 [Oasis](https://github.com/ant-galaxy/oasis-engine) - WebGL framework by _AntGroup_. 2D/3D, animation, physics.
    - 🎉 [Phaser](https://github.com/photonstorm/phaser) - Fast 2D game framework. [[Website](https://phaser.io)]
    - 🎉 [Turbulenz](https://github.com/turbulenz/turbulenz_engine) - Modular 2D/3D game framework for browsers, desktops and mobile.
    - 🎉 [WhitestormJS](https://github.com/WhitestormJS/whs.js) - Framework for 3D apps / games, built on _Three.js_.
- JavaScript: Geometry
    - 🎉 [Convexhull.js](https://github.com/indy256/convexhull-js) - High-performance JavaScript 2D convex hull library.
    - 🎉 [Delaunator](https://github.com/mapbox/delaunator) - Incredibly fast JavaScript library for Delaunay triangulation of 2D points.
    - 🎉 [Earcut](https://github.com/mapbox/earcut) - The fastest and smallest JavaScript polygon triangulation library for your WebGL apps.
    - 🎉 [Poly-Decomp.js](https://github.com/schteppe/poly-decomp.js) - Decompose 2D polygons into convex pieces.
- JavaScript: Graphics - 2D
    - 🎉 [CanvasKit](https://github.com/google/skia/tree/main/modules/canvaskit) - WebAssembly build of _Google_'s 2D graphics library, Skia. [[Samples](https://skia.org/docs/user/modules/canvaskit/)]
    - 🎉 [EaselJS](https://github.com/CreateJS/EaselJS) - Makes working with the canvas element easy, part of [CreateJS](https://createjs.com/).
    - 🎉 [Escher.js](https://github.com/tentone/escher.js) - Interactive 2D graphics canvas framework.
    - 🎉 [Fabric.js](https://github.com/fabricjs/fabric.js) - Powerful and simple JavaScript canvas library.
    - 🎉 [Konva](https://github.com/konvajs/konva) - Canvas interactivity framework for desktop and mobile apps.
    - 🎉 [p5.js](https://github.com/processing/p5.js) - Library for creative coding. [[Website](https://p5js.org)]
    - 🎉 [Paper.js](https://github.com/paperjs/paper.js) - The swiss army knife of vector graphics. [[Examples](http://paperjs.org/)]
    - 🎉 [Pencil.js](https://github.com/pencil-js/pencil.js) - Modular interactive 2D drawing library. [[Examples](https://pencil.js.org/)]
    - 🎉 [PixiJS](https://github.com/pixijs/pixijs) 🔥 - Fast, lightweight 2D library. [[Awesome](https://github.com/cursedcoder/awesome-pixijs) | [Editor](https://github.com/Megabyteceer/thing-editor) | [Essentials](https://github.com/ShukantPal/pixi-essentials) | [Website](https://pixijs.com/)]
    - 🎉 [Pts](https://github.com/williamngan/pts) - Library for visualization and creative coding. [[Examples](https://ptsjs.org)]
    - 🎉 [Scrawl-canvas](https://github.com/KaliedaRik/Scrawl-canvas) - Library for working with the canvas element.
    - 🎉 [Stage.js](https://github.com/piqnt/stage.js) - 2D rendering engine for game development. [[Examples](https://piqnt.com/stage.js/)]
    - 🎉 [Two.js](https://github.com/jonobr1/two.js) - Renderer agnostic 2D drawing API for the web.
    - 🎉 [ZIM](https://github.com/danzen/zimjs) - Creative canvas framework. [[Website](https://zimjs.com/)]
- JavaScript: Graphics - 3D
    - 🎉 [Babylon.js](https://github.com/BabylonJS/Babylon.js) 🔥 - Powerful web rendering engine. [[Extensions](https://github.com/BabylonJS/Extensions) | [Website](https://www.babylonjs.com/)]
    - 🎉 [ClayGL](https://github.com/pissang/claygl) - WebGL library for scalable Web3D applications.
    - 🎉 [CopperLicht](https://ambiera.com/copperlicht/) - A 3D library for WebGL. [[CopperCube Editor](https://ambiera.com/coppercube/index.html)]
    - 🎉 [Filament for Web](https://github.com/google/filament/tree/main/web/filament-js) - WebAssembly build of Google's 3D graphics library, _Filament_.
    - 🎉 [Four](https://github.com/CodyJasonBennett/four) - Minimal three.js alternative.
    - 🎉 [Hilo3d](https://github.com/hiloteam/Hilo3d) - WebGL 3D rendering engine by _Alibaba_.
    - 🎉 [Litescene.js](https://github.com/jagenjo/litescene.js) - WebGL 3D engine library, used by WebGLStudio.
    - 🎉 [LUME](https://github.com/lume/lume) - Simplifies the creation of interactive 2D/3D experiences.
    - ⭐ [OGL](https://github.com/oframe/ogl) 🔥 - Fast, powerful, minimal WebGL library. [[Examples](https://oframe.github.io/ogl/examples)]
    - 🎉 [PicoGL.js](https://github.com/tsherif/picogl.js) - Minimal WebGL 2 rendering library. [[Examples](https://tsherif.github.io/picogl.js/)]
    - 🎉 [Pixi3D](https://github.com/jnsmalm/pixi3d) - 3D renderer for _PixiJS_, seamless integration with 2D apps. [[Examples](https://pixi3d.org/)]
    - 🎉 [RedGL](https://github.com/redcamel/RedGL2) - JavaScript 3D WebGL library.
    - 🎉 [Regl](https://github.com/regl-project/regl) - Fast functional WebGL.
    - 🎉 [SwissGL](https://github.com/google/swissgl) - Minimalistic wrapper on top of WebGL2.
    - 🎉 [ThingJS](https://github.com/uinosoft/t3d.js) - Lightweight, extendable 3D library, aka _t3d_.
    - 🎉 [Three.js](https://github.com/mrdoob/three.js/) 🔥 - General-purpose 3D library. [[Awesome](https://github.com/0xAxiome/awesome-threejs) | [Docs](https://threejs.org) | [Editor](https://threejs.org/editor/) | [Examples](https://threejs.org/examples/)]
    - 🎉 [TWGL](https://github.com/greggman/twgl.js) - Tiny WebGL helper Library. [[Examples](http://twgljs.org/)]
    - 📚 [WebGL Frameworks](https://en.wikipedia.org/wiki/List_of_WebGL_frameworks) - List of WebGL frameworks on Wikipedia.
    - 📚 [WebGL / WebGPU Frameworks](https://gist.github.com/76878ba6903cf15789b712464875cfdc) -  List of WebGL and WebGPU frameworks and libraries.
    - 🎉 [x3dom](https://github.com/x3dom/x3dom) - Integrate 3D content seamlessly into your webpage.
- JavaScript: Graphics - Three.js
    - 📚 [Discover Three.js](https://discoverthreejs.com) - Create stunning 3D web apps using Three.js.
    - 🌎 [SBcode Three.js Tutorials](https://sbcode.net/threejs/) - Fantastic examples with code and explanations of topics.
    - 🎉 [Sketch Three.js](https://github.com/ykob/sketch-threejs) - Interactive sketches made with Three.js.
    - 🎉 [Sketchbook](https://github.com/swift502/Sketchbook) - 3D playground built on Three.js and Cannon.js.
    - 🌎 [Stemkoski Three.js Examples](http://stemkoski.github.io/Three.js/) - Excellent set of instructive examples.
    - 📚 [Three.js Bookshelf](https://discourse.threejs.org/t/three-js-bookshelf/2468) - Nice collection of resources.
    - 📚 [Three.js Discourse Examples](https://hofk.de/main/discourse.threejs/) - Yearly collection of all examples posted on the Three.js forum.
    - 💰 [Three.js Journey](https://threejs-journey.com/) - Course teaching WebGL from beginner to advanced.
    - 📚 [Three.js Manual](https://threejs.org/manual/#en/fundamentals) - Fantastic articles and explanations. Formerly _ThreeJsFundamentals_.
    - 📚 [THREEx](https://github.com/jeromeetienne/threex) - Nice collection of open source game extensions.
- JavaScript: Graphics - Three.js - Addon
    - 🎉 [Custom Shader Material](https://github.com/FarazzShaikh/THREE-CustomShaderMaterial) - Extend Three.js materials with your own shaders.
    - 🎉 [irregular-grid](https://github.com/sketchpunklabs/irregular_grid) - Examples of generating and using irregular grids. [[Demos](https://sketchpunklabs.github.io/irregular_grid/)]
    - 🎉 [Lamina](https://github.com/pmndrs/lamina) - Extensible, layered shader material for Three.js.
    - ❓ [screen-space-reflections](https://github.com/0beqz/screen-space-reflections) - Screen space reflections in Three.js.
    - 🎉 [three-billboard-reflection](https://github.com/0beqz/three-billboard-reflection) - Performant plane reflections in Three.js.
    - 🎉 [three-mesh-bvh](https://github.com/gkjohnson/three-mesh-bvh) - Speed up raycasting and enable spatial queries on Meshes.
    - 🎉 [three-mesh-ui](https://github.com/felixmariotto/three-mesh-ui) - VR user interfaces for Three.js.
    - 🎉 [three-nebula](https://github.com/creativelifeform/three-nebula) - WebGL particle system for Three.js. [[Examples](https://three-nebula.org/examples/custom-renderer)]
    - 🎉 [three-projected-material](https://github.com/marcofugaro/three-projected-material) - Texture projection in Three.js.
    - 🎉 [three.ik](https://github.com/jsantell/THREE.IK) - Inverse kinematics for Three.js.
    - 🎉 [Troika JS - Derived Material](https://github.com/protectwise/troika/blob/master/packages/troika-three-utils/src/DerivedMaterial.js) - Extend existing Three.js materials. [[Docs](https://protectwise.github.io/troika/troika-three-utils/createDerivedMaterial/)]
    - 🎉 [voxelizer](https://github.com/andstor/voxelizer) - Voxelization of 3D models.
- JavaScript: Graphics - Three.js - React
    - 🎉 [drei](https://github.com/pmndrs/drei) - Useful helpers for react-three-fiber.
    - 🎉 [gltfjsx](https://github.com/pmndrs/gltfjsx) - Turns GLTFs into JSX components.
    - 🎉 [react-three-fiber](https://github.com/pmndrs/react-three-fiber) - React renderer for Three.js.
- JavaScript: Graphics - Three.js - Svelte
    - 🎉 [Threlte](https://github.com/threlte/threlte) - 3D framework and ecosystem for Svelte and Three.js. [[Website](https://threlte.xyz/)]
- JavaScript: Gui
    - 🎉 [Bootstrap](https://github.com/twbs/bootstrap) - Popular. Develop responsive, mobile first projects. [[Website](https://getbootstrap.com/)]
    - 🎉 [dat.GUI](https://github.com/dataarts/dat.gui) - Lightweight gui for changing variables in JavaScript.
    - 🎉 [Dojo](https://github.com/dojo/widgets) - Gui widgets for web apps.
    - 🎉 [Guify](https://github.com/colejd/guify) - Simple gui for changing JavaScript variables. [[Demo](https://jons.website/projects/guify/)]
    - 🎉 [GuiGui](https://github.com/superguigui/guigui) - Gui for tweaking stuff in JavaScript. [[Demo](https://superguigui.github.io/guigui/)]
    - 🎉 [Inferno](https://github.com/infernojs/inferno) - React-like library for building high-performance user interfaces.
    - 🎉 [jQuery UI](https://github.com/jquery/jquery-ui) - The official gui library for jQuery.
    - 🎉 [Leva](https://github.com/pmndrs/leva) - React-first components gui.
    - 🎉 [Magic Circle](https://github.com/dpwoert/magic-circle) - Multi-functional gui. Inspired by dat.GUI, Unity and Framer.
    - 🎉 [PCUI](https://github.com/playcanvas/pcui) - UI component library for the web by _PlayCanvas_.
    - 🎉 [Tweakpane](https://github.com/cocopon/tweakpane) - Compact gui for fine-tuning values.
    - 🎉 [uil](https://github.com/lo-th/uil) - Simple JavaScript gui.
    - 🎉 [w2ui](https://github.com/vitmalina/w2ui) - Gui widgets for modern web apps.
    - 🎉 [Zebkit](https://github.com/barmalei/zebkit) - Canvas rendered UI component libary.
- JavaScript: Input
    - 🎉 [Joycon.js](https://github.com/barhatsor/joycon.js) - JavaScript controller functionality.
    - ❓ [Mesekai](https://github.com/Neleac/Mesekai) - Real-time motion tracking.
    - 🎉 [use-gesture](https://github.com/pmndrs/use-gesture) - Utility for mouse / touch gestures in React and JavaScript.
    - 🔒 [WebAR.rocks.faceDepth](https://github.com/WebAR-rocks/WebAR.rocks.faceDepth) - Insert your face from your camera into a 3D scene.
- JavaScript: Layout
    - 📚 [Complete Guide to Flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) - Comprehensive guide to CSS flexbox layout.
    - 📚 [Complete Guide to Grid](https://css-tricks.com/snippets/css/complete-guide-grid/) - Comprehensive guide to CSS grid.
- JavaScript: Networking
    - 🎉 [Socket.io](https://github.com/socketio/socket.io) - Enables real-time bidirectional event-based communication.
    - 🎉 [WebRTC](https://webrtc.org/) - Supports video, voice, and generic data to be sent between peers.
- JavaScript: Physics
    - 🎉 [Ammo.js](https://github.com/kripken/ammo.js) - _Bullet 3D_ Physics engine ported as WebAssembly.
    - 🎉 [Box2d.js](https://github.com/kripken/box2d.js/) - Box2D to ported as WebAssembly.
    - 🎉 [Cannon-es](https://github.com/pmndrs/cannon-es) - Maintained fork of [Cannon.js](https://github.com/schteppe/cannon.js) 3D physics engine. [[Demos](https://pmndrs.github.io/cannon-es/)]
    - 🎉 [Goblin Physics](https://github.com/chandlerprall/GoblinPhysics) - 3D physics engine written from the ground up in JavaScript. [[Demos](http://www.goblinphysics.com/)]
    - 🎉 [JoltPhysics.js](https://github.com/jrouwe/JoltPhysics.js) - Port of _Jolt Physics_ to JavaScript (as WebAssembly). [[Demos](https://jrouwe.github.io/JoltPhysics.js/)]
    - 🎉 [Matter.js](https://github.com/liabru/matter-js) - Featured 2D physics engine for the web. [[Demos](https://brm.io/matter-js/)]
    - 🎉 [Oimo.js](https://github.com/lo-th/Oimo.js) - Lightweight 3D physics engine. [[Demos](http://lo-th.github.io/Oimo.js)]
    - 🎉 [p2.js](https://github.com/schteppe/p2.js) - 2D rigid body physics, by the creator of Cannon.js.
    - 🎉 [Particulate.js](https://github.com/jpweeks/particulate-js) - Particle physics library designed to be simple, fast and stable.
    - 🎉 [Planck.js](https://github.com/shakiba/planck.js) - JavaScript rewrite of the _Box2D_ physics engine. [[Demos](https://piqnt.com/planck.js/)]
    - 🎉 [Physijs](https://github.com/chandlerprall/Physijs) - Physics plugin for Three.js
    - 🎉 [Rapier](https://rapier.rs/docs/user_guides/javascript/getting_started_js) - Rust 2D/3D physics libary focused on performance, ported as WebAssembly.
    - 🎉 [Verly.js](https://github.com/anuraghazra/Verly.js) - Easy to integrate verlet physics engine. [[Demos](https://anuraghazra.dev/Verly.js/)]
- JavaScript: Utility
    - 🎉 [Clipboard.js](https://github.com/zenorocha/clipboard.js) - Small, modern copy to clipboard.
    - 🎉 [Day.js](https://github.com/iamkun/dayjs) - Fast 2kB alternative to [Moment.js](https://github.com/moment/moment) with the same modern API.
    - 🎉 [i18next](https://github.com/i18next/i18next) - Popular internationalization framework.
    - 🎉 [jQuery](https://github.com/jquery/jquery) - Fast and feature-rich JavaScript library. [[Website](https://jquery.com)]
    - 🎉 [PreloadJS](https://github.com/CreateJS/PreloadJS) - Preloading assets w/progress events.
    - 🎉 [Struct Vec](https://github.com/moomoolive/struct-vec) - JavaScript array-like containers for multithreading.
- JavaScript: Timeline
    - 🎉 [Frame.js](https://github.com/mrdoob/frame.js/) - JavaScript sequence editor.
    - 🎉 [Neo](https://github.com/lo-th/neo) - Timeline for JavaScript. [[Demo](http://lo-th.github.io/neo/)]
- JavaScript: Video
    - 💸 [Remotion](https://github.com/remotion-dev/remotion) - Create videos programmatically in React. [[Website](https://www.remotion.dev/)]
- JavaScript: Visual Programming / Nodes
    - 🎉 [Butterfly](https://github.com/alibaba/butterfly) - Diagramming library concentrated on flow and field layout by _Alibaba_.
    - 🎉 [Drawflow](https://github.com/jerosoler/Drawflow) - Simple JavaScript flow library. [[Demo](https://jerosoler.github.io/Drawflow/)]
    - 🎉 [Flow](https://github.com/sunag/flow) - Node-graph library.
    - 🎉 [Litegraph.js](https://github.com/jagenjo/litegraph.js) - Create graphs in the browser similar to Unreal Blueprints. [[Demo](https://tamats.com/projects/litegraph/editor/)]
    - 🎉 [Node-RED](https://github.com/node-red/node-red) - Low-code programming for event-driven applications.
    - 🎉 [Nodl](https://github.com/emilwidlund/nodl) - Framework for computational node graphs.
    - 🎉 [Rete.js](https://github.com/retejs/rete) - Framework for visual programming and node editors. [[Demo](https://rete.js.org/#/examples/basic)]

### Kotlin
- 📚 [Awesome Kotlin](https://github.com/KotlinBy/awesome-kotlin) - List of awesome Kotlin related stuff.
- 🌎 [Kotlin](https://kotlinlang.org/) - General-purpose language, interoperates with Java. [[GitHub](https://github.com/JetBrains/kotlin)]
- Kotlin: Game Engine w/Editor
    - 🎉 [KorGE](https://github.com/korlibs/korge) - Multi-platform 2D game engine for Kotlin. [[Website](https://korge.org/)]
- Kotlin: Game Framework
    - 🎉 [FXGL](https://github.com/AlmasB/FXGL) - Game library for 2D, experimental 3D.
    - 🎉 [Kool](https://github.com/fabmax/kool) - Multi-platform 3D Vulkan / OpenGL graphics engine. [[Examples](https://fabmax.github.io/kool/kool-js/)]
    - 🎉 [KTX](https://github.com/libktx/ktx) - Kotlin extensions for the _libGDX_ game framework.

### Pascal
- 📚 [Awesome Pascal](https://github.com/Fr0sT-Brutal/awesome-pascal) - Curated list of Delphi / Pascal resources.
- 📚 [Delphi](https://en.wikipedia.org/wiki/Delphi_(software)) - Pascal dialect and popular IDE with cross-platform support.
- 🌎 [Free Pascal](https://www.freepascal.org/) - Mature, open source Pascal compiler.
- 📚 [Pascal Tutorials](https://www.tutorialspoint.com/pascal/index.htm) - Simple and easy Pascal tutorials.
- Pascal: Game Engine w/Editor
    - 🎉 [Castle](https://github.com/castle-engine/castle-engine) - Cross-platform 2D/3D game engine and editor. [[Website](https://castle-engine.io/)]
- Pascal: Game Framework
    - 🎉 [Apus](https://github.com/Cooler2/ApusGameEngine) - Cross-platform library for making 2D games.
- Pascal: Physics
    - 🎉 [Kraft](https://github.com/BeRo1985/kraft) - Object Pascal 3D physics engine.

### Python
- 📚 [Awesome Python](https://github.com/vinta/awesome-python) - List of awesome Python frameworks, libraries, software and more.
- 🌎 [Python.org](https://www.python.org) - Programming language that lets you work quickly. [[Docs](https://www.python.org/doc/)]
- Python: App Framework
    - 🎉 [Pyglet](https://github.com/pyglet/pyglet) - Windowing and multimedia library intended for game development.
- Python: Cross-Platform
    - 💸 [Anvil](https://anvil.works) - Full stack web apps with nothing but Python.
    - 🎉 [Brython](https://github.com/brython-dev/brython) - Python 3 running in the browser.
- Python: Game Framework
    - 🎉 [Arcade](https://github.com/pythonarcade/arcade) - Easy to use library for creating 2D arcade games.
    - 🎉 [Panda3D](https://github.com/panda3d/panda3d) - Powerful, mature game engine, developed by Disney and CMU. [[Website](https://www.panda3d.org)]
    - 🔒 [Pygame](https://github.com/pygame/pygame) - Game & multimedia app framework, built on _SDL_.
    - 🎉 [Pygcurse](https://github.com/asweigart/pygcurse) - [Curses-like](https://en.wikipedia.org/wiki/Curses_%28programming_library%29) library for text adventures / roguelikes. [[Website](http://inventwithpython.com/pygcurse/)]
- Python: Gui
    - 🎉 [Kivy](https://github.com/kivy/kivy) - Cross-platform gui framework. [[Website](https://kivy.org/)]

### Ruby
- 📚 [Awesome Ruby](https://github.com/markets/awesome-ruby) - Collection of awesome Ruby libraries, tools, frameworks and software.
- 🌎 [Ruby](https://www.ruby-lang.org/en/) - Dynamic programming language, focused on simplicity / productivity. [[GitHub](https://github.com/ruby/ruby)]
- Ruby: Framework
    - 🎉 [Ruby on Rails](https://github.com/rails/rails) - Web app framework. [[Website](https://rubyonrails.org)]
- Ruby: Game Framework
    - 🎉 [Ruby 2D](https://github.com/ruby2d/ruby2d) - Make cross-platform 2D apps.
- Ruby: Graphics - 3D
    - 🎉 [Mittsu](https://github.com/danini-the-panini/mittsu) - 3D graphics library based heavily on _Three.js_.
- Ruby: Gui
    - 🎉 [Glimmer](https://github.com/andyobtiva/glimmer) - Gui library and DSL (domain specific language) framework.
    - 🎉 [Shoes](https://github.com/shoes/shoes4) - Cross-platform gui library. [[Website](http://shoesrb.com/)]

### Rust
- 📚 [Awesome Rust](https://github.com/rust-unofficial/awesome-rust) - Curated list of Rust code and resources.
- 🌎 [Rust](https://www.rust-lang.org) - Empowering everyone to build quality software. [[Docs](https://www.rust-lang.org/learn) | [GitHub](https://github.com/rust-lang)]
- Rust: App Framework
    - 🎉 [Makepad](https://github.com/makepad/makepad) - Software development platform and native-rendering gui framework. [[Editor](https://makepad.dev/)]
    - 🎉 [Tao](https://github.com/tauri-apps/tao) - Cross-platform windowing. [[Docs](https://docs.rs/tao/latest/tao/)]
- Rust: Audio
    - 🎉 [Kira](https://github.com/tesselode/kira) - Create expressive audio for games.
- Rust: Game Engine w/Editor
    - 🎉 [Fyrox](https://github.com/FyroxEngine/Fyrox) - 2D/3D game engine with editor. Formerly _Rg3d_. [[Website](https://fyrox.rs/)]
- Rust: Game Framework
    - 🎉 [Ambient](https://github.com/AmbientRun/Ambient) - Multiplayer game engine.
    - 🎉 [Amethyst](https://github.com/amethyst/amethyst) - Data-driven 2D/3D game engine aiming to be fast and configurable.
    - 🎉 [Bevy](https://github.com/bevyengine/bevy) 🔥 - Refreshingly simple data-driven 2D/3D game engine. [[Website](https://bevyengine.org)]
    - 🎉 [Macroquad](https://github.com/not-fl3/macroquad) - Easy to use game library, heavily inspired by _RayLib_.
- Rust: Graphics - 3D
    - 🎉 [Ash](https://github.com/ash-rs/ash) - Vulkan bindgins for Rust.
    - 🎉 [Glium](https://github.com/glium/glium) - Safe wrapper arount the OpenGL API.
    - 🎉 [Kiss3D](https://github.com/sebcrozet/kiss3d) - Keep it simple, stupid 3D graphics engine.
    - 🎉 [Miniquad](https://github.com/not-fl3/miniquad) - Cross platform rendering.
    - 🎉 [Vulkano](https://github.com/vulkano-rs/vulkano) - Safe and rich wrapper around the Vulkan API.
- Rust: Gui
    - 🔒 [Azul](https://github.com/fschutt/azul) - Desktop gui framework.
    - 🎉 [Dioxus](https://github.com/dioxuslabs/dioxus) - Cross-platform, React-like gui library.
    - 🎉 [Druid](https://github.com/linebender/druid) - Data-first gui design toolkit.
    - 🎉 [egui](https://github.com/emilk/egui) - Easy to use immediate mode gui. Runs on web and native. [[Demo](https://www.egui.rs/)]
    - 🔒 [Slint](https://github.com/slint-ui/slint) - Gui toolkit for embedded / desktop. Formerly _SixtyFPS_. [[Website](https://slint-ui.com/)]
- Rust: Physics
    - 🎉 [Rapier](https://github.com/dimforge/rapier) - 2D/3D physics engines focused on performance. [[Docs](https://rapier.rs)]

### Zig
- 📚 [Awesome Zig](https://github.com/nrdmn/awesome-zig) - Curated list of Zig code and resources.
- 🌎 [Zig](https://ziglang.org/) - General-purpose language and toolchain. [[Docs](https://ziglang.org/documentation/master/) | [GitHub](https://github.com/michal-z/zig)]
- 📚 [Ziglings](https://github.com/ratfactor/ziglings) - Learn the Zig programming language by fixing tiny broken programs.
- Zig: App Framework
    - 🎉 [Upaya](https://github.com/prime31/zig-upaya) - Framework for creating game tools and helper apps.
- Zig: File System
    - 🎉 [Known Folders](https://github.com/ziglibs/known-folders) - Provides access to well-known folders across several operating systems.
- Zig: Game Engine w/Editor
    - 🎉 [Mach](https://github.com/hexops/mach) - Game engine & graphics toolkit. [[Examples](https://machengine.org/gpu/)]
- Zig: Game Framework
    - 🎉 [Zig-Gamedev Project](https://github.com/michal-z/zig-gamedev) - Sample apps and libraries using DirectX 12.
- Zig: Graphics - 2D
    - 🎉 [Mini Pixel](https://github.com/fabioarnold/MiniPixel) - Tiny pixel art editor. [[Download](https://fabioarnold.itch.io/mini-pixel)]
    - 🔒 [Pixi](https://github.com/foxnne/pixi) - Pixel art editor.
- Zig: Scripting
    - 🎉 [Cyber](https://github.com/fubark/cyber) - Fast, efficient, and concurrent scripting language.

<br />
<br />

## Open Source Games
_Successful open source video games to pick apart and gain knowledge._

### Awesome Collections
- 📚 [Quake Engines](https://quakeengines.github.io/) - List of repositories of idTech engines, it's derivatives and sourceports.

### C
- 🔒 [Doom](https://github.com/id-Software/DOOM) - The original 1993 3D masterpiece by _id Software_.
- 🔒 [Gish](https://github.com/blinry/gish) - Open Source version of the award-winning physics platformer. [[Steam](https://store.steampowered.com/app/9500/Gish/)]
- 💸 [Handmade Hero](https://handmadehero.org/) - Videos on making a game from start to finish, source code for $15.

### C++
- 🔒 [Doom 3](https://github.com/id-Software/DOOM-3) - Doom 3 GPL source release.
- 🔒 [Dungeon Crawl: Stone Soup](https://github.com/crawl/crawl) - Classic roguelike adventure. [[Play](https://crawl.develz.org/)]
- 🎉 [Etheral Legends](https://github.com/Soverance/EtherealLegends) - Indie Action RPG built with _Unreal Engine 4_. [[Steam](https://store.steampowered.com/app/428980/Ethereal_Legends/)]
- 🎉 [OpenLara](https://github.com/XProger/OpenLara) - Classic Tomb Raider open source engine. [[Play](http://xproger.info/projects/OpenLara/)]
- 🎉 [TeeWorlds](https://github.com/teeworlds/teeworlds) - Retro multiplayer shooter. [[Website](https://teeworlds.com/)]
- 🔒 [zDoom](https://github.com/ZDoom/gzdoom) - Modern, feature centric port for all Doom engine games.

### Java
- 🔒 [Pixel Dungeon](https://github.com/watabou/pixel-dungeon) - Traditional roguelike game with pixel-art graphics and simple interface.

<br />
<br />

## Specialty Topics
_Exploring specialty game engine / game development topics and features._

### AI / Pathfinding
- 📚 [Intro to AI](https://www.raywenderlich.com/2808-introduction-to-ai-programming-for-games) - Intro to AI Programming for Games at RayWenderlich.com.
- 📚 [Beginner's Guide to Game AI](https://www.gamedev.net/tutorials/programming/artificial-intelligence/the-total-beginners-guide-to-game-ai-r4942/) - Intro to concepts used in AI for games.

### Color Manipulation
- 📚 [How to Choose Colors Procedurally](http://devmag.org.za/2012/07/29/how-to-choose-colours-procedurally-algorithms/) - Procedural palettes and how to generate them.
- 📚 [Red, Yellow, and Blue](https://daveeddy.com/2014/07/01/red-yellow-and-blue/) - Convert colors from the paint color wheel to RGB space. [[Source](https://github.com/bahamas10/ryb)]

### Entity Component Systems
- 📚 [A Simple Entity Component System](https://austinmorlan.com/posts/entity_component_system/) - Basis for an ECS in C++.
- 📚 [Evolve Your Hierarchy](https://cowboyprogramming.com/2007/01/05/evolve-your-heirachy/) - Overview of ECSs and why to use them, at [Cowboy Programming](https://cowboyprogramming.com).
- 📚 [Intro to Component-Based Architecture in Games](https://www.raywenderlich.com/2806-introduction-to-component-based-architecture-in-games) - Component-based architecture.
- 📚 [Nomad Game Engine](https://savas.ca/nomad) - Articles building an ECS from the ground up in C++. [[Source](https://github.com/taurheim/NomadECS)]
- 📚 [What's an Entity System](http://entity-systems.wikidot.com) - Overview of ECSs, how they are used in game development.

### Fluid / Smoke
- 📚 [Fluid Simulation on the GPU](https://developer.nvidia.com/gpugems/gpugems/part-vi-beyond-triangles/chapter-38-fast-fluid-dynamics-simulation-gpu) - GPU Gems Chapter 38 - Fast, stable fluid simulation on the GPU.
- 🔒 [Fluids-2D](https://www.csc.kth.se/~mathar/fluids-2d/) - Real-time fluid dynamics on the GPU with the help of WebGL and Three.js. [[Source](https://github.com/mharrys/fluids-2d)]
- 🔒 [GPU Fluid Experiments](http://haxiomic.github.io/GPU-Fluid-Experiments/html5/) - Cross-platform GPU fluid simulation. [[Source](https://github.com/haxiomic/GPU-Fluid-Experiments)]
- 🎉 [WebGL Fluid Simulation](https://paveldogreat.github.io/WebGL-Fluid-Simulation/) - Play with fluids in your browser (even on mobile). [[Source](https://github.com/PavelDoGreat/WebGL-Fluid-Simulation)]

### Geometry
- CSG (Constructive Solid Geometry)
    - 📚 [Constructive Solid Geometry](https://en.wikipedia.org/wiki/Constructive_solid_geometry) - Technique using boolean operations to combine primitive objects.
    - 🎉 [csg.js](https://github.com/evanw/csg.js/) - JavaScript library implementing CSG. [[Examples](https://evanw.github.io/csg.js/)]
    - 🎉 [three-bvh-csg](https://github.com/gkjohnson/three-bvh-csg) - Fast and dynamic CSG on top of three-mesh-bvh.
    - 🎉 [three-csgmesh](https://github.com/manthrax/THREE-CSGMesh) - Conversion of the csg.js library for use with Three.js.
- Meshes
    - 📚 [Geometry, Surfaces, Curves, Polyhedra](https://paulbourke.net/geometry/) - Geometry topics including meshes, shapes, textures and more.
    - 📚 [Mesh Transforms](https://ciechanow.ski/mesh-transforms/) - _Apple_'s private API for manipulation of UIView meshes. [[Source](https://github.com/olegtyshcneko/CAMeshTransform)]
- Smoothing
    - 📚 [Laplacian Smoothing](http://rodolphe-vaillant.fr/entry/70/laplacian-smoothing-c-code-to-smooth-a-mesh) - Draft notes with C++ code for laplacian smoothing of meshes.
    - 📚 [Subdivision at Matt's Webcorner](http://graphics.stanford.edu/~mdfisher/subdivision.html) - Smoothing with subdivision surfaces.
    - 📚 [Subdivision Surfaces](http://www.holmes3d.net/graphics/subdivision/) - Explanations of different schemes used in subdivision surfaces.

### Hair
- 📚 [Fuzzy Meshes](https://medium.com/@Zadvorsky/fuzzy-meshes-4c7fd3910d6f) - Simulating fur with cones and gravity. [[Source](https://github.com/zadvorsky/three-fuzzy-mesh)]

### Lighting / Shadows
- Gamma
    - 📚 [What Every Coder Should Know About Gamma](https://blog.johnnovak.net/2016/09/21/what-every-coder-should-know-about-gamma/) - Light emission vs perceptual brightness.
- Lighting 2D
    - 📚 [Gleaner Heights: 2D Lighting](http://gleanerheights.blogspot.com/2017/05/lighting-in-2d-games-shader-glsl.html?m=1) - Simple intro to 2D lighting in a game with GLSL.
- Lighting 3D
    - 📚 [Basic Lighting](https://learnopengl.com/Lighting/Basic-Lighting) - 3D lighting article by _LearnOpenGL_.
    - 📚 [Forward Rendering vs. Deferred Rendering](https://gamedevelopment.tutsplus.com/articles/forward-rendering-vs-deferred-rendering--gamedev-12342) - Techniques for handling many lights.
    - 📚 [Forward+ Rendering / Tiled Forward Shading](https://www.3dgep.com/forward-plus/) - Forward rendering with tiled light culling.
- Shadows 2D
    - 📚 [2D Pixel Perfect Shadows](https://github.com/mattdesl/lwjgl-basics/wiki/2D-Pixel-Perfect-Shadows) - An approach to 2D pixel-perfect lights / shadows using shaders.
    - 📚 [2D Visibility](https://www.redblobgames.com/articles/visibility/) - Excellent interactive tutorial on 2D visibility.
    - 📚 [Fast 2D shadows in Unity](https://www.gamedeveloper.com/programming/fast-2d-shadows-in-unity-using-1d-shadow-mapping) - Adapting 3D rendering techniques to achieve fast 2D shadows.
    - 📚 [Sight & Light](https://ncase.me/sight-and-light/) - How to create 2D visibility / shadow effects for your game. [[Source](https://github.com/ncase/sight-and-light)]
    - 📚 [Symmetric Shadowcasting](https://www.albertford.com/shadowcasting/) - Common technique for calculating field of view.
- Shadows 3D
    - 📚 [Efficient Soft-Edged Shadows](https://developer.nvidia.com/gpugems/gpugems2/part-ii-shading-lighting-and-shadows/chapter-17-efficient-soft-edged-shadows-using) - GPU Gems 2 Chapter 17.
    - 📚 [Screen Space Shadows](https://panoskarabelas.com/posts/screen_space_shadows/) - Great exploration of screen space shadows.
    - 📚 [Shadow Mapping](https://en.m.wikipedia.org/wiki/Shadow_mapping) - Shadow mapping and the techniques used to acheive it.
- Volumetric
    - 🌎 [Threex Volumetric Spotlight](http://jeromeetienne.github.io/threex.volumetricspotlight/examples/basic.html) - Great example of volumetric lighting with Three.js. [[Source](https://github.com/jeromeetienne/threex.volumetricspotlight)]

### Network
- 📚 [Source Multiplayer Networking](https://developer.valvesoftware.com/wiki/Source_Multiplayer_Networking) - _Valve_'s Source Engine multiplayer system.

### Particles
- 📚 [Particles](https://learnopengl.com/In-Practice/2D-Game/Particles) - Article by _LearnOpenGL_.
- 📚 [Soft Particles](https://keaukraine.medium.com/implementing-soft-particles-in-webgl-and-opengl-es-b968d61133b0) - Implementing soft particles in WebGL.

### Physics
- 📚 [Fix Your Timestep!](https://gafferongames.com/post/fix_your_timestep/) 🔥 - How to keep physics stable with variable fps.
- 📚 [Game Physics from Scratch](https://brm.io/game-physics-for-beginners/) - Starting resource for game physics.
- 📚 [Intro to Physics](https://www.toptal.com/game/video-game-physics-part-i-an-introduction-to-rigid-body-dynamics) - Part I: Intro to Rigid Body Dynamics.
- 📚 [Open Source Physics Engines](https://www.tapirgames.com/blog/open-source-physics-engines) - List of open source physics engines.
- Platformer
    - 📚 [2D Physics Games](https://www.gamedeveloper.com/design/how-to-create-2d-physics-games-with-box2d-library) - Using Box2D for water, ropes, gravity, lines, vehicles, etc.
    - 📚 [Basic 2D Platformer Physics](https://gamedevelopment.tutsplus.com/series/basic-2d-platformer-physics--cms-998) - How to create a physics system for a platformer.
- Ropes / Chains
    - 📚 [Draw SVG rope using JavaScript](https://muffinman.io/blog/draw-svg-rope-using-javascript/) - SVG path vector rope drawing.
    - 📚 [Ropes in Contraption Maker](https://www.gamedeveloper.com/design/ropes-in-contraption-maker) - Implementing the physics of ropes in _Contraption Maker_.
    - 🌎 [Matter.js: Chains](https://brm.io/matter-js/demo/#chains) - Chains demo using _Matter.js_. [[Source](https://github.com/liabru/matter-js/blob/master/examples/chains.js)]
- Soft Body
    - 📚 [Blob Physics](https://cowboyprogramming.com/2007/01/05/blob-physics/) - Using verlet physics to simulate 2D blobs.
    - 🌎 [Oryol: Bullet Cloth](https://floooh.github.io/oryol-samples/wasm/BulletPhysicsCloth.html) - _Bullet 3D_ physics cloth using the _Oryol_ game framework. [[Source](https://github.com/floooh/oryol-samples/blob/master/src/BulletPhysicsCloth/BulletPhysicsCloth.cc)]
    - 🌎 [Three.js: Ammo Volume](https://threejs.org/examples/?q=physics#physics_ammo_volume) - 3D soft body volumes using _Ammo.js_ and _Three.js_. [[Source](https://github.com/mrdoob/three.js/blob/master/examples/physics_ammo_volume.html)]
- Verlet Physics
    - 📚 [Making a Verlet Physics Engine](https://medium.com/m/global-identity?redirectUrl=https%3A%2F%2Fbetterprogramming.pub%2Fmaking-a-verlet-physics-engine-in-javascript-1dff066d7bc5) - Under the hood of a 2D physics engine in JavaScript.
- Water / Buoyancy
    - 📚 [2D Water](https://prime31.github.io/water2d-part1/) - Modeling 2D water with springs.

### Rendering
- 📚 [GPU Driven Rendering](https://vkguide.dev/docs/gpudriven/gpu_driven_engines/) - Calculating rendering on the GPU in compute shaders.
- 📚 [Model Batching](https://webglfundamentals.org/webgl/lessons/webgl-qna-drawing-many-different-models-in-a-single-draw-call.html) - Drawing many different models in a single draw call.

### Scripting
- 📚 [Adding Languages to Game Engines](https://www.gamedeveloper.com/programming/adding-languages-to-game-engines) - Story of adding scripting to a game.
- 📚 [Implementing a Scripting Engine](https://www.flipcode.com/archives/Implementing_A_Scripting_Engine-Part_1_Overview.shtml) - Writting a scripting engine from scratch.
- 📚 [Embedded Scripting Languages](https://caiorss.github.io/C-Cpp-Notes/embedded_scripting_languages.html) - Scripting languages and engines available as libraries.
- 📚 [List of Embedded Scripting Languages](https://github.com/dbohdan/embedded-scripting-languages) - Scripting languages to use in your app / game.
- 📚 [Scriptorium](https://github.com/r-lyeh-archived/scriptorium) - Game scripting languages benchmarked.

### Shaders
- 📚 [3D Game Shaders For Beginners](https://lettier.github.io/3d-game-shaders-for-beginners/index.html) 🔥 - Shaders to improve your games. [[Source](https://github.com/lettier/3d-game-shaders-for-beginners)]
- 📚 [Book of Shaders](https://thebookofshaders.com) 🔥 - Step-by-step guide through [Fragment Shaders](https://www.khronos.org/opengl/wiki/Fragment_Shader). [[Source](https://github.com/patriciogonzalezvivo/thebookofshaders)]
- 🎉 [CrossShader](https://github.com/alaingalvan/CrossShader) - Cross-compiling shaders between GLSL, HLSL, Metal, and more. [[Online Tool](https://alain.xyz/libraries/crossshader)]
- 🌎 [Geeks3D Shader Library](https://www.geeks3d.com/shader-library/) - Postprocessing, lighting, utlities and many more.
- 📚 [Review of Shader Languages](https://alain.xyz/blog/a-review-of-shader-languages) - Differences between HLSL, GLSL, MSL, and WGSL.
- 📚 [Ronja Tutorials](https://www.ronja-tutorials.com/) - Tutorials covering many shader techniques.
- 🌎 [Shader Park](https://github.com/shader-park/shader-park-core) - Shader programming in JavaScript.
- 🌎 [SHADERed](https://github.com/dfranx/SHADERed) - Shader IDE, written in C++.
- 🌎 [Shadertoy](https://www.shadertoy.com) - Build and share shaders online.
- Bloom
    - 📚 [LearnOpenGL Tutorial](https://learnopengl.com/Advanced-Lighting/Bloom) - Techniques used for bloom lighting, presented in OpenGL.
    - 🌎 [Three.js: Bloom Example](https://threejs.org/examples/?q=bloom#webgl_postprocessing_unreal_bloom) - WebGL bloom postprocessing using _Three.js_. [[Source](https://github.com/mrdoob/three.js/blob/master/examples/webgl_postprocessing_unreal_bloom.html)]
    - 📚 [Unity Tutorial](https://catlikecoding.com/unity/tutorials/advanced-rendering/bloom/) - How to add support for a bloom effect.
- Dithering
    - 📚 [Dithering on the GPU](http://alex-charlton.com/posts/Dithering_on_the_GPU/) - Ordered dithering in glsl using 8x8 Bayer Dithering.
- Fire
    - 📚 [Fire Shader in GLSL](https://clockworkchilli.com/blog/8_a_fire_shader_in_glsl_for_your_webgl_games) - Fire intro shader using noise textures and masking.
    - 🌎 [Simplex 3D Noise](https://www.shadertoy.com/view/MllfDn) - Simplex noise fire simulation shader at ShaderToy.
- Lines
    - 📚 [Drawing Lines](https://mattdesl.svbtle.com/drawing-lines-is-hard) - Techniques for 2D/3D line rendering.
- Noise
    - 📚 [Book of Shaders: Noise](https://thebookofshaders.com/11/) - Excellent GLSL noise article by Book of Shaders.
    - 📚 [Color Banding](https://shader-tutorial.dev/advanced/color-banding-dithering/) - Using noise / dithering to improve drawing gradients.
    - 🎉 [Psrdnoise](https://github.com/stegu/psrdnoise/) - Tiling simplex flow noise in 2D/3D.
    - 📚 [Understanding Perlin Noise](http://adrianb.io/2014/08/09/perlinnoise.html) - Analysis of Perlin Noise, written in C#. [[Source](https://gist.github.com/Flafla2/f0260a861be0ebdeef76)]
    - 🎉 [WebGL Noise](https://github.com/stegu/webgl-noise/) - Maintained branch of the original _Ashima Arts_ 2D, 3D and 4D noise functions.
- Outlines
    - 🌎 [Fast Solid 2D Outline](https://www.shadertoy.com/view/XdV3Dc) - Drawing an outline on the alpha channel of a 2D image.
    - 📚 [Let it glow!](http://blogs.love2d.org/content/let-it-glow-dynamically-adding-outlines-characters) - Article with shader code on dynamically adding outlines to characters.
    - 🎉 [Outline Shader](https://www.reddit.com/r/godot/comments/8g067a/the_perfect_outline_shader_atleast_close/) - Nice outline shader. [[Source](https://github.com/steincodes/godot-shader-tutorials)]
    - 📚 [Outlines w/Surface IDs](https://omar-shehata.medium.com/better-outline-rendering-using-surface-ids-with-webgl-e13cdab1fd94) - Technique combining depth, normals and surface IDs. [[Source](https://github.com/OmarShehata/webgl-outlines)]
    - 📚 [Sketchy Outling](https://lettier.github.io/3d-game-shaders-for-beginners/outlining.html) - Article on producing a sketchy outline look.
- Pixelation
    - 📚 [Pixel Art Shaders](https://alaingalvan.tumblr.com/post/79829067408/glsl-pixel-art-shaders) - Useful GLSL postprocessing shaders for pixel art games.
    - 🌎 [Three.js: Pixelation Example](https://threejs.org/examples/?q=pixel#webgl_postprocessing_pixel) - WebGL pixelation postprocessing using _Three.js_. [[Source](https://github.com/mrdoob/three.js/blob/master/examples/webgl_postprocessing_pixel.html)]
- Postprocessing
    - 📚 [Image Editor Effects](https://alain.xyz/blog/image-editor-effects) - WebGL image filters / effects shaders. [[Source](https://github.com/alaingalvan/image-editor-effects)]
- Upscaling
    - 📚 [How do I perform an xBR or hqx filter in XNA?](https://gamedev.stackexchange.com/questions/87275/how-do-i-perform-an-xbr-or-hqx-filter-in-xna/87821#87821) - Upscaling shader code.
    - 📚 [hqx](https://en.wikipedia.org/wiki/Hqx) - Wikipedia article about the hqx pixel art upscaling algorithm developed by Maxim Stepin.
- Water / Refraction
    - 📚 [2D Water Shader](https://rotatingcanvas.com/fragment-shader-to-simulate-water-surface-in-libgdx/) - GLSL fragment shader to simulate 2D water surface in _libGDX_.
- Wireframe
    - 📚 [Flat and Wireframe Shading](https://catlikecoding.com/unity/tutorials/advanced-rendering/flat-and-wireframe-shading/) - Flat shading / wireframes using Barycentric Coordinates.

### Signed Distance Fields
- 📚 [2D SDFs](https://iquilezles.org/www/articles/distfunctions2d/distfunctions2d.htm) - Signed distance functions for basic 2D primitives.
- 📚 [3D SDFs](https://iquilezles.org/www/articles/distfunctions/distfunctions.htm) - Signed distance functions for basic 3D primitives.
- 📚 [CSG w/SDFs](https://jasmcole.com/2019/10/03/signed-distance-fields/) - Using circular SDFs to build 3D objects with CSG. [[Source](https://github.com/jasmcole/Blog/tree/master/CSG)]
- 📚 [Basic 2D SDFs](https://www.ronja-tutorials.com/post/034-2d-sdf-basics/) - Basics of rendering 2D shapes with SDFs in shaders.
- 📚 [Bezier Strokes](https://vladjuckov.github.io/beziers-sdf/) - Blog post on rendering bezier strokes with SDFs.
- 📚 [Signed Distance Field Resources](https://github.com/CedricGuillemet/SDF) - Tutorials, papers, software, demos, discussions, etc.
- 🎉 [SDF Mesh Generation](https://github.com/fogleman/sdf) - Python API to generate 3D meshes with SDFs.

### Tiling
- 📚 [Auto-Tile](https://gamedevelopment.tutsplus.com/tutorials/how-to-use-tile-bitmasking-to-auto-tile-your-level-layouts--cms-25673) - How to use tile bitmasking to auto-tile your level layouts.
- 📚 [List of Eucliden Uniform Tilings](https://en.wikipedia.org/wiki/List_of_Euclidean_uniform_tilings) - Wikipedia article on uniform tiling, space-filling polygons.
- 📚 [Space-Filling Polyhedron](https://mathworld.wolfram.com/Space-FillingPolyhedron.html) - [Polyhedra](https://en.wikipedia.org/wiki/Category:Space-filling_polyhedra), 3D polygons that fill space. [[5 Space-Filling Polyhedra](https://www.steelpillow.com/polyhedra/five_sf/five.html)]

### Transparency
- 📚 [Depth Peeling](https://developer.download.nvidia.com/assets/gamedev/docs/OrderIndependentTransparency.pdf) - Method for order-independent transparency.
- 📚 [Intro to Order-Independent Transparency](https://learnopengl.com/Guest-Articles/2020/OIT/Introduction) - Article by _LearnOpenGL_.
- 📚 [Weighted, Blended](http://casual-effects.blogspot.com/2015/03/implemented-weighted-blended-order.html) - Method for order-independent transparency.

<br />
<br />

## Tools / Software
_Software to help with game engine / video game development._

### 2D Game Dev
- 🆓 [ShoeBox](http://renderhjs.net/shoebox/) - Drag & drop tools for sprite sheets, bitmap fonts, texture ripping, tile maps and more.
- 💰 [Sprite Illuminator](https://www.codeandweb.com/spriteilluminator) - Create stunning light effects with 2D sprites in your game engine.
- 💰 [Texture Packer](https://www.codeandweb.com/texturepacker) - Create sprite sheets and optimize your game graphics.
- 🆓 [Tiled](https://www.mapeditor.org) - General-purpose tile map editor for all tile-based games. [[Source](https://github.com/mapeditor/tiled)]

### AI Assistants
- 💸 [Coplay](https://www.coplay.dev?ref=github&utm_source=stevinz_awesome_game_engine_dev) - Multi-agent AI Assistant for all aspects of Unity game developement.
- 💸 [Unity Muse](https://unity.com/products/muse) - Unity's suite of AI products.

### Animation Software
- 💸 [Cascadeur](https://cascadeur.com) - 3D animation software for physics-based character animation.
- 🆓 [DragonBones](https://dragonbones.github.io/en/index.html) - Open source 2D game skeletal animation solution. [[Source](https://github.com/DragonBones/)]
- 💸 [Mixamo](https://www.mixamo.com/#/) - Animate 3D characters for games, films and more. By _Adobe_.
- 💸 [Spine](http://esotericsoftware.com/) - 2D animation for games.

### Audio Tools
- Music
    - 🆓 [Ardour](https://ardour.org) - Record, edit, and mix. [[Source](https://github.com/Ardour/ardour)]
    - 🆓 [Audacity](https://www.audacityteam.org) - Multi-track audio editor and recorder. [[Source](https://github.com/audacity/audacity)]
    - 🆓 [Bosca Ceoil](https://boscaceoil.net) - Easy to use tool for creating music.
    - 🆓 [Cakewalk](https://www.bandlab.com/products/cakewalk) - Complete music production package.
    - 🆓 [FamiStudio](https://famistudio.org) - Music editor targeted at chiptune artists and NES homebrewers. [[Source](https://github.com/BleuBleu/FamiStudio)]
    - 💸 [fmod](https://www.fmod.com) - Popular (_Hades_, _Celeste_, _Untitled Goose Game_) audio software for games.
    - 🆓 [LMMS](https://lmms.io) 🔥 - Cross-platform music production software. [[Source](https://github.com/lmms/lmms)]
    - 🆓 [Sound Box](https://sb.bitsnbites.eu) - Compose synthetic music in your browser, good for small demos. [[Source](https://github.com/mbitsnbites/soundbox)]
    - 🆓 [ZzFXM](https://keithclark.github.io/ZzFXM/tracker/) - Music generator for use in tiny JavaScript apps. [[Source](https://github.com/keithclark/ZzFXM)]
- Sound Effects
    - 🆓 [Bfxr](https://www.bfxr.net) - Classic. For making simple sound effects for games. [[Source](https://github.com/increpare/bfxr)]
    - 🆓 [ChipTone](https://sfbgames.itch.io/chiptone) - Tool for generating sound effects.
    - 💸 [sfxia](https://rxi.itch.io/sfxia) - Tiny sound generator.
    - 🆓 [ZzFX](https://killedbyapixel.github.io/ZzFX/) - Tiny JavaScript sound FX system / Zuper Zmall Zound Zynth. [[Source](https://github.com/KilledByAPixel/ZzFX)]

### Color / Palettes
- 🌎 [Colormind](http://colormind.io) - Color scheme generator, can learn color styles from photographs, art, etc.
- 🌎 [COLOURlovers](https://www.colourlovers.com) - Share colors, palettes and patterns.
- 🌎 [Coolors](https://coolors.co) - Fast color palette generator.
- 🌎 [Huemint](https://huemint.com) - Uses machine learning to generate colors for graphic design.
- 🌎 [Lospec](https://lospec.com/palette-list) - Database of palettes for pixel art.
- 🌎 [Paletton](https://paletton.com) - Explore complementary colors on the color wheel.

### Generative Art
- Imaging
    - 💸 [DALL·E](https://en.wikipedia.org/wiki/DALL-E) - Create realistic images from natural language.
    - 🆓 [Disco Diffusion](http://discodiffusion.com/) - Notebooks, models and techniques for AI art and animations.[[Source](https://github.com/alembics/disco-diffusion)]
    - 💸 [Midjourney](https://www.midjourney.com/home/) - Image generation accessed through Discord.
    - 💸 [Replicate](https://replicate.com/) - Run open source models with a cloud API.
    - 💸 [Stable Diffusion](https://github.com/CompVis/stable-diffusion) - Latent text-to-image diffusion model.
- Modeling
    - 📚 [Dream Fusion](https://dreamfusion3d.github.io/) - Text-to-3D using 2D diffusion.
    - 📚 [GET3D](https://nv-tlabs.github.io/GET3D/) - Generative model of 3D shapes from images by _NVIDIA_. [[Source](https://github.com/nv-tlabs/GET3D)]
    - 📚 [Magic3D](https://research.nvidia.com/labs/dir/magic3d/) - High-resolution text-to-3D content creation.
    - 📚 [NeRF](https://www.matthewtancik.com/nerf) - View synthesis of scenes as neural radiance fields. [[Source](https://github.com/bmild/nerf)]
    - 📚 [Shap-e](https://github.com/openai/shap-e) - Generate 3D objects conditioned on text or images.
- Sound
    - 🆓 [Dittytoy](https://dittytoy.net/) - Create generative music using a simple JavaScript API.
    - 🆓 [Sonic Pi](https://github.com/sonic-pi-net/sonic-pi) - Kind of musical instrument where you code music.

### Image Editors
- 🆓 [GIMP](https://www.gimp.org) - GNU Image Manipulation Program, open source image editor. [[Source](https://github.com/GNOME/gimp)]
- 🆓 [Photopea](https://www.photopea.com) - Capable online photo editor.

### Level Editors
- 🆓 [Radiant](https://icculus.org/gtkradiant/) - Cross-platform level editor for [idTech](https://en.wikipedia.org/wiki/Id_Tech) games. [[Source](https://github.com/TTimo/GtkRadiant)]
- 🆓 [TrenchBroom](https://trenchbroom.github.io) - Level editor for _Quake-Engine_ games. [[Source](https://github.com/TrenchBroom/TrenchBroom)]

### Materials / Textures
- 🆓 [ArmorLab](https://armorlab.org) - Generate PBR materials by drag & dropping your photos. [[Source](https://github.com/armory3d/armorlab)]
- 💰 [Filter Forge](https://www.filterforge.com) - Photo effects, realistic textures, and visual editor.
- 🆓 [JSplacement](https://windmillart.net/?p=jsplacement) - Cross-platform pseudo-random displacement map generator.
- 🆓 [Material Maker](https://www.materialmaker.org) - Procedural [physically-based rendering](https://en.wikipedia.org/wiki/Physically_based_rendering) material maker. [[Source](https://github.com/RodZill4/material-maker)]
- 🆓 [Materialize](http://boundingboxsoftware.com/materialize/) - Tool for creating materials from images to be used in games. [[Source](https://github.com/BoundingBoxSoftware/Materialize)]
- 💸 [PixPlant](https://www.pixplant.com/index.php) - Tool to allow simple creation of tiling 3D materials.
- 🆓 [TexaTool](https://kronbits.itch.io/texatool) - Online tool to generate tileable textures by moving sliders.
- 🆓 [Texgen.js](https://texgenjs.org) - JavaScript texture generator tool. [[Source](https://github.com/mrdoob/texgen.js)]
- 🆓 [TexTools for Blender](http://www.renderhjs.net/?doc=texToolsBlender) - UV and texturing tools for _Blender_. [[Source](https://bitbucket.org/renderhjs/textools-blender/src/master/)]

### Modeling Tools
- 💰 [3DS Max](https://www.autodesk.com/products/3ds-max/) - Classic software for 3D modeling and rendering.
- 🆓 [ArmorPaint](https://armorpaint.org) - Physically-based texture painting, drop in your 3D models and paint. [[Source](https://github.com/armory3d/armorpaint)]
- 💰 [Asset Forge](https://assetforge.io) - Create 3D models and 2D sprites using building blocks.
- 🆓 [Blender](https://www.blender.org) 🔥 - Standard for open source 3D modeling. [[Source](https://github.com/blender/blender)]
- 🆓 [Meshroom](https://alicevision.org/#meshroom) - 3D reconstruction, built with the [AliceVision](https://github.com/alicevision/AliceVision) framework. [[Source](https://github.com/alicevision/meshroom)]
- 💸 [ZBrush](https://www.maxon.net/en/zbrush) - Simple and easy to use 3D sculpting tool.

### Particle Tools
- 💸 [Particle Designer](https://www.71squared.com/particledesigner) - Powerful particle effects editor designed for macOS.
- 💸 [TimelineFX](https://www.rigzsoft.co.uk) - Create amazing particle effects for your games, apps and webpages.

### Pixel Art
- 💸 [Aseprite](https://www.aseprite.org) - Animated sprite editor and pixel art tool. [[Source](https://github.com/aseprite/aseprite)]
- 💰 [Ditherdragon](https://winterveil.itch.io/ditherdragon) - Resample art, sketches and images into pixel-art.
- 💰 [Fluid FX](https://codemanu.itch.io/fluid-fx) - Uses fluid simulation to achieve animations like explosions, blood, smoke, etc.
- 💰 [Juice FX](https://codemanu.itch.io/juicefx) - Add style to your sprites and animations with ease.
- 🆓 [Piskel](https://www.piskelapp.com) - Online editor for animated sprites & pixel art. [[Source](https://github.com/piskelapp/piskel)]
- 💰 [PixaTool](https://kronbits.itch.io/pixatool) - Create pixel art by converting your images, sprites or videos.
- 💰 [Pixel FX](https://codemanu.itch.io/particle-fx-designer) - Create pixel art particle effects and render them to sprite sheets.
- 💰 [Smear FX](https://codemanu.itch.io/smear-fx) - Make your 2D animations juicy by adding some smearing to them.

### Vector Editors
- 🆓 [Inkscape](https://inkscape.org) - Cross-platform, open source vector graphics editor. [[Source](https://github.com/inkscape/inkscape)]
- 🆓 [Krita](https://krita.org/en/) - Professional quality, open source painting. [[Source](https://github.com/KDE/krita)]
- 💰 [Vec Maker](https://kronbits.itch.io/vecmaker) - Easy to use vector design.

### Voxel
- 💰 [Ken Shape](https://tools.kenney.nl/kenshape/) - Draw in 2D, set the depth for each pixel and generate 3D models!
- 🎉 [IsoVoxel](https://github.com/tommyettinger/IsoVoxel) - Generates isometric pixel art from _MagicaVoxel_ .vox files.
- 🆓 [MagicaVoxel](https://ephtracy.github.io) - Lightweight voxel art editor.
- 💰 [Qubicle](http://minddesk.com/) - Popular (Crossy Road, Pacman 256) voxel editor, easy creation of 3D models.

<br />
<br />

## Video Game Assets
_Resources to help bring video games and game engines alive._

### Audio Assets
- Music
    - 🆓 [BandLab Sounds](https://www.bandlab.com/sounds/home) - High-quality loops and packs used for music creation.
    - 💸 [Bensound](https://www.bensound.com/royalty-free-music) - Original music tracks, free with attribution. Perfect for games.
    - 💸 [Incompetech](https://incompetech.com/wordpress/) - Nice collection of game tracks. Buy or attribution required.
    - 💸 [Melody Loops](https://www.melodyloops.com/music/free/) - Nice mix of free and affordable music loops.
    - 💸 [Soundimage](https://soundimage.org/looping-music/) - Looping music tracks for videogames. Buy or attribution required.
- Sound Effects
    - 🆓 [Freesound](https://freesound.org/browse/) - Community-based archive of free sound effects.
    - 💸 [Free Sound Effects](https://www.freesoundeffects.com/) - Large collection of sound effects.
    - 💰 [Soundsnap](https://www.soundsnap.com) - Subscription-based professional sound effects library.

### Graphic Assets
- 💸 [Flaticon](https://www.flaticon.com) - Quality vector icons and stickers.
- 💸 [Freepik](https://www.freepik.com) - Illustrations, photos, icons and presentation templates.
- 🆓 [Kenny](https://www.kenney.nl/assets) 🔥 - 2D/3D CC0 1.0 game graphics and other assets.
- 🆓 [Open Game Art](https://opengameart.org) - Portal for free / public domain game art online.
- 🆓 [Top Free Game Assets](https://itch.io/game-assets/free) - Top free game assets listed on _itch.io_.

### Material Assets
- 🆓 [AmbientCG](https://ambientcg.com) - Public domain materials for physically-based rendering.
- 🆓 [Pmndrs Materials](https://github.com/pmndrs/market-assets/tree/main/files/materials) - Collection of public domain materials.

### Model Assets
- 🆓 [Pmndrs Market](https://github.com/pmndrs/market) - Collection of public domain models.
- 🆓 [Poly Pizza](https://poly.pizza) - Build something beautiful with thousands of free low poly models.
- 🆓 [Quaternius](https://quaternius.com) - Collection of CC0 1.0 3D models.
- 📚 [Retro3DGraphicsCollection](https://github.com/Miziziziz/Retro3DGraphicsCollection) - No attribution, retro (_PS1_ style) 3D graphics assets.
- 💸 [Sketchfab](https://sketchfab.com) - Huge library of 3D assets.

<br />
<br />

## Archive

_Dead links that have been removed are kept in the [Archive](ARCHIVE.md)._

<br />

## Legend

_The meaning behind the emoji._

- Open Source Software
    - ⭐ - [Public Domain License](https://en.wikipedia.org/wiki/Public-domain-equivalent_license) ([CC0](https://creativecommons.org/publicdomain/zero/1.0/), [BOLA](https://blitiri.com.ar/p/bola/), [WTFPL](https://en.wikipedia.org/wiki/WTFPL), [Unlicense](https://en.wikipedia.org/wiki/Unlicense), etc.)
    - 🎉 - [Permissive License](https://en.wikipedia.org/wiki/Permissive_software_license) ([MIT/Expat](https://en.wikipedia.org/wiki/MIT_License), [BSD](https://en.wikipedia.org/wiki/BSD_licenses), [ZLIB/LIBPNG](https://en.wikipedia.org/wiki/Zlib_License), [ISC](https://en.wikipedia.org/wiki/ISC_license), [Apache](https://en.wikipedia.org/wiki/Apache_License), [Boost](https://www.boost.org/users/license.html) etc.)
    - 🔒 - [Copyleft License](https://en.wikipedia.org/wiki/Copyleft) ([CC](https://en.wikipedia.org/wiki/Creative_Commons_license), [GPL](https://en.wikipedia.org/wiki/GNU_General_Public_License), [LGPL](https://en.wikipedia.org/wiki/GNU_Lesser_General_Public_License), [MPL](https://en.wikipedia.org/wiki/Mozilla_Public_License), etc.)
    - ❓ - Unknown License
- Asset / Service / Tool
    - 🆓 - Free
    - 💰 - Paid
    - 💸 - Partially Free
- Other
    - 📚 - Article, Blog, Collection, List, Tutorial(s)
    - 🔥 - Hot! Amazing Resource!
    - 🌎 - Website

<br />

## Contributing

_See [Contribution Guide](CONTRIBUTING.md)._

<br />
