/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { TextDecoder, TextEncoder } from "util";

global.TextEncoder = TextEncoder;
// @ts-expect-error
global.TextDecoder = TextDecoder;

beforeEach(() => {
  // The Streamlit class defines several static fields. To avoid side effects,
  // we restore them to their original state.
  const { Streamlit } = require("./streamlit");

  Object.defineProperty(Streamlit, "registeredMessageListener", {
    value: false,
    configurable: true,
    writable: true,
  });
  Object.defineProperty(Streamlit, "lastFrameHeight", {
    value: null,
    configurable: true,
    writable: true,
  });
});
