# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import annotations

import streamlit as st

x = st.button("TEST LOGIN")

if x:
    st.login("testprovider")


if st.user.get("is_logged_in"):
    st.markdown(f"YOU ARE LOGGED IN: {st.user.email}")
    st.markdown(st.user["name"])

    if st.user.tokens:
        st.markdown("TOKENS AVAILABLE")
        if "id" in st.user.tokens:
            st.markdown("HAS ID TOKEN")
        if "access" in st.user.tokens:
            st.markdown("HAS ACCESS TOKEN")
