# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import numpy as np
import pandas as pd

import streamlit as st


def page2():
    st.header("Page 2")


def page3():
    st.header("Page 3")


# Make MPA to use for dialog blocking test
st.navigation(
    [
        st.Page(page2, title="02_App_Page_2", default=True),
        st.Page(page3, title="03_App_Page_3"),
    ]
)

# always generate the same data
np.random.seed(0)

st.image(np.repeat(0, 100).reshape(10, 10))
st.dataframe(
    pd.DataFrame(np.random.randint(0, 100, size=(100, 4)), columns=list("ABCD"))
)
