# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from datetime import date, datetime

import streamlit as st
from streamlit import runtime

leading_indent_regular_text_tooltip = """
This is a regular text block!
Test1
Test2

"""

v1 = st.date_input(
    "Single date",
    date(1970, 1, 1),
    min_value=date(1970, 1, 1),
    help=leading_indent_regular_text_tooltip,
)
st.write("Value 1:", v1)

v2 = st.date_input("Single datetime", datetime(2019, 7, 6, 21, 15), help="Help text")
st.write("Value 2:", v2)

v3 = st.date_input("Range, no date", [])
st.write("Value 3:", v3)

v4 = st.date_input("Range, one date", [date(2019, 7, 6)])
st.write("Value 4:", v4)

v5 = st.date_input("Range, two dates", [date(2019, 7, 6), date(2019, 7, 8)])
st.write("Value 5:", v5)

v6 = st.date_input("Disabled, no date", [], disabled=True)
st.write("Value 6:", v6)

v7 = st.date_input(
    "Label hidden",
    datetime(2019, 7, 6, 21, 15),
    label_visibility="hidden",
    key="date_input_7",
)
st.write("Value 7:", v7)

v8 = st.date_input(
    "Label collapsed",
    datetime(2019, 7, 6, 21, 15),
    label_visibility="collapsed",
    key="date_input_8",
)
st.write("Value 8:", v8)

v9 = st.date_input("Single date with format", date(1970, 1, 1), format="MM-DD-YYYY")
st.write("Value 9:", v9)

v10 = st.date_input(
    "Range, two dates with format",
    [date(2019, 7, 6), date(2019, 7, 8)],
    format="MM/DD/YYYY",
)
st.write("Value 10:", v10)

v11 = st.date_input("Range, no date with format", [], format="DD.MM.YYYY")
st.write("Value 11:", v11)


if runtime.exists():

    def on_change():
        st.session_state.date_input_changed = True
        st.text("Date input changed callback")

    st.date_input(
        "Single date with callback",
        date(1970, 1, 1),
        min_value=date(1970, 1, 1),
        key="date_input_12",
        on_change=on_change,
    )
    st.write("Value 12:", st.session_state.date_input_12)
    st.write("Date Input Changed:", st.session_state.get("date_input_changed") is True)
    # Reset to False:
    st.session_state.date_input_changed = False

v13 = st.date_input("Empty value", value=None)
st.write("Value 13:", v13)

if "date_input_14" not in st.session_state:
    st.session_state["date_input_14"] = date(1970, 2, 3)

v14 = st.date_input(
    "Value from state",
    value=None,
    key="date_input_14",
)
st.write("Value 14:", v14)

st.date_input(
    "date input 15 -> :material/check: :rainbow[Fancy] _**markdown** `label` _support_",
    date(1970, 1, 1),
    key="date_input_15",
)

st.date_input("Date input 16 (width=200px)", date(1970, 1, 1), width=200)
st.date_input("Date input 17 (width='stretch')", date(1970, 1, 1), width="stretch")

st.write("""This is a block of text. We can click on it to
         trigger a click outside of the element to submit the value.""")

if st.toggle("Update date input props"):
    dval = st.date_input(
        "Updated dynamic date input",
        value=date(2023, 9, 10),
        width=300,
        help="updated help",
        on_change=lambda a, param: print(
            f"Updated date input - callback triggered: {a} {param}"
        ),
        args=("Updated date arg",),
        kwargs={"param": "updated kwarg param"},
        key="dynamic_date_input_with_key",
        # min_value, max_value, & format are not yet supported for dynamic changes
        # keeping it at the same value for now:
        min_value=date(2010, 1, 1),
        max_value=date(2030, 1, 1),
        format="YYYY/MM/DD",
    )
    st.write("Updated date input value:", dval)
else:
    dval = st.date_input(
        "Initial dynamic date input",
        value=date(2020, 1, 1),
        width="stretch",
        help="initial help",
        on_change=lambda a, param: print(
            f"Initial date input - callback triggered: {a} {param}"
        ),
        args=("Initial date arg",),
        kwargs={"param": "initial kwarg param"},
        key="dynamic_date_input_with_key",
        min_value=date(2010, 1, 1),
        max_value=date(2030, 1, 1),
        format="YYYY/MM/DD",
    )
    st.write("Initial date input value:", dval)
