# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import streamlit as st


@st.fragment
def my_fragment() -> None:
    st.selectbox("Choose a color", options=["red", "yellow", "green"])


my_fragment()

col1, col2 = st.columns(2)

with col1:
    if st.button("Balloons"):
        st.balloons()

with col2:
    if st.button("Snow"):
        st.snow()
