# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import streamlit as st
from streamlit import runtime

v1 = st.number_input("number input 1 (default)", help="Help text")
st.write("number input 1 (default) - value: ", v1)

v2 = st.number_input("number input 2 (value=1)", value=1)
st.write("number input 2 (value=1) - value: ", v2)

v3 = st.number_input("number input 3 (min & max)", 1, 10)
st.write("number input 3 (min & max) - value: ", v3)

v4 = st.number_input("number input 4 (step=2)", step=2)
st.write("number input 4 (step=2) - value: ", v4)

v5 = st.number_input("number input 5 (max=10)", max_value=10)
st.write("number input 5 (max=10) - value: ", v5)

v6 = st.number_input("number input 6 (disabled=True)", disabled=True)
st.write("number input 6 (disabled=True) - value: ", v6)

v7 = st.number_input("number input 7 (label=hidden)", label_visibility="hidden")
st.write("number input 7 (label=hidden) - value: ", v7)

v8 = st.number_input("number input 8 (label=collapsed)", label_visibility="collapsed")
st.write("number input 8 (label=collapsed) - value: ", v8)

if runtime.exists():

    def on_change():
        st.session_state.number_input_changed = True

    st.number_input(
        "number input 9 (on_change)", key="number_input_9", on_change=on_change
    )
    st.write("number input 9 (on_change) - value: ", st.session_state.number_input_9)
    st.write(
        "number input 9 (on_change) - changed:",
        st.session_state.get("number_input_changed") is True,
    )

[col1, col2, col3, col4, col5, col6] = st.columns(6)

with col1:
    v10 = st.number_input("number input 10 (small width)", max_value=10)
    st.write("number input 10 (small width) - value: ", v10)

v11 = st.number_input(
    "number input 11 (value=None)", value=None, placeholder="Type a number..."
)
st.write("number input 11 (value=None) - value: ", v11)

if "number_input_12" not in st.session_state:
    st.session_state["number_input_12"] = 10

v12 = st.number_input(
    "number input 12 (value from state & min=1)",
    value=None,
    min_value=1,
    key="number_input_12",
)
st.write("number input 12 (value from state & min=1) - value: ", v12)

st.number_input(
    "number input 13 -> :material/check: :rainbow[Fancy] _**markdown** `label` _support_"
)

st.number_input(
    "number input 14 - emoji icon",
    value=5,
    min_value=0,
    max_value=10,
    icon="💵",
)

st.number_input(
    "number input 15 - material icon",
    value=5,
    min_value=0,
    max_value=10,
    icon=":material/attach_money:",
)

st.number_input(
    "number input 16 (width=200px)", value=42, min_value=0, max_value=100, width=200
)

st.number_input(
    "number input 17 (width='stretch')",
    value=42,
    min_value=0,
    max_value=100,
    width="stretch",
)

st.markdown("Dynamic number input:")

if st.toggle("Update number input props"):
    dyn_val = st.number_input(
        "Updated dynamic number input",
        value=15,
        width=300,
        help="updated help",
        format="%0.2f",
        placeholder="Updated placeholder",
        icon=":material/looks_two:",
        key="dynamic_number_input_with_key",
        on_change=lambda a, param: print(
            f"Updated text input - callback triggered: {a} {param}"
        ),
        args=("Updated text arg",),
        kwargs={"param": "updated kwarg param"},
        min_value=10,
        max_value=50,
        step=5,
    )
    st.write("Updated number input value:", dyn_val)
else:
    dyn_val = st.number_input(
        "Initial dynamic number input",
        value=5,
        width="stretch",
        help="initial help",
        format="%d",
        placeholder="Initial placeholder",
        icon=":material/looks_one:",
        key="dynamic_number_input_with_key",
        on_change=lambda a, param: print(
            f"Initial text input - callback triggered: {a} {param}"
        ),
        args=("Initial text arg",),
        kwargs={"param": "initial kwarg param"},
        min_value=0,
        max_value=100,
        step=1,
    )
    st.write("Initial number input value:", dyn_val)

# Test very small step values that JavaScript represents in scientific notation (1e-7)
# This input starts at 0 for testing increment
v18 = st.number_input(
    "number input 18 (small step increment)",
    value=0.0,
    min_value=0.0,
    max_value=0.001,
    step=0.0000001,
    format="%0.7f",
    key="number_input_18",
)
# Format explicitly to avoid Python's scientific notation (e.g., 1e-07)
st.write(f"number input 18 (small step increment) - value: {v18:.7f}")

# This input starts at 0.0000005 for testing decrement
v19 = st.number_input(
    "number input 19 (small step decrement)",
    value=0.0000005,
    min_value=0.0,
    max_value=0.001,
    step=0.0000001,
    format="%0.7f",
    key="number_input_19",
)
st.write(f"number input 19 (small step decrement) - value: {v19:.7f}")
