# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import Any

import pytest
from playwright.sync_api import Page, expect

test_dicts = [{"x": "y"}, {"x": "y", "a": "b"}, {"x": ["y", "1", "2.34"]}, {"x": ""}]


@pytest.mark.parametrize("app_with_query_params", test_dicts, indirect=True)
def test_app_with_query_params(app_with_query_params: tuple[Page, dict[str, Any]]):
    page, test_dict = app_with_query_params
    expect(page.get_by_test_id("stMarkdownContainer")).to_have_text(str(test_dict))
