# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import streamlit as st
from streamlit import runtime

v1 = st.text_area("text area 1 (default)")
st.write("value 1:", v1)

v2 = st.text_area("text area 2 (value='some text')", "some text")
st.write("value 2:", v2)

v3 = st.text_area("text area 3 (value=1234)", 1234)
st.write("value 3:", v3)

v4 = st.text_area("text area 4 (value=None)", None)
st.write("value 4:", v4)

v5 = st.text_area("text area 5 (placeholder)", placeholder="Placeholder")
st.write("value 5:", v5)

v6 = st.text_area("text area 6 (disabled)", "default text", disabled=True)
st.write("value 6:", v6)

v7 = st.text_area(
    "text area 7 (hidden label)",
    "default text",
    label_visibility="hidden",
    key="text_area_7",
)
st.write("value 7:", v7)

v8 = st.text_area(
    "text area 8 (collapsed label)",
    "default text",
    label_visibility="collapsed",
    key="text_area_8",
)
st.write("value 8:", v8)

if runtime.exists():

    def on_change():
        st.session_state.text_area_changed = True
        st.text("text area changed callback")

    st.text_area(
        "text area 9 (callback, help)",
        key="text_area_9",
        on_change=on_change,
        help="Help text",
    )
    st.write("value 9:", st.session_state.text_area_9)
    st.write("text area changed:", st.session_state.get("text_area_changed") is True)
    # Reset to False:
    st.session_state.text_area_changed = False

v10 = st.text_area("text area 10 (max_chars=5)", "1234", max_chars=5)
st.write("value 10:", v10)

v11 = st.text_area("text area 11 (height=250)", "default text", height=250)
st.write("value 11:", v11)

v12 = st.text_area("text area 12 (height=75)", "default text", height=75)
st.write("value 12:", v12)

# Expect this to default to the minimum height of 68px
v13 = st.text_area("text area 13 (height=60)", "default text", height=60)
st.write("value 13:", v13)

# gh-12867: Test very small height that would produce negative calculation
# height=10: 10 - 30 (labelAndPadding) = -20, should clamp to 0 then use minHeight
v13_5 = st.text_area("text area 13.5 (height=10)", "default text", height=10)
st.write("value 13.5:", v13_5)

if "text_area_14" not in st.session_state:
    st.session_state["text_area_14"] = "xyz"

v14 = st.text_area(
    "text area 14 (value from state)",
    value=None,
    key="text_area_14",
)
st.write("text area 14 (value from state) - value: ", v14)

with st.form("form"):
    st.text_area("text area 15 (value from form)", key="text_area_15")
    st.form_submit_button("submit")

form_value = st.session_state.get("text_area_15", None)
st.write("text area 15 (value from form) - value: ", form_value)

st.text_area(
    "text area 16 -> :material/check: :rainbow[Fancy] **markdown** `label` _support_",
    key="text_area_16",
)

st.text_area("text area 17 (width=200px)", "width test", width=200)
st.text_area("text area 18 (width='stretch')", "width test", width="stretch")

with st.form("form2", height=500):
    st.text_area(
        "text area 19 (height='content') - Height adjusts to content.",
        """Line 1\nLine 2\nLine 3""",
        height="content",
    )
    st.form_submit_button("submit")

with st.container(horizontal=True, height=300, key="layout-horizontal-text-area"):
    st.text_area(
        "text area in horizontal layout (height='content')",
        """Line 1\nLine 2\nLine 3""",
        width="stretch",
        height="content",
    )

with st.form("form3", height=500):
    st.text_area(
        "text area 20 (height='stretch')",
        "Height stretches to fill space in fixed height form.",
        height="stretch",
    )
    st.form_submit_button("submit")

col1, col2 = st.columns(2)
with col1:
    st.text_area(
        "text area 21 (height='500')",
        """Fixed height of 500px""",
        height=500,
    )
with col2:
    st.text_area(
        "text area 22 (height='stretch')",
        """Height matches partner column""",
        height="stretch",
    )

st.markdown("Dynamic text area:")

if st.toggle("Update text area props"):
    ta_value = st.text_area(
        "Updated dynamic text area",
        value="updated",
        width=200,
        height=150,
        help="updated help",
        key="dynamic_text_area_with_key",
        on_change=lambda a, param: print(
            f"Updated text area - callback triggered: {a} {param}"
        ),
        args=("Updated text area arg",),
        kwargs={"param": "updated kwarg param"},
        placeholder="updated placeholder",
        # max_chars is not yet supported for dynamic changes
        # keeping it at the same value for now:
        max_chars=100,
    )
    st.write("Updated text area value:", ta_value)
else:
    ta_value = st.text_area(
        "Initial dynamic text area",
        value="initial",
        width="stretch",
        height="content",
        help="initial help",
        key="dynamic_text_area_with_key",
        on_change=lambda a, param: print(
            f"Initial text area - callback triggered: {a} {param}"
        ),
        args=("Initial text area arg",),
        kwargs={"param": "initial kwarg param"},
        placeholder="initial placeholder",
        max_chars=100,
    )
    st.write("Initial text area value:", ta_value)
