/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { ReactElement } from "react"

import { css, Global } from "@emotion/react"

export interface FontFaceDeclarationProps {
  fontFaces: object[]
}

const FontFaceDeclaration = ({
  fontFaces,
}: FontFaceDeclarationProps): ReactElement => {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any -- TODO: Replace 'any' with a more specific type.
  const fontMarkup = fontFaces.map((font: any) => {
    const { family, weight, weightRange, url, style, unicodeRange } = font
    // weight is deprecated in favour of weightRange, but we support it for
    // backwards compatibility.
    const resolvedWeight = weightRange || weight
    return `
      @font-face {
        font-family: ${family};
        src: url(${url}) format("woff2");
        font-display: swap;
        ${style ? `font-style: ${style};` : ""}
        ${resolvedWeight ? `font-weight: ${resolvedWeight};` : ""}
        ${unicodeRange ? `unicode-range: ${unicodeRange};` : ""}
      }
    `
  })

  return (
    <Global
      styles={css`
        ${fontMarkup}
      `}
    />
  )
}

export default FontFaceDeclaration
