/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export interface UserSettings {
  /**
   * If true, the app will be rendered with a wider column size
   */
  wideMode: boolean

  /**
   * Flag indicating whether the server should re-run an app's scripts automatically
   * when their source files are modified on disk.
   *
   * The server passes the initial runOnSave value in its 'NewConnection'
   * forward message. If the value is modified via {@link App.saveSettings},
   * a 'setRunOnSave' message will be sent back to the server.
   */
  runOnSave: boolean
}
