/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { FC, PropsWithChildren, useCallback, useRef } from "react"

import { StyledDataFrameOverlay } from "~lib/styled-components"

import { PortalContext } from "./PortalContext"

export const PortalProvider: FC<PropsWithChildren> = ({ children }) => {
  const overlayRef = useRef<HTMLDivElement>(null)

  const getRefElement = useCallback(() => {
    return overlayRef.current
  }, [])

  return (
    <PortalContext.Provider value={getRefElement}>
      {children}
      <StyledDataFrameOverlay
        data-testid="portal"
        id="portal"
        ref={overlayRef}
      />
    </PortalContext.Provider>
  )
}
