/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { memo, ReactElement } from "react"

import { Html as HtmlProto } from "@streamlit/protobuf"

import HtmlWithJs from "./HtmlWithJs"
import SanitizedHtml from "./SanitizedHtml"

export interface HtmlProps {
  element: HtmlProto
}

/**
 * HTML code to insert into the page.
 */
function Html({ element }: Readonly<HtmlProps>): ReactElement {
  const { body, unsafeAllowJavascript } = element

  return unsafeAllowJavascript ? (
    <HtmlWithJs body={body} />
  ) : (
    <SanitizedHtml body={body} />
  )
}

export default memo(Html)
