/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Serialized Plotly object for testing purposes
export default {
  useContainerWidth: false,
  figure: {
    spec: '{"data": [{"autobinx": false, "histnorm": "probability density", "legendgroup": "Group 1", "marker": {"color": "rgb(31, 119, 180)"}, "name": "Group 1", "opacity": 0.7, "x": [-0.7001341255632894, -2.7172511925337575, -2.676794270670189, -2.6964446858959312, -2.3388928773462667, -1.847642891977336, -3.210894349642625, -2.2898729324478087, -1.9244543234010134, -1.542874183075713, -2.0754999748655023, -1.7856536834250376, -3.040947008587687, 0.07296146053555974, -1.4574074643435826, -1.7635493939449756, -1.6943474178388795, -1.5269952539428016, -2.126856434052626, -3.2339313852197904, -2.229073321043474, -2.4519322943174995, -1.5933134873240007, -0.6903733959324143, -1.3817682798248496, -1.652125744268151, -0.6199070424919042, -1.9163560659405248, -3.2347436984429128, -1.7761428704481794, -3.1830313137403667, -2.235077023028927, -1.2738689616688594, -2.1007484841057016, -1.5392092574586933, -2.4600601309120247, -3.6664778524223434, -1.8524516379380398, 0.5525322934643988, -2.660453913188509, -4.362901504139749, -2.049063035182252, -1.1969930251191707, -1.5743690071507477, -1.2864344729916635, -0.9849779436484396, -1.6878024520549424, 0.1829829144953803, -2.543032079320584, -1.7205487317562351, -0.8742656894985334, -0.7699996012987991, -1.6404437441283095, -1.317796459741734, -2.636155433134551, -1.6583513120593163, -2.6066910484979013, -2.7173169562551918, -1.5814653919651989, -3.2811250576510176, -4.513760664043757, -1.6266938116970924, -2.8898192402536935, -2.631556308011037, -1.3626901022955216, -1.7010521667453882, -1.7177525685833468, -1.2803534777918295, 0.333916271260986, -1.5065659430831053, -3.410935441254124, -1.839151536948116, -2.458231832443594, -3.046030982683657, -2.1076103775193697, -3.4599948355383665, -1.9503142618495652, -0.7390641682030863, -2.095145388868499, -2.2042237028946716, -4.2955306806915186, -3.4563508850632862, -3.070179303049419, -1.2490625452829043, -2.6526469977759244, -2.2606102303411753, -2.953918573872213, -2.2215338586417848, 0.7997699099779205, -1.4399830550926749, -3.155934837840408, -2.4940767278457523, -2.9842069002229676, -1.7321559150182628, -1.7737935613986184, -0.9734807829493486, -0.9421855450060717, -3.0069836106440784, -2.652724902272573, -1.3254582776518506, -1.1406031384752189, -3.2796177486799647, -1.6775017255902434, -3.1296883700230786, -3.1014040027311163, -2.0650642358696616, -2.261813483808236, -0.4644464329340081, -0.4067739141190603, -1.4389926994318456, -2.4827341964034995, -3.512030344355951, -1.861916688624474, -2.8468693076402993, -0.23617579874728767, -2.885562366891033, -1.1066291071620575, -0.5076815559149137, -2.6764518173374894, -1.3604383970665017, -0.42635353269395315, -1.9024282181539145, -3.3004395387476304, -2.817717916934475, 0.6960514327101728, -3.6486207347857085, -2.9464712157919863, -0.7155534591607737, -1.290011320758599, -2.280297559178461, -1.7668484751937508, -1.7150018848417312, -2.5594268443531654, -3.2138667507434104, -3.9276149209611186, -1.8104704118590487, -2.7302407338755277, -2.3457237650393705, -1.300507238584432, -0.8876117782246515, -2.2586324543219694, -2.415195794522053, -2.252253227058963, -3.917024272381176, -1.8009676228168603, -1.024965699942972, -3.492769047579727, -1.7042944138737235, -3.1821649721916394, -2.286263091969299, -2.3182822436596964, -2.5663989625637575, -1.8589510961827158, -2.323425703821542, -2.4563339354733165, -2.366833930784866, -1.5308788907923214, -4.165218214735708, -3.291390449496774, -3.2175513149350925, -1.72793252715239, -3.039473171726544, -2.7699011031058003, -2.456515129529819, -4.00987888592009, -1.7481251605437336, -2.103650867075174, -0.8366289940032827, -3.004221577671708, -4.235359182835562, -0.19867191918459715, -3.0137625153377265, -1.749475407970678, -1.2960148185724012, -1.4761126976406949, -1.523885136928605, -1.8612623487242956, -0.6822185126115037, -4.424196252116276, -3.324797064659511, -1.5445552654630144, -1.4747820270092151, -3.3762704966110535, -0.9052491977232247, -0.9970369804168571, -1.5835927337811881, -1.4412066278280562, -0.9701265284276988, -2.7190632319794537, -1.663170575198067, -1.2700863259352762, -1.2869000274968823, -1.8613208637431664, -3.1244784717183567, -2.6861355399663176, -1.7458057189793708, -1.6113770819690965, -1.9462632722248454, -1.8984910858597113, -3.8742912646132095], "xaxis": "x", "xbins": {"end": 0.7997699099779205, "size": 0.1, "start": -4.513760664043757}, "yaxis": "y", "type": "histogram"}, {"autobinx": false, "histnorm": "probability density", "legendgroup": "Group 2", "marker": {"color": "rgb(255, 127, 14)"}, "name": "Group 2", "opacity": 0.7, "x": [-2.186606161142207, -0.7907084842026084, 0.6215684936273707, -0.6664573109260641, -1.8261029062383782, 0.49553610585758134, -0.9125973856082791, -0.606798197088081, -0.11130608036943589, 1.1581991444159523, 0.0435360654408021, 0.7025225238485446, -0.6270046152333697, -0.6652401348640777, 0.06301316703050687, 1.4002524740850435, 2.0496219351940357, -1.2088372669460596, 0.7755733011511213, 1.5865109652792682, -1.0893739523672943, 1.040533813292226, 0.6200455077540833, -0.7930354323485305, -1.6066380023928095, 1.4915784456841539, -0.06163245082462851, 0.1748525823997394, -1.7533759372833875, -0.39943220827913073, 0.5824830131689823, 0.9296329195109067, -0.05367283827555803, 0.08493359653172511, -0.6819041384685466, -0.5437498200694375, 0.2272237032884355, 1.2433958758062367, 1.3596122997568345, 1.369986710960303, -0.473824575123805, 0.18806963810745572, 0.8042722376668314, 0.4335118855729404, -0.5812341305492782, 2.044458427915941, -0.8264550515142165, -1.3086865520400053, 1.3685938576983765, 0.5471190402847167, 0.6679851112578952, -0.24951759256147674, -1.7998569326756668, -0.6193525043756357, 1.208263744870649, -1.0638463002820109, 1.8330393826136904, 0.28165754126597176, 1.18016380489207, -0.5118137185892909, 0.18883973942326235, -0.6885903293818294, 0.8062748190781387, 0.16348960402620802, 0.03177748819295189, -0.46526643742186446, 1.6225623336120352, 0.3476282863896616, -0.5560069054083071, -0.18044974875446287, -0.5307680039569107, -1.170608274912844, 0.9441252836419484, -0.5090792079751404, 0.44349311585207046, 1.359959429785838, 1.2923857570901407, 0.3569870241696899, 0.449725304668682, 1.5938112209604791, 0.0415325190333718, -1.4888909446484289, 0.8129659844716989, 1.6637950693489998, 1.1760152227567506, -0.8349856526971908, 0.9858738351669688, 1.6551732241036783, -1.199309229867516, 0.6905350677412722, -0.621551149217892, -1.2324279590772083, 0.34151850122085015, -1.007389676725006, -1.1348458929120997, -0.31233761059414605, 0.4793355042852716, 0.40319387283822594, -0.73817527160584, 0.608900364991188, 0.28909098394140265, -0.05631896518466086, 0.505742875582015, 0.651439291100705, 0.8798850156481322, -0.31882120685734505, -0.29891765024796363, -0.9432404135526444, 1.7821759611422188, 0.3577013100856936, -0.07847795856818938, -2.0550118101368127, -0.554735900233456, 0.0816522082842264, 1.0354081346319182, 0.4567000101513787, -0.5846515155036132, 1.5136165383345574, -0.055686616967372926, 0.07628807710884732, 1.0574736602544683, 1.0840157114841318, -0.9936548880723843, -0.2210860447600946, 0.3028222529795845, 0.7169510928055438, -0.1514003306688253, -0.8610284057638767, -1.0439263660710776, -0.27797338441800046, -0.377724465253531, 0.9357954247566446, -0.13353889502325872, -0.6049426048160075, 1.953949857998025, -1.1488953218499374, -0.3958396115466337, -0.6837338568566131, -1.820154826149105, -0.15067754736329086, 0.5105347247226132, 1.0448788574161052, 2.021241834039774, -0.22203732627274106, 2.0360991639300026, -0.6123543136954916, 1.0493655147465508, 0.25595426503918356, 0.9658375410084153, -0.29458052454415184, -0.7732118791188753, -0.9576011340352182, -1.2052900032471265, -1.6424083158993943, -0.09984979091596823, 1.1242732413527428, -1.4116967811791405, -0.00921625204782433, 1.2399902501077977, -0.042263682269344835, -1.0501838295107255, 1.6365580675359375, -1.8477976140909462, -0.1617742278924333, 0.07401583989993735, 0.2773069191335467, -0.5046766024968936, 0.6266134130238634, -1.3309752115383218, -0.371347953551894, -1.1820949306397104, -0.6622488795855106, -0.7205063651104684, -0.5023572486618174, -1.1520902569893434, 2.1065830797942393, -0.5586109095725957, -0.17532072875069174, -0.7240574281742918, 0.46196149858922003, 0.33139888029579684, 0.232025559000832, 0.531252100210586, 0.7579540871418472, 0.8309517343306817, -1.4633657386712393, 0.46611777190371934, 1.634545330497187, -0.6079212171698446, -0.20936891983099035, 0.739106309774338, 0.27461888133433915, -0.2976979333250953, -1.7570660006429129, 1.2745417192802326, -1.2141217941972722, 0.3134042577184187, -2.3051903298823304, 1.78952128174831, 0.4558491253695143], "xaxis": "x", "xbins": {"end": 2.1065830797942393, "size": 0.25, "start": -2.3051903298823304}, "yaxis": "y", "type": "histogram"}, {"autobinx": false, "histnorm": "probability density", "legendgroup": "Group 3", "marker": {"color": "rgb(44, 160, 44)"}, "name": "Group 3", "opacity": 0.7, "x": [2.4149902481853385, 2.8320872055155206, 2.264225399622341, 1.7099221832166085, 2.4664061870918985, 1.9013643625145127, 2.9919526047270253, 1.5175905737319897, 2.8333863006708393, 2.743131874234973, -0.017453043418832248, 1.5526896912378323, 2.553972671525987, 2.0181747840444753, 2.2253471780111997, 1.2832758571998388, 1.1612750935551064, 2.361669986228835, 3.721034175862947, 2.6781184933918, 1.8881819555959931, 3.2142425774989776, 1.9559726226977088, 2.2031832716846145, 1.3903201413704995, 4.995953556410613, 1.9750738473135276, 2.30630434323296, -0.23330697694425195, 0.4533494800548028, 3.361919608667601, 3.366478887893411, 1.0796589314635678, 3.227674024795921, 1.0030340927031463, 0.6409449295366854, 2.583691049461988, 1.1772438569619674, 1.5152834029569588, 2.5848643077288838, 2.3098866155416746, 2.438198825210403, 2.1914917644396743, 2.8981989474882233, 0.44017681684860754, 2.360183638368979, 2.85478377780431, 2.298248583226848, 1.443803111648668, 1.9310947388468531, 1.436898560143047, 1.23200440672781, 1.8958110702814805, 0.7866584900191604, 2.496178444191074, 0.8512481225394739, 2.050315937692191, 3.2237440494571663, 0.8861920914198467, 0.22600828025109432, 3.2881353943061953, 1.96580238016236, 1.4155790660616883, 2.453720256940728, 2.3785156959104534, 3.1823951984402186, -0.49089307211867483, 0.6518066855806923, 3.4533610879772336, 2.1751386300855495, 1.780283433741765, 0.6632152695114253, 3.9236346549646868, 2.5320304351483087, 2.767110245837692, 1.1846789290521358, 0.5815955932364816, 1.669613564741868, 3.5619603880839135, 3.6173005129104787, 3.98106364518085, 1.7452566463913253, 1.504994539801367, 1.3461128333941605, 2.4679364858188446, 1.5912314351181265, 1.0092181708130186, 1.4927593274850919, 2.760650281569971, 2.590156083231835, 2.1145800256359237, 0.8711747648547188, 1.6695677190187728, 2.5829329639036236, 2.5087732134815863, 2.2059869055063355, 2.398401953186879, 2.258714853696918, 1.5078373597707448, 1.7378088413742805, 1.2424337299685002, 0.7204125324873223, 4.373906475949751, -0.36165994075324814, 1.8744962844526463, 1.1758774131923961, 3.9006070875197656, 2.3091348432953813, 2.93889554590988, 2.2871271367535395, -0.16678771977766393, 1.589455850268077, 2.486824685817486, 0.44728317303576315, 1.5340528359765015, 3.43508338933444, 0.8004888813036724, 1.716587178969777, -0.11478316366693386, 3.604112772129816, 1.6905311462015256, 2.8723698038027936, 0.8101043245336044, 0.44703396460807854, 0.6436926124890245, 1.7832535208364477, 2.312670504155142, 3.034123199187526, 1.9354831498933032, 1.818282839882696, 2.650103986770086, 1.5535061658427884, 1.3726069939195358, 2.4367669185069305, 0.7882470358495934, 3.654153738322322, 3.1172578551846724, 2.7543821314610057, 0.3563169192177602, 1.0999198598323456, 2.0166971744144377, 0.6999567284962402, 1.4555724431106463, 2.625651782815015, 2.4389102340183215, 3.368361740059224, 2.626824168087939, 2.0262447137856427, 0.4143080893285751, 3.3706930312677894, 1.5549878787443439, 1.1250101515401916, 1.562755104212417, 2.7132790037025565, 2.0831922188716154, 3.1969401231815042, 3.37853746388412, 2.387724842244888, 3.98541566157831, 1.5389686650951104, 2.563521530177166, 1.6614350906958684, 1.48553115054735, 1.5557260674236861, 1.3702700798979204, 1.1100550262998503, 2.823292663553766, 1.5444628635920719, 3.310531374726547, 2.5730344584855906, 2.210837840595279, 3.3212401304129875, 2.1302541575915215, 3.5909504277862747, 1.8925376546372972, 1.9035791354285472, 2.3680754479413273, 3.514168981195849, 0.3533067074946614, 1.8887861364197471, 3.070064929711613, 2.8440110321482273, 1.5243505281436966, 1.2127250999550765, 2.1033317429238725, 2.1787576878608763, 1.5306418918970415, 2.3850922614077983, 4.554967962359095, 1.6126578736317452, 1.4361024121515302, 2.966564230354843, 3.1046273992738262, 1.2301660181283185, 0.09052023527742836, 3.10397821665058, 1.1050765386935169, 0.11356646311195107, 3.2928202449344623, 2.1605064630688617], "xaxis": "x", "xbins": {"end": 4.995953556410613, "size": 0.5, "start": -0.49089307211867483}, "yaxis": "y", "type": "histogram"}, {"legendgroup": "Group 1", "marker": {"color": "rgb(31, 119, 180)"}, "mode": "lines", "name": "Group 1", "showlegend": false, "x": [-4.513760664043757, -4.503133602895714, -4.49250654174767, -4.481879480599627, -4.4712524194515835, -4.460625358303541, -4.449998297155497, -4.439371236007454, -4.4287441748594105, -4.418117113711367, -4.407490052563324, -4.39686299141528, -4.386235930267237, -4.375608869119194, -4.364981807971151, -4.354354746823107, -4.343727685675064, -4.33310062452702, -4.322473563378977, -4.311846502230933, -4.30121944108289, -4.290592379934846, -4.279965318786804, -4.26933825763876, -4.258711196490717, -4.2480841353426735, -4.23745707419463, -4.226830013046587, -4.216202951898543, -4.2055758907505, -4.194948829602456, -4.184321768454414, -4.17369470730637, -4.163067646158327, -4.152440585010283, -4.14181352386224, -4.131186462714196, -4.120559401566153, -4.109932340418109, -4.099305279270066, -4.088678218122023, -4.07805115697398, -4.0674240958259364, -4.056797034677893, -4.0461699735298495, -4.035542912381806, -4.024915851233763, -4.014288790085719, -4.003661728937677, -3.993034667789633, -3.9824076066415897, -3.971780545493546, -3.9611534843455027, -3.9505264231974593, -3.939899362049416, -3.929272300901373, -3.9186452397533293, -3.908018178605286, -3.8973911174572424, -3.8867640563091994, -3.876136995161156, -3.8655099340131125, -3.854882872865069, -3.844255811717026, -3.8336287505689826, -3.823001689420939, -3.8123746282728956, -3.8017475671248526, -3.791120505976809, -3.7804934448287657, -3.7698663836807222, -3.759239322532679, -3.7486122613846358, -3.7379852002365923, -3.727358139088549, -3.716731077940506, -3.7061040167924624, -3.695476955644419, -3.6848498944963755, -3.674222833348332, -3.663595772200289, -3.6529687110522455, -3.642341649904202, -3.6317145887561586, -3.6210875276081156, -3.610460466460072, -3.5998334053120287, -3.589206344163985, -3.5785792830159417, -3.5679522218678983, -3.5573251607198553, -3.546698099571812, -3.536071038423769, -3.5254439772757253, -3.514816916127682, -3.5041898549796384, -3.493562793831595, -3.4829357326835515, -3.4723086715355085, -3.461681610387465, -3.451054549239422, -3.4404274880913785, -3.429800426943335, -3.4191733657952916, -3.408546304647248, -3.3979192434992047, -3.3872921823511613, -3.3766651212031182, -3.3660380600550748, -3.3554109989070313, -3.3447839377589883, -3.334156876610945, -3.3235298154629014, -3.312902754314858, -3.3022756931668145, -3.291648632018771, -3.2810215708707275, -3.2703945097226845, -3.2597674485746415, -3.249140387426598, -3.2385133262785546, -3.227886265130511, -3.2172592039824677, -3.206632142834424, -3.196005081686381, -3.1853780205383377, -3.1747509593902947, -3.1641238982422513, -3.153496837094208, -3.1428697759461643, -3.132242714798121, -3.1216156536500774, -3.110988592502034, -3.1003615313539905, -3.0897344702059475, -3.079107409057904, -3.068480347909861, -3.0578532867618176, -3.047226225613774, -3.0365991644657306, -3.025972103317687, -3.015345042169644, -3.0047179810216007, -2.9940909198735577, -2.9834638587255142, -2.9728367975774708, -2.9622097364294273, -2.951582675281384, -2.9409556141333404, -2.930328552985297, -2.919701491837254, -2.9090744306892105, -2.898447369541167, -2.887820308393124, -2.8771932472450805, -2.866566186097037, -2.8559391249489936, -2.84531206380095, -2.8346850026529067, -2.8240579415048632, -2.8134308803568207, -2.802803819208777, -2.7921767580607337, -2.7815496969126903, -2.770922635764647, -2.7602955746166034, -2.74966851346856, -2.739041452320517, -2.7284143911724734, -2.71778733002443, -2.707160268876387, -2.6965332077283435, -2.6859061465803, -2.6752790854322566, -2.664652024284213, -2.6540249631361696, -2.643397901988126, -2.632770840840083, -2.6221437796920397, -2.6115167185439967, -2.6008896573959532, -2.5902625962479098, -2.5796355350998663, -2.569008473951823, -2.55838141280378, -2.5477543516557364, -2.5371272905076934, -2.52650022935965, -2.5158731682116064, -2.505246107063563, -2.4946190459155195, -2.483991984767476, -2.473364923619433, -2.4627378624713896, -2.452110801323346, -2.4414837401753027, -2.4308566790272597, -2.420229617879216, -2.4096025567311727, -2.3989754955831293, -2.3883484344350863, -2.3777213732870424, -2.3670943121389993, -2.356467250990956, -2.345840189842913, -2.335213128694869, -2.324586067546826, -2.3139590063987825, -2.303331945250739, -2.2927048841026956, -2.2820778229546526, -2.2714507618066087, -2.2608237006585656, -2.250196639510522, -2.239569578362479, -2.2289425172144357, -2.2183154560663922, -2.2076883949183492, -2.1970613337703053, -2.1864342726222623, -2.175807211474219, -2.165180150326176, -2.154553089178132, -2.143926028030089, -2.1332989668820455, -2.122671905734002, -2.1120448445859585, -2.1014177834379155, -2.090790722289872, -2.0801636611418286, -2.069536599993785, -2.058909538845742, -2.0482824776976982, -2.037655416549655, -2.0270283554016117, -2.0164012942535687, -2.0057742331055253, -1.9951471719574818, -1.9845201108094388, -1.973893049661395, -1.9632659885133519, -1.9526389273653084, -1.942011866217265, -1.9313848050692215, -1.9207577439211785, -1.910130682773135, -1.8995036216250916, -1.888876560477048, -1.878249499329005, -1.8676224381809612, -1.8569953770329182, -1.8463683158848747, -1.8357412547368317, -1.8251141935887878, -1.8144871324407448, -1.8038600712927013, -1.7932330101446579, -1.7826059489966148, -1.7719788878485714, -1.7613518267005284, -1.7507247655524845, -1.7400977044044414, -1.729470643256398, -1.7188435821083545, -1.708216520960311, -1.697589459812268, -1.6869623986642241, -1.6763353375161811, -1.6657082763681377, -1.6550812152200947, -1.6444541540720508, -1.6338270929240077, -1.6232000317759643, -1.6125729706279208, -1.6019459094798774, -1.5913188483318343, -1.5806917871837909, -1.5700647260357474, -1.5594376648877044, -1.548810603739661, -1.5381835425916175, -1.527556481443574, -1.516929420295531, -1.5063023591474876, -1.495675297999444, -1.4850482368514006, -1.4744211757033576, -1.4637941145553137, -1.4531670534072707, -1.4425399922592272, -1.4319129311111838, -1.4212858699631403, -1.4106588088150973, -1.4000317476670538, -1.3894046865190104, -1.378777625370967, -1.368150564222924, -1.35752350307488, -1.346896441926837, -1.336269380778794, -1.3256423196307505, -1.315015258482707, -1.3043881973346636, -1.2937611361866206, -1.2831340750385767, -1.2725070138905337, -1.2618799527424902, -1.2512528915944472, -1.2406258304464033, -1.2299987692983603, -1.2193717081503168, -1.2087446470022734, -1.19811758585423, -1.1874905247061869, -1.176863463558143, -1.1662364024101, -1.1556093412620565, -1.1449822801140135, -1.1343552189659696, -1.1237281578179266, -1.1131010966698835, -1.1024740355218396, -1.0918469743737966, -1.0812199132257532, -1.0705928520777102, -1.0599657909296663, -1.0493387297816232, -1.0387116686335798, -1.0280846074855363, -1.0174575463374929, -1.0068304851894498, -0.9962034240414064, -0.9855763628933629, -0.9749493017453195, -0.9643222405972764, -0.9536951794492325, -0.9430681183011895, -0.9324410571531461, -0.9218139960051026, -0.9111869348570591, -0.9005598737090161, -0.8899328125609727, -0.8793057514129292, -0.8686786902648862, -0.8580516291168427, -0.8474245679687993, -0.8367975068207558, -0.8261704456727128, -0.8155433845246693, -0.8049163233766259, -0.7942892622285824, -0.7836622010805394, -0.7730351399324955, -0.7624080787844525, -0.751781017636409, -0.741153956488366, -0.7305268953403221, -0.7198998341922791, -0.7092727730442356, -0.6986457118961922, -0.6880186507481487, -0.6773915896001057, -0.6667645284520618, -0.6561374673040188, -0.6455104061559758, -0.6348833450079323, -0.6242562838598888, -0.6136292227118454, -0.6030021615638024, -0.5923751004157585, -0.5817480392677155, -0.571120978119672, -0.560493916971629, -0.5498668558235851, -0.5392397946755421, -0.5286127335274986, -0.5179856723794551, -0.5073586112314121, -0.49673155008336867, -0.4861044889353252, -0.47547742778728175, -0.4648503666392383, -0.45422330549119483, -0.44359624434315137, -0.4329691831951088, -0.42234212204706534, -0.4117150608990219, -0.4010879997509784, -0.39046093860293496, -0.3798338774548915, -0.36920681630684804, -0.35857975515880547, -0.347952694010762, -0.33732563286271766, -0.3266985717146751, -0.31607151056663163, -0.30544444941858817, -0.2948173882705447, -0.28419032712250125, -0.2735632659744578, -0.2629362048264152, -0.2523091436783709, -0.2416820825303274, -0.23105502138228484, -0.22042796023424138, -0.20980089908619703, -0.19917383793815446, -0.188546776790111, -0.17791971564206843, -0.16729265449402497, -0.15666559334598062, -0.14603853219793805, -0.1354114710498946, -0.12478440990185113, -0.11415734875380767, -0.10353028760576422, -0.09290322645772076, -0.08227616530967818, -0.07164910416163384, -0.06102204301359038, -0.050394981865547805, -0.039767920717504346, -0.029140859569459998, -0.018513798421417427, -0.007886737273373967, 0.0027403238746686043, 0.013367385022712952, 0.02399444617075641, 0.03462150731879898, 0.04524856846684244, 0.0558756296148859, 0.06650269076292936, 0.07712975191097282, 0.08775681305901628, 0.09838387420705885, 0.1090109353551032, 0.11963799650314666, 0.13026505765118923, 0.1408921187992327, 0.15151917994727615, 0.1621462410953196, 0.17277330224336307, 0.18340036339140564, 0.19402742453945, 0.20465448568749345, 0.21528154683553602, 0.22590860798357948, 0.23653566913162383, 0.2471627302796664, 0.25778979142770986, 0.2684168525757533, 0.2790439137237959, 0.28967097487184024, 0.3002980360198837, 0.31092509716792627, 0.3215521583159697, 0.3321792194640132, 0.34280628061205665, 0.3534333417601001, 0.3640604029081427, 0.374687464056187, 0.3853145252042305, 0.39594158635227306, 0.4065686475003165, 0.41719570864836086, 0.42782276979640343, 0.4384498309444469, 0.44907689209249035, 0.4597039532405338, 0.4703310143885773, 0.48095807553661984, 0.4915851366846633, 0.5022121978327068, 0.5128392589807502, 0.5234663201287937, 0.5340933812768371, 0.5447204424248797, 0.5553475035729241, 0.5659745647209675, 0.5766016258690101, 0.5872286870170536, 0.5978557481650979, 0.6084828093131405, 0.6191098704611839, 0.6297369316092274, 0.6403639927572709, 0.6509910539053143, 0.6616181150533569, 0.6722451762014003, 0.6828722373494447, 0.6934992984974873, 0.7041263596455307, 0.7147534207935742, 0.7253804819416168, 0.7360075430896611, 0.7466346042377046, 0.7572616653857471, 0.7678887265337906, 0.7785157876818349, 0.7891428488298775], "xaxis": "x", "y": [0.03561525439864836, 0.036396004869936, 0.03717392017977184, 0.03794847585812121, 0.03871917762215639, 0.0394855641593879, 0.04024720984531219, 0.0410037273841418, 0.04175477036145687, 0.042500035697928824, 0.04323926599362585, 0.043972251752799514, 0.044698833479478346, 0.04541890363464851, 0.04613240844627795, 0.046839349563939384, 0.047539785550302804, 0.048233833202292554, 0.048921668695241435, 0.04960352854391324, 0.05027971037480954, 0.05095057350471778, 0.051616539320999154, 0.052278091459649914, 0.05293577577769928, 0.05359020011703382, 0.05424203385725056, 0.05489200725565567, 0.05554091057302751, 0.0561895929842611, 0.05683896127350801, 0.05748997831391813, 0.05814366133258218, 0.05880107996177063, 0.05946335407806537, 0.06013165143149018, 0.060807185067262653, 0.06149121054332686, 0.06218502294737283, 0.06288995371761769, 0.06360736727221339, 0.06433865745275782, 0.06508524378802445, 0.06584856758469051, 0.06663008785253396, 0.0674312770722898, 0.06825361681510059, 0.0690985932232686, 0.06996769236281211, 0.07086239545914529, 0.07178417402803504, 0.07273448491484004, 0.07371476525589053, 0.07472642737673431, 0.0757708536428278, 0.07684939127910274, 0.07796334717567112, 0.0791139826977308, 0.08030250851851245, 0.0815300794948288, 0.08279778960546297, 0.08410666697324477, 0.08545766899219585, 0.08685167758158625, 0.08828949458909786, 0.08977183736555572, 0.09129933453383321, 0.09287252197456064, 0.09449183905117292, 0.09615762509658082, 0.09787011618338483, 0.09962944219900625, 0.1014356242464365, 0.10328857239046346, 0.10518808376823205, 0.1071338410818427, 0.10912541148937019, 0.11116224590920967, 0.11324367875103258, 0.1153689280848503, 0.11753709625777083, 0.11974717096597305, 0.12199802678725016, 0.12428842717718022, 0.12661702692958673, 0.12898237509948035, 0.1313829183841143, 0.13381700495518778, 0.13628288873258704, 0.13877873408739094, 0.1413026209592112, 0.14385255037029743, 0.14642645031623194, 0.14902218201051684, 0.15163754645788327, 0.15427029132882375, 0.15691811810560205, 0.15957868946792964, 0.1622496368845772, 0.16492856837544537, 0.16761307640710074, 0.1703007458834542, 0.1729891621921803, 0.17567591926662993, 0.1783586276224126, 0.18103492232750484, 0.18370247086469843, 0.1863589808454408, 0.1890022075346492, 0.19162996114687061, 0.1942401138752716, 0.1968306066162904, 0.19939945535444464, 0.20194475717368499, 0.2044646958638542, 0.20695754709321548, 0.20942168312064047, 0.2118555770238866, 0.21425780642342795, 0.21662705668448148, 0.21896212358322883, 0.2212619154266766, 0.22352545461915885, 0.22575187867209998, 0.22794044065731592, 0.23009050910780043, 0.23220156737359343, 0.23427321244392935, 0.23630515325039878, 0.23829720846927072, 0.24024930384442578, 0.24216146905547775, 0.24403383415861732, 0.2458666256304551, 0.2476601620476496, 0.24941484943738085, 0.25113117633571386, 0.2528097085926108, 0.2544510839637629, 0.25605600653050775, 0.2576252409898844, 0.25915960685732287, 0.26065997262460294, 0.26212724991549885, 0.2635623876809983, 0.26496636647513205, 0.2663401928512618, 0.2676848939172106, 0.2690015120858312, 0.27029110005555906, 0.27155471605318077, 0.2727934193684812, 0.27400826620765084, 0.2752003058893495, 0.27637057740416127, 0.2775201063548524, 0.2786499022914165, 0.27976095645134447, 0.2808542399119477, 0.2819307021579138, 0.28299127006360636, 0.2840368472859665, 0.2850683140602566, 0.28608652738735335, 0.28709232159783815, 0.2880865092748049, 0.2890698825141335, 0.29004321449794374, 0.2910072613541426, 0.29196276427234824, 0.29291045184410336, 0.29385104259315703, 0.2947852476597223, 0.2957137736010252, 0.29663732526916553, 0.2975566087263005, 0.2984723341564713, 0.2993852187330092, 0.30029598940040053, 0.3012053855297358, 0.3021141614074508, 0.3030230885179595, 0.3039329575819819, 0.3048445803138849, 0.3057587908631717, 0.30667644690735074, 0.30759843036580786, 0.3085256477069406, 0.3094590298237255, 0.31039953145600985, 0.3113481301411691, 0.3123058246783169, 0.313273633094969, 0.31425259010892825, 0.3152437440821588, 0.31624815346751317, 0.317266882753347, 0.318300997915292, 0.3193515613886803, 0.32041962657937834, 0.32150623193495015, 0.32261239460224556, 0.32373910370149767, 0.3248873132509504, 0.3260579347797735, 0.32725182967058064, 0.3284698012762115, 0.3297125868585369, 0.3309808493998724, 0.33227516934009727, 0.3335960362948, 0.3349438408115986, 0.3363188662232858, 0.33772128065753454, 0.33915112926359725, 0.34060832671669694, 0.3420926500606546, 0.3436037319486954, 0.3451410543413403, 0.34670394271878946, 0.34829156086328455, 0.3499029062645603, 0.351536806198677, 0.3531919145273336, 0.35486670926109753, 0.35655949092601424, 0.35826838176865516, 0.35999132582998494, 0.3617260899133985, 0.3634702654670091, 0.3652212713947342, 0.36697635780502413, 0.368732610700181, 0.3704869576032387, 0.37223617411329096, 0.37397689137407397, 0.37570560443452067, 0.3774186814740025, 0.3791123738590683, 0.38078282699275007, 0.38242609191196436, 0.38403813758324384, 0.385614863842036, 0.38715211491611917, 0.38864569346939587, 0.3900913750984006, 0.39148492321040185, 0.3928221042089608, 0.39409870291028903, 0.395310538111733, 0.3964534782322181, 0.3975234569435335, 0.39851648871091433, 0.3994286841615218, 0.4002562652000864, 0.4009955797922021, 0.4016431163374849, 0.40219551755708405, 0.40264959382275756, 0.40300233585795975, 0.4032509267450345, 0.403392753176702, 0.40342541589445374, 0.40334673926131465, 0.40315477992149906, 0.40284783450489287, 0.40242444633988683, 0.4018834111438728, 0.4012237816666426, 0.40044487126795153, 0.39954625641657643, 0.39852777810429885, 0.3973895421742605, 0.3961319185691544, 0.39475553951053205, 0.3932612966262441, 0.391650337048536, 0.389924058510614, 0.3880841034745439, 0.38613235232810644, 0.3840709156926819, 0.38190212588836403, 0.3796285276062905, 0.377252867841567, 0.37477808514322775, 0.3722072982403052, 0.36954379410534755, 0.3667910155185742, 0.3639525481973418, 0.36103210755663223, 0.35803352516697823, 0.354960734976516, 0.3518177593637792, 0.34860869508740705, 0.3453376991981384, 0.34200897497734106, 0.3386267579648731, 0.33519530213733206, 0.3317188662957155, 0.3282017007192303, 0.3246480341394567, 0.3210620610863227, 0.3174479296544007, 0.3138097297349134, 0.31015148175555113, 0.3064771259668117, 0.30279051231001924, 0.2990953908986066, 0.2953954031405348, 0.29169407352600635, 0.2879948021008758, 0.2843008576423944, 0.28061537155016125, 0.2769413324614428, 0.2732815815963264, 0.2696388088345691, 0.2660155495224449, 0.26241418200446903, 0.2588369258715162, 0.2552858409136548, 0.2517628267629116, 0.24826962320826723, 0.244807811162389, 0.24137881425698954, 0.23798390104128464, 0.23462418775573765, 0.23130064165125158, 0.22801408482207483, 0.22476519851905252, 0.22155452790838465, 0.21838248723982046, 0.2152493653871868, 0.21215533172333478, 0.20910044229098906, 0.20608464623059716, 0.2031077924261037, 0.20016963632960708, 0.19726984692608443, 0.19440801379982586, 0.1915836542648229, 0.18879622052218722, 0.18604510680865374, 0.18332965650138222, 0.18064916914558407, 0.17800290737295454, 0.17539010368049282, 0.17280996704099544, 0.17026168931833904, 0.1677444514625829, 0.16525742946192368, 0.16279980003059788, 0.16037074601395113, 0.15796946149404614, 0.1555951565813719, 0.15324706188039608, 0.1509244326189055, 0.14862655243323625, 0.146352736803646, 0.14410233613616927, 0.14187473848934554, 0.13966937194617765, 0.13748570663358398, 0.13532325639341689, 0.13318158011083747, 0.1310602827074574, 0.12895901580816066, 0.1268774780919184, 0.1248154153381794, 0.12277262018157792, 0.12074893158872654, 0.11874423407177247, 0.11675845665416457, 0.11479157160474825, 0.11284359295682343, 0.11091457482921942, 0.10900460956673376, 0.10711382571746067, 0.10524238586461264, 0.10339048433039683, 0.1015583447693952, 0.09974621766866182, 0.09795437777145748, 0.09618312144115268, 0.09443276398137765, 0.09270363692798075, 0.09099608532777796, 0.08931046501845238, 0.08764713992329214, 0.0860064793737462, 0.08438885547204424, 0.08279464050536159, 0.08122420442223119, 0.07967791238111174, 0.07815612238022003, 0.07665918297692983, 0.07518743110423654, 0.0737411899909938, 0.072320767191831, 0.07092645273189054, 0.06955851737075926, 0.0682172109892227, 0.06690276110174849, 0.06561537149690111, 0.06435522100720716, 0.06312246240934132, 0.061917221454867326, 0.060739596031170205, 0.05958965545163664, 0.05846743987360133, 0.057372959842050375, 0.05630619595659536, 0.05526709865876667, 0.05425558813625206, 0.05327155434031384, 0.052314857112248, 0.05138532641442372, 0.05048276266114056, 0.049606937144273486, 0.04875759254844599, 0.04793444355027234, 0.04713717749604286, 0.04636545515209855, 0.04561891152204498, 0.044897156724891446, 0.04419977692817607, 0.043526335330146694, 0.04287637318510301, 0.04224941086608717, 0.04164494895921082, 0.04106246938405138, 0.04050143653471771, 0.039961298436384414, 0.03944148791232415, 0.03894142375671778, 0.03846051190880151, 0.03799814662420728, 0.037553711639672575, 0.03712658132762659, 0.03671612183750969, 0.03632169222103868, 0.03594264553899376, 0.03557832994747059, 0.03522808976190643, 0.034891266497553246, 0.03456719988542324, 0.03425522886307741, 0.0339546925399558, 0.033664931137259047, 0.03338528690267917, 0.03311510500054192, 0.03285373437816181, 0.03260052860941508, 0.032354846716713466, 0.0321160539727013, 0.0318835226831029, 0.031656632952217996, 0.031434773432592315, 0.031217342060384547, 0.031003746777909, 0.0307934062447504, 0.03058575053873502, 0.0303802218478908, 0.03017627515434927, 0.029973378910932692, 0.029771015710932408, 0.029568682951326485, 0.029365893489404764, 0.029162176292477353, 0.02895707708003476, 0.028750158957417234, 0.028541003039734465, 0.028329209064464806, 0.028114395990855016, 0.02789620258394694, 0.027674287980777156, 0.027448332236035163, 0.027218036844229035, 0.02698312523519984, 0.02674334323964814, 0.02649845952119324, 0.02624826597138179, 0.02599257806399598, 0.02573123516498837, 0.025464100794390106, 0.025191062836603318, 0.0249120336955964, 0.02462695039167366, 0.024335774596687676, 0.02403849260480158, 0.0237351152361885, 0.023425677671373928, 0.023110239214281417, 0.022788882982430404, 0.02246171552315059, 0.02212886635512082, 0.021790487435004557, 0.021446752549433394, 0.02109785663308464, 0.0207440150140988, 0.02038546258858504], "yaxis": "y", "type": "scatter"}, {"legendgroup": "Group 2", "marker": {"color": "rgb(255, 127, 14)"}, "mode": "lines", "name": "Group 2", "showlegend": false, "x": [-2.3051903298823304, -2.2963667830629775, -2.287543236243624, -2.278719689424271, -2.269896142604918, -2.261072595785565, -2.2522490489662115, -2.2434255021468585, -2.234601955327505, -2.2257784085081522, -2.216954861688799, -2.208131314869446, -2.1993077680500925, -2.1904842212307396, -2.1816606744113862, -2.1728371275920333, -2.1640135807726804, -2.155190033953327, -2.146366487133974, -2.1375429403146207, -2.1287193934952677, -2.1198958466759144, -2.1110722998565614, -2.102248753037208, -2.093425206217855, -2.0846016593985017, -2.075778112579149, -2.0669545657597954, -2.0581310189404425, -2.0493074721210895, -2.040483925301736, -2.0316603784823832, -2.02283683166303, -2.014013284843677, -2.0051897380243235, -1.9963661912049706, -1.9875426443856172, -1.9787190975662643, -1.9698955507469111, -1.961072003927558, -1.9522484571082048, -1.9434249102888517, -1.9346013634694985, -1.9257778166501454, -1.9169542698307922, -1.908130723011439, -1.8993071761920859, -1.8904836293727327, -1.8816600825533798, -1.8728365357340264, -1.8640129889146735, -1.8551894420953203, -1.8463658952759672, -1.837542348456614, -1.8287188016372609, -1.8198952548179077, -1.8110717079985545, -1.8022481611792014, -1.7934246143598482, -1.7846010675404953, -1.775777520721142, -1.766953973901789, -1.7581304270824356, -1.7493068802630827, -1.7404833334437293, -1.7316597866243764, -1.722836239805023, -1.71401269298567, -1.705189146166317, -1.6963655993469637, -1.6875420525276108, -1.6787185057082574, -1.6698949588889043, -1.6610714120695511, -1.652247865250198, -1.6434243184308448, -1.6346007716114919, -1.6257772247921385, -1.6169536779727856, -1.6081301311534324, -1.5993065843340792, -1.5904830375147259, -1.581659490695373, -1.5728359438760198, -1.5640123970566666, -1.5551888502373135, -1.5463653034179603, -1.5375417565986074, -1.528718209779254, -1.519894662959901, -1.5110711161405477, -1.5022475693211947, -1.4934240225018414, -1.4846004756824884, -1.4757769288631353, -1.4669533820437821, -1.458129835224429, -1.4493062884050758, -1.4404827415857226, -1.4316591947663695, -1.4228356479470163, -1.4140121011276632, -1.4051885543083102, -1.3963650074889569, -1.387541460669604, -1.3787179138502506, -1.3698943670308976, -1.3610708202115445, -1.3522472733921913, -1.343423726572838, -1.334600179753485, -1.3257766329341318, -1.3169530861147787, -1.3081295392954255, -1.2993059924760724, -1.2904824456567192, -1.281658898837366, -1.2728353520180131, -1.26401180519866, -1.2551882583793068, -1.2463647115599537, -1.2375411647406005, -1.2287176179212473, -1.219894071101894, -1.211070524282541, -1.2022469774631879, -1.1934234306438347, -1.1845998838244816, -1.1757763370051284, -1.1669527901857752, -1.158129243366422, -1.149305696547069, -1.1404821497277158, -1.1316586029083628, -1.1228350560890097, -1.1140115092696565, -1.1051879624503034, -1.0963644156309502, -1.087540868811597, -1.078717321992244, -1.069893775172891, -1.0610702283535378, -1.0522466815341844, -1.0434231347148313, -1.0345995878954781, -1.025776041076125, -1.0169524942567718, -1.0081289474374187, -0.9993054006180655, -0.9904818537987126, -0.9816583069793594, -0.9728347601600063, -0.9640112133406531, -0.9551876665212999, -0.9463641197019468, -0.9375405728825936, -0.9287170260632407, -0.9198934792438875, -0.9110699324245344, -0.9022463856051812, -0.8934228387858281, -0.8845992919664747, -0.8757757451471215, -0.8669521983277684, -0.8581286515084152, -0.8493051046890623, -0.8404815578697091, -0.831658011050356, -0.8228344642310028, -0.8140109174116497, -0.8051873705922965, -0.7963638237729433, -0.7875402769535904, -0.7787167301342373, -0.7698931833148841, -0.7610696364955309, -0.7522460896761778, -0.7434225428568246, -0.7345989960374715, -0.7257754492181183, -0.7169519023987649, -0.708128355579412, -0.6993048087600588, -0.6904812619407057, -0.6816577151213525, -0.6728341683019994, -0.6640106214826462, -0.6551870746632931, -0.6463635278439401, -0.637539981024587, -0.6287164342052338, -0.6198928873858807, -0.6110693405665275, -0.6022457937471744, -0.5934222469278212, -0.584598700108468, -0.5757751532891149, -0.566951606469762, -0.5581280596504088, -0.5493045128310554, -0.5404809660117023, -0.5316574191923491, -0.522833872372996, -0.5140103255536428, -0.5051867787342899, -0.4963632319149367, -0.48753968509558354, -0.4787161382762304, -0.46989259145687723, -0.4610690446375241, -0.4522454978181709, -0.44342195099881776, -0.4345984041794646, -0.42577485736011167, -0.4169513105407585, -0.40812776372140536, -0.3993042169020522, -0.3904806700826988, -0.38165712326334567, -0.3728335764439925, -0.3640100296246396, -0.3551864828052864, -0.34636293598593326, -0.3375393891665801, -0.32871584234722695, -0.3198922955278738, -0.31106874870852064, -0.30224520188916726, -0.2934216550698143, -0.2845981082504614, -0.275774561431108, -0.2669510146117551, -0.2581274677924017, -0.24930392097304876, -0.24048037415369583, -0.23165682733434245, -0.22283328051498952, -0.21400973369563614, -0.2051861868762832, -0.19636264005692983, -0.1875390932375769, -0.17871554641822396, -0.16989199959887058, -0.16106845277951765, -0.15224490596016427, -0.14342135914081133, -0.1345978123214575, -0.12577426550210458, -0.11695071868275164, -0.10812717186339826, -0.09930362504404533, -0.09048007822469195, -0.08165653140533902, -0.07283298458598564, -0.0640094377666327, -0.055185890947279326, -0.04636234412792639, -0.03753879730857346, -0.02871525048922008, -0.019891703669867145, -0.011068156850513766, -0.002244610031160832, 0.0065789367881925465, 0.01540248360754548, 0.02422603042689886, 0.03304957724625179, 0.04187312406560473, 0.050696670884958106, 0.05952021770431104, 0.06834376452366442, 0.07716731134301735, 0.08599085816237073, 0.09481440498172367, 0.1036379518010766, 0.11246149862042998, 0.12128504543978291, 0.1301085922591363, 0.13893213907848923, 0.1477556858978426, 0.15657923271719554, 0.16540277953654847, 0.17422632635590185, 0.18304987317525478, 0.1918734199946086, 0.20069696681396154, 0.20952051363331492, 0.21834406045266785, 0.22716760727202123, 0.23599115409137417, 0.2448147009107271, 0.2536382477300805, 0.2624617945494334, 0.2712853413687868, 0.2801088881881397, 0.2889324350074931, 0.29775598182684604, 0.3065795286461994, 0.31540307546555235, 0.3242266222849053, 0.33305016910425866, 0.3418737159236116, 0.350697262742965, 0.3595208095623179, 0.3683443563816713, 0.3771679032010242, 0.38599145002037716, 0.39481499683973054, 0.40363854365908347, 0.41246209047843685, 0.4212856372977898, 0.43010918411714316, 0.4389327309364961, 0.44775627775584903, 0.4565798245752024, 0.46540337139455534, 0.4742269182139087, 0.48305046503326166, 0.49187401185261503, 0.500697558671968, 0.5095211054913213, 0.5183446523106743, 0.5271681991300272, 0.535991745949381, 0.544815292768734, 0.5536388395880874, 0.5624623864074403, 0.5712859332267937, 0.5801094800461466, 0.5889330268655, 0.5977565736848529, 0.6065801205042058, 0.6154036673235592, 0.6242272141429122, 0.6330507609622655, 0.6418743077816185, 0.6506978546009718, 0.6595214014203248, 0.6683449482396777, 0.6771684950590311, 0.685992041878384, 0.6948155886977374, 0.7036391355170903, 0.7124626823364437, 0.7212862291557967, 0.7301097759751496, 0.738933322794503, 0.7477568696138559, 0.7565804164332093, 0.7654039632525622, 0.7742275100719156, 0.7830510568912685, 0.7918746037106219, 0.8006981505299748, 0.8095216973493278, 0.8183452441686812, 0.8271687909880341, 0.8359923378073875, 0.8448158846267404, 0.8536394314460938, 0.8624629782654472, 0.8712865250848005, 0.8801100719041535, 0.8889336187235064, 0.8977571655428598, 0.9065807123622127, 0.9154042591815661, 0.924227806000919, 0.9330513528202724, 0.9418748996396253, 0.9506984464589783, 0.9595219932783317, 0.9683455400976846, 0.977169086917038, 0.9859926337363909, 0.9948161805557443, 1.0036397273750972, 1.0124632741944501, 1.0212868210138035, 1.0301103678331565, 1.0389339146525098, 1.0477574614718628, 1.0565810082912162, 1.065404555110569, 1.0742281019299225, 1.0830516487492754, 1.0918751955686283, 1.1006987423879817, 1.1095222892073346, 1.118345836026688, 1.127169382846041, 1.1359929296653943, 1.1448164764847473, 1.1536400233041006, 1.1624635701234536, 1.1712871169428065, 1.18011066376216, 1.1889342105815128, 1.1977577574008667, 1.2065813042202196, 1.215404851039573, 1.224228397858926, 1.2330519446782788, 1.2418754914976322, 1.2506990383169851, 1.2595225851363385, 1.2683461319556915, 1.2771696787750448, 1.2859932255943978, 1.2948167724137507, 1.303640319233104, 1.312463866052457, 1.3212874128718104, 1.3301109596911633, 1.3389345065105167, 1.3477580533298696, 1.356581600149223, 1.365405146968576, 1.374228693787929, 1.3830522406072823, 1.3918757874266352, 1.4006993342459886, 1.4095228810653415, 1.418346427884695, 1.4271699747040478, 1.4359935215234012, 1.4448170683427541, 1.453640615162107, 1.4624641619814605, 1.4712877088008134, 1.4801112556201668, 1.4889348024395197, 1.497758349258873, 1.506581896078226, 1.515405442897579, 1.5242289897169328, 1.5330525365362857, 1.541876083355639, 1.550699630174992, 1.5595231769943454, 1.5683467238136983, 1.5771702706330513, 1.5859938174524046, 1.5948173642717576, 1.603640911091111, 1.6124644579104639, 1.6212880047298173, 1.6301115515491702, 1.6389350983685236, 1.6477586451878765, 1.6565821920072294, 1.6654057388265828, 1.6742292856459358, 1.6830528324652891, 1.691876379284642, 1.700699926103996, 1.7095234729233488, 1.7183470197427018, 1.7271705665620547, 1.7359941133814076, 1.7448176602007615, 1.7536412070201144, 1.7624647538394673, 1.7712883006588203, 1.780111847478174, 1.788935394297527, 1.79775894111688, 1.8065824879362329, 1.8154060347555867, 1.8242295815749388, 1.8330531283942926, 1.8418766752136455, 1.8507002220329993, 1.8595237688523514, 1.8683473156717052, 1.8771708624910581, 1.885994409310411, 1.894817956129764, 1.9036415029491178, 1.9124650497684708, 1.9212885965878237, 1.9301121434071766, 1.9389356902265305, 1.9477592370458825, 1.9565827838652363, 1.9654063306845893, 1.974229877503943, 1.9830534243232951, 1.991876971142649, 2.000700517962002, 2.009524064781355, 2.0183476116007077, 2.0271711584200616, 2.0359947052394154, 2.0448182520587674, 2.0536417988781213, 2.062465345697474, 2.071288892516827, 2.08011243933618, 2.088935986155534, 2.097759532974887], "xaxis": "x", "y": [0.030578550542863837, 0.03134051079931042, 0.03211194760828613, 0.032892735480551896, 0.03368274435537929, 0.03448183984669143, 0.03528988351247847, 0.0361067331484031, 0.03693224310642945, 0.037766264639208125, 0.038608646270836225, 0.03945923419448, 0.04031787269720329, 0.04118440461218371, 0.04205867179832417, 0.042940515647079645, 0.04382977761611881, 0.044726299789227056, 0.045629925461636696, 0.046540499749739145, 0.047457870223895034, 0.04838188756281625, 0.049312406227745645, 0.050249285154412904, 0.051192388460495945, 0.05214158616607299, 0.05309675492430843, 0.05405777875938506, 0.05502454980846771, 0.05599696906427583, 0.056974947114641655, 0.057958404875251425, 0.05894727431160558, 0.05994149914609038, 0.06094103554593918, 0.06194585278776542, 0.06295593389428737, 0.06397127623882308, 0.06499189211313337, 0.06601780925420886, 0.06704907132565939, 0.06808573834945135, 0.06912788708386525, 0.0701756113437028, 0.07122902225896666, 0.07228824846846163, 0.0733534362450275, 0.07442474954940569, 0.07550237001006492, 0.07658649682666549, 0.07767734659522292, 0.07877515305343886, 0.07988016674509901, 0.08099265460288631, 0.08211289944943256, 0.08324119941691036, 0.08437786728596779, 0.08552322974530821, 0.08667762657372927, 0.08784140974694059, 0.08901494247198684, 0.09019859815259722, 0.09139275928927303, 0.092597816318388, 0.09381416639503327, 0.09504221212475987, 0.09628236024977282, 0.09753502029549854, 0.09880060318377867, 0.10007951981923624, 0.10137217965561712, 0.1026789892491131, 0.10400035080583662, 0.10533666073073138, 0.10668830818526058, 0.1080556736612284, 0.10943912757804306, 0.1108390289106331, 0.11225572385507647, 0.11368954453879475, 0.1151408077819092, 0.11660981391603742, 0.11809684566645536, 0.11960216710313579, 0.1211260226657175, 0.12266863626696663, 0.12423021047874744, 0.12581092580395475, 0.12741094003724796, 0.12903038771680214, 0.1306693796686362, 0.13232800264440592, 0.13400631905287255, 0.13570436678456702, 0.13742215912848127, 0.1391596847789359, 0.14091690793010392, 0.14269376845500772, 0.1444901821651827, 0.14630604114658924, 0.14814121416678747, 0.14999554714785485, 0.15186886369903987, 0.1537609657027044, 0.15567163394671987, 0.15760062879615563, 0.15954769089682266, 0.1615125419030367, 0.16349488522181924, 0.16549440676568697, 0.1675107757061759, 0.16954364522031695, 0.1715926532224145, 0.17365742307369586, 0.17573756426267234, 0.17783267304940054, 0.17994233306725058, 0.18206611587625454, 0.18420358146265053, 0.18635427867982543, 0.1885177456265027, 0.19069350995870596, 0.1928810891327632, 0.19507999057737477, 0.19728971179356128, 0.19950974038212643, 0.20173955399908802, 0.20397862024037647, 0.20622639645793367, 0.20848232951017423, 0.21074585545058958, 0.21301639915906762, 0.2152933739212685, 0.21757618096212497, 0.21986420894022335, 0.22215683341045858, 0.22445341626293622, 0.22675330514661624, 0.22905583288664486, 0.23136031690469813, 0.23366605865197362, 0.23597234306467743, 0.2382784380520068, 0.24058359402667712, 0.2428870434880128, 0.24518800066749977, 0.24748566124648858, 0.24977920215544536, 0.2520677814637604, 0.25435053836865573, 0.2566265932911914, 0.2588950480867373, 0.26115498637657647, 0.26340547400654113, 0.2656455596377446, 0.2678742754735827, 0.2700906381262392, 0.27229364962494323, 0.27448229856720163, 0.2766555614131909, 0.2788124039224103, 0.280951782730626, 0.2830726470640491, 0.28517394058661366, 0.28725460337515, 0.28931357401621927, 0.2913497918173476, 0.2933621991244474, 0.2953497437362704, 0.29731138140588015, 0.2992460784183178, 0.3011528142329033, 0.3030305841779387, 0.3048784021850085, 0.30669530354956165, 0.3084803477040586, 0.3102326209896403, 0.3119512394120583, 0.3136353513674806, 0.31528414032375096, 0.31689682744275766, 0.3184726741297364, 0.32001098449558885, 0.32151110771866304, 0.32297244029288924, 0.32439442814971153, 0.3257765686418608, 0.3271184123777367, 0.3284195648959257, 0.3296796881702287, 0.3308985019364792, 0.33207578483338795, 0.33321137535064466, 0.3343051725785649, 0.3353571367546336, 0.33636728960339424, 0.337335714467245, 0.3382625562268232, 0.33914802101077496, 0.339992375695804, 0.340795947199002, 0.3415591215655136, 0.342282342855623, 0.34296611183634995, 0.3436109844835878, 0.3442175703017075, 0.3447865304684117, 0.34531857581337144, 0.34581446463992765, 0.34627500039975584, 0.3467010292309748, 0.34709343737068754, 0.34745314845334135, 0.3477811207066637, 0.348078344057178, 0.34834583715750245, 0.34858464434774633, 0.34879583256335467, 0.34898048820172506, 0.34913971395980636, 0.34927462565473016, 0.34938634903928273, 0.34947601662374184, 0.3495447645152542, 0.34959372928552374, 0.34962404487716087, 0.34963683955854147, 0.34963323293652615, 0.34961433303583545, 0.34958123345332637, 0.34953501059481296, 0.34947672100149757, 0.3494073987724614, 0.3493280530890675, 0.34923966584652344, 0.34914318939725897, 0.34903954441018786, 0.34892961784936044, 0.34881426107496, 0.34869428806907515, 0.34857047378817724, 0.34844355264375737, 0.3483142171121362, 0.34818311647404165, 0.3480508556841744, 0.34791799437061943, 0.34778504596365833, 0.34765247695323975, 0.3475207062741156, 0.347390104817421, 0.34726099506729347, 0.3471336508609379, 0.3470082972704148, 0.3468851106043041, 0.34676421852729605, 0.34664570029567177, 0.34652958710658066, 0.3464158625589498, 0.3463044632238306, 0.34619527932192873, 0.34608815550604555, 0.3459828917461093, 0.3458792443144412, 0.34577692686886236, 0.34567561163119154, 0.3455749306586347, 0.34547447720549146, 0.3453738071725289, 0.3452724406412784, 0.345169863490396, 0.3450655290911193, 0.3449588600786937, 0.34484925019651, 0.34473606620950265, 0.34461864988319046, 0.3444963200245333, 0.3443683745805738, 0.34423409279060424, 0.3440927373873754, 0.34394355684261596, 0.34378578765189255, 0.3436186566535984, 0.3434413833765987, 0.3432531824108283, 0.34305326579489986, 0.34284084541453513, 0.3426151354054355, 0.3423753545539864, 0.3421207286890155, 0.34185049305764886, 0.34156389467817555, 0.3412601946627074, 0.34093867050233945, 0.34059861830744714, 0.3402393549957476, 0.33986022042075, 0.3394605794332702, 0.3390398238687725, 0.33859737445342275, 0.33813268262189833, 0.33764523224020593, 0.3371345412270031, 0.33660016306719975, 0.33604168821193736, 0.3354587453594141, 0.3348510026114078, 0.33421816850079683, 0.3335599928858381, 0.33287626770746287, 0.3321668276063823, 0.3314315503973449, 0.3306703573984689, 0.32988321361416895, 0.32907012777081596, 0.32823115220489, 0.32736638260402917, 0.3264759576020165, 0.3255600582293992, 0.32461890722206466, 0.3236527681907464, 0.32266194465505205, 0.3216467789462229, 0.3206076509834182, 0.3195449769289056, 0.31845920772807196, 0.31735082754069516, 0.3162203520704011, 0.31506832679968, 0.3138953251382546, 0.3127019464929574, 0.3114888142676095, 0.3102565738016796, 0.309005890256732, 0.3077374464598763, 0.3064519407135548, 0.3051500845811107, 0.30383260065761497, 0.3025002203354139, 0.3011536815738141, 0.2997937266821961, 0.29842110012570217, 0.29703654636242927, 0.2956408077208139, 0.2942346223255915, 0.292818722080381, 0.2913938307145638, 0.2899606619017097, 0.288519917456355, 0.2870722856154539, 0.2856184394103114, 0.2841590351342814, 0.2826947109109363, 0.28122608536686367, 0.2797537564126337, 0.2782783001348967, 0.27680026980195116, 0.2753201949845185, 0.2738385807928483, 0.2723559072306679, 0.2708726286658963, 0.2693891734174497, 0.2679059434568933, 0.2664233142231397, 0.2649416345478569, 0.26346122668873734, 0.26198238646728983, 0.26050538350737085, 0.2590304615702281, 0.25755783898145457, 0.25608770914487583, 0.25462024113808596, 0.2531555803840522, 0.2516938493929688, 0.2502351485683293, 0.24877955707102306, 0.24732713373513204, 0.24587791802901426, 0.2444319310552201, 0.2429891765827654, 0.2415496421053263, 0.24011329991897676, 0.23868010821319766, 0.23725001216901373, 0.2358229450582888, 0.2343988293384056, 0.2329775777367753, 0.23155909431989072, 0.2301432755418935, 0.2287300112679413, 0.22731918576796553, 0.22591067867675296, 0.22450436591662298, 0.2231001205793434, 0.22169781376428294, 0.22029731537017905, 0.21889849483827953, 0.21750122184498732, 0.21610536694252325, 0.21471080214648786, 0.21331740146957587, 0.2119250414010544, 0.2105336013319649, 0.20914296392634504, 0.20775301543909241, 0.20636364598139992, 0.20497474973498062, 0.20358622511657654, 0.20219797489450003, 0.20080990625918974, 0.19942193084997745, 0.19803396474045598, 0.1966459283850061, 0.19525774652919708, 0.19386934808689335, 0.19248066598701807, 0.1910916369929963, 0.18970220149797595, 0.18831230329896242, 0.18692188935302492, 0.18553090951874374, 0.18413931628605068, 0.18274706449757816, 0.18135411106460164, 0.17996041468057933, 0.17856593553523004, 0.17717063503199654, 0.17577447551163708, 0.17437741998458292, 0.17297943187457285, 0.17158047477594646, 0.17018051222684233, 0.16877950750040088, 0.16737742341592562, 0.1659742221717951, 0.1645698652017761, 0.16316431305620593, 0.16175752530937176, 0.16034946049423832, 0.15894007606551336, 0.1575293283918836, 0.15611717277807702, 0.15470356351726083, 0.15328845397410992, 0.1518717966987292, 0.15045354357144947, 0.14903364597836977, 0.14761205501735544, 0.1461887217340578, 0.14476359738737296, 0.1433366337436075, 0.14190778339848248, 0.14047700012596365, 0.1390442392527722, 0.13760945805729669, 0.13617261619149618, 0.13473367612426387, 0.13329260360458853, 0.1318493681427474, 0.13040394350763443, 0.12895630823823398, 0.12750644616713264, 0.12605434695387271, 0.12460000662585316, 0.12314342812439645, 0.12168462185352419, 0.12022360622890348, 0.11876040822437071, 0.11729506391337417, 0.11582761900263551, 0.11435812935528646, 0.11288666150071663, 0.1114132931283422, 0.10993811356251139, 0.10846122421575508, 0.1069827390176277, 0.10550278481639626, 0.10402150175089969, 0.10253904358994663, 0.10105557803670308, 0.09957128699560318, 0.09808636679942286, 0.0966010283942756, 0.09511549748041578, 0.09363001460688611, 0.09214483521820781, 0.09066022965147921, 0.08917648308244643, 0.08769389541929762, 0.08621278114315904, 0.08473346909447603, 0.0832563022047126, 0.08178163717303183, 0.08030984408787442, 0.07884130599360764, 0.07737641840267387, 0.07591558875394072, 0.07445923581820656, 0.07300778905209607, 0.07156168790183552, 0.07012138105866478], "yaxis": "y", "type": "scatter"}, {"legendgroup": "Group 3", "marker": {"color": "rgb(44, 160, 44)"}, "mode": "lines", "name": "Group 3", "showlegend": false, "x": [-0.49089307211867483, -0.4799193788616163, -0.4689456856045577, -0.4579719923474991, -0.44699829909044053, -0.436024605833382, -0.4250509125763234, -0.4140772193192648, -0.40310352606220623, -0.3921298328051477, -0.3811561395480891, -0.37018244629103053, -0.35920875303397193, -0.3482350597769134, -0.3372613665198548, -0.32628767326279623, -0.3153139800057376, -0.3043402867486791, -0.29336659349162053, -0.2823929002345619, -0.2714192069775033, -0.2604455137204448, -0.2494718204633862, -0.23849812720632763, -0.22752443394926902, -0.21655074069221047, -0.20557704743515193, -0.19460335417809332, -0.18362966092103472, -0.17265596766397617, -0.16168227440691763, -0.15070858114985902, -0.13973488789280047, -0.12876119463574187, -0.11778750137868327, -0.10681380812162478, -0.09584011486456617, -0.08486642160750757, -0.07389272835044902, -0.06291903509339042, -0.05194534183633187, -0.04097164857927332, -0.02999795532221472, -0.019024262065156117, -0.008050568808097569, 0.002923124448961034, 0.013896817706019582, 0.02487051096307824, 0.03584420422013679, 0.046817897477195225, 0.057791590734253884, 0.06876528399131243, 0.07973897724837098, 0.09071267050542964, 0.10168636376248819, 0.11266005701954673, 0.12363375027660539, 0.13460744353366394, 0.1455811367907225, 0.15655483004778104, 0.16752852330483958, 0.17850221656189813, 0.1894759098189568, 0.20044960307601534, 0.21142329633307388, 0.22239698959013254, 0.2333706828471911, 0.24434437610424964, 0.2553180693613083, 0.26629176261836685, 0.2772654558754253, 0.28823914913248394, 0.2992128423895425, 0.31018653564660104, 0.3211602289036597, 0.33213392216071824, 0.3431076154177768, 0.35408130867483545, 0.365055001931894, 0.37602869518895254, 0.3870023884460111, 0.39797608170306964, 0.4089497749601282, 0.41992346821718685, 0.4308971614742454, 0.44187085473130394, 0.4528445479883626, 0.46381824124542115, 0.4747919345024797, 0.48576562775953835, 0.4967393210165969, 0.5077130142736553, 0.518686707530714, 0.5296604007877725, 0.5406340940448313, 0.5516077873018899, 0.5625814805589484, 0.5735551738160067, 0.5845288670730653, 0.595502560330124, 0.6064762535871826, 0.6174499468442411, 0.6284236401012997, 0.6393973333583582, 0.6503710266154168, 0.6613447198724756, 0.6723184131295341, 0.6832921063865927, 0.6942657996436512, 0.7052394929007098, 0.7162131861577683, 0.7271868794148271, 0.7381605726718856, 0.7491342659289442, 0.7601079591860027, 0.7710816524430613, 0.7820553457001198, 0.7930290389571786, 0.8040027322142369, 0.8149764254712955, 0.825950118728354, 0.8369238119854125, 0.8478975052424711, 0.8588711984995299, 0.8698448917565884, 0.880818585013647, 0.8917922782707055, 0.902765971527764, 0.9137396647848226, 0.9247133580418814, 0.9356870512989399, 0.9466607445559985, 0.957634437813057, 0.9686081310701156, 0.9795818243271741, 0.9905555175842329, 1.0015292108412914, 1.01250290409835, 1.0234765973554085, 1.0344502906124668, 1.0454239838695254, 1.0563976771265842, 1.0673713703836427, 1.0783450636407013, 1.0893187568977598, 1.1002924501548184, 1.111266143411877, 1.1222398366689357, 1.1332135299259942, 1.1441872231830528, 1.1551609164401113, 1.1661346096971699, 1.1771083029542284, 1.1880819962112872, 1.1990556894683457, 1.2100293827254043, 1.2210030759824628, 1.2319767692395214, 1.24295046249658, 1.2539241557536387, 1.264897849010697, 1.2758715422677556, 1.2868452355248141, 1.2978189287818727, 1.3087926220389312, 1.31976631529599, 1.3307400085530485, 1.341713701810107, 1.3526873950671656, 1.3636610883242242, 1.3746347815812827, 1.3856084748383415, 1.3965821680954, 1.4075558613524586, 1.4185295546095171, 1.4295032478665757, 1.4404769411236342, 1.451450634380693, 1.4624243276377515, 1.47339802089481, 1.4843717141518686, 1.4953454074089272, 1.5063191006659855, 1.517292793923044, 1.5282664871801028, 1.5392401804371612, 1.55021387369422, 1.5611875669512787, 1.5721612602083375, 1.5831349534653958, 1.5941086467224546, 1.6050823399795129, 1.6160560332365717, 1.62702972649363, 1.6380034197506883, 1.648977113007747, 1.6599508062648054, 1.6709244995218642, 1.681898192778923, 1.6928718860359813, 1.70384557929304, 1.7148192725500984, 1.7257929658071571, 1.7367666590642155, 1.7477403523212742, 1.758714045578333, 1.7696877388353913, 1.78066143209245, 1.7916351253495084, 1.8026088186065672, 1.813582511863626, 1.8245562051206843, 1.835529898377743, 1.8465035916348014, 1.8574772848918601, 1.8684509781489185, 1.8794246714059772, 1.890398364663036, 1.9013720579200943, 1.912345751177153, 1.9233194444342114, 1.9342931376912702, 1.945266830948329, 1.9562405242053873, 1.967214217462446, 1.9781879107195044, 1.9891616039765632, 2.0001352972336215, 2.0111089904906803, 2.022082683747739, 2.0330563770047974, 2.044030070261856, 2.0550037635189145, 2.065977456775973, 2.076951150033032, 2.08792484329009, 2.0988985365471486, 2.109872229804207, 2.1208459230612657, 2.131819616318324, 2.142793309575383, 2.1537670028324416, 2.1647406960895, 2.1757143893465587, 2.186688082603617, 2.197661775860676, 2.2086354691177346, 2.219609162374793, 2.2305828556318517, 2.24155654888891, 2.2525302421459688, 2.263503935403027, 2.274477628660086, 2.2854513219171446, 2.296425015174203, 2.3073987084312617, 2.31837240168832, 2.329346094945379, 2.3403197882024376, 2.351293481459496, 2.3622671747165547, 2.373240867973613, 2.3842145612306718, 2.39518825448773, 2.406161947744789, 2.4171356410018476, 2.428109334258906, 2.4390830275159647, 2.450056720773023, 2.461030414030082, 2.4720041072871406, 2.482977800544199, 2.4939514938012577, 2.504925187058316, 2.515898880315375, 2.526872573572433, 2.537846266829492, 2.5488199600865507, 2.5597936533436085, 2.5707673466006673, 2.5817410398577256, 2.5927147331147844, 2.603688426371843, 2.6146621196289015, 2.6256358128859603, 2.6366095061430186, 2.6475831994000774, 2.6585568926571357, 2.6695305859141945, 2.6805042791712532, 2.6914779724283115, 2.7024516656853703, 2.7134253589424286, 2.7243990521994874, 2.735372745456546, 2.7463464387136045, 2.7573201319706633, 2.7682938252277216, 2.7792675184847804, 2.7902412117418387, 2.8012149049988975, 2.8121885982559562, 2.8231622915130146, 2.8341359847700733, 2.8451096780271317, 2.8560833712841904, 2.867057064541249, 2.8780307577983075, 2.8890044510553663, 2.8999781443124246, 2.9109518375694834, 2.9219255308265417, 2.9328992240836005, 2.9438729173406593, 2.9548466105977176, 2.9658203038547764, 2.9767939971118347, 2.9877676903688934, 2.998741383625952, 3.0097150768830105, 3.020688770140069, 3.031662463397127, 3.042636156654186, 3.0536098499112443, 3.064583543168303, 3.075557236425362, 3.08653092968242, 3.097504622939479, 3.1084783161965372, 3.119452009453596, 3.130425702710655, 3.141399395967713, 3.152373089224772, 3.16334678248183, 3.174320475738889, 3.1852941689959473, 3.196267862253006, 3.207241555510065, 3.218215248767123, 3.229188942024182, 3.2401626352812403, 3.251136328538299, 3.262110021795358, 3.273083715052416, 3.284057408309475, 3.2950311015665332, 3.306004794823592, 3.3169784880806503, 3.327952181337709, 3.338925874594768, 3.349899567851826, 3.360873261108885, 3.3718469543659433, 3.382820647623002, 3.393794340880061, 3.404768034137119, 3.415741727394178, 3.4267154206512362, 3.437689113908295, 3.4486628071653533, 3.459636500422412, 3.470610193679471, 3.481583886936529, 3.4925575801935875, 3.503531273450646, 3.514504966707704, 3.525478659964763, 3.5364523532218217, 3.5474260464788805, 3.5583997397359393, 3.569373432992997, 3.580347126250056, 3.5913208195071147, 3.6022945127641735, 3.613268206021232, 3.624241899278291, 3.6352155925353498, 3.6461892857924076, 3.6571629790494664, 3.668136672306525, 3.679110365563584, 3.6900840588206427, 3.7010577520777006, 3.7120314453347594, 3.723005138591818, 3.733978831848876, 3.744952525105935, 3.7559262183629927, 3.7668999116200514, 3.77787360487711, 3.788847298134169, 3.7998209913912278, 3.8107946846482856, 3.8217683779053444, 3.832742071162403, 3.843715764419462, 3.8546894576765207, 3.8656631509335786, 3.8766368441906374, 3.887610537447696, 3.898584230704755, 3.909557923961813, 3.9205316172188716, 3.9315053104759303, 3.942479003732989, 3.953452696990048, 3.9644263902471057, 3.9754000835041645, 3.9863737767612233, 3.997347470018282, 4.00832116327534, 4.019294856532399, 4.030268549789458, 4.041242243046517, 4.0522159363035755, 4.063189629560634, 4.074163322817691, 4.08513701607475, 4.096110709331809, 4.1070844025888675, 4.118058095845926, 4.129031789102985, 4.140005482360044, 4.150979175617103, 4.161952868874161, 4.172926562131218, 4.183900255388277, 4.194873948645336, 4.205847641902395, 4.2168213351594535, 4.227795028416512, 4.238768721673571, 4.24974241493063, 4.2607161081876885, 4.271689801444747, 4.282663494701804, 4.293637187958863, 4.304610881215922, 4.315584574472981, 4.326558267730039, 4.337531960987098, 4.348505654244157, 4.359479347501216, 4.3704530407582745, 4.381426734015333, 4.39240042727239, 4.403374120529449, 4.414347813786508, 4.4253215070435665, 4.436295200300625, 4.447268893557684, 4.458242586814743, 4.469216280071802, 4.48018997332886, 4.491163666585917, 4.502137359842976, 4.513111053100035, 4.524084746357094, 4.5350584396141524, 4.546032132871211, 4.55700582612827, 4.567979519385329, 4.5789532126423875, 4.589926905899446, 4.600900599156503, 4.611874292413562, 4.622847985670621, 4.63382167892768, 4.644795372184738, 4.655769065441797, 4.666742758698854, 4.677716451955913, 4.688690145212972, 4.69966383847003, 4.710637531727089, 4.721611224984148, 4.732584918241207, 4.7435586114982655, 4.7545323047553225, 4.765505998012381, 4.77647969126944, 4.787453384526499, 4.798427077783558, 4.809400771040616, 4.820374464297675, 4.831348157554734, 4.842321850811793, 4.853295544068851, 4.864269237325908, 4.875242930582967, 4.886216623840026, 4.897190317097085, 4.9081640103541435, 4.919137703611202, 4.930111396868261, 4.94108509012532, 4.952058783382379, 4.963032476639436, 4.974006169896494, 4.984979863153553], "xaxis": "x", "y": [0.029732583178486285, 0.030536754433693497, 0.031347863265104144, 0.03216563199396359, 0.03298979590803587, 0.03382010488090892, 0.03465632493650801, 0.03549823974847771, 0.03634565206421594, 0.037198385043536175, 0.0380562835021965, 0.03891921505086614, 0.039787071120504176, 0.04065976786559838, 0.041537246937253344, 0.042419476118728684, 0.04330644981670185, 0.044198189402269675, 0.0450947433965006, 0.045996187496205154, 0.04690262443649888, 0.047814183687686904, 0.048731020984998374, 0.0496533176907312, 0.05058127998943663, 0.05151513791786042, 0.05245514423246906, 0.053401573118505616, 0.05435471874564454, 0.055314893676431484, 0.05628242713479996, 0.05725766314304217, 0.05824095853666843, 0.059232680867608106, 0.060233206207182616, 0.06124291686120086, 0.06226219901039146, 0.06329144029017761, 0.06433102732451969, 0.06538134322918486, 0.0664427651003496, 0.06751566150489173, 0.06860038998907902, 0.06969729462260657, 0.07080670359506963, 0.0719289268819822, 0.07306425399735604, 0.07421295184964467, 0.07537526271752687, 0.07655140236155217, 0.07774155828710567, 0.07894588817346214, 0.08016451848289964, 0.08139754326293187, 0.08264502315369802, 0.08390698461142893, 0.08518341935768807, 0.08647428406277667, 0.08777950027030369, 0.0890989545684501, 0.09043249901192549, 0.09177995179702517, 0.09314109819055622, 0.09451569171172622, 0.09590345556438613, 0.09730408431530078, 0.09871724581239809, 0.10014258333523211, 0.10157971796819734, 0.10302825118536266, 0.10448776763416844, 0.10595783810365249, 0.10743802266135878, 0.10892787394164838, 0.11042694056677035, 0.11193477068080031, 0.11345091557538667, 0.11497493338521006, 0.11650639283012897, 0.11804487698019471, 0.11958998701905227, 0.12114134598072568, 0.12269860243441066, 0.12426143409166901, 0.12582955131035573, 0.12740270046968394, 0.12898066719108614, 0.1305632793799246, 0.13215041006366646, 0.13374198000285875, 0.13533796005210708, 0.13693837324929203, 0.13854329661242895, 0.14015286262489565, 0.14176726039121212, 0.1433867364471389, 0.1450115952095858, 0.14664219905364081, 0.14827896800598, 0.14992237904594882, 0.15157296500774214, 0.15323131307930585, 0.1548980628958682, 0.1565739042283303, 0.158259574269122, 0.15995585452053887, 0.1616635672929928, 0.16338357182304714, 0.16511676002352624, 0.16686405188039538, 0.16862639051347392, 0.17040473692037109, 0.1722000644252918, 0.1740133528565543, 0.1758455824787544, 0.17769772770752645, 0.17957075063672398, 0.18146559440962862, 0.1833831764674012, 0.18532438170949392, 0.18729005560204037, 0.18928099727140987, 0.19129795262107271, 0.19334160751071128, 0.19541258103709414, 0.19751141895661298, 0.19963858728954603, 0.20179446614606242, 0.2039793438137088, 0.20619341114561288, 0.20843675628790706, 0.2107093597839115, 0.21301109009140298, 0.21534169954788135, 0.21770082081705555, 0.22008796384789112, 0.2225025133754327, 0.22494372699027257, 0.2274107338009859, 0.22990253371109226, 0.23241799732915197, 0.23495586652747052, 0.23751475566158065, 0.24009315345921037, 0.24268942558384934, 0.24530181787430422, 0.24792846025780646, 0.2505673713303439, 0.2532164635939052, 0.2558735493363341, 0.2585363471354683, 0.26120248896523046, 0.2638695278773716, 0.2665349462286549, 0.2691961644194581, 0.27185055010606457, 0.274495427845368, 0.27712808912732656, 0.279745802747321, 0.2823458254676186, 0.2849254129144377, 0.2874818306546769, 0.2900123653942538, 0.2925143362381845, 0.29498510595107935, 0.29742209215562787, 0.2998227784059185, 0.30218472507211536, 0.30450557997306854, 0.3067830886939309, 0.30901510452673386, 0.31119959797320024, 0.3133346657507889, 0.3154185392451179, 0.317449592354453, 0.31942634867489034, 0.3213474879781823, 0.32321185193783236, 0.32501844906311866, 0.3267664588050292, 0.32845523480274036, 0.33008430724415183, 0.33165338431911773, 0.3331623527493339, 0.33461127738431345, 0.3360003998584908, 0.33733013631018427, 0.33860107416884533, 0.3398139680228023, 0.3409697345853506, 0.3420694467826952, 0.34311432699271277, 0.3441057394688748, 0.3450451819887795, 0.3459342767716753, 0.3467747607139739, 0.3475684749961087, 0.34831735411808884, 0.3490234144247353, 0.34968874218486373, 0.3503154812915125, 0.3509058206527469, 0.35146198134454426, 0.35198620359880844, 0.3524807337005996, 0.3529478108692838, 0.3533896541984197, 0.35380844972885256, 0.35420633772868265, 0.35458540025250435, 0.3549476490506121, 0.3552950138967137, 0.35562933140015857, 0.35595233436572477, 0.3562656417607024, 0.3565707493453509, 0.35686902101880474, 0.35716168092825656, 0.3574498063846739, 0.3577343216235651, 0.358015992444317, 0.35829542175649526, 0.3585730460562333, 0.35884913285043296, 0.35912377904108755, 0.359396910276528, 0.35966828127092587, 0.3599374770879234, 0.3602039153788699, 0.36046684956083475, 0.3607253729143851, 0.36097842357608695, 0.36122479039581057, 0.36146311962428906, 0.3616919223919097, 0.3619095829355723, 0.3621143675264868, 0.3623044340481901, 0.3624778421707073, 0.3626325640637925, 0.3627664955895045, 0.3628774679120462, 0.3629632594608236, 0.3630216081810732, 0.363050224005155, 0.3630468014767547, 0.3630090324597246, 0.36293461886318595, 0.36282128531475516, 0.36266679171438254, 0.3624689456022623, 0.36222561427561356, 0.3619347365908138, 0.3615943343893613, 0.36120252348849763, 0.3607575241799419, 0.3602576711831212, 0.3597014230024817, 0.3590873706419134, 0.3584142456330069, 0.3576809273377521, 0.35688644949037496, 0.3560300059472478, 0.3551109556182115, 0.3541288265571274, 0.35308331919409147, 0.35197430869639174, 0.3508018464499841, 0.3495661606579676, 0.3482676560572504, 0.34690691275923363, 0.34548468422494055, 0.3440018943895282, 0.34245963395549645, 0.34085915587817184, 0.33920187007113395, 0.3374893373631776, 0.33572326274211695, 0.33390548792423913, 0.3320379832914874, 0.33012283924147173, 0.32816225699815416, 0.32615853893354496, 0.324114078452926, 0.32203134949803225, 0.3199128957241978, 0.3177613194087723, 0.31557927014909026, 0.31336943340891626, 0.311134518972664, 0.30887724936669236, 0.3066003483067219, 0.3043065292298196, 0.301998483968519, 0.299678871623468, 0.2973503076895251, 0.2950153534884968, 0.29267650595970596, 0.2903361878573271, 0.2879967384009404, 0.28566040442304125, 0.2833293320543321, 0.28100555898449403, 0.27869100733287766, 0.2763874771600919, 0.2740966406478937, 0.27182003697109486, 0.26955906788139256, 0.2673149940191518, 0.26508893196524486, 0.26288185204105496, 0.2606945768607771, 0.25852778063613435, 0.2563819892296754, 0.2542575809488795, 0.25215478806943303, 0.25007369907226934, 0.24801426157527418, 0.24597628593702486, 0.2439594495065048, 0.24196330148949963, 0.2399872683993071, 0.23803066005651974, 0.23609267609997817, 0.23417241296856184, 0.23226887131128177, 0.2303809637812095, 0.2285075231670883, 0.2266473108150794, 0.22479902529196943, 0.22296131124033267, 0.22113276837560927, 0.21931196057480962, 0.21749742500662061, 0.21568768125303084, 0.2138812403732537, 0.2120766138616497, 0.21027232245258057, 0.2084669047266224, 0.20665892547431583, 0.20484698377566074, 0.2030297207557957, 0.2012058269797913, 0.19937404945214918, 0.19753319818948037, 0.19568215233784875, 0.19381986580944857, 0.19194537241657797, 0.19005779048425855, 0.18815632692632295, 0.18624028077329088, 0.1843090461439115, 0.18236211465575966, 0.18039907727379528, 0.17841962559923924, 0.17642355260449802, 0.17441075282313978, 0.17238122200707912, 0.17033505626612944, 0.1682724507079218, 0.16619369759884792, 0.1640991840691344, 0.16198938938739654, 0.15986488183202427, 0.1577263151885287, 0.15557442490348322, 0.15341002392696534, 0.15123399827640072, 0.14904730235545036, 0.1468509540620569, 0.144646029719981, 0.14243365886811896, 0.14021501894160598, 0.1379913298781763, 0.13576384868250205, 0.13353386398025363, 0.13130269059245883, 0.12907166415936874, 0.12684213584152532, 0.12461546712403698, 0.12239302474826971, 0.12017617579324187, 0.11796628292700649, 0.1157646998462255, 0.11357276692002577, 0.11139180705206474, 0.10922312177258595, 0.10706798757009542, 0.10492765247017627, 0.10280333286689618, 0.10069621061026521, 0.09860743035128346, 0.0965380971443023, 0.09448927430470533, 0.0924619815183346, 0.09045719319760771, 0.08847583707796301, 0.08651879304707194, 0.08458689219822178, 0.08268091609838682, 0.0808015962607511, 0.07894961381086026, 0.07712559933512217, 0.0753301329000648, 0.07356374423057913, 0.0718269130353239, 0.07012006946753278, 0.06844359470963819, 0.06679782167040209, 0.06518303578359678, 0.06359947589772559, 0.062047335246764784, 0.060526762492471325, 0.05903786282938858, 0.05758069914431255, 0.05615529322262178, 0.05476162699452263, 0.053399643814908075, 0.0520692497711665, 0.050770315013878894, 0.049502675105934986, 0.04826613238613815, 0.0470604573438737, 0.04588539000187415, 0.04474064130451571, 0.04362589450943794, 0.042540806580571855, 0.04148500958091007, 0.04045811206353594, 0.03945970045957045, 0.03848934046177886, 0.03754657840262365, 0.03663094262554473, 0.035741944848213185, 0.03487908151643206, 0.034041835147262695, 0.03322967565983586, 0.032442061692180786, 0.031678441902260976, 0.03093825625127061, 0.03022093726710789, 0.029525911285815373, 0.028852599668669092, 0.028200419992508004, 0.02756878721082894, 0.026957114783137413, 0.02636481577003646, 0.02579130389156629, 0.02523599454636704, 0.02469830578933784, 0.024177659265598592, 0.023673481098731113, 0.02318520273147774, 0.022712261717312138, 0.022254102461558335, 0.021810176911023854, 0.021379945191423038, 0.020962876192192555, 0.020558448098642997, 0.020166148871736816, 0.019785476676133677, 0.019415940257491326, 0.019057059270350302, 0.018708364558258105, 0.018369398388096436, 0.018039714640863073, 0.0177188789614198, 0.01740646886994615, 0.017102073838036008, 0.016805295332531108, 0.016515746830305995, 0.016233053807296317, 0.01595685370510103, 0.01568679587848043, 0.015422541527026526, 0.015163763614191979, 0.01491014677673496, 0.014661387227471021, 0.014417192654021214, 0.014177282116012354, 0.013941385942924048, 0.013709245634490125, 0.013480613765257832, 0.013255253894585749, 0.013032940483031177, 0.012813458815739838, 0.0125966049331137, 0.01238218556869951, 0.012170018093916823, 0.01195993046893348, 0.011751761198705898, 0.011545359292930152, 0.01134058422840776, 0.01113730591211459, 0.010935404643079646, 0.010734771071032377, 0.010535306149665866, 0.01033692108228894, 0.010139537257604593, 0.009943086173355393], "yaxis": "y", "type": "scatter"}, {"legendgroup": "Group 1", "marker": {"color": "rgb(31, 119, 180)", "symbol": "line-ns-open"}, "mode": "markers", "name": "Group 1", "showlegend": false, "x": [-0.7001341255632894, -2.7172511925337575, -2.676794270670189, -2.6964446858959312, -2.3388928773462667, -1.847642891977336, -3.210894349642625, -2.2898729324478087, -1.9244543234010134, -1.542874183075713, -2.0754999748655023, -1.7856536834250376, -3.040947008587687, 0.07296146053555974, -1.4574074643435826, -1.7635493939449756, -1.6943474178388795, -1.5269952539428016, -2.126856434052626, -3.2339313852197904, -2.229073321043474, -2.4519322943174995, -1.5933134873240007, -0.6903733959324143, -1.3817682798248496, -1.652125744268151, -0.6199070424919042, -1.9163560659405248, -3.2347436984429128, -1.7761428704481794, -3.1830313137403667, -2.235077023028927, -1.2738689616688594, -2.1007484841057016, -1.5392092574586933, -2.4600601309120247, -3.6664778524223434, -1.8524516379380398, 0.5525322934643988, -2.660453913188509, -4.362901504139749, -2.049063035182252, -1.1969930251191707, -1.5743690071507477, -1.2864344729916635, -0.9849779436484396, -1.6878024520549424, 0.1829829144953803, -2.543032079320584, -1.7205487317562351, -0.8742656894985334, -0.7699996012987991, -1.6404437441283095, -1.317796459741734, -2.636155433134551, -1.6583513120593163, -2.6066910484979013, -2.7173169562551918, -1.5814653919651989, -3.2811250576510176, -4.513760664043757, -1.6266938116970924, -2.8898192402536935, -2.631556308011037, -1.3626901022955216, -1.7010521667453882, -1.7177525685833468, -1.2803534777918295, 0.333916271260986, -1.5065659430831053, -3.410935441254124, -1.839151536948116, -2.458231832443594, -3.046030982683657, -2.1076103775193697, -3.4599948355383665, -1.9503142618495652, -0.7390641682030863, -2.095145388868499, -2.2042237028946716, -4.2955306806915186, -3.4563508850632862, -3.070179303049419, -1.2490625452829043, -2.6526469977759244, -2.2606102303411753, -2.953918573872213, -2.2215338586417848, 0.7997699099779205, -1.4399830550926749, -3.155934837840408, -2.4940767278457523, -2.9842069002229676, -1.7321559150182628, -1.7737935613986184, -0.9734807829493486, -0.9421855450060717, -3.0069836106440784, -2.652724902272573, -1.3254582776518506, -1.1406031384752189, -3.2796177486799647, -1.6775017255902434, -3.1296883700230786, -3.1014040027311163, -2.0650642358696616, -2.261813483808236, -0.4644464329340081, -0.4067739141190603, -1.4389926994318456, -2.4827341964034995, -3.512030344355951, -1.861916688624474, -2.8468693076402993, -0.23617579874728767, -2.885562366891033, -1.1066291071620575, -0.5076815559149137, -2.6764518173374894, -1.3604383970665017, -0.42635353269395315, -1.9024282181539145, -3.3004395387476304, -2.817717916934475, 0.6960514327101728, -3.6486207347857085, -2.9464712157919863, -0.7155534591607737, -1.290011320758599, -2.280297559178461, -1.7668484751937508, -1.7150018848417312, -2.5594268443531654, -3.2138667507434104, -3.9276149209611186, -1.8104704118590487, -2.7302407338755277, -2.3457237650393705, -1.300507238584432, -0.8876117782246515, -2.2586324543219694, -2.415195794522053, -2.252253227058963, -3.917024272381176, -1.8009676228168603, -1.024965699942972, -3.492769047579727, -1.7042944138737235, -3.1821649721916394, -2.286263091969299, -2.3182822436596964, -2.5663989625637575, -1.8589510961827158, -2.323425703821542, -2.4563339354733165, -2.366833930784866, -1.5308788907923214, -4.165218214735708, -3.291390449496774, -3.2175513149350925, -1.72793252715239, -3.039473171726544, -2.7699011031058003, -2.456515129529819, -4.00987888592009, -1.7481251605437336, -2.103650867075174, -0.8366289940032827, -3.004221577671708, -4.235359182835562, -0.19867191918459715, -3.0137625153377265, -1.749475407970678, -1.2960148185724012, -1.4761126976406949, -1.523885136928605, -1.8612623487242956, -0.6822185126115037, -4.424196252116276, -3.324797064659511, -1.5445552654630144, -1.4747820270092151, -3.3762704966110535, -0.9052491977232247, -0.9970369804168571, -1.5835927337811881, -1.4412066278280562, -0.9701265284276988, -2.7190632319794537, -1.663170575198067, -1.2700863259352762, -1.2869000274968823, -1.8613208637431664, -3.1244784717183567, -2.6861355399663176, -1.7458057189793708, -1.6113770819690965, -1.9462632722248454, -1.8984910858597113, -3.8742912646132095], "xaxis": "x", "y": ["Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1", "Group 1"], "yaxis": "y2", "type": "scatter"}, {"legendgroup": "Group 2", "marker": {"color": "rgb(255, 127, 14)", "symbol": "line-ns-open"}, "mode": "markers", "name": "Group 2", "showlegend": false, "x": [-2.186606161142207, -0.7907084842026084, 0.6215684936273707, -0.6664573109260641, -1.8261029062383782, 0.49553610585758134, -0.9125973856082791, -0.606798197088081, -0.11130608036943589, 1.1581991444159523, 0.0435360654408021, 0.7025225238485446, -0.6270046152333697, -0.6652401348640777, 0.06301316703050687, 1.4002524740850435, 2.0496219351940357, -1.2088372669460596, 0.7755733011511213, 1.5865109652792682, -1.0893739523672943, 1.040533813292226, 0.6200455077540833, -0.7930354323485305, -1.6066380023928095, 1.4915784456841539, -0.06163245082462851, 0.1748525823997394, -1.7533759372833875, -0.39943220827913073, 0.5824830131689823, 0.9296329195109067, -0.05367283827555803, 0.08493359653172511, -0.6819041384685466, -0.5437498200694375, 0.2272237032884355, 1.2433958758062367, 1.3596122997568345, 1.369986710960303, -0.473824575123805, 0.18806963810745572, 0.8042722376668314, 0.4335118855729404, -0.5812341305492782, 2.044458427915941, -0.8264550515142165, -1.3086865520400053, 1.3685938576983765, 0.5471190402847167, 0.6679851112578952, -0.24951759256147674, -1.7998569326756668, -0.6193525043756357, 1.208263744870649, -1.0638463002820109, 1.8330393826136904, 0.28165754126597176, 1.18016380489207, -0.5118137185892909, 0.18883973942326235, -0.6885903293818294, 0.8062748190781387, 0.16348960402620802, 0.03177748819295189, -0.46526643742186446, 1.6225623336120352, 0.3476282863896616, -0.5560069054083071, -0.18044974875446287, -0.5307680039569107, -1.170608274912844, 0.9441252836419484, -0.5090792079751404, 0.44349311585207046, 1.359959429785838, 1.2923857570901407, 0.3569870241696899, 0.449725304668682, 1.5938112209604791, 0.0415325190333718, -1.4888909446484289, 0.8129659844716989, 1.6637950693489998, 1.1760152227567506, -0.8349856526971908, 0.9858738351669688, 1.6551732241036783, -1.199309229867516, 0.6905350677412722, -0.621551149217892, -1.2324279590772083, 0.34151850122085015, -1.007389676725006, -1.1348458929120997, -0.31233761059414605, 0.4793355042852716, 0.40319387283822594, -0.73817527160584, 0.608900364991188, 0.28909098394140265, -0.05631896518466086, 0.505742875582015, 0.651439291100705, 0.8798850156481322, -0.31882120685734505, -0.29891765024796363, -0.9432404135526444, 1.7821759611422188, 0.3577013100856936, -0.07847795856818938, -2.0550118101368127, -0.554735900233456, 0.0816522082842264, 1.0354081346319182, 0.4567000101513787, -0.5846515155036132, 1.5136165383345574, -0.055686616967372926, 0.07628807710884732, 1.0574736602544683, 1.0840157114841318, -0.9936548880723843, -0.2210860447600946, 0.3028222529795845, 0.7169510928055438, -0.1514003306688253, -0.8610284057638767, -1.0439263660710776, -0.27797338441800046, -0.377724465253531, 0.9357954247566446, -0.13353889502325872, -0.6049426048160075, 1.953949857998025, -1.1488953218499374, -0.3958396115466337, -0.6837338568566131, -1.820154826149105, -0.15067754736329086, 0.5105347247226132, 1.0448788574161052, 2.021241834039774, -0.22203732627274106, 2.0360991639300026, -0.6123543136954916, 1.0493655147465508, 0.25595426503918356, 0.9658375410084153, -0.29458052454415184, -0.7732118791188753, -0.9576011340352182, -1.2052900032471265, -1.6424083158993943, -0.09984979091596823, 1.1242732413527428, -1.4116967811791405, -0.00921625204782433, 1.2399902501077977, -0.042263682269344835, -1.0501838295107255, 1.6365580675359375, -1.8477976140909462, -0.1617742278924333, 0.07401583989993735, 0.2773069191335467, -0.5046766024968936, 0.6266134130238634, -1.3309752115383218, -0.371347953551894, -1.1820949306397104, -0.6622488795855106, -0.7205063651104684, -0.5023572486618174, -1.1520902569893434, 2.1065830797942393, -0.5586109095725957, -0.17532072875069174, -0.7240574281742918, 0.46196149858922003, 0.33139888029579684, 0.232025559000832, 0.531252100210586, 0.7579540871418472, 0.8309517343306817, -1.4633657386712393, 0.46611777190371934, 1.634545330497187, -0.6079212171698446, -0.20936891983099035, 0.739106309774338, 0.27461888133433915, -0.2976979333250953, -1.7570660006429129, 1.2745417192802326, -1.2141217941972722, 0.3134042577184187, -2.3051903298823304, 1.78952128174831, 0.4558491253695143], "xaxis": "x", "y": ["Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2", "Group 2"], "yaxis": "y2", "type": "scatter"}, {"legendgroup": "Group 3", "marker": {"color": "rgb(44, 160, 44)", "symbol": "line-ns-open"}, "mode": "markers", "name": "Group 3", "showlegend": false, "x": [2.4149902481853385, 2.8320872055155206, 2.264225399622341, 1.7099221832166085, 2.4664061870918985, 1.9013643625145127, 2.9919526047270253, 1.5175905737319897, 2.8333863006708393, 2.743131874234973, -0.017453043418832248, 1.5526896912378323, 2.553972671525987, 2.0181747840444753, 2.2253471780111997, 1.2832758571998388, 1.1612750935551064, 2.361669986228835, 3.721034175862947, 2.6781184933918, 1.8881819555959931, 3.2142425774989776, 1.9559726226977088, 2.2031832716846145, 1.3903201413704995, 4.995953556410613, 1.9750738473135276, 2.30630434323296, -0.23330697694425195, 0.4533494800548028, 3.361919608667601, 3.366478887893411, 1.0796589314635678, 3.227674024795921, 1.0030340927031463, 0.6409449295366854, 2.583691049461988, 1.1772438569619674, 1.5152834029569588, 2.5848643077288838, 2.3098866155416746, 2.438198825210403, 2.1914917644396743, 2.8981989474882233, 0.44017681684860754, 2.360183638368979, 2.85478377780431, 2.298248583226848, 1.443803111648668, 1.9310947388468531, 1.436898560143047, 1.23200440672781, 1.8958110702814805, 0.7866584900191604, 2.496178444191074, 0.8512481225394739, 2.050315937692191, 3.2237440494571663, 0.8861920914198467, 0.22600828025109432, 3.2881353943061953, 1.96580238016236, 1.4155790660616883, 2.453720256940728, 2.3785156959104534, 3.1823951984402186, -0.49089307211867483, 0.6518066855806923, 3.4533610879772336, 2.1751386300855495, 1.780283433741765, 0.6632152695114253, 3.9236346549646868, 2.5320304351483087, 2.767110245837692, 1.1846789290521358, 0.5815955932364816, 1.669613564741868, 3.5619603880839135, 3.6173005129104787, 3.98106364518085, 1.7452566463913253, 1.504994539801367, 1.3461128333941605, 2.4679364858188446, 1.5912314351181265, 1.0092181708130186, 1.4927593274850919, 2.760650281569971, 2.590156083231835, 2.1145800256359237, 0.8711747648547188, 1.6695677190187728, 2.5829329639036236, 2.5087732134815863, 2.2059869055063355, 2.398401953186879, 2.258714853696918, 1.5078373597707448, 1.7378088413742805, 1.2424337299685002, 0.7204125324873223, 4.373906475949751, -0.36165994075324814, 1.8744962844526463, 1.1758774131923961, 3.9006070875197656, 2.3091348432953813, 2.93889554590988, 2.2871271367535395, -0.16678771977766393, 1.589455850268077, 2.486824685817486, 0.44728317303576315, 1.5340528359765015, 3.43508338933444, 0.8004888813036724, 1.716587178969777, -0.11478316366693386, 3.604112772129816, 1.6905311462015256, 2.8723698038027936, 0.8101043245336044, 0.44703396460807854, 0.6436926124890245, 1.7832535208364477, 2.312670504155142, 3.034123199187526, 1.9354831498933032, 1.818282839882696, 2.650103986770086, 1.5535061658427884, 1.3726069939195358, 2.4367669185069305, 0.7882470358495934, 3.654153738322322, 3.1172578551846724, 2.7543821314610057, 0.3563169192177602, 1.0999198598323456, 2.0166971744144377, 0.6999567284962402, 1.4555724431106463, 2.625651782815015, 2.4389102340183215, 3.368361740059224, 2.626824168087939, 2.0262447137856427, 0.4143080893285751, 3.3706930312677894, 1.5549878787443439, 1.1250101515401916, 1.562755104212417, 2.7132790037025565, 2.0831922188716154, 3.1969401231815042, 3.37853746388412, 2.387724842244888, 3.98541566157831, 1.5389686650951104, 2.563521530177166, 1.6614350906958684, 1.48553115054735, 1.5557260674236861, 1.3702700798979204, 1.1100550262998503, 2.823292663553766, 1.5444628635920719, 3.310531374726547, 2.5730344584855906, 2.210837840595279, 3.3212401304129875, 2.1302541575915215, 3.5909504277862747, 1.8925376546372972, 1.9035791354285472, 2.3680754479413273, 3.514168981195849, 0.3533067074946614, 1.8887861364197471, 3.070064929711613, 2.8440110321482273, 1.5243505281436966, 1.2127250999550765, 2.1033317429238725, 2.1787576878608763, 1.5306418918970415, 2.3850922614077983, 4.554967962359095, 1.6126578736317452, 1.4361024121515302, 2.966564230354843, 3.1046273992738262, 1.2301660181283185, 0.09052023527742836, 3.10397821665058, 1.1050765386935169, 0.11356646311195107, 3.2928202449344623, 2.1605064630688617], "xaxis": "x", "y": ["Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3", "Group 3"], "yaxis": "y2", "type": "scatter"}], "layout": {"barmode": "overlay", "hovermode": "closest", "legend": {"traceorder": "reversed"}, "xaxis": {"anchor": "y2", "domain": [0.0, 1.0], "zeroline": false}, "yaxis": {"anchor": "free", "domain": [0.35, 1], "position": 0.0}, "yaxis2": {"anchor": "x", "domain": [0, 0.25], "dtick": 1, "showticklabels": false}, "template": {"data": {"barpolar": [{"marker": {"line": {"color": "#E5ECF6", "width": 0.5}}, "type": "barpolar"}], "bar": [{"error_x": {"color": "#2a3f5f"}, "error_y": {"color": "#2a3f5f"}, "marker": {"line": {"color": "#E5ECF6", "width": 0.5}}, "type": "bar"}], "carpet": [{"aaxis": {"endlinecolor": "#2a3f5f", "gridcolor": "white", "linecolor": "white", "minorgridcolor": "white", "startlinecolor": "#2a3f5f"}, "baxis": {"endlinecolor": "#2a3f5f", "gridcolor": "white", "linecolor": "white", "minorgridcolor": "white", "startlinecolor": "#2a3f5f"}, "type": "carpet"}], "choropleth": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "type": "choropleth"}], "contourcarpet": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "type": "contourcarpet"}], "contour": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "colorscale": [[0.0, "#0d0887"], [0.1111111111111111, "#46039f"], [0.2222222222222222, "#7201a8"], [0.3333333333333333, "#9c179e"], [0.4444444444444444, "#bd3786"], [0.5555555555555556, "#d8576b"], [0.6666666666666666, "#ed7953"], [0.7777777777777778, "#fb9f3a"], [0.8888888888888888, "#fdca26"], [1.0, "#f0f921"]], "type": "contour"}], "heatmapgl": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "colorscale": [[0.0, "#0d0887"], [0.1111111111111111, "#46039f"], [0.2222222222222222, "#7201a8"], [0.3333333333333333, "#9c179e"], [0.4444444444444444, "#bd3786"], [0.5555555555555556, "#d8576b"], [0.6666666666666666, "#ed7953"], [0.7777777777777778, "#fb9f3a"], [0.8888888888888888, "#fdca26"], [1.0, "#f0f921"]], "type": "heatmapgl"}], "heatmap": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "colorscale": [[0.0, "#0d0887"], [0.1111111111111111, "#46039f"], [0.2222222222222222, "#7201a8"], [0.3333333333333333, "#9c179e"], [0.4444444444444444, "#bd3786"], [0.5555555555555556, "#d8576b"], [0.6666666666666666, "#ed7953"], [0.7777777777777778, "#fb9f3a"], [0.8888888888888888, "#fdca26"], [1.0, "#f0f921"]], "type": "heatmap"}], "histogram2dcontour": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "colorscale": [[0.0, "#0d0887"], [0.1111111111111111, "#46039f"], [0.2222222222222222, "#7201a8"], [0.3333333333333333, "#9c179e"], [0.4444444444444444, "#bd3786"], [0.5555555555555556, "#d8576b"], [0.6666666666666666, "#ed7953"], [0.7777777777777778, "#fb9f3a"], [0.8888888888888888, "#fdca26"], [1.0, "#f0f921"]], "type": "histogram2dcontour"}], "histogram2d": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "colorscale": [[0.0, "#0d0887"], [0.1111111111111111, "#46039f"], [0.2222222222222222, "#7201a8"], [0.3333333333333333, "#9c179e"], [0.4444444444444444, "#bd3786"], [0.5555555555555556, "#d8576b"], [0.6666666666666666, "#ed7953"], [0.7777777777777778, "#fb9f3a"], [0.8888888888888888, "#fdca26"], [1.0, "#f0f921"]], "type": "histogram2d"}], "histogram": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "histogram"}], "mesh3d": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "type": "mesh3d"}], "parcoords": [{"line": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "parcoords"}], "pie": [{"automargin": true, "type": "pie"}], "scatter3d": [{"line": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scatter3d"}], "scattercarpet": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scattercarpet"}], "scattergeo": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scattergeo"}], "scattergl": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scattergl"}], "scattermapbox": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scattermapbox"}], "scatterpolargl": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scatterpolargl"}], "scatterpolar": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scatterpolar"}], "scatter": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scatter"}], "scatterternary": [{"marker": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "type": "scatterternary"}], "surface": [{"colorbar": {"outlinewidth": 0, "ticks": ""}, "colorscale": [[0.0, "#0d0887"], [0.1111111111111111, "#46039f"], [0.2222222222222222, "#7201a8"], [0.3333333333333333, "#9c179e"], [0.4444444444444444, "#bd3786"], [0.5555555555555556, "#d8576b"], [0.6666666666666666, "#ed7953"], [0.7777777777777778, "#fb9f3a"], [0.8888888888888888, "#fdca26"], [1.0, "#f0f921"]], "type": "surface"}], "table": [{"cells": {"fill": {"color": "#EBF0F8"}, "line": {"color": "white"}}, "header": {"fill": {"color": "#C8D4E3"}, "line": {"color": "white"}}, "type": "table"}]}, "layout": {"annotationdefaults": {"arrowcolor": "#2a3f5f", "arrowhead": 0, "arrowwidth": 1}, "coloraxis": {"colorbar": {"outlinewidth": 0, "ticks": ""}}, "colorscale": {"diverging": [[0, "#8e0152"], [0.1, "#c51b7d"], [0.2, "#de77ae"], [0.3, "#f1b6da"], [0.4, "#fde0ef"], [0.5, "#f7f7f7"], [0.6, "#e6f5d0"], [0.7, "#b8e186"], [0.8, "#7fbc41"], [0.9, "#4d9221"], [1, "#276419"]], "sequential": [[0.0, "#0d0887"], [0.1111111111111111, "#46039f"], [0.2222222222222222, "#7201a8"], [0.3333333333333333, "#9c179e"], [0.4444444444444444, "#bd3786"], [0.5555555555555556, "#d8576b"], [0.6666666666666666, "#ed7953"], [0.7777777777777778, "#fb9f3a"], [0.8888888888888888, "#fdca26"], [1.0, "#f0f921"]], "sequentialminus": [[0.0, "#0d0887"], [0.1111111111111111, "#46039f"], [0.2222222222222222, "#7201a8"], [0.3333333333333333, "#9c179e"], [0.4444444444444444, "#bd3786"], [0.5555555555555556, "#d8576b"], [0.6666666666666666, "#ed7953"], [0.7777777777777778, "#fb9f3a"], [0.8888888888888888, "#fdca26"], [1.0, "#f0f921"]]}, "colorway": ["#636efa", "#EF553B", "#00cc96", "#ab63fa", "#FFA15A", "#19d3f3", "#FF6692", "#B6E880", "#FF97FF", "#FECB52"], "font": {"color": "#2a3f5f"}, "geo": {"bgcolor": "white", "lakecolor": "white", "landcolor": "#E5ECF6", "showlakes": true, "showland": true, "subunitcolor": "white"}, "hoverlabel": {"align": "left"}, "hovermode": "closest", "mapbox": {"style": "light"}, "paper_bgcolor": "white", "plot_bgcolor": "#E5ECF6", "polar": {"angularaxis": {"gridcolor": "white", "linecolor": "white", "ticks": ""}, "bgcolor": "#E5ECF6", "radialaxis": {"gridcolor": "white", "linecolor": "white", "ticks": ""}}, "scene": {"xaxis": {"backgroundcolor": "#E5ECF6", "gridcolor": "white", "gridwidth": 2, "linecolor": "white", "showbackground": true, "ticks": "", "zerolinecolor": "white"}, "yaxis": {"backgroundcolor": "#E5ECF6", "gridcolor": "white", "gridwidth": 2, "linecolor": "white", "showbackground": true, "ticks": "", "zerolinecolor": "white"}, "zaxis": {"backgroundcolor": "#E5ECF6", "gridcolor": "white", "gridwidth": 2, "linecolor": "white", "showbackground": true, "ticks": "", "zerolinecolor": "white"}}, "shapedefaults": {"line": {"color": "#2a3f5f"}}, "ternary": {"aaxis": {"gridcolor": "white", "linecolor": "white", "ticks": ""}, "baxis": {"gridcolor": "white", "linecolor": "white", "ticks": ""}, "bgcolor": "#E5ECF6", "caxis": {"gridcolor": "white", "linecolor": "white", "ticks": ""}}, "title": {"x": 0.05}, "xaxis": {"automargin": true, "gridcolor": "white", "linecolor": "white", "ticks": "", "title": {"standoff": 15}, "zerolinecolor": "white", "zerolinewidth": 2}, "yaxis": {"automargin": true, "gridcolor": "white", "linecolor": "white", "ticks": "", "title": {"standoff": 15}, "zerolinecolor": "white", "zerolinewidth": 2}}}}}',
    config: '{"showLink": false, "linkText": false}',
  },
  chart: "figure",
}
