/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import styled from "@emotion/styled"
import { transparentize } from "color2k"

export interface StyledTabContainerProps {
  isOverflowing: boolean
  tabHeight: string
  width: React.CSSProperties["width"]
  flex: React.CSSProperties["flex"]
}

export const StyledTabContainer = styled.div<StyledTabContainerProps>(
  ({ theme, isOverflowing, tabHeight, width, flex }) => ({
    ...(isOverflowing
      ? {
          position: "relative",
          "::after": {
            content: `" "`,
            position: "absolute",
            zIndex: theme.zIndices.priority,
            top: 0,
            right: 0,
            pointerEvents: "none",
            backgroundImage: `linear-gradient(to right, ${transparentize(
              theme.colors.bgColor,
              1
            )}, ${theme.colors.bgColor})`,
            width: theme.spacing.lg,
            height: tabHeight,
          },
        }
      : {}),
    ...(width && {
      width,
    }),
    ...(flex && {
      flex,
    }),
  })
)
