/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { screen } from "@testing-library/react"

import { render } from "~lib/test_util"

import AlertContainer, { AlertContainerProps, Kind } from "./AlertContainer"

const getProps = (
  propOverrides: Partial<AlertContainerProps> = {}
): AlertContainerProps => ({
  kind: Kind.INFO,
  width: 100,
  children: null,
  ...propOverrides,
})

describe("AlertContainer element", () => {
  it("renders a Notification", () => {
    render(<AlertContainer {...getProps()} />)
    const alertContainer = screen.getByTestId("stAlertContainer")
    expect(alertContainer).toBeInTheDocument()
    expect(alertContainer).toHaveClass("stAlertContainer")
  })

  it("renders its children", () => {
    render(
      <AlertContainer {...getProps()}>
        <div className="foo" data-testid="foo" />
      </AlertContainer>
    )

    expect(screen.getByTestId("foo")).toBeInTheDocument()
  })
})
