/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { FC, PropsWithChildren, useMemo } from "react"

import { ElementFullscreenContext } from "~lib/components/shared/ElementFullscreen/ElementFullscreenContext"
import { StyledFullScreenFrame } from "~lib/components/shared/FullScreenWrapper/styled-components"
import { useCalculatedDimensions } from "~lib/hooks/useCalculatedDimensions"
import { useEmotionTheme } from "~lib/hooks/useEmotionTheme"

import { useFullscreen } from "./useFullscreen"

type ElementFullscreenWrapperProps = PropsWithChildren

const ElementFullscreenWrapper: FC<ElementFullscreenWrapperProps> = ({
  children,
}) => {
  const theme = useEmotionTheme()
  const { expanded, fullHeight, fullWidth, zoomIn, zoomOut } = useFullscreen()
  const { width, elementRef } = useCalculatedDimensions()

  const fullscreenContextValue = useMemo(() => {
    return {
      width: expanded ? fullWidth : width,
      height: expanded ? fullHeight : undefined,
      expanded,
      expand: zoomIn,
      collapse: zoomOut,
    }
  }, [expanded, fullHeight, fullWidth, width, zoomIn, zoomOut])

  return (
    <ElementFullscreenContext.Provider value={fullscreenContextValue}>
      <StyledFullScreenFrame
        ref={elementRef}
        isExpanded={expanded}
        data-testid="stFullScreenFrame"
        theme={theme}
      >
        {children}
      </StyledFullScreenFrame>
    </ElementFullscreenContext.Provider>
  )
}

export default ElementFullscreenWrapper
