/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { screen } from "@testing-library/react"

import { render } from "~lib/test_util"

import CameraInputButton, { CameraInputButtonProps } from "./CameraInputButton"

const getProps = (
  props: Partial<CameraInputButtonProps> = {}
): CameraInputButtonProps => {
  return {
    onClick: vi.fn(),
    disabled: false,
    progress: 0,
    ...props,
  }
}

describe("Testing Camera Input Button", () => {
  it("renders without crashing", () => {
    const props = getProps()
    render(<CameraInputButton {...props} />)
    expect(screen.getByTestId("stCameraInputButton")).toBeInTheDocument()
  })

  it("plumbs progress properly", () => {
    const props = getProps({ progress: 50 })

    render(<CameraInputButton {...props} />)

    const progress = screen.getByRole("progressbar")
    expect(progress).toHaveAttribute("aria-valuenow", "50")
  })

  it("renders disabled button properly", () => {
    const props = getProps({ disabled: true })

    render(<CameraInputButton {...props} />)

    const button = screen.getByTestId("stCameraInputButton")
    expect(button).toBeDisabled()
    expect(button).toHaveStyle("cursor: not-allowed")
  })
})
