/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Raw data (in Apache Arrow format) for a dataframe
// that uses `MultiIndex` for both `index` and `columns` attributes.
//
// arrays = [[1, 2], ["red", "blue"]]
// pd.DataFrame(
//     [["foo", "1"], ["bar", "2"]],
//     index=pd.MultiIndex.from_arrays(arrays, names=("number", "color")),
//     columns=pd.MultiIndex.from_arrays(arrays, names=("number", "color")),
// )

export const MULTI = new Uint8Array([
  255, 255, 255, 255, 168, 4, 0, 0, 16, 0, 0, 0, 0, 0, 10, 0, 14, 0, 6, 0, 5,
  0, 8, 0, 10, 0, 0, 0, 0, 1, 4, 0, 16, 0, 0, 0, 0, 0, 10, 0, 12, 0, 0, 0, 4,
  0, 8, 0, 10, 0, 0, 0, 144, 3, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 12, 0, 0, 0, 8,
  0, 12, 0, 4, 0, 8, 0, 8, 0, 0, 0, 104, 3, 0, 0, 4, 0, 0, 0, 90, 3, 0, 0, 123,
  34, 105, 110, 100, 101, 120, 95, 99, 111, 108, 117, 109, 110, 115, 34, 58,
  32, 91, 34, 110, 117, 109, 98, 101, 114, 34, 44, 32, 34, 99, 111, 108, 111,
  114, 34, 93, 44, 32, 34, 99, 111, 108, 117, 109, 110, 95, 105, 110, 100, 101,
  120, 101, 115, 34, 58, 32, 91, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34,
  110, 117, 109, 98, 101, 114, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95,
  110, 97, 109, 101, 34, 58, 32, 34, 110, 117, 109, 98, 101, 114, 34, 44, 32,
  34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 105,
  110, 116, 54, 52, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112,
  101, 34, 58, 32, 34, 105, 110, 116, 54, 52, 34, 44, 32, 34, 109, 101, 116,
  97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34,
  110, 97, 109, 101, 34, 58, 32, 34, 99, 111, 108, 111, 114, 34, 44, 32, 34,
  102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 99, 111, 108,
  111, 114, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101,
  34, 58, 32, 34, 117, 110, 105, 99, 111, 100, 101, 34, 44, 32, 34, 110, 117,
  109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 123,
  34, 101, 110, 99, 111, 100, 105, 110, 103, 34, 58, 32, 34, 85, 84, 70, 45,
  56, 34, 125, 125, 93, 44, 32, 34, 99, 111, 108, 117, 109, 110, 115, 34, 58,
  32, 91, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 40, 39, 49, 39, 44, 32,
  39, 114, 101, 100, 39, 41, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110,
  97, 109, 101, 34, 58, 32, 34, 40, 39, 49, 39, 44, 32, 39, 114, 101, 100, 39,
  41, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34,
  58, 32, 34, 117, 110, 105, 99, 111, 100, 101, 34, 44, 32, 34, 110, 117, 109,
  112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116,
  34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117,
  108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 40, 39,
  50, 39, 44, 32, 39, 98, 108, 117, 101, 39, 41, 34, 44, 32, 34, 102, 105, 101,
  108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 40, 39, 50, 39, 44, 32, 39,
  98, 108, 117, 101, 39, 41, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95,
  116, 121, 112, 101, 34, 58, 32, 34, 117, 110, 105, 99, 111, 100, 101, 34, 44,
  32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111,
  98, 106, 101, 99, 116, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97,
  34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34,
  58, 32, 34, 110, 117, 109, 98, 101, 114, 34, 44, 32, 34, 102, 105, 101, 108,
  100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 110, 117, 109, 98, 101, 114, 34,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 105, 110, 116, 54, 52, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116,
  121, 112, 101, 34, 58, 32, 34, 105, 110, 116, 54, 52, 34, 44, 32, 34, 109,
  101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32,
  123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 99, 111, 108, 111, 114, 34, 44,
  32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 99,
  111, 108, 111, 114, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 117, 110, 105, 99, 111, 100, 101, 34, 44, 32, 34,
  110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98,
  106, 101, 99, 116, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34,
  58, 32, 110, 117, 108, 108, 125, 93, 44, 32, 34, 99, 114, 101, 97, 116, 111,
  114, 34, 58, 32, 123, 34, 108, 105, 98, 114, 97, 114, 121, 34, 58, 32, 34,
  112, 121, 97, 114, 114, 111, 119, 34, 44, 32, 34, 118, 101, 114, 115, 105,
  111, 110, 34, 58, 32, 34, 52, 46, 48, 46, 48, 34, 125, 44, 32, 34, 112, 97,
  110, 100, 97, 115, 95, 118, 101, 114, 115, 105, 111, 110, 34, 58, 32, 34, 49,
  46, 50, 46, 52, 34, 125, 0, 0, 6, 0, 0, 0, 112, 97, 110, 100, 97, 115, 0, 0,
  4, 0, 0, 0, 176, 0, 0, 0, 108, 0, 0, 0, 48, 0, 0, 0, 4, 0, 0, 0, 112, 255,
  255, 255, 0, 0, 1, 5, 16, 0, 0, 0, 24, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 5, 0,
  0, 0, 99, 111, 108, 111, 114, 0, 0, 0, 88, 255, 255, 255, 152, 255, 255, 255,
  0, 0, 1, 2, 16, 0, 0, 0, 32, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0,
  110, 117, 109, 98, 101, 114, 0, 0, 8, 0, 12, 0, 8, 0, 7, 0, 8, 0, 0, 0, 0, 0,
  0, 1, 64, 0, 0, 0, 208, 255, 255, 255, 0, 0, 1, 5, 16, 0, 0, 0, 32, 0, 0, 0,
  4, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 40, 39, 50, 39, 44, 32, 39, 98, 108,
  117, 101, 39, 41, 0, 0, 0, 192, 255, 255, 255, 16, 0, 20, 0, 8, 0, 6, 0, 7,
  0, 12, 0, 0, 0, 16, 0, 16, 0, 0, 0, 0, 0, 1, 5, 16, 0, 0, 0, 36, 0, 0, 0, 4,
  0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 40, 39, 49, 39, 44, 32, 39, 114, 101, 100,
  39, 41, 0, 0, 0, 0, 4, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
  72, 1, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 12, 0, 22, 0, 6, 0, 5, 0, 8, 0, 12, 0,
  12, 0, 0, 0, 0, 3, 4, 0, 24, 0, 0, 0, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0,
  24, 0, 12, 0, 4, 0, 8, 0, 10, 0, 0, 0, 204, 0, 0, 0, 16, 0, 0, 0, 2, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0,
  0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 24, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0, 0, 0, 0, 0,
  2, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48,
  0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0,
  0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 2, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 102,
  111, 111, 98, 97, 114, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
  49, 50, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 114, 101, 100, 98, 108, 117,
  101, 0, 255, 255, 255, 255, 0, 0, 0, 0,
])
