/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Raw data (in Apache Arrow format) for a dataframe
// that uses CategoricalDtype and stores Interval as values
//
// import pandas as pd
//
// metric_df = pd.DataFrame(
//   data=[
//     [pd.Interval(23.535, 256.5)],
//     [pd.Interval(23.535, 256.5)],
//     [pd.Interval(23.535, 256.5)],
//     [pd.Interval(256.5, 489.0)],
//     [pd.Interval(23.535, 256.5)],
//     [pd.Interval(256.5, 489.0)],
//     [pd.Interval(256.5, 489.0)],
//   ],
//   dtype=pd.CategoricalDtype(
//     categories=[
//       pd.Interval(23.535, 256.5),
//       pd.Interval(256.5, 489.0)
//     ],
//     ordered=True
//   ),
// )

export const CATEGORICAL_INTERVAL = new Uint8Array([
  255, 255, 255, 255, 168, 3, 0, 0, 16, 0, 0, 0, 0, 0, 10, 0, 14, 0, 6, 0, 5,
  0, 8, 0, 10, 0, 0, 0, 0, 1, 4, 0, 16, 0, 0, 0, 0, 0, 10, 0, 12, 0, 0, 0, 4,
  0, 8, 0, 10, 0, 0, 0, 232, 1, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 148,
  253, 255, 255, 200, 1, 0, 0, 4, 0, 0, 0, 184, 1, 0, 0, 123, 34, 105, 110,
  100, 101, 120, 95, 99, 111, 108, 117, 109, 110, 115, 34, 58, 32, 91, 123, 34,
  107, 105, 110, 100, 34, 58, 32, 34, 114, 97, 110, 103, 101, 34, 44, 32, 34,
  110, 97, 109, 101, 34, 58, 32, 110, 117, 108, 108, 44, 32, 34, 115, 116, 97,
  114, 116, 34, 58, 32, 48, 44, 32, 34, 115, 116, 111, 112, 34, 58, 32, 55, 44,
  32, 34, 115, 116, 101, 112, 34, 58, 32, 49, 125, 93, 44, 32, 34, 99, 111,
  108, 117, 109, 110, 95, 105, 110, 100, 101, 120, 101, 115, 34, 58, 32, 91,
  123, 34, 110, 97, 109, 101, 34, 58, 32, 110, 117, 108, 108, 44, 32, 34, 102,
  105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 110, 117, 108, 108,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 105, 110, 116, 54, 52, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116,
  121, 112, 101, 34, 58, 32, 34, 105, 110, 116, 54, 52, 34, 44, 32, 34, 109,
  101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 93, 44,
  32, 34, 99, 111, 108, 117, 109, 110, 115, 34, 58, 32, 91, 123, 34, 110, 97,
  109, 101, 34, 58, 32, 34, 48, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95,
  110, 97, 109, 101, 34, 58, 32, 34, 48, 34, 44, 32, 34, 112, 97, 110, 100, 97,
  115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 99, 97, 116, 101, 103, 111, 114,
  105, 99, 97, 108, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112,
  101, 34, 58, 32, 34, 105, 110, 116, 56, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 123, 34, 110, 117, 109, 95, 99, 97, 116, 101,
  103, 111, 114, 105, 101, 115, 34, 58, 32, 50, 44, 32, 34, 111, 114, 100, 101,
  114, 101, 100, 34, 58, 32, 116, 114, 117, 101, 125, 125, 93, 44, 32, 34, 99,
  114, 101, 97, 116, 111, 114, 34, 58, 32, 123, 34, 108, 105, 98, 114, 97, 114,
  121, 34, 58, 32, 34, 112, 121, 97, 114, 114, 111, 119, 34, 44, 32, 34, 118,
  101, 114, 115, 105, 111, 110, 34, 58, 32, 34, 57, 46, 48, 46, 48, 34, 125,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 118, 101, 114, 115, 105, 111,
  110, 34, 58, 32, 34, 49, 46, 53, 46, 48, 34, 125, 0, 0, 0, 0, 6, 0, 0, 0,
  112, 97, 110, 100, 97, 115, 0, 0, 1, 0, 0, 0, 24, 0, 0, 0, 0, 0, 18, 0, 28,
  0, 8, 0, 6, 0, 7, 0, 12, 0, 16, 0, 20, 0, 24, 0, 18, 0, 0, 0, 0, 0, 1, 13,
  32, 0, 0, 0, 252, 0, 0, 0, 212, 0, 0, 0, 8, 0, 0, 0, 24, 0, 0, 0, 2, 0, 0, 0,
  40, 1, 0, 0, 232, 0, 0, 0, 1, 0, 0, 0, 48, 0, 0, 0, 2, 0, 0, 0, 76, 0, 0, 0,
  4, 0, 0, 0, 196, 255, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 15, 0, 0, 0, 112,
  97, 110, 100, 97, 115, 46, 105, 110, 116, 101, 114, 118, 97, 108, 0, 20, 0,
  0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110,
  58, 110, 97, 109, 101, 0, 0, 0, 0, 8, 0, 12, 0, 4, 0, 8, 0, 8, 0, 0, 0, 56,
  0, 0, 0, 4, 0, 0, 0, 40, 0, 0, 0, 123, 34, 115, 117, 98, 116, 121, 112, 101,
  34, 58, 32, 34, 100, 111, 117, 98, 108, 101, 34, 44, 32, 34, 99, 108, 111,
  115, 101, 100, 34, 58, 32, 34, 114, 105, 103, 104, 116, 34, 125, 0, 0, 0, 0,
  24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111,
  110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 10, 0, 12, 0, 0, 0, 8, 0,
  7, 0, 10, 0, 0, 0, 0, 0, 0, 1, 12, 0, 0, 0, 8, 0, 12, 0, 8, 0, 7, 0, 8, 0, 0,
  0, 0, 0, 0, 1, 8, 0, 0, 0, 4, 0, 4, 0, 4, 0, 0, 0, 212, 255, 255, 255, 0, 0,
  1, 3, 16, 0, 0, 0, 24, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 114, 105,
  103, 104, 116, 0, 0, 0, 198, 255, 255, 255, 0, 0, 2, 0, 16, 0, 20, 0, 8, 0,
  6, 0, 7, 0, 12, 0, 0, 0, 16, 0, 16, 0, 0, 0, 0, 0, 1, 3, 16, 0, 0, 0, 28, 0,
  0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 108, 101, 102, 116, 0, 0, 6, 0, 8,
  0, 6, 0, 6, 0, 0, 0, 0, 0, 2, 0, 255, 255, 255, 255, 232, 0, 0, 0, 20, 0, 0,
  0, 0, 0, 0, 0, 12, 0, 20, 0, 6, 0, 5, 0, 8, 0, 12, 0, 12, 0, 0, 0, 0, 2, 4,
  0, 20, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 8, 0, 10, 0, 0, 0, 4, 0, 8, 0, 0, 0,
  16, 0, 0, 0, 0, 0, 10, 0, 24, 0, 12, 0, 4, 0, 8, 0, 10, 0, 0, 0, 108, 0, 0,
  0, 16, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 41, 92, 143, 194, 245, 136, 55, 64, 0, 0, 0, 0, 0, 8, 112, 64, 0,
  0, 0, 0, 0, 8, 112, 64, 0, 0, 0, 0, 0, 144, 126, 64, 255, 255, 255, 255, 136,
  0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 12, 0, 22, 0, 6, 0, 5, 0, 8, 0, 12, 0, 12,
  0, 0, 0, 0, 3, 4, 0, 24, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 24, 0,
  12, 0, 4, 0, 8, 0, 10, 0, 0, 0, 60, 0, 0, 0, 16, 0, 0, 0, 7, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 7, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 255, 255,
  255, 255, 0, 0, 0, 0,
])
