/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Raw data (in Apache Arrow format) for a dataframe
// that uses `PeriodIndex` for both `index` and `columns` attributes.
//
// months_shorts = [
//   "JAN",
//   "FEB",
//   "MAR",
//   "APR",
//   "MAY",
//   "JUN",
//   "JUL",
//   "AUG",
//   "SEP",
//   "OCT",
//   "NOV",
//   "DEC",
// ]
// weekday_shorts = ["SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"]
// offset_types = [
//   "A",
//   "M",
//   "Y",
//   "h",
//   "min",
//   "ms",
//   "s",
//   "L",
//   "S",
//   "T",
//   "H",
//   "D",
//   "W",
//   *[f"W-{d}" for d in weekday_shorts],
//   "Q",
//   *[f"Q-{d}" for d in months_shorts],
// ]
// df = pd.DataFrame(
//   [
//       [pd.Period("2012-02-14", freq=offset_type) for offset_type in offset_types],
//       [pd.Period("1970-01-01", freq=offset_type) for offset_type in offset_types],
//   ],
//   columns=offset_types,
// )
export const PERIOD = new Uint8Array([
  255, 255, 255, 255, 24, 41, 0, 0, 16, 0, 0, 0, 0, 0, 10, 0, 14, 0, 6, 0, 5,
  0, 8, 0, 10, 0, 0, 0, 0, 1, 4, 0, 16, 0, 0, 0, 0, 0, 10, 0, 12, 0, 0, 0, 4,
  0, 8, 0, 10, 0, 0, 0, 216, 15, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 132,
  215, 255, 255, 184, 15, 0, 0, 4, 0, 0, 0, 171, 15, 0, 0, 123, 34, 105, 110,
  100, 101, 120, 95, 99, 111, 108, 117, 109, 110, 115, 34, 58, 32, 91, 123, 34,
  107, 105, 110, 100, 34, 58, 32, 34, 114, 97, 110, 103, 101, 34, 44, 32, 34,
  110, 97, 109, 101, 34, 58, 32, 110, 117, 108, 108, 44, 32, 34, 115, 116, 97,
  114, 116, 34, 58, 32, 48, 44, 32, 34, 115, 116, 111, 112, 34, 58, 32, 50, 44,
  32, 34, 115, 116, 101, 112, 34, 58, 32, 49, 125, 93, 44, 32, 34, 99, 111,
  108, 117, 109, 110, 95, 105, 110, 100, 101, 120, 101, 115, 34, 58, 32, 91,
  123, 34, 110, 97, 109, 101, 34, 58, 32, 110, 117, 108, 108, 44, 32, 34, 102,
  105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 110, 117, 108, 108,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 117, 110, 105, 99, 111, 100, 101, 34, 44, 32, 34, 110, 117, 109, 112,
  121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34,
  44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 123, 34, 101,
  110, 99, 111, 100, 105, 110, 103, 34, 58, 32, 34, 85, 84, 70, 45, 56, 34,
  125, 125, 93, 44, 32, 34, 99, 111, 108, 117, 109, 110, 115, 34, 58, 32, 91,
  123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 65, 34, 44, 32, 34, 102, 105,
  101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 65, 34, 44, 32, 34,
  112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98,
  106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 89, 45, 68, 69,
  67, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110,
  117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 77,
  34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32,
  34, 77, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101,
  34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109,
  112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111,
  100, 91, 77, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58,
  32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32,
  34, 89, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34,
  58, 32, 34, 89, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110,
  117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114,
  105, 111, 100, 91, 89, 45, 68, 69, 67, 93, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110,
  97, 109, 101, 34, 58, 32, 34, 104, 34, 44, 32, 34, 102, 105, 101, 108, 100,
  95, 110, 97, 109, 101, 34, 58, 32, 34, 104, 34, 44, 32, 34, 112, 97, 110,
  100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58,
  32, 34, 112, 101, 114, 105, 111, 100, 91, 104, 93, 34, 44, 32, 34, 109, 101,
  116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123,
  34, 110, 97, 109, 101, 34, 58, 32, 34, 109, 105, 110, 34, 44, 32, 34, 102,
  105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 109, 105, 110, 34,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95,
  116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 109,
  105, 110, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58,
  32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32,
  34, 109, 115, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101,
  34, 58, 32, 34, 109, 115, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95,
  116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32,
  34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112,
  101, 114, 105, 111, 100, 91, 109, 115, 93, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110,
  97, 109, 101, 34, 58, 32, 34, 115, 34, 44, 32, 34, 102, 105, 101, 108, 100,
  95, 110, 97, 109, 101, 34, 58, 32, 34, 115, 34, 44, 32, 34, 112, 97, 110,
  100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58,
  32, 34, 112, 101, 114, 105, 111, 100, 91, 115, 93, 34, 44, 32, 34, 109, 101,
  116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123,
  34, 110, 97, 109, 101, 34, 58, 32, 34, 76, 34, 44, 32, 34, 102, 105, 101,
  108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 76, 34, 44, 32, 34, 112, 97,
  110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101,
  99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34,
  58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 109, 115, 93, 34, 44, 32, 34,
  109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44,
  32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 83, 34, 44, 32, 34, 102, 105,
  101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 83, 34, 44, 32, 34,
  112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98,
  106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 115, 93, 34, 44,
  32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108,
  125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 84, 34, 44, 32, 34,
  102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 84, 34, 44,
  32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34,
  111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116,
  121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 109, 105,
  110, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32,
  110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34,
  72, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58,
  32, 34, 72, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112,
  101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117,
  109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105,
  111, 100, 91, 104, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97,
  34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34,
  58, 32, 34, 68, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109,
  101, 34, 58, 32, 34, 68, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116,
  121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34,
  110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101,
  114, 105, 111, 100, 91, 68, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97,
  116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109,
  101, 34, 58, 32, 34, 87, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110,
  97, 109, 101, 34, 58, 32, 34, 87, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115,
  95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44,
  32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112,
  101, 114, 105, 111, 100, 91, 87, 45, 83, 85, 78, 93, 34, 44, 32, 34, 109,
  101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32,
  123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 87, 45, 83, 85, 78, 34, 44, 32,
  34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 87, 45,
  83, 85, 78, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112,
  101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117,
  109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105,
  111, 100, 91, 87, 45, 83, 85, 78, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100,
  97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97,
  109, 101, 34, 58, 32, 34, 87, 45, 77, 79, 78, 34, 44, 32, 34, 102, 105, 101,
  108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 87, 45, 77, 79, 78, 34, 44,
  32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34,
  111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116,
  121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 87, 45, 77,
  79, 78, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32,
  110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34,
  87, 45, 84, 85, 69, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97,
  109, 101, 34, 58, 32, 34, 87, 45, 84, 85, 69, 34, 44, 32, 34, 112, 97, 110,
  100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58,
  32, 34, 112, 101, 114, 105, 111, 100, 91, 87, 45, 84, 85, 69, 93, 34, 44, 32,
  34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125,
  44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 87, 45, 87, 69, 68, 34,
  44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34,
  87, 45, 87, 69, 68, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110,
  117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114,
  105, 111, 100, 91, 87, 45, 87, 69, 68, 93, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110,
  97, 109, 101, 34, 58, 32, 34, 87, 45, 84, 72, 85, 34, 44, 32, 34, 102, 105,
  101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 87, 45, 84, 72, 85, 34,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95,
  116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 87, 45,
  84, 72, 85, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58,
  32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32,
  34, 87, 45, 70, 82, 73, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97,
  109, 101, 34, 58, 32, 34, 87, 45, 70, 82, 73, 34, 44, 32, 34, 112, 97, 110,
  100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58,
  32, 34, 112, 101, 114, 105, 111, 100, 91, 87, 45, 70, 82, 73, 93, 34, 44, 32,
  34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125,
  44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 87, 45, 83, 65, 84, 34,
  44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34,
  87, 45, 83, 65, 84, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110,
  117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114,
  105, 111, 100, 91, 87, 45, 83, 65, 84, 93, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110,
  97, 109, 101, 34, 58, 32, 34, 81, 34, 44, 32, 34, 102, 105, 101, 108, 100,
  95, 110, 97, 109, 101, 34, 58, 32, 34, 81, 34, 44, 32, 34, 112, 97, 110, 100,
  97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116,
  34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 112, 101, 114, 105, 111, 100, 91, 81, 45, 68, 69, 67, 93, 34, 44, 32, 34,
  109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44,
  32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 81, 45, 74, 65, 78, 34, 44,
  32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 81,
  45, 74, 65, 78, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110,
  117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114,
  105, 111, 100, 91, 81, 45, 74, 65, 78, 93, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110,
  97, 109, 101, 34, 58, 32, 34, 81, 45, 70, 69, 66, 34, 44, 32, 34, 102, 105,
  101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 81, 45, 70, 69, 66, 34,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95,
  116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 81, 45,
  70, 69, 66, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58,
  32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32,
  34, 81, 45, 77, 65, 82, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97,
  109, 101, 34, 58, 32, 34, 81, 45, 77, 65, 82, 34, 44, 32, 34, 112, 97, 110,
  100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58,
  32, 34, 112, 101, 114, 105, 111, 100, 91, 81, 45, 77, 65, 82, 93, 34, 44, 32,
  34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125,
  44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 81, 45, 65, 80, 82, 34,
  44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34,
  81, 45, 65, 80, 82, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110,
  117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114,
  105, 111, 100, 91, 81, 45, 65, 80, 82, 93, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110,
  97, 109, 101, 34, 58, 32, 34, 81, 45, 77, 65, 89, 34, 44, 32, 34, 102, 105,
  101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 81, 45, 77, 65, 89, 34,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95,
  116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 81, 45,
  77, 65, 89, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58,
  32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32,
  34, 81, 45, 74, 85, 78, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97,
  109, 101, 34, 58, 32, 34, 81, 45, 74, 85, 78, 34, 44, 32, 34, 112, 97, 110,
  100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58,
  32, 34, 112, 101, 114, 105, 111, 100, 91, 81, 45, 74, 85, 78, 93, 34, 44, 32,
  34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125,
  44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 81, 45, 74, 85, 76, 34,
  44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34,
  81, 45, 74, 85, 76, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110,
  117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114,
  105, 111, 100, 91, 81, 45, 74, 85, 76, 93, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110,
  97, 109, 101, 34, 58, 32, 34, 81, 45, 65, 85, 71, 34, 44, 32, 34, 102, 105,
  101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 81, 45, 65, 85, 71, 34,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95,
  116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 81, 45,
  65, 85, 71, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58,
  32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32,
  34, 81, 45, 83, 69, 80, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97,
  109, 101, 34, 58, 32, 34, 81, 45, 83, 69, 80, 34, 44, 32, 34, 112, 97, 110,
  100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58,
  32, 34, 112, 101, 114, 105, 111, 100, 91, 81, 45, 83, 69, 80, 93, 34, 44, 32,
  34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125,
  44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32, 34, 81, 45, 79, 67, 84, 34,
  44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34,
  81, 45, 79, 67, 84, 34, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121,
  112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110,
  117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114,
  105, 111, 100, 91, 81, 45, 79, 67, 84, 93, 34, 44, 32, 34, 109, 101, 116, 97,
  100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110,
  97, 109, 101, 34, 58, 32, 34, 81, 45, 78, 79, 86, 34, 44, 32, 34, 102, 105,
  101, 108, 100, 95, 110, 97, 109, 101, 34, 58, 32, 34, 81, 45, 78, 79, 86, 34,
  44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32,
  34, 111, 98, 106, 101, 99, 116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95,
  116, 121, 112, 101, 34, 58, 32, 34, 112, 101, 114, 105, 111, 100, 91, 81, 45,
  78, 79, 86, 93, 34, 44, 32, 34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58,
  32, 110, 117, 108, 108, 125, 44, 32, 123, 34, 110, 97, 109, 101, 34, 58, 32,
  34, 81, 45, 68, 69, 67, 34, 44, 32, 34, 102, 105, 101, 108, 100, 95, 110, 97,
  109, 101, 34, 58, 32, 34, 81, 45, 68, 69, 67, 34, 44, 32, 34, 112, 97, 110,
  100, 97, 115, 95, 116, 121, 112, 101, 34, 58, 32, 34, 111, 98, 106, 101, 99,
  116, 34, 44, 32, 34, 110, 117, 109, 112, 121, 95, 116, 121, 112, 101, 34, 58,
  32, 34, 112, 101, 114, 105, 111, 100, 91, 81, 45, 68, 69, 67, 93, 34, 44, 32,
  34, 109, 101, 116, 97, 100, 97, 116, 97, 34, 58, 32, 110, 117, 108, 108, 125,
  93, 44, 32, 34, 99, 114, 101, 97, 116, 111, 114, 34, 58, 32, 123, 34, 108,
  105, 98, 114, 97, 114, 121, 34, 58, 32, 34, 112, 121, 97, 114, 114, 111, 119,
  34, 44, 32, 34, 118, 101, 114, 115, 105, 111, 110, 34, 58, 32, 34, 49, 53,
  46, 48, 46, 48, 34, 125, 44, 32, 34, 112, 97, 110, 100, 97, 115, 95, 118,
  101, 114, 115, 105, 111, 110, 34, 58, 32, 34, 50, 46, 50, 46, 48, 34, 125, 0,
  6, 0, 0, 0, 112, 97, 110, 100, 97, 115, 0, 0, 33, 0, 0, 0, 68, 24, 0, 0, 108,
  23, 0, 0, 172, 22, 0, 0, 240, 21, 0, 0, 52, 21, 0, 0, 120, 20, 0, 0, 188, 19,
  0, 0, 0, 19, 0, 0, 68, 18, 0, 0, 136, 17, 0, 0, 204, 16, 0, 0, 16, 16, 0, 0,
  80, 15, 0, 0, 140, 14, 0, 0, 200, 13, 0, 0, 4, 13, 0, 0, 64, 12, 0, 0, 124,
  11, 0, 0, 184, 10, 0, 0, 244, 9, 0, 0, 52, 9, 0, 0, 112, 8, 0, 0, 172, 7, 0,
  0, 232, 6, 0, 0, 36, 6, 0, 0, 96, 5, 0, 0, 156, 4, 0, 0, 216, 3, 0, 0, 20, 3,
  0, 0, 80, 2, 0, 0, 140, 1, 0, 0, 200, 0, 0, 0, 4, 0, 0, 0, 82, 232, 255, 255,
  0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0,
  5, 0, 0, 0, 81, 45, 68, 69, 67, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0,
  8, 232, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100,
  97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82,
  79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109,
  101, 0, 0, 0, 0, 68, 232, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0,
  123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 81, 45, 68, 69, 67, 34, 125, 0,
  0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 60, 232, 255,
  255, 0, 0, 0, 1, 64, 0, 0, 0, 18, 233, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0,
  168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 81, 45, 78,
  79, 86, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 200, 232, 255, 255, 28,
  0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101,
  114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 4, 233,
  255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113,
  34, 58, 32, 34, 81, 45, 78, 79, 86, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82,
  82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109, 101,
  116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 252, 232, 255, 255, 0, 0, 0, 1, 64, 0,
  0, 0, 210, 233, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0,
  20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 81, 45, 79, 67, 84, 0, 0, 0, 2, 0, 0, 0,
  68, 0, 0, 0, 4, 0, 0, 0, 136, 233, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0,
  0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0,
  20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111,
  110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 196, 233, 255, 255, 32, 0, 0, 0, 4,
  0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 81, 45,
  79, 67, 84, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97,
  0, 0, 0, 0, 188, 233, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 146, 234, 255, 255,
  0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0,
  5, 0, 0, 0, 81, 45, 83, 69, 80, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0,
  72, 234, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100,
  97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82,
  79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109,
  101, 0, 0, 0, 0, 132, 234, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0,
  123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 81, 45, 83, 69, 80, 34, 125, 0,
  0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 124, 234, 255,
  255, 0, 0, 0, 1, 64, 0, 0, 0, 82, 235, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0,
  168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 81, 45, 65,
  85, 71, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 8, 235, 255, 255, 28,
  0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101,
  114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 68,
  235, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101,
  113, 34, 58, 32, 34, 81, 45, 65, 85, 71, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65,
  82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109,
  101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 60, 235, 255, 255, 0, 0, 0, 1,
  64, 0, 0, 0, 18, 236, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0,
  0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 81, 45, 74, 85, 76, 0, 0, 0, 2, 0,
  0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 200, 235, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0,
  13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0,
  0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 4, 236, 255, 255, 32, 0, 0, 0,
  4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 81, 45,
  74, 85, 76, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97,
  0, 0, 0, 0, 252, 235, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 210, 236, 255, 255,
  0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0,
  5, 0, 0, 0, 81, 45, 74, 85, 78, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0,
  136, 236, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100,
  97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82,
  79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109,
  101, 0, 0, 0, 0, 196, 236, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0,
  123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 81, 45, 74, 85, 78, 34, 125, 0,
  0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 188, 236, 255,
  255, 0, 0, 0, 1, 64, 0, 0, 0, 146, 237, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0,
  168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 81, 45, 77,
  65, 89, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 72, 237, 255, 255, 28,
  0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101,
  114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 132,
  237, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101,
  113, 34, 58, 32, 34, 81, 45, 77, 65, 89, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65,
  82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109,
  101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 124, 237, 255, 255, 0, 0, 0, 1,
  64, 0, 0, 0, 82, 238, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0,
  0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 81, 45, 65, 80, 82, 0, 0, 0, 2, 0,
  0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 8, 238, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13,
  0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0,
  0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 68, 238, 255, 255, 32, 0, 0, 0,
  4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 81, 45,
  65, 80, 82, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97,
  0, 0, 0, 0, 60, 238, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 18, 239, 255, 255, 0,
  0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5,
  0, 0, 0, 81, 45, 77, 65, 82, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0,
  200, 238, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100,
  97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82,
  79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109,
  101, 0, 0, 0, 0, 4, 239, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123,
  34, 102, 114, 101, 113, 34, 58, 32, 34, 81, 45, 77, 65, 82, 34, 125, 0, 0, 0,
  24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111,
  110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 252, 238, 255, 255,
  0, 0, 0, 1, 64, 0, 0, 0, 210, 239, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0,
  0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 81, 45, 70, 69, 66, 0,
  0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 136, 239, 255, 255, 28, 0, 0, 0,
  4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105,
  111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101,
  110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 196, 239, 255,
  255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34,
  58, 32, 34, 81, 45, 70, 69, 66, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82,
  79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116,
  97, 100, 97, 116, 97, 0, 0, 0, 0, 188, 239, 255, 255, 0, 0, 0, 1, 64, 0, 0,
  0, 146, 240, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0, 20,
  0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 81, 45, 74, 65, 78, 0, 0, 0, 2, 0, 0, 0, 68,
  0, 0, 0, 4, 0, 0, 0, 72, 240, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0,
  112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0,
  0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110,
  58, 110, 97, 109, 101, 0, 0, 0, 0, 132, 240, 255, 255, 32, 0, 0, 0, 4, 0, 0,
  0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 81, 45, 74, 65,
  78, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116,
  101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0,
  0, 0, 124, 240, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 82, 241, 255, 255, 0, 0,
  1, 2, 20, 0, 0, 0, 164, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 0,
  0, 0, 81, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 4, 241, 255, 255, 28,
  0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101,
  114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 64,
  241, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101,
  113, 34, 58, 32, 34, 81, 45, 68, 69, 67, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65,
  82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109,
  101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 56, 241, 255, 255, 0, 0, 0, 1,
  64, 0, 0, 0, 14, 242, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0,
  0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 87, 45, 83, 65, 84, 0, 0, 0, 2, 0,
  0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 196, 241, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0,
  13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0,
  0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 0, 242, 255, 255, 32, 0, 0, 0,
  4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 87, 45,
  83, 65, 84, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97,
  0, 0, 0, 0, 248, 241, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 206, 242, 255, 255,
  0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0,
  5, 0, 0, 0, 87, 45, 70, 82, 73, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0,
  132, 242, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100,
  97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82,
  79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109,
  101, 0, 0, 0, 0, 192, 242, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0,
  123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 87, 45, 70, 82, 73, 34, 125, 0,
  0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 184, 242, 255,
  255, 0, 0, 0, 1, 64, 0, 0, 0, 142, 243, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0,
  168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 87, 45, 84,
  72, 85, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 68, 243, 255, 255, 28,
  0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101,
  114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 128,
  243, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101,
  113, 34, 58, 32, 34, 87, 45, 84, 72, 85, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65,
  82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109,
  101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 120, 243, 255, 255, 0, 0, 0, 1,
  64, 0, 0, 0, 78, 244, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0,
  0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 87, 45, 87, 69, 68, 0, 0, 0, 2, 0,
  0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 4, 244, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13,
  0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0,
  0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 64, 244, 255, 255, 32, 0, 0, 0,
  4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 87, 45,
  87, 69, 68, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97,
  0, 0, 0, 0, 56, 244, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 14, 245, 255, 255, 0,
  0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5,
  0, 0, 0, 87, 45, 84, 85, 69, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0,
  196, 244, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100,
  97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82,
  79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109,
  101, 0, 0, 0, 0, 0, 245, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123,
  34, 102, 114, 101, 113, 34, 58, 32, 34, 87, 45, 84, 85, 69, 34, 125, 0, 0, 0,
  24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111,
  110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 248, 244, 255, 255,
  0, 0, 0, 1, 64, 0, 0, 0, 206, 245, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0,
  0, 0, 8, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 87, 45, 77, 79, 78, 0,
  0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 132, 245, 255, 255, 28, 0, 0, 0,
  4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105,
  111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101,
  110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 192, 245, 255,
  255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34,
  58, 32, 34, 87, 45, 77, 79, 78, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82,
  79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116,
  97, 100, 97, 116, 97, 0, 0, 0, 0, 184, 245, 255, 255, 0, 0, 0, 1, 64, 0, 0,
  0, 142, 246, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 168, 0, 0, 0, 8, 0, 0, 0, 20,
  0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 87, 45, 83, 85, 78, 0, 0, 0, 2, 0, 0, 0, 68,
  0, 0, 0, 4, 0, 0, 0, 68, 246, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0,
  112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0,
  0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110,
  58, 110, 97, 109, 101, 0, 0, 0, 0, 128, 246, 255, 255, 32, 0, 0, 0, 4, 0, 0,
  0, 17, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 87, 45, 83, 85,
  78, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116,
  101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0,
  0, 0, 120, 246, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 78, 247, 255, 255, 0, 0,
  1, 2, 20, 0, 0, 0, 164, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 0,
  0, 0, 87, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 0, 247, 255, 255, 28,
  0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101,
  114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 60,
  247, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0, 123, 34, 102, 114, 101,
  113, 34, 58, 32, 34, 87, 45, 83, 85, 78, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65,
  82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109,
  101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 52, 247, 255, 255, 0, 0, 0, 1,
  64, 0, 0, 0, 10, 248, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 160, 0, 0, 0, 8, 0,
  0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 68, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0,
  0, 4, 0, 0, 0, 188, 247, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112,
  97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0,
  0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58,
  110, 97, 109, 101, 0, 0, 0, 0, 248, 247, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0,
  13, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 68, 34, 125, 0, 0,
  0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 236, 247, 255,
  255, 0, 0, 0, 1, 64, 0, 0, 0, 194, 248, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0,
  160, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 72, 0, 0, 0,
  2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 116, 248, 255, 255, 28, 0, 0, 0, 4, 0,
  0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111,
  100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110,
  115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 176, 248, 255, 255,
  28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58,
  32, 34, 104, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120,
  116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97,
  0, 0, 0, 0, 164, 248, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 122, 249, 255, 255,
  0, 0, 1, 2, 20, 0, 0, 0, 160, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 84, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 44, 249, 255,
  255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46,
  112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58,
  101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0,
  0, 104, 249, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 15, 0, 0, 0, 123, 34, 102,
  114, 101, 113, 34, 58, 32, 34, 109, 105, 110, 34, 125, 0, 24, 0, 0, 0, 65,
  82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109,
  101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 92, 249, 255, 255, 0, 0, 0, 1,
  64, 0, 0, 0, 50, 250, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 160, 0, 0, 0, 8, 0,
  0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 83, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0,
  0, 4, 0, 0, 0, 228, 249, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112,
  97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0,
  0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58,
  110, 97, 109, 101, 0, 0, 0, 0, 32, 250, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0,
  13, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 115, 34, 125, 0, 0,
  0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 20, 250, 255,
  255, 0, 0, 0, 1, 64, 0, 0, 0, 234, 250, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0,
  160, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 76, 0, 0, 0,
  2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 156, 250, 255, 255, 28, 0, 0, 0, 4, 0,
  0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111,
  100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110,
  115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 216, 250, 255, 255,
  28, 0, 0, 0, 4, 0, 0, 0, 14, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58,
  32, 34, 109, 115, 34, 125, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101,
  120, 116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116,
  97, 0, 0, 0, 0, 204, 250, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 162, 251, 255,
  255, 0, 0, 1, 2, 20, 0, 0, 0, 160, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, 0, 115, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 84, 251,
  255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115,
  46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87,
  58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0,
  0, 0, 144, 251, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 123, 34, 102,
  114, 101, 113, 34, 58, 32, 34, 115, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82,
  82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109, 101,
  116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 132, 251, 255, 255, 0, 0, 0, 1, 64, 0,
  0, 0, 90, 252, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 160, 0, 0, 0, 8, 0, 0, 0,
  16, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 109, 115, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0,
  4, 0, 0, 0, 12, 252, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97,
  110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0,
  65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110,
  97, 109, 101, 0, 0, 0, 0, 72, 252, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 14, 0,
  0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 109, 115, 34, 125, 0, 0,
  24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111,
  110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 60, 252, 255, 255,
  0, 0, 0, 1, 64, 0, 0, 0, 18, 253, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 160, 0,
  0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 109, 105, 110, 0, 2,
  0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 196, 252, 255, 255, 28, 0, 0, 0, 4, 0, 0,
  0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105, 111, 100,
  0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115,
  105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 0, 253, 255, 255, 28, 0, 0,
  0, 4, 0, 0, 0, 15, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 109,
  105, 110, 34, 125, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116,
  101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0,
  0, 0, 244, 252, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 202, 253, 255, 255, 0, 0,
  1, 2, 20, 0, 0, 0, 160, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 0,
  0, 0, 104, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 124, 253, 255, 255,
  28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112,
  101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101,
  120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0,
  184, 253, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 123, 34, 102, 114,
  101, 113, 34, 58, 32, 34, 104, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79,
  87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97,
  100, 97, 116, 97, 0, 0, 0, 0, 172, 253, 255, 255, 0, 0, 0, 1, 64, 0, 0, 0,
  130, 254, 255, 255, 0, 0, 1, 2, 20, 0, 0, 0, 164, 0, 0, 0, 8, 0, 0, 0, 16, 0,
  0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 89, 0, 0, 0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0,
  0, 52, 254, 255, 255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110,
  100, 97, 115, 46, 112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82,
  82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97,
  109, 101, 0, 0, 0, 0, 112, 254, 255, 255, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0,
  0, 123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 89, 45, 68, 69, 67, 34, 125,
  0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115,
  105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 104, 254,
  255, 255, 0, 0, 0, 1, 64, 0, 0, 0, 62, 255, 255, 255, 0, 0, 1, 2, 20, 0, 0,
  0, 168, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 77, 0, 0,
  0, 2, 0, 0, 0, 68, 0, 0, 0, 4, 0, 0, 0, 240, 254, 255, 255, 28, 0, 0, 0, 4,
  0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46, 112, 101, 114, 105,
  111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101,
  110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0, 0, 44, 255, 255,
  255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 123, 34, 102, 114, 101, 113, 34,
  58, 32, 34, 77, 34, 125, 0, 0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101,
  120, 116, 101, 110, 115, 105, 111, 110, 58, 109, 101, 116, 97, 100, 97, 116,
  97, 0, 0, 0, 0, 8, 0, 14, 0, 8, 0, 7, 0, 8, 0, 0, 0, 0, 0, 0, 1, 64, 0, 0, 0,
  0, 0, 18, 0, 24, 0, 8, 0, 6, 0, 7, 0, 12, 0, 0, 0, 16, 0, 20, 0, 18, 0, 0, 0,
  0, 0, 1, 2, 20, 0, 0, 0, 180, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 65, 0, 0, 0, 2, 0, 0, 0, 76, 0, 0, 0, 4, 0, 0, 0, 196, 255, 255,
  255, 28, 0, 0, 0, 4, 0, 0, 0, 13, 0, 0, 0, 112, 97, 110, 100, 97, 115, 46,
  112, 101, 114, 105, 111, 100, 0, 0, 0, 20, 0, 0, 0, 65, 82, 82, 79, 87, 58,
  101, 120, 116, 101, 110, 115, 105, 111, 110, 58, 110, 97, 109, 101, 0, 0, 0,
  0, 8, 0, 12, 0, 4, 0, 8, 0, 8, 0, 0, 0, 32, 0, 0, 0, 4, 0, 0, 0, 17, 0, 0, 0,
  123, 34, 102, 114, 101, 113, 34, 58, 32, 34, 89, 45, 68, 69, 67, 34, 125, 0,
  0, 0, 24, 0, 0, 0, 65, 82, 82, 79, 87, 58, 101, 120, 116, 101, 110, 115, 105,
  111, 110, 58, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 8, 0, 12, 0,
  8, 0, 7, 0, 8, 0, 0, 0, 0, 0, 0, 1, 64, 0, 0, 0, 255, 255, 255, 255, 136, 6,
  0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 12, 0, 22, 0, 6, 0, 5, 0, 8, 0, 12, 0, 12, 0,
  0, 0, 0, 3, 4, 0, 24, 0, 0, 0, 16, 2, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 24, 0,
  12, 0, 4, 0, 8, 0, 10, 0, 0, 0, 60, 4, 0, 0, 16, 0, 0, 0, 2, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 32,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 16, 0,
  0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0,
  0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0,
  0, 0, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 0, 0, 0, 0, 0, 0,
  0, 16, 0, 0, 0, 0, 0, 0, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  112, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 0, 0, 0, 0, 0, 0, 0,
  16, 0, 0, 0, 0, 0, 0, 0, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  160, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 176, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 176, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0,
  16, 0, 0, 0, 0, 0, 0, 0, 208, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  208, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 224, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 224, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240, 0, 0, 0, 0, 0, 0, 0,
  16, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 16, 1, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 16, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 32, 1, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0,
  0, 0, 0, 0, 48, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 1, 0, 0, 0,
  0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 64, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 64, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 80, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  96, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 1, 0, 0, 0, 0, 0, 0, 16,
  0, 0, 0, 0, 0, 0, 0, 112, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112,
  1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 128, 1, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 128, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 144, 1,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0,
  0, 0, 0, 0, 0, 160, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 1, 0,
  0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 176, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 176, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 192, 1, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0,
  0, 0, 0, 208, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 1, 0, 0, 0,
  0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 224, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 224, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 240, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240, 1, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0,
  0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
  16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 1, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64,
  162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 82, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 160, 40, 121, 53, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  164, 57, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 40, 121, 53, 1, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 57, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 7, 82, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 162, 5, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  151, 8, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 151, 8, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 151, 8, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
  150, 8, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 150, 8, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 150, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  150, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 8, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  172, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 171, 0, 0, 0, 0, 0, 0, 0,
  3, 0, 0, 0, 0, 0, 0, 0, 171, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
  171, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 170, 0, 0, 0, 0, 0, 0, 0,
  2, 0, 0, 0, 0, 0, 0, 0, 170, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
  170, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 169, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 169, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
  169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  255, 255, 255, 255, 0, 0, 0, 0,
])
