/**
 * Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export const colors = {
  transparent: "transparent",
  black: "#000000",
  white: "#ffffff",

  gray10: "#fafafa",
  gray20: "#f0f2f6",
  gray30: "#e6eaf1",
  gray40: "#d5dae5",
  gray50: "#bfc5d3",
  gray60: "#a3a8b8",
  gray70: "#808495",
  gray80: "#555867",
  gray85: "#31333F",
  gray90: "#262730",
  gray100: "#0e1117",

  red10: "#fff0f0",
  red20: "#ffdede",
  red30: "#ffc7c7",
  red40: "#ffabab",
  red50: "#ff8c8c",
  red60: "#ff6c6c",
  red70: "#ff4b4b",
  red80: "#ff2b2b",
  red90: "#bd4043",
  red100: "#7d353b",

  orange10: "#fffae8",
  orange20: "#fff6d0",
  orange30: "#ffecb0",
  orange40: "#ffe08e",
  orange50: "#ffd16a",
  orange60: "#ffbd45",
  orange70: "#ffa421",
  orange80: "#ff8700",
  orange90: "#ed6f13",
  orange95: "#e2660c",
  orange100: "#d95a00",

  yellow10: "#ffffe1",
  yellow20: "#ffffc2",
  yellow30: "#ffffa0",
  yellow40: "#ffff7d",
  yellow50: "#ffff59",
  yellow60: "#fff835",
  yellow65: "#ffff12",
  yellow70: "#ffe312",
  yellow80: "#faca2b",
  yellow90: "#edbb16",
  yellow100: "#dea816",
  yellow110: "#916e10",
  yellow115: "#926c05",

  green10: "#dffde9",
  green20: "#c0fcd3",
  green30: "#9ef6bb",
  green40: "#7defa1",
  green50: "#5ce488",
  green60: "#3dd56d",
  green70: "#21c354",
  green80: "#09ab3b",
  green90: "#158237",
  green100: "#177233",

  blueGreen10: "#dcfffb",
  blueGreen20: "#bafff7",
  blueGreen30: "#93ffee",
  blueGreen40: "#6bfde3",
  blueGreen50: "#45f4d5",
  blueGreen60: "#20e7c5",
  blueGreen70: "#00d4b1",
  blueGreen80: "#29b09d",
  blueGreen90: "#2c867c",
  blueGreen100: "#246e69",

  lightBlue10: "#e0feff",
  lightBlue20: "#bffdff",
  lightBlue30: "#9af8ff",
  lightBlue40: "#73efff",
  lightBlue50: "#4be4ff",
  lightBlue60: "#24d4ff",
  lightBlue70: "#00c0f2",
  lightBlue80: "#00a4d4",
  lightBlue90: "#0d8cb5",
  lightBlue100: "#15799e",

  blue10: "#e4f5ff",
  blue20: "#c7ebff",
  blue30: "#a6dcff",
  blue40: "#83c9ff",
  blue50: "#60b4ff",
  blue60: "#3d9df3",
  blue65: "#1c83ff",
  blue70: "#1c83e1",
  blue80: "#0068c9",
  blue90: "#0054a3",
  blue100: "#004280",

  purple10: "#f5ebff",
  purple20: "#ebd6ff",
  purple30: "#dbbbff",
  purple40: "#c89dff",
  purple50: "#b27eff",
  purple60: "#9a5dff",
  purple70: "#803df5",
  purple80: "#6d3fc0",
  purple90: "#583f84",
  purple100: "#3f3163",
}

export type PrimitiveColors = Record<keyof typeof colors, string>
